// Copyright © 2020 The CefSharp Authors. All rights reserved.
//
// Use of this source code is governed by a BSD-style license that can be found in the LICENSE file.
//
// **This code was generated by a tool, do not change directly**
// CHROMIUM VERSION 129.0.6668.90
using System.Runtime.Serialization;

namespace CefSharp.DevTools.Accessibility
{
    /// <summary>
    /// Enum of possible property types.
    /// </summary>
    public enum AXValueType
    {
        /// <summary>
        /// boolean
        /// </summary>
        [EnumMember(Value = ("boolean"))]
        Boolean,
        /// <summary>
        /// tristate
        /// </summary>
        [EnumMember(Value = ("tristate"))]
        Tristate,
        /// <summary>
        /// booleanOrUndefined
        /// </summary>
        [EnumMember(Value = ("booleanOrUndefined"))]
        BooleanOrUndefined,
        /// <summary>
        /// idref
        /// </summary>
        [EnumMember(Value = ("idref"))]
        Idref,
        /// <summary>
        /// idrefList
        /// </summary>
        [EnumMember(Value = ("idrefList"))]
        IdrefList,
        /// <summary>
        /// integer
        /// </summary>
        [EnumMember(Value = ("integer"))]
        Integer,
        /// <summary>
        /// node
        /// </summary>
        [EnumMember(Value = ("node"))]
        Node,
        /// <summary>
        /// nodeList
        /// </summary>
        [EnumMember(Value = ("nodeList"))]
        NodeList,
        /// <summary>
        /// number
        /// </summary>
        [EnumMember(Value = ("number"))]
        Number,
        /// <summary>
        /// string
        /// </summary>
        [EnumMember(Value = ("string"))]
        String,
        /// <summary>
        /// computedString
        /// </summary>
        [EnumMember(Value = ("computedString"))]
        ComputedString,
        /// <summary>
        /// token
        /// </summary>
        [EnumMember(Value = ("token"))]
        Token,
        /// <summary>
        /// tokenList
        /// </summary>
        [EnumMember(Value = ("tokenList"))]
        TokenList,
        /// <summary>
        /// domRelation
        /// </summary>
        [EnumMember(Value = ("domRelation"))]
        DomRelation,
        /// <summary>
        /// role
        /// </summary>
        [EnumMember(Value = ("role"))]
        Role,
        /// <summary>
        /// internalRole
        /// </summary>
        [EnumMember(Value = ("internalRole"))]
        InternalRole,
        /// <summary>
        /// valueUndefined
        /// </summary>
        [EnumMember(Value = ("valueUndefined"))]
        ValueUndefined
    }

    /// <summary>
    /// Enum of possible property sources.
    /// </summary>
    public enum AXValueSourceType
    {
        /// <summary>
        /// attribute
        /// </summary>
        [EnumMember(Value = ("attribute"))]
        Attribute,
        /// <summary>
        /// implicit
        /// </summary>
        [EnumMember(Value = ("implicit"))]
        Implicit,
        /// <summary>
        /// style
        /// </summary>
        [EnumMember(Value = ("style"))]
        Style,
        /// <summary>
        /// contents
        /// </summary>
        [EnumMember(Value = ("contents"))]
        Contents,
        /// <summary>
        /// placeholder
        /// </summary>
        [EnumMember(Value = ("placeholder"))]
        Placeholder,
        /// <summary>
        /// relatedElement
        /// </summary>
        [EnumMember(Value = ("relatedElement"))]
        RelatedElement
    }

    /// <summary>
    /// Enum of possible native property sources (as a subtype of a particular AXValueSourceType).
    /// </summary>
    public enum AXValueNativeSourceType
    {
        /// <summary>
        /// description
        /// </summary>
        [EnumMember(Value = ("description"))]
        Description,
        /// <summary>
        /// figcaption
        /// </summary>
        [EnumMember(Value = ("figcaption"))]
        Figcaption,
        /// <summary>
        /// label
        /// </summary>
        [EnumMember(Value = ("label"))]
        Label,
        /// <summary>
        /// labelfor
        /// </summary>
        [EnumMember(Value = ("labelfor"))]
        Labelfor,
        /// <summary>
        /// labelwrapped
        /// </summary>
        [EnumMember(Value = ("labelwrapped"))]
        Labelwrapped,
        /// <summary>
        /// legend
        /// </summary>
        [EnumMember(Value = ("legend"))]
        Legend,
        /// <summary>
        /// rubyannotation
        /// </summary>
        [EnumMember(Value = ("rubyannotation"))]
        Rubyannotation,
        /// <summary>
        /// tablecaption
        /// </summary>
        [EnumMember(Value = ("tablecaption"))]
        Tablecaption,
        /// <summary>
        /// title
        /// </summary>
        [EnumMember(Value = ("title"))]
        Title,
        /// <summary>
        /// other
        /// </summary>
        [EnumMember(Value = ("other"))]
        Other
    }

    /// <summary>
    /// A single source for a computed AX property.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class AXValueSource : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// What type of source this is.
        /// </summary>
        public CefSharp.DevTools.Accessibility.AXValueSourceType Type
        {
            get
            {
                return (CefSharp.DevTools.Accessibility.AXValueSourceType)(StringToEnum(typeof(CefSharp.DevTools.Accessibility.AXValueSourceType), type));
            }

            set
            {
                this.type = (EnumToString(value));
            }
        }

        /// <summary>
        /// What type of source this is.
        /// </summary>
        [DataMember(Name = ("type"), IsRequired = (true))]
        internal string type
        {
            get;
            set;
        }

        /// <summary>
        /// The value of this property source.
        /// </summary>
        [DataMember(Name = ("value"), IsRequired = (false))]
        public CefSharp.DevTools.Accessibility.AXValue Value
        {
            get;
            set;
        }

        /// <summary>
        /// The name of the relevant attribute, if any.
        /// </summary>
        [DataMember(Name = ("attribute"), IsRequired = (false))]
        public string Attribute
        {
            get;
            set;
        }

        /// <summary>
        /// The value of the relevant attribute, if any.
        /// </summary>
        [DataMember(Name = ("attributeValue"), IsRequired = (false))]
        public CefSharp.DevTools.Accessibility.AXValue AttributeValue
        {
            get;
            set;
        }

        /// <summary>
        /// Whether this source is superseded by a higher priority source.
        /// </summary>
        [DataMember(Name = ("superseded"), IsRequired = (false))]
        public bool? Superseded
        {
            get;
            set;
        }

        /// <summary>
        /// The native markup source for this value, e.g. a `&lt;label&gt;` element.
        /// </summary>
        public CefSharp.DevTools.Accessibility.AXValueNativeSourceType? NativeSource
        {
            get
            {
                return (CefSharp.DevTools.Accessibility.AXValueNativeSourceType? )(StringToEnum(typeof(CefSharp.DevTools.Accessibility.AXValueNativeSourceType? ), nativeSource));
            }

            set
            {
                this.nativeSource = (EnumToString(value));
            }
        }

        /// <summary>
        /// The native markup source for this value, e.g. a `&lt;label&gt;` element.
        /// </summary>
        [DataMember(Name = ("nativeSource"), IsRequired = (false))]
        internal string nativeSource
        {
            get;
            set;
        }

        /// <summary>
        /// The value, such as a node or node list, of the native source.
        /// </summary>
        [DataMember(Name = ("nativeSourceValue"), IsRequired = (false))]
        public CefSharp.DevTools.Accessibility.AXValue NativeSourceValue
        {
            get;
            set;
        }

        /// <summary>
        /// Whether the value for this property is invalid.
        /// </summary>
        [DataMember(Name = ("invalid"), IsRequired = (false))]
        public bool? Invalid
        {
            get;
            set;
        }

        /// <summary>
        /// Reason for the value being invalid, if it is.
        /// </summary>
        [DataMember(Name = ("invalidReason"), IsRequired = (false))]
        public string InvalidReason
        {
            get;
            set;
        }
    }

    /// <summary>
    /// AXRelatedNode
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class AXRelatedNode : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The BackendNodeId of the related DOM node.
        /// </summary>
        [DataMember(Name = ("backendDOMNodeId"), IsRequired = (true))]
        public int BackendDOMNodeId
        {
            get;
            set;
        }

        /// <summary>
        /// The IDRef value provided, if any.
        /// </summary>
        [DataMember(Name = ("idref"), IsRequired = (false))]
        public string Idref
        {
            get;
            set;
        }

        /// <summary>
        /// The text alternative of this node in the current context.
        /// </summary>
        [DataMember(Name = ("text"), IsRequired = (false))]
        public string Text
        {
            get;
            set;
        }
    }

    /// <summary>
    /// AXProperty
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class AXProperty : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The name of this property.
        /// </summary>
        public CefSharp.DevTools.Accessibility.AXPropertyName Name
        {
            get
            {
                return (CefSharp.DevTools.Accessibility.AXPropertyName)(StringToEnum(typeof(CefSharp.DevTools.Accessibility.AXPropertyName), name));
            }

            set
            {
                this.name = (EnumToString(value));
            }
        }

        /// <summary>
        /// The name of this property.
        /// </summary>
        [DataMember(Name = ("name"), IsRequired = (true))]
        internal string name
        {
            get;
            set;
        }

        /// <summary>
        /// The value of this property.
        /// </summary>
        [DataMember(Name = ("value"), IsRequired = (true))]
        public CefSharp.DevTools.Accessibility.AXValue Value
        {
            get;
            set;
        }
    }

    /// <summary>
    /// A single computed AX property.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class AXValue : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The type of this value.
        /// </summary>
        public CefSharp.DevTools.Accessibility.AXValueType Type
        {
            get
            {
                return (CefSharp.DevTools.Accessibility.AXValueType)(StringToEnum(typeof(CefSharp.DevTools.Accessibility.AXValueType), type));
            }

            set
            {
                this.type = (EnumToString(value));
            }
        }

        /// <summary>
        /// The type of this value.
        /// </summary>
        [DataMember(Name = ("type"), IsRequired = (true))]
        internal string type
        {
            get;
            set;
        }

        /// <summary>
        /// The computed value of this property.
        /// </summary>
        [DataMember(Name = ("value"), IsRequired = (false))]
        public object Value
        {
            get;
            set;
        }

        /// <summary>
        /// One or more related nodes, if applicable.
        /// </summary>
        [DataMember(Name = ("relatedNodes"), IsRequired = (false))]
        public System.Collections.Generic.IList<CefSharp.DevTools.Accessibility.AXRelatedNode> RelatedNodes
        {
            get;
            set;
        }

        /// <summary>
        /// The sources which contributed to the computation of this property.
        /// </summary>
        [DataMember(Name = ("sources"), IsRequired = (false))]
        public System.Collections.Generic.IList<CefSharp.DevTools.Accessibility.AXValueSource> Sources
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Values of AXProperty name:
    /// - from &apos;busy&apos; to &apos;roledescription&apos;: states which apply to every AX node
    /// - from &apos;live&apos; to &apos;root&apos;: attributes which apply to nodes in live regions
    /// - from &apos;autocomplete&apos; to &apos;valuetext&apos;: attributes which apply to widgets
    /// - from &apos;checked&apos; to &apos;selected&apos;: states which apply to widgets
    /// - from &apos;activedescendant&apos; to &apos;owns&apos; - relationships between elements other than parent/child/sibling.
    /// </summary>
    public enum AXPropertyName
    {
        /// <summary>
        /// busy
        /// </summary>
        [EnumMember(Value = ("busy"))]
        Busy,
        /// <summary>
        /// disabled
        /// </summary>
        [EnumMember(Value = ("disabled"))]
        Disabled,
        /// <summary>
        /// editable
        /// </summary>
        [EnumMember(Value = ("editable"))]
        Editable,
        /// <summary>
        /// focusable
        /// </summary>
        [EnumMember(Value = ("focusable"))]
        Focusable,
        /// <summary>
        /// focused
        /// </summary>
        [EnumMember(Value = ("focused"))]
        Focused,
        /// <summary>
        /// hidden
        /// </summary>
        [EnumMember(Value = ("hidden"))]
        Hidden,
        /// <summary>
        /// hiddenRoot
        /// </summary>
        [EnumMember(Value = ("hiddenRoot"))]
        HiddenRoot,
        /// <summary>
        /// invalid
        /// </summary>
        [EnumMember(Value = ("invalid"))]
        Invalid,
        /// <summary>
        /// keyshortcuts
        /// </summary>
        [EnumMember(Value = ("keyshortcuts"))]
        Keyshortcuts,
        /// <summary>
        /// settable
        /// </summary>
        [EnumMember(Value = ("settable"))]
        Settable,
        /// <summary>
        /// roledescription
        /// </summary>
        [EnumMember(Value = ("roledescription"))]
        Roledescription,
        /// <summary>
        /// live
        /// </summary>
        [EnumMember(Value = ("live"))]
        Live,
        /// <summary>
        /// atomic
        /// </summary>
        [EnumMember(Value = ("atomic"))]
        Atomic,
        /// <summary>
        /// relevant
        /// </summary>
        [EnumMember(Value = ("relevant"))]
        Relevant,
        /// <summary>
        /// root
        /// </summary>
        [EnumMember(Value = ("root"))]
        Root,
        /// <summary>
        /// autocomplete
        /// </summary>
        [EnumMember(Value = ("autocomplete"))]
        Autocomplete,
        /// <summary>
        /// hasPopup
        /// </summary>
        [EnumMember(Value = ("hasPopup"))]
        HasPopup,
        /// <summary>
        /// level
        /// </summary>
        [EnumMember(Value = ("level"))]
        Level,
        /// <summary>
        /// multiselectable
        /// </summary>
        [EnumMember(Value = ("multiselectable"))]
        Multiselectable,
        /// <summary>
        /// orientation
        /// </summary>
        [EnumMember(Value = ("orientation"))]
        Orientation,
        /// <summary>
        /// multiline
        /// </summary>
        [EnumMember(Value = ("multiline"))]
        Multiline,
        /// <summary>
        /// readonly
        /// </summary>
        [EnumMember(Value = ("readonly"))]
        Readonly,
        /// <summary>
        /// required
        /// </summary>
        [EnumMember(Value = ("required"))]
        Required,
        /// <summary>
        /// valuemin
        /// </summary>
        [EnumMember(Value = ("valuemin"))]
        Valuemin,
        /// <summary>
        /// valuemax
        /// </summary>
        [EnumMember(Value = ("valuemax"))]
        Valuemax,
        /// <summary>
        /// valuetext
        /// </summary>
        [EnumMember(Value = ("valuetext"))]
        Valuetext,
        /// <summary>
        /// checked
        /// </summary>
        [EnumMember(Value = ("checked"))]
        Checked,
        /// <summary>
        /// expanded
        /// </summary>
        [EnumMember(Value = ("expanded"))]
        Expanded,
        /// <summary>
        /// modal
        /// </summary>
        [EnumMember(Value = ("modal"))]
        Modal,
        /// <summary>
        /// pressed
        /// </summary>
        [EnumMember(Value = ("pressed"))]
        Pressed,
        /// <summary>
        /// selected
        /// </summary>
        [EnumMember(Value = ("selected"))]
        Selected,
        /// <summary>
        /// activedescendant
        /// </summary>
        [EnumMember(Value = ("activedescendant"))]
        Activedescendant,
        /// <summary>
        /// controls
        /// </summary>
        [EnumMember(Value = ("controls"))]
        Controls,
        /// <summary>
        /// describedby
        /// </summary>
        [EnumMember(Value = ("describedby"))]
        Describedby,
        /// <summary>
        /// details
        /// </summary>
        [EnumMember(Value = ("details"))]
        Details,
        /// <summary>
        /// errormessage
        /// </summary>
        [EnumMember(Value = ("errormessage"))]
        Errormessage,
        /// <summary>
        /// flowto
        /// </summary>
        [EnumMember(Value = ("flowto"))]
        Flowto,
        /// <summary>
        /// labelledby
        /// </summary>
        [EnumMember(Value = ("labelledby"))]
        Labelledby,
        /// <summary>
        /// owns
        /// </summary>
        [EnumMember(Value = ("owns"))]
        Owns,
        /// <summary>
        /// url
        /// </summary>
        [EnumMember(Value = ("url"))]
        Url
    }

    /// <summary>
    /// A node in the accessibility tree.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class AXNode : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Unique identifier for this node.
        /// </summary>
        [DataMember(Name = ("nodeId"), IsRequired = (true))]
        public string NodeId
        {
            get;
            set;
        }

        /// <summary>
        /// Whether this node is ignored for accessibility
        /// </summary>
        [DataMember(Name = ("ignored"), IsRequired = (true))]
        public bool Ignored
        {
            get;
            set;
        }

        /// <summary>
        /// Collection of reasons why this node is hidden.
        /// </summary>
        [DataMember(Name = ("ignoredReasons"), IsRequired = (false))]
        public System.Collections.Generic.IList<CefSharp.DevTools.Accessibility.AXProperty> IgnoredReasons
        {
            get;
            set;
        }

        /// <summary>
        /// This `Node`&apos;s role, whether explicit or implicit.
        /// </summary>
        [DataMember(Name = ("role"), IsRequired = (false))]
        public CefSharp.DevTools.Accessibility.AXValue Role
        {
            get;
            set;
        }

        /// <summary>
        /// This `Node`&apos;s Chrome raw role.
        /// </summary>
        [DataMember(Name = ("chromeRole"), IsRequired = (false))]
        public CefSharp.DevTools.Accessibility.AXValue ChromeRole
        {
            get;
            set;
        }

        /// <summary>
        /// The accessible name for this `Node`.
        /// </summary>
        [DataMember(Name = ("name"), IsRequired = (false))]
        public CefSharp.DevTools.Accessibility.AXValue Name
        {
            get;
            set;
        }

        /// <summary>
        /// The accessible description for this `Node`.
        /// </summary>
        [DataMember(Name = ("description"), IsRequired = (false))]
        public CefSharp.DevTools.Accessibility.AXValue Description
        {
            get;
            set;
        }

        /// <summary>
        /// The value for this `Node`.
        /// </summary>
        [DataMember(Name = ("value"), IsRequired = (false))]
        public CefSharp.DevTools.Accessibility.AXValue Value
        {
            get;
            set;
        }

        /// <summary>
        /// All other properties
        /// </summary>
        [DataMember(Name = ("properties"), IsRequired = (false))]
        public System.Collections.Generic.IList<CefSharp.DevTools.Accessibility.AXProperty> Properties
        {
            get;
            set;
        }

        /// <summary>
        /// ID for this node&apos;s parent.
        /// </summary>
        [DataMember(Name = ("parentId"), IsRequired = (false))]
        public string ParentId
        {
            get;
            set;
        }

        /// <summary>
        /// IDs for each of this node&apos;s child nodes.
        /// </summary>
        [DataMember(Name = ("childIds"), IsRequired = (false))]
        public string[] ChildIds
        {
            get;
            set;
        }

        /// <summary>
        /// The backend ID for the associated DOM node, if any.
        /// </summary>
        [DataMember(Name = ("backendDOMNodeId"), IsRequired = (false))]
        public int? BackendDOMNodeId
        {
            get;
            set;
        }

        /// <summary>
        /// The frame ID for the frame associated with this nodes document.
        /// </summary>
        [DataMember(Name = ("frameId"), IsRequired = (false))]
        public string FrameId
        {
            get;
            set;
        }
    }

    /// <summary>
    /// The loadComplete event mirrors the load complete event sent by the browser to assistive
    /// technology when the web page has finished loading.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class LoadCompleteEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// New document root node.
        /// </summary>
        [DataMember(Name = ("root"), IsRequired = (true))]
        public CefSharp.DevTools.Accessibility.AXNode Root
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// The nodesUpdated event is sent every time a previously requested node has changed the in tree.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class NodesUpdatedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Updated node data.
        /// </summary>
        [DataMember(Name = ("nodes"), IsRequired = (true))]
        public System.Collections.Generic.IList<CefSharp.DevTools.Accessibility.AXNode> Nodes
        {
            get;
            private set;
        }
    }
}

namespace CefSharp.DevTools.Animation
{
    /// <summary>
    /// Animation type of `Animation`.
    /// </summary>
    public enum AnimationType
    {
        /// <summary>
        /// CSSTransition
        /// </summary>
        [EnumMember(Value = ("CSSTransition"))]
        CSSTransition,
        /// <summary>
        /// CSSAnimation
        /// </summary>
        [EnumMember(Value = ("CSSAnimation"))]
        CSSAnimation,
        /// <summary>
        /// WebAnimation
        /// </summary>
        [EnumMember(Value = ("WebAnimation"))]
        WebAnimation
    }

    /// <summary>
    /// Animation instance.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class Animation : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// `Animation`&apos;s id.
        /// </summary>
        [DataMember(Name = ("id"), IsRequired = (true))]
        public string Id
        {
            get;
            set;
        }

        /// <summary>
        /// `Animation`&apos;s name.
        /// </summary>
        [DataMember(Name = ("name"), IsRequired = (true))]
        public string Name
        {
            get;
            set;
        }

        /// <summary>
        /// `Animation`&apos;s internal paused state.
        /// </summary>
        [DataMember(Name = ("pausedState"), IsRequired = (true))]
        public bool PausedState
        {
            get;
            set;
        }

        /// <summary>
        /// `Animation`&apos;s play state.
        /// </summary>
        [DataMember(Name = ("playState"), IsRequired = (true))]
        public string PlayState
        {
            get;
            set;
        }

        /// <summary>
        /// `Animation`&apos;s playback rate.
        /// </summary>
        [DataMember(Name = ("playbackRate"), IsRequired = (true))]
        public double PlaybackRate
        {
            get;
            set;
        }

        /// <summary>
        /// `Animation`&apos;s start time.
        /// Milliseconds for time based animations and
        /// percentage [0 - 100] for scroll driven animations
        /// (i.e. when viewOrScrollTimeline exists).
        /// </summary>
        [DataMember(Name = ("startTime"), IsRequired = (true))]
        public double StartTime
        {
            get;
            set;
        }

        /// <summary>
        /// `Animation`&apos;s current time.
        /// </summary>
        [DataMember(Name = ("currentTime"), IsRequired = (true))]
        public double CurrentTime
        {
            get;
            set;
        }

        /// <summary>
        /// Animation type of `Animation`.
        /// </summary>
        public CefSharp.DevTools.Animation.AnimationType Type
        {
            get
            {
                return (CefSharp.DevTools.Animation.AnimationType)(StringToEnum(typeof(CefSharp.DevTools.Animation.AnimationType), type));
            }

            set
            {
                this.type = (EnumToString(value));
            }
        }

        /// <summary>
        /// Animation type of `Animation`.
        /// </summary>
        [DataMember(Name = ("type"), IsRequired = (true))]
        internal string type
        {
            get;
            set;
        }

        /// <summary>
        /// `Animation`&apos;s source animation node.
        /// </summary>
        [DataMember(Name = ("source"), IsRequired = (false))]
        public CefSharp.DevTools.Animation.AnimationEffect Source
        {
            get;
            set;
        }

        /// <summary>
        /// A unique ID for `Animation` representing the sources that triggered this CSS
        /// animation/transition.
        /// </summary>
        [DataMember(Name = ("cssId"), IsRequired = (false))]
        public string CssId
        {
            get;
            set;
        }

        /// <summary>
        /// View or scroll timeline
        /// </summary>
        [DataMember(Name = ("viewOrScrollTimeline"), IsRequired = (false))]
        public CefSharp.DevTools.Animation.ViewOrScrollTimeline ViewOrScrollTimeline
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Timeline instance
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class ViewOrScrollTimeline : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Scroll container node
        /// </summary>
        [DataMember(Name = ("sourceNodeId"), IsRequired = (false))]
        public int? SourceNodeId
        {
            get;
            set;
        }

        /// <summary>
        /// Represents the starting scroll position of the timeline
        /// as a length offset in pixels from scroll origin.
        /// </summary>
        [DataMember(Name = ("startOffset"), IsRequired = (false))]
        public double? StartOffset
        {
            get;
            set;
        }

        /// <summary>
        /// Represents the ending scroll position of the timeline
        /// as a length offset in pixels from scroll origin.
        /// </summary>
        [DataMember(Name = ("endOffset"), IsRequired = (false))]
        public double? EndOffset
        {
            get;
            set;
        }

        /// <summary>
        /// The element whose principal box&apos;s visibility in the
        /// scrollport defined the progress of the timeline.
        /// Does not exist for animations with ScrollTimeline
        /// </summary>
        [DataMember(Name = ("subjectNodeId"), IsRequired = (false))]
        public int? SubjectNodeId
        {
            get;
            set;
        }

        /// <summary>
        /// Orientation of the scroll
        /// </summary>
        public CefSharp.DevTools.DOM.ScrollOrientation Axis
        {
            get
            {
                return (CefSharp.DevTools.DOM.ScrollOrientation)(StringToEnum(typeof(CefSharp.DevTools.DOM.ScrollOrientation), axis));
            }

            set
            {
                this.axis = (EnumToString(value));
            }
        }

        /// <summary>
        /// Orientation of the scroll
        /// </summary>
        [DataMember(Name = ("axis"), IsRequired = (true))]
        internal string axis
        {
            get;
            set;
        }
    }

    /// <summary>
    /// AnimationEffect instance
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class AnimationEffect : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// `AnimationEffect`&apos;s delay.
        /// </summary>
        [DataMember(Name = ("delay"), IsRequired = (true))]
        public double Delay
        {
            get;
            set;
        }

        /// <summary>
        /// `AnimationEffect`&apos;s end delay.
        /// </summary>
        [DataMember(Name = ("endDelay"), IsRequired = (true))]
        public double EndDelay
        {
            get;
            set;
        }

        /// <summary>
        /// `AnimationEffect`&apos;s iteration start.
        /// </summary>
        [DataMember(Name = ("iterationStart"), IsRequired = (true))]
        public double IterationStart
        {
            get;
            set;
        }

        /// <summary>
        /// `AnimationEffect`&apos;s iterations.
        /// </summary>
        [DataMember(Name = ("iterations"), IsRequired = (true))]
        public double Iterations
        {
            get;
            set;
        }

        /// <summary>
        /// `AnimationEffect`&apos;s iteration duration.
        /// Milliseconds for time based animations and
        /// percentage [0 - 100] for scroll driven animations
        /// (i.e. when viewOrScrollTimeline exists).
        /// </summary>
        [DataMember(Name = ("duration"), IsRequired = (true))]
        public double Duration
        {
            get;
            set;
        }

        /// <summary>
        /// `AnimationEffect`&apos;s playback direction.
        /// </summary>
        [DataMember(Name = ("direction"), IsRequired = (true))]
        public string Direction
        {
            get;
            set;
        }

        /// <summary>
        /// `AnimationEffect`&apos;s fill mode.
        /// </summary>
        [DataMember(Name = ("fill"), IsRequired = (true))]
        public string Fill
        {
            get;
            set;
        }

        /// <summary>
        /// `AnimationEffect`&apos;s target node.
        /// </summary>
        [DataMember(Name = ("backendNodeId"), IsRequired = (false))]
        public int? BackendNodeId
        {
            get;
            set;
        }

        /// <summary>
        /// `AnimationEffect`&apos;s keyframes.
        /// </summary>
        [DataMember(Name = ("keyframesRule"), IsRequired = (false))]
        public CefSharp.DevTools.Animation.KeyframesRule KeyframesRule
        {
            get;
            set;
        }

        /// <summary>
        /// `AnimationEffect`&apos;s timing function.
        /// </summary>
        [DataMember(Name = ("easing"), IsRequired = (true))]
        public string Easing
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Keyframes Rule
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class KeyframesRule : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// CSS keyframed animation&apos;s name.
        /// </summary>
        [DataMember(Name = ("name"), IsRequired = (false))]
        public string Name
        {
            get;
            set;
        }

        /// <summary>
        /// List of animation keyframes.
        /// </summary>
        [DataMember(Name = ("keyframes"), IsRequired = (true))]
        public System.Collections.Generic.IList<CefSharp.DevTools.Animation.KeyframeStyle> Keyframes
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Keyframe Style
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class KeyframeStyle : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Keyframe&apos;s time offset.
        /// </summary>
        [DataMember(Name = ("offset"), IsRequired = (true))]
        public string Offset
        {
            get;
            set;
        }

        /// <summary>
        /// `AnimationEffect`&apos;s timing function.
        /// </summary>
        [DataMember(Name = ("easing"), IsRequired = (true))]
        public string Easing
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Event for when an animation has been cancelled.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class AnimationCanceledEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Id of the animation that was cancelled.
        /// </summary>
        [DataMember(Name = ("id"), IsRequired = (true))]
        public string Id
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Event for each animation that has been created.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class AnimationCreatedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Id of the animation that was created.
        /// </summary>
        [DataMember(Name = ("id"), IsRequired = (true))]
        public string Id
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Event for animation that has been started.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class AnimationStartedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Animation that was started.
        /// </summary>
        [DataMember(Name = ("animation"), IsRequired = (true))]
        public CefSharp.DevTools.Animation.Animation Animation
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Event for animation that has been updated.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class AnimationUpdatedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Animation that was updated.
        /// </summary>
        [DataMember(Name = ("animation"), IsRequired = (true))]
        public CefSharp.DevTools.Animation.Animation Animation
        {
            get;
            private set;
        }
    }
}

namespace CefSharp.DevTools.Audits
{
    /// <summary>
    /// Information about a cookie that is affected by an inspector issue.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class AffectedCookie : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The following three properties uniquely identify a cookie
        /// </summary>
        [DataMember(Name = ("name"), IsRequired = (true))]
        public string Name
        {
            get;
            set;
        }

        /// <summary>
        /// Path
        /// </summary>
        [DataMember(Name = ("path"), IsRequired = (true))]
        public string Path
        {
            get;
            set;
        }

        /// <summary>
        /// Domain
        /// </summary>
        [DataMember(Name = ("domain"), IsRequired = (true))]
        public string Domain
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Information about a request that is affected by an inspector issue.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class AffectedRequest : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The unique request id.
        /// </summary>
        [DataMember(Name = ("requestId"), IsRequired = (true))]
        public string RequestId
        {
            get;
            set;
        }

        /// <summary>
        /// Url
        /// </summary>
        [DataMember(Name = ("url"), IsRequired = (false))]
        public string Url
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Information about the frame affected by an inspector issue.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class AffectedFrame : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// FrameId
        /// </summary>
        [DataMember(Name = ("frameId"), IsRequired = (true))]
        public string FrameId
        {
            get;
            set;
        }
    }

    /// <summary>
    /// CookieExclusionReason
    /// </summary>
    public enum CookieExclusionReason
    {
        /// <summary>
        /// ExcludeSameSiteUnspecifiedTreatedAsLax
        /// </summary>
        [EnumMember(Value = ("ExcludeSameSiteUnspecifiedTreatedAsLax"))]
        ExcludeSameSiteUnspecifiedTreatedAsLax,
        /// <summary>
        /// ExcludeSameSiteNoneInsecure
        /// </summary>
        [EnumMember(Value = ("ExcludeSameSiteNoneInsecure"))]
        ExcludeSameSiteNoneInsecure,
        /// <summary>
        /// ExcludeSameSiteLax
        /// </summary>
        [EnumMember(Value = ("ExcludeSameSiteLax"))]
        ExcludeSameSiteLax,
        /// <summary>
        /// ExcludeSameSiteStrict
        /// </summary>
        [EnumMember(Value = ("ExcludeSameSiteStrict"))]
        ExcludeSameSiteStrict,
        /// <summary>
        /// ExcludeInvalidSameParty
        /// </summary>
        [EnumMember(Value = ("ExcludeInvalidSameParty"))]
        ExcludeInvalidSameParty,
        /// <summary>
        /// ExcludeSamePartyCrossPartyContext
        /// </summary>
        [EnumMember(Value = ("ExcludeSamePartyCrossPartyContext"))]
        ExcludeSamePartyCrossPartyContext,
        /// <summary>
        /// ExcludeDomainNonASCII
        /// </summary>
        [EnumMember(Value = ("ExcludeDomainNonASCII"))]
        ExcludeDomainNonASCII,
        /// <summary>
        /// ExcludeThirdPartyCookieBlockedInFirstPartySet
        /// </summary>
        [EnumMember(Value = ("ExcludeThirdPartyCookieBlockedInFirstPartySet"))]
        ExcludeThirdPartyCookieBlockedInFirstPartySet,
        /// <summary>
        /// ExcludeThirdPartyPhaseout
        /// </summary>
        [EnumMember(Value = ("ExcludeThirdPartyPhaseout"))]
        ExcludeThirdPartyPhaseout
    }

    /// <summary>
    /// CookieWarningReason
    /// </summary>
    public enum CookieWarningReason
    {
        /// <summary>
        /// WarnSameSiteUnspecifiedCrossSiteContext
        /// </summary>
        [EnumMember(Value = ("WarnSameSiteUnspecifiedCrossSiteContext"))]
        WarnSameSiteUnspecifiedCrossSiteContext,
        /// <summary>
        /// WarnSameSiteNoneInsecure
        /// </summary>
        [EnumMember(Value = ("WarnSameSiteNoneInsecure"))]
        WarnSameSiteNoneInsecure,
        /// <summary>
        /// WarnSameSiteUnspecifiedLaxAllowUnsafe
        /// </summary>
        [EnumMember(Value = ("WarnSameSiteUnspecifiedLaxAllowUnsafe"))]
        WarnSameSiteUnspecifiedLaxAllowUnsafe,
        /// <summary>
        /// WarnSameSiteStrictLaxDowngradeStrict
        /// </summary>
        [EnumMember(Value = ("WarnSameSiteStrictLaxDowngradeStrict"))]
        WarnSameSiteStrictLaxDowngradeStrict,
        /// <summary>
        /// WarnSameSiteStrictCrossDowngradeStrict
        /// </summary>
        [EnumMember(Value = ("WarnSameSiteStrictCrossDowngradeStrict"))]
        WarnSameSiteStrictCrossDowngradeStrict,
        /// <summary>
        /// WarnSameSiteStrictCrossDowngradeLax
        /// </summary>
        [EnumMember(Value = ("WarnSameSiteStrictCrossDowngradeLax"))]
        WarnSameSiteStrictCrossDowngradeLax,
        /// <summary>
        /// WarnSameSiteLaxCrossDowngradeStrict
        /// </summary>
        [EnumMember(Value = ("WarnSameSiteLaxCrossDowngradeStrict"))]
        WarnSameSiteLaxCrossDowngradeStrict,
        /// <summary>
        /// WarnSameSiteLaxCrossDowngradeLax
        /// </summary>
        [EnumMember(Value = ("WarnSameSiteLaxCrossDowngradeLax"))]
        WarnSameSiteLaxCrossDowngradeLax,
        /// <summary>
        /// WarnAttributeValueExceedsMaxSize
        /// </summary>
        [EnumMember(Value = ("WarnAttributeValueExceedsMaxSize"))]
        WarnAttributeValueExceedsMaxSize,
        /// <summary>
        /// WarnDomainNonASCII
        /// </summary>
        [EnumMember(Value = ("WarnDomainNonASCII"))]
        WarnDomainNonASCII,
        /// <summary>
        /// WarnThirdPartyPhaseout
        /// </summary>
        [EnumMember(Value = ("WarnThirdPartyPhaseout"))]
        WarnThirdPartyPhaseout,
        /// <summary>
        /// WarnCrossSiteRedirectDowngradeChangesInclusion
        /// </summary>
        [EnumMember(Value = ("WarnCrossSiteRedirectDowngradeChangesInclusion"))]
        WarnCrossSiteRedirectDowngradeChangesInclusion
    }

    /// <summary>
    /// CookieOperation
    /// </summary>
    public enum CookieOperation
    {
        /// <summary>
        /// SetCookie
        /// </summary>
        [EnumMember(Value = ("SetCookie"))]
        SetCookie,
        /// <summary>
        /// ReadCookie
        /// </summary>
        [EnumMember(Value = ("ReadCookie"))]
        ReadCookie
    }

    /// <summary>
    /// This information is currently necessary, as the front-end has a difficult
    /// time finding a specific cookie. With this, we can convey specific error
    /// information without the cookie.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class CookieIssueDetails : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// If AffectedCookie is not set then rawCookieLine contains the raw
        /// Set-Cookie header string. This hints at a problem where the
        /// cookie line is syntactically or semantically malformed in a way
        /// that no valid cookie could be created.
        /// </summary>
        [DataMember(Name = ("cookie"), IsRequired = (false))]
        public CefSharp.DevTools.Audits.AffectedCookie Cookie
        {
            get;
            set;
        }

        /// <summary>
        /// RawCookieLine
        /// </summary>
        [DataMember(Name = ("rawCookieLine"), IsRequired = (false))]
        public string RawCookieLine
        {
            get;
            set;
        }

        /// <summary>
        /// CookieWarningReasons
        /// </summary>
        public CefSharp.DevTools.Audits.CookieWarningReason[] CookieWarningReasons
        {
            get
            {
                return (CefSharp.DevTools.Audits.CookieWarningReason[])(StringToEnum(typeof(CefSharp.DevTools.Audits.CookieWarningReason[]), cookieWarningReasons));
            }

            set
            {
                this.cookieWarningReasons = (EnumToString(value));
            }
        }

        /// <summary>
        /// CookieWarningReasons
        /// </summary>
        [DataMember(Name = ("cookieWarningReasons"), IsRequired = (true))]
        internal string cookieWarningReasons
        {
            get;
            set;
        }

        /// <summary>
        /// CookieExclusionReasons
        /// </summary>
        public CefSharp.DevTools.Audits.CookieExclusionReason[] CookieExclusionReasons
        {
            get
            {
                return (CefSharp.DevTools.Audits.CookieExclusionReason[])(StringToEnum(typeof(CefSharp.DevTools.Audits.CookieExclusionReason[]), cookieExclusionReasons));
            }

            set
            {
                this.cookieExclusionReasons = (EnumToString(value));
            }
        }

        /// <summary>
        /// CookieExclusionReasons
        /// </summary>
        [DataMember(Name = ("cookieExclusionReasons"), IsRequired = (true))]
        internal string cookieExclusionReasons
        {
            get;
            set;
        }

        /// <summary>
        /// Optionally identifies the site-for-cookies and the cookie url, which
        /// may be used by the front-end as additional context.
        /// </summary>
        public CefSharp.DevTools.Audits.CookieOperation Operation
        {
            get
            {
                return (CefSharp.DevTools.Audits.CookieOperation)(StringToEnum(typeof(CefSharp.DevTools.Audits.CookieOperation), operation));
            }

            set
            {
                this.operation = (EnumToString(value));
            }
        }

        /// <summary>
        /// Optionally identifies the site-for-cookies and the cookie url, which
        /// may be used by the front-end as additional context.
        /// </summary>
        [DataMember(Name = ("operation"), IsRequired = (true))]
        internal string operation
        {
            get;
            set;
        }

        /// <summary>
        /// SiteForCookies
        /// </summary>
        [DataMember(Name = ("siteForCookies"), IsRequired = (false))]
        public string SiteForCookies
        {
            get;
            set;
        }

        /// <summary>
        /// CookieUrl
        /// </summary>
        [DataMember(Name = ("cookieUrl"), IsRequired = (false))]
        public string CookieUrl
        {
            get;
            set;
        }

        /// <summary>
        /// Request
        /// </summary>
        [DataMember(Name = ("request"), IsRequired = (false))]
        public CefSharp.DevTools.Audits.AffectedRequest Request
        {
            get;
            set;
        }
    }

    /// <summary>
    /// MixedContentResolutionStatus
    /// </summary>
    public enum MixedContentResolutionStatus
    {
        /// <summary>
        /// MixedContentBlocked
        /// </summary>
        [EnumMember(Value = ("MixedContentBlocked"))]
        MixedContentBlocked,
        /// <summary>
        /// MixedContentAutomaticallyUpgraded
        /// </summary>
        [EnumMember(Value = ("MixedContentAutomaticallyUpgraded"))]
        MixedContentAutomaticallyUpgraded,
        /// <summary>
        /// MixedContentWarning
        /// </summary>
        [EnumMember(Value = ("MixedContentWarning"))]
        MixedContentWarning
    }

    /// <summary>
    /// MixedContentResourceType
    /// </summary>
    public enum MixedContentResourceType
    {
        /// <summary>
        /// AttributionSrc
        /// </summary>
        [EnumMember(Value = ("AttributionSrc"))]
        AttributionSrc,
        /// <summary>
        /// Audio
        /// </summary>
        [EnumMember(Value = ("Audio"))]
        Audio,
        /// <summary>
        /// Beacon
        /// </summary>
        [EnumMember(Value = ("Beacon"))]
        Beacon,
        /// <summary>
        /// CSPReport
        /// </summary>
        [EnumMember(Value = ("CSPReport"))]
        CSPReport,
        /// <summary>
        /// Download
        /// </summary>
        [EnumMember(Value = ("Download"))]
        Download,
        /// <summary>
        /// EventSource
        /// </summary>
        [EnumMember(Value = ("EventSource"))]
        EventSource,
        /// <summary>
        /// Favicon
        /// </summary>
        [EnumMember(Value = ("Favicon"))]
        Favicon,
        /// <summary>
        /// Font
        /// </summary>
        [EnumMember(Value = ("Font"))]
        Font,
        /// <summary>
        /// Form
        /// </summary>
        [EnumMember(Value = ("Form"))]
        Form,
        /// <summary>
        /// Frame
        /// </summary>
        [EnumMember(Value = ("Frame"))]
        Frame,
        /// <summary>
        /// Image
        /// </summary>
        [EnumMember(Value = ("Image"))]
        Image,
        /// <summary>
        /// Import
        /// </summary>
        [EnumMember(Value = ("Import"))]
        Import,
        /// <summary>
        /// JSON
        /// </summary>
        [EnumMember(Value = ("JSON"))]
        JSON,
        /// <summary>
        /// Manifest
        /// </summary>
        [EnumMember(Value = ("Manifest"))]
        Manifest,
        /// <summary>
        /// Ping
        /// </summary>
        [EnumMember(Value = ("Ping"))]
        Ping,
        /// <summary>
        /// PluginData
        /// </summary>
        [EnumMember(Value = ("PluginData"))]
        PluginData,
        /// <summary>
        /// PluginResource
        /// </summary>
        [EnumMember(Value = ("PluginResource"))]
        PluginResource,
        /// <summary>
        /// Prefetch
        /// </summary>
        [EnumMember(Value = ("Prefetch"))]
        Prefetch,
        /// <summary>
        /// Resource
        /// </summary>
        [EnumMember(Value = ("Resource"))]
        Resource,
        /// <summary>
        /// Script
        /// </summary>
        [EnumMember(Value = ("Script"))]
        Script,
        /// <summary>
        /// ServiceWorker
        /// </summary>
        [EnumMember(Value = ("ServiceWorker"))]
        ServiceWorker,
        /// <summary>
        /// SharedWorker
        /// </summary>
        [EnumMember(Value = ("SharedWorker"))]
        SharedWorker,
        /// <summary>
        /// SpeculationRules
        /// </summary>
        [EnumMember(Value = ("SpeculationRules"))]
        SpeculationRules,
        /// <summary>
        /// Stylesheet
        /// </summary>
        [EnumMember(Value = ("Stylesheet"))]
        Stylesheet,
        /// <summary>
        /// Track
        /// </summary>
        [EnumMember(Value = ("Track"))]
        Track,
        /// <summary>
        /// Video
        /// </summary>
        [EnumMember(Value = ("Video"))]
        Video,
        /// <summary>
        /// Worker
        /// </summary>
        [EnumMember(Value = ("Worker"))]
        Worker,
        /// <summary>
        /// XMLHttpRequest
        /// </summary>
        [EnumMember(Value = ("XMLHttpRequest"))]
        XMLHttpRequest,
        /// <summary>
        /// XSLT
        /// </summary>
        [EnumMember(Value = ("XSLT"))]
        XSLT
    }

    /// <summary>
    /// MixedContentIssueDetails
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class MixedContentIssueDetails : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The type of resource causing the mixed content issue (css, js, iframe,
        /// form,...). Marked as optional because it is mapped to from
        /// blink::mojom::RequestContextType, which will be replaced
        /// by network::mojom::RequestDestination
        /// </summary>
        public CefSharp.DevTools.Audits.MixedContentResourceType? ResourceType
        {
            get
            {
                return (CefSharp.DevTools.Audits.MixedContentResourceType? )(StringToEnum(typeof(CefSharp.DevTools.Audits.MixedContentResourceType? ), resourceType));
            }

            set
            {
                this.resourceType = (EnumToString(value));
            }
        }

        /// <summary>
        /// The type of resource causing the mixed content issue (css, js, iframe,
        /// form,...). Marked as optional because it is mapped to from
        /// blink::mojom::RequestContextType, which will be replaced
        /// by network::mojom::RequestDestination
        /// </summary>
        [DataMember(Name = ("resourceType"), IsRequired = (false))]
        internal string resourceType
        {
            get;
            set;
        }

        /// <summary>
        /// The way the mixed content issue is being resolved.
        /// </summary>
        public CefSharp.DevTools.Audits.MixedContentResolutionStatus ResolutionStatus
        {
            get
            {
                return (CefSharp.DevTools.Audits.MixedContentResolutionStatus)(StringToEnum(typeof(CefSharp.DevTools.Audits.MixedContentResolutionStatus), resolutionStatus));
            }

            set
            {
                this.resolutionStatus = (EnumToString(value));
            }
        }

        /// <summary>
        /// The way the mixed content issue is being resolved.
        /// </summary>
        [DataMember(Name = ("resolutionStatus"), IsRequired = (true))]
        internal string resolutionStatus
        {
            get;
            set;
        }

        /// <summary>
        /// The unsafe http url causing the mixed content issue.
        /// </summary>
        [DataMember(Name = ("insecureURL"), IsRequired = (true))]
        public string InsecureURL
        {
            get;
            set;
        }

        /// <summary>
        /// The url responsible for the call to an unsafe url.
        /// </summary>
        [DataMember(Name = ("mainResourceURL"), IsRequired = (true))]
        public string MainResourceURL
        {
            get;
            set;
        }

        /// <summary>
        /// The mixed content request.
        /// Does not always exist (e.g. for unsafe form submission urls).
        /// </summary>
        [DataMember(Name = ("request"), IsRequired = (false))]
        public CefSharp.DevTools.Audits.AffectedRequest Request
        {
            get;
            set;
        }

        /// <summary>
        /// Optional because not every mixed content issue is necessarily linked to a frame.
        /// </summary>
        [DataMember(Name = ("frame"), IsRequired = (false))]
        public CefSharp.DevTools.Audits.AffectedFrame Frame
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Enum indicating the reason a response has been blocked. These reasons are
    /// refinements of the net error BLOCKED_BY_RESPONSE.
    /// </summary>
    public enum BlockedByResponseReason
    {
        /// <summary>
        /// CoepFrameResourceNeedsCoepHeader
        /// </summary>
        [EnumMember(Value = ("CoepFrameResourceNeedsCoepHeader"))]
        CoepFrameResourceNeedsCoepHeader,
        /// <summary>
        /// CoopSandboxedIFrameCannotNavigateToCoopPage
        /// </summary>
        [EnumMember(Value = ("CoopSandboxedIFrameCannotNavigateToCoopPage"))]
        CoopSandboxedIFrameCannotNavigateToCoopPage,
        /// <summary>
        /// CorpNotSameOrigin
        /// </summary>
        [EnumMember(Value = ("CorpNotSameOrigin"))]
        CorpNotSameOrigin,
        /// <summary>
        /// CorpNotSameOriginAfterDefaultedToSameOriginByCoep
        /// </summary>
        [EnumMember(Value = ("CorpNotSameOriginAfterDefaultedToSameOriginByCoep"))]
        CorpNotSameOriginAfterDefaultedToSameOriginByCoep,
        /// <summary>
        /// CorpNotSameOriginAfterDefaultedToSameOriginByDip
        /// </summary>
        [EnumMember(Value = ("CorpNotSameOriginAfterDefaultedToSameOriginByDip"))]
        CorpNotSameOriginAfterDefaultedToSameOriginByDip,
        /// <summary>
        /// CorpNotSameOriginAfterDefaultedToSameOriginByCoepAndDip
        /// </summary>
        [EnumMember(Value = ("CorpNotSameOriginAfterDefaultedToSameOriginByCoepAndDip"))]
        CorpNotSameOriginAfterDefaultedToSameOriginByCoepAndDip,
        /// <summary>
        /// CorpNotSameSite
        /// </summary>
        [EnumMember(Value = ("CorpNotSameSite"))]
        CorpNotSameSite
    }

    /// <summary>
    /// Details for a request that has been blocked with the BLOCKED_BY_RESPONSE
    /// code. Currently only used for COEP/COOP, but may be extended to include
    /// some CSP errors in the future.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class BlockedByResponseIssueDetails : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Request
        /// </summary>
        [DataMember(Name = ("request"), IsRequired = (true))]
        public CefSharp.DevTools.Audits.AffectedRequest Request
        {
            get;
            set;
        }

        /// <summary>
        /// ParentFrame
        /// </summary>
        [DataMember(Name = ("parentFrame"), IsRequired = (false))]
        public CefSharp.DevTools.Audits.AffectedFrame ParentFrame
        {
            get;
            set;
        }

        /// <summary>
        /// BlockedFrame
        /// </summary>
        [DataMember(Name = ("blockedFrame"), IsRequired = (false))]
        public CefSharp.DevTools.Audits.AffectedFrame BlockedFrame
        {
            get;
            set;
        }

        /// <summary>
        /// Reason
        /// </summary>
        public CefSharp.DevTools.Audits.BlockedByResponseReason Reason
        {
            get
            {
                return (CefSharp.DevTools.Audits.BlockedByResponseReason)(StringToEnum(typeof(CefSharp.DevTools.Audits.BlockedByResponseReason), reason));
            }

            set
            {
                this.reason = (EnumToString(value));
            }
        }

        /// <summary>
        /// Reason
        /// </summary>
        [DataMember(Name = ("reason"), IsRequired = (true))]
        internal string reason
        {
            get;
            set;
        }
    }

    /// <summary>
    /// HeavyAdResolutionStatus
    /// </summary>
    public enum HeavyAdResolutionStatus
    {
        /// <summary>
        /// HeavyAdBlocked
        /// </summary>
        [EnumMember(Value = ("HeavyAdBlocked"))]
        HeavyAdBlocked,
        /// <summary>
        /// HeavyAdWarning
        /// </summary>
        [EnumMember(Value = ("HeavyAdWarning"))]
        HeavyAdWarning
    }

    /// <summary>
    /// HeavyAdReason
    /// </summary>
    public enum HeavyAdReason
    {
        /// <summary>
        /// NetworkTotalLimit
        /// </summary>
        [EnumMember(Value = ("NetworkTotalLimit"))]
        NetworkTotalLimit,
        /// <summary>
        /// CpuTotalLimit
        /// </summary>
        [EnumMember(Value = ("CpuTotalLimit"))]
        CpuTotalLimit,
        /// <summary>
        /// CpuPeakLimit
        /// </summary>
        [EnumMember(Value = ("CpuPeakLimit"))]
        CpuPeakLimit
    }

    /// <summary>
    /// HeavyAdIssueDetails
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class HeavyAdIssueDetails : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The resolution status, either blocking the content or warning.
        /// </summary>
        public CefSharp.DevTools.Audits.HeavyAdResolutionStatus Resolution
        {
            get
            {
                return (CefSharp.DevTools.Audits.HeavyAdResolutionStatus)(StringToEnum(typeof(CefSharp.DevTools.Audits.HeavyAdResolutionStatus), resolution));
            }

            set
            {
                this.resolution = (EnumToString(value));
            }
        }

        /// <summary>
        /// The resolution status, either blocking the content or warning.
        /// </summary>
        [DataMember(Name = ("resolution"), IsRequired = (true))]
        internal string resolution
        {
            get;
            set;
        }

        /// <summary>
        /// The reason the ad was blocked, total network or cpu or peak cpu.
        /// </summary>
        public CefSharp.DevTools.Audits.HeavyAdReason Reason
        {
            get
            {
                return (CefSharp.DevTools.Audits.HeavyAdReason)(StringToEnum(typeof(CefSharp.DevTools.Audits.HeavyAdReason), reason));
            }

            set
            {
                this.reason = (EnumToString(value));
            }
        }

        /// <summary>
        /// The reason the ad was blocked, total network or cpu or peak cpu.
        /// </summary>
        [DataMember(Name = ("reason"), IsRequired = (true))]
        internal string reason
        {
            get;
            set;
        }

        /// <summary>
        /// The frame that was blocked.
        /// </summary>
        [DataMember(Name = ("frame"), IsRequired = (true))]
        public CefSharp.DevTools.Audits.AffectedFrame Frame
        {
            get;
            set;
        }
    }

    /// <summary>
    /// ContentSecurityPolicyViolationType
    /// </summary>
    public enum ContentSecurityPolicyViolationType
    {
        /// <summary>
        /// kInlineViolation
        /// </summary>
        [EnumMember(Value = ("kInlineViolation"))]
        KInlineViolation,
        /// <summary>
        /// kEvalViolation
        /// </summary>
        [EnumMember(Value = ("kEvalViolation"))]
        KEvalViolation,
        /// <summary>
        /// kURLViolation
        /// </summary>
        [EnumMember(Value = ("kURLViolation"))]
        KURLViolation,
        /// <summary>
        /// kTrustedTypesSinkViolation
        /// </summary>
        [EnumMember(Value = ("kTrustedTypesSinkViolation"))]
        KTrustedTypesSinkViolation,
        /// <summary>
        /// kTrustedTypesPolicyViolation
        /// </summary>
        [EnumMember(Value = ("kTrustedTypesPolicyViolation"))]
        KTrustedTypesPolicyViolation,
        /// <summary>
        /// kWasmEvalViolation
        /// </summary>
        [EnumMember(Value = ("kWasmEvalViolation"))]
        KWasmEvalViolation
    }

    /// <summary>
    /// SourceCodeLocation
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class SourceCodeLocation : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// ScriptId
        /// </summary>
        [DataMember(Name = ("scriptId"), IsRequired = (false))]
        public string ScriptId
        {
            get;
            set;
        }

        /// <summary>
        /// Url
        /// </summary>
        [DataMember(Name = ("url"), IsRequired = (true))]
        public string Url
        {
            get;
            set;
        }

        /// <summary>
        /// LineNumber
        /// </summary>
        [DataMember(Name = ("lineNumber"), IsRequired = (true))]
        public int LineNumber
        {
            get;
            set;
        }

        /// <summary>
        /// ColumnNumber
        /// </summary>
        [DataMember(Name = ("columnNumber"), IsRequired = (true))]
        public int ColumnNumber
        {
            get;
            set;
        }
    }

    /// <summary>
    /// ContentSecurityPolicyIssueDetails
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class ContentSecurityPolicyIssueDetails : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The url not included in allowed sources.
        /// </summary>
        [DataMember(Name = ("blockedURL"), IsRequired = (false))]
        public string BlockedURL
        {
            get;
            set;
        }

        /// <summary>
        /// Specific directive that is violated, causing the CSP issue.
        /// </summary>
        [DataMember(Name = ("violatedDirective"), IsRequired = (true))]
        public string ViolatedDirective
        {
            get;
            set;
        }

        /// <summary>
        /// IsReportOnly
        /// </summary>
        [DataMember(Name = ("isReportOnly"), IsRequired = (true))]
        public bool IsReportOnly
        {
            get;
            set;
        }

        /// <summary>
        /// ContentSecurityPolicyViolationType
        /// </summary>
        public CefSharp.DevTools.Audits.ContentSecurityPolicyViolationType ContentSecurityPolicyViolationType
        {
            get
            {
                return (CefSharp.DevTools.Audits.ContentSecurityPolicyViolationType)(StringToEnum(typeof(CefSharp.DevTools.Audits.ContentSecurityPolicyViolationType), contentSecurityPolicyViolationType));
            }

            set
            {
                this.contentSecurityPolicyViolationType = (EnumToString(value));
            }
        }

        /// <summary>
        /// ContentSecurityPolicyViolationType
        /// </summary>
        [DataMember(Name = ("contentSecurityPolicyViolationType"), IsRequired = (true))]
        internal string contentSecurityPolicyViolationType
        {
            get;
            set;
        }

        /// <summary>
        /// FrameAncestor
        /// </summary>
        [DataMember(Name = ("frameAncestor"), IsRequired = (false))]
        public CefSharp.DevTools.Audits.AffectedFrame FrameAncestor
        {
            get;
            set;
        }

        /// <summary>
        /// SourceCodeLocation
        /// </summary>
        [DataMember(Name = ("sourceCodeLocation"), IsRequired = (false))]
        public CefSharp.DevTools.Audits.SourceCodeLocation SourceCodeLocation
        {
            get;
            set;
        }

        /// <summary>
        /// ViolatingNodeId
        /// </summary>
        [DataMember(Name = ("violatingNodeId"), IsRequired = (false))]
        public int? ViolatingNodeId
        {
            get;
            set;
        }
    }

    /// <summary>
    /// SharedArrayBufferIssueType
    /// </summary>
    public enum SharedArrayBufferIssueType
    {
        /// <summary>
        /// TransferIssue
        /// </summary>
        [EnumMember(Value = ("TransferIssue"))]
        TransferIssue,
        /// <summary>
        /// CreationIssue
        /// </summary>
        [EnumMember(Value = ("CreationIssue"))]
        CreationIssue
    }

    /// <summary>
    /// Details for a issue arising from an SAB being instantiated in, or
    /// transferred to a context that is not cross-origin isolated.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class SharedArrayBufferIssueDetails : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// SourceCodeLocation
        /// </summary>
        [DataMember(Name = ("sourceCodeLocation"), IsRequired = (true))]
        public CefSharp.DevTools.Audits.SourceCodeLocation SourceCodeLocation
        {
            get;
            set;
        }

        /// <summary>
        /// IsWarning
        /// </summary>
        [DataMember(Name = ("isWarning"), IsRequired = (true))]
        public bool IsWarning
        {
            get;
            set;
        }

        /// <summary>
        /// Type
        /// </summary>
        public CefSharp.DevTools.Audits.SharedArrayBufferIssueType Type
        {
            get
            {
                return (CefSharp.DevTools.Audits.SharedArrayBufferIssueType)(StringToEnum(typeof(CefSharp.DevTools.Audits.SharedArrayBufferIssueType), type));
            }

            set
            {
                this.type = (EnumToString(value));
            }
        }

        /// <summary>
        /// Type
        /// </summary>
        [DataMember(Name = ("type"), IsRequired = (true))]
        internal string type
        {
            get;
            set;
        }
    }

    /// <summary>
    /// LowTextContrastIssueDetails
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class LowTextContrastIssueDetails : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// ViolatingNodeId
        /// </summary>
        [DataMember(Name = ("violatingNodeId"), IsRequired = (true))]
        public int ViolatingNodeId
        {
            get;
            set;
        }

        /// <summary>
        /// ViolatingNodeSelector
        /// </summary>
        [DataMember(Name = ("violatingNodeSelector"), IsRequired = (true))]
        public string ViolatingNodeSelector
        {
            get;
            set;
        }

        /// <summary>
        /// ContrastRatio
        /// </summary>
        [DataMember(Name = ("contrastRatio"), IsRequired = (true))]
        public double ContrastRatio
        {
            get;
            set;
        }

        /// <summary>
        /// ThresholdAA
        /// </summary>
        [DataMember(Name = ("thresholdAA"), IsRequired = (true))]
        public double ThresholdAA
        {
            get;
            set;
        }

        /// <summary>
        /// ThresholdAAA
        /// </summary>
        [DataMember(Name = ("thresholdAAA"), IsRequired = (true))]
        public double ThresholdAAA
        {
            get;
            set;
        }

        /// <summary>
        /// FontSize
        /// </summary>
        [DataMember(Name = ("fontSize"), IsRequired = (true))]
        public string FontSize
        {
            get;
            set;
        }

        /// <summary>
        /// FontWeight
        /// </summary>
        [DataMember(Name = ("fontWeight"), IsRequired = (true))]
        public string FontWeight
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Details for a CORS related issue, e.g. a warning or error related to
    /// CORS RFC1918 enforcement.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class CorsIssueDetails : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// CorsErrorStatus
        /// </summary>
        [DataMember(Name = ("corsErrorStatus"), IsRequired = (true))]
        public CefSharp.DevTools.Network.CorsErrorStatus CorsErrorStatus
        {
            get;
            set;
        }

        /// <summary>
        /// IsWarning
        /// </summary>
        [DataMember(Name = ("isWarning"), IsRequired = (true))]
        public bool IsWarning
        {
            get;
            set;
        }

        /// <summary>
        /// Request
        /// </summary>
        [DataMember(Name = ("request"), IsRequired = (true))]
        public CefSharp.DevTools.Audits.AffectedRequest Request
        {
            get;
            set;
        }

        /// <summary>
        /// Location
        /// </summary>
        [DataMember(Name = ("location"), IsRequired = (false))]
        public CefSharp.DevTools.Audits.SourceCodeLocation Location
        {
            get;
            set;
        }

        /// <summary>
        /// InitiatorOrigin
        /// </summary>
        [DataMember(Name = ("initiatorOrigin"), IsRequired = (false))]
        public string InitiatorOrigin
        {
            get;
            set;
        }

        /// <summary>
        /// ResourceIPAddressSpace
        /// </summary>
        public CefSharp.DevTools.Network.IPAddressSpace? ResourceIPAddressSpace
        {
            get
            {
                return (CefSharp.DevTools.Network.IPAddressSpace? )(StringToEnum(typeof(CefSharp.DevTools.Network.IPAddressSpace? ), resourceIPAddressSpace));
            }

            set
            {
                this.resourceIPAddressSpace = (EnumToString(value));
            }
        }

        /// <summary>
        /// ResourceIPAddressSpace
        /// </summary>
        [DataMember(Name = ("resourceIPAddressSpace"), IsRequired = (false))]
        internal string resourceIPAddressSpace
        {
            get;
            set;
        }

        /// <summary>
        /// ClientSecurityState
        /// </summary>
        [DataMember(Name = ("clientSecurityState"), IsRequired = (false))]
        public CefSharp.DevTools.Network.ClientSecurityState ClientSecurityState
        {
            get;
            set;
        }
    }

    /// <summary>
    /// AttributionReportingIssueType
    /// </summary>
    public enum AttributionReportingIssueType
    {
        /// <summary>
        /// PermissionPolicyDisabled
        /// </summary>
        [EnumMember(Value = ("PermissionPolicyDisabled"))]
        PermissionPolicyDisabled,
        /// <summary>
        /// UntrustworthyReportingOrigin
        /// </summary>
        [EnumMember(Value = ("UntrustworthyReportingOrigin"))]
        UntrustworthyReportingOrigin,
        /// <summary>
        /// InsecureContext
        /// </summary>
        [EnumMember(Value = ("InsecureContext"))]
        InsecureContext,
        /// <summary>
        /// InvalidHeader
        /// </summary>
        [EnumMember(Value = ("InvalidHeader"))]
        InvalidHeader,
        /// <summary>
        /// InvalidRegisterTriggerHeader
        /// </summary>
        [EnumMember(Value = ("InvalidRegisterTriggerHeader"))]
        InvalidRegisterTriggerHeader,
        /// <summary>
        /// SourceAndTriggerHeaders
        /// </summary>
        [EnumMember(Value = ("SourceAndTriggerHeaders"))]
        SourceAndTriggerHeaders,
        /// <summary>
        /// SourceIgnored
        /// </summary>
        [EnumMember(Value = ("SourceIgnored"))]
        SourceIgnored,
        /// <summary>
        /// TriggerIgnored
        /// </summary>
        [EnumMember(Value = ("TriggerIgnored"))]
        TriggerIgnored,
        /// <summary>
        /// OsSourceIgnored
        /// </summary>
        [EnumMember(Value = ("OsSourceIgnored"))]
        OsSourceIgnored,
        /// <summary>
        /// OsTriggerIgnored
        /// </summary>
        [EnumMember(Value = ("OsTriggerIgnored"))]
        OsTriggerIgnored,
        /// <summary>
        /// InvalidRegisterOsSourceHeader
        /// </summary>
        [EnumMember(Value = ("InvalidRegisterOsSourceHeader"))]
        InvalidRegisterOsSourceHeader,
        /// <summary>
        /// InvalidRegisterOsTriggerHeader
        /// </summary>
        [EnumMember(Value = ("InvalidRegisterOsTriggerHeader"))]
        InvalidRegisterOsTriggerHeader,
        /// <summary>
        /// WebAndOsHeaders
        /// </summary>
        [EnumMember(Value = ("WebAndOsHeaders"))]
        WebAndOsHeaders,
        /// <summary>
        /// NoWebOrOsSupport
        /// </summary>
        [EnumMember(Value = ("NoWebOrOsSupport"))]
        NoWebOrOsSupport,
        /// <summary>
        /// NavigationRegistrationWithoutTransientUserActivation
        /// </summary>
        [EnumMember(Value = ("NavigationRegistrationWithoutTransientUserActivation"))]
        NavigationRegistrationWithoutTransientUserActivation,
        /// <summary>
        /// InvalidInfoHeader
        /// </summary>
        [EnumMember(Value = ("InvalidInfoHeader"))]
        InvalidInfoHeader,
        /// <summary>
        /// NoRegisterSourceHeader
        /// </summary>
        [EnumMember(Value = ("NoRegisterSourceHeader"))]
        NoRegisterSourceHeader,
        /// <summary>
        /// NoRegisterTriggerHeader
        /// </summary>
        [EnumMember(Value = ("NoRegisterTriggerHeader"))]
        NoRegisterTriggerHeader,
        /// <summary>
        /// NoRegisterOsSourceHeader
        /// </summary>
        [EnumMember(Value = ("NoRegisterOsSourceHeader"))]
        NoRegisterOsSourceHeader,
        /// <summary>
        /// NoRegisterOsTriggerHeader
        /// </summary>
        [EnumMember(Value = ("NoRegisterOsTriggerHeader"))]
        NoRegisterOsTriggerHeader
    }

    /// <summary>
    /// SharedDictionaryError
    /// </summary>
    public enum SharedDictionaryError
    {
        /// <summary>
        /// UseErrorCrossOriginNoCorsRequest
        /// </summary>
        [EnumMember(Value = ("UseErrorCrossOriginNoCorsRequest"))]
        UseErrorCrossOriginNoCorsRequest,
        /// <summary>
        /// UseErrorDictionaryLoadFailure
        /// </summary>
        [EnumMember(Value = ("UseErrorDictionaryLoadFailure"))]
        UseErrorDictionaryLoadFailure,
        /// <summary>
        /// UseErrorMatchingDictionaryNotUsed
        /// </summary>
        [EnumMember(Value = ("UseErrorMatchingDictionaryNotUsed"))]
        UseErrorMatchingDictionaryNotUsed,
        /// <summary>
        /// UseErrorUnexpectedContentDictionaryHeader
        /// </summary>
        [EnumMember(Value = ("UseErrorUnexpectedContentDictionaryHeader"))]
        UseErrorUnexpectedContentDictionaryHeader,
        /// <summary>
        /// WriteErrorCossOriginNoCorsRequest
        /// </summary>
        [EnumMember(Value = ("WriteErrorCossOriginNoCorsRequest"))]
        WriteErrorCossOriginNoCorsRequest,
        /// <summary>
        /// WriteErrorDisallowedBySettings
        /// </summary>
        [EnumMember(Value = ("WriteErrorDisallowedBySettings"))]
        WriteErrorDisallowedBySettings,
        /// <summary>
        /// WriteErrorExpiredResponse
        /// </summary>
        [EnumMember(Value = ("WriteErrorExpiredResponse"))]
        WriteErrorExpiredResponse,
        /// <summary>
        /// WriteErrorFeatureDisabled
        /// </summary>
        [EnumMember(Value = ("WriteErrorFeatureDisabled"))]
        WriteErrorFeatureDisabled,
        /// <summary>
        /// WriteErrorInsufficientResources
        /// </summary>
        [EnumMember(Value = ("WriteErrorInsufficientResources"))]
        WriteErrorInsufficientResources,
        /// <summary>
        /// WriteErrorInvalidMatchField
        /// </summary>
        [EnumMember(Value = ("WriteErrorInvalidMatchField"))]
        WriteErrorInvalidMatchField,
        /// <summary>
        /// WriteErrorInvalidStructuredHeader
        /// </summary>
        [EnumMember(Value = ("WriteErrorInvalidStructuredHeader"))]
        WriteErrorInvalidStructuredHeader,
        /// <summary>
        /// WriteErrorNavigationRequest
        /// </summary>
        [EnumMember(Value = ("WriteErrorNavigationRequest"))]
        WriteErrorNavigationRequest,
        /// <summary>
        /// WriteErrorNoMatchField
        /// </summary>
        [EnumMember(Value = ("WriteErrorNoMatchField"))]
        WriteErrorNoMatchField,
        /// <summary>
        /// WriteErrorNonListMatchDestField
        /// </summary>
        [EnumMember(Value = ("WriteErrorNonListMatchDestField"))]
        WriteErrorNonListMatchDestField,
        /// <summary>
        /// WriteErrorNonSecureContext
        /// </summary>
        [EnumMember(Value = ("WriteErrorNonSecureContext"))]
        WriteErrorNonSecureContext,
        /// <summary>
        /// WriteErrorNonStringIdField
        /// </summary>
        [EnumMember(Value = ("WriteErrorNonStringIdField"))]
        WriteErrorNonStringIdField,
        /// <summary>
        /// WriteErrorNonStringInMatchDestList
        /// </summary>
        [EnumMember(Value = ("WriteErrorNonStringInMatchDestList"))]
        WriteErrorNonStringInMatchDestList,
        /// <summary>
        /// WriteErrorNonStringMatchField
        /// </summary>
        [EnumMember(Value = ("WriteErrorNonStringMatchField"))]
        WriteErrorNonStringMatchField,
        /// <summary>
        /// WriteErrorNonTokenTypeField
        /// </summary>
        [EnumMember(Value = ("WriteErrorNonTokenTypeField"))]
        WriteErrorNonTokenTypeField,
        /// <summary>
        /// WriteErrorRequestAborted
        /// </summary>
        [EnumMember(Value = ("WriteErrorRequestAborted"))]
        WriteErrorRequestAborted,
        /// <summary>
        /// WriteErrorShuttingDown
        /// </summary>
        [EnumMember(Value = ("WriteErrorShuttingDown"))]
        WriteErrorShuttingDown,
        /// <summary>
        /// WriteErrorTooLongIdField
        /// </summary>
        [EnumMember(Value = ("WriteErrorTooLongIdField"))]
        WriteErrorTooLongIdField,
        /// <summary>
        /// WriteErrorUnsupportedType
        /// </summary>
        [EnumMember(Value = ("WriteErrorUnsupportedType"))]
        WriteErrorUnsupportedType
    }

    /// <summary>
    /// Details for issues around &quot;Attribution Reporting API&quot; usage.
    /// Explainer: https://github.com/WICG/attribution-reporting-api
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class AttributionReportingIssueDetails : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// ViolationType
        /// </summary>
        public CefSharp.DevTools.Audits.AttributionReportingIssueType ViolationType
        {
            get
            {
                return (CefSharp.DevTools.Audits.AttributionReportingIssueType)(StringToEnum(typeof(CefSharp.DevTools.Audits.AttributionReportingIssueType), violationType));
            }

            set
            {
                this.violationType = (EnumToString(value));
            }
        }

        /// <summary>
        /// ViolationType
        /// </summary>
        [DataMember(Name = ("violationType"), IsRequired = (true))]
        internal string violationType
        {
            get;
            set;
        }

        /// <summary>
        /// Request
        /// </summary>
        [DataMember(Name = ("request"), IsRequired = (false))]
        public CefSharp.DevTools.Audits.AffectedRequest Request
        {
            get;
            set;
        }

        /// <summary>
        /// ViolatingNodeId
        /// </summary>
        [DataMember(Name = ("violatingNodeId"), IsRequired = (false))]
        public int? ViolatingNodeId
        {
            get;
            set;
        }

        /// <summary>
        /// InvalidParameter
        /// </summary>
        [DataMember(Name = ("invalidParameter"), IsRequired = (false))]
        public string InvalidParameter
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Details for issues about documents in Quirks Mode
    /// or Limited Quirks Mode that affects page layouting.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class QuirksModeIssueDetails : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// If false, it means the document&apos;s mode is &quot;quirks&quot;
        /// instead of &quot;limited-quirks&quot;.
        /// </summary>
        [DataMember(Name = ("isLimitedQuirksMode"), IsRequired = (true))]
        public bool IsLimitedQuirksMode
        {
            get;
            set;
        }

        /// <summary>
        /// DocumentNodeId
        /// </summary>
        [DataMember(Name = ("documentNodeId"), IsRequired = (true))]
        public int DocumentNodeId
        {
            get;
            set;
        }

        /// <summary>
        /// Url
        /// </summary>
        [DataMember(Name = ("url"), IsRequired = (true))]
        public string Url
        {
            get;
            set;
        }

        /// <summary>
        /// FrameId
        /// </summary>
        [DataMember(Name = ("frameId"), IsRequired = (true))]
        public string FrameId
        {
            get;
            set;
        }

        /// <summary>
        /// LoaderId
        /// </summary>
        [DataMember(Name = ("loaderId"), IsRequired = (true))]
        public string LoaderId
        {
            get;
            set;
        }
    }

    /// <summary>
    /// NavigatorUserAgentIssueDetails
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class NavigatorUserAgentIssueDetails : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Url
        /// </summary>
        [DataMember(Name = ("url"), IsRequired = (true))]
        public string Url
        {
            get;
            set;
        }

        /// <summary>
        /// Location
        /// </summary>
        [DataMember(Name = ("location"), IsRequired = (false))]
        public CefSharp.DevTools.Audits.SourceCodeLocation Location
        {
            get;
            set;
        }
    }

    /// <summary>
    /// SharedDictionaryIssueDetails
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class SharedDictionaryIssueDetails : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// SharedDictionaryError
        /// </summary>
        public CefSharp.DevTools.Audits.SharedDictionaryError SharedDictionaryError
        {
            get
            {
                return (CefSharp.DevTools.Audits.SharedDictionaryError)(StringToEnum(typeof(CefSharp.DevTools.Audits.SharedDictionaryError), sharedDictionaryError));
            }

            set
            {
                this.sharedDictionaryError = (EnumToString(value));
            }
        }

        /// <summary>
        /// SharedDictionaryError
        /// </summary>
        [DataMember(Name = ("sharedDictionaryError"), IsRequired = (true))]
        internal string sharedDictionaryError
        {
            get;
            set;
        }

        /// <summary>
        /// Request
        /// </summary>
        [DataMember(Name = ("request"), IsRequired = (true))]
        public CefSharp.DevTools.Audits.AffectedRequest Request
        {
            get;
            set;
        }
    }

    /// <summary>
    /// GenericIssueErrorType
    /// </summary>
    public enum GenericIssueErrorType
    {
        /// <summary>
        /// FormLabelForNameError
        /// </summary>
        [EnumMember(Value = ("FormLabelForNameError"))]
        FormLabelForNameError,
        /// <summary>
        /// FormDuplicateIdForInputError
        /// </summary>
        [EnumMember(Value = ("FormDuplicateIdForInputError"))]
        FormDuplicateIdForInputError,
        /// <summary>
        /// FormInputWithNoLabelError
        /// </summary>
        [EnumMember(Value = ("FormInputWithNoLabelError"))]
        FormInputWithNoLabelError,
        /// <summary>
        /// FormAutocompleteAttributeEmptyError
        /// </summary>
        [EnumMember(Value = ("FormAutocompleteAttributeEmptyError"))]
        FormAutocompleteAttributeEmptyError,
        /// <summary>
        /// FormEmptyIdAndNameAttributesForInputError
        /// </summary>
        [EnumMember(Value = ("FormEmptyIdAndNameAttributesForInputError"))]
        FormEmptyIdAndNameAttributesForInputError,
        /// <summary>
        /// FormAriaLabelledByToNonExistingId
        /// </summary>
        [EnumMember(Value = ("FormAriaLabelledByToNonExistingId"))]
        FormAriaLabelledByToNonExistingId,
        /// <summary>
        /// FormInputAssignedAutocompleteValueToIdOrNameAttributeError
        /// </summary>
        [EnumMember(Value = ("FormInputAssignedAutocompleteValueToIdOrNameAttributeError"))]
        FormInputAssignedAutocompleteValueToIdOrNameAttributeError,
        /// <summary>
        /// FormLabelHasNeitherForNorNestedInput
        /// </summary>
        [EnumMember(Value = ("FormLabelHasNeitherForNorNestedInput"))]
        FormLabelHasNeitherForNorNestedInput,
        /// <summary>
        /// FormLabelForMatchesNonExistingIdError
        /// </summary>
        [EnumMember(Value = ("FormLabelForMatchesNonExistingIdError"))]
        FormLabelForMatchesNonExistingIdError,
        /// <summary>
        /// FormInputHasWrongButWellIntendedAutocompleteValueError
        /// </summary>
        [EnumMember(Value = ("FormInputHasWrongButWellIntendedAutocompleteValueError"))]
        FormInputHasWrongButWellIntendedAutocompleteValueError,
        /// <summary>
        /// ResponseWasBlockedByORB
        /// </summary>
        [EnumMember(Value = ("ResponseWasBlockedByORB"))]
        ResponseWasBlockedByORB
    }

    /// <summary>
    /// Depending on the concrete errorType, different properties are set.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class GenericIssueDetails : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Issues with the same errorType are aggregated in the frontend.
        /// </summary>
        public CefSharp.DevTools.Audits.GenericIssueErrorType ErrorType
        {
            get
            {
                return (CefSharp.DevTools.Audits.GenericIssueErrorType)(StringToEnum(typeof(CefSharp.DevTools.Audits.GenericIssueErrorType), errorType));
            }

            set
            {
                this.errorType = (EnumToString(value));
            }
        }

        /// <summary>
        /// Issues with the same errorType are aggregated in the frontend.
        /// </summary>
        [DataMember(Name = ("errorType"), IsRequired = (true))]
        internal string errorType
        {
            get;
            set;
        }

        /// <summary>
        /// FrameId
        /// </summary>
        [DataMember(Name = ("frameId"), IsRequired = (false))]
        public string FrameId
        {
            get;
            set;
        }

        /// <summary>
        /// ViolatingNodeId
        /// </summary>
        [DataMember(Name = ("violatingNodeId"), IsRequired = (false))]
        public int? ViolatingNodeId
        {
            get;
            set;
        }

        /// <summary>
        /// ViolatingNodeAttribute
        /// </summary>
        [DataMember(Name = ("violatingNodeAttribute"), IsRequired = (false))]
        public string ViolatingNodeAttribute
        {
            get;
            set;
        }

        /// <summary>
        /// Request
        /// </summary>
        [DataMember(Name = ("request"), IsRequired = (false))]
        public CefSharp.DevTools.Audits.AffectedRequest Request
        {
            get;
            set;
        }
    }

    /// <summary>
    /// This issue tracks information needed to print a deprecation message.
    /// https://source.chromium.org/chromium/chromium/src/+/main:third_party/blink/renderer/core/frame/third_party/blink/renderer/core/frame/deprecation/README.md
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class DeprecationIssueDetails : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// AffectedFrame
        /// </summary>
        [DataMember(Name = ("affectedFrame"), IsRequired = (false))]
        public CefSharp.DevTools.Audits.AffectedFrame AffectedFrame
        {
            get;
            set;
        }

        /// <summary>
        /// SourceCodeLocation
        /// </summary>
        [DataMember(Name = ("sourceCodeLocation"), IsRequired = (true))]
        public CefSharp.DevTools.Audits.SourceCodeLocation SourceCodeLocation
        {
            get;
            set;
        }

        /// <summary>
        /// One of the deprecation names from third_party/blink/renderer/core/frame/deprecation/deprecation.json5
        /// </summary>
        [DataMember(Name = ("type"), IsRequired = (true))]
        public string Type
        {
            get;
            set;
        }
    }

    /// <summary>
    /// This issue warns about sites in the redirect chain of a finished navigation
    /// that may be flagged as trackers and have their state cleared if they don&apos;t
    /// receive a user interaction. Note that in this context &apos;site&apos; means eTLD+1.
    /// For example, if the URL `https://example.test:80/bounce` was in the
    /// redirect chain, the site reported would be `example.test`.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class BounceTrackingIssueDetails : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// TrackingSites
        /// </summary>
        [DataMember(Name = ("trackingSites"), IsRequired = (true))]
        public string[] TrackingSites
        {
            get;
            set;
        }
    }

    /// <summary>
    /// This issue warns about third-party sites that are accessing cookies on the
    /// current page, and have been permitted due to having a global metadata grant.
    /// Note that in this context &apos;site&apos; means eTLD+1. For example, if the URL
    /// `https://example.test:80/web_page` was accessing cookies, the site reported
    /// would be `example.test`.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class CookieDeprecationMetadataIssueDetails : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// AllowedSites
        /// </summary>
        [DataMember(Name = ("allowedSites"), IsRequired = (true))]
        public string[] AllowedSites
        {
            get;
            set;
        }

        /// <summary>
        /// OptOutPercentage
        /// </summary>
        [DataMember(Name = ("optOutPercentage"), IsRequired = (true))]
        public double OptOutPercentage
        {
            get;
            set;
        }

        /// <summary>
        /// IsOptOutTopLevel
        /// </summary>
        [DataMember(Name = ("isOptOutTopLevel"), IsRequired = (true))]
        public bool IsOptOutTopLevel
        {
            get;
            set;
        }

        /// <summary>
        /// Operation
        /// </summary>
        public CefSharp.DevTools.Audits.CookieOperation Operation
        {
            get
            {
                return (CefSharp.DevTools.Audits.CookieOperation)(StringToEnum(typeof(CefSharp.DevTools.Audits.CookieOperation), operation));
            }

            set
            {
                this.operation = (EnumToString(value));
            }
        }

        /// <summary>
        /// Operation
        /// </summary>
        [DataMember(Name = ("operation"), IsRequired = (true))]
        internal string operation
        {
            get;
            set;
        }
    }

    /// <summary>
    /// ClientHintIssueReason
    /// </summary>
    public enum ClientHintIssueReason
    {
        /// <summary>
        /// MetaTagAllowListInvalidOrigin
        /// </summary>
        [EnumMember(Value = ("MetaTagAllowListInvalidOrigin"))]
        MetaTagAllowListInvalidOrigin,
        /// <summary>
        /// MetaTagModifiedHTML
        /// </summary>
        [EnumMember(Value = ("MetaTagModifiedHTML"))]
        MetaTagModifiedHTML
    }

    /// <summary>
    /// FederatedAuthRequestIssueDetails
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class FederatedAuthRequestIssueDetails : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// FederatedAuthRequestIssueReason
        /// </summary>
        public CefSharp.DevTools.Audits.FederatedAuthRequestIssueReason FederatedAuthRequestIssueReason
        {
            get
            {
                return (CefSharp.DevTools.Audits.FederatedAuthRequestIssueReason)(StringToEnum(typeof(CefSharp.DevTools.Audits.FederatedAuthRequestIssueReason), federatedAuthRequestIssueReason));
            }

            set
            {
                this.federatedAuthRequestIssueReason = (EnumToString(value));
            }
        }

        /// <summary>
        /// FederatedAuthRequestIssueReason
        /// </summary>
        [DataMember(Name = ("federatedAuthRequestIssueReason"), IsRequired = (true))]
        internal string federatedAuthRequestIssueReason
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Represents the failure reason when a federated authentication reason fails.
    /// Should be updated alongside RequestIdTokenStatus in
    /// third_party/blink/public/mojom/devtools/inspector_issue.mojom to include
    /// all cases except for success.
    /// </summary>
    public enum FederatedAuthRequestIssueReason
    {
        /// <summary>
        /// ShouldEmbargo
        /// </summary>
        [EnumMember(Value = ("ShouldEmbargo"))]
        ShouldEmbargo,
        /// <summary>
        /// TooManyRequests
        /// </summary>
        [EnumMember(Value = ("TooManyRequests"))]
        TooManyRequests,
        /// <summary>
        /// WellKnownHttpNotFound
        /// </summary>
        [EnumMember(Value = ("WellKnownHttpNotFound"))]
        WellKnownHttpNotFound,
        /// <summary>
        /// WellKnownNoResponse
        /// </summary>
        [EnumMember(Value = ("WellKnownNoResponse"))]
        WellKnownNoResponse,
        /// <summary>
        /// WellKnownInvalidResponse
        /// </summary>
        [EnumMember(Value = ("WellKnownInvalidResponse"))]
        WellKnownInvalidResponse,
        /// <summary>
        /// WellKnownListEmpty
        /// </summary>
        [EnumMember(Value = ("WellKnownListEmpty"))]
        WellKnownListEmpty,
        /// <summary>
        /// WellKnownInvalidContentType
        /// </summary>
        [EnumMember(Value = ("WellKnownInvalidContentType"))]
        WellKnownInvalidContentType,
        /// <summary>
        /// ConfigNotInWellKnown
        /// </summary>
        [EnumMember(Value = ("ConfigNotInWellKnown"))]
        ConfigNotInWellKnown,
        /// <summary>
        /// WellKnownTooBig
        /// </summary>
        [EnumMember(Value = ("WellKnownTooBig"))]
        WellKnownTooBig,
        /// <summary>
        /// ConfigHttpNotFound
        /// </summary>
        [EnumMember(Value = ("ConfigHttpNotFound"))]
        ConfigHttpNotFound,
        /// <summary>
        /// ConfigNoResponse
        /// </summary>
        [EnumMember(Value = ("ConfigNoResponse"))]
        ConfigNoResponse,
        /// <summary>
        /// ConfigInvalidResponse
        /// </summary>
        [EnumMember(Value = ("ConfigInvalidResponse"))]
        ConfigInvalidResponse,
        /// <summary>
        /// ConfigInvalidContentType
        /// </summary>
        [EnumMember(Value = ("ConfigInvalidContentType"))]
        ConfigInvalidContentType,
        /// <summary>
        /// ClientMetadataHttpNotFound
        /// </summary>
        [EnumMember(Value = ("ClientMetadataHttpNotFound"))]
        ClientMetadataHttpNotFound,
        /// <summary>
        /// ClientMetadataNoResponse
        /// </summary>
        [EnumMember(Value = ("ClientMetadataNoResponse"))]
        ClientMetadataNoResponse,
        /// <summary>
        /// ClientMetadataInvalidResponse
        /// </summary>
        [EnumMember(Value = ("ClientMetadataInvalidResponse"))]
        ClientMetadataInvalidResponse,
        /// <summary>
        /// ClientMetadataInvalidContentType
        /// </summary>
        [EnumMember(Value = ("ClientMetadataInvalidContentType"))]
        ClientMetadataInvalidContentType,
        /// <summary>
        /// IdpNotPotentiallyTrustworthy
        /// </summary>
        [EnumMember(Value = ("IdpNotPotentiallyTrustworthy"))]
        IdpNotPotentiallyTrustworthy,
        /// <summary>
        /// DisabledInSettings
        /// </summary>
        [EnumMember(Value = ("DisabledInSettings"))]
        DisabledInSettings,
        /// <summary>
        /// DisabledInFlags
        /// </summary>
        [EnumMember(Value = ("DisabledInFlags"))]
        DisabledInFlags,
        /// <summary>
        /// ErrorFetchingSignin
        /// </summary>
        [EnumMember(Value = ("ErrorFetchingSignin"))]
        ErrorFetchingSignin,
        /// <summary>
        /// InvalidSigninResponse
        /// </summary>
        [EnumMember(Value = ("InvalidSigninResponse"))]
        InvalidSigninResponse,
        /// <summary>
        /// AccountsHttpNotFound
        /// </summary>
        [EnumMember(Value = ("AccountsHttpNotFound"))]
        AccountsHttpNotFound,
        /// <summary>
        /// AccountsNoResponse
        /// </summary>
        [EnumMember(Value = ("AccountsNoResponse"))]
        AccountsNoResponse,
        /// <summary>
        /// AccountsInvalidResponse
        /// </summary>
        [EnumMember(Value = ("AccountsInvalidResponse"))]
        AccountsInvalidResponse,
        /// <summary>
        /// AccountsListEmpty
        /// </summary>
        [EnumMember(Value = ("AccountsListEmpty"))]
        AccountsListEmpty,
        /// <summary>
        /// AccountsInvalidContentType
        /// </summary>
        [EnumMember(Value = ("AccountsInvalidContentType"))]
        AccountsInvalidContentType,
        /// <summary>
        /// IdTokenHttpNotFound
        /// </summary>
        [EnumMember(Value = ("IdTokenHttpNotFound"))]
        IdTokenHttpNotFound,
        /// <summary>
        /// IdTokenNoResponse
        /// </summary>
        [EnumMember(Value = ("IdTokenNoResponse"))]
        IdTokenNoResponse,
        /// <summary>
        /// IdTokenInvalidResponse
        /// </summary>
        [EnumMember(Value = ("IdTokenInvalidResponse"))]
        IdTokenInvalidResponse,
        /// <summary>
        /// IdTokenIdpErrorResponse
        /// </summary>
        [EnumMember(Value = ("IdTokenIdpErrorResponse"))]
        IdTokenIdpErrorResponse,
        /// <summary>
        /// IdTokenCrossSiteIdpErrorResponse
        /// </summary>
        [EnumMember(Value = ("IdTokenCrossSiteIdpErrorResponse"))]
        IdTokenCrossSiteIdpErrorResponse,
        /// <summary>
        /// IdTokenInvalidRequest
        /// </summary>
        [EnumMember(Value = ("IdTokenInvalidRequest"))]
        IdTokenInvalidRequest,
        /// <summary>
        /// IdTokenInvalidContentType
        /// </summary>
        [EnumMember(Value = ("IdTokenInvalidContentType"))]
        IdTokenInvalidContentType,
        /// <summary>
        /// ErrorIdToken
        /// </summary>
        [EnumMember(Value = ("ErrorIdToken"))]
        ErrorIdToken,
        /// <summary>
        /// Canceled
        /// </summary>
        [EnumMember(Value = ("Canceled"))]
        Canceled,
        /// <summary>
        /// RpPageNotVisible
        /// </summary>
        [EnumMember(Value = ("RpPageNotVisible"))]
        RpPageNotVisible,
        /// <summary>
        /// SilentMediationFailure
        /// </summary>
        [EnumMember(Value = ("SilentMediationFailure"))]
        SilentMediationFailure,
        /// <summary>
        /// ThirdPartyCookiesBlocked
        /// </summary>
        [EnumMember(Value = ("ThirdPartyCookiesBlocked"))]
        ThirdPartyCookiesBlocked,
        /// <summary>
        /// NotSignedInWithIdp
        /// </summary>
        [EnumMember(Value = ("NotSignedInWithIdp"))]
        NotSignedInWithIdp,
        /// <summary>
        /// MissingTransientUserActivation
        /// </summary>
        [EnumMember(Value = ("MissingTransientUserActivation"))]
        MissingTransientUserActivation,
        /// <summary>
        /// ReplacedByButtonMode
        /// </summary>
        [EnumMember(Value = ("ReplacedByButtonMode"))]
        ReplacedByButtonMode,
        /// <summary>
        /// InvalidFieldsSpecified
        /// </summary>
        [EnumMember(Value = ("InvalidFieldsSpecified"))]
        InvalidFieldsSpecified,
        /// <summary>
        /// RelyingPartyOriginIsOpaque
        /// </summary>
        [EnumMember(Value = ("RelyingPartyOriginIsOpaque"))]
        RelyingPartyOriginIsOpaque,
        /// <summary>
        /// TypeNotMatching
        /// </summary>
        [EnumMember(Value = ("TypeNotMatching"))]
        TypeNotMatching
    }

    /// <summary>
    /// FederatedAuthUserInfoRequestIssueDetails
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class FederatedAuthUserInfoRequestIssueDetails : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// FederatedAuthUserInfoRequestIssueReason
        /// </summary>
        public CefSharp.DevTools.Audits.FederatedAuthUserInfoRequestIssueReason FederatedAuthUserInfoRequestIssueReason
        {
            get
            {
                return (CefSharp.DevTools.Audits.FederatedAuthUserInfoRequestIssueReason)(StringToEnum(typeof(CefSharp.DevTools.Audits.FederatedAuthUserInfoRequestIssueReason), federatedAuthUserInfoRequestIssueReason));
            }

            set
            {
                this.federatedAuthUserInfoRequestIssueReason = (EnumToString(value));
            }
        }

        /// <summary>
        /// FederatedAuthUserInfoRequestIssueReason
        /// </summary>
        [DataMember(Name = ("federatedAuthUserInfoRequestIssueReason"), IsRequired = (true))]
        internal string federatedAuthUserInfoRequestIssueReason
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Represents the failure reason when a getUserInfo() call fails.
    /// Should be updated alongside FederatedAuthUserInfoRequestResult in
    /// third_party/blink/public/mojom/devtools/inspector_issue.mojom.
    /// </summary>
    public enum FederatedAuthUserInfoRequestIssueReason
    {
        /// <summary>
        /// NotSameOrigin
        /// </summary>
        [EnumMember(Value = ("NotSameOrigin"))]
        NotSameOrigin,
        /// <summary>
        /// NotIframe
        /// </summary>
        [EnumMember(Value = ("NotIframe"))]
        NotIframe,
        /// <summary>
        /// NotPotentiallyTrustworthy
        /// </summary>
        [EnumMember(Value = ("NotPotentiallyTrustworthy"))]
        NotPotentiallyTrustworthy,
        /// <summary>
        /// NoApiPermission
        /// </summary>
        [EnumMember(Value = ("NoApiPermission"))]
        NoApiPermission,
        /// <summary>
        /// NotSignedInWithIdp
        /// </summary>
        [EnumMember(Value = ("NotSignedInWithIdp"))]
        NotSignedInWithIdp,
        /// <summary>
        /// NoAccountSharingPermission
        /// </summary>
        [EnumMember(Value = ("NoAccountSharingPermission"))]
        NoAccountSharingPermission,
        /// <summary>
        /// InvalidConfigOrWellKnown
        /// </summary>
        [EnumMember(Value = ("InvalidConfigOrWellKnown"))]
        InvalidConfigOrWellKnown,
        /// <summary>
        /// InvalidAccountsResponse
        /// </summary>
        [EnumMember(Value = ("InvalidAccountsResponse"))]
        InvalidAccountsResponse,
        /// <summary>
        /// NoReturningUserFromFetchedAccounts
        /// </summary>
        [EnumMember(Value = ("NoReturningUserFromFetchedAccounts"))]
        NoReturningUserFromFetchedAccounts
    }

    /// <summary>
    /// This issue tracks client hints related issues. It&apos;s used to deprecate old
    /// features, encourage the use of new ones, and provide general guidance.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class ClientHintIssueDetails : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// SourceCodeLocation
        /// </summary>
        [DataMember(Name = ("sourceCodeLocation"), IsRequired = (true))]
        public CefSharp.DevTools.Audits.SourceCodeLocation SourceCodeLocation
        {
            get;
            set;
        }

        /// <summary>
        /// ClientHintIssueReason
        /// </summary>
        public CefSharp.DevTools.Audits.ClientHintIssueReason ClientHintIssueReason
        {
            get
            {
                return (CefSharp.DevTools.Audits.ClientHintIssueReason)(StringToEnum(typeof(CefSharp.DevTools.Audits.ClientHintIssueReason), clientHintIssueReason));
            }

            set
            {
                this.clientHintIssueReason = (EnumToString(value));
            }
        }

        /// <summary>
        /// ClientHintIssueReason
        /// </summary>
        [DataMember(Name = ("clientHintIssueReason"), IsRequired = (true))]
        internal string clientHintIssueReason
        {
            get;
            set;
        }
    }

    /// <summary>
    /// FailedRequestInfo
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class FailedRequestInfo : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The URL that failed to load.
        /// </summary>
        [DataMember(Name = ("url"), IsRequired = (true))]
        public string Url
        {
            get;
            set;
        }

        /// <summary>
        /// The failure message for the failed request.
        /// </summary>
        [DataMember(Name = ("failureMessage"), IsRequired = (true))]
        public string FailureMessage
        {
            get;
            set;
        }

        /// <summary>
        /// RequestId
        /// </summary>
        [DataMember(Name = ("requestId"), IsRequired = (false))]
        public string RequestId
        {
            get;
            set;
        }
    }

    /// <summary>
    /// StyleSheetLoadingIssueReason
    /// </summary>
    public enum StyleSheetLoadingIssueReason
    {
        /// <summary>
        /// LateImportRule
        /// </summary>
        [EnumMember(Value = ("LateImportRule"))]
        LateImportRule,
        /// <summary>
        /// RequestFailed
        /// </summary>
        [EnumMember(Value = ("RequestFailed"))]
        RequestFailed
    }

    /// <summary>
    /// This issue warns when a referenced stylesheet couldn&apos;t be loaded.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class StylesheetLoadingIssueDetails : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Source code position that referenced the failing stylesheet.
        /// </summary>
        [DataMember(Name = ("sourceCodeLocation"), IsRequired = (true))]
        public CefSharp.DevTools.Audits.SourceCodeLocation SourceCodeLocation
        {
            get;
            set;
        }

        /// <summary>
        /// Reason why the stylesheet couldn&apos;t be loaded.
        /// </summary>
        public CefSharp.DevTools.Audits.StyleSheetLoadingIssueReason StyleSheetLoadingIssueReason
        {
            get
            {
                return (CefSharp.DevTools.Audits.StyleSheetLoadingIssueReason)(StringToEnum(typeof(CefSharp.DevTools.Audits.StyleSheetLoadingIssueReason), styleSheetLoadingIssueReason));
            }

            set
            {
                this.styleSheetLoadingIssueReason = (EnumToString(value));
            }
        }

        /// <summary>
        /// Reason why the stylesheet couldn&apos;t be loaded.
        /// </summary>
        [DataMember(Name = ("styleSheetLoadingIssueReason"), IsRequired = (true))]
        internal string styleSheetLoadingIssueReason
        {
            get;
            set;
        }

        /// <summary>
        /// Contains additional info when the failure was due to a request.
        /// </summary>
        [DataMember(Name = ("failedRequestInfo"), IsRequired = (false))]
        public CefSharp.DevTools.Audits.FailedRequestInfo FailedRequestInfo
        {
            get;
            set;
        }
    }

    /// <summary>
    /// PropertyRuleIssueReason
    /// </summary>
    public enum PropertyRuleIssueReason
    {
        /// <summary>
        /// InvalidSyntax
        /// </summary>
        [EnumMember(Value = ("InvalidSyntax"))]
        InvalidSyntax,
        /// <summary>
        /// InvalidInitialValue
        /// </summary>
        [EnumMember(Value = ("InvalidInitialValue"))]
        InvalidInitialValue,
        /// <summary>
        /// InvalidInherits
        /// </summary>
        [EnumMember(Value = ("InvalidInherits"))]
        InvalidInherits,
        /// <summary>
        /// InvalidName
        /// </summary>
        [EnumMember(Value = ("InvalidName"))]
        InvalidName
    }

    /// <summary>
    /// This issue warns about errors in property rules that lead to property
    /// registrations being ignored.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class PropertyRuleIssueDetails : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Source code position of the property rule.
        /// </summary>
        [DataMember(Name = ("sourceCodeLocation"), IsRequired = (true))]
        public CefSharp.DevTools.Audits.SourceCodeLocation SourceCodeLocation
        {
            get;
            set;
        }

        /// <summary>
        /// Reason why the property rule was discarded.
        /// </summary>
        public CefSharp.DevTools.Audits.PropertyRuleIssueReason PropertyRuleIssueReason
        {
            get
            {
                return (CefSharp.DevTools.Audits.PropertyRuleIssueReason)(StringToEnum(typeof(CefSharp.DevTools.Audits.PropertyRuleIssueReason), propertyRuleIssueReason));
            }

            set
            {
                this.propertyRuleIssueReason = (EnumToString(value));
            }
        }

        /// <summary>
        /// Reason why the property rule was discarded.
        /// </summary>
        [DataMember(Name = ("propertyRuleIssueReason"), IsRequired = (true))]
        internal string propertyRuleIssueReason
        {
            get;
            set;
        }

        /// <summary>
        /// The value of the property rule property that failed to parse
        /// </summary>
        [DataMember(Name = ("propertyValue"), IsRequired = (false))]
        public string PropertyValue
        {
            get;
            set;
        }
    }

    /// <summary>
    /// A unique identifier for the type of issue. Each type may use one of the
    /// optional fields in InspectorIssueDetails to convey more specific
    /// information about the kind of issue.
    /// </summary>
    public enum InspectorIssueCode
    {
        /// <summary>
        /// CookieIssue
        /// </summary>
        [EnumMember(Value = ("CookieIssue"))]
        CookieIssue,
        /// <summary>
        /// MixedContentIssue
        /// </summary>
        [EnumMember(Value = ("MixedContentIssue"))]
        MixedContentIssue,
        /// <summary>
        /// BlockedByResponseIssue
        /// </summary>
        [EnumMember(Value = ("BlockedByResponseIssue"))]
        BlockedByResponseIssue,
        /// <summary>
        /// HeavyAdIssue
        /// </summary>
        [EnumMember(Value = ("HeavyAdIssue"))]
        HeavyAdIssue,
        /// <summary>
        /// ContentSecurityPolicyIssue
        /// </summary>
        [EnumMember(Value = ("ContentSecurityPolicyIssue"))]
        ContentSecurityPolicyIssue,
        /// <summary>
        /// SharedArrayBufferIssue
        /// </summary>
        [EnumMember(Value = ("SharedArrayBufferIssue"))]
        SharedArrayBufferIssue,
        /// <summary>
        /// LowTextContrastIssue
        /// </summary>
        [EnumMember(Value = ("LowTextContrastIssue"))]
        LowTextContrastIssue,
        /// <summary>
        /// CorsIssue
        /// </summary>
        [EnumMember(Value = ("CorsIssue"))]
        CorsIssue,
        /// <summary>
        /// AttributionReportingIssue
        /// </summary>
        [EnumMember(Value = ("AttributionReportingIssue"))]
        AttributionReportingIssue,
        /// <summary>
        /// QuirksModeIssue
        /// </summary>
        [EnumMember(Value = ("QuirksModeIssue"))]
        QuirksModeIssue,
        /// <summary>
        /// NavigatorUserAgentIssue
        /// </summary>
        [EnumMember(Value = ("NavigatorUserAgentIssue"))]
        NavigatorUserAgentIssue,
        /// <summary>
        /// GenericIssue
        /// </summary>
        [EnumMember(Value = ("GenericIssue"))]
        GenericIssue,
        /// <summary>
        /// DeprecationIssue
        /// </summary>
        [EnumMember(Value = ("DeprecationIssue"))]
        DeprecationIssue,
        /// <summary>
        /// ClientHintIssue
        /// </summary>
        [EnumMember(Value = ("ClientHintIssue"))]
        ClientHintIssue,
        /// <summary>
        /// FederatedAuthRequestIssue
        /// </summary>
        [EnumMember(Value = ("FederatedAuthRequestIssue"))]
        FederatedAuthRequestIssue,
        /// <summary>
        /// BounceTrackingIssue
        /// </summary>
        [EnumMember(Value = ("BounceTrackingIssue"))]
        BounceTrackingIssue,
        /// <summary>
        /// CookieDeprecationMetadataIssue
        /// </summary>
        [EnumMember(Value = ("CookieDeprecationMetadataIssue"))]
        CookieDeprecationMetadataIssue,
        /// <summary>
        /// StylesheetLoadingIssue
        /// </summary>
        [EnumMember(Value = ("StylesheetLoadingIssue"))]
        StylesheetLoadingIssue,
        /// <summary>
        /// FederatedAuthUserInfoRequestIssue
        /// </summary>
        [EnumMember(Value = ("FederatedAuthUserInfoRequestIssue"))]
        FederatedAuthUserInfoRequestIssue,
        /// <summary>
        /// PropertyRuleIssue
        /// </summary>
        [EnumMember(Value = ("PropertyRuleIssue"))]
        PropertyRuleIssue,
        /// <summary>
        /// SharedDictionaryIssue
        /// </summary>
        [EnumMember(Value = ("SharedDictionaryIssue"))]
        SharedDictionaryIssue
    }

    /// <summary>
    /// This struct holds a list of optional fields with additional information
    /// specific to the kind of issue. When adding a new issue code, please also
    /// add a new optional field to this type.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class InspectorIssueDetails : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// CookieIssueDetails
        /// </summary>
        [DataMember(Name = ("cookieIssueDetails"), IsRequired = (false))]
        public CefSharp.DevTools.Audits.CookieIssueDetails CookieIssueDetails
        {
            get;
            set;
        }

        /// <summary>
        /// MixedContentIssueDetails
        /// </summary>
        [DataMember(Name = ("mixedContentIssueDetails"), IsRequired = (false))]
        public CefSharp.DevTools.Audits.MixedContentIssueDetails MixedContentIssueDetails
        {
            get;
            set;
        }

        /// <summary>
        /// BlockedByResponseIssueDetails
        /// </summary>
        [DataMember(Name = ("blockedByResponseIssueDetails"), IsRequired = (false))]
        public CefSharp.DevTools.Audits.BlockedByResponseIssueDetails BlockedByResponseIssueDetails
        {
            get;
            set;
        }

        /// <summary>
        /// HeavyAdIssueDetails
        /// </summary>
        [DataMember(Name = ("heavyAdIssueDetails"), IsRequired = (false))]
        public CefSharp.DevTools.Audits.HeavyAdIssueDetails HeavyAdIssueDetails
        {
            get;
            set;
        }

        /// <summary>
        /// ContentSecurityPolicyIssueDetails
        /// </summary>
        [DataMember(Name = ("contentSecurityPolicyIssueDetails"), IsRequired = (false))]
        public CefSharp.DevTools.Audits.ContentSecurityPolicyIssueDetails ContentSecurityPolicyIssueDetails
        {
            get;
            set;
        }

        /// <summary>
        /// SharedArrayBufferIssueDetails
        /// </summary>
        [DataMember(Name = ("sharedArrayBufferIssueDetails"), IsRequired = (false))]
        public CefSharp.DevTools.Audits.SharedArrayBufferIssueDetails SharedArrayBufferIssueDetails
        {
            get;
            set;
        }

        /// <summary>
        /// LowTextContrastIssueDetails
        /// </summary>
        [DataMember(Name = ("lowTextContrastIssueDetails"), IsRequired = (false))]
        public CefSharp.DevTools.Audits.LowTextContrastIssueDetails LowTextContrastIssueDetails
        {
            get;
            set;
        }

        /// <summary>
        /// CorsIssueDetails
        /// </summary>
        [DataMember(Name = ("corsIssueDetails"), IsRequired = (false))]
        public CefSharp.DevTools.Audits.CorsIssueDetails CorsIssueDetails
        {
            get;
            set;
        }

        /// <summary>
        /// AttributionReportingIssueDetails
        /// </summary>
        [DataMember(Name = ("attributionReportingIssueDetails"), IsRequired = (false))]
        public CefSharp.DevTools.Audits.AttributionReportingIssueDetails AttributionReportingIssueDetails
        {
            get;
            set;
        }

        /// <summary>
        /// QuirksModeIssueDetails
        /// </summary>
        [DataMember(Name = ("quirksModeIssueDetails"), IsRequired = (false))]
        public CefSharp.DevTools.Audits.QuirksModeIssueDetails QuirksModeIssueDetails
        {
            get;
            set;
        }

        /// <summary>
        /// NavigatorUserAgentIssueDetails
        /// </summary>
        [DataMember(Name = ("navigatorUserAgentIssueDetails"), IsRequired = (false))]
        public CefSharp.DevTools.Audits.NavigatorUserAgentIssueDetails NavigatorUserAgentIssueDetails
        {
            get;
            set;
        }

        /// <summary>
        /// GenericIssueDetails
        /// </summary>
        [DataMember(Name = ("genericIssueDetails"), IsRequired = (false))]
        public CefSharp.DevTools.Audits.GenericIssueDetails GenericIssueDetails
        {
            get;
            set;
        }

        /// <summary>
        /// DeprecationIssueDetails
        /// </summary>
        [DataMember(Name = ("deprecationIssueDetails"), IsRequired = (false))]
        public CefSharp.DevTools.Audits.DeprecationIssueDetails DeprecationIssueDetails
        {
            get;
            set;
        }

        /// <summary>
        /// ClientHintIssueDetails
        /// </summary>
        [DataMember(Name = ("clientHintIssueDetails"), IsRequired = (false))]
        public CefSharp.DevTools.Audits.ClientHintIssueDetails ClientHintIssueDetails
        {
            get;
            set;
        }

        /// <summary>
        /// FederatedAuthRequestIssueDetails
        /// </summary>
        [DataMember(Name = ("federatedAuthRequestIssueDetails"), IsRequired = (false))]
        public CefSharp.DevTools.Audits.FederatedAuthRequestIssueDetails FederatedAuthRequestIssueDetails
        {
            get;
            set;
        }

        /// <summary>
        /// BounceTrackingIssueDetails
        /// </summary>
        [DataMember(Name = ("bounceTrackingIssueDetails"), IsRequired = (false))]
        public CefSharp.DevTools.Audits.BounceTrackingIssueDetails BounceTrackingIssueDetails
        {
            get;
            set;
        }

        /// <summary>
        /// CookieDeprecationMetadataIssueDetails
        /// </summary>
        [DataMember(Name = ("cookieDeprecationMetadataIssueDetails"), IsRequired = (false))]
        public CefSharp.DevTools.Audits.CookieDeprecationMetadataIssueDetails CookieDeprecationMetadataIssueDetails
        {
            get;
            set;
        }

        /// <summary>
        /// StylesheetLoadingIssueDetails
        /// </summary>
        [DataMember(Name = ("stylesheetLoadingIssueDetails"), IsRequired = (false))]
        public CefSharp.DevTools.Audits.StylesheetLoadingIssueDetails StylesheetLoadingIssueDetails
        {
            get;
            set;
        }

        /// <summary>
        /// PropertyRuleIssueDetails
        /// </summary>
        [DataMember(Name = ("propertyRuleIssueDetails"), IsRequired = (false))]
        public CefSharp.DevTools.Audits.PropertyRuleIssueDetails PropertyRuleIssueDetails
        {
            get;
            set;
        }

        /// <summary>
        /// FederatedAuthUserInfoRequestIssueDetails
        /// </summary>
        [DataMember(Name = ("federatedAuthUserInfoRequestIssueDetails"), IsRequired = (false))]
        public CefSharp.DevTools.Audits.FederatedAuthUserInfoRequestIssueDetails FederatedAuthUserInfoRequestIssueDetails
        {
            get;
            set;
        }

        /// <summary>
        /// SharedDictionaryIssueDetails
        /// </summary>
        [DataMember(Name = ("sharedDictionaryIssueDetails"), IsRequired = (false))]
        public CefSharp.DevTools.Audits.SharedDictionaryIssueDetails SharedDictionaryIssueDetails
        {
            get;
            set;
        }
    }

    /// <summary>
    /// An inspector issue reported from the back-end.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class InspectorIssue : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Code
        /// </summary>
        public CefSharp.DevTools.Audits.InspectorIssueCode Code
        {
            get
            {
                return (CefSharp.DevTools.Audits.InspectorIssueCode)(StringToEnum(typeof(CefSharp.DevTools.Audits.InspectorIssueCode), code));
            }

            set
            {
                this.code = (EnumToString(value));
            }
        }

        /// <summary>
        /// Code
        /// </summary>
        [DataMember(Name = ("code"), IsRequired = (true))]
        internal string code
        {
            get;
            set;
        }

        /// <summary>
        /// Details
        /// </summary>
        [DataMember(Name = ("details"), IsRequired = (true))]
        public CefSharp.DevTools.Audits.InspectorIssueDetails Details
        {
            get;
            set;
        }

        /// <summary>
        /// A unique id for this issue. May be omitted if no other entity (e.g.
        /// exception, CDP message, etc.) is referencing this issue.
        /// </summary>
        [DataMember(Name = ("issueId"), IsRequired = (false))]
        public string IssueId
        {
            get;
            set;
        }
    }

    /// <summary>
    /// issueAdded
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class IssueAddedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Issue
        /// </summary>
        [DataMember(Name = ("issue"), IsRequired = (true))]
        public CefSharp.DevTools.Audits.InspectorIssue Issue
        {
            get;
            private set;
        }
    }
}

namespace CefSharp.DevTools.Extensions
{
    /// <summary>
    /// Storage areas.
    /// </summary>
    public enum StorageArea
    {
        /// <summary>
        /// session
        /// </summary>
        [EnumMember(Value = ("session"))]
        Session,
        /// <summary>
        /// local
        /// </summary>
        [EnumMember(Value = ("local"))]
        Local,
        /// <summary>
        /// sync
        /// </summary>
        [EnumMember(Value = ("sync"))]
        Sync,
        /// <summary>
        /// managed
        /// </summary>
        [EnumMember(Value = ("managed"))]
        Managed
    }
}

namespace CefSharp.DevTools.Autofill
{
    /// <summary>
    /// CreditCard
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class CreditCard : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// 16-digit credit card number.
        /// </summary>
        [DataMember(Name = ("number"), IsRequired = (true))]
        public string Number
        {
            get;
            set;
        }

        /// <summary>
        /// Name of the credit card owner.
        /// </summary>
        [DataMember(Name = ("name"), IsRequired = (true))]
        public string Name
        {
            get;
            set;
        }

        /// <summary>
        /// 2-digit expiry month.
        /// </summary>
        [DataMember(Name = ("expiryMonth"), IsRequired = (true))]
        public string ExpiryMonth
        {
            get;
            set;
        }

        /// <summary>
        /// 4-digit expiry year.
        /// </summary>
        [DataMember(Name = ("expiryYear"), IsRequired = (true))]
        public string ExpiryYear
        {
            get;
            set;
        }

        /// <summary>
        /// 3-digit card verification code.
        /// </summary>
        [DataMember(Name = ("cvc"), IsRequired = (true))]
        public string Cvc
        {
            get;
            set;
        }
    }

    /// <summary>
    /// AddressField
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class AddressField : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// address field name, for example GIVEN_NAME.
        /// </summary>
        [DataMember(Name = ("name"), IsRequired = (true))]
        public string Name
        {
            get;
            set;
        }

        /// <summary>
        /// address field value, for example Jon Doe.
        /// </summary>
        [DataMember(Name = ("value"), IsRequired = (true))]
        public string Value
        {
            get;
            set;
        }
    }

    /// <summary>
    /// A list of address fields.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class AddressFields : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Fields
        /// </summary>
        [DataMember(Name = ("fields"), IsRequired = (true))]
        public System.Collections.Generic.IList<CefSharp.DevTools.Autofill.AddressField> Fields
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Address
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class Address : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// fields and values defining an address.
        /// </summary>
        [DataMember(Name = ("fields"), IsRequired = (true))]
        public System.Collections.Generic.IList<CefSharp.DevTools.Autofill.AddressField> Fields
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Defines how an address can be displayed like in chrome://settings/addresses.
    /// Address UI is a two dimensional array, each inner array is an &quot;address information line&quot;, and when rendered in a UI surface should be displayed as such.
    /// The following address UI for instance:
    /// [[{name: &quot;GIVE_NAME&quot;, value: &quot;Jon&quot;}, {name: &quot;FAMILY_NAME&quot;, value: &quot;Doe&quot;}], [{name: &quot;CITY&quot;, value: &quot;Munich&quot;}, {name: &quot;ZIP&quot;, value: &quot;81456&quot;}]]
    /// should allow the receiver to render:
    /// Jon Doe
    /// Munich 81456
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class AddressUI : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// A two dimension array containing the representation of values from an address profile.
        /// </summary>
        [DataMember(Name = ("addressFields"), IsRequired = (true))]
        public System.Collections.Generic.IList<CefSharp.DevTools.Autofill.AddressFields> AddressFields
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Specified whether a filled field was done so by using the html autocomplete attribute or autofill heuristics.
    /// </summary>
    public enum FillingStrategy
    {
        /// <summary>
        /// autocompleteAttribute
        /// </summary>
        [EnumMember(Value = ("autocompleteAttribute"))]
        AutocompleteAttribute,
        /// <summary>
        /// autofillInferred
        /// </summary>
        [EnumMember(Value = ("autofillInferred"))]
        AutofillInferred
    }

    /// <summary>
    /// FilledField
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class FilledField : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The type of the field, e.g text, password etc.
        /// </summary>
        [DataMember(Name = ("htmlType"), IsRequired = (true))]
        public string HtmlType
        {
            get;
            set;
        }

        /// <summary>
        /// the html id
        /// </summary>
        [DataMember(Name = ("id"), IsRequired = (true))]
        public string Id
        {
            get;
            set;
        }

        /// <summary>
        /// the html name
        /// </summary>
        [DataMember(Name = ("name"), IsRequired = (true))]
        public string Name
        {
            get;
            set;
        }

        /// <summary>
        /// the field value
        /// </summary>
        [DataMember(Name = ("value"), IsRequired = (true))]
        public string Value
        {
            get;
            set;
        }

        /// <summary>
        /// The actual field type, e.g FAMILY_NAME
        /// </summary>
        [DataMember(Name = ("autofillType"), IsRequired = (true))]
        public string AutofillType
        {
            get;
            set;
        }

        /// <summary>
        /// The filling strategy
        /// </summary>
        public CefSharp.DevTools.Autofill.FillingStrategy FillingStrategy
        {
            get
            {
                return (CefSharp.DevTools.Autofill.FillingStrategy)(StringToEnum(typeof(CefSharp.DevTools.Autofill.FillingStrategy), fillingStrategy));
            }

            set
            {
                this.fillingStrategy = (EnumToString(value));
            }
        }

        /// <summary>
        /// The filling strategy
        /// </summary>
        [DataMember(Name = ("fillingStrategy"), IsRequired = (true))]
        internal string fillingStrategy
        {
            get;
            set;
        }

        /// <summary>
        /// The frame the field belongs to
        /// </summary>
        [DataMember(Name = ("frameId"), IsRequired = (true))]
        public string FrameId
        {
            get;
            set;
        }

        /// <summary>
        /// The form field&apos;s DOM node
        /// </summary>
        [DataMember(Name = ("fieldId"), IsRequired = (true))]
        public int FieldId
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Emitted when an address form is filled.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class AddressFormFilledEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Information about the fields that were filled
        /// </summary>
        [DataMember(Name = ("filledFields"), IsRequired = (true))]
        public System.Collections.Generic.IList<CefSharp.DevTools.Autofill.FilledField> FilledFields
        {
            get;
            private set;
        }

        /// <summary>
        /// An UI representation of the address used to fill the form.
        /// Consists of a 2D array where each child represents an address/profile line.
        /// </summary>
        [DataMember(Name = ("addressUi"), IsRequired = (true))]
        public CefSharp.DevTools.Autofill.AddressUI AddressUi
        {
            get;
            private set;
        }
    }
}

namespace CefSharp.DevTools.BackgroundService
{
    /// <summary>
    /// The Background Service that will be associated with the commands/events.
    /// Every Background Service operates independently, but they share the same
    /// API.
    /// </summary>
    public enum ServiceName
    {
        /// <summary>
        /// backgroundFetch
        /// </summary>
        [EnumMember(Value = ("backgroundFetch"))]
        BackgroundFetch,
        /// <summary>
        /// backgroundSync
        /// </summary>
        [EnumMember(Value = ("backgroundSync"))]
        BackgroundSync,
        /// <summary>
        /// pushMessaging
        /// </summary>
        [EnumMember(Value = ("pushMessaging"))]
        PushMessaging,
        /// <summary>
        /// notifications
        /// </summary>
        [EnumMember(Value = ("notifications"))]
        Notifications,
        /// <summary>
        /// paymentHandler
        /// </summary>
        [EnumMember(Value = ("paymentHandler"))]
        PaymentHandler,
        /// <summary>
        /// periodicBackgroundSync
        /// </summary>
        [EnumMember(Value = ("periodicBackgroundSync"))]
        PeriodicBackgroundSync
    }

    /// <summary>
    /// A key-value pair for additional event information to pass along.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class EventMetadata : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Key
        /// </summary>
        [DataMember(Name = ("key"), IsRequired = (true))]
        public string Key
        {
            get;
            set;
        }

        /// <summary>
        /// Value
        /// </summary>
        [DataMember(Name = ("value"), IsRequired = (true))]
        public string Value
        {
            get;
            set;
        }
    }

    /// <summary>
    /// BackgroundServiceEvent
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class BackgroundServiceEvent : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Timestamp of the event (in seconds).
        /// </summary>
        [DataMember(Name = ("timestamp"), IsRequired = (true))]
        public double Timestamp
        {
            get;
            set;
        }

        /// <summary>
        /// The origin this event belongs to.
        /// </summary>
        [DataMember(Name = ("origin"), IsRequired = (true))]
        public string Origin
        {
            get;
            set;
        }

        /// <summary>
        /// The Service Worker ID that initiated the event.
        /// </summary>
        [DataMember(Name = ("serviceWorkerRegistrationId"), IsRequired = (true))]
        public string ServiceWorkerRegistrationId
        {
            get;
            set;
        }

        /// <summary>
        /// The Background Service this event belongs to.
        /// </summary>
        public CefSharp.DevTools.BackgroundService.ServiceName Service
        {
            get
            {
                return (CefSharp.DevTools.BackgroundService.ServiceName)(StringToEnum(typeof(CefSharp.DevTools.BackgroundService.ServiceName), service));
            }

            set
            {
                this.service = (EnumToString(value));
            }
        }

        /// <summary>
        /// The Background Service this event belongs to.
        /// </summary>
        [DataMember(Name = ("service"), IsRequired = (true))]
        internal string service
        {
            get;
            set;
        }

        /// <summary>
        /// A description of the event.
        /// </summary>
        [DataMember(Name = ("eventName"), IsRequired = (true))]
        public string EventName
        {
            get;
            set;
        }

        /// <summary>
        /// An identifier that groups related events together.
        /// </summary>
        [DataMember(Name = ("instanceId"), IsRequired = (true))]
        public string InstanceId
        {
            get;
            set;
        }

        /// <summary>
        /// A list of event-specific information.
        /// </summary>
        [DataMember(Name = ("eventMetadata"), IsRequired = (true))]
        public System.Collections.Generic.IList<CefSharp.DevTools.BackgroundService.EventMetadata> EventMetadata
        {
            get;
            set;
        }

        /// <summary>
        /// Storage key this event belongs to.
        /// </summary>
        [DataMember(Name = ("storageKey"), IsRequired = (true))]
        public string StorageKey
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Called when the recording state for the service has been updated.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class RecordingStateChangedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// IsRecording
        /// </summary>
        [DataMember(Name = ("isRecording"), IsRequired = (true))]
        public bool IsRecording
        {
            get;
            private set;
        }

        /// <summary>
        /// Service
        /// </summary>
        public CefSharp.DevTools.BackgroundService.ServiceName Service
        {
            get
            {
                return (CefSharp.DevTools.BackgroundService.ServiceName)(StringToEnum(typeof(CefSharp.DevTools.BackgroundService.ServiceName), service));
            }

            set
            {
                this.service = (EnumToString(value));
            }
        }

        /// <summary>
        /// Service
        /// </summary>
        [DataMember(Name = ("service"), IsRequired = (true))]
        internal string service
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Called with all existing backgroundServiceEvents when enabled, and all new
    /// events afterwards if enabled and recording.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class BackgroundServiceEventReceivedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// BackgroundServiceEvent
        /// </summary>
        [DataMember(Name = ("backgroundServiceEvent"), IsRequired = (true))]
        public CefSharp.DevTools.BackgroundService.BackgroundServiceEvent BackgroundServiceEvent
        {
            get;
            private set;
        }
    }
}

namespace CefSharp.DevTools.Browser
{
    /// <summary>
    /// The state of the browser window.
    /// </summary>
    public enum WindowState
    {
        /// <summary>
        /// normal
        /// </summary>
        [EnumMember(Value = ("normal"))]
        Normal,
        /// <summary>
        /// minimized
        /// </summary>
        [EnumMember(Value = ("minimized"))]
        Minimized,
        /// <summary>
        /// maximized
        /// </summary>
        [EnumMember(Value = ("maximized"))]
        Maximized,
        /// <summary>
        /// fullscreen
        /// </summary>
        [EnumMember(Value = ("fullscreen"))]
        Fullscreen
    }

    /// <summary>
    /// Browser window bounds information
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class Bounds : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The offset from the left edge of the screen to the window in pixels.
        /// </summary>
        [DataMember(Name = ("left"), IsRequired = (false))]
        public int? Left
        {
            get;
            set;
        }

        /// <summary>
        /// The offset from the top edge of the screen to the window in pixels.
        /// </summary>
        [DataMember(Name = ("top"), IsRequired = (false))]
        public int? Top
        {
            get;
            set;
        }

        /// <summary>
        /// The window width in pixels.
        /// </summary>
        [DataMember(Name = ("width"), IsRequired = (false))]
        public int? Width
        {
            get;
            set;
        }

        /// <summary>
        /// The window height in pixels.
        /// </summary>
        [DataMember(Name = ("height"), IsRequired = (false))]
        public int? Height
        {
            get;
            set;
        }

        /// <summary>
        /// The window state. Default to normal.
        /// </summary>
        public CefSharp.DevTools.Browser.WindowState? WindowState
        {
            get
            {
                return (CefSharp.DevTools.Browser.WindowState? )(StringToEnum(typeof(CefSharp.DevTools.Browser.WindowState? ), windowState));
            }

            set
            {
                this.windowState = (EnumToString(value));
            }
        }

        /// <summary>
        /// The window state. Default to normal.
        /// </summary>
        [DataMember(Name = ("windowState"), IsRequired = (false))]
        internal string windowState
        {
            get;
            set;
        }
    }

    /// <summary>
    /// PermissionType
    /// </summary>
    public enum PermissionType
    {
        /// <summary>
        /// accessibilityEvents
        /// </summary>
        [EnumMember(Value = ("accessibilityEvents"))]
        AccessibilityEvents,
        /// <summary>
        /// audioCapture
        /// </summary>
        [EnumMember(Value = ("audioCapture"))]
        AudioCapture,
        /// <summary>
        /// backgroundSync
        /// </summary>
        [EnumMember(Value = ("backgroundSync"))]
        BackgroundSync,
        /// <summary>
        /// backgroundFetch
        /// </summary>
        [EnumMember(Value = ("backgroundFetch"))]
        BackgroundFetch,
        /// <summary>
        /// capturedSurfaceControl
        /// </summary>
        [EnumMember(Value = ("capturedSurfaceControl"))]
        CapturedSurfaceControl,
        /// <summary>
        /// clipboardReadWrite
        /// </summary>
        [EnumMember(Value = ("clipboardReadWrite"))]
        ClipboardReadWrite,
        /// <summary>
        /// clipboardSanitizedWrite
        /// </summary>
        [EnumMember(Value = ("clipboardSanitizedWrite"))]
        ClipboardSanitizedWrite,
        /// <summary>
        /// displayCapture
        /// </summary>
        [EnumMember(Value = ("displayCapture"))]
        DisplayCapture,
        /// <summary>
        /// durableStorage
        /// </summary>
        [EnumMember(Value = ("durableStorage"))]
        DurableStorage,
        /// <summary>
        /// flash
        /// </summary>
        [EnumMember(Value = ("flash"))]
        Flash,
        /// <summary>
        /// geolocation
        /// </summary>
        [EnumMember(Value = ("geolocation"))]
        Geolocation,
        /// <summary>
        /// idleDetection
        /// </summary>
        [EnumMember(Value = ("idleDetection"))]
        IdleDetection,
        /// <summary>
        /// localFonts
        /// </summary>
        [EnumMember(Value = ("localFonts"))]
        LocalFonts,
        /// <summary>
        /// midi
        /// </summary>
        [EnumMember(Value = ("midi"))]
        Midi,
        /// <summary>
        /// midiSysex
        /// </summary>
        [EnumMember(Value = ("midiSysex"))]
        MidiSysex,
        /// <summary>
        /// nfc
        /// </summary>
        [EnumMember(Value = ("nfc"))]
        Nfc,
        /// <summary>
        /// notifications
        /// </summary>
        [EnumMember(Value = ("notifications"))]
        Notifications,
        /// <summary>
        /// paymentHandler
        /// </summary>
        [EnumMember(Value = ("paymentHandler"))]
        PaymentHandler,
        /// <summary>
        /// periodicBackgroundSync
        /// </summary>
        [EnumMember(Value = ("periodicBackgroundSync"))]
        PeriodicBackgroundSync,
        /// <summary>
        /// protectedMediaIdentifier
        /// </summary>
        [EnumMember(Value = ("protectedMediaIdentifier"))]
        ProtectedMediaIdentifier,
        /// <summary>
        /// sensors
        /// </summary>
        [EnumMember(Value = ("sensors"))]
        Sensors,
        /// <summary>
        /// storageAccess
        /// </summary>
        [EnumMember(Value = ("storageAccess"))]
        StorageAccess,
        /// <summary>
        /// speakerSelection
        /// </summary>
        [EnumMember(Value = ("speakerSelection"))]
        SpeakerSelection,
        /// <summary>
        /// topLevelStorageAccess
        /// </summary>
        [EnumMember(Value = ("topLevelStorageAccess"))]
        TopLevelStorageAccess,
        /// <summary>
        /// videoCapture
        /// </summary>
        [EnumMember(Value = ("videoCapture"))]
        VideoCapture,
        /// <summary>
        /// videoCapturePanTiltZoom
        /// </summary>
        [EnumMember(Value = ("videoCapturePanTiltZoom"))]
        VideoCapturePanTiltZoom,
        /// <summary>
        /// wakeLockScreen
        /// </summary>
        [EnumMember(Value = ("wakeLockScreen"))]
        WakeLockScreen,
        /// <summary>
        /// wakeLockSystem
        /// </summary>
        [EnumMember(Value = ("wakeLockSystem"))]
        WakeLockSystem,
        /// <summary>
        /// windowManagement
        /// </summary>
        [EnumMember(Value = ("windowManagement"))]
        WindowManagement
    }

    /// <summary>
    /// PermissionSetting
    /// </summary>
    public enum PermissionSetting
    {
        /// <summary>
        /// granted
        /// </summary>
        [EnumMember(Value = ("granted"))]
        Granted,
        /// <summary>
        /// denied
        /// </summary>
        [EnumMember(Value = ("denied"))]
        Denied,
        /// <summary>
        /// prompt
        /// </summary>
        [EnumMember(Value = ("prompt"))]
        Prompt
    }

    /// <summary>
    /// Definition of PermissionDescriptor defined in the Permissions API:
    /// https://w3c.github.io/permissions/#dom-permissiondescriptor.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class PermissionDescriptor : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Name of permission.
        /// See https://cs.chromium.org/chromium/src/third_party/blink/renderer/modules/permissions/permission_descriptor.idl for valid permission names.
        /// </summary>
        [DataMember(Name = ("name"), IsRequired = (true))]
        public string Name
        {
            get;
            set;
        }

        /// <summary>
        /// For &quot;midi&quot; permission, may also specify sysex control.
        /// </summary>
        [DataMember(Name = ("sysex"), IsRequired = (false))]
        public bool? Sysex
        {
            get;
            set;
        }

        /// <summary>
        /// For &quot;push&quot; permission, may specify userVisibleOnly.
        /// Note that userVisibleOnly = true is the only currently supported type.
        /// </summary>
        [DataMember(Name = ("userVisibleOnly"), IsRequired = (false))]
        public bool? UserVisibleOnly
        {
            get;
            set;
        }

        /// <summary>
        /// For &quot;clipboard&quot; permission, may specify allowWithoutSanitization.
        /// </summary>
        [DataMember(Name = ("allowWithoutSanitization"), IsRequired = (false))]
        public bool? AllowWithoutSanitization
        {
            get;
            set;
        }

        /// <summary>
        /// For &quot;fullscreen&quot; permission, must specify allowWithoutGesture:true.
        /// </summary>
        [DataMember(Name = ("allowWithoutGesture"), IsRequired = (false))]
        public bool? AllowWithoutGesture
        {
            get;
            set;
        }

        /// <summary>
        /// For &quot;camera&quot; permission, may specify panTiltZoom.
        /// </summary>
        [DataMember(Name = ("panTiltZoom"), IsRequired = (false))]
        public bool? PanTiltZoom
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Browser command ids used by executeBrowserCommand.
    /// </summary>
    public enum BrowserCommandId
    {
        /// <summary>
        /// openTabSearch
        /// </summary>
        [EnumMember(Value = ("openTabSearch"))]
        OpenTabSearch,
        /// <summary>
        /// closeTabSearch
        /// </summary>
        [EnumMember(Value = ("closeTabSearch"))]
        CloseTabSearch
    }

    /// <summary>
    /// Chrome histogram bucket.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class Bucket : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Minimum value (inclusive).
        /// </summary>
        [DataMember(Name = ("low"), IsRequired = (true))]
        public int Low
        {
            get;
            set;
        }

        /// <summary>
        /// Maximum value (exclusive).
        /// </summary>
        [DataMember(Name = ("high"), IsRequired = (true))]
        public int High
        {
            get;
            set;
        }

        /// <summary>
        /// Number of samples.
        /// </summary>
        [DataMember(Name = ("count"), IsRequired = (true))]
        public int Count
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Chrome histogram.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class Histogram : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Name.
        /// </summary>
        [DataMember(Name = ("name"), IsRequired = (true))]
        public string Name
        {
            get;
            set;
        }

        /// <summary>
        /// Sum of sample values.
        /// </summary>
        [DataMember(Name = ("sum"), IsRequired = (true))]
        public int Sum
        {
            get;
            set;
        }

        /// <summary>
        /// Total number of samples.
        /// </summary>
        [DataMember(Name = ("count"), IsRequired = (true))]
        public int Count
        {
            get;
            set;
        }

        /// <summary>
        /// Buckets.
        /// </summary>
        [DataMember(Name = ("buckets"), IsRequired = (true))]
        public System.Collections.Generic.IList<CefSharp.DevTools.Browser.Bucket> Buckets
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Fired when page is about to start a download.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class DownloadWillBeginEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Id of the frame that caused the download to begin.
        /// </summary>
        [DataMember(Name = ("frameId"), IsRequired = (true))]
        public string FrameId
        {
            get;
            private set;
        }

        /// <summary>
        /// Global unique identifier of the download.
        /// </summary>
        [DataMember(Name = ("guid"), IsRequired = (true))]
        public string Guid
        {
            get;
            private set;
        }

        /// <summary>
        /// URL of the resource being downloaded.
        /// </summary>
        [DataMember(Name = ("url"), IsRequired = (true))]
        public string Url
        {
            get;
            private set;
        }

        /// <summary>
        /// Suggested file name of the resource (the actual name of the file saved on disk may differ).
        /// </summary>
        [DataMember(Name = ("suggestedFilename"), IsRequired = (true))]
        public string SuggestedFilename
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Download status.
    /// </summary>
    public enum DownloadProgressState
    {
        /// <summary>
        /// inProgress
        /// </summary>
        [EnumMember(Value = ("inProgress"))]
        InProgress,
        /// <summary>
        /// completed
        /// </summary>
        [EnumMember(Value = ("completed"))]
        Completed,
        /// <summary>
        /// canceled
        /// </summary>
        [EnumMember(Value = ("canceled"))]
        Canceled
    }

    /// <summary>
    /// Fired when download makes progress. Last call has |done| == true.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class DownloadProgressEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Global unique identifier of the download.
        /// </summary>
        [DataMember(Name = ("guid"), IsRequired = (true))]
        public string Guid
        {
            get;
            private set;
        }

        /// <summary>
        /// Total expected bytes to download.
        /// </summary>
        [DataMember(Name = ("totalBytes"), IsRequired = (true))]
        public double TotalBytes
        {
            get;
            private set;
        }

        /// <summary>
        /// Total bytes received.
        /// </summary>
        [DataMember(Name = ("receivedBytes"), IsRequired = (true))]
        public double ReceivedBytes
        {
            get;
            private set;
        }

        /// <summary>
        /// Download status.
        /// </summary>
        public CefSharp.DevTools.Browser.DownloadProgressState State
        {
            get
            {
                return (CefSharp.DevTools.Browser.DownloadProgressState)(StringToEnum(typeof(CefSharp.DevTools.Browser.DownloadProgressState), state));
            }

            set
            {
                this.state = (EnumToString(value));
            }
        }

        /// <summary>
        /// Download status.
        /// </summary>
        [DataMember(Name = ("state"), IsRequired = (true))]
        internal string state
        {
            get;
            private set;
        }
    }
}

namespace CefSharp.DevTools.CSS
{
    /// <summary>
    /// Stylesheet type: &quot;injected&quot; for stylesheets injected via extension, &quot;user-agent&quot; for user-agent
    /// stylesheets, &quot;inspector&quot; for stylesheets created by the inspector (i.e. those holding the &quot;via
    /// inspector&quot; rules), &quot;regular&quot; for regular stylesheets.
    /// </summary>
    public enum StyleSheetOrigin
    {
        /// <summary>
        /// injected
        /// </summary>
        [EnumMember(Value = ("injected"))]
        Injected,
        /// <summary>
        /// user-agent
        /// </summary>
        [EnumMember(Value = ("user-agent"))]
        UserAgent,
        /// <summary>
        /// inspector
        /// </summary>
        [EnumMember(Value = ("inspector"))]
        Inspector,
        /// <summary>
        /// regular
        /// </summary>
        [EnumMember(Value = ("regular"))]
        Regular
    }

    /// <summary>
    /// CSS rule collection for a single pseudo style.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class PseudoElementMatches : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Pseudo element type.
        /// </summary>
        public CefSharp.DevTools.DOM.PseudoType PseudoType
        {
            get
            {
                return (CefSharp.DevTools.DOM.PseudoType)(StringToEnum(typeof(CefSharp.DevTools.DOM.PseudoType), pseudoType));
            }

            set
            {
                this.pseudoType = (EnumToString(value));
            }
        }

        /// <summary>
        /// Pseudo element type.
        /// </summary>
        [DataMember(Name = ("pseudoType"), IsRequired = (true))]
        internal string pseudoType
        {
            get;
            set;
        }

        /// <summary>
        /// Pseudo element custom ident.
        /// </summary>
        [DataMember(Name = ("pseudoIdentifier"), IsRequired = (false))]
        public string PseudoIdentifier
        {
            get;
            set;
        }

        /// <summary>
        /// Matches of CSS rules applicable to the pseudo style.
        /// </summary>
        [DataMember(Name = ("matches"), IsRequired = (true))]
        public System.Collections.Generic.IList<CefSharp.DevTools.CSS.RuleMatch> Matches
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Inherited CSS rule collection from ancestor node.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class InheritedStyleEntry : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The ancestor node&apos;s inline style, if any, in the style inheritance chain.
        /// </summary>
        [DataMember(Name = ("inlineStyle"), IsRequired = (false))]
        public CefSharp.DevTools.CSS.CSSStyle InlineStyle
        {
            get;
            set;
        }

        /// <summary>
        /// Matches of CSS rules matching the ancestor node in the style inheritance chain.
        /// </summary>
        [DataMember(Name = ("matchedCSSRules"), IsRequired = (true))]
        public System.Collections.Generic.IList<CefSharp.DevTools.CSS.RuleMatch> MatchedCSSRules
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Inherited pseudo element matches from pseudos of an ancestor node.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class InheritedPseudoElementMatches : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Matches of pseudo styles from the pseudos of an ancestor node.
        /// </summary>
        [DataMember(Name = ("pseudoElements"), IsRequired = (true))]
        public System.Collections.Generic.IList<CefSharp.DevTools.CSS.PseudoElementMatches> PseudoElements
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Match data for a CSS rule.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class RuleMatch : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// CSS rule in the match.
        /// </summary>
        [DataMember(Name = ("rule"), IsRequired = (true))]
        public CefSharp.DevTools.CSS.CSSRule Rule
        {
            get;
            set;
        }

        /// <summary>
        /// Matching selector indices in the rule&apos;s selectorList selectors (0-based).
        /// </summary>
        [DataMember(Name = ("matchingSelectors"), IsRequired = (true))]
        public int[] MatchingSelectors
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Data for a simple selector (these are delimited by commas in a selector list).
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class Value : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Value text.
        /// </summary>
        [DataMember(Name = ("text"), IsRequired = (true))]
        public string Text
        {
            get;
            set;
        }

        /// <summary>
        /// Value range in the underlying resource (if available).
        /// </summary>
        [DataMember(Name = ("range"), IsRequired = (false))]
        public CefSharp.DevTools.CSS.SourceRange Range
        {
            get;
            set;
        }

        /// <summary>
        /// Specificity of the selector.
        /// </summary>
        [DataMember(Name = ("specificity"), IsRequired = (false))]
        public CefSharp.DevTools.CSS.Specificity Specificity
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Specificity:
    /// https://drafts.csswg.org/selectors/#specificity-rules
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class Specificity : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The a component, which represents the number of ID selectors.
        /// </summary>
        [DataMember(Name = ("a"), IsRequired = (true))]
        public int A
        {
            get;
            set;
        }

        /// <summary>
        /// The b component, which represents the number of class selectors, attributes selectors, and
        /// pseudo-classes.
        /// </summary>
        [DataMember(Name = ("b"), IsRequired = (true))]
        public int B
        {
            get;
            set;
        }

        /// <summary>
        /// The c component, which represents the number of type selectors and pseudo-elements.
        /// </summary>
        [DataMember(Name = ("c"), IsRequired = (true))]
        public int C
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Selector list data.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class SelectorList : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Selectors in the list.
        /// </summary>
        [DataMember(Name = ("selectors"), IsRequired = (true))]
        public System.Collections.Generic.IList<CefSharp.DevTools.CSS.Value> Selectors
        {
            get;
            set;
        }

        /// <summary>
        /// Rule selector text.
        /// </summary>
        [DataMember(Name = ("text"), IsRequired = (true))]
        public string Text
        {
            get;
            set;
        }
    }

    /// <summary>
    /// CSS stylesheet metainformation.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class CSSStyleSheetHeader : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The stylesheet identifier.
        /// </summary>
        [DataMember(Name = ("styleSheetId"), IsRequired = (true))]
        public string StyleSheetId
        {
            get;
            set;
        }

        /// <summary>
        /// Owner frame identifier.
        /// </summary>
        [DataMember(Name = ("frameId"), IsRequired = (true))]
        public string FrameId
        {
            get;
            set;
        }

        /// <summary>
        /// Stylesheet resource URL. Empty if this is a constructed stylesheet created using
        /// new CSSStyleSheet() (but non-empty if this is a constructed stylesheet imported
        /// as a CSS module script).
        /// </summary>
        [DataMember(Name = ("sourceURL"), IsRequired = (true))]
        public string SourceURL
        {
            get;
            set;
        }

        /// <summary>
        /// URL of source map associated with the stylesheet (if any).
        /// </summary>
        [DataMember(Name = ("sourceMapURL"), IsRequired = (false))]
        public string SourceMapURL
        {
            get;
            set;
        }

        /// <summary>
        /// Stylesheet origin.
        /// </summary>
        public CefSharp.DevTools.CSS.StyleSheetOrigin Origin
        {
            get
            {
                return (CefSharp.DevTools.CSS.StyleSheetOrigin)(StringToEnum(typeof(CefSharp.DevTools.CSS.StyleSheetOrigin), origin));
            }

            set
            {
                this.origin = (EnumToString(value));
            }
        }

        /// <summary>
        /// Stylesheet origin.
        /// </summary>
        [DataMember(Name = ("origin"), IsRequired = (true))]
        internal string origin
        {
            get;
            set;
        }

        /// <summary>
        /// Stylesheet title.
        /// </summary>
        [DataMember(Name = ("title"), IsRequired = (true))]
        public string Title
        {
            get;
            set;
        }

        /// <summary>
        /// The backend id for the owner node of the stylesheet.
        /// </summary>
        [DataMember(Name = ("ownerNode"), IsRequired = (false))]
        public int? OwnerNode
        {
            get;
            set;
        }

        /// <summary>
        /// Denotes whether the stylesheet is disabled.
        /// </summary>
        [DataMember(Name = ("disabled"), IsRequired = (true))]
        public bool Disabled
        {
            get;
            set;
        }

        /// <summary>
        /// Whether the sourceURL field value comes from the sourceURL comment.
        /// </summary>
        [DataMember(Name = ("hasSourceURL"), IsRequired = (false))]
        public bool? HasSourceURL
        {
            get;
            set;
        }

        /// <summary>
        /// Whether this stylesheet is created for STYLE tag by parser. This flag is not set for
        /// document.written STYLE tags.
        /// </summary>
        [DataMember(Name = ("isInline"), IsRequired = (true))]
        public bool IsInline
        {
            get;
            set;
        }

        /// <summary>
        /// Whether this stylesheet is mutable. Inline stylesheets become mutable
        /// after they have been modified via CSSOM API.
        /// `&lt;link&gt;` element&apos;s stylesheets become mutable only if DevTools modifies them.
        /// Constructed stylesheets (new CSSStyleSheet()) are mutable immediately after creation.
        /// </summary>
        [DataMember(Name = ("isMutable"), IsRequired = (true))]
        public bool IsMutable
        {
            get;
            set;
        }

        /// <summary>
        /// True if this stylesheet is created through new CSSStyleSheet() or imported as a
        /// CSS module script.
        /// </summary>
        [DataMember(Name = ("isConstructed"), IsRequired = (true))]
        public bool IsConstructed
        {
            get;
            set;
        }

        /// <summary>
        /// Line offset of the stylesheet within the resource (zero based).
        /// </summary>
        [DataMember(Name = ("startLine"), IsRequired = (true))]
        public double StartLine
        {
            get;
            set;
        }

        /// <summary>
        /// Column offset of the stylesheet within the resource (zero based).
        /// </summary>
        [DataMember(Name = ("startColumn"), IsRequired = (true))]
        public double StartColumn
        {
            get;
            set;
        }

        /// <summary>
        /// Size of the content (in characters).
        /// </summary>
        [DataMember(Name = ("length"), IsRequired = (true))]
        public double Length
        {
            get;
            set;
        }

        /// <summary>
        /// Line offset of the end of the stylesheet within the resource (zero based).
        /// </summary>
        [DataMember(Name = ("endLine"), IsRequired = (true))]
        public double EndLine
        {
            get;
            set;
        }

        /// <summary>
        /// Column offset of the end of the stylesheet within the resource (zero based).
        /// </summary>
        [DataMember(Name = ("endColumn"), IsRequired = (true))]
        public double EndColumn
        {
            get;
            set;
        }

        /// <summary>
        /// If the style sheet was loaded from a network resource, this indicates when the resource failed to load
        /// </summary>
        [DataMember(Name = ("loadingFailed"), IsRequired = (false))]
        public bool? LoadingFailed
        {
            get;
            set;
        }
    }

    /// <summary>
    /// CSS rule representation.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class CSSRule : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The css style sheet identifier (absent for user agent stylesheet and user-specified
        /// stylesheet rules) this rule came from.
        /// </summary>
        [DataMember(Name = ("styleSheetId"), IsRequired = (false))]
        public string StyleSheetId
        {
            get;
            set;
        }

        /// <summary>
        /// Rule selector data.
        /// </summary>
        [DataMember(Name = ("selectorList"), IsRequired = (true))]
        public CefSharp.DevTools.CSS.SelectorList SelectorList
        {
            get;
            set;
        }

        /// <summary>
        /// Array of selectors from ancestor style rules, sorted by distance from the current rule.
        /// </summary>
        [DataMember(Name = ("nestingSelectors"), IsRequired = (false))]
        public string[] NestingSelectors
        {
            get;
            set;
        }

        /// <summary>
        /// Parent stylesheet&apos;s origin.
        /// </summary>
        public CefSharp.DevTools.CSS.StyleSheetOrigin Origin
        {
            get
            {
                return (CefSharp.DevTools.CSS.StyleSheetOrigin)(StringToEnum(typeof(CefSharp.DevTools.CSS.StyleSheetOrigin), origin));
            }

            set
            {
                this.origin = (EnumToString(value));
            }
        }

        /// <summary>
        /// Parent stylesheet&apos;s origin.
        /// </summary>
        [DataMember(Name = ("origin"), IsRequired = (true))]
        internal string origin
        {
            get;
            set;
        }

        /// <summary>
        /// Associated style declaration.
        /// </summary>
        [DataMember(Name = ("style"), IsRequired = (true))]
        public CefSharp.DevTools.CSS.CSSStyle Style
        {
            get;
            set;
        }

        /// <summary>
        /// Media list array (for rules involving media queries). The array enumerates media queries
        /// starting with the innermost one, going outwards.
        /// </summary>
        [DataMember(Name = ("media"), IsRequired = (false))]
        public System.Collections.Generic.IList<CefSharp.DevTools.CSS.CSSMedia> Media
        {
            get;
            set;
        }

        /// <summary>
        /// Container query list array (for rules involving container queries).
        /// The array enumerates container queries starting with the innermost one, going outwards.
        /// </summary>
        [DataMember(Name = ("containerQueries"), IsRequired = (false))]
        public System.Collections.Generic.IList<CefSharp.DevTools.CSS.CSSContainerQuery> ContainerQueries
        {
            get;
            set;
        }

        /// <summary>
        /// @supports CSS at-rule array.
        /// The array enumerates @supports at-rules starting with the innermost one, going outwards.
        /// </summary>
        [DataMember(Name = ("supports"), IsRequired = (false))]
        public System.Collections.Generic.IList<CefSharp.DevTools.CSS.CSSSupports> Supports
        {
            get;
            set;
        }

        /// <summary>
        /// Cascade layer array. Contains the layer hierarchy that this rule belongs to starting
        /// with the innermost layer and going outwards.
        /// </summary>
        [DataMember(Name = ("layers"), IsRequired = (false))]
        public System.Collections.Generic.IList<CefSharp.DevTools.CSS.CSSLayer> Layers
        {
            get;
            set;
        }

        /// <summary>
        /// @scope CSS at-rule array.
        /// The array enumerates @scope at-rules starting with the innermost one, going outwards.
        /// </summary>
        [DataMember(Name = ("scopes"), IsRequired = (false))]
        public System.Collections.Generic.IList<CefSharp.DevTools.CSS.CSSScope> Scopes
        {
            get;
            set;
        }

        /// <summary>
        /// The array keeps the types of ancestor CSSRules from the innermost going outwards.
        /// </summary>
        public CefSharp.DevTools.CSS.CSSRuleType[] RuleTypes
        {
            get
            {
                return (CefSharp.DevTools.CSS.CSSRuleType[])(StringToEnum(typeof(CefSharp.DevTools.CSS.CSSRuleType[]), ruleTypes));
            }

            set
            {
                this.ruleTypes = (EnumToString(value));
            }
        }

        /// <summary>
        /// The array keeps the types of ancestor CSSRules from the innermost going outwards.
        /// </summary>
        [DataMember(Name = ("ruleTypes"), IsRequired = (false))]
        internal string ruleTypes
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Enum indicating the type of a CSS rule, used to represent the order of a style rule&apos;s ancestors.
    /// This list only contains rule types that are collected during the ancestor rule collection.
    /// </summary>
    public enum CSSRuleType
    {
        /// <summary>
        /// MediaRule
        /// </summary>
        [EnumMember(Value = ("MediaRule"))]
        MediaRule,
        /// <summary>
        /// SupportsRule
        /// </summary>
        [EnumMember(Value = ("SupportsRule"))]
        SupportsRule,
        /// <summary>
        /// ContainerRule
        /// </summary>
        [EnumMember(Value = ("ContainerRule"))]
        ContainerRule,
        /// <summary>
        /// LayerRule
        /// </summary>
        [EnumMember(Value = ("LayerRule"))]
        LayerRule,
        /// <summary>
        /// ScopeRule
        /// </summary>
        [EnumMember(Value = ("ScopeRule"))]
        ScopeRule,
        /// <summary>
        /// StyleRule
        /// </summary>
        [EnumMember(Value = ("StyleRule"))]
        StyleRule
    }

    /// <summary>
    /// CSS coverage information.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class RuleUsage : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The css style sheet identifier (absent for user agent stylesheet and user-specified
        /// stylesheet rules) this rule came from.
        /// </summary>
        [DataMember(Name = ("styleSheetId"), IsRequired = (true))]
        public string StyleSheetId
        {
            get;
            set;
        }

        /// <summary>
        /// Offset of the start of the rule (including selector) from the beginning of the stylesheet.
        /// </summary>
        [DataMember(Name = ("startOffset"), IsRequired = (true))]
        public double StartOffset
        {
            get;
            set;
        }

        /// <summary>
        /// Offset of the end of the rule body from the beginning of the stylesheet.
        /// </summary>
        [DataMember(Name = ("endOffset"), IsRequired = (true))]
        public double EndOffset
        {
            get;
            set;
        }

        /// <summary>
        /// Indicates whether the rule was actually used by some element in the page.
        /// </summary>
        [DataMember(Name = ("used"), IsRequired = (true))]
        public bool Used
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Text range within a resource. All numbers are zero-based.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class SourceRange : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Start line of range.
        /// </summary>
        [DataMember(Name = ("startLine"), IsRequired = (true))]
        public int StartLine
        {
            get;
            set;
        }

        /// <summary>
        /// Start column of range (inclusive).
        /// </summary>
        [DataMember(Name = ("startColumn"), IsRequired = (true))]
        public int StartColumn
        {
            get;
            set;
        }

        /// <summary>
        /// End line of range
        /// </summary>
        [DataMember(Name = ("endLine"), IsRequired = (true))]
        public int EndLine
        {
            get;
            set;
        }

        /// <summary>
        /// End column of range (exclusive).
        /// </summary>
        [DataMember(Name = ("endColumn"), IsRequired = (true))]
        public int EndColumn
        {
            get;
            set;
        }
    }

    /// <summary>
    /// ShorthandEntry
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class ShorthandEntry : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Shorthand name.
        /// </summary>
        [DataMember(Name = ("name"), IsRequired = (true))]
        public string Name
        {
            get;
            set;
        }

        /// <summary>
        /// Shorthand value.
        /// </summary>
        [DataMember(Name = ("value"), IsRequired = (true))]
        public string Value
        {
            get;
            set;
        }

        /// <summary>
        /// Whether the property has &quot;!important&quot; annotation (implies `false` if absent).
        /// </summary>
        [DataMember(Name = ("important"), IsRequired = (false))]
        public bool? Important
        {
            get;
            set;
        }
    }

    /// <summary>
    /// CSSComputedStyleProperty
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class CSSComputedStyleProperty : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Computed style property name.
        /// </summary>
        [DataMember(Name = ("name"), IsRequired = (true))]
        public string Name
        {
            get;
            set;
        }

        /// <summary>
        /// Computed style property value.
        /// </summary>
        [DataMember(Name = ("value"), IsRequired = (true))]
        public string Value
        {
            get;
            set;
        }
    }

    /// <summary>
    /// CSS style representation.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class CSSStyle : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The css style sheet identifier (absent for user agent stylesheet and user-specified
        /// stylesheet rules) this rule came from.
        /// </summary>
        [DataMember(Name = ("styleSheetId"), IsRequired = (false))]
        public string StyleSheetId
        {
            get;
            set;
        }

        /// <summary>
        /// CSS properties in the style.
        /// </summary>
        [DataMember(Name = ("cssProperties"), IsRequired = (true))]
        public System.Collections.Generic.IList<CefSharp.DevTools.CSS.CSSProperty> CssProperties
        {
            get;
            set;
        }

        /// <summary>
        /// Computed values for all shorthands found in the style.
        /// </summary>
        [DataMember(Name = ("shorthandEntries"), IsRequired = (true))]
        public System.Collections.Generic.IList<CefSharp.DevTools.CSS.ShorthandEntry> ShorthandEntries
        {
            get;
            set;
        }

        /// <summary>
        /// Style declaration text (if available).
        /// </summary>
        [DataMember(Name = ("cssText"), IsRequired = (false))]
        public string CssText
        {
            get;
            set;
        }

        /// <summary>
        /// Style declaration range in the enclosing stylesheet (if available).
        /// </summary>
        [DataMember(Name = ("range"), IsRequired = (false))]
        public CefSharp.DevTools.CSS.SourceRange Range
        {
            get;
            set;
        }
    }

    /// <summary>
    /// CSS property declaration data.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class CSSProperty : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The property name.
        /// </summary>
        [DataMember(Name = ("name"), IsRequired = (true))]
        public string Name
        {
            get;
            set;
        }

        /// <summary>
        /// The property value.
        /// </summary>
        [DataMember(Name = ("value"), IsRequired = (true))]
        public string Value
        {
            get;
            set;
        }

        /// <summary>
        /// Whether the property has &quot;!important&quot; annotation (implies `false` if absent).
        /// </summary>
        [DataMember(Name = ("important"), IsRequired = (false))]
        public bool? Important
        {
            get;
            set;
        }

        /// <summary>
        /// Whether the property is implicit (implies `false` if absent).
        /// </summary>
        [DataMember(Name = ("implicit"), IsRequired = (false))]
        public bool? Implicit
        {
            get;
            set;
        }

        /// <summary>
        /// The full property text as specified in the style.
        /// </summary>
        [DataMember(Name = ("text"), IsRequired = (false))]
        public string Text
        {
            get;
            set;
        }

        /// <summary>
        /// Whether the property is understood by the browser (implies `true` if absent).
        /// </summary>
        [DataMember(Name = ("parsedOk"), IsRequired = (false))]
        public bool? ParsedOk
        {
            get;
            set;
        }

        /// <summary>
        /// Whether the property is disabled by the user (present for source-based properties only).
        /// </summary>
        [DataMember(Name = ("disabled"), IsRequired = (false))]
        public bool? Disabled
        {
            get;
            set;
        }

        /// <summary>
        /// The entire property range in the enclosing style declaration (if available).
        /// </summary>
        [DataMember(Name = ("range"), IsRequired = (false))]
        public CefSharp.DevTools.CSS.SourceRange Range
        {
            get;
            set;
        }

        /// <summary>
        /// Parsed longhand components of this property if it is a shorthand.
        /// This field will be empty if the given property is not a shorthand.
        /// </summary>
        [DataMember(Name = ("longhandProperties"), IsRequired = (false))]
        public System.Collections.Generic.IList<CefSharp.DevTools.CSS.CSSProperty> LonghandProperties
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Source of the media query: &quot;mediaRule&quot; if specified by a @media rule, &quot;importRule&quot; if
    /// specified by an @import rule, &quot;linkedSheet&quot; if specified by a &quot;media&quot; attribute in a linked
    /// stylesheet&apos;s LINK tag, &quot;inlineSheet&quot; if specified by a &quot;media&quot; attribute in an inline
    /// stylesheet&apos;s STYLE tag.
    /// </summary>
    public enum CSSMediaSource
    {
        /// <summary>
        /// mediaRule
        /// </summary>
        [EnumMember(Value = ("mediaRule"))]
        MediaRule,
        /// <summary>
        /// importRule
        /// </summary>
        [EnumMember(Value = ("importRule"))]
        ImportRule,
        /// <summary>
        /// linkedSheet
        /// </summary>
        [EnumMember(Value = ("linkedSheet"))]
        LinkedSheet,
        /// <summary>
        /// inlineSheet
        /// </summary>
        [EnumMember(Value = ("inlineSheet"))]
        InlineSheet
    }

    /// <summary>
    /// CSS media rule descriptor.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class CSSMedia : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Media query text.
        /// </summary>
        [DataMember(Name = ("text"), IsRequired = (true))]
        public string Text
        {
            get;
            set;
        }

        /// <summary>
        /// Source of the media query: &quot;mediaRule&quot; if specified by a @media rule, &quot;importRule&quot; if
        /// specified by an @import rule, &quot;linkedSheet&quot; if specified by a &quot;media&quot; attribute in a linked
        /// stylesheet&apos;s LINK tag, &quot;inlineSheet&quot; if specified by a &quot;media&quot; attribute in an inline
        /// stylesheet&apos;s STYLE tag.
        /// </summary>
        public CefSharp.DevTools.CSS.CSSMediaSource Source
        {
            get
            {
                return (CefSharp.DevTools.CSS.CSSMediaSource)(StringToEnum(typeof(CefSharp.DevTools.CSS.CSSMediaSource), source));
            }

            set
            {
                this.source = (EnumToString(value));
            }
        }

        /// <summary>
        /// Source of the media query: &quot;mediaRule&quot; if specified by a @media rule, &quot;importRule&quot; if
        /// specified by an @import rule, &quot;linkedSheet&quot; if specified by a &quot;media&quot; attribute in a linked
        /// stylesheet&apos;s LINK tag, &quot;inlineSheet&quot; if specified by a &quot;media&quot; attribute in an inline
        /// stylesheet&apos;s STYLE tag.
        /// </summary>
        [DataMember(Name = ("source"), IsRequired = (true))]
        internal string source
        {
            get;
            set;
        }

        /// <summary>
        /// URL of the document containing the media query description.
        /// </summary>
        [DataMember(Name = ("sourceURL"), IsRequired = (false))]
        public string SourceURL
        {
            get;
            set;
        }

        /// <summary>
        /// The associated rule (@media or @import) header range in the enclosing stylesheet (if
        /// available).
        /// </summary>
        [DataMember(Name = ("range"), IsRequired = (false))]
        public CefSharp.DevTools.CSS.SourceRange Range
        {
            get;
            set;
        }

        /// <summary>
        /// Identifier of the stylesheet containing this object (if exists).
        /// </summary>
        [DataMember(Name = ("styleSheetId"), IsRequired = (false))]
        public string StyleSheetId
        {
            get;
            set;
        }

        /// <summary>
        /// Array of media queries.
        /// </summary>
        [DataMember(Name = ("mediaList"), IsRequired = (false))]
        public System.Collections.Generic.IList<CefSharp.DevTools.CSS.MediaQuery> MediaList
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Media query descriptor.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class MediaQuery : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Array of media query expressions.
        /// </summary>
        [DataMember(Name = ("expressions"), IsRequired = (true))]
        public System.Collections.Generic.IList<CefSharp.DevTools.CSS.MediaQueryExpression> Expressions
        {
            get;
            set;
        }

        /// <summary>
        /// Whether the media query condition is satisfied.
        /// </summary>
        [DataMember(Name = ("active"), IsRequired = (true))]
        public bool Active
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Media query expression descriptor.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class MediaQueryExpression : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Media query expression value.
        /// </summary>
        [DataMember(Name = ("value"), IsRequired = (true))]
        public double Value
        {
            get;
            set;
        }

        /// <summary>
        /// Media query expression units.
        /// </summary>
        [DataMember(Name = ("unit"), IsRequired = (true))]
        public string Unit
        {
            get;
            set;
        }

        /// <summary>
        /// Media query expression feature.
        /// </summary>
        [DataMember(Name = ("feature"), IsRequired = (true))]
        public string Feature
        {
            get;
            set;
        }

        /// <summary>
        /// The associated range of the value text in the enclosing stylesheet (if available).
        /// </summary>
        [DataMember(Name = ("valueRange"), IsRequired = (false))]
        public CefSharp.DevTools.CSS.SourceRange ValueRange
        {
            get;
            set;
        }

        /// <summary>
        /// Computed length of media query expression (if applicable).
        /// </summary>
        [DataMember(Name = ("computedLength"), IsRequired = (false))]
        public double? ComputedLength
        {
            get;
            set;
        }
    }

    /// <summary>
    /// CSS container query rule descriptor.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class CSSContainerQuery : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Container query text.
        /// </summary>
        [DataMember(Name = ("text"), IsRequired = (true))]
        public string Text
        {
            get;
            set;
        }

        /// <summary>
        /// The associated rule header range in the enclosing stylesheet (if
        /// available).
        /// </summary>
        [DataMember(Name = ("range"), IsRequired = (false))]
        public CefSharp.DevTools.CSS.SourceRange Range
        {
            get;
            set;
        }

        /// <summary>
        /// Identifier of the stylesheet containing this object (if exists).
        /// </summary>
        [DataMember(Name = ("styleSheetId"), IsRequired = (false))]
        public string StyleSheetId
        {
            get;
            set;
        }

        /// <summary>
        /// Optional name for the container.
        /// </summary>
        [DataMember(Name = ("name"), IsRequired = (false))]
        public string Name
        {
            get;
            set;
        }

        /// <summary>
        /// Optional physical axes queried for the container.
        /// </summary>
        public CefSharp.DevTools.DOM.PhysicalAxes? PhysicalAxes
        {
            get
            {
                return (CefSharp.DevTools.DOM.PhysicalAxes? )(StringToEnum(typeof(CefSharp.DevTools.DOM.PhysicalAxes? ), physicalAxes));
            }

            set
            {
                this.physicalAxes = (EnumToString(value));
            }
        }

        /// <summary>
        /// Optional physical axes queried for the container.
        /// </summary>
        [DataMember(Name = ("physicalAxes"), IsRequired = (false))]
        internal string physicalAxes
        {
            get;
            set;
        }

        /// <summary>
        /// Optional logical axes queried for the container.
        /// </summary>
        public CefSharp.DevTools.DOM.LogicalAxes? LogicalAxes
        {
            get
            {
                return (CefSharp.DevTools.DOM.LogicalAxes? )(StringToEnum(typeof(CefSharp.DevTools.DOM.LogicalAxes? ), logicalAxes));
            }

            set
            {
                this.logicalAxes = (EnumToString(value));
            }
        }

        /// <summary>
        /// Optional logical axes queried for the container.
        /// </summary>
        [DataMember(Name = ("logicalAxes"), IsRequired = (false))]
        internal string logicalAxes
        {
            get;
            set;
        }
    }

    /// <summary>
    /// CSS Supports at-rule descriptor.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class CSSSupports : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Supports rule text.
        /// </summary>
        [DataMember(Name = ("text"), IsRequired = (true))]
        public string Text
        {
            get;
            set;
        }

        /// <summary>
        /// Whether the supports condition is satisfied.
        /// </summary>
        [DataMember(Name = ("active"), IsRequired = (true))]
        public bool Active
        {
            get;
            set;
        }

        /// <summary>
        /// The associated rule header range in the enclosing stylesheet (if
        /// available).
        /// </summary>
        [DataMember(Name = ("range"), IsRequired = (false))]
        public CefSharp.DevTools.CSS.SourceRange Range
        {
            get;
            set;
        }

        /// <summary>
        /// Identifier of the stylesheet containing this object (if exists).
        /// </summary>
        [DataMember(Name = ("styleSheetId"), IsRequired = (false))]
        public string StyleSheetId
        {
            get;
            set;
        }
    }

    /// <summary>
    /// CSS Scope at-rule descriptor.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class CSSScope : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Scope rule text.
        /// </summary>
        [DataMember(Name = ("text"), IsRequired = (true))]
        public string Text
        {
            get;
            set;
        }

        /// <summary>
        /// The associated rule header range in the enclosing stylesheet (if
        /// available).
        /// </summary>
        [DataMember(Name = ("range"), IsRequired = (false))]
        public CefSharp.DevTools.CSS.SourceRange Range
        {
            get;
            set;
        }

        /// <summary>
        /// Identifier of the stylesheet containing this object (if exists).
        /// </summary>
        [DataMember(Name = ("styleSheetId"), IsRequired = (false))]
        public string StyleSheetId
        {
            get;
            set;
        }
    }

    /// <summary>
    /// CSS Layer at-rule descriptor.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class CSSLayer : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Layer name.
        /// </summary>
        [DataMember(Name = ("text"), IsRequired = (true))]
        public string Text
        {
            get;
            set;
        }

        /// <summary>
        /// The associated rule header range in the enclosing stylesheet (if
        /// available).
        /// </summary>
        [DataMember(Name = ("range"), IsRequired = (false))]
        public CefSharp.DevTools.CSS.SourceRange Range
        {
            get;
            set;
        }

        /// <summary>
        /// Identifier of the stylesheet containing this object (if exists).
        /// </summary>
        [DataMember(Name = ("styleSheetId"), IsRequired = (false))]
        public string StyleSheetId
        {
            get;
            set;
        }
    }

    /// <summary>
    /// CSS Layer data.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class CSSLayerData : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Layer name.
        /// </summary>
        [DataMember(Name = ("name"), IsRequired = (true))]
        public string Name
        {
            get;
            set;
        }

        /// <summary>
        /// Direct sub-layers
        /// </summary>
        [DataMember(Name = ("subLayers"), IsRequired = (false))]
        public System.Collections.Generic.IList<CefSharp.DevTools.CSS.CSSLayerData> SubLayers
        {
            get;
            set;
        }

        /// <summary>
        /// Layer order. The order determines the order of the layer in the cascade order.
        /// A higher number has higher priority in the cascade order.
        /// </summary>
        [DataMember(Name = ("order"), IsRequired = (true))]
        public double Order
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Information about amount of glyphs that were rendered with given font.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class PlatformFontUsage : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Font&apos;s family name reported by platform.
        /// </summary>
        [DataMember(Name = ("familyName"), IsRequired = (true))]
        public string FamilyName
        {
            get;
            set;
        }

        /// <summary>
        /// Font&apos;s PostScript name reported by platform.
        /// </summary>
        [DataMember(Name = ("postScriptName"), IsRequired = (true))]
        public string PostScriptName
        {
            get;
            set;
        }

        /// <summary>
        /// Indicates if the font was downloaded or resolved locally.
        /// </summary>
        [DataMember(Name = ("isCustomFont"), IsRequired = (true))]
        public bool IsCustomFont
        {
            get;
            set;
        }

        /// <summary>
        /// Amount of glyphs that were rendered with this font.
        /// </summary>
        [DataMember(Name = ("glyphCount"), IsRequired = (true))]
        public double GlyphCount
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Information about font variation axes for variable fonts
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class FontVariationAxis : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The font-variation-setting tag (a.k.a. &quot;axis tag&quot;).
        /// </summary>
        [DataMember(Name = ("tag"), IsRequired = (true))]
        public string Tag
        {
            get;
            set;
        }

        /// <summary>
        /// Human-readable variation name in the default language (normally, &quot;en&quot;).
        /// </summary>
        [DataMember(Name = ("name"), IsRequired = (true))]
        public string Name
        {
            get;
            set;
        }

        /// <summary>
        /// The minimum value (inclusive) the font supports for this tag.
        /// </summary>
        [DataMember(Name = ("minValue"), IsRequired = (true))]
        public double MinValue
        {
            get;
            set;
        }

        /// <summary>
        /// The maximum value (inclusive) the font supports for this tag.
        /// </summary>
        [DataMember(Name = ("maxValue"), IsRequired = (true))]
        public double MaxValue
        {
            get;
            set;
        }

        /// <summary>
        /// The default value.
        /// </summary>
        [DataMember(Name = ("defaultValue"), IsRequired = (true))]
        public double DefaultValue
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Properties of a web font: https://www.w3.org/TR/2008/REC-CSS2-20080411/fonts.html#font-descriptions
    /// and additional information such as platformFontFamily and fontVariationAxes.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class FontFace : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The font-family.
        /// </summary>
        [DataMember(Name = ("fontFamily"), IsRequired = (true))]
        public string FontFamily
        {
            get;
            set;
        }

        /// <summary>
        /// The font-style.
        /// </summary>
        [DataMember(Name = ("fontStyle"), IsRequired = (true))]
        public string FontStyle
        {
            get;
            set;
        }

        /// <summary>
        /// The font-variant.
        /// </summary>
        [DataMember(Name = ("fontVariant"), IsRequired = (true))]
        public string FontVariant
        {
            get;
            set;
        }

        /// <summary>
        /// The font-weight.
        /// </summary>
        [DataMember(Name = ("fontWeight"), IsRequired = (true))]
        public string FontWeight
        {
            get;
            set;
        }

        /// <summary>
        /// The font-stretch.
        /// </summary>
        [DataMember(Name = ("fontStretch"), IsRequired = (true))]
        public string FontStretch
        {
            get;
            set;
        }

        /// <summary>
        /// The font-display.
        /// </summary>
        [DataMember(Name = ("fontDisplay"), IsRequired = (true))]
        public string FontDisplay
        {
            get;
            set;
        }

        /// <summary>
        /// The unicode-range.
        /// </summary>
        [DataMember(Name = ("unicodeRange"), IsRequired = (true))]
        public string UnicodeRange
        {
            get;
            set;
        }

        /// <summary>
        /// The src.
        /// </summary>
        [DataMember(Name = ("src"), IsRequired = (true))]
        public string Src
        {
            get;
            set;
        }

        /// <summary>
        /// The resolved platform font family
        /// </summary>
        [DataMember(Name = ("platformFontFamily"), IsRequired = (true))]
        public string PlatformFontFamily
        {
            get;
            set;
        }

        /// <summary>
        /// Available variation settings (a.k.a. &quot;axes&quot;).
        /// </summary>
        [DataMember(Name = ("fontVariationAxes"), IsRequired = (false))]
        public System.Collections.Generic.IList<CefSharp.DevTools.CSS.FontVariationAxis> FontVariationAxes
        {
            get;
            set;
        }
    }

    /// <summary>
    /// CSS try rule representation.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class CSSTryRule : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The css style sheet identifier (absent for user agent stylesheet and user-specified
        /// stylesheet rules) this rule came from.
        /// </summary>
        [DataMember(Name = ("styleSheetId"), IsRequired = (false))]
        public string StyleSheetId
        {
            get;
            set;
        }

        /// <summary>
        /// Parent stylesheet&apos;s origin.
        /// </summary>
        public CefSharp.DevTools.CSS.StyleSheetOrigin Origin
        {
            get
            {
                return (CefSharp.DevTools.CSS.StyleSheetOrigin)(StringToEnum(typeof(CefSharp.DevTools.CSS.StyleSheetOrigin), origin));
            }

            set
            {
                this.origin = (EnumToString(value));
            }
        }

        /// <summary>
        /// Parent stylesheet&apos;s origin.
        /// </summary>
        [DataMember(Name = ("origin"), IsRequired = (true))]
        internal string origin
        {
            get;
            set;
        }

        /// <summary>
        /// Associated style declaration.
        /// </summary>
        [DataMember(Name = ("style"), IsRequired = (true))]
        public CefSharp.DevTools.CSS.CSSStyle Style
        {
            get;
            set;
        }
    }

    /// <summary>
    /// CSS @position-try rule representation.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class CSSPositionTryRule : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The prelude dashed-ident name
        /// </summary>
        [DataMember(Name = ("name"), IsRequired = (true))]
        public CefSharp.DevTools.CSS.Value Name
        {
            get;
            set;
        }

        /// <summary>
        /// The css style sheet identifier (absent for user agent stylesheet and user-specified
        /// stylesheet rules) this rule came from.
        /// </summary>
        [DataMember(Name = ("styleSheetId"), IsRequired = (false))]
        public string StyleSheetId
        {
            get;
            set;
        }

        /// <summary>
        /// Parent stylesheet&apos;s origin.
        /// </summary>
        public CefSharp.DevTools.CSS.StyleSheetOrigin Origin
        {
            get
            {
                return (CefSharp.DevTools.CSS.StyleSheetOrigin)(StringToEnum(typeof(CefSharp.DevTools.CSS.StyleSheetOrigin), origin));
            }

            set
            {
                this.origin = (EnumToString(value));
            }
        }

        /// <summary>
        /// Parent stylesheet&apos;s origin.
        /// </summary>
        [DataMember(Name = ("origin"), IsRequired = (true))]
        internal string origin
        {
            get;
            set;
        }

        /// <summary>
        /// Associated style declaration.
        /// </summary>
        [DataMember(Name = ("style"), IsRequired = (true))]
        public CefSharp.DevTools.CSS.CSSStyle Style
        {
            get;
            set;
        }

        /// <summary>
        /// Active
        /// </summary>
        [DataMember(Name = ("active"), IsRequired = (true))]
        public bool Active
        {
            get;
            set;
        }
    }

    /// <summary>
    /// CSS keyframes rule representation.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class CSSKeyframesRule : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Animation name.
        /// </summary>
        [DataMember(Name = ("animationName"), IsRequired = (true))]
        public CefSharp.DevTools.CSS.Value AnimationName
        {
            get;
            set;
        }

        /// <summary>
        /// List of keyframes.
        /// </summary>
        [DataMember(Name = ("keyframes"), IsRequired = (true))]
        public System.Collections.Generic.IList<CefSharp.DevTools.CSS.CSSKeyframeRule> Keyframes
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Representation of a custom property registration through CSS.registerProperty
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class CSSPropertyRegistration : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// PropertyName
        /// </summary>
        [DataMember(Name = ("propertyName"), IsRequired = (true))]
        public string PropertyName
        {
            get;
            set;
        }

        /// <summary>
        /// InitialValue
        /// </summary>
        [DataMember(Name = ("initialValue"), IsRequired = (false))]
        public CefSharp.DevTools.CSS.Value InitialValue
        {
            get;
            set;
        }

        /// <summary>
        /// Inherits
        /// </summary>
        [DataMember(Name = ("inherits"), IsRequired = (true))]
        public bool Inherits
        {
            get;
            set;
        }

        /// <summary>
        /// Syntax
        /// </summary>
        [DataMember(Name = ("syntax"), IsRequired = (true))]
        public string Syntax
        {
            get;
            set;
        }
    }

    /// <summary>
    /// CSS font-palette-values rule representation.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class CSSFontPaletteValuesRule : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The css style sheet identifier (absent for user agent stylesheet and user-specified
        /// stylesheet rules) this rule came from.
        /// </summary>
        [DataMember(Name = ("styleSheetId"), IsRequired = (false))]
        public string StyleSheetId
        {
            get;
            set;
        }

        /// <summary>
        /// Parent stylesheet&apos;s origin.
        /// </summary>
        public CefSharp.DevTools.CSS.StyleSheetOrigin Origin
        {
            get
            {
                return (CefSharp.DevTools.CSS.StyleSheetOrigin)(StringToEnum(typeof(CefSharp.DevTools.CSS.StyleSheetOrigin), origin));
            }

            set
            {
                this.origin = (EnumToString(value));
            }
        }

        /// <summary>
        /// Parent stylesheet&apos;s origin.
        /// </summary>
        [DataMember(Name = ("origin"), IsRequired = (true))]
        internal string origin
        {
            get;
            set;
        }

        /// <summary>
        /// Associated font palette name.
        /// </summary>
        [DataMember(Name = ("fontPaletteName"), IsRequired = (true))]
        public CefSharp.DevTools.CSS.Value FontPaletteName
        {
            get;
            set;
        }

        /// <summary>
        /// Associated style declaration.
        /// </summary>
        [DataMember(Name = ("style"), IsRequired = (true))]
        public CefSharp.DevTools.CSS.CSSStyle Style
        {
            get;
            set;
        }
    }

    /// <summary>
    /// CSS property at-rule representation.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class CSSPropertyRule : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The css style sheet identifier (absent for user agent stylesheet and user-specified
        /// stylesheet rules) this rule came from.
        /// </summary>
        [DataMember(Name = ("styleSheetId"), IsRequired = (false))]
        public string StyleSheetId
        {
            get;
            set;
        }

        /// <summary>
        /// Parent stylesheet&apos;s origin.
        /// </summary>
        public CefSharp.DevTools.CSS.StyleSheetOrigin Origin
        {
            get
            {
                return (CefSharp.DevTools.CSS.StyleSheetOrigin)(StringToEnum(typeof(CefSharp.DevTools.CSS.StyleSheetOrigin), origin));
            }

            set
            {
                this.origin = (EnumToString(value));
            }
        }

        /// <summary>
        /// Parent stylesheet&apos;s origin.
        /// </summary>
        [DataMember(Name = ("origin"), IsRequired = (true))]
        internal string origin
        {
            get;
            set;
        }

        /// <summary>
        /// Associated property name.
        /// </summary>
        [DataMember(Name = ("propertyName"), IsRequired = (true))]
        public CefSharp.DevTools.CSS.Value PropertyName
        {
            get;
            set;
        }

        /// <summary>
        /// Associated style declaration.
        /// </summary>
        [DataMember(Name = ("style"), IsRequired = (true))]
        public CefSharp.DevTools.CSS.CSSStyle Style
        {
            get;
            set;
        }
    }

    /// <summary>
    /// CSS keyframe rule representation.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class CSSKeyframeRule : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The css style sheet identifier (absent for user agent stylesheet and user-specified
        /// stylesheet rules) this rule came from.
        /// </summary>
        [DataMember(Name = ("styleSheetId"), IsRequired = (false))]
        public string StyleSheetId
        {
            get;
            set;
        }

        /// <summary>
        /// Parent stylesheet&apos;s origin.
        /// </summary>
        public CefSharp.DevTools.CSS.StyleSheetOrigin Origin
        {
            get
            {
                return (CefSharp.DevTools.CSS.StyleSheetOrigin)(StringToEnum(typeof(CefSharp.DevTools.CSS.StyleSheetOrigin), origin));
            }

            set
            {
                this.origin = (EnumToString(value));
            }
        }

        /// <summary>
        /// Parent stylesheet&apos;s origin.
        /// </summary>
        [DataMember(Name = ("origin"), IsRequired = (true))]
        internal string origin
        {
            get;
            set;
        }

        /// <summary>
        /// Associated key text.
        /// </summary>
        [DataMember(Name = ("keyText"), IsRequired = (true))]
        public CefSharp.DevTools.CSS.Value KeyText
        {
            get;
            set;
        }

        /// <summary>
        /// Associated style declaration.
        /// </summary>
        [DataMember(Name = ("style"), IsRequired = (true))]
        public CefSharp.DevTools.CSS.CSSStyle Style
        {
            get;
            set;
        }
    }

    /// <summary>
    /// A descriptor of operation to mutate style declaration text.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class StyleDeclarationEdit : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The css style sheet identifier.
        /// </summary>
        [DataMember(Name = ("styleSheetId"), IsRequired = (true))]
        public string StyleSheetId
        {
            get;
            set;
        }

        /// <summary>
        /// The range of the style text in the enclosing stylesheet.
        /// </summary>
        [DataMember(Name = ("range"), IsRequired = (true))]
        public CefSharp.DevTools.CSS.SourceRange Range
        {
            get;
            set;
        }

        /// <summary>
        /// New style text.
        /// </summary>
        [DataMember(Name = ("text"), IsRequired = (true))]
        public string Text
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Fires whenever a web font is updated.  A non-empty font parameter indicates a successfully loaded
    /// web font.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class FontsUpdatedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// The web font that has loaded.
        /// </summary>
        [DataMember(Name = ("font"), IsRequired = (false))]
        public CefSharp.DevTools.CSS.FontFace Font
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired whenever an active document stylesheet is added.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class StyleSheetAddedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Added stylesheet metainfo.
        /// </summary>
        [DataMember(Name = ("header"), IsRequired = (true))]
        public CefSharp.DevTools.CSS.CSSStyleSheetHeader Header
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired whenever a stylesheet is changed as a result of the client operation.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class StyleSheetChangedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// StyleSheetId
        /// </summary>
        [DataMember(Name = ("styleSheetId"), IsRequired = (true))]
        public string StyleSheetId
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired whenever an active document stylesheet is removed.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class StyleSheetRemovedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Identifier of the removed stylesheet.
        /// </summary>
        [DataMember(Name = ("styleSheetId"), IsRequired = (true))]
        public string StyleSheetId
        {
            get;
            private set;
        }
    }
}

namespace CefSharp.DevTools.CacheStorage
{
    /// <summary>
    /// type of HTTP response cached
    /// </summary>
    public enum CachedResponseType
    {
        /// <summary>
        /// basic
        /// </summary>
        [EnumMember(Value = ("basic"))]
        Basic,
        /// <summary>
        /// cors
        /// </summary>
        [EnumMember(Value = ("cors"))]
        Cors,
        /// <summary>
        /// default
        /// </summary>
        [EnumMember(Value = ("default"))]
        Default,
        /// <summary>
        /// error
        /// </summary>
        [EnumMember(Value = ("error"))]
        Error,
        /// <summary>
        /// opaqueResponse
        /// </summary>
        [EnumMember(Value = ("opaqueResponse"))]
        OpaqueResponse,
        /// <summary>
        /// opaqueRedirect
        /// </summary>
        [EnumMember(Value = ("opaqueRedirect"))]
        OpaqueRedirect
    }

    /// <summary>
    /// Data entry.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class DataEntry : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Request URL.
        /// </summary>
        [DataMember(Name = ("requestURL"), IsRequired = (true))]
        public string RequestURL
        {
            get;
            set;
        }

        /// <summary>
        /// Request method.
        /// </summary>
        [DataMember(Name = ("requestMethod"), IsRequired = (true))]
        public string RequestMethod
        {
            get;
            set;
        }

        /// <summary>
        /// Request headers
        /// </summary>
        [DataMember(Name = ("requestHeaders"), IsRequired = (true))]
        public System.Collections.Generic.IList<CefSharp.DevTools.CacheStorage.Header> RequestHeaders
        {
            get;
            set;
        }

        /// <summary>
        /// Number of seconds since epoch.
        /// </summary>
        [DataMember(Name = ("responseTime"), IsRequired = (true))]
        public double ResponseTime
        {
            get;
            set;
        }

        /// <summary>
        /// HTTP response status code.
        /// </summary>
        [DataMember(Name = ("responseStatus"), IsRequired = (true))]
        public int ResponseStatus
        {
            get;
            set;
        }

        /// <summary>
        /// HTTP response status text.
        /// </summary>
        [DataMember(Name = ("responseStatusText"), IsRequired = (true))]
        public string ResponseStatusText
        {
            get;
            set;
        }

        /// <summary>
        /// HTTP response type
        /// </summary>
        public CefSharp.DevTools.CacheStorage.CachedResponseType ResponseType
        {
            get
            {
                return (CefSharp.DevTools.CacheStorage.CachedResponseType)(StringToEnum(typeof(CefSharp.DevTools.CacheStorage.CachedResponseType), responseType));
            }

            set
            {
                this.responseType = (EnumToString(value));
            }
        }

        /// <summary>
        /// HTTP response type
        /// </summary>
        [DataMember(Name = ("responseType"), IsRequired = (true))]
        internal string responseType
        {
            get;
            set;
        }

        /// <summary>
        /// Response headers
        /// </summary>
        [DataMember(Name = ("responseHeaders"), IsRequired = (true))]
        public System.Collections.Generic.IList<CefSharp.DevTools.CacheStorage.Header> ResponseHeaders
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Cache identifier.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class Cache : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// An opaque unique id of the cache.
        /// </summary>
        [DataMember(Name = ("cacheId"), IsRequired = (true))]
        public string CacheId
        {
            get;
            set;
        }

        /// <summary>
        /// Security origin of the cache.
        /// </summary>
        [DataMember(Name = ("securityOrigin"), IsRequired = (true))]
        public string SecurityOrigin
        {
            get;
            set;
        }

        /// <summary>
        /// Storage key of the cache.
        /// </summary>
        [DataMember(Name = ("storageKey"), IsRequired = (true))]
        public string StorageKey
        {
            get;
            set;
        }

        /// <summary>
        /// Storage bucket of the cache.
        /// </summary>
        [DataMember(Name = ("storageBucket"), IsRequired = (false))]
        public CefSharp.DevTools.Storage.StorageBucket StorageBucket
        {
            get;
            set;
        }

        /// <summary>
        /// The name of the cache.
        /// </summary>
        [DataMember(Name = ("cacheName"), IsRequired = (true))]
        public string CacheName
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Header
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class Header : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Name
        /// </summary>
        [DataMember(Name = ("name"), IsRequired = (true))]
        public string Name
        {
            get;
            set;
        }

        /// <summary>
        /// Value
        /// </summary>
        [DataMember(Name = ("value"), IsRequired = (true))]
        public string Value
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Cached response
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class CachedResponse : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Entry content, base64-encoded.
        /// </summary>
        [DataMember(Name = ("body"), IsRequired = (true))]
        public byte[] Body
        {
            get;
            set;
        }
    }
}

namespace CefSharp.DevTools.Cast
{
    /// <summary>
    /// Sink
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class Sink : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Name
        /// </summary>
        [DataMember(Name = ("name"), IsRequired = (true))]
        public string Name
        {
            get;
            set;
        }

        /// <summary>
        /// Id
        /// </summary>
        [DataMember(Name = ("id"), IsRequired = (true))]
        public string Id
        {
            get;
            set;
        }

        /// <summary>
        /// Text describing the current session. Present only if there is an active
        /// session on the sink.
        /// </summary>
        [DataMember(Name = ("session"), IsRequired = (false))]
        public string Session
        {
            get;
            set;
        }
    }

    /// <summary>
    /// This is fired whenever the list of available sinks changes. A sink is a
    /// device or a software surface that you can cast to.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class SinksUpdatedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Sinks
        /// </summary>
        [DataMember(Name = ("sinks"), IsRequired = (true))]
        public System.Collections.Generic.IList<CefSharp.DevTools.Cast.Sink> Sinks
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// This is fired whenever the outstanding issue/error message changes.
    /// |issueMessage| is empty if there is no issue.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class IssueUpdatedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// IssueMessage
        /// </summary>
        [DataMember(Name = ("issueMessage"), IsRequired = (true))]
        public string IssueMessage
        {
            get;
            private set;
        }
    }
}

namespace CefSharp.DevTools.DOM
{
    /// <summary>
    /// Backend node with a friendly name.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class BackendNode : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// `Node`&apos;s nodeType.
        /// </summary>
        [DataMember(Name = ("nodeType"), IsRequired = (true))]
        public int NodeType
        {
            get;
            set;
        }

        /// <summary>
        /// `Node`&apos;s nodeName.
        /// </summary>
        [DataMember(Name = ("nodeName"), IsRequired = (true))]
        public string NodeName
        {
            get;
            set;
        }

        /// <summary>
        /// BackendNodeId
        /// </summary>
        [DataMember(Name = ("backendNodeId"), IsRequired = (true))]
        public int BackendNodeId
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Pseudo element type.
    /// </summary>
    public enum PseudoType
    {
        /// <summary>
        /// first-line
        /// </summary>
        [EnumMember(Value = ("first-line"))]
        FirstLine,
        /// <summary>
        /// first-letter
        /// </summary>
        [EnumMember(Value = ("first-letter"))]
        FirstLetter,
        /// <summary>
        /// before
        /// </summary>
        [EnumMember(Value = ("before"))]
        Before,
        /// <summary>
        /// after
        /// </summary>
        [EnumMember(Value = ("after"))]
        After,
        /// <summary>
        /// marker
        /// </summary>
        [EnumMember(Value = ("marker"))]
        Marker,
        /// <summary>
        /// backdrop
        /// </summary>
        [EnumMember(Value = ("backdrop"))]
        Backdrop,
        /// <summary>
        /// selection
        /// </summary>
        [EnumMember(Value = ("selection"))]
        Selection,
        /// <summary>
        /// search-text
        /// </summary>
        [EnumMember(Value = ("search-text"))]
        SearchText,
        /// <summary>
        /// target-text
        /// </summary>
        [EnumMember(Value = ("target-text"))]
        TargetText,
        /// <summary>
        /// spelling-error
        /// </summary>
        [EnumMember(Value = ("spelling-error"))]
        SpellingError,
        /// <summary>
        /// grammar-error
        /// </summary>
        [EnumMember(Value = ("grammar-error"))]
        GrammarError,
        /// <summary>
        /// highlight
        /// </summary>
        [EnumMember(Value = ("highlight"))]
        Highlight,
        /// <summary>
        /// first-line-inherited
        /// </summary>
        [EnumMember(Value = ("first-line-inherited"))]
        FirstLineInherited,
        /// <summary>
        /// scroll-marker
        /// </summary>
        [EnumMember(Value = ("scroll-marker"))]
        ScrollMarker,
        /// <summary>
        /// scroll-marker-group
        /// </summary>
        [EnumMember(Value = ("scroll-marker-group"))]
        ScrollMarkerGroup,
        /// <summary>
        /// scroll-next-button
        /// </summary>
        [EnumMember(Value = ("scroll-next-button"))]
        ScrollNextButton,
        /// <summary>
        /// scroll-prev-button
        /// </summary>
        [EnumMember(Value = ("scroll-prev-button"))]
        ScrollPrevButton,
        /// <summary>
        /// scrollbar
        /// </summary>
        [EnumMember(Value = ("scrollbar"))]
        Scrollbar,
        /// <summary>
        /// scrollbar-thumb
        /// </summary>
        [EnumMember(Value = ("scrollbar-thumb"))]
        ScrollbarThumb,
        /// <summary>
        /// scrollbar-button
        /// </summary>
        [EnumMember(Value = ("scrollbar-button"))]
        ScrollbarButton,
        /// <summary>
        /// scrollbar-track
        /// </summary>
        [EnumMember(Value = ("scrollbar-track"))]
        ScrollbarTrack,
        /// <summary>
        /// scrollbar-track-piece
        /// </summary>
        [EnumMember(Value = ("scrollbar-track-piece"))]
        ScrollbarTrackPiece,
        /// <summary>
        /// scrollbar-corner
        /// </summary>
        [EnumMember(Value = ("scrollbar-corner"))]
        ScrollbarCorner,
        /// <summary>
        /// resizer
        /// </summary>
        [EnumMember(Value = ("resizer"))]
        Resizer,
        /// <summary>
        /// input-list-button
        /// </summary>
        [EnumMember(Value = ("input-list-button"))]
        InputListButton,
        /// <summary>
        /// view-transition
        /// </summary>
        [EnumMember(Value = ("view-transition"))]
        ViewTransition,
        /// <summary>
        /// view-transition-group
        /// </summary>
        [EnumMember(Value = ("view-transition-group"))]
        ViewTransitionGroup,
        /// <summary>
        /// view-transition-image-pair
        /// </summary>
        [EnumMember(Value = ("view-transition-image-pair"))]
        ViewTransitionImagePair,
        /// <summary>
        /// view-transition-old
        /// </summary>
        [EnumMember(Value = ("view-transition-old"))]
        ViewTransitionOld,
        /// <summary>
        /// view-transition-new
        /// </summary>
        [EnumMember(Value = ("view-transition-new"))]
        ViewTransitionNew
    }

    /// <summary>
    /// Shadow root type.
    /// </summary>
    public enum ShadowRootType
    {
        /// <summary>
        /// user-agent
        /// </summary>
        [EnumMember(Value = ("user-agent"))]
        UserAgent,
        /// <summary>
        /// open
        /// </summary>
        [EnumMember(Value = ("open"))]
        Open,
        /// <summary>
        /// closed
        /// </summary>
        [EnumMember(Value = ("closed"))]
        Closed
    }

    /// <summary>
    /// Document compatibility mode.
    /// </summary>
    public enum CompatibilityMode
    {
        /// <summary>
        /// QuirksMode
        /// </summary>
        [EnumMember(Value = ("QuirksMode"))]
        QuirksMode,
        /// <summary>
        /// LimitedQuirksMode
        /// </summary>
        [EnumMember(Value = ("LimitedQuirksMode"))]
        LimitedQuirksMode,
        /// <summary>
        /// NoQuirksMode
        /// </summary>
        [EnumMember(Value = ("NoQuirksMode"))]
        NoQuirksMode
    }

    /// <summary>
    /// ContainerSelector physical axes
    /// </summary>
    public enum PhysicalAxes
    {
        /// <summary>
        /// Horizontal
        /// </summary>
        [EnumMember(Value = ("Horizontal"))]
        Horizontal,
        /// <summary>
        /// Vertical
        /// </summary>
        [EnumMember(Value = ("Vertical"))]
        Vertical,
        /// <summary>
        /// Both
        /// </summary>
        [EnumMember(Value = ("Both"))]
        Both
    }

    /// <summary>
    /// ContainerSelector logical axes
    /// </summary>
    public enum LogicalAxes
    {
        /// <summary>
        /// Inline
        /// </summary>
        [EnumMember(Value = ("Inline"))]
        Inline,
        /// <summary>
        /// Block
        /// </summary>
        [EnumMember(Value = ("Block"))]
        Block,
        /// <summary>
        /// Both
        /// </summary>
        [EnumMember(Value = ("Both"))]
        Both
    }

    /// <summary>
    /// Physical scroll orientation
    /// </summary>
    public enum ScrollOrientation
    {
        /// <summary>
        /// horizontal
        /// </summary>
        [EnumMember(Value = ("horizontal"))]
        Horizontal,
        /// <summary>
        /// vertical
        /// </summary>
        [EnumMember(Value = ("vertical"))]
        Vertical
    }

    /// <summary>
    /// DOM interaction is implemented in terms of mirror objects that represent the actual DOM nodes.
    /// DOMNode is a base node mirror type.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class Node : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Node identifier that is passed into the rest of the DOM messages as the `nodeId`. Backend
        /// will only push node with given `id` once. It is aware of all requested nodes and will only
        /// fire DOM events for nodes known to the client.
        /// </summary>
        [DataMember(Name = ("nodeId"), IsRequired = (true))]
        public int NodeId
        {
            get;
            set;
        }

        /// <summary>
        /// The id of the parent node if any.
        /// </summary>
        [DataMember(Name = ("parentId"), IsRequired = (false))]
        public int? ParentId
        {
            get;
            set;
        }

        /// <summary>
        /// The BackendNodeId for this node.
        /// </summary>
        [DataMember(Name = ("backendNodeId"), IsRequired = (true))]
        public int BackendNodeId
        {
            get;
            set;
        }

        /// <summary>
        /// `Node`&apos;s nodeType.
        /// </summary>
        [DataMember(Name = ("nodeType"), IsRequired = (true))]
        public int NodeType
        {
            get;
            set;
        }

        /// <summary>
        /// `Node`&apos;s nodeName.
        /// </summary>
        [DataMember(Name = ("nodeName"), IsRequired = (true))]
        public string NodeName
        {
            get;
            set;
        }

        /// <summary>
        /// `Node`&apos;s localName.
        /// </summary>
        [DataMember(Name = ("localName"), IsRequired = (true))]
        public string LocalName
        {
            get;
            set;
        }

        /// <summary>
        /// `Node`&apos;s nodeValue.
        /// </summary>
        [DataMember(Name = ("nodeValue"), IsRequired = (true))]
        public string NodeValue
        {
            get;
            set;
        }

        /// <summary>
        /// Child count for `Container` nodes.
        /// </summary>
        [DataMember(Name = ("childNodeCount"), IsRequired = (false))]
        public int? ChildNodeCount
        {
            get;
            set;
        }

        /// <summary>
        /// Child nodes of this node when requested with children.
        /// </summary>
        [DataMember(Name = ("children"), IsRequired = (false))]
        public System.Collections.Generic.IList<CefSharp.DevTools.DOM.Node> Children
        {
            get;
            set;
        }

        /// <summary>
        /// Attributes of the `Element` node in the form of flat array `[name1, value1, name2, value2]`.
        /// </summary>
        [DataMember(Name = ("attributes"), IsRequired = (false))]
        public string[] Attributes
        {
            get;
            set;
        }

        /// <summary>
        /// Document URL that `Document` or `FrameOwner` node points to.
        /// </summary>
        [DataMember(Name = ("documentURL"), IsRequired = (false))]
        public string DocumentURL
        {
            get;
            set;
        }

        /// <summary>
        /// Base URL that `Document` or `FrameOwner` node uses for URL completion.
        /// </summary>
        [DataMember(Name = ("baseURL"), IsRequired = (false))]
        public string BaseURL
        {
            get;
            set;
        }

        /// <summary>
        /// `DocumentType`&apos;s publicId.
        /// </summary>
        [DataMember(Name = ("publicId"), IsRequired = (false))]
        public string PublicId
        {
            get;
            set;
        }

        /// <summary>
        /// `DocumentType`&apos;s systemId.
        /// </summary>
        [DataMember(Name = ("systemId"), IsRequired = (false))]
        public string SystemId
        {
            get;
            set;
        }

        /// <summary>
        /// `DocumentType`&apos;s internalSubset.
        /// </summary>
        [DataMember(Name = ("internalSubset"), IsRequired = (false))]
        public string InternalSubset
        {
            get;
            set;
        }

        /// <summary>
        /// `Document`&apos;s XML version in case of XML documents.
        /// </summary>
        [DataMember(Name = ("xmlVersion"), IsRequired = (false))]
        public string XmlVersion
        {
            get;
            set;
        }

        /// <summary>
        /// `Attr`&apos;s name.
        /// </summary>
        [DataMember(Name = ("name"), IsRequired = (false))]
        public string Name
        {
            get;
            set;
        }

        /// <summary>
        /// `Attr`&apos;s value.
        /// </summary>
        [DataMember(Name = ("value"), IsRequired = (false))]
        public string Value
        {
            get;
            set;
        }

        /// <summary>
        /// Pseudo element type for this node.
        /// </summary>
        public CefSharp.DevTools.DOM.PseudoType? PseudoType
        {
            get
            {
                return (CefSharp.DevTools.DOM.PseudoType? )(StringToEnum(typeof(CefSharp.DevTools.DOM.PseudoType? ), pseudoType));
            }

            set
            {
                this.pseudoType = (EnumToString(value));
            }
        }

        /// <summary>
        /// Pseudo element type for this node.
        /// </summary>
        [DataMember(Name = ("pseudoType"), IsRequired = (false))]
        internal string pseudoType
        {
            get;
            set;
        }

        /// <summary>
        /// Pseudo element identifier for this node. Only present if there is a
        /// valid pseudoType.
        /// </summary>
        [DataMember(Name = ("pseudoIdentifier"), IsRequired = (false))]
        public string PseudoIdentifier
        {
            get;
            set;
        }

        /// <summary>
        /// Shadow root type.
        /// </summary>
        public CefSharp.DevTools.DOM.ShadowRootType? ShadowRootType
        {
            get
            {
                return (CefSharp.DevTools.DOM.ShadowRootType? )(StringToEnum(typeof(CefSharp.DevTools.DOM.ShadowRootType? ), shadowRootType));
            }

            set
            {
                this.shadowRootType = (EnumToString(value));
            }
        }

        /// <summary>
        /// Shadow root type.
        /// </summary>
        [DataMember(Name = ("shadowRootType"), IsRequired = (false))]
        internal string shadowRootType
        {
            get;
            set;
        }

        /// <summary>
        /// Frame ID for frame owner elements.
        /// </summary>
        [DataMember(Name = ("frameId"), IsRequired = (false))]
        public string FrameId
        {
            get;
            set;
        }

        /// <summary>
        /// Content document for frame owner elements.
        /// </summary>
        [DataMember(Name = ("contentDocument"), IsRequired = (false))]
        public CefSharp.DevTools.DOM.Node ContentDocument
        {
            get;
            set;
        }

        /// <summary>
        /// Shadow root list for given element host.
        /// </summary>
        [DataMember(Name = ("shadowRoots"), IsRequired = (false))]
        public System.Collections.Generic.IList<CefSharp.DevTools.DOM.Node> ShadowRoots
        {
            get;
            set;
        }

        /// <summary>
        /// Content document fragment for template elements.
        /// </summary>
        [DataMember(Name = ("templateContent"), IsRequired = (false))]
        public CefSharp.DevTools.DOM.Node TemplateContent
        {
            get;
            set;
        }

        /// <summary>
        /// Pseudo elements associated with this node.
        /// </summary>
        [DataMember(Name = ("pseudoElements"), IsRequired = (false))]
        public System.Collections.Generic.IList<CefSharp.DevTools.DOM.Node> PseudoElements
        {
            get;
            set;
        }

        /// <summary>
        /// Deprecated, as the HTML Imports API has been removed (crbug.com/937746).
        /// This property used to return the imported document for the HTMLImport links.
        /// The property is always undefined now.
        /// </summary>
        [DataMember(Name = ("importedDocument"), IsRequired = (false))]
        public CefSharp.DevTools.DOM.Node ImportedDocument
        {
            get;
            set;
        }

        /// <summary>
        /// Distributed nodes for given insertion point.
        /// </summary>
        [DataMember(Name = ("distributedNodes"), IsRequired = (false))]
        public System.Collections.Generic.IList<CefSharp.DevTools.DOM.BackendNode> DistributedNodes
        {
            get;
            set;
        }

        /// <summary>
        /// Whether the node is SVG.
        /// </summary>
        [DataMember(Name = ("isSVG"), IsRequired = (false))]
        public bool? IsSVG
        {
            get;
            set;
        }

        /// <summary>
        /// CompatibilityMode
        /// </summary>
        public CefSharp.DevTools.DOM.CompatibilityMode? CompatibilityMode
        {
            get
            {
                return (CefSharp.DevTools.DOM.CompatibilityMode? )(StringToEnum(typeof(CefSharp.DevTools.DOM.CompatibilityMode? ), compatibilityMode));
            }

            set
            {
                this.compatibilityMode = (EnumToString(value));
            }
        }

        /// <summary>
        /// CompatibilityMode
        /// </summary>
        [DataMember(Name = ("compatibilityMode"), IsRequired = (false))]
        internal string compatibilityMode
        {
            get;
            set;
        }

        /// <summary>
        /// AssignedSlot
        /// </summary>
        [DataMember(Name = ("assignedSlot"), IsRequired = (false))]
        public CefSharp.DevTools.DOM.BackendNode AssignedSlot
        {
            get;
            set;
        }
    }

    /// <summary>
    /// A structure to hold the top-level node of a detached tree and an array of its retained descendants.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class DetachedElementInfo : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// TreeNode
        /// </summary>
        [DataMember(Name = ("treeNode"), IsRequired = (true))]
        public CefSharp.DevTools.DOM.Node TreeNode
        {
            get;
            set;
        }

        /// <summary>
        /// RetainedNodeIds
        /// </summary>
        [DataMember(Name = ("retainedNodeIds"), IsRequired = (true))]
        public int[] RetainedNodeIds
        {
            get;
            set;
        }
    }

    /// <summary>
    /// A structure holding an RGBA color.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class RGBA : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The red component, in the [0-255] range.
        /// </summary>
        [DataMember(Name = ("r"), IsRequired = (true))]
        public int R
        {
            get;
            set;
        }

        /// <summary>
        /// The green component, in the [0-255] range.
        /// </summary>
        [DataMember(Name = ("g"), IsRequired = (true))]
        public int G
        {
            get;
            set;
        }

        /// <summary>
        /// The blue component, in the [0-255] range.
        /// </summary>
        [DataMember(Name = ("b"), IsRequired = (true))]
        public int B
        {
            get;
            set;
        }

        /// <summary>
        /// The alpha component, in the [0-1] range (default: 1).
        /// </summary>
        [DataMember(Name = ("a"), IsRequired = (false))]
        public double? A
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Box model.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class BoxModel : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Content box
        /// </summary>
        [DataMember(Name = ("content"), IsRequired = (true))]
        public double[] Content
        {
            get;
            set;
        }

        /// <summary>
        /// Padding box
        /// </summary>
        [DataMember(Name = ("padding"), IsRequired = (true))]
        public double[] Padding
        {
            get;
            set;
        }

        /// <summary>
        /// Border box
        /// </summary>
        [DataMember(Name = ("border"), IsRequired = (true))]
        public double[] Border
        {
            get;
            set;
        }

        /// <summary>
        /// Margin box
        /// </summary>
        [DataMember(Name = ("margin"), IsRequired = (true))]
        public double[] Margin
        {
            get;
            set;
        }

        /// <summary>
        /// Node width
        /// </summary>
        [DataMember(Name = ("width"), IsRequired = (true))]
        public int Width
        {
            get;
            set;
        }

        /// <summary>
        /// Node height
        /// </summary>
        [DataMember(Name = ("height"), IsRequired = (true))]
        public int Height
        {
            get;
            set;
        }

        /// <summary>
        /// Shape outside coordinates
        /// </summary>
        [DataMember(Name = ("shapeOutside"), IsRequired = (false))]
        public CefSharp.DevTools.DOM.ShapeOutsideInfo ShapeOutside
        {
            get;
            set;
        }
    }

    /// <summary>
    /// CSS Shape Outside details.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class ShapeOutsideInfo : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Shape bounds
        /// </summary>
        [DataMember(Name = ("bounds"), IsRequired = (true))]
        public double[] Bounds
        {
            get;
            set;
        }

        /// <summary>
        /// Shape coordinate details
        /// </summary>
        [DataMember(Name = ("shape"), IsRequired = (true))]
        public object[] Shape
        {
            get;
            set;
        }

        /// <summary>
        /// Margin shape bounds
        /// </summary>
        [DataMember(Name = ("marginShape"), IsRequired = (true))]
        public object[] MarginShape
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Rectangle.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class Rect : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// X coordinate
        /// </summary>
        [DataMember(Name = ("x"), IsRequired = (true))]
        public double X
        {
            get;
            set;
        }

        /// <summary>
        /// Y coordinate
        /// </summary>
        [DataMember(Name = ("y"), IsRequired = (true))]
        public double Y
        {
            get;
            set;
        }

        /// <summary>
        /// Rectangle width
        /// </summary>
        [DataMember(Name = ("width"), IsRequired = (true))]
        public double Width
        {
            get;
            set;
        }

        /// <summary>
        /// Rectangle height
        /// </summary>
        [DataMember(Name = ("height"), IsRequired = (true))]
        public double Height
        {
            get;
            set;
        }
    }

    /// <summary>
    /// CSSComputedStyleProperty
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class CSSComputedStyleProperty : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Computed style property name.
        /// </summary>
        [DataMember(Name = ("name"), IsRequired = (true))]
        public string Name
        {
            get;
            set;
        }

        /// <summary>
        /// Computed style property value.
        /// </summary>
        [DataMember(Name = ("value"), IsRequired = (true))]
        public string Value
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Fired when `Element`&apos;s attribute is modified.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class AttributeModifiedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Id of the node that has changed.
        /// </summary>
        [DataMember(Name = ("nodeId"), IsRequired = (true))]
        public int NodeId
        {
            get;
            private set;
        }

        /// <summary>
        /// Attribute name.
        /// </summary>
        [DataMember(Name = ("name"), IsRequired = (true))]
        public string Name
        {
            get;
            private set;
        }

        /// <summary>
        /// Attribute value.
        /// </summary>
        [DataMember(Name = ("value"), IsRequired = (true))]
        public string Value
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired when `Element`&apos;s attribute is removed.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class AttributeRemovedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Id of the node that has changed.
        /// </summary>
        [DataMember(Name = ("nodeId"), IsRequired = (true))]
        public int NodeId
        {
            get;
            private set;
        }

        /// <summary>
        /// A ttribute name.
        /// </summary>
        [DataMember(Name = ("name"), IsRequired = (true))]
        public string Name
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Mirrors `DOMCharacterDataModified` event.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class CharacterDataModifiedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Id of the node that has changed.
        /// </summary>
        [DataMember(Name = ("nodeId"), IsRequired = (true))]
        public int NodeId
        {
            get;
            private set;
        }

        /// <summary>
        /// New text value.
        /// </summary>
        [DataMember(Name = ("characterData"), IsRequired = (true))]
        public string CharacterData
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired when `Container`&apos;s child node count has changed.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class ChildNodeCountUpdatedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Id of the node that has changed.
        /// </summary>
        [DataMember(Name = ("nodeId"), IsRequired = (true))]
        public int NodeId
        {
            get;
            private set;
        }

        /// <summary>
        /// New node count.
        /// </summary>
        [DataMember(Name = ("childNodeCount"), IsRequired = (true))]
        public int ChildNodeCount
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Mirrors `DOMNodeInserted` event.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class ChildNodeInsertedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Id of the node that has changed.
        /// </summary>
        [DataMember(Name = ("parentNodeId"), IsRequired = (true))]
        public int ParentNodeId
        {
            get;
            private set;
        }

        /// <summary>
        /// Id of the previous sibling.
        /// </summary>
        [DataMember(Name = ("previousNodeId"), IsRequired = (true))]
        public int PreviousNodeId
        {
            get;
            private set;
        }

        /// <summary>
        /// Inserted node data.
        /// </summary>
        [DataMember(Name = ("node"), IsRequired = (true))]
        public CefSharp.DevTools.DOM.Node Node
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Mirrors `DOMNodeRemoved` event.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class ChildNodeRemovedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Parent id.
        /// </summary>
        [DataMember(Name = ("parentNodeId"), IsRequired = (true))]
        public int ParentNodeId
        {
            get;
            private set;
        }

        /// <summary>
        /// Id of the node that has been removed.
        /// </summary>
        [DataMember(Name = ("nodeId"), IsRequired = (true))]
        public int NodeId
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Called when distribution is changed.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class DistributedNodesUpdatedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Insertion point where distributed nodes were updated.
        /// </summary>
        [DataMember(Name = ("insertionPointId"), IsRequired = (true))]
        public int InsertionPointId
        {
            get;
            private set;
        }

        /// <summary>
        /// Distributed nodes for given insertion point.
        /// </summary>
        [DataMember(Name = ("distributedNodes"), IsRequired = (true))]
        public System.Collections.Generic.IList<CefSharp.DevTools.DOM.BackendNode> DistributedNodes
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired when `Element`&apos;s inline style is modified via a CSS property modification.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class InlineStyleInvalidatedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Ids of the nodes for which the inline styles have been invalidated.
        /// </summary>
        [DataMember(Name = ("nodeIds"), IsRequired = (true))]
        public int[] NodeIds
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Called when a pseudo element is added to an element.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class PseudoElementAddedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Pseudo element&apos;s parent element id.
        /// </summary>
        [DataMember(Name = ("parentId"), IsRequired = (true))]
        public int ParentId
        {
            get;
            private set;
        }

        /// <summary>
        /// The added pseudo element.
        /// </summary>
        [DataMember(Name = ("pseudoElement"), IsRequired = (true))]
        public CefSharp.DevTools.DOM.Node PseudoElement
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Called when a pseudo element is removed from an element.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class PseudoElementRemovedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Pseudo element&apos;s parent element id.
        /// </summary>
        [DataMember(Name = ("parentId"), IsRequired = (true))]
        public int ParentId
        {
            get;
            private set;
        }

        /// <summary>
        /// The removed pseudo element id.
        /// </summary>
        [DataMember(Name = ("pseudoElementId"), IsRequired = (true))]
        public int PseudoElementId
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired when backend wants to provide client with the missing DOM structure. This happens upon
    /// most of the calls requesting node ids.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class SetChildNodesEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Parent node id to populate with children.
        /// </summary>
        [DataMember(Name = ("parentId"), IsRequired = (true))]
        public int ParentId
        {
            get;
            private set;
        }

        /// <summary>
        /// Child nodes array.
        /// </summary>
        [DataMember(Name = ("nodes"), IsRequired = (true))]
        public System.Collections.Generic.IList<CefSharp.DevTools.DOM.Node> Nodes
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Called when shadow root is popped from the element.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class ShadowRootPoppedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Host element id.
        /// </summary>
        [DataMember(Name = ("hostId"), IsRequired = (true))]
        public int HostId
        {
            get;
            private set;
        }

        /// <summary>
        /// Shadow root id.
        /// </summary>
        [DataMember(Name = ("rootId"), IsRequired = (true))]
        public int RootId
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Called when shadow root is pushed into the element.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class ShadowRootPushedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Host element id.
        /// </summary>
        [DataMember(Name = ("hostId"), IsRequired = (true))]
        public int HostId
        {
            get;
            private set;
        }

        /// <summary>
        /// Shadow root.
        /// </summary>
        [DataMember(Name = ("root"), IsRequired = (true))]
        public CefSharp.DevTools.DOM.Node Root
        {
            get;
            private set;
        }
    }
}

namespace CefSharp.DevTools.DOMDebugger
{
    /// <summary>
    /// DOM breakpoint type.
    /// </summary>
    public enum DOMBreakpointType
    {
        /// <summary>
        /// subtree-modified
        /// </summary>
        [EnumMember(Value = ("subtree-modified"))]
        SubtreeModified,
        /// <summary>
        /// attribute-modified
        /// </summary>
        [EnumMember(Value = ("attribute-modified"))]
        AttributeModified,
        /// <summary>
        /// node-removed
        /// </summary>
        [EnumMember(Value = ("node-removed"))]
        NodeRemoved
    }

    /// <summary>
    /// CSP Violation type.
    /// </summary>
    public enum CSPViolationType
    {
        /// <summary>
        /// trustedtype-sink-violation
        /// </summary>
        [EnumMember(Value = ("trustedtype-sink-violation"))]
        TrustedtypeSinkViolation,
        /// <summary>
        /// trustedtype-policy-violation
        /// </summary>
        [EnumMember(Value = ("trustedtype-policy-violation"))]
        TrustedtypePolicyViolation
    }

    /// <summary>
    /// Object event listener.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class EventListener : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// `EventListener`&apos;s type.
        /// </summary>
        [DataMember(Name = ("type"), IsRequired = (true))]
        public string Type
        {
            get;
            set;
        }

        /// <summary>
        /// `EventListener`&apos;s useCapture.
        /// </summary>
        [DataMember(Name = ("useCapture"), IsRequired = (true))]
        public bool UseCapture
        {
            get;
            set;
        }

        /// <summary>
        /// `EventListener`&apos;s passive flag.
        /// </summary>
        [DataMember(Name = ("passive"), IsRequired = (true))]
        public bool Passive
        {
            get;
            set;
        }

        /// <summary>
        /// `EventListener`&apos;s once flag.
        /// </summary>
        [DataMember(Name = ("once"), IsRequired = (true))]
        public bool Once
        {
            get;
            set;
        }

        /// <summary>
        /// Script id of the handler code.
        /// </summary>
        [DataMember(Name = ("scriptId"), IsRequired = (true))]
        public string ScriptId
        {
            get;
            set;
        }

        /// <summary>
        /// Line number in the script (0-based).
        /// </summary>
        [DataMember(Name = ("lineNumber"), IsRequired = (true))]
        public int LineNumber
        {
            get;
            set;
        }

        /// <summary>
        /// Column number in the script (0-based).
        /// </summary>
        [DataMember(Name = ("columnNumber"), IsRequired = (true))]
        public int ColumnNumber
        {
            get;
            set;
        }

        /// <summary>
        /// Event handler function value.
        /// </summary>
        [DataMember(Name = ("handler"), IsRequired = (false))]
        public CefSharp.DevTools.Runtime.RemoteObject Handler
        {
            get;
            set;
        }

        /// <summary>
        /// Event original handler function value.
        /// </summary>
        [DataMember(Name = ("originalHandler"), IsRequired = (false))]
        public CefSharp.DevTools.Runtime.RemoteObject OriginalHandler
        {
            get;
            set;
        }

        /// <summary>
        /// Node the listener is added to (if any).
        /// </summary>
        [DataMember(Name = ("backendNodeId"), IsRequired = (false))]
        public int? BackendNodeId
        {
            get;
            set;
        }
    }
}

namespace CefSharp.DevTools.DOMSnapshot
{
    /// <summary>
    /// A Node in the DOM tree.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class DOMNode : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// `Node`&apos;s nodeType.
        /// </summary>
        [DataMember(Name = ("nodeType"), IsRequired = (true))]
        public int NodeType
        {
            get;
            set;
        }

        /// <summary>
        /// `Node`&apos;s nodeName.
        /// </summary>
        [DataMember(Name = ("nodeName"), IsRequired = (true))]
        public string NodeName
        {
            get;
            set;
        }

        /// <summary>
        /// `Node`&apos;s nodeValue.
        /// </summary>
        [DataMember(Name = ("nodeValue"), IsRequired = (true))]
        public string NodeValue
        {
            get;
            set;
        }

        /// <summary>
        /// Only set for textarea elements, contains the text value.
        /// </summary>
        [DataMember(Name = ("textValue"), IsRequired = (false))]
        public string TextValue
        {
            get;
            set;
        }

        /// <summary>
        /// Only set for input elements, contains the input&apos;s associated text value.
        /// </summary>
        [DataMember(Name = ("inputValue"), IsRequired = (false))]
        public string InputValue
        {
            get;
            set;
        }

        /// <summary>
        /// Only set for radio and checkbox input elements, indicates if the element has been checked
        /// </summary>
        [DataMember(Name = ("inputChecked"), IsRequired = (false))]
        public bool? InputChecked
        {
            get;
            set;
        }

        /// <summary>
        /// Only set for option elements, indicates if the element has been selected
        /// </summary>
        [DataMember(Name = ("optionSelected"), IsRequired = (false))]
        public bool? OptionSelected
        {
            get;
            set;
        }

        /// <summary>
        /// `Node`&apos;s id, corresponds to DOM.Node.backendNodeId.
        /// </summary>
        [DataMember(Name = ("backendNodeId"), IsRequired = (true))]
        public int BackendNodeId
        {
            get;
            set;
        }

        /// <summary>
        /// The indexes of the node&apos;s child nodes in the `domNodes` array returned by `getSnapshot`, if
        /// any.
        /// </summary>
        [DataMember(Name = ("childNodeIndexes"), IsRequired = (false))]
        public int[] ChildNodeIndexes
        {
            get;
            set;
        }

        /// <summary>
        /// Attributes of an `Element` node.
        /// </summary>
        [DataMember(Name = ("attributes"), IsRequired = (false))]
        public System.Collections.Generic.IList<CefSharp.DevTools.DOMSnapshot.NameValue> Attributes
        {
            get;
            set;
        }

        /// <summary>
        /// Indexes of pseudo elements associated with this node in the `domNodes` array returned by
        /// `getSnapshot`, if any.
        /// </summary>
        [DataMember(Name = ("pseudoElementIndexes"), IsRequired = (false))]
        public int[] PseudoElementIndexes
        {
            get;
            set;
        }

        /// <summary>
        /// The index of the node&apos;s related layout tree node in the `layoutTreeNodes` array returned by
        /// `getSnapshot`, if any.
        /// </summary>
        [DataMember(Name = ("layoutNodeIndex"), IsRequired = (false))]
        public int? LayoutNodeIndex
        {
            get;
            set;
        }

        /// <summary>
        /// Document URL that `Document` or `FrameOwner` node points to.
        /// </summary>
        [DataMember(Name = ("documentURL"), IsRequired = (false))]
        public string DocumentURL
        {
            get;
            set;
        }

        /// <summary>
        /// Base URL that `Document` or `FrameOwner` node uses for URL completion.
        /// </summary>
        [DataMember(Name = ("baseURL"), IsRequired = (false))]
        public string BaseURL
        {
            get;
            set;
        }

        /// <summary>
        /// Only set for documents, contains the document&apos;s content language.
        /// </summary>
        [DataMember(Name = ("contentLanguage"), IsRequired = (false))]
        public string ContentLanguage
        {
            get;
            set;
        }

        /// <summary>
        /// Only set for documents, contains the document&apos;s character set encoding.
        /// </summary>
        [DataMember(Name = ("documentEncoding"), IsRequired = (false))]
        public string DocumentEncoding
        {
            get;
            set;
        }

        /// <summary>
        /// `DocumentType` node&apos;s publicId.
        /// </summary>
        [DataMember(Name = ("publicId"), IsRequired = (false))]
        public string PublicId
        {
            get;
            set;
        }

        /// <summary>
        /// `DocumentType` node&apos;s systemId.
        /// </summary>
        [DataMember(Name = ("systemId"), IsRequired = (false))]
        public string SystemId
        {
            get;
            set;
        }

        /// <summary>
        /// Frame ID for frame owner elements and also for the document node.
        /// </summary>
        [DataMember(Name = ("frameId"), IsRequired = (false))]
        public string FrameId
        {
            get;
            set;
        }

        /// <summary>
        /// The index of a frame owner element&apos;s content document in the `domNodes` array returned by
        /// `getSnapshot`, if any.
        /// </summary>
        [DataMember(Name = ("contentDocumentIndex"), IsRequired = (false))]
        public int? ContentDocumentIndex
        {
            get;
            set;
        }

        /// <summary>
        /// Type of a pseudo element node.
        /// </summary>
        public CefSharp.DevTools.DOM.PseudoType? PseudoType
        {
            get
            {
                return (CefSharp.DevTools.DOM.PseudoType? )(StringToEnum(typeof(CefSharp.DevTools.DOM.PseudoType? ), pseudoType));
            }

            set
            {
                this.pseudoType = (EnumToString(value));
            }
        }

        /// <summary>
        /// Type of a pseudo element node.
        /// </summary>
        [DataMember(Name = ("pseudoType"), IsRequired = (false))]
        internal string pseudoType
        {
            get;
            set;
        }

        /// <summary>
        /// Shadow root type.
        /// </summary>
        public CefSharp.DevTools.DOM.ShadowRootType? ShadowRootType
        {
            get
            {
                return (CefSharp.DevTools.DOM.ShadowRootType? )(StringToEnum(typeof(CefSharp.DevTools.DOM.ShadowRootType? ), shadowRootType));
            }

            set
            {
                this.shadowRootType = (EnumToString(value));
            }
        }

        /// <summary>
        /// Shadow root type.
        /// </summary>
        [DataMember(Name = ("shadowRootType"), IsRequired = (false))]
        internal string shadowRootType
        {
            get;
            set;
        }

        /// <summary>
        /// Whether this DOM node responds to mouse clicks. This includes nodes that have had click
        /// event listeners attached via JavaScript as well as anchor tags that naturally navigate when
        /// clicked.
        /// </summary>
        [DataMember(Name = ("isClickable"), IsRequired = (false))]
        public bool? IsClickable
        {
            get;
            set;
        }

        /// <summary>
        /// Details of the node&apos;s event listeners, if any.
        /// </summary>
        [DataMember(Name = ("eventListeners"), IsRequired = (false))]
        public System.Collections.Generic.IList<CefSharp.DevTools.DOMDebugger.EventListener> EventListeners
        {
            get;
            set;
        }

        /// <summary>
        /// The selected url for nodes with a srcset attribute.
        /// </summary>
        [DataMember(Name = ("currentSourceURL"), IsRequired = (false))]
        public string CurrentSourceURL
        {
            get;
            set;
        }

        /// <summary>
        /// The url of the script (if any) that generates this node.
        /// </summary>
        [DataMember(Name = ("originURL"), IsRequired = (false))]
        public string OriginURL
        {
            get;
            set;
        }

        /// <summary>
        /// Scroll offsets, set when this node is a Document.
        /// </summary>
        [DataMember(Name = ("scrollOffsetX"), IsRequired = (false))]
        public double? ScrollOffsetX
        {
            get;
            set;
        }

        /// <summary>
        /// ScrollOffsetY
        /// </summary>
        [DataMember(Name = ("scrollOffsetY"), IsRequired = (false))]
        public double? ScrollOffsetY
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Details of post layout rendered text positions. The exact layout should not be regarded as
    /// stable and may change between versions.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class InlineTextBox : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The bounding box in document coordinates. Note that scroll offset of the document is ignored.
        /// </summary>
        [DataMember(Name = ("boundingBox"), IsRequired = (true))]
        public CefSharp.DevTools.DOM.Rect BoundingBox
        {
            get;
            set;
        }

        /// <summary>
        /// The starting index in characters, for this post layout textbox substring. Characters that
        /// would be represented as a surrogate pair in UTF-16 have length 2.
        /// </summary>
        [DataMember(Name = ("startCharacterIndex"), IsRequired = (true))]
        public int StartCharacterIndex
        {
            get;
            set;
        }

        /// <summary>
        /// The number of characters in this post layout textbox substring. Characters that would be
        /// represented as a surrogate pair in UTF-16 have length 2.
        /// </summary>
        [DataMember(Name = ("numCharacters"), IsRequired = (true))]
        public int NumCharacters
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Details of an element in the DOM tree with a LayoutObject.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class LayoutTreeNode : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The index of the related DOM node in the `domNodes` array returned by `getSnapshot`.
        /// </summary>
        [DataMember(Name = ("domNodeIndex"), IsRequired = (true))]
        public int DomNodeIndex
        {
            get;
            set;
        }

        /// <summary>
        /// The bounding box in document coordinates. Note that scroll offset of the document is ignored.
        /// </summary>
        [DataMember(Name = ("boundingBox"), IsRequired = (true))]
        public CefSharp.DevTools.DOM.Rect BoundingBox
        {
            get;
            set;
        }

        /// <summary>
        /// Contents of the LayoutText, if any.
        /// </summary>
        [DataMember(Name = ("layoutText"), IsRequired = (false))]
        public string LayoutText
        {
            get;
            set;
        }

        /// <summary>
        /// The post-layout inline text nodes, if any.
        /// </summary>
        [DataMember(Name = ("inlineTextNodes"), IsRequired = (false))]
        public System.Collections.Generic.IList<CefSharp.DevTools.DOMSnapshot.InlineTextBox> InlineTextNodes
        {
            get;
            set;
        }

        /// <summary>
        /// Index into the `computedStyles` array returned by `getSnapshot`.
        /// </summary>
        [DataMember(Name = ("styleIndex"), IsRequired = (false))]
        public int? StyleIndex
        {
            get;
            set;
        }

        /// <summary>
        /// Global paint order index, which is determined by the stacking order of the nodes. Nodes
        /// that are painted together will have the same index. Only provided if includePaintOrder in
        /// getSnapshot was true.
        /// </summary>
        [DataMember(Name = ("paintOrder"), IsRequired = (false))]
        public int? PaintOrder
        {
            get;
            set;
        }

        /// <summary>
        /// Set to true to indicate the element begins a new stacking context.
        /// </summary>
        [DataMember(Name = ("isStackingContext"), IsRequired = (false))]
        public bool? IsStackingContext
        {
            get;
            set;
        }
    }

    /// <summary>
    /// A subset of the full ComputedStyle as defined by the request whitelist.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class ComputedStyle : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Name/value pairs of computed style properties.
        /// </summary>
        [DataMember(Name = ("properties"), IsRequired = (true))]
        public System.Collections.Generic.IList<CefSharp.DevTools.DOMSnapshot.NameValue> Properties
        {
            get;
            set;
        }
    }

    /// <summary>
    /// A name/value pair.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class NameValue : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Attribute/property name.
        /// </summary>
        [DataMember(Name = ("name"), IsRequired = (true))]
        public string Name
        {
            get;
            set;
        }

        /// <summary>
        /// Attribute/property value.
        /// </summary>
        [DataMember(Name = ("value"), IsRequired = (true))]
        public string Value
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Data that is only present on rare nodes.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class RareStringData : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Index
        /// </summary>
        [DataMember(Name = ("index"), IsRequired = (true))]
        public int[] Index
        {
            get;
            set;
        }

        /// <summary>
        /// Value
        /// </summary>
        [DataMember(Name = ("value"), IsRequired = (true))]
        public int[] Value
        {
            get;
            set;
        }
    }

    /// <summary>
    /// RareBooleanData
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class RareBooleanData : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Index
        /// </summary>
        [DataMember(Name = ("index"), IsRequired = (true))]
        public int[] Index
        {
            get;
            set;
        }
    }

    /// <summary>
    /// RareIntegerData
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class RareIntegerData : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Index
        /// </summary>
        [DataMember(Name = ("index"), IsRequired = (true))]
        public int[] Index
        {
            get;
            set;
        }

        /// <summary>
        /// Value
        /// </summary>
        [DataMember(Name = ("value"), IsRequired = (true))]
        public int[] Value
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Document snapshot.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class DocumentSnapshot : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Document URL that `Document` or `FrameOwner` node points to.
        /// </summary>
        [DataMember(Name = ("documentURL"), IsRequired = (true))]
        public int DocumentURL
        {
            get;
            set;
        }

        /// <summary>
        /// Document title.
        /// </summary>
        [DataMember(Name = ("title"), IsRequired = (true))]
        public int Title
        {
            get;
            set;
        }

        /// <summary>
        /// Base URL that `Document` or `FrameOwner` node uses for URL completion.
        /// </summary>
        [DataMember(Name = ("baseURL"), IsRequired = (true))]
        public int BaseURL
        {
            get;
            set;
        }

        /// <summary>
        /// Contains the document&apos;s content language.
        /// </summary>
        [DataMember(Name = ("contentLanguage"), IsRequired = (true))]
        public int ContentLanguage
        {
            get;
            set;
        }

        /// <summary>
        /// Contains the document&apos;s character set encoding.
        /// </summary>
        [DataMember(Name = ("encodingName"), IsRequired = (true))]
        public int EncodingName
        {
            get;
            set;
        }

        /// <summary>
        /// `DocumentType` node&apos;s publicId.
        /// </summary>
        [DataMember(Name = ("publicId"), IsRequired = (true))]
        public int PublicId
        {
            get;
            set;
        }

        /// <summary>
        /// `DocumentType` node&apos;s systemId.
        /// </summary>
        [DataMember(Name = ("systemId"), IsRequired = (true))]
        public int SystemId
        {
            get;
            set;
        }

        /// <summary>
        /// Frame ID for frame owner elements and also for the document node.
        /// </summary>
        [DataMember(Name = ("frameId"), IsRequired = (true))]
        public int FrameId
        {
            get;
            set;
        }

        /// <summary>
        /// A table with dom nodes.
        /// </summary>
        [DataMember(Name = ("nodes"), IsRequired = (true))]
        public CefSharp.DevTools.DOMSnapshot.NodeTreeSnapshot Nodes
        {
            get;
            set;
        }

        /// <summary>
        /// The nodes in the layout tree.
        /// </summary>
        [DataMember(Name = ("layout"), IsRequired = (true))]
        public CefSharp.DevTools.DOMSnapshot.LayoutTreeSnapshot Layout
        {
            get;
            set;
        }

        /// <summary>
        /// The post-layout inline text nodes.
        /// </summary>
        [DataMember(Name = ("textBoxes"), IsRequired = (true))]
        public CefSharp.DevTools.DOMSnapshot.TextBoxSnapshot TextBoxes
        {
            get;
            set;
        }

        /// <summary>
        /// Horizontal scroll offset.
        /// </summary>
        [DataMember(Name = ("scrollOffsetX"), IsRequired = (false))]
        public double? ScrollOffsetX
        {
            get;
            set;
        }

        /// <summary>
        /// Vertical scroll offset.
        /// </summary>
        [DataMember(Name = ("scrollOffsetY"), IsRequired = (false))]
        public double? ScrollOffsetY
        {
            get;
            set;
        }

        /// <summary>
        /// Document content width.
        /// </summary>
        [DataMember(Name = ("contentWidth"), IsRequired = (false))]
        public double? ContentWidth
        {
            get;
            set;
        }

        /// <summary>
        /// Document content height.
        /// </summary>
        [DataMember(Name = ("contentHeight"), IsRequired = (false))]
        public double? ContentHeight
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Table containing nodes.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class NodeTreeSnapshot : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Parent node index.
        /// </summary>
        [DataMember(Name = ("parentIndex"), IsRequired = (false))]
        public int[] ParentIndex
        {
            get;
            set;
        }

        /// <summary>
        /// `Node`&apos;s nodeType.
        /// </summary>
        [DataMember(Name = ("nodeType"), IsRequired = (false))]
        public int[] NodeType
        {
            get;
            set;
        }

        /// <summary>
        /// Type of the shadow root the `Node` is in. String values are equal to the `ShadowRootType` enum.
        /// </summary>
        [DataMember(Name = ("shadowRootType"), IsRequired = (false))]
        public CefSharp.DevTools.DOMSnapshot.RareStringData ShadowRootType
        {
            get;
            set;
        }

        /// <summary>
        /// `Node`&apos;s nodeName.
        /// </summary>
        [DataMember(Name = ("nodeName"), IsRequired = (false))]
        public int[] NodeName
        {
            get;
            set;
        }

        /// <summary>
        /// `Node`&apos;s nodeValue.
        /// </summary>
        [DataMember(Name = ("nodeValue"), IsRequired = (false))]
        public int[] NodeValue
        {
            get;
            set;
        }

        /// <summary>
        /// `Node`&apos;s id, corresponds to DOM.Node.backendNodeId.
        /// </summary>
        [DataMember(Name = ("backendNodeId"), IsRequired = (false))]
        public int[] BackendNodeId
        {
            get;
            set;
        }

        /// <summary>
        /// Attributes of an `Element` node. Flatten name, value pairs.
        /// </summary>
        [DataMember(Name = ("attributes"), IsRequired = (false))]
        public int[] Attributes
        {
            get;
            set;
        }

        /// <summary>
        /// Only set for textarea elements, contains the text value.
        /// </summary>
        [DataMember(Name = ("textValue"), IsRequired = (false))]
        public CefSharp.DevTools.DOMSnapshot.RareStringData TextValue
        {
            get;
            set;
        }

        /// <summary>
        /// Only set for input elements, contains the input&apos;s associated text value.
        /// </summary>
        [DataMember(Name = ("inputValue"), IsRequired = (false))]
        public CefSharp.DevTools.DOMSnapshot.RareStringData InputValue
        {
            get;
            set;
        }

        /// <summary>
        /// Only set for radio and checkbox input elements, indicates if the element has been checked
        /// </summary>
        [DataMember(Name = ("inputChecked"), IsRequired = (false))]
        public CefSharp.DevTools.DOMSnapshot.RareBooleanData InputChecked
        {
            get;
            set;
        }

        /// <summary>
        /// Only set for option elements, indicates if the element has been selected
        /// </summary>
        [DataMember(Name = ("optionSelected"), IsRequired = (false))]
        public CefSharp.DevTools.DOMSnapshot.RareBooleanData OptionSelected
        {
            get;
            set;
        }

        /// <summary>
        /// The index of the document in the list of the snapshot documents.
        /// </summary>
        [DataMember(Name = ("contentDocumentIndex"), IsRequired = (false))]
        public CefSharp.DevTools.DOMSnapshot.RareIntegerData ContentDocumentIndex
        {
            get;
            set;
        }

        /// <summary>
        /// Type of a pseudo element node.
        /// </summary>
        [DataMember(Name = ("pseudoType"), IsRequired = (false))]
        public CefSharp.DevTools.DOMSnapshot.RareStringData PseudoType
        {
            get;
            set;
        }

        /// <summary>
        /// Pseudo element identifier for this node. Only present if there is a
        /// valid pseudoType.
        /// </summary>
        [DataMember(Name = ("pseudoIdentifier"), IsRequired = (false))]
        public CefSharp.DevTools.DOMSnapshot.RareStringData PseudoIdentifier
        {
            get;
            set;
        }

        /// <summary>
        /// Whether this DOM node responds to mouse clicks. This includes nodes that have had click
        /// event listeners attached via JavaScript as well as anchor tags that naturally navigate when
        /// clicked.
        /// </summary>
        [DataMember(Name = ("isClickable"), IsRequired = (false))]
        public CefSharp.DevTools.DOMSnapshot.RareBooleanData IsClickable
        {
            get;
            set;
        }

        /// <summary>
        /// The selected url for nodes with a srcset attribute.
        /// </summary>
        [DataMember(Name = ("currentSourceURL"), IsRequired = (false))]
        public CefSharp.DevTools.DOMSnapshot.RareStringData CurrentSourceURL
        {
            get;
            set;
        }

        /// <summary>
        /// The url of the script (if any) that generates this node.
        /// </summary>
        [DataMember(Name = ("originURL"), IsRequired = (false))]
        public CefSharp.DevTools.DOMSnapshot.RareStringData OriginURL
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Table of details of an element in the DOM tree with a LayoutObject.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class LayoutTreeSnapshot : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Index of the corresponding node in the `NodeTreeSnapshot` array returned by `captureSnapshot`.
        /// </summary>
        [DataMember(Name = ("nodeIndex"), IsRequired = (true))]
        public int[] NodeIndex
        {
            get;
            set;
        }

        /// <summary>
        /// Array of indexes specifying computed style strings, filtered according to the `computedStyles` parameter passed to `captureSnapshot`.
        /// </summary>
        [DataMember(Name = ("styles"), IsRequired = (true))]
        public int[] Styles
        {
            get;
            set;
        }

        /// <summary>
        /// The absolute position bounding box.
        /// </summary>
        [DataMember(Name = ("bounds"), IsRequired = (true))]
        public double[] Bounds
        {
            get;
            set;
        }

        /// <summary>
        /// Contents of the LayoutText, if any.
        /// </summary>
        [DataMember(Name = ("text"), IsRequired = (true))]
        public int[] Text
        {
            get;
            set;
        }

        /// <summary>
        /// Stacking context information.
        /// </summary>
        [DataMember(Name = ("stackingContexts"), IsRequired = (true))]
        public CefSharp.DevTools.DOMSnapshot.RareBooleanData StackingContexts
        {
            get;
            set;
        }

        /// <summary>
        /// Global paint order index, which is determined by the stacking order of the nodes. Nodes
        /// that are painted together will have the same index. Only provided if includePaintOrder in
        /// captureSnapshot was true.
        /// </summary>
        [DataMember(Name = ("paintOrders"), IsRequired = (false))]
        public int[] PaintOrders
        {
            get;
            set;
        }

        /// <summary>
        /// The offset rect of nodes. Only available when includeDOMRects is set to true
        /// </summary>
        [DataMember(Name = ("offsetRects"), IsRequired = (false))]
        public double[] OffsetRects
        {
            get;
            set;
        }

        /// <summary>
        /// The scroll rect of nodes. Only available when includeDOMRects is set to true
        /// </summary>
        [DataMember(Name = ("scrollRects"), IsRequired = (false))]
        public double[] ScrollRects
        {
            get;
            set;
        }

        /// <summary>
        /// The client rect of nodes. Only available when includeDOMRects is set to true
        /// </summary>
        [DataMember(Name = ("clientRects"), IsRequired = (false))]
        public double[] ClientRects
        {
            get;
            set;
        }

        /// <summary>
        /// The list of background colors that are blended with colors of overlapping elements.
        /// </summary>
        [DataMember(Name = ("blendedBackgroundColors"), IsRequired = (false))]
        public int[] BlendedBackgroundColors
        {
            get;
            set;
        }

        /// <summary>
        /// The list of computed text opacities.
        /// </summary>
        [DataMember(Name = ("textColorOpacities"), IsRequired = (false))]
        public double[] TextColorOpacities
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Table of details of the post layout rendered text positions. The exact layout should not be regarded as
    /// stable and may change between versions.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class TextBoxSnapshot : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Index of the layout tree node that owns this box collection.
        /// </summary>
        [DataMember(Name = ("layoutIndex"), IsRequired = (true))]
        public int[] LayoutIndex
        {
            get;
            set;
        }

        /// <summary>
        /// The absolute position bounding box.
        /// </summary>
        [DataMember(Name = ("bounds"), IsRequired = (true))]
        public double[] Bounds
        {
            get;
            set;
        }

        /// <summary>
        /// The starting index in characters, for this post layout textbox substring. Characters that
        /// would be represented as a surrogate pair in UTF-16 have length 2.
        /// </summary>
        [DataMember(Name = ("start"), IsRequired = (true))]
        public int[] Start
        {
            get;
            set;
        }

        /// <summary>
        /// The number of characters in this post layout textbox substring. Characters that would be
        /// represented as a surrogate pair in UTF-16 have length 2.
        /// </summary>
        [DataMember(Name = ("length"), IsRequired = (true))]
        public int[] Length
        {
            get;
            set;
        }
    }
}

namespace CefSharp.DevTools.DOMStorage
{
    /// <summary>
    /// DOM Storage identifier.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class StorageId : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Security origin for the storage.
        /// </summary>
        [DataMember(Name = ("securityOrigin"), IsRequired = (false))]
        public string SecurityOrigin
        {
            get;
            set;
        }

        /// <summary>
        /// Represents a key by which DOM Storage keys its CachedStorageAreas
        /// </summary>
        [DataMember(Name = ("storageKey"), IsRequired = (false))]
        public string StorageKey
        {
            get;
            set;
        }

        /// <summary>
        /// Whether the storage is local storage (not session storage).
        /// </summary>
        [DataMember(Name = ("isLocalStorage"), IsRequired = (true))]
        public bool IsLocalStorage
        {
            get;
            set;
        }
    }

    /// <summary>
    /// domStorageItemAdded
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class DomStorageItemAddedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// StorageId
        /// </summary>
        [DataMember(Name = ("storageId"), IsRequired = (true))]
        public CefSharp.DevTools.DOMStorage.StorageId StorageId
        {
            get;
            private set;
        }

        /// <summary>
        /// Key
        /// </summary>
        [DataMember(Name = ("key"), IsRequired = (true))]
        public string Key
        {
            get;
            private set;
        }

        /// <summary>
        /// NewValue
        /// </summary>
        [DataMember(Name = ("newValue"), IsRequired = (true))]
        public string NewValue
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// domStorageItemRemoved
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class DomStorageItemRemovedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// StorageId
        /// </summary>
        [DataMember(Name = ("storageId"), IsRequired = (true))]
        public CefSharp.DevTools.DOMStorage.StorageId StorageId
        {
            get;
            private set;
        }

        /// <summary>
        /// Key
        /// </summary>
        [DataMember(Name = ("key"), IsRequired = (true))]
        public string Key
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// domStorageItemUpdated
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class DomStorageItemUpdatedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// StorageId
        /// </summary>
        [DataMember(Name = ("storageId"), IsRequired = (true))]
        public CefSharp.DevTools.DOMStorage.StorageId StorageId
        {
            get;
            private set;
        }

        /// <summary>
        /// Key
        /// </summary>
        [DataMember(Name = ("key"), IsRequired = (true))]
        public string Key
        {
            get;
            private set;
        }

        /// <summary>
        /// OldValue
        /// </summary>
        [DataMember(Name = ("oldValue"), IsRequired = (true))]
        public string OldValue
        {
            get;
            private set;
        }

        /// <summary>
        /// NewValue
        /// </summary>
        [DataMember(Name = ("newValue"), IsRequired = (true))]
        public string NewValue
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// domStorageItemsCleared
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class DomStorageItemsClearedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// StorageId
        /// </summary>
        [DataMember(Name = ("storageId"), IsRequired = (true))]
        public CefSharp.DevTools.DOMStorage.StorageId StorageId
        {
            get;
            private set;
        }
    }
}

namespace CefSharp.DevTools.Database
{
    /// <summary>
    /// Database object.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class Database : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Database ID.
        /// </summary>
        [DataMember(Name = ("id"), IsRequired = (true))]
        public string Id
        {
            get;
            set;
        }

        /// <summary>
        /// Database domain.
        /// </summary>
        [DataMember(Name = ("domain"), IsRequired = (true))]
        public string Domain
        {
            get;
            set;
        }

        /// <summary>
        /// Database name.
        /// </summary>
        [DataMember(Name = ("name"), IsRequired = (true))]
        public string Name
        {
            get;
            set;
        }

        /// <summary>
        /// Database version.
        /// </summary>
        [DataMember(Name = ("version"), IsRequired = (true))]
        public string Version
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Database error.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class Error : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Error message.
        /// </summary>
        [DataMember(Name = ("message"), IsRequired = (true))]
        public string Message
        {
            get;
            set;
        }

        /// <summary>
        /// Error code.
        /// </summary>
        [DataMember(Name = ("code"), IsRequired = (true))]
        public int Code
        {
            get;
            set;
        }
    }

    /// <summary>
    /// addDatabase
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class AddDatabaseEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Database
        /// </summary>
        [DataMember(Name = ("database"), IsRequired = (true))]
        public CefSharp.DevTools.Database.Database Database
        {
            get;
            private set;
        }
    }
}

namespace CefSharp.DevTools.Emulation
{
    /// <summary>
    /// Orientation type.
    /// </summary>
    public enum ScreenOrientationType
    {
        /// <summary>
        /// portraitPrimary
        /// </summary>
        [EnumMember(Value = ("portraitPrimary"))]
        PortraitPrimary,
        /// <summary>
        /// portraitSecondary
        /// </summary>
        [EnumMember(Value = ("portraitSecondary"))]
        PortraitSecondary,
        /// <summary>
        /// landscapePrimary
        /// </summary>
        [EnumMember(Value = ("landscapePrimary"))]
        LandscapePrimary,
        /// <summary>
        /// landscapeSecondary
        /// </summary>
        [EnumMember(Value = ("landscapeSecondary"))]
        LandscapeSecondary
    }

    /// <summary>
    /// Screen orientation.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class ScreenOrientation : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Orientation type.
        /// </summary>
        public CefSharp.DevTools.Emulation.ScreenOrientationType Type
        {
            get
            {
                return (CefSharp.DevTools.Emulation.ScreenOrientationType)(StringToEnum(typeof(CefSharp.DevTools.Emulation.ScreenOrientationType), type));
            }

            set
            {
                this.type = (EnumToString(value));
            }
        }

        /// <summary>
        /// Orientation type.
        /// </summary>
        [DataMember(Name = ("type"), IsRequired = (true))]
        internal string type
        {
            get;
            set;
        }

        /// <summary>
        /// Orientation angle.
        /// </summary>
        [DataMember(Name = ("angle"), IsRequired = (true))]
        public int Angle
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Orientation of a display feature in relation to screen
    /// </summary>
    public enum DisplayFeatureOrientation
    {
        /// <summary>
        /// vertical
        /// </summary>
        [EnumMember(Value = ("vertical"))]
        Vertical,
        /// <summary>
        /// horizontal
        /// </summary>
        [EnumMember(Value = ("horizontal"))]
        Horizontal
    }

    /// <summary>
    /// DisplayFeature
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class DisplayFeature : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Orientation of a display feature in relation to screen
        /// </summary>
        public CefSharp.DevTools.Emulation.DisplayFeatureOrientation Orientation
        {
            get
            {
                return (CefSharp.DevTools.Emulation.DisplayFeatureOrientation)(StringToEnum(typeof(CefSharp.DevTools.Emulation.DisplayFeatureOrientation), orientation));
            }

            set
            {
                this.orientation = (EnumToString(value));
            }
        }

        /// <summary>
        /// Orientation of a display feature in relation to screen
        /// </summary>
        [DataMember(Name = ("orientation"), IsRequired = (true))]
        internal string orientation
        {
            get;
            set;
        }

        /// <summary>
        /// The offset from the screen origin in either the x (for vertical
        /// orientation) or y (for horizontal orientation) direction.
        /// </summary>
        [DataMember(Name = ("offset"), IsRequired = (true))]
        public int Offset
        {
            get;
            set;
        }

        /// <summary>
        /// A display feature may mask content such that it is not physically
        /// displayed - this length along with the offset describes this area.
        /// A display feature that only splits content will have a 0 mask_length.
        /// </summary>
        [DataMember(Name = ("maskLength"), IsRequired = (true))]
        public int MaskLength
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Current posture of the device
    /// </summary>
    public enum DevicePostureType
    {
        /// <summary>
        /// continuous
        /// </summary>
        [EnumMember(Value = ("continuous"))]
        Continuous,
        /// <summary>
        /// folded
        /// </summary>
        [EnumMember(Value = ("folded"))]
        Folded
    }

    /// <summary>
    /// DevicePosture
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class DevicePosture : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Current posture of the device
        /// </summary>
        public CefSharp.DevTools.Emulation.DevicePostureType Type
        {
            get
            {
                return (CefSharp.DevTools.Emulation.DevicePostureType)(StringToEnum(typeof(CefSharp.DevTools.Emulation.DevicePostureType), type));
            }

            set
            {
                this.type = (EnumToString(value));
            }
        }

        /// <summary>
        /// Current posture of the device
        /// </summary>
        [DataMember(Name = ("type"), IsRequired = (true))]
        internal string type
        {
            get;
            set;
        }
    }

    /// <summary>
    /// MediaFeature
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class MediaFeature : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Name
        /// </summary>
        [DataMember(Name = ("name"), IsRequired = (true))]
        public string Name
        {
            get;
            set;
        }

        /// <summary>
        /// Value
        /// </summary>
        [DataMember(Name = ("value"), IsRequired = (true))]
        public string Value
        {
            get;
            set;
        }
    }

    /// <summary>
    /// advance: If the scheduler runs out of immediate work, the virtual time base may fast forward to
    /// allow the next delayed task (if any) to run; pause: The virtual time base may not advance;
    /// pauseIfNetworkFetchesPending: The virtual time base may not advance if there are any pending
    /// resource fetches.
    /// </summary>
    public enum VirtualTimePolicy
    {
        /// <summary>
        /// advance
        /// </summary>
        [EnumMember(Value = ("advance"))]
        Advance,
        /// <summary>
        /// pause
        /// </summary>
        [EnumMember(Value = ("pause"))]
        Pause,
        /// <summary>
        /// pauseIfNetworkFetchesPending
        /// </summary>
        [EnumMember(Value = ("pauseIfNetworkFetchesPending"))]
        PauseIfNetworkFetchesPending
    }

    /// <summary>
    /// Used to specify User Agent Client Hints to emulate. See https://wicg.github.io/ua-client-hints
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class UserAgentBrandVersion : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Brand
        /// </summary>
        [DataMember(Name = ("brand"), IsRequired = (true))]
        public string Brand
        {
            get;
            set;
        }

        /// <summary>
        /// Version
        /// </summary>
        [DataMember(Name = ("version"), IsRequired = (true))]
        public string Version
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Used to specify User Agent Client Hints to emulate. See https://wicg.github.io/ua-client-hints
    /// Missing optional values will be filled in by the target with what it would normally use.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class UserAgentMetadata : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Brands appearing in Sec-CH-UA.
        /// </summary>
        [DataMember(Name = ("brands"), IsRequired = (false))]
        public System.Collections.Generic.IList<CefSharp.DevTools.Emulation.UserAgentBrandVersion> Brands
        {
            get;
            set;
        }

        /// <summary>
        /// Brands appearing in Sec-CH-UA-Full-Version-List.
        /// </summary>
        [DataMember(Name = ("fullVersionList"), IsRequired = (false))]
        public System.Collections.Generic.IList<CefSharp.DevTools.Emulation.UserAgentBrandVersion> FullVersionList
        {
            get;
            set;
        }

        /// <summary>
        /// FullVersion
        /// </summary>
        [DataMember(Name = ("fullVersion"), IsRequired = (false))]
        public string FullVersion
        {
            get;
            set;
        }

        /// <summary>
        /// Platform
        /// </summary>
        [DataMember(Name = ("platform"), IsRequired = (true))]
        public string Platform
        {
            get;
            set;
        }

        /// <summary>
        /// PlatformVersion
        /// </summary>
        [DataMember(Name = ("platformVersion"), IsRequired = (true))]
        public string PlatformVersion
        {
            get;
            set;
        }

        /// <summary>
        /// Architecture
        /// </summary>
        [DataMember(Name = ("architecture"), IsRequired = (true))]
        public string Architecture
        {
            get;
            set;
        }

        /// <summary>
        /// Model
        /// </summary>
        [DataMember(Name = ("model"), IsRequired = (true))]
        public string Model
        {
            get;
            set;
        }

        /// <summary>
        /// Mobile
        /// </summary>
        [DataMember(Name = ("mobile"), IsRequired = (true))]
        public bool Mobile
        {
            get;
            set;
        }

        /// <summary>
        /// Bitness
        /// </summary>
        [DataMember(Name = ("bitness"), IsRequired = (false))]
        public string Bitness
        {
            get;
            set;
        }

        /// <summary>
        /// Wow64
        /// </summary>
        [DataMember(Name = ("wow64"), IsRequired = (false))]
        public bool? Wow64
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Used to specify sensor types to emulate.
    /// See https://w3c.github.io/sensors/#automation for more information.
    /// </summary>
    public enum SensorType
    {
        /// <summary>
        /// absolute-orientation
        /// </summary>
        [EnumMember(Value = ("absolute-orientation"))]
        AbsoluteOrientation,
        /// <summary>
        /// accelerometer
        /// </summary>
        [EnumMember(Value = ("accelerometer"))]
        Accelerometer,
        /// <summary>
        /// ambient-light
        /// </summary>
        [EnumMember(Value = ("ambient-light"))]
        AmbientLight,
        /// <summary>
        /// gravity
        /// </summary>
        [EnumMember(Value = ("gravity"))]
        Gravity,
        /// <summary>
        /// gyroscope
        /// </summary>
        [EnumMember(Value = ("gyroscope"))]
        Gyroscope,
        /// <summary>
        /// linear-acceleration
        /// </summary>
        [EnumMember(Value = ("linear-acceleration"))]
        LinearAcceleration,
        /// <summary>
        /// magnetometer
        /// </summary>
        [EnumMember(Value = ("magnetometer"))]
        Magnetometer,
        /// <summary>
        /// proximity
        /// </summary>
        [EnumMember(Value = ("proximity"))]
        Proximity,
        /// <summary>
        /// relative-orientation
        /// </summary>
        [EnumMember(Value = ("relative-orientation"))]
        RelativeOrientation
    }

    /// <summary>
    /// SensorMetadata
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class SensorMetadata : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Available
        /// </summary>
        [DataMember(Name = ("available"), IsRequired = (false))]
        public bool? Available
        {
            get;
            set;
        }

        /// <summary>
        /// MinimumFrequency
        /// </summary>
        [DataMember(Name = ("minimumFrequency"), IsRequired = (false))]
        public double? MinimumFrequency
        {
            get;
            set;
        }

        /// <summary>
        /// MaximumFrequency
        /// </summary>
        [DataMember(Name = ("maximumFrequency"), IsRequired = (false))]
        public double? MaximumFrequency
        {
            get;
            set;
        }
    }

    /// <summary>
    /// SensorReadingSingle
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class SensorReadingSingle : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Value
        /// </summary>
        [DataMember(Name = ("value"), IsRequired = (true))]
        public double Value
        {
            get;
            set;
        }
    }

    /// <summary>
    /// SensorReadingXYZ
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class SensorReadingXYZ : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// X
        /// </summary>
        [DataMember(Name = ("x"), IsRequired = (true))]
        public double X
        {
            get;
            set;
        }

        /// <summary>
        /// Y
        /// </summary>
        [DataMember(Name = ("y"), IsRequired = (true))]
        public double Y
        {
            get;
            set;
        }

        /// <summary>
        /// Z
        /// </summary>
        [DataMember(Name = ("z"), IsRequired = (true))]
        public double Z
        {
            get;
            set;
        }
    }

    /// <summary>
    /// SensorReadingQuaternion
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class SensorReadingQuaternion : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// X
        /// </summary>
        [DataMember(Name = ("x"), IsRequired = (true))]
        public double X
        {
            get;
            set;
        }

        /// <summary>
        /// Y
        /// </summary>
        [DataMember(Name = ("y"), IsRequired = (true))]
        public double Y
        {
            get;
            set;
        }

        /// <summary>
        /// Z
        /// </summary>
        [DataMember(Name = ("z"), IsRequired = (true))]
        public double Z
        {
            get;
            set;
        }

        /// <summary>
        /// W
        /// </summary>
        [DataMember(Name = ("w"), IsRequired = (true))]
        public double W
        {
            get;
            set;
        }
    }

    /// <summary>
    /// SensorReading
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class SensorReading : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Single
        /// </summary>
        [DataMember(Name = ("single"), IsRequired = (false))]
        public CefSharp.DevTools.Emulation.SensorReadingSingle Single
        {
            get;
            set;
        }

        /// <summary>
        /// Xyz
        /// </summary>
        [DataMember(Name = ("xyz"), IsRequired = (false))]
        public CefSharp.DevTools.Emulation.SensorReadingXYZ Xyz
        {
            get;
            set;
        }

        /// <summary>
        /// Quaternion
        /// </summary>
        [DataMember(Name = ("quaternion"), IsRequired = (false))]
        public CefSharp.DevTools.Emulation.SensorReadingQuaternion Quaternion
        {
            get;
            set;
        }
    }

    /// <summary>
    /// PressureSource
    /// </summary>
    public enum PressureSource
    {
        /// <summary>
        /// cpu
        /// </summary>
        [EnumMember(Value = ("cpu"))]
        Cpu
    }

    /// <summary>
    /// PressureState
    /// </summary>
    public enum PressureState
    {
        /// <summary>
        /// nominal
        /// </summary>
        [EnumMember(Value = ("nominal"))]
        Nominal,
        /// <summary>
        /// fair
        /// </summary>
        [EnumMember(Value = ("fair"))]
        Fair,
        /// <summary>
        /// serious
        /// </summary>
        [EnumMember(Value = ("serious"))]
        Serious,
        /// <summary>
        /// critical
        /// </summary>
        [EnumMember(Value = ("critical"))]
        Critical
    }

    /// <summary>
    /// PressureMetadata
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class PressureMetadata : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Available
        /// </summary>
        [DataMember(Name = ("available"), IsRequired = (false))]
        public bool? Available
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Enum of image types that can be disabled.
    /// </summary>
    public enum DisabledImageType
    {
        /// <summary>
        /// avif
        /// </summary>
        [EnumMember(Value = ("avif"))]
        Avif,
        /// <summary>
        /// webp
        /// </summary>
        [EnumMember(Value = ("webp"))]
        Webp
    }
}

namespace CefSharp.DevTools.HeadlessExperimental
{
    /// <summary>
    /// Image compression format (defaults to png).
    /// </summary>
    public enum ScreenshotParamsFormat
    {
        /// <summary>
        /// jpeg
        /// </summary>
        [EnumMember(Value = ("jpeg"))]
        Jpeg,
        /// <summary>
        /// png
        /// </summary>
        [EnumMember(Value = ("png"))]
        Png,
        /// <summary>
        /// webp
        /// </summary>
        [EnumMember(Value = ("webp"))]
        Webp
    }

    /// <summary>
    /// Encoding options for a screenshot.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class ScreenshotParams : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Image compression format (defaults to png).
        /// </summary>
        public CefSharp.DevTools.HeadlessExperimental.ScreenshotParamsFormat? Format
        {
            get
            {
                return (CefSharp.DevTools.HeadlessExperimental.ScreenshotParamsFormat? )(StringToEnum(typeof(CefSharp.DevTools.HeadlessExperimental.ScreenshotParamsFormat? ), format));
            }

            set
            {
                this.format = (EnumToString(value));
            }
        }

        /// <summary>
        /// Image compression format (defaults to png).
        /// </summary>
        [DataMember(Name = ("format"), IsRequired = (false))]
        internal string format
        {
            get;
            set;
        }

        /// <summary>
        /// Compression quality from range [0..100] (jpeg and webp only).
        /// </summary>
        [DataMember(Name = ("quality"), IsRequired = (false))]
        public int? Quality
        {
            get;
            set;
        }

        /// <summary>
        /// Optimize image encoding for speed, not for resulting size (defaults to false)
        /// </summary>
        [DataMember(Name = ("optimizeForSpeed"), IsRequired = (false))]
        public bool? OptimizeForSpeed
        {
            get;
            set;
        }
    }
}

namespace CefSharp.DevTools.FileSystem
{
    /// <summary>
    /// File
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class File : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Name
        /// </summary>
        [DataMember(Name = ("name"), IsRequired = (true))]
        public string Name
        {
            get;
            set;
        }

        /// <summary>
        /// Timestamp
        /// </summary>
        [DataMember(Name = ("lastModified"), IsRequired = (true))]
        public double LastModified
        {
            get;
            set;
        }

        /// <summary>
        /// Size in bytes
        /// </summary>
        [DataMember(Name = ("size"), IsRequired = (true))]
        public double Size
        {
            get;
            set;
        }

        /// <summary>
        /// Type
        /// </summary>
        [DataMember(Name = ("type"), IsRequired = (true))]
        public string Type
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Directory
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class Directory : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Name
        /// </summary>
        [DataMember(Name = ("name"), IsRequired = (true))]
        public string Name
        {
            get;
            set;
        }

        /// <summary>
        /// NestedDirectories
        /// </summary>
        [DataMember(Name = ("nestedDirectories"), IsRequired = (true))]
        public string[] NestedDirectories
        {
            get;
            set;
        }

        /// <summary>
        /// Files that are directly nested under this directory.
        /// </summary>
        [DataMember(Name = ("nestedFiles"), IsRequired = (true))]
        public System.Collections.Generic.IList<CefSharp.DevTools.FileSystem.File> NestedFiles
        {
            get;
            set;
        }
    }

    /// <summary>
    /// BucketFileSystemLocator
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class BucketFileSystemLocator : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Storage key
        /// </summary>
        [DataMember(Name = ("storageKey"), IsRequired = (true))]
        public string StorageKey
        {
            get;
            set;
        }

        /// <summary>
        /// Bucket name. Not passing a `bucketName` will retrieve the default Bucket. (https://developer.mozilla.org/en-US/docs/Web/API/Storage_API#storage_buckets)
        /// </summary>
        [DataMember(Name = ("bucketName"), IsRequired = (false))]
        public string BucketName
        {
            get;
            set;
        }

        /// <summary>
        /// Path to the directory using each path component as an array item.
        /// </summary>
        [DataMember(Name = ("pathComponents"), IsRequired = (true))]
        public string[] PathComponents
        {
            get;
            set;
        }
    }
}

namespace CefSharp.DevTools.IndexedDB
{
    /// <summary>
    /// Database with an array of object stores.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class DatabaseWithObjectStores : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Database name.
        /// </summary>
        [DataMember(Name = ("name"), IsRequired = (true))]
        public string Name
        {
            get;
            set;
        }

        /// <summary>
        /// Database version (type is not &apos;integer&apos;, as the standard
        /// requires the version number to be &apos;unsigned long long&apos;)
        /// </summary>
        [DataMember(Name = ("version"), IsRequired = (true))]
        public double Version
        {
            get;
            set;
        }

        /// <summary>
        /// Object stores in this database.
        /// </summary>
        [DataMember(Name = ("objectStores"), IsRequired = (true))]
        public System.Collections.Generic.IList<CefSharp.DevTools.IndexedDB.ObjectStore> ObjectStores
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Object store.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class ObjectStore : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Object store name.
        /// </summary>
        [DataMember(Name = ("name"), IsRequired = (true))]
        public string Name
        {
            get;
            set;
        }

        /// <summary>
        /// Object store key path.
        /// </summary>
        [DataMember(Name = ("keyPath"), IsRequired = (true))]
        public CefSharp.DevTools.IndexedDB.KeyPath KeyPath
        {
            get;
            set;
        }

        /// <summary>
        /// If true, object store has auto increment flag set.
        /// </summary>
        [DataMember(Name = ("autoIncrement"), IsRequired = (true))]
        public bool AutoIncrement
        {
            get;
            set;
        }

        /// <summary>
        /// Indexes in this object store.
        /// </summary>
        [DataMember(Name = ("indexes"), IsRequired = (true))]
        public System.Collections.Generic.IList<CefSharp.DevTools.IndexedDB.ObjectStoreIndex> Indexes
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Object store index.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class ObjectStoreIndex : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Index name.
        /// </summary>
        [DataMember(Name = ("name"), IsRequired = (true))]
        public string Name
        {
            get;
            set;
        }

        /// <summary>
        /// Index key path.
        /// </summary>
        [DataMember(Name = ("keyPath"), IsRequired = (true))]
        public CefSharp.DevTools.IndexedDB.KeyPath KeyPath
        {
            get;
            set;
        }

        /// <summary>
        /// If true, index is unique.
        /// </summary>
        [DataMember(Name = ("unique"), IsRequired = (true))]
        public bool Unique
        {
            get;
            set;
        }

        /// <summary>
        /// If true, index allows multiple entries for a key.
        /// </summary>
        [DataMember(Name = ("multiEntry"), IsRequired = (true))]
        public bool MultiEntry
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Key type.
    /// </summary>
    public enum KeyType
    {
        /// <summary>
        /// number
        /// </summary>
        [EnumMember(Value = ("number"))]
        Number,
        /// <summary>
        /// string
        /// </summary>
        [EnumMember(Value = ("string"))]
        String,
        /// <summary>
        /// date
        /// </summary>
        [EnumMember(Value = ("date"))]
        Date,
        /// <summary>
        /// array
        /// </summary>
        [EnumMember(Value = ("array"))]
        Array
    }

    /// <summary>
    /// Key.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class Key : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Key type.
        /// </summary>
        public CefSharp.DevTools.IndexedDB.KeyType Type
        {
            get
            {
                return (CefSharp.DevTools.IndexedDB.KeyType)(StringToEnum(typeof(CefSharp.DevTools.IndexedDB.KeyType), type));
            }

            set
            {
                this.type = (EnumToString(value));
            }
        }

        /// <summary>
        /// Key type.
        /// </summary>
        [DataMember(Name = ("type"), IsRequired = (true))]
        internal string type
        {
            get;
            set;
        }

        /// <summary>
        /// Number value.
        /// </summary>
        [DataMember(Name = ("number"), IsRequired = (false))]
        public double? Number
        {
            get;
            set;
        }

        /// <summary>
        /// String value.
        /// </summary>
        [DataMember(Name = ("string"), IsRequired = (false))]
        public string String
        {
            get;
            set;
        }

        /// <summary>
        /// Date value.
        /// </summary>
        [DataMember(Name = ("date"), IsRequired = (false))]
        public double? Date
        {
            get;
            set;
        }

        /// <summary>
        /// Array value.
        /// </summary>
        [DataMember(Name = ("array"), IsRequired = (false))]
        public System.Collections.Generic.IList<CefSharp.DevTools.IndexedDB.Key> Array
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Key range.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class KeyRange : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Lower bound.
        /// </summary>
        [DataMember(Name = ("lower"), IsRequired = (false))]
        public CefSharp.DevTools.IndexedDB.Key Lower
        {
            get;
            set;
        }

        /// <summary>
        /// Upper bound.
        /// </summary>
        [DataMember(Name = ("upper"), IsRequired = (false))]
        public CefSharp.DevTools.IndexedDB.Key Upper
        {
            get;
            set;
        }

        /// <summary>
        /// If true lower bound is open.
        /// </summary>
        [DataMember(Name = ("lowerOpen"), IsRequired = (true))]
        public bool LowerOpen
        {
            get;
            set;
        }

        /// <summary>
        /// If true upper bound is open.
        /// </summary>
        [DataMember(Name = ("upperOpen"), IsRequired = (true))]
        public bool UpperOpen
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Data entry.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class DataEntry : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Key object.
        /// </summary>
        [DataMember(Name = ("key"), IsRequired = (true))]
        public CefSharp.DevTools.Runtime.RemoteObject Key
        {
            get;
            set;
        }

        /// <summary>
        /// Primary key object.
        /// </summary>
        [DataMember(Name = ("primaryKey"), IsRequired = (true))]
        public CefSharp.DevTools.Runtime.RemoteObject PrimaryKey
        {
            get;
            set;
        }

        /// <summary>
        /// Value object.
        /// </summary>
        [DataMember(Name = ("value"), IsRequired = (true))]
        public CefSharp.DevTools.Runtime.RemoteObject Value
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Key path type.
    /// </summary>
    public enum KeyPathType
    {
        /// <summary>
        /// null
        /// </summary>
        [EnumMember(Value = ("null"))]
        Null,
        /// <summary>
        /// string
        /// </summary>
        [EnumMember(Value = ("string"))]
        String,
        /// <summary>
        /// array
        /// </summary>
        [EnumMember(Value = ("array"))]
        Array
    }

    /// <summary>
    /// Key path.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class KeyPath : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Key path type.
        /// </summary>
        public CefSharp.DevTools.IndexedDB.KeyPathType Type
        {
            get
            {
                return (CefSharp.DevTools.IndexedDB.KeyPathType)(StringToEnum(typeof(CefSharp.DevTools.IndexedDB.KeyPathType), type));
            }

            set
            {
                this.type = (EnumToString(value));
            }
        }

        /// <summary>
        /// Key path type.
        /// </summary>
        [DataMember(Name = ("type"), IsRequired = (true))]
        internal string type
        {
            get;
            set;
        }

        /// <summary>
        /// String value.
        /// </summary>
        [DataMember(Name = ("string"), IsRequired = (false))]
        public string String
        {
            get;
            set;
        }

        /// <summary>
        /// Array value.
        /// </summary>
        [DataMember(Name = ("array"), IsRequired = (false))]
        public string[] Array
        {
            get;
            set;
        }
    }
}

namespace CefSharp.DevTools.Input
{
    /// <summary>
    /// TouchPoint
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class TouchPoint : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// X coordinate of the event relative to the main frame&apos;s viewport in CSS pixels.
        /// </summary>
        [DataMember(Name = ("x"), IsRequired = (true))]
        public double X
        {
            get;
            set;
        }

        /// <summary>
        /// Y coordinate of the event relative to the main frame&apos;s viewport in CSS pixels. 0 refers to
        /// the top of the viewport and Y increases as it proceeds towards the bottom of the viewport.
        /// </summary>
        [DataMember(Name = ("y"), IsRequired = (true))]
        public double Y
        {
            get;
            set;
        }

        /// <summary>
        /// X radius of the touch area (default: 1.0).
        /// </summary>
        [DataMember(Name = ("radiusX"), IsRequired = (false))]
        public double? RadiusX
        {
            get;
            set;
        }

        /// <summary>
        /// Y radius of the touch area (default: 1.0).
        /// </summary>
        [DataMember(Name = ("radiusY"), IsRequired = (false))]
        public double? RadiusY
        {
            get;
            set;
        }

        /// <summary>
        /// Rotation angle (default: 0.0).
        /// </summary>
        [DataMember(Name = ("rotationAngle"), IsRequired = (false))]
        public double? RotationAngle
        {
            get;
            set;
        }

        /// <summary>
        /// Force (default: 1.0).
        /// </summary>
        [DataMember(Name = ("force"), IsRequired = (false))]
        public double? Force
        {
            get;
            set;
        }

        /// <summary>
        /// The normalized tangential pressure, which has a range of [-1,1] (default: 0).
        /// </summary>
        [DataMember(Name = ("tangentialPressure"), IsRequired = (false))]
        public double? TangentialPressure
        {
            get;
            set;
        }

        /// <summary>
        /// The plane angle between the Y-Z plane and the plane containing both the stylus axis and the Y axis, in degrees of the range [-90,90], a positive tiltX is to the right (default: 0)
        /// </summary>
        [DataMember(Name = ("tiltX"), IsRequired = (false))]
        public double? TiltX
        {
            get;
            set;
        }

        /// <summary>
        /// The plane angle between the X-Z plane and the plane containing both the stylus axis and the X axis, in degrees of the range [-90,90], a positive tiltY is towards the user (default: 0).
        /// </summary>
        [DataMember(Name = ("tiltY"), IsRequired = (false))]
        public double? TiltY
        {
            get;
            set;
        }

        /// <summary>
        /// The clockwise rotation of a pen stylus around its own major axis, in degrees in the range [0,359] (default: 0).
        /// </summary>
        [DataMember(Name = ("twist"), IsRequired = (false))]
        public int? Twist
        {
            get;
            set;
        }

        /// <summary>
        /// Identifier used to track touch sources between events, must be unique within an event.
        /// </summary>
        [DataMember(Name = ("id"), IsRequired = (false))]
        public double? Id
        {
            get;
            set;
        }
    }

    /// <summary>
    /// GestureSourceType
    /// </summary>
    public enum GestureSourceType
    {
        /// <summary>
        /// default
        /// </summary>
        [EnumMember(Value = ("default"))]
        Default,
        /// <summary>
        /// touch
        /// </summary>
        [EnumMember(Value = ("touch"))]
        Touch,
        /// <summary>
        /// mouse
        /// </summary>
        [EnumMember(Value = ("mouse"))]
        Mouse
    }

    /// <summary>
    /// MouseButton
    /// </summary>
    public enum MouseButton
    {
        /// <summary>
        /// none
        /// </summary>
        [EnumMember(Value = ("none"))]
        None,
        /// <summary>
        /// left
        /// </summary>
        [EnumMember(Value = ("left"))]
        Left,
        /// <summary>
        /// middle
        /// </summary>
        [EnumMember(Value = ("middle"))]
        Middle,
        /// <summary>
        /// right
        /// </summary>
        [EnumMember(Value = ("right"))]
        Right,
        /// <summary>
        /// back
        /// </summary>
        [EnumMember(Value = ("back"))]
        Back,
        /// <summary>
        /// forward
        /// </summary>
        [EnumMember(Value = ("forward"))]
        Forward
    }

    /// <summary>
    /// DragDataItem
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class DragDataItem : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Mime type of the dragged data.
        /// </summary>
        [DataMember(Name = ("mimeType"), IsRequired = (true))]
        public string MimeType
        {
            get;
            set;
        }

        /// <summary>
        /// Depending of the value of `mimeType`, it contains the dragged link,
        /// text, HTML markup or any other data.
        /// </summary>
        [DataMember(Name = ("data"), IsRequired = (true))]
        public string Data
        {
            get;
            set;
        }

        /// <summary>
        /// Title associated with a link. Only valid when `mimeType` == &quot;text/uri-list&quot;.
        /// </summary>
        [DataMember(Name = ("title"), IsRequired = (false))]
        public string Title
        {
            get;
            set;
        }

        /// <summary>
        /// Stores the base URL for the contained markup. Only valid when `mimeType`
        /// == &quot;text/html&quot;.
        /// </summary>
        [DataMember(Name = ("baseURL"), IsRequired = (false))]
        public string BaseURL
        {
            get;
            set;
        }
    }

    /// <summary>
    /// DragData
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class DragData : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Items
        /// </summary>
        [DataMember(Name = ("items"), IsRequired = (true))]
        public System.Collections.Generic.IList<CefSharp.DevTools.Input.DragDataItem> Items
        {
            get;
            set;
        }

        /// <summary>
        /// List of filenames that should be included when dropping
        /// </summary>
        [DataMember(Name = ("files"), IsRequired = (false))]
        public string[] Files
        {
            get;
            set;
        }

        /// <summary>
        /// Bit field representing allowed drag operations. Copy = 1, Link = 2, Move = 16
        /// </summary>
        [DataMember(Name = ("dragOperationsMask"), IsRequired = (true))]
        public int DragOperationsMask
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Emitted only when `Input.setInterceptDrags` is enabled. Use this data with `Input.dispatchDragEvent` to
    /// restore normal drag and drop behavior.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class DragInterceptedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Data
        /// </summary>
        [DataMember(Name = ("data"), IsRequired = (true))]
        public CefSharp.DevTools.Input.DragData Data
        {
            get;
            private set;
        }
    }
}

namespace CefSharp.DevTools.Inspector
{
    /// <summary>
    /// Fired when remote debugging connection is about to be terminated. Contains detach reason.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class DetachedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// The reason why connection has been terminated.
        /// </summary>
        [DataMember(Name = ("reason"), IsRequired = (true))]
        public string Reason
        {
            get;
            private set;
        }
    }
}

namespace CefSharp.DevTools.LayerTree
{
    /// <summary>
    /// Reason for rectangle to force scrolling on the main thread
    /// </summary>
    public enum ScrollRectType
    {
        /// <summary>
        /// RepaintsOnScroll
        /// </summary>
        [EnumMember(Value = ("RepaintsOnScroll"))]
        RepaintsOnScroll,
        /// <summary>
        /// TouchEventHandler
        /// </summary>
        [EnumMember(Value = ("TouchEventHandler"))]
        TouchEventHandler,
        /// <summary>
        /// WheelEventHandler
        /// </summary>
        [EnumMember(Value = ("WheelEventHandler"))]
        WheelEventHandler
    }

    /// <summary>
    /// Rectangle where scrolling happens on the main thread.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class ScrollRect : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Rectangle itself.
        /// </summary>
        [DataMember(Name = ("rect"), IsRequired = (true))]
        public CefSharp.DevTools.DOM.Rect Rect
        {
            get;
            set;
        }

        /// <summary>
        /// Reason for rectangle to force scrolling on the main thread
        /// </summary>
        public CefSharp.DevTools.LayerTree.ScrollRectType Type
        {
            get
            {
                return (CefSharp.DevTools.LayerTree.ScrollRectType)(StringToEnum(typeof(CefSharp.DevTools.LayerTree.ScrollRectType), type));
            }

            set
            {
                this.type = (EnumToString(value));
            }
        }

        /// <summary>
        /// Reason for rectangle to force scrolling on the main thread
        /// </summary>
        [DataMember(Name = ("type"), IsRequired = (true))]
        internal string type
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Sticky position constraints.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class StickyPositionConstraint : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Layout rectangle of the sticky element before being shifted
        /// </summary>
        [DataMember(Name = ("stickyBoxRect"), IsRequired = (true))]
        public CefSharp.DevTools.DOM.Rect StickyBoxRect
        {
            get;
            set;
        }

        /// <summary>
        /// Layout rectangle of the containing block of the sticky element
        /// </summary>
        [DataMember(Name = ("containingBlockRect"), IsRequired = (true))]
        public CefSharp.DevTools.DOM.Rect ContainingBlockRect
        {
            get;
            set;
        }

        /// <summary>
        /// The nearest sticky layer that shifts the sticky box
        /// </summary>
        [DataMember(Name = ("nearestLayerShiftingStickyBox"), IsRequired = (false))]
        public string NearestLayerShiftingStickyBox
        {
            get;
            set;
        }

        /// <summary>
        /// The nearest sticky layer that shifts the containing block
        /// </summary>
        [DataMember(Name = ("nearestLayerShiftingContainingBlock"), IsRequired = (false))]
        public string NearestLayerShiftingContainingBlock
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Serialized fragment of layer picture along with its offset within the layer.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class PictureTile : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Offset from owning layer left boundary
        /// </summary>
        [DataMember(Name = ("x"), IsRequired = (true))]
        public double X
        {
            get;
            set;
        }

        /// <summary>
        /// Offset from owning layer top boundary
        /// </summary>
        [DataMember(Name = ("y"), IsRequired = (true))]
        public double Y
        {
            get;
            set;
        }

        /// <summary>
        /// Base64-encoded snapshot data.
        /// </summary>
        [DataMember(Name = ("picture"), IsRequired = (true))]
        public byte[] Picture
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Information about a compositing layer.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class Layer : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The unique id for this layer.
        /// </summary>
        [DataMember(Name = ("layerId"), IsRequired = (true))]
        public string LayerId
        {
            get;
            set;
        }

        /// <summary>
        /// The id of parent (not present for root).
        /// </summary>
        [DataMember(Name = ("parentLayerId"), IsRequired = (false))]
        public string ParentLayerId
        {
            get;
            set;
        }

        /// <summary>
        /// The backend id for the node associated with this layer.
        /// </summary>
        [DataMember(Name = ("backendNodeId"), IsRequired = (false))]
        public int? BackendNodeId
        {
            get;
            set;
        }

        /// <summary>
        /// Offset from parent layer, X coordinate.
        /// </summary>
        [DataMember(Name = ("offsetX"), IsRequired = (true))]
        public double OffsetX
        {
            get;
            set;
        }

        /// <summary>
        /// Offset from parent layer, Y coordinate.
        /// </summary>
        [DataMember(Name = ("offsetY"), IsRequired = (true))]
        public double OffsetY
        {
            get;
            set;
        }

        /// <summary>
        /// Layer width.
        /// </summary>
        [DataMember(Name = ("width"), IsRequired = (true))]
        public double Width
        {
            get;
            set;
        }

        /// <summary>
        /// Layer height.
        /// </summary>
        [DataMember(Name = ("height"), IsRequired = (true))]
        public double Height
        {
            get;
            set;
        }

        /// <summary>
        /// Transformation matrix for layer, default is identity matrix
        /// </summary>
        [DataMember(Name = ("transform"), IsRequired = (false))]
        public double[] Transform
        {
            get;
            set;
        }

        /// <summary>
        /// Transform anchor point X, absent if no transform specified
        /// </summary>
        [DataMember(Name = ("anchorX"), IsRequired = (false))]
        public double? AnchorX
        {
            get;
            set;
        }

        /// <summary>
        /// Transform anchor point Y, absent if no transform specified
        /// </summary>
        [DataMember(Name = ("anchorY"), IsRequired = (false))]
        public double? AnchorY
        {
            get;
            set;
        }

        /// <summary>
        /// Transform anchor point Z, absent if no transform specified
        /// </summary>
        [DataMember(Name = ("anchorZ"), IsRequired = (false))]
        public double? AnchorZ
        {
            get;
            set;
        }

        /// <summary>
        /// Indicates how many time this layer has painted.
        /// </summary>
        [DataMember(Name = ("paintCount"), IsRequired = (true))]
        public int PaintCount
        {
            get;
            set;
        }

        /// <summary>
        /// Indicates whether this layer hosts any content, rather than being used for
        /// transform/scrolling purposes only.
        /// </summary>
        [DataMember(Name = ("drawsContent"), IsRequired = (true))]
        public bool DrawsContent
        {
            get;
            set;
        }

        /// <summary>
        /// Set if layer is not visible.
        /// </summary>
        [DataMember(Name = ("invisible"), IsRequired = (false))]
        public bool? Invisible
        {
            get;
            set;
        }

        /// <summary>
        /// Rectangles scrolling on main thread only.
        /// </summary>
        [DataMember(Name = ("scrollRects"), IsRequired = (false))]
        public System.Collections.Generic.IList<CefSharp.DevTools.LayerTree.ScrollRect> ScrollRects
        {
            get;
            set;
        }

        /// <summary>
        /// Sticky position constraint information
        /// </summary>
        [DataMember(Name = ("stickyPositionConstraint"), IsRequired = (false))]
        public CefSharp.DevTools.LayerTree.StickyPositionConstraint StickyPositionConstraint
        {
            get;
            set;
        }
    }

    /// <summary>
    /// layerPainted
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class LayerPaintedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// The id of the painted layer.
        /// </summary>
        [DataMember(Name = ("layerId"), IsRequired = (true))]
        public string LayerId
        {
            get;
            private set;
        }

        /// <summary>
        /// Clip rectangle.
        /// </summary>
        [DataMember(Name = ("clip"), IsRequired = (true))]
        public CefSharp.DevTools.DOM.Rect Clip
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// layerTreeDidChange
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class LayerTreeDidChangeEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Layer tree, absent if not in the compositing mode.
        /// </summary>
        [DataMember(Name = ("layers"), IsRequired = (false))]
        public System.Collections.Generic.IList<CefSharp.DevTools.LayerTree.Layer> Layers
        {
            get;
            private set;
        }
    }
}

namespace CefSharp.DevTools.Log
{
    /// <summary>
    /// Log entry source.
    /// </summary>
    public enum LogEntrySource
    {
        /// <summary>
        /// xml
        /// </summary>
        [EnumMember(Value = ("xml"))]
        Xml,
        /// <summary>
        /// javascript
        /// </summary>
        [EnumMember(Value = ("javascript"))]
        Javascript,
        /// <summary>
        /// network
        /// </summary>
        [EnumMember(Value = ("network"))]
        Network,
        /// <summary>
        /// storage
        /// </summary>
        [EnumMember(Value = ("storage"))]
        Storage,
        /// <summary>
        /// appcache
        /// </summary>
        [EnumMember(Value = ("appcache"))]
        Appcache,
        /// <summary>
        /// rendering
        /// </summary>
        [EnumMember(Value = ("rendering"))]
        Rendering,
        /// <summary>
        /// security
        /// </summary>
        [EnumMember(Value = ("security"))]
        Security,
        /// <summary>
        /// deprecation
        /// </summary>
        [EnumMember(Value = ("deprecation"))]
        Deprecation,
        /// <summary>
        /// worker
        /// </summary>
        [EnumMember(Value = ("worker"))]
        Worker,
        /// <summary>
        /// violation
        /// </summary>
        [EnumMember(Value = ("violation"))]
        Violation,
        /// <summary>
        /// intervention
        /// </summary>
        [EnumMember(Value = ("intervention"))]
        Intervention,
        /// <summary>
        /// recommendation
        /// </summary>
        [EnumMember(Value = ("recommendation"))]
        Recommendation,
        /// <summary>
        /// other
        /// </summary>
        [EnumMember(Value = ("other"))]
        Other
    }

    /// <summary>
    /// Log entry severity.
    /// </summary>
    public enum LogEntryLevel
    {
        /// <summary>
        /// verbose
        /// </summary>
        [EnumMember(Value = ("verbose"))]
        Verbose,
        /// <summary>
        /// info
        /// </summary>
        [EnumMember(Value = ("info"))]
        Info,
        /// <summary>
        /// warning
        /// </summary>
        [EnumMember(Value = ("warning"))]
        Warning,
        /// <summary>
        /// error
        /// </summary>
        [EnumMember(Value = ("error"))]
        Error
    }

    /// <summary>
    /// LogEntryCategory
    /// </summary>
    public enum LogEntryCategory
    {
        /// <summary>
        /// cors
        /// </summary>
        [EnumMember(Value = ("cors"))]
        Cors
    }

    /// <summary>
    /// Log entry.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class LogEntry : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Log entry source.
        /// </summary>
        public CefSharp.DevTools.Log.LogEntrySource Source
        {
            get
            {
                return (CefSharp.DevTools.Log.LogEntrySource)(StringToEnum(typeof(CefSharp.DevTools.Log.LogEntrySource), source));
            }

            set
            {
                this.source = (EnumToString(value));
            }
        }

        /// <summary>
        /// Log entry source.
        /// </summary>
        [DataMember(Name = ("source"), IsRequired = (true))]
        internal string source
        {
            get;
            set;
        }

        /// <summary>
        /// Log entry severity.
        /// </summary>
        public CefSharp.DevTools.Log.LogEntryLevel Level
        {
            get
            {
                return (CefSharp.DevTools.Log.LogEntryLevel)(StringToEnum(typeof(CefSharp.DevTools.Log.LogEntryLevel), level));
            }

            set
            {
                this.level = (EnumToString(value));
            }
        }

        /// <summary>
        /// Log entry severity.
        /// </summary>
        [DataMember(Name = ("level"), IsRequired = (true))]
        internal string level
        {
            get;
            set;
        }

        /// <summary>
        /// Logged text.
        /// </summary>
        [DataMember(Name = ("text"), IsRequired = (true))]
        public string Text
        {
            get;
            set;
        }

        /// <summary>
        /// Category
        /// </summary>
        public CefSharp.DevTools.Log.LogEntryCategory? Category
        {
            get
            {
                return (CefSharp.DevTools.Log.LogEntryCategory? )(StringToEnum(typeof(CefSharp.DevTools.Log.LogEntryCategory? ), category));
            }

            set
            {
                this.category = (EnumToString(value));
            }
        }

        /// <summary>
        /// Category
        /// </summary>
        [DataMember(Name = ("category"), IsRequired = (false))]
        internal string category
        {
            get;
            set;
        }

        /// <summary>
        /// Timestamp when this entry was added.
        /// </summary>
        [DataMember(Name = ("timestamp"), IsRequired = (true))]
        public double Timestamp
        {
            get;
            set;
        }

        /// <summary>
        /// URL of the resource if known.
        /// </summary>
        [DataMember(Name = ("url"), IsRequired = (false))]
        public string Url
        {
            get;
            set;
        }

        /// <summary>
        /// Line number in the resource.
        /// </summary>
        [DataMember(Name = ("lineNumber"), IsRequired = (false))]
        public int? LineNumber
        {
            get;
            set;
        }

        /// <summary>
        /// JavaScript stack trace.
        /// </summary>
        [DataMember(Name = ("stackTrace"), IsRequired = (false))]
        public CefSharp.DevTools.Runtime.StackTrace StackTrace
        {
            get;
            set;
        }

        /// <summary>
        /// Identifier of the network request associated with this entry.
        /// </summary>
        [DataMember(Name = ("networkRequestId"), IsRequired = (false))]
        public string NetworkRequestId
        {
            get;
            set;
        }

        /// <summary>
        /// Identifier of the worker associated with this entry.
        /// </summary>
        [DataMember(Name = ("workerId"), IsRequired = (false))]
        public string WorkerId
        {
            get;
            set;
        }

        /// <summary>
        /// Call arguments.
        /// </summary>
        [DataMember(Name = ("args"), IsRequired = (false))]
        public System.Collections.Generic.IList<CefSharp.DevTools.Runtime.RemoteObject> Args
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Violation type.
    /// </summary>
    public enum ViolationSettingName
    {
        /// <summary>
        /// longTask
        /// </summary>
        [EnumMember(Value = ("longTask"))]
        LongTask,
        /// <summary>
        /// longLayout
        /// </summary>
        [EnumMember(Value = ("longLayout"))]
        LongLayout,
        /// <summary>
        /// blockedEvent
        /// </summary>
        [EnumMember(Value = ("blockedEvent"))]
        BlockedEvent,
        /// <summary>
        /// blockedParser
        /// </summary>
        [EnumMember(Value = ("blockedParser"))]
        BlockedParser,
        /// <summary>
        /// discouragedAPIUse
        /// </summary>
        [EnumMember(Value = ("discouragedAPIUse"))]
        DiscouragedAPIUse,
        /// <summary>
        /// handler
        /// </summary>
        [EnumMember(Value = ("handler"))]
        Handler,
        /// <summary>
        /// recurringHandler
        /// </summary>
        [EnumMember(Value = ("recurringHandler"))]
        RecurringHandler
    }

    /// <summary>
    /// Violation configuration setting.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class ViolationSetting : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Violation type.
        /// </summary>
        public CefSharp.DevTools.Log.ViolationSettingName Name
        {
            get
            {
                return (CefSharp.DevTools.Log.ViolationSettingName)(StringToEnum(typeof(CefSharp.DevTools.Log.ViolationSettingName), name));
            }

            set
            {
                this.name = (EnumToString(value));
            }
        }

        /// <summary>
        /// Violation type.
        /// </summary>
        [DataMember(Name = ("name"), IsRequired = (true))]
        internal string name
        {
            get;
            set;
        }

        /// <summary>
        /// Time threshold to trigger upon.
        /// </summary>
        [DataMember(Name = ("threshold"), IsRequired = (true))]
        public double Threshold
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Issued when new message was logged.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class EntryAddedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// The entry.
        /// </summary>
        [DataMember(Name = ("entry"), IsRequired = (true))]
        public CefSharp.DevTools.Log.LogEntry Entry
        {
            get;
            private set;
        }
    }
}

namespace CefSharp.DevTools.Memory
{
    /// <summary>
    /// Memory pressure level.
    /// </summary>
    public enum PressureLevel
    {
        /// <summary>
        /// moderate
        /// </summary>
        [EnumMember(Value = ("moderate"))]
        Moderate,
        /// <summary>
        /// critical
        /// </summary>
        [EnumMember(Value = ("critical"))]
        Critical
    }

    /// <summary>
    /// Heap profile sample.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class SamplingProfileNode : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Size of the sampled allocation.
        /// </summary>
        [DataMember(Name = ("size"), IsRequired = (true))]
        public double Size
        {
            get;
            set;
        }

        /// <summary>
        /// Total bytes attributed to this sample.
        /// </summary>
        [DataMember(Name = ("total"), IsRequired = (true))]
        public double Total
        {
            get;
            set;
        }

        /// <summary>
        /// Execution stack at the point of allocation.
        /// </summary>
        [DataMember(Name = ("stack"), IsRequired = (true))]
        public string[] Stack
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Array of heap profile samples.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class SamplingProfile : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Samples
        /// </summary>
        [DataMember(Name = ("samples"), IsRequired = (true))]
        public System.Collections.Generic.IList<CefSharp.DevTools.Memory.SamplingProfileNode> Samples
        {
            get;
            set;
        }

        /// <summary>
        /// Modules
        /// </summary>
        [DataMember(Name = ("modules"), IsRequired = (true))]
        public System.Collections.Generic.IList<CefSharp.DevTools.Memory.Module> Modules
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Executable module information
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class Module : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Name of the module.
        /// </summary>
        [DataMember(Name = ("name"), IsRequired = (true))]
        public string Name
        {
            get;
            set;
        }

        /// <summary>
        /// UUID of the module.
        /// </summary>
        [DataMember(Name = ("uuid"), IsRequired = (true))]
        public string Uuid
        {
            get;
            set;
        }

        /// <summary>
        /// Base address where the module is loaded into memory. Encoded as a decimal
        /// or hexadecimal (0x prefixed) string.
        /// </summary>
        [DataMember(Name = ("baseAddress"), IsRequired = (true))]
        public string BaseAddress
        {
            get;
            set;
        }

        /// <summary>
        /// Size of the module in bytes.
        /// </summary>
        [DataMember(Name = ("size"), IsRequired = (true))]
        public double Size
        {
            get;
            set;
        }
    }
}

namespace CefSharp.DevTools.Network
{
    /// <summary>
    /// Resource type as it was perceived by the rendering engine.
    /// </summary>
    public enum ResourceType
    {
        /// <summary>
        /// Document
        /// </summary>
        [EnumMember(Value = ("Document"))]
        Document,
        /// <summary>
        /// Stylesheet
        /// </summary>
        [EnumMember(Value = ("Stylesheet"))]
        Stylesheet,
        /// <summary>
        /// Image
        /// </summary>
        [EnumMember(Value = ("Image"))]
        Image,
        /// <summary>
        /// Media
        /// </summary>
        [EnumMember(Value = ("Media"))]
        Media,
        /// <summary>
        /// Font
        /// </summary>
        [EnumMember(Value = ("Font"))]
        Font,
        /// <summary>
        /// Script
        /// </summary>
        [EnumMember(Value = ("Script"))]
        Script,
        /// <summary>
        /// TextTrack
        /// </summary>
        [EnumMember(Value = ("TextTrack"))]
        TextTrack,
        /// <summary>
        /// XHR
        /// </summary>
        [EnumMember(Value = ("XHR"))]
        XHR,
        /// <summary>
        /// Fetch
        /// </summary>
        [EnumMember(Value = ("Fetch"))]
        Fetch,
        /// <summary>
        /// Prefetch
        /// </summary>
        [EnumMember(Value = ("Prefetch"))]
        Prefetch,
        /// <summary>
        /// EventSource
        /// </summary>
        [EnumMember(Value = ("EventSource"))]
        EventSource,
        /// <summary>
        /// WebSocket
        /// </summary>
        [EnumMember(Value = ("WebSocket"))]
        WebSocket,
        /// <summary>
        /// Manifest
        /// </summary>
        [EnumMember(Value = ("Manifest"))]
        Manifest,
        /// <summary>
        /// SignedExchange
        /// </summary>
        [EnumMember(Value = ("SignedExchange"))]
        SignedExchange,
        /// <summary>
        /// Ping
        /// </summary>
        [EnumMember(Value = ("Ping"))]
        Ping,
        /// <summary>
        /// CSPViolationReport
        /// </summary>
        [EnumMember(Value = ("CSPViolationReport"))]
        CSPViolationReport,
        /// <summary>
        /// Preflight
        /// </summary>
        [EnumMember(Value = ("Preflight"))]
        Preflight,
        /// <summary>
        /// Other
        /// </summary>
        [EnumMember(Value = ("Other"))]
        Other
    }

    /// <summary>
    /// Network level fetch failure reason.
    /// </summary>
    public enum ErrorReason
    {
        /// <summary>
        /// Failed
        /// </summary>
        [EnumMember(Value = ("Failed"))]
        Failed,
        /// <summary>
        /// Aborted
        /// </summary>
        [EnumMember(Value = ("Aborted"))]
        Aborted,
        /// <summary>
        /// TimedOut
        /// </summary>
        [EnumMember(Value = ("TimedOut"))]
        TimedOut,
        /// <summary>
        /// AccessDenied
        /// </summary>
        [EnumMember(Value = ("AccessDenied"))]
        AccessDenied,
        /// <summary>
        /// ConnectionClosed
        /// </summary>
        [EnumMember(Value = ("ConnectionClosed"))]
        ConnectionClosed,
        /// <summary>
        /// ConnectionReset
        /// </summary>
        [EnumMember(Value = ("ConnectionReset"))]
        ConnectionReset,
        /// <summary>
        /// ConnectionRefused
        /// </summary>
        [EnumMember(Value = ("ConnectionRefused"))]
        ConnectionRefused,
        /// <summary>
        /// ConnectionAborted
        /// </summary>
        [EnumMember(Value = ("ConnectionAborted"))]
        ConnectionAborted,
        /// <summary>
        /// ConnectionFailed
        /// </summary>
        [EnumMember(Value = ("ConnectionFailed"))]
        ConnectionFailed,
        /// <summary>
        /// NameNotResolved
        /// </summary>
        [EnumMember(Value = ("NameNotResolved"))]
        NameNotResolved,
        /// <summary>
        /// InternetDisconnected
        /// </summary>
        [EnumMember(Value = ("InternetDisconnected"))]
        InternetDisconnected,
        /// <summary>
        /// AddressUnreachable
        /// </summary>
        [EnumMember(Value = ("AddressUnreachable"))]
        AddressUnreachable,
        /// <summary>
        /// BlockedByClient
        /// </summary>
        [EnumMember(Value = ("BlockedByClient"))]
        BlockedByClient,
        /// <summary>
        /// BlockedByResponse
        /// </summary>
        [EnumMember(Value = ("BlockedByResponse"))]
        BlockedByResponse
    }

    /// <summary>
    /// The underlying connection technology that the browser is supposedly using.
    /// </summary>
    public enum ConnectionType
    {
        /// <summary>
        /// none
        /// </summary>
        [EnumMember(Value = ("none"))]
        None,
        /// <summary>
        /// cellular2g
        /// </summary>
        [EnumMember(Value = ("cellular2g"))]
        Cellular2g,
        /// <summary>
        /// cellular3g
        /// </summary>
        [EnumMember(Value = ("cellular3g"))]
        Cellular3g,
        /// <summary>
        /// cellular4g
        /// </summary>
        [EnumMember(Value = ("cellular4g"))]
        Cellular4g,
        /// <summary>
        /// bluetooth
        /// </summary>
        [EnumMember(Value = ("bluetooth"))]
        Bluetooth,
        /// <summary>
        /// ethernet
        /// </summary>
        [EnumMember(Value = ("ethernet"))]
        Ethernet,
        /// <summary>
        /// wifi
        /// </summary>
        [EnumMember(Value = ("wifi"))]
        Wifi,
        /// <summary>
        /// wimax
        /// </summary>
        [EnumMember(Value = ("wimax"))]
        Wimax,
        /// <summary>
        /// other
        /// </summary>
        [EnumMember(Value = ("other"))]
        Other
    }

    /// <summary>
    /// Represents the cookie&apos;s &apos;SameSite&apos; status:
    /// https://tools.ietf.org/html/draft-west-first-party-cookies
    /// </summary>
    public enum CookieSameSite
    {
        /// <summary>
        /// Strict
        /// </summary>
        [EnumMember(Value = ("Strict"))]
        Strict,
        /// <summary>
        /// Lax
        /// </summary>
        [EnumMember(Value = ("Lax"))]
        Lax,
        /// <summary>
        /// None
        /// </summary>
        [EnumMember(Value = ("None"))]
        None
    }

    /// <summary>
    /// Represents the cookie&apos;s &apos;Priority&apos; status:
    /// https://tools.ietf.org/html/draft-west-cookie-priority-00
    /// </summary>
    public enum CookiePriority
    {
        /// <summary>
        /// Low
        /// </summary>
        [EnumMember(Value = ("Low"))]
        Low,
        /// <summary>
        /// Medium
        /// </summary>
        [EnumMember(Value = ("Medium"))]
        Medium,
        /// <summary>
        /// High
        /// </summary>
        [EnumMember(Value = ("High"))]
        High
    }

    /// <summary>
    /// Represents the source scheme of the origin that originally set the cookie.
    /// A value of &quot;Unset&quot; allows protocol clients to emulate legacy cookie scope for the scheme.
    /// This is a temporary ability and it will be removed in the future.
    /// </summary>
    public enum CookieSourceScheme
    {
        /// <summary>
        /// Unset
        /// </summary>
        [EnumMember(Value = ("Unset"))]
        Unset,
        /// <summary>
        /// NonSecure
        /// </summary>
        [EnumMember(Value = ("NonSecure"))]
        NonSecure,
        /// <summary>
        /// Secure
        /// </summary>
        [EnumMember(Value = ("Secure"))]
        Secure
    }

    /// <summary>
    /// Timing information for the request.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class ResourceTiming : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Timing&apos;s requestTime is a baseline in seconds, while the other numbers are ticks in
        /// milliseconds relatively to this requestTime.
        /// </summary>
        [DataMember(Name = ("requestTime"), IsRequired = (true))]
        public double RequestTime
        {
            get;
            set;
        }

        /// <summary>
        /// Started resolving proxy.
        /// </summary>
        [DataMember(Name = ("proxyStart"), IsRequired = (true))]
        public double ProxyStart
        {
            get;
            set;
        }

        /// <summary>
        /// Finished resolving proxy.
        /// </summary>
        [DataMember(Name = ("proxyEnd"), IsRequired = (true))]
        public double ProxyEnd
        {
            get;
            set;
        }

        /// <summary>
        /// Started DNS address resolve.
        /// </summary>
        [DataMember(Name = ("dnsStart"), IsRequired = (true))]
        public double DnsStart
        {
            get;
            set;
        }

        /// <summary>
        /// Finished DNS address resolve.
        /// </summary>
        [DataMember(Name = ("dnsEnd"), IsRequired = (true))]
        public double DnsEnd
        {
            get;
            set;
        }

        /// <summary>
        /// Started connecting to the remote host.
        /// </summary>
        [DataMember(Name = ("connectStart"), IsRequired = (true))]
        public double ConnectStart
        {
            get;
            set;
        }

        /// <summary>
        /// Connected to the remote host.
        /// </summary>
        [DataMember(Name = ("connectEnd"), IsRequired = (true))]
        public double ConnectEnd
        {
            get;
            set;
        }

        /// <summary>
        /// Started SSL handshake.
        /// </summary>
        [DataMember(Name = ("sslStart"), IsRequired = (true))]
        public double SslStart
        {
            get;
            set;
        }

        /// <summary>
        /// Finished SSL handshake.
        /// </summary>
        [DataMember(Name = ("sslEnd"), IsRequired = (true))]
        public double SslEnd
        {
            get;
            set;
        }

        /// <summary>
        /// Started running ServiceWorker.
        /// </summary>
        [DataMember(Name = ("workerStart"), IsRequired = (true))]
        public double WorkerStart
        {
            get;
            set;
        }

        /// <summary>
        /// Finished Starting ServiceWorker.
        /// </summary>
        [DataMember(Name = ("workerReady"), IsRequired = (true))]
        public double WorkerReady
        {
            get;
            set;
        }

        /// <summary>
        /// Started fetch event.
        /// </summary>
        [DataMember(Name = ("workerFetchStart"), IsRequired = (true))]
        public double WorkerFetchStart
        {
            get;
            set;
        }

        /// <summary>
        /// Settled fetch event respondWith promise.
        /// </summary>
        [DataMember(Name = ("workerRespondWithSettled"), IsRequired = (true))]
        public double WorkerRespondWithSettled
        {
            get;
            set;
        }

        /// <summary>
        /// Started ServiceWorker static routing source evaluation.
        /// </summary>
        [DataMember(Name = ("workerRouterEvaluationStart"), IsRequired = (false))]
        public double? WorkerRouterEvaluationStart
        {
            get;
            set;
        }

        /// <summary>
        /// Started cache lookup when the source was evaluated to `cache`.
        /// </summary>
        [DataMember(Name = ("workerCacheLookupStart"), IsRequired = (false))]
        public double? WorkerCacheLookupStart
        {
            get;
            set;
        }

        /// <summary>
        /// Started sending request.
        /// </summary>
        [DataMember(Name = ("sendStart"), IsRequired = (true))]
        public double SendStart
        {
            get;
            set;
        }

        /// <summary>
        /// Finished sending request.
        /// </summary>
        [DataMember(Name = ("sendEnd"), IsRequired = (true))]
        public double SendEnd
        {
            get;
            set;
        }

        /// <summary>
        /// Time the server started pushing request.
        /// </summary>
        [DataMember(Name = ("pushStart"), IsRequired = (true))]
        public double PushStart
        {
            get;
            set;
        }

        /// <summary>
        /// Time the server finished pushing request.
        /// </summary>
        [DataMember(Name = ("pushEnd"), IsRequired = (true))]
        public double PushEnd
        {
            get;
            set;
        }

        /// <summary>
        /// Started receiving response headers.
        /// </summary>
        [DataMember(Name = ("receiveHeadersStart"), IsRequired = (true))]
        public double ReceiveHeadersStart
        {
            get;
            set;
        }

        /// <summary>
        /// Finished receiving response headers.
        /// </summary>
        [DataMember(Name = ("receiveHeadersEnd"), IsRequired = (true))]
        public double ReceiveHeadersEnd
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Loading priority of a resource request.
    /// </summary>
    public enum ResourcePriority
    {
        /// <summary>
        /// VeryLow
        /// </summary>
        [EnumMember(Value = ("VeryLow"))]
        VeryLow,
        /// <summary>
        /// Low
        /// </summary>
        [EnumMember(Value = ("Low"))]
        Low,
        /// <summary>
        /// Medium
        /// </summary>
        [EnumMember(Value = ("Medium"))]
        Medium,
        /// <summary>
        /// High
        /// </summary>
        [EnumMember(Value = ("High"))]
        High,
        /// <summary>
        /// VeryHigh
        /// </summary>
        [EnumMember(Value = ("VeryHigh"))]
        VeryHigh
    }

    /// <summary>
    /// Post data entry for HTTP request
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class PostDataEntry : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Bytes
        /// </summary>
        [DataMember(Name = ("bytes"), IsRequired = (false))]
        public byte[] Bytes
        {
            get;
            set;
        }
    }

    /// <summary>
    /// The referrer policy of the request, as defined in https://www.w3.org/TR/referrer-policy/
    /// </summary>
    public enum RequestReferrerPolicy
    {
        /// <summary>
        /// unsafe-url
        /// </summary>
        [EnumMember(Value = ("unsafe-url"))]
        UnsafeUrl,
        /// <summary>
        /// no-referrer-when-downgrade
        /// </summary>
        [EnumMember(Value = ("no-referrer-when-downgrade"))]
        NoReferrerWhenDowngrade,
        /// <summary>
        /// no-referrer
        /// </summary>
        [EnumMember(Value = ("no-referrer"))]
        NoReferrer,
        /// <summary>
        /// origin
        /// </summary>
        [EnumMember(Value = ("origin"))]
        Origin,
        /// <summary>
        /// origin-when-cross-origin
        /// </summary>
        [EnumMember(Value = ("origin-when-cross-origin"))]
        OriginWhenCrossOrigin,
        /// <summary>
        /// same-origin
        /// </summary>
        [EnumMember(Value = ("same-origin"))]
        SameOrigin,
        /// <summary>
        /// strict-origin
        /// </summary>
        [EnumMember(Value = ("strict-origin"))]
        StrictOrigin,
        /// <summary>
        /// strict-origin-when-cross-origin
        /// </summary>
        [EnumMember(Value = ("strict-origin-when-cross-origin"))]
        StrictOriginWhenCrossOrigin
    }

    /// <summary>
    /// HTTP request data.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class Request : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Request URL (without fragment).
        /// </summary>
        [DataMember(Name = ("url"), IsRequired = (true))]
        public string Url
        {
            get;
            set;
        }

        /// <summary>
        /// Fragment of the requested URL starting with hash, if present.
        /// </summary>
        [DataMember(Name = ("urlFragment"), IsRequired = (false))]
        public string UrlFragment
        {
            get;
            set;
        }

        /// <summary>
        /// HTTP request method.
        /// </summary>
        [DataMember(Name = ("method"), IsRequired = (true))]
        public string Method
        {
            get;
            set;
        }

        /// <summary>
        /// HTTP request headers.
        /// </summary>
        [DataMember(Name = ("headers"), IsRequired = (true))]
        public CefSharp.DevTools.Network.Headers Headers
        {
            get;
            set;
        }

        /// <summary>
        /// HTTP POST request data.
        /// Use postDataEntries instead.
        /// </summary>
        [DataMember(Name = ("postData"), IsRequired = (false))]
        public string PostData
        {
            get;
            set;
        }

        /// <summary>
        /// True when the request has POST data. Note that postData might still be omitted when this flag is true when the data is too long.
        /// </summary>
        [DataMember(Name = ("hasPostData"), IsRequired = (false))]
        public bool? HasPostData
        {
            get;
            set;
        }

        /// <summary>
        /// Request body elements (post data broken into individual entries).
        /// </summary>
        [DataMember(Name = ("postDataEntries"), IsRequired = (false))]
        public System.Collections.Generic.IList<CefSharp.DevTools.Network.PostDataEntry> PostDataEntries
        {
            get;
            set;
        }

        /// <summary>
        /// The mixed content type of the request.
        /// </summary>
        public CefSharp.DevTools.Security.MixedContentType? MixedContentType
        {
            get
            {
                return (CefSharp.DevTools.Security.MixedContentType? )(StringToEnum(typeof(CefSharp.DevTools.Security.MixedContentType? ), mixedContentType));
            }

            set
            {
                this.mixedContentType = (EnumToString(value));
            }
        }

        /// <summary>
        /// The mixed content type of the request.
        /// </summary>
        [DataMember(Name = ("mixedContentType"), IsRequired = (false))]
        internal string mixedContentType
        {
            get;
            set;
        }

        /// <summary>
        /// Priority of the resource request at the time request is sent.
        /// </summary>
        public CefSharp.DevTools.Network.ResourcePriority InitialPriority
        {
            get
            {
                return (CefSharp.DevTools.Network.ResourcePriority)(StringToEnum(typeof(CefSharp.DevTools.Network.ResourcePriority), initialPriority));
            }

            set
            {
                this.initialPriority = (EnumToString(value));
            }
        }

        /// <summary>
        /// Priority of the resource request at the time request is sent.
        /// </summary>
        [DataMember(Name = ("initialPriority"), IsRequired = (true))]
        internal string initialPriority
        {
            get;
            set;
        }

        /// <summary>
        /// The referrer policy of the request, as defined in https://www.w3.org/TR/referrer-policy/
        /// </summary>
        public CefSharp.DevTools.Network.RequestReferrerPolicy ReferrerPolicy
        {
            get
            {
                return (CefSharp.DevTools.Network.RequestReferrerPolicy)(StringToEnum(typeof(CefSharp.DevTools.Network.RequestReferrerPolicy), referrerPolicy));
            }

            set
            {
                this.referrerPolicy = (EnumToString(value));
            }
        }

        /// <summary>
        /// The referrer policy of the request, as defined in https://www.w3.org/TR/referrer-policy/
        /// </summary>
        [DataMember(Name = ("referrerPolicy"), IsRequired = (true))]
        internal string referrerPolicy
        {
            get;
            set;
        }

        /// <summary>
        /// Whether is loaded via link preload.
        /// </summary>
        [DataMember(Name = ("isLinkPreload"), IsRequired = (false))]
        public bool? IsLinkPreload
        {
            get;
            set;
        }

        /// <summary>
        /// Set for requests when the TrustToken API is used. Contains the parameters
        /// passed by the developer (e.g. via &quot;fetch&quot;) as understood by the backend.
        /// </summary>
        [DataMember(Name = ("trustTokenParams"), IsRequired = (false))]
        public CefSharp.DevTools.Network.TrustTokenParams TrustTokenParams
        {
            get;
            set;
        }

        /// <summary>
        /// True if this resource request is considered to be the &apos;same site&apos; as the
        /// request corresponding to the main frame.
        /// </summary>
        [DataMember(Name = ("isSameSite"), IsRequired = (false))]
        public bool? IsSameSite
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Details of a signed certificate timestamp (SCT).
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class SignedCertificateTimestamp : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Validation status.
        /// </summary>
        [DataMember(Name = ("status"), IsRequired = (true))]
        public string Status
        {
            get;
            set;
        }

        /// <summary>
        /// Origin.
        /// </summary>
        [DataMember(Name = ("origin"), IsRequired = (true))]
        public string Origin
        {
            get;
            set;
        }

        /// <summary>
        /// Log name / description.
        /// </summary>
        [DataMember(Name = ("logDescription"), IsRequired = (true))]
        public string LogDescription
        {
            get;
            set;
        }

        /// <summary>
        /// Log ID.
        /// </summary>
        [DataMember(Name = ("logId"), IsRequired = (true))]
        public string LogId
        {
            get;
            set;
        }

        /// <summary>
        /// Issuance date. Unlike TimeSinceEpoch, this contains the number of
        /// milliseconds since January 1, 1970, UTC, not the number of seconds.
        /// </summary>
        [DataMember(Name = ("timestamp"), IsRequired = (true))]
        public double Timestamp
        {
            get;
            set;
        }

        /// <summary>
        /// Hash algorithm.
        /// </summary>
        [DataMember(Name = ("hashAlgorithm"), IsRequired = (true))]
        public string HashAlgorithm
        {
            get;
            set;
        }

        /// <summary>
        /// Signature algorithm.
        /// </summary>
        [DataMember(Name = ("signatureAlgorithm"), IsRequired = (true))]
        public string SignatureAlgorithm
        {
            get;
            set;
        }

        /// <summary>
        /// Signature data.
        /// </summary>
        [DataMember(Name = ("signatureData"), IsRequired = (true))]
        public string SignatureData
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Security details about a request.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class SecurityDetails : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Protocol name (e.g. &quot;TLS 1.2&quot; or &quot;QUIC&quot;).
        /// </summary>
        [DataMember(Name = ("protocol"), IsRequired = (true))]
        public string Protocol
        {
            get;
            set;
        }

        /// <summary>
        /// Key Exchange used by the connection, or the empty string if not applicable.
        /// </summary>
        [DataMember(Name = ("keyExchange"), IsRequired = (true))]
        public string KeyExchange
        {
            get;
            set;
        }

        /// <summary>
        /// (EC)DH group used by the connection, if applicable.
        /// </summary>
        [DataMember(Name = ("keyExchangeGroup"), IsRequired = (false))]
        public string KeyExchangeGroup
        {
            get;
            set;
        }

        /// <summary>
        /// Cipher name.
        /// </summary>
        [DataMember(Name = ("cipher"), IsRequired = (true))]
        public string Cipher
        {
            get;
            set;
        }

        /// <summary>
        /// TLS MAC. Note that AEAD ciphers do not have separate MACs.
        /// </summary>
        [DataMember(Name = ("mac"), IsRequired = (false))]
        public string Mac
        {
            get;
            set;
        }

        /// <summary>
        /// Certificate ID value.
        /// </summary>
        [DataMember(Name = ("certificateId"), IsRequired = (true))]
        public int CertificateId
        {
            get;
            set;
        }

        /// <summary>
        /// Certificate subject name.
        /// </summary>
        [DataMember(Name = ("subjectName"), IsRequired = (true))]
        public string SubjectName
        {
            get;
            set;
        }

        /// <summary>
        /// Subject Alternative Name (SAN) DNS names and IP addresses.
        /// </summary>
        [DataMember(Name = ("sanList"), IsRequired = (true))]
        public string[] SanList
        {
            get;
            set;
        }

        /// <summary>
        /// Name of the issuing CA.
        /// </summary>
        [DataMember(Name = ("issuer"), IsRequired = (true))]
        public string Issuer
        {
            get;
            set;
        }

        /// <summary>
        /// Certificate valid from date.
        /// </summary>
        [DataMember(Name = ("validFrom"), IsRequired = (true))]
        public double ValidFrom
        {
            get;
            set;
        }

        /// <summary>
        /// Certificate valid to (expiration) date
        /// </summary>
        [DataMember(Name = ("validTo"), IsRequired = (true))]
        public double ValidTo
        {
            get;
            set;
        }

        /// <summary>
        /// List of signed certificate timestamps (SCTs).
        /// </summary>
        [DataMember(Name = ("signedCertificateTimestampList"), IsRequired = (true))]
        public System.Collections.Generic.IList<CefSharp.DevTools.Network.SignedCertificateTimestamp> SignedCertificateTimestampList
        {
            get;
            set;
        }

        /// <summary>
        /// Whether the request complied with Certificate Transparency policy
        /// </summary>
        public CefSharp.DevTools.Network.CertificateTransparencyCompliance CertificateTransparencyCompliance
        {
            get
            {
                return (CefSharp.DevTools.Network.CertificateTransparencyCompliance)(StringToEnum(typeof(CefSharp.DevTools.Network.CertificateTransparencyCompliance), certificateTransparencyCompliance));
            }

            set
            {
                this.certificateTransparencyCompliance = (EnumToString(value));
            }
        }

        /// <summary>
        /// Whether the request complied with Certificate Transparency policy
        /// </summary>
        [DataMember(Name = ("certificateTransparencyCompliance"), IsRequired = (true))]
        internal string certificateTransparencyCompliance
        {
            get;
            set;
        }

        /// <summary>
        /// The signature algorithm used by the server in the TLS server signature,
        /// represented as a TLS SignatureScheme code point. Omitted if not
        /// applicable or not known.
        /// </summary>
        [DataMember(Name = ("serverSignatureAlgorithm"), IsRequired = (false))]
        public int? ServerSignatureAlgorithm
        {
            get;
            set;
        }

        /// <summary>
        /// Whether the connection used Encrypted ClientHello
        /// </summary>
        [DataMember(Name = ("encryptedClientHello"), IsRequired = (true))]
        public bool EncryptedClientHello
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Whether the request complied with Certificate Transparency policy.
    /// </summary>
    public enum CertificateTransparencyCompliance
    {
        /// <summary>
        /// unknown
        /// </summary>
        [EnumMember(Value = ("unknown"))]
        Unknown,
        /// <summary>
        /// not-compliant
        /// </summary>
        [EnumMember(Value = ("not-compliant"))]
        NotCompliant,
        /// <summary>
        /// compliant
        /// </summary>
        [EnumMember(Value = ("compliant"))]
        Compliant
    }

    /// <summary>
    /// The reason why request was blocked.
    /// </summary>
    public enum BlockedReason
    {
        /// <summary>
        /// other
        /// </summary>
        [EnumMember(Value = ("other"))]
        Other,
        /// <summary>
        /// csp
        /// </summary>
        [EnumMember(Value = ("csp"))]
        Csp,
        /// <summary>
        /// mixed-content
        /// </summary>
        [EnumMember(Value = ("mixed-content"))]
        MixedContent,
        /// <summary>
        /// origin
        /// </summary>
        [EnumMember(Value = ("origin"))]
        Origin,
        /// <summary>
        /// inspector
        /// </summary>
        [EnumMember(Value = ("inspector"))]
        Inspector,
        /// <summary>
        /// subresource-filter
        /// </summary>
        [EnumMember(Value = ("subresource-filter"))]
        SubresourceFilter,
        /// <summary>
        /// content-type
        /// </summary>
        [EnumMember(Value = ("content-type"))]
        ContentType,
        /// <summary>
        /// coep-frame-resource-needs-coep-header
        /// </summary>
        [EnumMember(Value = ("coep-frame-resource-needs-coep-header"))]
        CoepFrameResourceNeedsCoepHeader,
        /// <summary>
        /// coop-sandboxed-iframe-cannot-navigate-to-coop-page
        /// </summary>
        [EnumMember(Value = ("coop-sandboxed-iframe-cannot-navigate-to-coop-page"))]
        CoopSandboxedIframeCannotNavigateToCoopPage,
        /// <summary>
        /// corp-not-same-origin
        /// </summary>
        [EnumMember(Value = ("corp-not-same-origin"))]
        CorpNotSameOrigin,
        /// <summary>
        /// corp-not-same-origin-after-defaulted-to-same-origin-by-coep
        /// </summary>
        [EnumMember(Value = ("corp-not-same-origin-after-defaulted-to-same-origin-by-coep"))]
        CorpNotSameOriginAfterDefaultedToSameOriginByCoep,
        /// <summary>
        /// corp-not-same-origin-after-defaulted-to-same-origin-by-dip
        /// </summary>
        [EnumMember(Value = ("corp-not-same-origin-after-defaulted-to-same-origin-by-dip"))]
        CorpNotSameOriginAfterDefaultedToSameOriginByDip,
        /// <summary>
        /// corp-not-same-origin-after-defaulted-to-same-origin-by-coep-and-dip
        /// </summary>
        [EnumMember(Value = ("corp-not-same-origin-after-defaulted-to-same-origin-by-coep-and-dip"))]
        CorpNotSameOriginAfterDefaultedToSameOriginByCoepAndDip,
        /// <summary>
        /// corp-not-same-site
        /// </summary>
        [EnumMember(Value = ("corp-not-same-site"))]
        CorpNotSameSite
    }

    /// <summary>
    /// The reason why request was blocked.
    /// </summary>
    public enum CorsError
    {
        /// <summary>
        /// DisallowedByMode
        /// </summary>
        [EnumMember(Value = ("DisallowedByMode"))]
        DisallowedByMode,
        /// <summary>
        /// InvalidResponse
        /// </summary>
        [EnumMember(Value = ("InvalidResponse"))]
        InvalidResponse,
        /// <summary>
        /// WildcardOriginNotAllowed
        /// </summary>
        [EnumMember(Value = ("WildcardOriginNotAllowed"))]
        WildcardOriginNotAllowed,
        /// <summary>
        /// MissingAllowOriginHeader
        /// </summary>
        [EnumMember(Value = ("MissingAllowOriginHeader"))]
        MissingAllowOriginHeader,
        /// <summary>
        /// MultipleAllowOriginValues
        /// </summary>
        [EnumMember(Value = ("MultipleAllowOriginValues"))]
        MultipleAllowOriginValues,
        /// <summary>
        /// InvalidAllowOriginValue
        /// </summary>
        [EnumMember(Value = ("InvalidAllowOriginValue"))]
        InvalidAllowOriginValue,
        /// <summary>
        /// AllowOriginMismatch
        /// </summary>
        [EnumMember(Value = ("AllowOriginMismatch"))]
        AllowOriginMismatch,
        /// <summary>
        /// InvalidAllowCredentials
        /// </summary>
        [EnumMember(Value = ("InvalidAllowCredentials"))]
        InvalidAllowCredentials,
        /// <summary>
        /// CorsDisabledScheme
        /// </summary>
        [EnumMember(Value = ("CorsDisabledScheme"))]
        CorsDisabledScheme,
        /// <summary>
        /// PreflightInvalidStatus
        /// </summary>
        [EnumMember(Value = ("PreflightInvalidStatus"))]
        PreflightInvalidStatus,
        /// <summary>
        /// PreflightDisallowedRedirect
        /// </summary>
        [EnumMember(Value = ("PreflightDisallowedRedirect"))]
        PreflightDisallowedRedirect,
        /// <summary>
        /// PreflightWildcardOriginNotAllowed
        /// </summary>
        [EnumMember(Value = ("PreflightWildcardOriginNotAllowed"))]
        PreflightWildcardOriginNotAllowed,
        /// <summary>
        /// PreflightMissingAllowOriginHeader
        /// </summary>
        [EnumMember(Value = ("PreflightMissingAllowOriginHeader"))]
        PreflightMissingAllowOriginHeader,
        /// <summary>
        /// PreflightMultipleAllowOriginValues
        /// </summary>
        [EnumMember(Value = ("PreflightMultipleAllowOriginValues"))]
        PreflightMultipleAllowOriginValues,
        /// <summary>
        /// PreflightInvalidAllowOriginValue
        /// </summary>
        [EnumMember(Value = ("PreflightInvalidAllowOriginValue"))]
        PreflightInvalidAllowOriginValue,
        /// <summary>
        /// PreflightAllowOriginMismatch
        /// </summary>
        [EnumMember(Value = ("PreflightAllowOriginMismatch"))]
        PreflightAllowOriginMismatch,
        /// <summary>
        /// PreflightInvalidAllowCredentials
        /// </summary>
        [EnumMember(Value = ("PreflightInvalidAllowCredentials"))]
        PreflightInvalidAllowCredentials,
        /// <summary>
        /// PreflightMissingAllowExternal
        /// </summary>
        [EnumMember(Value = ("PreflightMissingAllowExternal"))]
        PreflightMissingAllowExternal,
        /// <summary>
        /// PreflightInvalidAllowExternal
        /// </summary>
        [EnumMember(Value = ("PreflightInvalidAllowExternal"))]
        PreflightInvalidAllowExternal,
        /// <summary>
        /// PreflightMissingAllowPrivateNetwork
        /// </summary>
        [EnumMember(Value = ("PreflightMissingAllowPrivateNetwork"))]
        PreflightMissingAllowPrivateNetwork,
        /// <summary>
        /// PreflightInvalidAllowPrivateNetwork
        /// </summary>
        [EnumMember(Value = ("PreflightInvalidAllowPrivateNetwork"))]
        PreflightInvalidAllowPrivateNetwork,
        /// <summary>
        /// InvalidAllowMethodsPreflightResponse
        /// </summary>
        [EnumMember(Value = ("InvalidAllowMethodsPreflightResponse"))]
        InvalidAllowMethodsPreflightResponse,
        /// <summary>
        /// InvalidAllowHeadersPreflightResponse
        /// </summary>
        [EnumMember(Value = ("InvalidAllowHeadersPreflightResponse"))]
        InvalidAllowHeadersPreflightResponse,
        /// <summary>
        /// MethodDisallowedByPreflightResponse
        /// </summary>
        [EnumMember(Value = ("MethodDisallowedByPreflightResponse"))]
        MethodDisallowedByPreflightResponse,
        /// <summary>
        /// HeaderDisallowedByPreflightResponse
        /// </summary>
        [EnumMember(Value = ("HeaderDisallowedByPreflightResponse"))]
        HeaderDisallowedByPreflightResponse,
        /// <summary>
        /// RedirectContainsCredentials
        /// </summary>
        [EnumMember(Value = ("RedirectContainsCredentials"))]
        RedirectContainsCredentials,
        /// <summary>
        /// InsecurePrivateNetwork
        /// </summary>
        [EnumMember(Value = ("InsecurePrivateNetwork"))]
        InsecurePrivateNetwork,
        /// <summary>
        /// InvalidPrivateNetworkAccess
        /// </summary>
        [EnumMember(Value = ("InvalidPrivateNetworkAccess"))]
        InvalidPrivateNetworkAccess,
        /// <summary>
        /// UnexpectedPrivateNetworkAccess
        /// </summary>
        [EnumMember(Value = ("UnexpectedPrivateNetworkAccess"))]
        UnexpectedPrivateNetworkAccess,
        /// <summary>
        /// NoCorsRedirectModeNotFollow
        /// </summary>
        [EnumMember(Value = ("NoCorsRedirectModeNotFollow"))]
        NoCorsRedirectModeNotFollow,
        /// <summary>
        /// PreflightMissingPrivateNetworkAccessId
        /// </summary>
        [EnumMember(Value = ("PreflightMissingPrivateNetworkAccessId"))]
        PreflightMissingPrivateNetworkAccessId,
        /// <summary>
        /// PreflightMissingPrivateNetworkAccessName
        /// </summary>
        [EnumMember(Value = ("PreflightMissingPrivateNetworkAccessName"))]
        PreflightMissingPrivateNetworkAccessName,
        /// <summary>
        /// PrivateNetworkAccessPermissionUnavailable
        /// </summary>
        [EnumMember(Value = ("PrivateNetworkAccessPermissionUnavailable"))]
        PrivateNetworkAccessPermissionUnavailable,
        /// <summary>
        /// PrivateNetworkAccessPermissionDenied
        /// </summary>
        [EnumMember(Value = ("PrivateNetworkAccessPermissionDenied"))]
        PrivateNetworkAccessPermissionDenied
    }

    /// <summary>
    /// CorsErrorStatus
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class CorsErrorStatus : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// CorsError
        /// </summary>
        public CefSharp.DevTools.Network.CorsError CorsError
        {
            get
            {
                return (CefSharp.DevTools.Network.CorsError)(StringToEnum(typeof(CefSharp.DevTools.Network.CorsError), corsError));
            }

            set
            {
                this.corsError = (EnumToString(value));
            }
        }

        /// <summary>
        /// CorsError
        /// </summary>
        [DataMember(Name = ("corsError"), IsRequired = (true))]
        internal string corsError
        {
            get;
            set;
        }

        /// <summary>
        /// FailedParameter
        /// </summary>
        [DataMember(Name = ("failedParameter"), IsRequired = (true))]
        public string FailedParameter
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Source of serviceworker response.
    /// </summary>
    public enum ServiceWorkerResponseSource
    {
        /// <summary>
        /// cache-storage
        /// </summary>
        [EnumMember(Value = ("cache-storage"))]
        CacheStorage,
        /// <summary>
        /// http-cache
        /// </summary>
        [EnumMember(Value = ("http-cache"))]
        HttpCache,
        /// <summary>
        /// fallback-code
        /// </summary>
        [EnumMember(Value = ("fallback-code"))]
        FallbackCode,
        /// <summary>
        /// network
        /// </summary>
        [EnumMember(Value = ("network"))]
        Network
    }

    /// <summary>
    /// Only set for &quot;token-redemption&quot; operation and determine whether
    /// to request a fresh SRR or use a still valid cached SRR.
    /// </summary>
    public enum TrustTokenParamsRefreshPolicy
    {
        /// <summary>
        /// UseCached
        /// </summary>
        [EnumMember(Value = ("UseCached"))]
        UseCached,
        /// <summary>
        /// Refresh
        /// </summary>
        [EnumMember(Value = ("Refresh"))]
        Refresh
    }

    /// <summary>
    /// Determines what type of Trust Token operation is executed and
    /// depending on the type, some additional parameters. The values
    /// are specified in third_party/blink/renderer/core/fetch/trust_token.idl.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class TrustTokenParams : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Operation
        /// </summary>
        public CefSharp.DevTools.Network.TrustTokenOperationType Operation
        {
            get
            {
                return (CefSharp.DevTools.Network.TrustTokenOperationType)(StringToEnum(typeof(CefSharp.DevTools.Network.TrustTokenOperationType), operation));
            }

            set
            {
                this.operation = (EnumToString(value));
            }
        }

        /// <summary>
        /// Operation
        /// </summary>
        [DataMember(Name = ("operation"), IsRequired = (true))]
        internal string operation
        {
            get;
            set;
        }

        /// <summary>
        /// Only set for &quot;token-redemption&quot; operation and determine whether
        /// to request a fresh SRR or use a still valid cached SRR.
        /// </summary>
        public CefSharp.DevTools.Network.TrustTokenParamsRefreshPolicy RefreshPolicy
        {
            get
            {
                return (CefSharp.DevTools.Network.TrustTokenParamsRefreshPolicy)(StringToEnum(typeof(CefSharp.DevTools.Network.TrustTokenParamsRefreshPolicy), refreshPolicy));
            }

            set
            {
                this.refreshPolicy = (EnumToString(value));
            }
        }

        /// <summary>
        /// Only set for &quot;token-redemption&quot; operation and determine whether
        /// to request a fresh SRR or use a still valid cached SRR.
        /// </summary>
        [DataMember(Name = ("refreshPolicy"), IsRequired = (true))]
        internal string refreshPolicy
        {
            get;
            set;
        }

        /// <summary>
        /// Origins of issuers from whom to request tokens or redemption
        /// records.
        /// </summary>
        [DataMember(Name = ("issuers"), IsRequired = (false))]
        public string[] Issuers
        {
            get;
            set;
        }
    }

    /// <summary>
    /// TrustTokenOperationType
    /// </summary>
    public enum TrustTokenOperationType
    {
        /// <summary>
        /// Issuance
        /// </summary>
        [EnumMember(Value = ("Issuance"))]
        Issuance,
        /// <summary>
        /// Redemption
        /// </summary>
        [EnumMember(Value = ("Redemption"))]
        Redemption,
        /// <summary>
        /// Signing
        /// </summary>
        [EnumMember(Value = ("Signing"))]
        Signing
    }

    /// <summary>
    /// The reason why Chrome uses a specific transport protocol for HTTP semantics.
    /// </summary>
    public enum AlternateProtocolUsage
    {
        /// <summary>
        /// alternativeJobWonWithoutRace
        /// </summary>
        [EnumMember(Value = ("alternativeJobWonWithoutRace"))]
        AlternativeJobWonWithoutRace,
        /// <summary>
        /// alternativeJobWonRace
        /// </summary>
        [EnumMember(Value = ("alternativeJobWonRace"))]
        AlternativeJobWonRace,
        /// <summary>
        /// mainJobWonRace
        /// </summary>
        [EnumMember(Value = ("mainJobWonRace"))]
        MainJobWonRace,
        /// <summary>
        /// mappingMissing
        /// </summary>
        [EnumMember(Value = ("mappingMissing"))]
        MappingMissing,
        /// <summary>
        /// broken
        /// </summary>
        [EnumMember(Value = ("broken"))]
        Broken,
        /// <summary>
        /// dnsAlpnH3JobWonWithoutRace
        /// </summary>
        [EnumMember(Value = ("dnsAlpnH3JobWonWithoutRace"))]
        DnsAlpnH3JobWonWithoutRace,
        /// <summary>
        /// dnsAlpnH3JobWonRace
        /// </summary>
        [EnumMember(Value = ("dnsAlpnH3JobWonRace"))]
        DnsAlpnH3JobWonRace,
        /// <summary>
        /// unspecifiedReason
        /// </summary>
        [EnumMember(Value = ("unspecifiedReason"))]
        UnspecifiedReason
    }

    /// <summary>
    /// Source of service worker router.
    /// </summary>
    public enum ServiceWorkerRouterSource
    {
        /// <summary>
        /// network
        /// </summary>
        [EnumMember(Value = ("network"))]
        Network,
        /// <summary>
        /// cache
        /// </summary>
        [EnumMember(Value = ("cache"))]
        Cache,
        /// <summary>
        /// fetch-event
        /// </summary>
        [EnumMember(Value = ("fetch-event"))]
        FetchEvent,
        /// <summary>
        /// race-network-and-fetch-handler
        /// </summary>
        [EnumMember(Value = ("race-network-and-fetch-handler"))]
        RaceNetworkAndFetchHandler
    }

    /// <summary>
    /// ServiceWorkerRouterInfo
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class ServiceWorkerRouterInfo : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// ID of the rule matched. If there is a matched rule, this field will
        /// be set, otherwiser no value will be set.
        /// </summary>
        [DataMember(Name = ("ruleIdMatched"), IsRequired = (false))]
        public int? RuleIdMatched
        {
            get;
            set;
        }

        /// <summary>
        /// The router source of the matched rule. If there is a matched rule, this
        /// field will be set, otherwise no value will be set.
        /// </summary>
        public CefSharp.DevTools.Network.ServiceWorkerRouterSource? MatchedSourceType
        {
            get
            {
                return (CefSharp.DevTools.Network.ServiceWorkerRouterSource? )(StringToEnum(typeof(CefSharp.DevTools.Network.ServiceWorkerRouterSource? ), matchedSourceType));
            }

            set
            {
                this.matchedSourceType = (EnumToString(value));
            }
        }

        /// <summary>
        /// The router source of the matched rule. If there is a matched rule, this
        /// field will be set, otherwise no value will be set.
        /// </summary>
        [DataMember(Name = ("matchedSourceType"), IsRequired = (false))]
        internal string matchedSourceType
        {
            get;
            set;
        }

        /// <summary>
        /// The actual router source used.
        /// </summary>
        public CefSharp.DevTools.Network.ServiceWorkerRouterSource? ActualSourceType
        {
            get
            {
                return (CefSharp.DevTools.Network.ServiceWorkerRouterSource? )(StringToEnum(typeof(CefSharp.DevTools.Network.ServiceWorkerRouterSource? ), actualSourceType));
            }

            set
            {
                this.actualSourceType = (EnumToString(value));
            }
        }

        /// <summary>
        /// The actual router source used.
        /// </summary>
        [DataMember(Name = ("actualSourceType"), IsRequired = (false))]
        internal string actualSourceType
        {
            get;
            set;
        }
    }

    /// <summary>
    /// HTTP response data.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class Response : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Response URL. This URL can be different from CachedResource.url in case of redirect.
        /// </summary>
        [DataMember(Name = ("url"), IsRequired = (true))]
        public string Url
        {
            get;
            set;
        }

        /// <summary>
        /// HTTP response status code.
        /// </summary>
        [DataMember(Name = ("status"), IsRequired = (true))]
        public int Status
        {
            get;
            set;
        }

        /// <summary>
        /// HTTP response status text.
        /// </summary>
        [DataMember(Name = ("statusText"), IsRequired = (true))]
        public string StatusText
        {
            get;
            set;
        }

        /// <summary>
        /// HTTP response headers.
        /// </summary>
        [DataMember(Name = ("headers"), IsRequired = (true))]
        public CefSharp.DevTools.Network.Headers Headers
        {
            get;
            set;
        }

        /// <summary>
        /// HTTP response headers text. This has been replaced by the headers in Network.responseReceivedExtraInfo.
        /// </summary>
        [DataMember(Name = ("headersText"), IsRequired = (false))]
        public string HeadersText
        {
            get;
            set;
        }

        /// <summary>
        /// Resource mimeType as determined by the browser.
        /// </summary>
        [DataMember(Name = ("mimeType"), IsRequired = (true))]
        public string MimeType
        {
            get;
            set;
        }

        /// <summary>
        /// Resource charset as determined by the browser (if applicable).
        /// </summary>
        [DataMember(Name = ("charset"), IsRequired = (true))]
        public string Charset
        {
            get;
            set;
        }

        /// <summary>
        /// Refined HTTP request headers that were actually transmitted over the network.
        /// </summary>
        [DataMember(Name = ("requestHeaders"), IsRequired = (false))]
        public CefSharp.DevTools.Network.Headers RequestHeaders
        {
            get;
            set;
        }

        /// <summary>
        /// HTTP request headers text. This has been replaced by the headers in Network.requestWillBeSentExtraInfo.
        /// </summary>
        [DataMember(Name = ("requestHeadersText"), IsRequired = (false))]
        public string RequestHeadersText
        {
            get;
            set;
        }

        /// <summary>
        /// Specifies whether physical connection was actually reused for this request.
        /// </summary>
        [DataMember(Name = ("connectionReused"), IsRequired = (true))]
        public bool ConnectionReused
        {
            get;
            set;
        }

        /// <summary>
        /// Physical connection id that was actually used for this request.
        /// </summary>
        [DataMember(Name = ("connectionId"), IsRequired = (true))]
        public double ConnectionId
        {
            get;
            set;
        }

        /// <summary>
        /// Remote IP address.
        /// </summary>
        [DataMember(Name = ("remoteIPAddress"), IsRequired = (false))]
        public string RemoteIPAddress
        {
            get;
            set;
        }

        /// <summary>
        /// Remote port.
        /// </summary>
        [DataMember(Name = ("remotePort"), IsRequired = (false))]
        public int? RemotePort
        {
            get;
            set;
        }

        /// <summary>
        /// Specifies that the request was served from the disk cache.
        /// </summary>
        [DataMember(Name = ("fromDiskCache"), IsRequired = (false))]
        public bool? FromDiskCache
        {
            get;
            set;
        }

        /// <summary>
        /// Specifies that the request was served from the ServiceWorker.
        /// </summary>
        [DataMember(Name = ("fromServiceWorker"), IsRequired = (false))]
        public bool? FromServiceWorker
        {
            get;
            set;
        }

        /// <summary>
        /// Specifies that the request was served from the prefetch cache.
        /// </summary>
        [DataMember(Name = ("fromPrefetchCache"), IsRequired = (false))]
        public bool? FromPrefetchCache
        {
            get;
            set;
        }

        /// <summary>
        /// Specifies that the request was served from the prefetch cache.
        /// </summary>
        [DataMember(Name = ("fromEarlyHints"), IsRequired = (false))]
        public bool? FromEarlyHints
        {
            get;
            set;
        }

        /// <summary>
        /// Information about how ServiceWorker Static Router API was used. If this
        /// field is set with `matchedSourceType` field, a matching rule is found.
        /// If this field is set without `matchedSource`, no matching rule is found.
        /// Otherwise, the API is not used.
        /// </summary>
        [DataMember(Name = ("serviceWorkerRouterInfo"), IsRequired = (false))]
        public CefSharp.DevTools.Network.ServiceWorkerRouterInfo ServiceWorkerRouterInfo
        {
            get;
            set;
        }

        /// <summary>
        /// Total number of bytes received for this request so far.
        /// </summary>
        [DataMember(Name = ("encodedDataLength"), IsRequired = (true))]
        public double EncodedDataLength
        {
            get;
            set;
        }

        /// <summary>
        /// Timing information for the given request.
        /// </summary>
        [DataMember(Name = ("timing"), IsRequired = (false))]
        public CefSharp.DevTools.Network.ResourceTiming Timing
        {
            get;
            set;
        }

        /// <summary>
        /// Response source of response from ServiceWorker.
        /// </summary>
        public CefSharp.DevTools.Network.ServiceWorkerResponseSource? ServiceWorkerResponseSource
        {
            get
            {
                return (CefSharp.DevTools.Network.ServiceWorkerResponseSource? )(StringToEnum(typeof(CefSharp.DevTools.Network.ServiceWorkerResponseSource? ), serviceWorkerResponseSource));
            }

            set
            {
                this.serviceWorkerResponseSource = (EnumToString(value));
            }
        }

        /// <summary>
        /// Response source of response from ServiceWorker.
        /// </summary>
        [DataMember(Name = ("serviceWorkerResponseSource"), IsRequired = (false))]
        internal string serviceWorkerResponseSource
        {
            get;
            set;
        }

        /// <summary>
        /// The time at which the returned response was generated.
        /// </summary>
        [DataMember(Name = ("responseTime"), IsRequired = (false))]
        public double? ResponseTime
        {
            get;
            set;
        }

        /// <summary>
        /// Cache Storage Cache Name.
        /// </summary>
        [DataMember(Name = ("cacheStorageCacheName"), IsRequired = (false))]
        public string CacheStorageCacheName
        {
            get;
            set;
        }

        /// <summary>
        /// Protocol used to fetch this request.
        /// </summary>
        [DataMember(Name = ("protocol"), IsRequired = (false))]
        public string Protocol
        {
            get;
            set;
        }

        /// <summary>
        /// The reason why Chrome uses a specific transport protocol for HTTP semantics.
        /// </summary>
        public CefSharp.DevTools.Network.AlternateProtocolUsage? AlternateProtocolUsage
        {
            get
            {
                return (CefSharp.DevTools.Network.AlternateProtocolUsage? )(StringToEnum(typeof(CefSharp.DevTools.Network.AlternateProtocolUsage? ), alternateProtocolUsage));
            }

            set
            {
                this.alternateProtocolUsage = (EnumToString(value));
            }
        }

        /// <summary>
        /// The reason why Chrome uses a specific transport protocol for HTTP semantics.
        /// </summary>
        [DataMember(Name = ("alternateProtocolUsage"), IsRequired = (false))]
        internal string alternateProtocolUsage
        {
            get;
            set;
        }

        /// <summary>
        /// Security state of the request resource.
        /// </summary>
        public CefSharp.DevTools.Security.SecurityState SecurityState
        {
            get
            {
                return (CefSharp.DevTools.Security.SecurityState)(StringToEnum(typeof(CefSharp.DevTools.Security.SecurityState), securityState));
            }

            set
            {
                this.securityState = (EnumToString(value));
            }
        }

        /// <summary>
        /// Security state of the request resource.
        /// </summary>
        [DataMember(Name = ("securityState"), IsRequired = (true))]
        internal string securityState
        {
            get;
            set;
        }

        /// <summary>
        /// Security details for the request.
        /// </summary>
        [DataMember(Name = ("securityDetails"), IsRequired = (false))]
        public CefSharp.DevTools.Network.SecurityDetails SecurityDetails
        {
            get;
            set;
        }
    }

    /// <summary>
    /// WebSocket request data.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class WebSocketRequest : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// HTTP request headers.
        /// </summary>
        [DataMember(Name = ("headers"), IsRequired = (true))]
        public CefSharp.DevTools.Network.Headers Headers
        {
            get;
            set;
        }
    }

    /// <summary>
    /// WebSocket response data.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class WebSocketResponse : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// HTTP response status code.
        /// </summary>
        [DataMember(Name = ("status"), IsRequired = (true))]
        public int Status
        {
            get;
            set;
        }

        /// <summary>
        /// HTTP response status text.
        /// </summary>
        [DataMember(Name = ("statusText"), IsRequired = (true))]
        public string StatusText
        {
            get;
            set;
        }

        /// <summary>
        /// HTTP response headers.
        /// </summary>
        [DataMember(Name = ("headers"), IsRequired = (true))]
        public CefSharp.DevTools.Network.Headers Headers
        {
            get;
            set;
        }

        /// <summary>
        /// HTTP response headers text.
        /// </summary>
        [DataMember(Name = ("headersText"), IsRequired = (false))]
        public string HeadersText
        {
            get;
            set;
        }

        /// <summary>
        /// HTTP request headers.
        /// </summary>
        [DataMember(Name = ("requestHeaders"), IsRequired = (false))]
        public CefSharp.DevTools.Network.Headers RequestHeaders
        {
            get;
            set;
        }

        /// <summary>
        /// HTTP request headers text.
        /// </summary>
        [DataMember(Name = ("requestHeadersText"), IsRequired = (false))]
        public string RequestHeadersText
        {
            get;
            set;
        }
    }

    /// <summary>
    /// WebSocket message data. This represents an entire WebSocket message, not just a fragmented frame as the name suggests.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class WebSocketFrame : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// WebSocket message opcode.
        /// </summary>
        [DataMember(Name = ("opcode"), IsRequired = (true))]
        public double Opcode
        {
            get;
            set;
        }

        /// <summary>
        /// WebSocket message mask.
        /// </summary>
        [DataMember(Name = ("mask"), IsRequired = (true))]
        public bool Mask
        {
            get;
            set;
        }

        /// <summary>
        /// WebSocket message payload data.
        /// If the opcode is 1, this is a text message and payloadData is a UTF-8 string.
        /// If the opcode isn&apos;t 1, then payloadData is a base64 encoded string representing binary data.
        /// </summary>
        [DataMember(Name = ("payloadData"), IsRequired = (true))]
        public string PayloadData
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Information about the cached resource.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class CachedResource : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Resource URL. This is the url of the original network request.
        /// </summary>
        [DataMember(Name = ("url"), IsRequired = (true))]
        public string Url
        {
            get;
            set;
        }

        /// <summary>
        /// Type of this resource.
        /// </summary>
        public CefSharp.DevTools.Network.ResourceType Type
        {
            get
            {
                return (CefSharp.DevTools.Network.ResourceType)(StringToEnum(typeof(CefSharp.DevTools.Network.ResourceType), type));
            }

            set
            {
                this.type = (EnumToString(value));
            }
        }

        /// <summary>
        /// Type of this resource.
        /// </summary>
        [DataMember(Name = ("type"), IsRequired = (true))]
        internal string type
        {
            get;
            set;
        }

        /// <summary>
        /// Cached response data.
        /// </summary>
        [DataMember(Name = ("response"), IsRequired = (false))]
        public CefSharp.DevTools.Network.Response Response
        {
            get;
            set;
        }

        /// <summary>
        /// Cached response body size.
        /// </summary>
        [DataMember(Name = ("bodySize"), IsRequired = (true))]
        public double BodySize
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Type of this initiator.
    /// </summary>
    public enum InitiatorType
    {
        /// <summary>
        /// parser
        /// </summary>
        [EnumMember(Value = ("parser"))]
        Parser,
        /// <summary>
        /// script
        /// </summary>
        [EnumMember(Value = ("script"))]
        Script,
        /// <summary>
        /// preload
        /// </summary>
        [EnumMember(Value = ("preload"))]
        Preload,
        /// <summary>
        /// SignedExchange
        /// </summary>
        [EnumMember(Value = ("SignedExchange"))]
        SignedExchange,
        /// <summary>
        /// preflight
        /// </summary>
        [EnumMember(Value = ("preflight"))]
        Preflight,
        /// <summary>
        /// other
        /// </summary>
        [EnumMember(Value = ("other"))]
        Other
    }

    /// <summary>
    /// Information about the request initiator.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class Initiator : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Type of this initiator.
        /// </summary>
        public CefSharp.DevTools.Network.InitiatorType Type
        {
            get
            {
                return (CefSharp.DevTools.Network.InitiatorType)(StringToEnum(typeof(CefSharp.DevTools.Network.InitiatorType), type));
            }

            set
            {
                this.type = (EnumToString(value));
            }
        }

        /// <summary>
        /// Type of this initiator.
        /// </summary>
        [DataMember(Name = ("type"), IsRequired = (true))]
        internal string type
        {
            get;
            set;
        }

        /// <summary>
        /// Initiator JavaScript stack trace, set for Script only.
        /// </summary>
        [DataMember(Name = ("stack"), IsRequired = (false))]
        public CefSharp.DevTools.Runtime.StackTrace Stack
        {
            get;
            set;
        }

        /// <summary>
        /// Initiator URL, set for Parser type or for Script type (when script is importing module) or for SignedExchange type.
        /// </summary>
        [DataMember(Name = ("url"), IsRequired = (false))]
        public string Url
        {
            get;
            set;
        }

        /// <summary>
        /// Initiator line number, set for Parser type or for Script type (when script is importing
        /// module) (0-based).
        /// </summary>
        [DataMember(Name = ("lineNumber"), IsRequired = (false))]
        public double? LineNumber
        {
            get;
            set;
        }

        /// <summary>
        /// Initiator column number, set for Parser type or for Script type (when script is importing
        /// module) (0-based).
        /// </summary>
        [DataMember(Name = ("columnNumber"), IsRequired = (false))]
        public double? ColumnNumber
        {
            get;
            set;
        }

        /// <summary>
        /// Set if another request triggered this request (e.g. preflight).
        /// </summary>
        [DataMember(Name = ("requestId"), IsRequired = (false))]
        public string RequestId
        {
            get;
            set;
        }
    }

    /// <summary>
    /// cookiePartitionKey object
    /// The representation of the components of the key that are created by the cookiePartitionKey class contained in net/cookies/cookie_partition_key.h.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class CookiePartitionKey : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The site of the top-level URL the browser was visiting at the start
        /// of the request to the endpoint that set the cookie.
        /// </summary>
        [DataMember(Name = ("topLevelSite"), IsRequired = (true))]
        public string TopLevelSite
        {
            get;
            set;
        }

        /// <summary>
        /// Indicates if the cookie has any ancestors that are cross-site to the topLevelSite.
        /// </summary>
        [DataMember(Name = ("hasCrossSiteAncestor"), IsRequired = (true))]
        public bool HasCrossSiteAncestor
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Cookie object
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class Cookie : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Cookie name.
        /// </summary>
        [DataMember(Name = ("name"), IsRequired = (true))]
        public string Name
        {
            get;
            set;
        }

        /// <summary>
        /// Cookie value.
        /// </summary>
        [DataMember(Name = ("value"), IsRequired = (true))]
        public string Value
        {
            get;
            set;
        }

        /// <summary>
        /// Cookie domain.
        /// </summary>
        [DataMember(Name = ("domain"), IsRequired = (true))]
        public string Domain
        {
            get;
            set;
        }

        /// <summary>
        /// Cookie path.
        /// </summary>
        [DataMember(Name = ("path"), IsRequired = (true))]
        public string Path
        {
            get;
            set;
        }

        /// <summary>
        /// Cookie expiration date as the number of seconds since the UNIX epoch.
        /// </summary>
        [DataMember(Name = ("expires"), IsRequired = (true))]
        public double Expires
        {
            get;
            set;
        }

        /// <summary>
        /// Cookie size.
        /// </summary>
        [DataMember(Name = ("size"), IsRequired = (true))]
        public int Size
        {
            get;
            set;
        }

        /// <summary>
        /// True if cookie is http-only.
        /// </summary>
        [DataMember(Name = ("httpOnly"), IsRequired = (true))]
        public bool HttpOnly
        {
            get;
            set;
        }

        /// <summary>
        /// True if cookie is secure.
        /// </summary>
        [DataMember(Name = ("secure"), IsRequired = (true))]
        public bool Secure
        {
            get;
            set;
        }

        /// <summary>
        /// True in case of session cookie.
        /// </summary>
        [DataMember(Name = ("session"), IsRequired = (true))]
        public bool Session
        {
            get;
            set;
        }

        /// <summary>
        /// Cookie SameSite type.
        /// </summary>
        public CefSharp.DevTools.Network.CookieSameSite? SameSite
        {
            get
            {
                return (CefSharp.DevTools.Network.CookieSameSite? )(StringToEnum(typeof(CefSharp.DevTools.Network.CookieSameSite? ), sameSite));
            }

            set
            {
                this.sameSite = (EnumToString(value));
            }
        }

        /// <summary>
        /// Cookie SameSite type.
        /// </summary>
        [DataMember(Name = ("sameSite"), IsRequired = (false))]
        internal string sameSite
        {
            get;
            set;
        }

        /// <summary>
        /// Cookie Priority
        /// </summary>
        public CefSharp.DevTools.Network.CookiePriority Priority
        {
            get
            {
                return (CefSharp.DevTools.Network.CookiePriority)(StringToEnum(typeof(CefSharp.DevTools.Network.CookiePriority), priority));
            }

            set
            {
                this.priority = (EnumToString(value));
            }
        }

        /// <summary>
        /// Cookie Priority
        /// </summary>
        [DataMember(Name = ("priority"), IsRequired = (true))]
        internal string priority
        {
            get;
            set;
        }

        /// <summary>
        /// True if cookie is SameParty.
        /// </summary>
        [DataMember(Name = ("sameParty"), IsRequired = (true))]
        public bool SameParty
        {
            get;
            set;
        }

        /// <summary>
        /// Cookie source scheme type.
        /// </summary>
        public CefSharp.DevTools.Network.CookieSourceScheme SourceScheme
        {
            get
            {
                return (CefSharp.DevTools.Network.CookieSourceScheme)(StringToEnum(typeof(CefSharp.DevTools.Network.CookieSourceScheme), sourceScheme));
            }

            set
            {
                this.sourceScheme = (EnumToString(value));
            }
        }

        /// <summary>
        /// Cookie source scheme type.
        /// </summary>
        [DataMember(Name = ("sourceScheme"), IsRequired = (true))]
        internal string sourceScheme
        {
            get;
            set;
        }

        /// <summary>
        /// Cookie source port. Valid values are {-1, [1, 65535]}, -1 indicates an unspecified port.
        /// An unspecified port value allows protocol clients to emulate legacy cookie scope for the port.
        /// This is a temporary ability and it will be removed in the future.
        /// </summary>
        [DataMember(Name = ("sourcePort"), IsRequired = (true))]
        public int SourcePort
        {
            get;
            set;
        }

        /// <summary>
        /// Cookie partition key.
        /// </summary>
        [DataMember(Name = ("partitionKey"), IsRequired = (false))]
        public CefSharp.DevTools.Network.CookiePartitionKey PartitionKey
        {
            get;
            set;
        }

        /// <summary>
        /// True if cookie partition key is opaque.
        /// </summary>
        [DataMember(Name = ("partitionKeyOpaque"), IsRequired = (false))]
        public bool? PartitionKeyOpaque
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Types of reasons why a cookie may not be stored from a response.
    /// </summary>
    public enum SetCookieBlockedReason
    {
        /// <summary>
        /// SecureOnly
        /// </summary>
        [EnumMember(Value = ("SecureOnly"))]
        SecureOnly,
        /// <summary>
        /// SameSiteStrict
        /// </summary>
        [EnumMember(Value = ("SameSiteStrict"))]
        SameSiteStrict,
        /// <summary>
        /// SameSiteLax
        /// </summary>
        [EnumMember(Value = ("SameSiteLax"))]
        SameSiteLax,
        /// <summary>
        /// SameSiteUnspecifiedTreatedAsLax
        /// </summary>
        [EnumMember(Value = ("SameSiteUnspecifiedTreatedAsLax"))]
        SameSiteUnspecifiedTreatedAsLax,
        /// <summary>
        /// SameSiteNoneInsecure
        /// </summary>
        [EnumMember(Value = ("SameSiteNoneInsecure"))]
        SameSiteNoneInsecure,
        /// <summary>
        /// UserPreferences
        /// </summary>
        [EnumMember(Value = ("UserPreferences"))]
        UserPreferences,
        /// <summary>
        /// ThirdPartyPhaseout
        /// </summary>
        [EnumMember(Value = ("ThirdPartyPhaseout"))]
        ThirdPartyPhaseout,
        /// <summary>
        /// ThirdPartyBlockedInFirstPartySet
        /// </summary>
        [EnumMember(Value = ("ThirdPartyBlockedInFirstPartySet"))]
        ThirdPartyBlockedInFirstPartySet,
        /// <summary>
        /// SyntaxError
        /// </summary>
        [EnumMember(Value = ("SyntaxError"))]
        SyntaxError,
        /// <summary>
        /// SchemeNotSupported
        /// </summary>
        [EnumMember(Value = ("SchemeNotSupported"))]
        SchemeNotSupported,
        /// <summary>
        /// OverwriteSecure
        /// </summary>
        [EnumMember(Value = ("OverwriteSecure"))]
        OverwriteSecure,
        /// <summary>
        /// InvalidDomain
        /// </summary>
        [EnumMember(Value = ("InvalidDomain"))]
        InvalidDomain,
        /// <summary>
        /// InvalidPrefix
        /// </summary>
        [EnumMember(Value = ("InvalidPrefix"))]
        InvalidPrefix,
        /// <summary>
        /// UnknownError
        /// </summary>
        [EnumMember(Value = ("UnknownError"))]
        UnknownError,
        /// <summary>
        /// SchemefulSameSiteStrict
        /// </summary>
        [EnumMember(Value = ("SchemefulSameSiteStrict"))]
        SchemefulSameSiteStrict,
        /// <summary>
        /// SchemefulSameSiteLax
        /// </summary>
        [EnumMember(Value = ("SchemefulSameSiteLax"))]
        SchemefulSameSiteLax,
        /// <summary>
        /// SchemefulSameSiteUnspecifiedTreatedAsLax
        /// </summary>
        [EnumMember(Value = ("SchemefulSameSiteUnspecifiedTreatedAsLax"))]
        SchemefulSameSiteUnspecifiedTreatedAsLax,
        /// <summary>
        /// SamePartyFromCrossPartyContext
        /// </summary>
        [EnumMember(Value = ("SamePartyFromCrossPartyContext"))]
        SamePartyFromCrossPartyContext,
        /// <summary>
        /// SamePartyConflictsWithOtherAttributes
        /// </summary>
        [EnumMember(Value = ("SamePartyConflictsWithOtherAttributes"))]
        SamePartyConflictsWithOtherAttributes,
        /// <summary>
        /// NameValuePairExceedsMaxSize
        /// </summary>
        [EnumMember(Value = ("NameValuePairExceedsMaxSize"))]
        NameValuePairExceedsMaxSize,
        /// <summary>
        /// DisallowedCharacter
        /// </summary>
        [EnumMember(Value = ("DisallowedCharacter"))]
        DisallowedCharacter,
        /// <summary>
        /// NoCookieContent
        /// </summary>
        [EnumMember(Value = ("NoCookieContent"))]
        NoCookieContent
    }

    /// <summary>
    /// Types of reasons why a cookie may not be sent with a request.
    /// </summary>
    public enum CookieBlockedReason
    {
        /// <summary>
        /// SecureOnly
        /// </summary>
        [EnumMember(Value = ("SecureOnly"))]
        SecureOnly,
        /// <summary>
        /// NotOnPath
        /// </summary>
        [EnumMember(Value = ("NotOnPath"))]
        NotOnPath,
        /// <summary>
        /// DomainMismatch
        /// </summary>
        [EnumMember(Value = ("DomainMismatch"))]
        DomainMismatch,
        /// <summary>
        /// SameSiteStrict
        /// </summary>
        [EnumMember(Value = ("SameSiteStrict"))]
        SameSiteStrict,
        /// <summary>
        /// SameSiteLax
        /// </summary>
        [EnumMember(Value = ("SameSiteLax"))]
        SameSiteLax,
        /// <summary>
        /// SameSiteUnspecifiedTreatedAsLax
        /// </summary>
        [EnumMember(Value = ("SameSiteUnspecifiedTreatedAsLax"))]
        SameSiteUnspecifiedTreatedAsLax,
        /// <summary>
        /// SameSiteNoneInsecure
        /// </summary>
        [EnumMember(Value = ("SameSiteNoneInsecure"))]
        SameSiteNoneInsecure,
        /// <summary>
        /// UserPreferences
        /// </summary>
        [EnumMember(Value = ("UserPreferences"))]
        UserPreferences,
        /// <summary>
        /// ThirdPartyPhaseout
        /// </summary>
        [EnumMember(Value = ("ThirdPartyPhaseout"))]
        ThirdPartyPhaseout,
        /// <summary>
        /// ThirdPartyBlockedInFirstPartySet
        /// </summary>
        [EnumMember(Value = ("ThirdPartyBlockedInFirstPartySet"))]
        ThirdPartyBlockedInFirstPartySet,
        /// <summary>
        /// UnknownError
        /// </summary>
        [EnumMember(Value = ("UnknownError"))]
        UnknownError,
        /// <summary>
        /// SchemefulSameSiteStrict
        /// </summary>
        [EnumMember(Value = ("SchemefulSameSiteStrict"))]
        SchemefulSameSiteStrict,
        /// <summary>
        /// SchemefulSameSiteLax
        /// </summary>
        [EnumMember(Value = ("SchemefulSameSiteLax"))]
        SchemefulSameSiteLax,
        /// <summary>
        /// SchemefulSameSiteUnspecifiedTreatedAsLax
        /// </summary>
        [EnumMember(Value = ("SchemefulSameSiteUnspecifiedTreatedAsLax"))]
        SchemefulSameSiteUnspecifiedTreatedAsLax,
        /// <summary>
        /// SamePartyFromCrossPartyContext
        /// </summary>
        [EnumMember(Value = ("SamePartyFromCrossPartyContext"))]
        SamePartyFromCrossPartyContext,
        /// <summary>
        /// NameValuePairExceedsMaxSize
        /// </summary>
        [EnumMember(Value = ("NameValuePairExceedsMaxSize"))]
        NameValuePairExceedsMaxSize
    }

    /// <summary>
    /// Types of reasons why a cookie should have been blocked by 3PCD but is exempted for the request.
    /// </summary>
    public enum CookieExemptionReason
    {
        /// <summary>
        /// None
        /// </summary>
        [EnumMember(Value = ("None"))]
        None,
        /// <summary>
        /// UserSetting
        /// </summary>
        [EnumMember(Value = ("UserSetting"))]
        UserSetting,
        /// <summary>
        /// TPCDMetadata
        /// </summary>
        [EnumMember(Value = ("TPCDMetadata"))]
        TPCDMetadata,
        /// <summary>
        /// TPCDDeprecationTrial
        /// </summary>
        [EnumMember(Value = ("TPCDDeprecationTrial"))]
        TPCDDeprecationTrial,
        /// <summary>
        /// TPCDHeuristics
        /// </summary>
        [EnumMember(Value = ("TPCDHeuristics"))]
        TPCDHeuristics,
        /// <summary>
        /// EnterprisePolicy
        /// </summary>
        [EnumMember(Value = ("EnterprisePolicy"))]
        EnterprisePolicy,
        /// <summary>
        /// StorageAccess
        /// </summary>
        [EnumMember(Value = ("StorageAccess"))]
        StorageAccess,
        /// <summary>
        /// TopLevelStorageAccess
        /// </summary>
        [EnumMember(Value = ("TopLevelStorageAccess"))]
        TopLevelStorageAccess,
        /// <summary>
        /// CorsOptIn
        /// </summary>
        [EnumMember(Value = ("CorsOptIn"))]
        CorsOptIn,
        /// <summary>
        /// Scheme
        /// </summary>
        [EnumMember(Value = ("Scheme"))]
        Scheme
    }

    /// <summary>
    /// A cookie which was not stored from a response with the corresponding reason.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class BlockedSetCookieWithReason : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The reason(s) this cookie was blocked.
        /// </summary>
        public CefSharp.DevTools.Network.SetCookieBlockedReason[] BlockedReasons
        {
            get
            {
                return (CefSharp.DevTools.Network.SetCookieBlockedReason[])(StringToEnum(typeof(CefSharp.DevTools.Network.SetCookieBlockedReason[]), blockedReasons));
            }

            set
            {
                this.blockedReasons = (EnumToString(value));
            }
        }

        /// <summary>
        /// The reason(s) this cookie was blocked.
        /// </summary>
        [DataMember(Name = ("blockedReasons"), IsRequired = (true))]
        internal string blockedReasons
        {
            get;
            set;
        }

        /// <summary>
        /// The string representing this individual cookie as it would appear in the header.
        /// This is not the entire &quot;cookie&quot; or &quot;set-cookie&quot; header which could have multiple cookies.
        /// </summary>
        [DataMember(Name = ("cookieLine"), IsRequired = (true))]
        public string CookieLine
        {
            get;
            set;
        }

        /// <summary>
        /// The cookie object which represents the cookie which was not stored. It is optional because
        /// sometimes complete cookie information is not available, such as in the case of parsing
        /// errors.
        /// </summary>
        [DataMember(Name = ("cookie"), IsRequired = (false))]
        public CefSharp.DevTools.Network.Cookie Cookie
        {
            get;
            set;
        }
    }

    /// <summary>
    /// A cookie should have been blocked by 3PCD but is exempted and stored from a response with the
    /// corresponding reason. A cookie could only have at most one exemption reason.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class ExemptedSetCookieWithReason : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The reason the cookie was exempted.
        /// </summary>
        public CefSharp.DevTools.Network.CookieExemptionReason ExemptionReason
        {
            get
            {
                return (CefSharp.DevTools.Network.CookieExemptionReason)(StringToEnum(typeof(CefSharp.DevTools.Network.CookieExemptionReason), exemptionReason));
            }

            set
            {
                this.exemptionReason = (EnumToString(value));
            }
        }

        /// <summary>
        /// The reason the cookie was exempted.
        /// </summary>
        [DataMember(Name = ("exemptionReason"), IsRequired = (true))]
        internal string exemptionReason
        {
            get;
            set;
        }

        /// <summary>
        /// The string representing this individual cookie as it would appear in the header.
        /// </summary>
        [DataMember(Name = ("cookieLine"), IsRequired = (true))]
        public string CookieLine
        {
            get;
            set;
        }

        /// <summary>
        /// The cookie object representing the cookie.
        /// </summary>
        [DataMember(Name = ("cookie"), IsRequired = (true))]
        public CefSharp.DevTools.Network.Cookie Cookie
        {
            get;
            set;
        }
    }

    /// <summary>
    /// A cookie associated with the request which may or may not be sent with it.
    /// Includes the cookies itself and reasons for blocking or exemption.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class AssociatedCookie : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The cookie object representing the cookie which was not sent.
        /// </summary>
        [DataMember(Name = ("cookie"), IsRequired = (true))]
        public CefSharp.DevTools.Network.Cookie Cookie
        {
            get;
            set;
        }

        /// <summary>
        /// The reason(s) the cookie was blocked. If empty means the cookie is included.
        /// </summary>
        public CefSharp.DevTools.Network.CookieBlockedReason[] BlockedReasons
        {
            get
            {
                return (CefSharp.DevTools.Network.CookieBlockedReason[])(StringToEnum(typeof(CefSharp.DevTools.Network.CookieBlockedReason[]), blockedReasons));
            }

            set
            {
                this.blockedReasons = (EnumToString(value));
            }
        }

        /// <summary>
        /// The reason(s) the cookie was blocked. If empty means the cookie is included.
        /// </summary>
        [DataMember(Name = ("blockedReasons"), IsRequired = (true))]
        internal string blockedReasons
        {
            get;
            set;
        }

        /// <summary>
        /// The reason the cookie should have been blocked by 3PCD but is exempted. A cookie could
        /// only have at most one exemption reason.
        /// </summary>
        public CefSharp.DevTools.Network.CookieExemptionReason? ExemptionReason
        {
            get
            {
                return (CefSharp.DevTools.Network.CookieExemptionReason? )(StringToEnum(typeof(CefSharp.DevTools.Network.CookieExemptionReason? ), exemptionReason));
            }

            set
            {
                this.exemptionReason = (EnumToString(value));
            }
        }

        /// <summary>
        /// The reason the cookie should have been blocked by 3PCD but is exempted. A cookie could
        /// only have at most one exemption reason.
        /// </summary>
        [DataMember(Name = ("exemptionReason"), IsRequired = (false))]
        internal string exemptionReason
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Cookie parameter object
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class CookieParam : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Cookie name.
        /// </summary>
        [DataMember(Name = ("name"), IsRequired = (true))]
        public string Name
        {
            get;
            set;
        }

        /// <summary>
        /// Cookie value.
        /// </summary>
        [DataMember(Name = ("value"), IsRequired = (true))]
        public string Value
        {
            get;
            set;
        }

        /// <summary>
        /// The request-URI to associate with the setting of the cookie. This value can affect the
        /// default domain, path, source port, and source scheme values of the created cookie.
        /// </summary>
        [DataMember(Name = ("url"), IsRequired = (false))]
        public string Url
        {
            get;
            set;
        }

        /// <summary>
        /// Cookie domain.
        /// </summary>
        [DataMember(Name = ("domain"), IsRequired = (false))]
        public string Domain
        {
            get;
            set;
        }

        /// <summary>
        /// Cookie path.
        /// </summary>
        [DataMember(Name = ("path"), IsRequired = (false))]
        public string Path
        {
            get;
            set;
        }

        /// <summary>
        /// True if cookie is secure.
        /// </summary>
        [DataMember(Name = ("secure"), IsRequired = (false))]
        public bool? Secure
        {
            get;
            set;
        }

        /// <summary>
        /// True if cookie is http-only.
        /// </summary>
        [DataMember(Name = ("httpOnly"), IsRequired = (false))]
        public bool? HttpOnly
        {
            get;
            set;
        }

        /// <summary>
        /// Cookie SameSite type.
        /// </summary>
        public CefSharp.DevTools.Network.CookieSameSite? SameSite
        {
            get
            {
                return (CefSharp.DevTools.Network.CookieSameSite? )(StringToEnum(typeof(CefSharp.DevTools.Network.CookieSameSite? ), sameSite));
            }

            set
            {
                this.sameSite = (EnumToString(value));
            }
        }

        /// <summary>
        /// Cookie SameSite type.
        /// </summary>
        [DataMember(Name = ("sameSite"), IsRequired = (false))]
        internal string sameSite
        {
            get;
            set;
        }

        /// <summary>
        /// Cookie expiration date, session cookie if not set
        /// </summary>
        [DataMember(Name = ("expires"), IsRequired = (false))]
        public double? Expires
        {
            get;
            set;
        }

        /// <summary>
        /// Cookie Priority.
        /// </summary>
        public CefSharp.DevTools.Network.CookiePriority? Priority
        {
            get
            {
                return (CefSharp.DevTools.Network.CookiePriority? )(StringToEnum(typeof(CefSharp.DevTools.Network.CookiePriority? ), priority));
            }

            set
            {
                this.priority = (EnumToString(value));
            }
        }

        /// <summary>
        /// Cookie Priority.
        /// </summary>
        [DataMember(Name = ("priority"), IsRequired = (false))]
        internal string priority
        {
            get;
            set;
        }

        /// <summary>
        /// True if cookie is SameParty.
        /// </summary>
        [DataMember(Name = ("sameParty"), IsRequired = (false))]
        public bool? SameParty
        {
            get;
            set;
        }

        /// <summary>
        /// Cookie source scheme type.
        /// </summary>
        public CefSharp.DevTools.Network.CookieSourceScheme? SourceScheme
        {
            get
            {
                return (CefSharp.DevTools.Network.CookieSourceScheme? )(StringToEnum(typeof(CefSharp.DevTools.Network.CookieSourceScheme? ), sourceScheme));
            }

            set
            {
                this.sourceScheme = (EnumToString(value));
            }
        }

        /// <summary>
        /// Cookie source scheme type.
        /// </summary>
        [DataMember(Name = ("sourceScheme"), IsRequired = (false))]
        internal string sourceScheme
        {
            get;
            set;
        }

        /// <summary>
        /// Cookie source port. Valid values are {-1, [1, 65535]}, -1 indicates an unspecified port.
        /// An unspecified port value allows protocol clients to emulate legacy cookie scope for the port.
        /// This is a temporary ability and it will be removed in the future.
        /// </summary>
        [DataMember(Name = ("sourcePort"), IsRequired = (false))]
        public int? SourcePort
        {
            get;
            set;
        }

        /// <summary>
        /// Cookie partition key. If not set, the cookie will be set as not partitioned.
        /// </summary>
        [DataMember(Name = ("partitionKey"), IsRequired = (false))]
        public CefSharp.DevTools.Network.CookiePartitionKey PartitionKey
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Source of the authentication challenge.
    /// </summary>
    public enum AuthChallengeSource
    {
        /// <summary>
        /// Server
        /// </summary>
        [EnumMember(Value = ("Server"))]
        Server,
        /// <summary>
        /// Proxy
        /// </summary>
        [EnumMember(Value = ("Proxy"))]
        Proxy
    }

    /// <summary>
    /// Authorization challenge for HTTP status code 401 or 407.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class AuthChallenge : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Source of the authentication challenge.
        /// </summary>
        public CefSharp.DevTools.Network.AuthChallengeSource? Source
        {
            get
            {
                return (CefSharp.DevTools.Network.AuthChallengeSource? )(StringToEnum(typeof(CefSharp.DevTools.Network.AuthChallengeSource? ), source));
            }

            set
            {
                this.source = (EnumToString(value));
            }
        }

        /// <summary>
        /// Source of the authentication challenge.
        /// </summary>
        [DataMember(Name = ("source"), IsRequired = (false))]
        internal string source
        {
            get;
            set;
        }

        /// <summary>
        /// Origin of the challenger.
        /// </summary>
        [DataMember(Name = ("origin"), IsRequired = (true))]
        public string Origin
        {
            get;
            set;
        }

        /// <summary>
        /// The authentication scheme used, such as basic or digest
        /// </summary>
        [DataMember(Name = ("scheme"), IsRequired = (true))]
        public string Scheme
        {
            get;
            set;
        }

        /// <summary>
        /// The realm of the challenge. May be empty.
        /// </summary>
        [DataMember(Name = ("realm"), IsRequired = (true))]
        public string Realm
        {
            get;
            set;
        }
    }

    /// <summary>
    /// The decision on what to do in response to the authorization challenge.  Default means
    /// deferring to the default behavior of the net stack, which will likely either the Cancel
    /// authentication or display a popup dialog box.
    /// </summary>
    public enum AuthChallengeResponseResponse
    {
        /// <summary>
        /// Default
        /// </summary>
        [EnumMember(Value = ("Default"))]
        Default,
        /// <summary>
        /// CancelAuth
        /// </summary>
        [EnumMember(Value = ("CancelAuth"))]
        CancelAuth,
        /// <summary>
        /// ProvideCredentials
        /// </summary>
        [EnumMember(Value = ("ProvideCredentials"))]
        ProvideCredentials
    }

    /// <summary>
    /// Response to an AuthChallenge.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class AuthChallengeResponse : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The decision on what to do in response to the authorization challenge.  Default means
        /// deferring to the default behavior of the net stack, which will likely either the Cancel
        /// authentication or display a popup dialog box.
        /// </summary>
        public CefSharp.DevTools.Network.AuthChallengeResponseResponse Response
        {
            get
            {
                return (CefSharp.DevTools.Network.AuthChallengeResponseResponse)(StringToEnum(typeof(CefSharp.DevTools.Network.AuthChallengeResponseResponse), response));
            }

            set
            {
                this.response = (EnumToString(value));
            }
        }

        /// <summary>
        /// The decision on what to do in response to the authorization challenge.  Default means
        /// deferring to the default behavior of the net stack, which will likely either the Cancel
        /// authentication or display a popup dialog box.
        /// </summary>
        [DataMember(Name = ("response"), IsRequired = (true))]
        internal string response
        {
            get;
            set;
        }

        /// <summary>
        /// The username to provide, possibly empty. Should only be set if response is
        /// ProvideCredentials.
        /// </summary>
        [DataMember(Name = ("username"), IsRequired = (false))]
        public string Username
        {
            get;
            set;
        }

        /// <summary>
        /// The password to provide, possibly empty. Should only be set if response is
        /// ProvideCredentials.
        /// </summary>
        [DataMember(Name = ("password"), IsRequired = (false))]
        public string Password
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Stages of the interception to begin intercepting. Request will intercept before the request is
    /// sent. Response will intercept after the response is received.
    /// </summary>
    public enum InterceptionStage
    {
        /// <summary>
        /// Request
        /// </summary>
        [EnumMember(Value = ("Request"))]
        Request,
        /// <summary>
        /// HeadersReceived
        /// </summary>
        [EnumMember(Value = ("HeadersReceived"))]
        HeadersReceived
    }

    /// <summary>
    /// Request pattern for interception.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class RequestPattern : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Wildcards (`&apos;*&apos;` -&gt; zero or more, `&apos;?&apos;` -&gt; exactly one) are allowed. Escape character is
        /// backslash. Omitting is equivalent to `&quot;*&quot;`.
        /// </summary>
        [DataMember(Name = ("urlPattern"), IsRequired = (false))]
        public string UrlPattern
        {
            get;
            set;
        }

        /// <summary>
        /// If set, only requests for matching resource types will be intercepted.
        /// </summary>
        public CefSharp.DevTools.Network.ResourceType? ResourceType
        {
            get
            {
                return (CefSharp.DevTools.Network.ResourceType? )(StringToEnum(typeof(CefSharp.DevTools.Network.ResourceType? ), resourceType));
            }

            set
            {
                this.resourceType = (EnumToString(value));
            }
        }

        /// <summary>
        /// If set, only requests for matching resource types will be intercepted.
        /// </summary>
        [DataMember(Name = ("resourceType"), IsRequired = (false))]
        internal string resourceType
        {
            get;
            set;
        }

        /// <summary>
        /// Stage at which to begin intercepting requests. Default is Request.
        /// </summary>
        public CefSharp.DevTools.Network.InterceptionStage? InterceptionStage
        {
            get
            {
                return (CefSharp.DevTools.Network.InterceptionStage? )(StringToEnum(typeof(CefSharp.DevTools.Network.InterceptionStage? ), interceptionStage));
            }

            set
            {
                this.interceptionStage = (EnumToString(value));
            }
        }

        /// <summary>
        /// Stage at which to begin intercepting requests. Default is Request.
        /// </summary>
        [DataMember(Name = ("interceptionStage"), IsRequired = (false))]
        internal string interceptionStage
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Information about a signed exchange signature.
    /// https://wicg.github.io/webpackage/draft-yasskin-httpbis-origin-signed-exchanges-impl.html#rfc.section.3.1
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class SignedExchangeSignature : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Signed exchange signature label.
        /// </summary>
        [DataMember(Name = ("label"), IsRequired = (true))]
        public string Label
        {
            get;
            set;
        }

        /// <summary>
        /// The hex string of signed exchange signature.
        /// </summary>
        [DataMember(Name = ("signature"), IsRequired = (true))]
        public string Signature
        {
            get;
            set;
        }

        /// <summary>
        /// Signed exchange signature integrity.
        /// </summary>
        [DataMember(Name = ("integrity"), IsRequired = (true))]
        public string Integrity
        {
            get;
            set;
        }

        /// <summary>
        /// Signed exchange signature cert Url.
        /// </summary>
        [DataMember(Name = ("certUrl"), IsRequired = (false))]
        public string CertUrl
        {
            get;
            set;
        }

        /// <summary>
        /// The hex string of signed exchange signature cert sha256.
        /// </summary>
        [DataMember(Name = ("certSha256"), IsRequired = (false))]
        public string CertSha256
        {
            get;
            set;
        }

        /// <summary>
        /// Signed exchange signature validity Url.
        /// </summary>
        [DataMember(Name = ("validityUrl"), IsRequired = (true))]
        public string ValidityUrl
        {
            get;
            set;
        }

        /// <summary>
        /// Signed exchange signature date.
        /// </summary>
        [DataMember(Name = ("date"), IsRequired = (true))]
        public int Date
        {
            get;
            set;
        }

        /// <summary>
        /// Signed exchange signature expires.
        /// </summary>
        [DataMember(Name = ("expires"), IsRequired = (true))]
        public int Expires
        {
            get;
            set;
        }

        /// <summary>
        /// The encoded certificates.
        /// </summary>
        [DataMember(Name = ("certificates"), IsRequired = (false))]
        public string[] Certificates
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Information about a signed exchange header.
    /// https://wicg.github.io/webpackage/draft-yasskin-httpbis-origin-signed-exchanges-impl.html#cbor-representation
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class SignedExchangeHeader : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Signed exchange request URL.
        /// </summary>
        [DataMember(Name = ("requestUrl"), IsRequired = (true))]
        public string RequestUrl
        {
            get;
            set;
        }

        /// <summary>
        /// Signed exchange response code.
        /// </summary>
        [DataMember(Name = ("responseCode"), IsRequired = (true))]
        public int ResponseCode
        {
            get;
            set;
        }

        /// <summary>
        /// Signed exchange response headers.
        /// </summary>
        [DataMember(Name = ("responseHeaders"), IsRequired = (true))]
        public CefSharp.DevTools.Network.Headers ResponseHeaders
        {
            get;
            set;
        }

        /// <summary>
        /// Signed exchange response signature.
        /// </summary>
        [DataMember(Name = ("signatures"), IsRequired = (true))]
        public System.Collections.Generic.IList<CefSharp.DevTools.Network.SignedExchangeSignature> Signatures
        {
            get;
            set;
        }

        /// <summary>
        /// Signed exchange header integrity hash in the form of `sha256-&lt;base64-hash-value&gt;`.
        /// </summary>
        [DataMember(Name = ("headerIntegrity"), IsRequired = (true))]
        public string HeaderIntegrity
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Field type for a signed exchange related error.
    /// </summary>
    public enum SignedExchangeErrorField
    {
        /// <summary>
        /// signatureSig
        /// </summary>
        [EnumMember(Value = ("signatureSig"))]
        SignatureSig,
        /// <summary>
        /// signatureIntegrity
        /// </summary>
        [EnumMember(Value = ("signatureIntegrity"))]
        SignatureIntegrity,
        /// <summary>
        /// signatureCertUrl
        /// </summary>
        [EnumMember(Value = ("signatureCertUrl"))]
        SignatureCertUrl,
        /// <summary>
        /// signatureCertSha256
        /// </summary>
        [EnumMember(Value = ("signatureCertSha256"))]
        SignatureCertSha256,
        /// <summary>
        /// signatureValidityUrl
        /// </summary>
        [EnumMember(Value = ("signatureValidityUrl"))]
        SignatureValidityUrl,
        /// <summary>
        /// signatureTimestamps
        /// </summary>
        [EnumMember(Value = ("signatureTimestamps"))]
        SignatureTimestamps
    }

    /// <summary>
    /// Information about a signed exchange response.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class SignedExchangeError : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Error message.
        /// </summary>
        [DataMember(Name = ("message"), IsRequired = (true))]
        public string Message
        {
            get;
            set;
        }

        /// <summary>
        /// The index of the signature which caused the error.
        /// </summary>
        [DataMember(Name = ("signatureIndex"), IsRequired = (false))]
        public int? SignatureIndex
        {
            get;
            set;
        }

        /// <summary>
        /// The field which caused the error.
        /// </summary>
        public CefSharp.DevTools.Network.SignedExchangeErrorField? ErrorField
        {
            get
            {
                return (CefSharp.DevTools.Network.SignedExchangeErrorField? )(StringToEnum(typeof(CefSharp.DevTools.Network.SignedExchangeErrorField? ), errorField));
            }

            set
            {
                this.errorField = (EnumToString(value));
            }
        }

        /// <summary>
        /// The field which caused the error.
        /// </summary>
        [DataMember(Name = ("errorField"), IsRequired = (false))]
        internal string errorField
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Information about a signed exchange response.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class SignedExchangeInfo : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The outer response of signed HTTP exchange which was received from network.
        /// </summary>
        [DataMember(Name = ("outerResponse"), IsRequired = (true))]
        public CefSharp.DevTools.Network.Response OuterResponse
        {
            get;
            set;
        }

        /// <summary>
        /// Information about the signed exchange header.
        /// </summary>
        [DataMember(Name = ("header"), IsRequired = (false))]
        public CefSharp.DevTools.Network.SignedExchangeHeader Header
        {
            get;
            set;
        }

        /// <summary>
        /// Security details for the signed exchange header.
        /// </summary>
        [DataMember(Name = ("securityDetails"), IsRequired = (false))]
        public CefSharp.DevTools.Network.SecurityDetails SecurityDetails
        {
            get;
            set;
        }

        /// <summary>
        /// Errors occurred while handling the signed exchange.
        /// </summary>
        [DataMember(Name = ("errors"), IsRequired = (false))]
        public System.Collections.Generic.IList<CefSharp.DevTools.Network.SignedExchangeError> Errors
        {
            get;
            set;
        }
    }

    /// <summary>
    /// List of content encodings supported by the backend.
    /// </summary>
    public enum ContentEncoding
    {
        /// <summary>
        /// deflate
        /// </summary>
        [EnumMember(Value = ("deflate"))]
        Deflate,
        /// <summary>
        /// gzip
        /// </summary>
        [EnumMember(Value = ("gzip"))]
        Gzip,
        /// <summary>
        /// br
        /// </summary>
        [EnumMember(Value = ("br"))]
        Br,
        /// <summary>
        /// zstd
        /// </summary>
        [EnumMember(Value = ("zstd"))]
        Zstd
    }

    /// <summary>
    /// PrivateNetworkRequestPolicy
    /// </summary>
    public enum PrivateNetworkRequestPolicy
    {
        /// <summary>
        /// Allow
        /// </summary>
        [EnumMember(Value = ("Allow"))]
        Allow,
        /// <summary>
        /// BlockFromInsecureToMorePrivate
        /// </summary>
        [EnumMember(Value = ("BlockFromInsecureToMorePrivate"))]
        BlockFromInsecureToMorePrivate,
        /// <summary>
        /// WarnFromInsecureToMorePrivate
        /// </summary>
        [EnumMember(Value = ("WarnFromInsecureToMorePrivate"))]
        WarnFromInsecureToMorePrivate,
        /// <summary>
        /// PreflightBlock
        /// </summary>
        [EnumMember(Value = ("PreflightBlock"))]
        PreflightBlock,
        /// <summary>
        /// PreflightWarn
        /// </summary>
        [EnumMember(Value = ("PreflightWarn"))]
        PreflightWarn
    }

    /// <summary>
    /// IPAddressSpace
    /// </summary>
    public enum IPAddressSpace
    {
        /// <summary>
        /// Local
        /// </summary>
        [EnumMember(Value = ("Local"))]
        Local,
        /// <summary>
        /// Private
        /// </summary>
        [EnumMember(Value = ("Private"))]
        Private,
        /// <summary>
        /// Public
        /// </summary>
        [EnumMember(Value = ("Public"))]
        Public,
        /// <summary>
        /// Unknown
        /// </summary>
        [EnumMember(Value = ("Unknown"))]
        Unknown
    }

    /// <summary>
    /// ConnectTiming
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class ConnectTiming : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Timing&apos;s requestTime is a baseline in seconds, while the other numbers are ticks in
        /// milliseconds relatively to this requestTime. Matches ResourceTiming&apos;s requestTime for
        /// the same request (but not for redirected requests).
        /// </summary>
        [DataMember(Name = ("requestTime"), IsRequired = (true))]
        public double RequestTime
        {
            get;
            set;
        }
    }

    /// <summary>
    /// ClientSecurityState
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class ClientSecurityState : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// InitiatorIsSecureContext
        /// </summary>
        [DataMember(Name = ("initiatorIsSecureContext"), IsRequired = (true))]
        public bool InitiatorIsSecureContext
        {
            get;
            set;
        }

        /// <summary>
        /// InitiatorIPAddressSpace
        /// </summary>
        public CefSharp.DevTools.Network.IPAddressSpace InitiatorIPAddressSpace
        {
            get
            {
                return (CefSharp.DevTools.Network.IPAddressSpace)(StringToEnum(typeof(CefSharp.DevTools.Network.IPAddressSpace), initiatorIPAddressSpace));
            }

            set
            {
                this.initiatorIPAddressSpace = (EnumToString(value));
            }
        }

        /// <summary>
        /// InitiatorIPAddressSpace
        /// </summary>
        [DataMember(Name = ("initiatorIPAddressSpace"), IsRequired = (true))]
        internal string initiatorIPAddressSpace
        {
            get;
            set;
        }

        /// <summary>
        /// PrivateNetworkRequestPolicy
        /// </summary>
        public CefSharp.DevTools.Network.PrivateNetworkRequestPolicy PrivateNetworkRequestPolicy
        {
            get
            {
                return (CefSharp.DevTools.Network.PrivateNetworkRequestPolicy)(StringToEnum(typeof(CefSharp.DevTools.Network.PrivateNetworkRequestPolicy), privateNetworkRequestPolicy));
            }

            set
            {
                this.privateNetworkRequestPolicy = (EnumToString(value));
            }
        }

        /// <summary>
        /// PrivateNetworkRequestPolicy
        /// </summary>
        [DataMember(Name = ("privateNetworkRequestPolicy"), IsRequired = (true))]
        internal string privateNetworkRequestPolicy
        {
            get;
            set;
        }
    }

    /// <summary>
    /// CrossOriginOpenerPolicyValue
    /// </summary>
    public enum CrossOriginOpenerPolicyValue
    {
        /// <summary>
        /// SameOrigin
        /// </summary>
        [EnumMember(Value = ("SameOrigin"))]
        SameOrigin,
        /// <summary>
        /// SameOriginAllowPopups
        /// </summary>
        [EnumMember(Value = ("SameOriginAllowPopups"))]
        SameOriginAllowPopups,
        /// <summary>
        /// RestrictProperties
        /// </summary>
        [EnumMember(Value = ("RestrictProperties"))]
        RestrictProperties,
        /// <summary>
        /// UnsafeNone
        /// </summary>
        [EnumMember(Value = ("UnsafeNone"))]
        UnsafeNone,
        /// <summary>
        /// SameOriginPlusCoep
        /// </summary>
        [EnumMember(Value = ("SameOriginPlusCoep"))]
        SameOriginPlusCoep,
        /// <summary>
        /// RestrictPropertiesPlusCoep
        /// </summary>
        [EnumMember(Value = ("RestrictPropertiesPlusCoep"))]
        RestrictPropertiesPlusCoep,
        /// <summary>
        /// NoopenerAllowPopups
        /// </summary>
        [EnumMember(Value = ("NoopenerAllowPopups"))]
        NoopenerAllowPopups
    }

    /// <summary>
    /// CrossOriginOpenerPolicyStatus
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class CrossOriginOpenerPolicyStatus : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Value
        /// </summary>
        public CefSharp.DevTools.Network.CrossOriginOpenerPolicyValue Value
        {
            get
            {
                return (CefSharp.DevTools.Network.CrossOriginOpenerPolicyValue)(StringToEnum(typeof(CefSharp.DevTools.Network.CrossOriginOpenerPolicyValue), value));
            }

            set
            {
                this.value = (EnumToString(value));
            }
        }

        /// <summary>
        /// Value
        /// </summary>
        [DataMember(Name = ("value"), IsRequired = (true))]
        internal string value
        {
            get;
            set;
        }

        /// <summary>
        /// ReportOnlyValue
        /// </summary>
        public CefSharp.DevTools.Network.CrossOriginOpenerPolicyValue ReportOnlyValue
        {
            get
            {
                return (CefSharp.DevTools.Network.CrossOriginOpenerPolicyValue)(StringToEnum(typeof(CefSharp.DevTools.Network.CrossOriginOpenerPolicyValue), reportOnlyValue));
            }

            set
            {
                this.reportOnlyValue = (EnumToString(value));
            }
        }

        /// <summary>
        /// ReportOnlyValue
        /// </summary>
        [DataMember(Name = ("reportOnlyValue"), IsRequired = (true))]
        internal string reportOnlyValue
        {
            get;
            set;
        }

        /// <summary>
        /// ReportingEndpoint
        /// </summary>
        [DataMember(Name = ("reportingEndpoint"), IsRequired = (false))]
        public string ReportingEndpoint
        {
            get;
            set;
        }

        /// <summary>
        /// ReportOnlyReportingEndpoint
        /// </summary>
        [DataMember(Name = ("reportOnlyReportingEndpoint"), IsRequired = (false))]
        public string ReportOnlyReportingEndpoint
        {
            get;
            set;
        }
    }

    /// <summary>
    /// CrossOriginEmbedderPolicyValue
    /// </summary>
    public enum CrossOriginEmbedderPolicyValue
    {
        /// <summary>
        /// None
        /// </summary>
        [EnumMember(Value = ("None"))]
        None,
        /// <summary>
        /// Credentialless
        /// </summary>
        [EnumMember(Value = ("Credentialless"))]
        Credentialless,
        /// <summary>
        /// RequireCorp
        /// </summary>
        [EnumMember(Value = ("RequireCorp"))]
        RequireCorp
    }

    /// <summary>
    /// CrossOriginEmbedderPolicyStatus
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class CrossOriginEmbedderPolicyStatus : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Value
        /// </summary>
        public CefSharp.DevTools.Network.CrossOriginEmbedderPolicyValue Value
        {
            get
            {
                return (CefSharp.DevTools.Network.CrossOriginEmbedderPolicyValue)(StringToEnum(typeof(CefSharp.DevTools.Network.CrossOriginEmbedderPolicyValue), value));
            }

            set
            {
                this.value = (EnumToString(value));
            }
        }

        /// <summary>
        /// Value
        /// </summary>
        [DataMember(Name = ("value"), IsRequired = (true))]
        internal string value
        {
            get;
            set;
        }

        /// <summary>
        /// ReportOnlyValue
        /// </summary>
        public CefSharp.DevTools.Network.CrossOriginEmbedderPolicyValue ReportOnlyValue
        {
            get
            {
                return (CefSharp.DevTools.Network.CrossOriginEmbedderPolicyValue)(StringToEnum(typeof(CefSharp.DevTools.Network.CrossOriginEmbedderPolicyValue), reportOnlyValue));
            }

            set
            {
                this.reportOnlyValue = (EnumToString(value));
            }
        }

        /// <summary>
        /// ReportOnlyValue
        /// </summary>
        [DataMember(Name = ("reportOnlyValue"), IsRequired = (true))]
        internal string reportOnlyValue
        {
            get;
            set;
        }

        /// <summary>
        /// ReportingEndpoint
        /// </summary>
        [DataMember(Name = ("reportingEndpoint"), IsRequired = (false))]
        public string ReportingEndpoint
        {
            get;
            set;
        }

        /// <summary>
        /// ReportOnlyReportingEndpoint
        /// </summary>
        [DataMember(Name = ("reportOnlyReportingEndpoint"), IsRequired = (false))]
        public string ReportOnlyReportingEndpoint
        {
            get;
            set;
        }
    }

    /// <summary>
    /// ContentSecurityPolicySource
    /// </summary>
    public enum ContentSecurityPolicySource
    {
        /// <summary>
        /// HTTP
        /// </summary>
        [EnumMember(Value = ("HTTP"))]
        HTTP,
        /// <summary>
        /// Meta
        /// </summary>
        [EnumMember(Value = ("Meta"))]
        Meta
    }

    /// <summary>
    /// ContentSecurityPolicyStatus
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class ContentSecurityPolicyStatus : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// EffectiveDirectives
        /// </summary>
        [DataMember(Name = ("effectiveDirectives"), IsRequired = (true))]
        public string EffectiveDirectives
        {
            get;
            set;
        }

        /// <summary>
        /// IsEnforced
        /// </summary>
        [DataMember(Name = ("isEnforced"), IsRequired = (true))]
        public bool IsEnforced
        {
            get;
            set;
        }

        /// <summary>
        /// Source
        /// </summary>
        public CefSharp.DevTools.Network.ContentSecurityPolicySource Source
        {
            get
            {
                return (CefSharp.DevTools.Network.ContentSecurityPolicySource)(StringToEnum(typeof(CefSharp.DevTools.Network.ContentSecurityPolicySource), source));
            }

            set
            {
                this.source = (EnumToString(value));
            }
        }

        /// <summary>
        /// Source
        /// </summary>
        [DataMember(Name = ("source"), IsRequired = (true))]
        internal string source
        {
            get;
            set;
        }
    }

    /// <summary>
    /// SecurityIsolationStatus
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class SecurityIsolationStatus : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Coop
        /// </summary>
        [DataMember(Name = ("coop"), IsRequired = (false))]
        public CefSharp.DevTools.Network.CrossOriginOpenerPolicyStatus Coop
        {
            get;
            set;
        }

        /// <summary>
        /// Coep
        /// </summary>
        [DataMember(Name = ("coep"), IsRequired = (false))]
        public CefSharp.DevTools.Network.CrossOriginEmbedderPolicyStatus Coep
        {
            get;
            set;
        }

        /// <summary>
        /// Csp
        /// </summary>
        [DataMember(Name = ("csp"), IsRequired = (false))]
        public System.Collections.Generic.IList<CefSharp.DevTools.Network.ContentSecurityPolicyStatus> Csp
        {
            get;
            set;
        }
    }

    /// <summary>
    /// The status of a Reporting API report.
    /// </summary>
    public enum ReportStatus
    {
        /// <summary>
        /// Queued
        /// </summary>
        [EnumMember(Value = ("Queued"))]
        Queued,
        /// <summary>
        /// Pending
        /// </summary>
        [EnumMember(Value = ("Pending"))]
        Pending,
        /// <summary>
        /// MarkedForRemoval
        /// </summary>
        [EnumMember(Value = ("MarkedForRemoval"))]
        MarkedForRemoval,
        /// <summary>
        /// Success
        /// </summary>
        [EnumMember(Value = ("Success"))]
        Success
    }

    /// <summary>
    /// An object representing a report generated by the Reporting API.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class ReportingApiReport : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Id
        /// </summary>
        [DataMember(Name = ("id"), IsRequired = (true))]
        public string Id
        {
            get;
            set;
        }

        /// <summary>
        /// The URL of the document that triggered the report.
        /// </summary>
        [DataMember(Name = ("initiatorUrl"), IsRequired = (true))]
        public string InitiatorUrl
        {
            get;
            set;
        }

        /// <summary>
        /// The name of the endpoint group that should be used to deliver the report.
        /// </summary>
        [DataMember(Name = ("destination"), IsRequired = (true))]
        public string Destination
        {
            get;
            set;
        }

        /// <summary>
        /// The type of the report (specifies the set of data that is contained in the report body).
        /// </summary>
        [DataMember(Name = ("type"), IsRequired = (true))]
        public string Type
        {
            get;
            set;
        }

        /// <summary>
        /// When the report was generated.
        /// </summary>
        [DataMember(Name = ("timestamp"), IsRequired = (true))]
        public double Timestamp
        {
            get;
            set;
        }

        /// <summary>
        /// How many uploads deep the related request was.
        /// </summary>
        [DataMember(Name = ("depth"), IsRequired = (true))]
        public int Depth
        {
            get;
            set;
        }

        /// <summary>
        /// The number of delivery attempts made so far, not including an active attempt.
        /// </summary>
        [DataMember(Name = ("completedAttempts"), IsRequired = (true))]
        public int CompletedAttempts
        {
            get;
            set;
        }

        /// <summary>
        /// Body
        /// </summary>
        [DataMember(Name = ("body"), IsRequired = (true))]
        public object Body
        {
            get;
            set;
        }

        /// <summary>
        /// Status
        /// </summary>
        public CefSharp.DevTools.Network.ReportStatus Status
        {
            get
            {
                return (CefSharp.DevTools.Network.ReportStatus)(StringToEnum(typeof(CefSharp.DevTools.Network.ReportStatus), status));
            }

            set
            {
                this.status = (EnumToString(value));
            }
        }

        /// <summary>
        /// Status
        /// </summary>
        [DataMember(Name = ("status"), IsRequired = (true))]
        internal string status
        {
            get;
            set;
        }
    }

    /// <summary>
    /// ReportingApiEndpoint
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class ReportingApiEndpoint : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The URL of the endpoint to which reports may be delivered.
        /// </summary>
        [DataMember(Name = ("url"), IsRequired = (true))]
        public string Url
        {
            get;
            set;
        }

        /// <summary>
        /// Name of the endpoint group.
        /// </summary>
        [DataMember(Name = ("groupName"), IsRequired = (true))]
        public string GroupName
        {
            get;
            set;
        }
    }

    /// <summary>
    /// An object providing the result of a network resource load.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class LoadNetworkResourcePageResult : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Success
        /// </summary>
        [DataMember(Name = ("success"), IsRequired = (true))]
        public bool Success
        {
            get;
            set;
        }

        /// <summary>
        /// Optional values used for error reporting.
        /// </summary>
        [DataMember(Name = ("netError"), IsRequired = (false))]
        public double? NetError
        {
            get;
            set;
        }

        /// <summary>
        /// NetErrorName
        /// </summary>
        [DataMember(Name = ("netErrorName"), IsRequired = (false))]
        public string NetErrorName
        {
            get;
            set;
        }

        /// <summary>
        /// HttpStatusCode
        /// </summary>
        [DataMember(Name = ("httpStatusCode"), IsRequired = (false))]
        public double? HttpStatusCode
        {
            get;
            set;
        }

        /// <summary>
        /// If successful, one of the following two fields holds the result.
        /// </summary>
        [DataMember(Name = ("stream"), IsRequired = (false))]
        public string Stream
        {
            get;
            set;
        }

        /// <summary>
        /// Response headers.
        /// </summary>
        [DataMember(Name = ("headers"), IsRequired = (false))]
        public CefSharp.DevTools.Network.Headers Headers
        {
            get;
            set;
        }
    }

    /// <summary>
    /// An options object that may be extended later to better support CORS,
    /// CORB and streaming.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class LoadNetworkResourceOptions : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// DisableCache
        /// </summary>
        [DataMember(Name = ("disableCache"), IsRequired = (true))]
        public bool DisableCache
        {
            get;
            set;
        }

        /// <summary>
        /// IncludeCredentials
        /// </summary>
        [DataMember(Name = ("includeCredentials"), IsRequired = (true))]
        public bool IncludeCredentials
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Fired when data chunk was received over the network.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class DataReceivedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Request identifier.
        /// </summary>
        [DataMember(Name = ("requestId"), IsRequired = (true))]
        public string RequestId
        {
            get;
            private set;
        }

        /// <summary>
        /// Timestamp.
        /// </summary>
        [DataMember(Name = ("timestamp"), IsRequired = (true))]
        public double Timestamp
        {
            get;
            private set;
        }

        /// <summary>
        /// Data chunk length.
        /// </summary>
        [DataMember(Name = ("dataLength"), IsRequired = (true))]
        public int DataLength
        {
            get;
            private set;
        }

        /// <summary>
        /// Actual bytes received (might be less than dataLength for compressed encodings).
        /// </summary>
        [DataMember(Name = ("encodedDataLength"), IsRequired = (true))]
        public int EncodedDataLength
        {
            get;
            private set;
        }

        /// <summary>
        /// Data that was received.
        /// </summary>
        [DataMember(Name = ("data"), IsRequired = (false))]
        public byte[] Data
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired when EventSource message is received.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class EventSourceMessageReceivedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Request identifier.
        /// </summary>
        [DataMember(Name = ("requestId"), IsRequired = (true))]
        public string RequestId
        {
            get;
            private set;
        }

        /// <summary>
        /// Timestamp.
        /// </summary>
        [DataMember(Name = ("timestamp"), IsRequired = (true))]
        public double Timestamp
        {
            get;
            private set;
        }

        /// <summary>
        /// Message type.
        /// </summary>
        [DataMember(Name = ("eventName"), IsRequired = (true))]
        public string EventName
        {
            get;
            private set;
        }

        /// <summary>
        /// Message identifier.
        /// </summary>
        [DataMember(Name = ("eventId"), IsRequired = (true))]
        public string EventId
        {
            get;
            private set;
        }

        /// <summary>
        /// Message content.
        /// </summary>
        [DataMember(Name = ("data"), IsRequired = (true))]
        public string Data
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired when HTTP request has failed to load.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class LoadingFailedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Request identifier.
        /// </summary>
        [DataMember(Name = ("requestId"), IsRequired = (true))]
        public string RequestId
        {
            get;
            private set;
        }

        /// <summary>
        /// Timestamp.
        /// </summary>
        [DataMember(Name = ("timestamp"), IsRequired = (true))]
        public double Timestamp
        {
            get;
            private set;
        }

        /// <summary>
        /// Resource type.
        /// </summary>
        public CefSharp.DevTools.Network.ResourceType Type
        {
            get
            {
                return (CefSharp.DevTools.Network.ResourceType)(StringToEnum(typeof(CefSharp.DevTools.Network.ResourceType), type));
            }

            set
            {
                this.type = (EnumToString(value));
            }
        }

        /// <summary>
        /// Resource type.
        /// </summary>
        [DataMember(Name = ("type"), IsRequired = (true))]
        internal string type
        {
            get;
            private set;
        }

        /// <summary>
        /// Error message. List of network errors: https://cs.chromium.org/chromium/src/net/base/net_error_list.h
        /// </summary>
        [DataMember(Name = ("errorText"), IsRequired = (true))]
        public string ErrorText
        {
            get;
            private set;
        }

        /// <summary>
        /// True if loading was canceled.
        /// </summary>
        [DataMember(Name = ("canceled"), IsRequired = (false))]
        public bool? Canceled
        {
            get;
            private set;
        }

        /// <summary>
        /// The reason why loading was blocked, if any.
        /// </summary>
        public CefSharp.DevTools.Network.BlockedReason? BlockedReason
        {
            get
            {
                return (CefSharp.DevTools.Network.BlockedReason? )(StringToEnum(typeof(CefSharp.DevTools.Network.BlockedReason? ), blockedReason));
            }

            set
            {
                this.blockedReason = (EnumToString(value));
            }
        }

        /// <summary>
        /// The reason why loading was blocked, if any.
        /// </summary>
        [DataMember(Name = ("blockedReason"), IsRequired = (false))]
        internal string blockedReason
        {
            get;
            private set;
        }

        /// <summary>
        /// The reason why loading was blocked by CORS, if any.
        /// </summary>
        [DataMember(Name = ("corsErrorStatus"), IsRequired = (false))]
        public CefSharp.DevTools.Network.CorsErrorStatus CorsErrorStatus
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired when HTTP request has finished loading.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class LoadingFinishedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Request identifier.
        /// </summary>
        [DataMember(Name = ("requestId"), IsRequired = (true))]
        public string RequestId
        {
            get;
            private set;
        }

        /// <summary>
        /// Timestamp.
        /// </summary>
        [DataMember(Name = ("timestamp"), IsRequired = (true))]
        public double Timestamp
        {
            get;
            private set;
        }

        /// <summary>
        /// Total number of bytes received for this request.
        /// </summary>
        [DataMember(Name = ("encodedDataLength"), IsRequired = (true))]
        public double EncodedDataLength
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Details of an intercepted HTTP request, which must be either allowed, blocked, modified or
    /// mocked.
    /// Deprecated, use Fetch.requestPaused instead.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class RequestInterceptedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Each request the page makes will have a unique id, however if any redirects are encountered
        /// while processing that fetch, they will be reported with the same id as the original fetch.
        /// Likewise if HTTP authentication is needed then the same fetch id will be used.
        /// </summary>
        [DataMember(Name = ("interceptionId"), IsRequired = (true))]
        public string InterceptionId
        {
            get;
            private set;
        }

        /// <summary>
        /// Request
        /// </summary>
        [DataMember(Name = ("request"), IsRequired = (true))]
        public CefSharp.DevTools.Network.Request Request
        {
            get;
            private set;
        }

        /// <summary>
        /// The id of the frame that initiated the request.
        /// </summary>
        [DataMember(Name = ("frameId"), IsRequired = (true))]
        public string FrameId
        {
            get;
            private set;
        }

        /// <summary>
        /// How the requested resource will be used.
        /// </summary>
        public CefSharp.DevTools.Network.ResourceType ResourceType
        {
            get
            {
                return (CefSharp.DevTools.Network.ResourceType)(StringToEnum(typeof(CefSharp.DevTools.Network.ResourceType), resourceType));
            }

            set
            {
                this.resourceType = (EnumToString(value));
            }
        }

        /// <summary>
        /// How the requested resource will be used.
        /// </summary>
        [DataMember(Name = ("resourceType"), IsRequired = (true))]
        internal string resourceType
        {
            get;
            private set;
        }

        /// <summary>
        /// Whether this is a navigation request, which can abort the navigation completely.
        /// </summary>
        [DataMember(Name = ("isNavigationRequest"), IsRequired = (true))]
        public bool IsNavigationRequest
        {
            get;
            private set;
        }

        /// <summary>
        /// Set if the request is a navigation that will result in a download.
        /// Only present after response is received from the server (i.e. HeadersReceived stage).
        /// </summary>
        [DataMember(Name = ("isDownload"), IsRequired = (false))]
        public bool? IsDownload
        {
            get;
            private set;
        }

        /// <summary>
        /// Redirect location, only sent if a redirect was intercepted.
        /// </summary>
        [DataMember(Name = ("redirectUrl"), IsRequired = (false))]
        public string RedirectUrl
        {
            get;
            private set;
        }

        /// <summary>
        /// Details of the Authorization Challenge encountered. If this is set then
        /// continueInterceptedRequest must contain an authChallengeResponse.
        /// </summary>
        [DataMember(Name = ("authChallenge"), IsRequired = (false))]
        public CefSharp.DevTools.Network.AuthChallenge AuthChallenge
        {
            get;
            private set;
        }

        /// <summary>
        /// Response error if intercepted at response stage or if redirect occurred while intercepting
        /// request.
        /// </summary>
        public CefSharp.DevTools.Network.ErrorReason? ResponseErrorReason
        {
            get
            {
                return (CefSharp.DevTools.Network.ErrorReason? )(StringToEnum(typeof(CefSharp.DevTools.Network.ErrorReason? ), responseErrorReason));
            }

            set
            {
                this.responseErrorReason = (EnumToString(value));
            }
        }

        /// <summary>
        /// Response error if intercepted at response stage or if redirect occurred while intercepting
        /// request.
        /// </summary>
        [DataMember(Name = ("responseErrorReason"), IsRequired = (false))]
        internal string responseErrorReason
        {
            get;
            private set;
        }

        /// <summary>
        /// Response code if intercepted at response stage or if redirect occurred while intercepting
        /// request or auth retry occurred.
        /// </summary>
        [DataMember(Name = ("responseStatusCode"), IsRequired = (false))]
        public int? ResponseStatusCode
        {
            get;
            private set;
        }

        /// <summary>
        /// Response headers if intercepted at the response stage or if redirect occurred while
        /// intercepting request or auth retry occurred.
        /// </summary>
        [DataMember(Name = ("responseHeaders"), IsRequired = (false))]
        public CefSharp.DevTools.Network.Headers ResponseHeaders
        {
            get;
            private set;
        }

        /// <summary>
        /// If the intercepted request had a corresponding requestWillBeSent event fired for it, then
        /// this requestId will be the same as the requestId present in the requestWillBeSent event.
        /// </summary>
        [DataMember(Name = ("requestId"), IsRequired = (false))]
        public string RequestId
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired if request ended up loading from cache.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class RequestServedFromCacheEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Request identifier.
        /// </summary>
        [DataMember(Name = ("requestId"), IsRequired = (true))]
        public string RequestId
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired when page is about to send HTTP request.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class RequestWillBeSentEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Request identifier.
        /// </summary>
        [DataMember(Name = ("requestId"), IsRequired = (true))]
        public string RequestId
        {
            get;
            private set;
        }

        /// <summary>
        /// Loader identifier. Empty string if the request is fetched from worker.
        /// </summary>
        [DataMember(Name = ("loaderId"), IsRequired = (true))]
        public string LoaderId
        {
            get;
            private set;
        }

        /// <summary>
        /// URL of the document this request is loaded for.
        /// </summary>
        [DataMember(Name = ("documentURL"), IsRequired = (true))]
        public string DocumentURL
        {
            get;
            private set;
        }

        /// <summary>
        /// Request data.
        /// </summary>
        [DataMember(Name = ("request"), IsRequired = (true))]
        public CefSharp.DevTools.Network.Request Request
        {
            get;
            private set;
        }

        /// <summary>
        /// Timestamp.
        /// </summary>
        [DataMember(Name = ("timestamp"), IsRequired = (true))]
        public double Timestamp
        {
            get;
            private set;
        }

        /// <summary>
        /// Timestamp.
        /// </summary>
        [DataMember(Name = ("wallTime"), IsRequired = (true))]
        public double WallTime
        {
            get;
            private set;
        }

        /// <summary>
        /// Request initiator.
        /// </summary>
        [DataMember(Name = ("initiator"), IsRequired = (true))]
        public CefSharp.DevTools.Network.Initiator Initiator
        {
            get;
            private set;
        }

        /// <summary>
        /// In the case that redirectResponse is populated, this flag indicates whether
        /// requestWillBeSentExtraInfo and responseReceivedExtraInfo events will be or were emitted
        /// for the request which was just redirected.
        /// </summary>
        [DataMember(Name = ("redirectHasExtraInfo"), IsRequired = (true))]
        public bool RedirectHasExtraInfo
        {
            get;
            private set;
        }

        /// <summary>
        /// Redirect response data.
        /// </summary>
        [DataMember(Name = ("redirectResponse"), IsRequired = (false))]
        public CefSharp.DevTools.Network.Response RedirectResponse
        {
            get;
            private set;
        }

        /// <summary>
        /// Type of this resource.
        /// </summary>
        public CefSharp.DevTools.Network.ResourceType? Type
        {
            get
            {
                return (CefSharp.DevTools.Network.ResourceType? )(StringToEnum(typeof(CefSharp.DevTools.Network.ResourceType? ), type));
            }

            set
            {
                this.type = (EnumToString(value));
            }
        }

        /// <summary>
        /// Type of this resource.
        /// </summary>
        [DataMember(Name = ("type"), IsRequired = (false))]
        internal string type
        {
            get;
            private set;
        }

        /// <summary>
        /// Frame identifier.
        /// </summary>
        [DataMember(Name = ("frameId"), IsRequired = (false))]
        public string FrameId
        {
            get;
            private set;
        }

        /// <summary>
        /// Whether the request is initiated by a user gesture. Defaults to false.
        /// </summary>
        [DataMember(Name = ("hasUserGesture"), IsRequired = (false))]
        public bool? HasUserGesture
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired when resource loading priority is changed
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class ResourceChangedPriorityEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Request identifier.
        /// </summary>
        [DataMember(Name = ("requestId"), IsRequired = (true))]
        public string RequestId
        {
            get;
            private set;
        }

        /// <summary>
        /// New priority
        /// </summary>
        public CefSharp.DevTools.Network.ResourcePriority NewPriority
        {
            get
            {
                return (CefSharp.DevTools.Network.ResourcePriority)(StringToEnum(typeof(CefSharp.DevTools.Network.ResourcePriority), newPriority));
            }

            set
            {
                this.newPriority = (EnumToString(value));
            }
        }

        /// <summary>
        /// New priority
        /// </summary>
        [DataMember(Name = ("newPriority"), IsRequired = (true))]
        internal string newPriority
        {
            get;
            private set;
        }

        /// <summary>
        /// Timestamp.
        /// </summary>
        [DataMember(Name = ("timestamp"), IsRequired = (true))]
        public double Timestamp
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired when a signed exchange was received over the network
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class SignedExchangeReceivedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Request identifier.
        /// </summary>
        [DataMember(Name = ("requestId"), IsRequired = (true))]
        public string RequestId
        {
            get;
            private set;
        }

        /// <summary>
        /// Information about the signed exchange response.
        /// </summary>
        [DataMember(Name = ("info"), IsRequired = (true))]
        public CefSharp.DevTools.Network.SignedExchangeInfo Info
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired when HTTP response is available.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class ResponseReceivedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Request identifier.
        /// </summary>
        [DataMember(Name = ("requestId"), IsRequired = (true))]
        public string RequestId
        {
            get;
            private set;
        }

        /// <summary>
        /// Loader identifier. Empty string if the request is fetched from worker.
        /// </summary>
        [DataMember(Name = ("loaderId"), IsRequired = (true))]
        public string LoaderId
        {
            get;
            private set;
        }

        /// <summary>
        /// Timestamp.
        /// </summary>
        [DataMember(Name = ("timestamp"), IsRequired = (true))]
        public double Timestamp
        {
            get;
            private set;
        }

        /// <summary>
        /// Resource type.
        /// </summary>
        public CefSharp.DevTools.Network.ResourceType Type
        {
            get
            {
                return (CefSharp.DevTools.Network.ResourceType)(StringToEnum(typeof(CefSharp.DevTools.Network.ResourceType), type));
            }

            set
            {
                this.type = (EnumToString(value));
            }
        }

        /// <summary>
        /// Resource type.
        /// </summary>
        [DataMember(Name = ("type"), IsRequired = (true))]
        internal string type
        {
            get;
            private set;
        }

        /// <summary>
        /// Response data.
        /// </summary>
        [DataMember(Name = ("response"), IsRequired = (true))]
        public CefSharp.DevTools.Network.Response Response
        {
            get;
            private set;
        }

        /// <summary>
        /// Indicates whether requestWillBeSentExtraInfo and responseReceivedExtraInfo events will be
        /// or were emitted for this request.
        /// </summary>
        [DataMember(Name = ("hasExtraInfo"), IsRequired = (true))]
        public bool HasExtraInfo
        {
            get;
            private set;
        }

        /// <summary>
        /// Frame identifier.
        /// </summary>
        [DataMember(Name = ("frameId"), IsRequired = (false))]
        public string FrameId
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired when WebSocket is closed.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class WebSocketClosedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Request identifier.
        /// </summary>
        [DataMember(Name = ("requestId"), IsRequired = (true))]
        public string RequestId
        {
            get;
            private set;
        }

        /// <summary>
        /// Timestamp.
        /// </summary>
        [DataMember(Name = ("timestamp"), IsRequired = (true))]
        public double Timestamp
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired upon WebSocket creation.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class WebSocketCreatedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Request identifier.
        /// </summary>
        [DataMember(Name = ("requestId"), IsRequired = (true))]
        public string RequestId
        {
            get;
            private set;
        }

        /// <summary>
        /// WebSocket request URL.
        /// </summary>
        [DataMember(Name = ("url"), IsRequired = (true))]
        public string Url
        {
            get;
            private set;
        }

        /// <summary>
        /// Request initiator.
        /// </summary>
        [DataMember(Name = ("initiator"), IsRequired = (false))]
        public CefSharp.DevTools.Network.Initiator Initiator
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired when WebSocket message error occurs.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class WebSocketFrameErrorEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Request identifier.
        /// </summary>
        [DataMember(Name = ("requestId"), IsRequired = (true))]
        public string RequestId
        {
            get;
            private set;
        }

        /// <summary>
        /// Timestamp.
        /// </summary>
        [DataMember(Name = ("timestamp"), IsRequired = (true))]
        public double Timestamp
        {
            get;
            private set;
        }

        /// <summary>
        /// WebSocket error message.
        /// </summary>
        [DataMember(Name = ("errorMessage"), IsRequired = (true))]
        public string ErrorMessage
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired when WebSocket message is received.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class WebSocketFrameReceivedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Request identifier.
        /// </summary>
        [DataMember(Name = ("requestId"), IsRequired = (true))]
        public string RequestId
        {
            get;
            private set;
        }

        /// <summary>
        /// Timestamp.
        /// </summary>
        [DataMember(Name = ("timestamp"), IsRequired = (true))]
        public double Timestamp
        {
            get;
            private set;
        }

        /// <summary>
        /// WebSocket response data.
        /// </summary>
        [DataMember(Name = ("response"), IsRequired = (true))]
        public CefSharp.DevTools.Network.WebSocketFrame Response
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired when WebSocket message is sent.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class WebSocketFrameSentEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Request identifier.
        /// </summary>
        [DataMember(Name = ("requestId"), IsRequired = (true))]
        public string RequestId
        {
            get;
            private set;
        }

        /// <summary>
        /// Timestamp.
        /// </summary>
        [DataMember(Name = ("timestamp"), IsRequired = (true))]
        public double Timestamp
        {
            get;
            private set;
        }

        /// <summary>
        /// WebSocket response data.
        /// </summary>
        [DataMember(Name = ("response"), IsRequired = (true))]
        public CefSharp.DevTools.Network.WebSocketFrame Response
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired when WebSocket handshake response becomes available.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class WebSocketHandshakeResponseReceivedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Request identifier.
        /// </summary>
        [DataMember(Name = ("requestId"), IsRequired = (true))]
        public string RequestId
        {
            get;
            private set;
        }

        /// <summary>
        /// Timestamp.
        /// </summary>
        [DataMember(Name = ("timestamp"), IsRequired = (true))]
        public double Timestamp
        {
            get;
            private set;
        }

        /// <summary>
        /// WebSocket response data.
        /// </summary>
        [DataMember(Name = ("response"), IsRequired = (true))]
        public CefSharp.DevTools.Network.WebSocketResponse Response
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired when WebSocket is about to initiate handshake.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class WebSocketWillSendHandshakeRequestEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Request identifier.
        /// </summary>
        [DataMember(Name = ("requestId"), IsRequired = (true))]
        public string RequestId
        {
            get;
            private set;
        }

        /// <summary>
        /// Timestamp.
        /// </summary>
        [DataMember(Name = ("timestamp"), IsRequired = (true))]
        public double Timestamp
        {
            get;
            private set;
        }

        /// <summary>
        /// UTC Timestamp.
        /// </summary>
        [DataMember(Name = ("wallTime"), IsRequired = (true))]
        public double WallTime
        {
            get;
            private set;
        }

        /// <summary>
        /// WebSocket request data.
        /// </summary>
        [DataMember(Name = ("request"), IsRequired = (true))]
        public CefSharp.DevTools.Network.WebSocketRequest Request
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired upon WebTransport creation.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class WebTransportCreatedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// WebTransport identifier.
        /// </summary>
        [DataMember(Name = ("transportId"), IsRequired = (true))]
        public string TransportId
        {
            get;
            private set;
        }

        /// <summary>
        /// WebTransport request URL.
        /// </summary>
        [DataMember(Name = ("url"), IsRequired = (true))]
        public string Url
        {
            get;
            private set;
        }

        /// <summary>
        /// Timestamp.
        /// </summary>
        [DataMember(Name = ("timestamp"), IsRequired = (true))]
        public double Timestamp
        {
            get;
            private set;
        }

        /// <summary>
        /// Request initiator.
        /// </summary>
        [DataMember(Name = ("initiator"), IsRequired = (false))]
        public CefSharp.DevTools.Network.Initiator Initiator
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired when WebTransport handshake is finished.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class WebTransportConnectionEstablishedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// WebTransport identifier.
        /// </summary>
        [DataMember(Name = ("transportId"), IsRequired = (true))]
        public string TransportId
        {
            get;
            private set;
        }

        /// <summary>
        /// Timestamp.
        /// </summary>
        [DataMember(Name = ("timestamp"), IsRequired = (true))]
        public double Timestamp
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired when WebTransport is disposed.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class WebTransportClosedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// WebTransport identifier.
        /// </summary>
        [DataMember(Name = ("transportId"), IsRequired = (true))]
        public string TransportId
        {
            get;
            private set;
        }

        /// <summary>
        /// Timestamp.
        /// </summary>
        [DataMember(Name = ("timestamp"), IsRequired = (true))]
        public double Timestamp
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired when additional information about a requestWillBeSent event is available from the
    /// network stack. Not every requestWillBeSent event will have an additional
    /// requestWillBeSentExtraInfo fired for it, and there is no guarantee whether requestWillBeSent
    /// or requestWillBeSentExtraInfo will be fired first for the same request.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class RequestWillBeSentExtraInfoEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Request identifier. Used to match this information to an existing requestWillBeSent event.
        /// </summary>
        [DataMember(Name = ("requestId"), IsRequired = (true))]
        public string RequestId
        {
            get;
            private set;
        }

        /// <summary>
        /// A list of cookies potentially associated to the requested URL. This includes both cookies sent with
        /// the request and the ones not sent; the latter are distinguished by having blockedReasons field set.
        /// </summary>
        [DataMember(Name = ("associatedCookies"), IsRequired = (true))]
        public System.Collections.Generic.IList<CefSharp.DevTools.Network.AssociatedCookie> AssociatedCookies
        {
            get;
            private set;
        }

        /// <summary>
        /// Raw request headers as they will be sent over the wire.
        /// </summary>
        [DataMember(Name = ("headers"), IsRequired = (true))]
        public CefSharp.DevTools.Network.Headers Headers
        {
            get;
            private set;
        }

        /// <summary>
        /// Connection timing information for the request.
        /// </summary>
        [DataMember(Name = ("connectTiming"), IsRequired = (true))]
        public CefSharp.DevTools.Network.ConnectTiming ConnectTiming
        {
            get;
            private set;
        }

        /// <summary>
        /// The client security state set for the request.
        /// </summary>
        [DataMember(Name = ("clientSecurityState"), IsRequired = (false))]
        public CefSharp.DevTools.Network.ClientSecurityState ClientSecurityState
        {
            get;
            private set;
        }

        /// <summary>
        /// Whether the site has partitioned cookies stored in a partition different than the current one.
        /// </summary>
        [DataMember(Name = ("siteHasCookieInOtherPartition"), IsRequired = (false))]
        public bool? SiteHasCookieInOtherPartition
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired when additional information about a responseReceived event is available from the network
    /// stack. Not every responseReceived event will have an additional responseReceivedExtraInfo for
    /// it, and responseReceivedExtraInfo may be fired before or after responseReceived.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class ResponseReceivedExtraInfoEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Request identifier. Used to match this information to another responseReceived event.
        /// </summary>
        [DataMember(Name = ("requestId"), IsRequired = (true))]
        public string RequestId
        {
            get;
            private set;
        }

        /// <summary>
        /// A list of cookies which were not stored from the response along with the corresponding
        /// reasons for blocking. The cookies here may not be valid due to syntax errors, which
        /// are represented by the invalid cookie line string instead of a proper cookie.
        /// </summary>
        [DataMember(Name = ("blockedCookies"), IsRequired = (true))]
        public System.Collections.Generic.IList<CefSharp.DevTools.Network.BlockedSetCookieWithReason> BlockedCookies
        {
            get;
            private set;
        }

        /// <summary>
        /// Raw response headers as they were received over the wire.
        /// </summary>
        [DataMember(Name = ("headers"), IsRequired = (true))]
        public CefSharp.DevTools.Network.Headers Headers
        {
            get;
            private set;
        }

        /// <summary>
        /// The IP address space of the resource. The address space can only be determined once the transport
        /// established the connection, so we can&apos;t send it in `requestWillBeSentExtraInfo`.
        /// </summary>
        public CefSharp.DevTools.Network.IPAddressSpace ResourceIPAddressSpace
        {
            get
            {
                return (CefSharp.DevTools.Network.IPAddressSpace)(StringToEnum(typeof(CefSharp.DevTools.Network.IPAddressSpace), resourceIPAddressSpace));
            }

            set
            {
                this.resourceIPAddressSpace = (EnumToString(value));
            }
        }

        /// <summary>
        /// The IP address space of the resource. The address space can only be determined once the transport
        /// established the connection, so we can&apos;t send it in `requestWillBeSentExtraInfo`.
        /// </summary>
        [DataMember(Name = ("resourceIPAddressSpace"), IsRequired = (true))]
        internal string resourceIPAddressSpace
        {
            get;
            private set;
        }

        /// <summary>
        /// The status code of the response. This is useful in cases the request failed and no responseReceived
        /// event is triggered, which is the case for, e.g., CORS errors. This is also the correct status code
        /// for cached requests, where the status in responseReceived is a 200 and this will be 304.
        /// </summary>
        [DataMember(Name = ("statusCode"), IsRequired = (true))]
        public int StatusCode
        {
            get;
            private set;
        }

        /// <summary>
        /// Raw response header text as it was received over the wire. The raw text may not always be
        /// available, such as in the case of HTTP/2 or QUIC.
        /// </summary>
        [DataMember(Name = ("headersText"), IsRequired = (false))]
        public string HeadersText
        {
            get;
            private set;
        }

        /// <summary>
        /// The cookie partition key that will be used to store partitioned cookies set in this response.
        /// Only sent when partitioned cookies are enabled.
        /// </summary>
        [DataMember(Name = ("cookiePartitionKey"), IsRequired = (false))]
        public CefSharp.DevTools.Network.CookiePartitionKey CookiePartitionKey
        {
            get;
            private set;
        }

        /// <summary>
        /// True if partitioned cookies are enabled, but the partition key is not serializable to string.
        /// </summary>
        [DataMember(Name = ("cookiePartitionKeyOpaque"), IsRequired = (false))]
        public bool? CookiePartitionKeyOpaque
        {
            get;
            private set;
        }

        /// <summary>
        /// A list of cookies which should have been blocked by 3PCD but are exempted and stored from
        /// the response with the corresponding reason.
        /// </summary>
        [DataMember(Name = ("exemptedCookies"), IsRequired = (false))]
        public System.Collections.Generic.IList<CefSharp.DevTools.Network.ExemptedSetCookieWithReason> ExemptedCookies
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired when 103 Early Hints headers is received in addition to the common response.
    /// Not every responseReceived event will have an responseReceivedEarlyHints fired.
    /// Only one responseReceivedEarlyHints may be fired for eached responseReceived event.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class ResponseReceivedEarlyHintsEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Request identifier. Used to match this information to another responseReceived event.
        /// </summary>
        [DataMember(Name = ("requestId"), IsRequired = (true))]
        public string RequestId
        {
            get;
            private set;
        }

        /// <summary>
        /// Raw response headers as they were received over the wire.
        /// </summary>
        [DataMember(Name = ("headers"), IsRequired = (true))]
        public CefSharp.DevTools.Network.Headers Headers
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Detailed success or error status of the operation.
    /// &apos;AlreadyExists&apos; also signifies a successful operation, as the result
    /// of the operation already exists und thus, the operation was abort
    /// preemptively (e.g. a cache hit).
    /// </summary>
    public enum TrustTokenOperationDoneStatus
    {
        /// <summary>
        /// Ok
        /// </summary>
        [EnumMember(Value = ("Ok"))]
        Ok,
        /// <summary>
        /// InvalidArgument
        /// </summary>
        [EnumMember(Value = ("InvalidArgument"))]
        InvalidArgument,
        /// <summary>
        /// MissingIssuerKeys
        /// </summary>
        [EnumMember(Value = ("MissingIssuerKeys"))]
        MissingIssuerKeys,
        /// <summary>
        /// FailedPrecondition
        /// </summary>
        [EnumMember(Value = ("FailedPrecondition"))]
        FailedPrecondition,
        /// <summary>
        /// ResourceExhausted
        /// </summary>
        [EnumMember(Value = ("ResourceExhausted"))]
        ResourceExhausted,
        /// <summary>
        /// AlreadyExists
        /// </summary>
        [EnumMember(Value = ("AlreadyExists"))]
        AlreadyExists,
        /// <summary>
        /// ResourceLimited
        /// </summary>
        [EnumMember(Value = ("ResourceLimited"))]
        ResourceLimited,
        /// <summary>
        /// Unauthorized
        /// </summary>
        [EnumMember(Value = ("Unauthorized"))]
        Unauthorized,
        /// <summary>
        /// BadResponse
        /// </summary>
        [EnumMember(Value = ("BadResponse"))]
        BadResponse,
        /// <summary>
        /// InternalError
        /// </summary>
        [EnumMember(Value = ("InternalError"))]
        InternalError,
        /// <summary>
        /// UnknownError
        /// </summary>
        [EnumMember(Value = ("UnknownError"))]
        UnknownError,
        /// <summary>
        /// FulfilledLocally
        /// </summary>
        [EnumMember(Value = ("FulfilledLocally"))]
        FulfilledLocally
    }

    /// <summary>
    /// Fired exactly once for each Trust Token operation. Depending on
    /// the type of the operation and whether the operation succeeded or
    /// failed, the event is fired before the corresponding request was sent
    /// or after the response was received.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class TrustTokenOperationDoneEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Detailed success or error status of the operation.
        /// &apos;AlreadyExists&apos; also signifies a successful operation, as the result
        /// of the operation already exists und thus, the operation was abort
        /// preemptively (e.g. a cache hit).
        /// </summary>
        public CefSharp.DevTools.Network.TrustTokenOperationDoneStatus Status
        {
            get
            {
                return (CefSharp.DevTools.Network.TrustTokenOperationDoneStatus)(StringToEnum(typeof(CefSharp.DevTools.Network.TrustTokenOperationDoneStatus), status));
            }

            set
            {
                this.status = (EnumToString(value));
            }
        }

        /// <summary>
        /// Detailed success or error status of the operation.
        /// &apos;AlreadyExists&apos; also signifies a successful operation, as the result
        /// of the operation already exists und thus, the operation was abort
        /// preemptively (e.g. a cache hit).
        /// </summary>
        [DataMember(Name = ("status"), IsRequired = (true))]
        internal string status
        {
            get;
            private set;
        }

        /// <summary>
        /// Type
        /// </summary>
        public CefSharp.DevTools.Network.TrustTokenOperationType Type
        {
            get
            {
                return (CefSharp.DevTools.Network.TrustTokenOperationType)(StringToEnum(typeof(CefSharp.DevTools.Network.TrustTokenOperationType), type));
            }

            set
            {
                this.type = (EnumToString(value));
            }
        }

        /// <summary>
        /// Type
        /// </summary>
        [DataMember(Name = ("type"), IsRequired = (true))]
        internal string type
        {
            get;
            private set;
        }

        /// <summary>
        /// RequestId
        /// </summary>
        [DataMember(Name = ("requestId"), IsRequired = (true))]
        public string RequestId
        {
            get;
            private set;
        }

        /// <summary>
        /// Top level origin. The context in which the operation was attempted.
        /// </summary>
        [DataMember(Name = ("topLevelOrigin"), IsRequired = (false))]
        public string TopLevelOrigin
        {
            get;
            private set;
        }

        /// <summary>
        /// Origin of the issuer in case of a &quot;Issuance&quot; or &quot;Redemption&quot; operation.
        /// </summary>
        [DataMember(Name = ("issuerOrigin"), IsRequired = (false))]
        public string IssuerOrigin
        {
            get;
            private set;
        }

        /// <summary>
        /// The number of obtained Trust Tokens on a successful &quot;Issuance&quot; operation.
        /// </summary>
        [DataMember(Name = ("issuedTokenCount"), IsRequired = (false))]
        public int? IssuedTokenCount
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired once when parsing the .wbn file has succeeded.
    /// The event contains the information about the web bundle contents.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class SubresourceWebBundleMetadataReceivedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Request identifier. Used to match this information to another event.
        /// </summary>
        [DataMember(Name = ("requestId"), IsRequired = (true))]
        public string RequestId
        {
            get;
            private set;
        }

        /// <summary>
        /// A list of URLs of resources in the subresource Web Bundle.
        /// </summary>
        [DataMember(Name = ("urls"), IsRequired = (true))]
        public string[] Urls
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired once when parsing the .wbn file has failed.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class SubresourceWebBundleMetadataErrorEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Request identifier. Used to match this information to another event.
        /// </summary>
        [DataMember(Name = ("requestId"), IsRequired = (true))]
        public string RequestId
        {
            get;
            private set;
        }

        /// <summary>
        /// Error message
        /// </summary>
        [DataMember(Name = ("errorMessage"), IsRequired = (true))]
        public string ErrorMessage
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired when handling requests for resources within a .wbn file.
    /// Note: this will only be fired for resources that are requested by the webpage.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class SubresourceWebBundleInnerResponseParsedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Request identifier of the subresource request
        /// </summary>
        [DataMember(Name = ("innerRequestId"), IsRequired = (true))]
        public string InnerRequestId
        {
            get;
            private set;
        }

        /// <summary>
        /// URL of the subresource resource.
        /// </summary>
        [DataMember(Name = ("innerRequestURL"), IsRequired = (true))]
        public string InnerRequestURL
        {
            get;
            private set;
        }

        /// <summary>
        /// Bundle request identifier. Used to match this information to another event.
        /// This made be absent in case when the instrumentation was enabled only
        /// after webbundle was parsed.
        /// </summary>
        [DataMember(Name = ("bundleRequestId"), IsRequired = (false))]
        public string BundleRequestId
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired when request for resources within a .wbn file failed.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class SubresourceWebBundleInnerResponseErrorEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Request identifier of the subresource request
        /// </summary>
        [DataMember(Name = ("innerRequestId"), IsRequired = (true))]
        public string InnerRequestId
        {
            get;
            private set;
        }

        /// <summary>
        /// URL of the subresource resource.
        /// </summary>
        [DataMember(Name = ("innerRequestURL"), IsRequired = (true))]
        public string InnerRequestURL
        {
            get;
            private set;
        }

        /// <summary>
        /// Error message
        /// </summary>
        [DataMember(Name = ("errorMessage"), IsRequired = (true))]
        public string ErrorMessage
        {
            get;
            private set;
        }

        /// <summary>
        /// Bundle request identifier. Used to match this information to another event.
        /// This made be absent in case when the instrumentation was enabled only
        /// after webbundle was parsed.
        /// </summary>
        [DataMember(Name = ("bundleRequestId"), IsRequired = (false))]
        public string BundleRequestId
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Is sent whenever a new report is added.
    /// And after &apos;enableReportingApi&apos; for all existing reports.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class ReportingApiReportAddedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Report
        /// </summary>
        [DataMember(Name = ("report"), IsRequired = (true))]
        public CefSharp.DevTools.Network.ReportingApiReport Report
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// reportingApiReportUpdated
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class ReportingApiReportUpdatedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Report
        /// </summary>
        [DataMember(Name = ("report"), IsRequired = (true))]
        public CefSharp.DevTools.Network.ReportingApiReport Report
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// reportingApiEndpointsChangedForOrigin
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class ReportingApiEndpointsChangedForOriginEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Origin of the document(s) which configured the endpoints.
        /// </summary>
        [DataMember(Name = ("origin"), IsRequired = (true))]
        public string Origin
        {
            get;
            private set;
        }

        /// <summary>
        /// Endpoints
        /// </summary>
        [DataMember(Name = ("endpoints"), IsRequired = (true))]
        public System.Collections.Generic.IList<CefSharp.DevTools.Network.ReportingApiEndpoint> Endpoints
        {
            get;
            private set;
        }
    }
}

namespace CefSharp.DevTools.Overlay
{
    /// <summary>
    /// Configuration data for drawing the source order of an elements children.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class SourceOrderConfig : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// the color to outline the given element in.
        /// </summary>
        [DataMember(Name = ("parentOutlineColor"), IsRequired = (true))]
        public CefSharp.DevTools.DOM.RGBA ParentOutlineColor
        {
            get;
            set;
        }

        /// <summary>
        /// the color to outline the child elements in.
        /// </summary>
        [DataMember(Name = ("childOutlineColor"), IsRequired = (true))]
        public CefSharp.DevTools.DOM.RGBA ChildOutlineColor
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Configuration data for the highlighting of Grid elements.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class GridHighlightConfig : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Whether the extension lines from grid cells to the rulers should be shown (default: false).
        /// </summary>
        [DataMember(Name = ("showGridExtensionLines"), IsRequired = (false))]
        public bool? ShowGridExtensionLines
        {
            get;
            set;
        }

        /// <summary>
        /// Show Positive line number labels (default: false).
        /// </summary>
        [DataMember(Name = ("showPositiveLineNumbers"), IsRequired = (false))]
        public bool? ShowPositiveLineNumbers
        {
            get;
            set;
        }

        /// <summary>
        /// Show Negative line number labels (default: false).
        /// </summary>
        [DataMember(Name = ("showNegativeLineNumbers"), IsRequired = (false))]
        public bool? ShowNegativeLineNumbers
        {
            get;
            set;
        }

        /// <summary>
        /// Show area name labels (default: false).
        /// </summary>
        [DataMember(Name = ("showAreaNames"), IsRequired = (false))]
        public bool? ShowAreaNames
        {
            get;
            set;
        }

        /// <summary>
        /// Show line name labels (default: false).
        /// </summary>
        [DataMember(Name = ("showLineNames"), IsRequired = (false))]
        public bool? ShowLineNames
        {
            get;
            set;
        }

        /// <summary>
        /// Show track size labels (default: false).
        /// </summary>
        [DataMember(Name = ("showTrackSizes"), IsRequired = (false))]
        public bool? ShowTrackSizes
        {
            get;
            set;
        }

        /// <summary>
        /// The grid container border highlight color (default: transparent).
        /// </summary>
        [DataMember(Name = ("gridBorderColor"), IsRequired = (false))]
        public CefSharp.DevTools.DOM.RGBA GridBorderColor
        {
            get;
            set;
        }

        /// <summary>
        /// The cell border color (default: transparent). Deprecated, please use rowLineColor and columnLineColor instead.
        /// </summary>
        [DataMember(Name = ("cellBorderColor"), IsRequired = (false))]
        public CefSharp.DevTools.DOM.RGBA CellBorderColor
        {
            get;
            set;
        }

        /// <summary>
        /// The row line color (default: transparent).
        /// </summary>
        [DataMember(Name = ("rowLineColor"), IsRequired = (false))]
        public CefSharp.DevTools.DOM.RGBA RowLineColor
        {
            get;
            set;
        }

        /// <summary>
        /// The column line color (default: transparent).
        /// </summary>
        [DataMember(Name = ("columnLineColor"), IsRequired = (false))]
        public CefSharp.DevTools.DOM.RGBA ColumnLineColor
        {
            get;
            set;
        }

        /// <summary>
        /// Whether the grid border is dashed (default: false).
        /// </summary>
        [DataMember(Name = ("gridBorderDash"), IsRequired = (false))]
        public bool? GridBorderDash
        {
            get;
            set;
        }

        /// <summary>
        /// Whether the cell border is dashed (default: false). Deprecated, please us rowLineDash and columnLineDash instead.
        /// </summary>
        [DataMember(Name = ("cellBorderDash"), IsRequired = (false))]
        public bool? CellBorderDash
        {
            get;
            set;
        }

        /// <summary>
        /// Whether row lines are dashed (default: false).
        /// </summary>
        [DataMember(Name = ("rowLineDash"), IsRequired = (false))]
        public bool? RowLineDash
        {
            get;
            set;
        }

        /// <summary>
        /// Whether column lines are dashed (default: false).
        /// </summary>
        [DataMember(Name = ("columnLineDash"), IsRequired = (false))]
        public bool? ColumnLineDash
        {
            get;
            set;
        }

        /// <summary>
        /// The row gap highlight fill color (default: transparent).
        /// </summary>
        [DataMember(Name = ("rowGapColor"), IsRequired = (false))]
        public CefSharp.DevTools.DOM.RGBA RowGapColor
        {
            get;
            set;
        }

        /// <summary>
        /// The row gap hatching fill color (default: transparent).
        /// </summary>
        [DataMember(Name = ("rowHatchColor"), IsRequired = (false))]
        public CefSharp.DevTools.DOM.RGBA RowHatchColor
        {
            get;
            set;
        }

        /// <summary>
        /// The column gap highlight fill color (default: transparent).
        /// </summary>
        [DataMember(Name = ("columnGapColor"), IsRequired = (false))]
        public CefSharp.DevTools.DOM.RGBA ColumnGapColor
        {
            get;
            set;
        }

        /// <summary>
        /// The column gap hatching fill color (default: transparent).
        /// </summary>
        [DataMember(Name = ("columnHatchColor"), IsRequired = (false))]
        public CefSharp.DevTools.DOM.RGBA ColumnHatchColor
        {
            get;
            set;
        }

        /// <summary>
        /// The named grid areas border color (Default: transparent).
        /// </summary>
        [DataMember(Name = ("areaBorderColor"), IsRequired = (false))]
        public CefSharp.DevTools.DOM.RGBA AreaBorderColor
        {
            get;
            set;
        }

        /// <summary>
        /// The grid container background color (Default: transparent).
        /// </summary>
        [DataMember(Name = ("gridBackgroundColor"), IsRequired = (false))]
        public CefSharp.DevTools.DOM.RGBA GridBackgroundColor
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Configuration data for the highlighting of Flex container elements.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class FlexContainerHighlightConfig : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The style of the container border
        /// </summary>
        [DataMember(Name = ("containerBorder"), IsRequired = (false))]
        public CefSharp.DevTools.Overlay.LineStyle ContainerBorder
        {
            get;
            set;
        }

        /// <summary>
        /// The style of the separator between lines
        /// </summary>
        [DataMember(Name = ("lineSeparator"), IsRequired = (false))]
        public CefSharp.DevTools.Overlay.LineStyle LineSeparator
        {
            get;
            set;
        }

        /// <summary>
        /// The style of the separator between items
        /// </summary>
        [DataMember(Name = ("itemSeparator"), IsRequired = (false))]
        public CefSharp.DevTools.Overlay.LineStyle ItemSeparator
        {
            get;
            set;
        }

        /// <summary>
        /// Style of content-distribution space on the main axis (justify-content).
        /// </summary>
        [DataMember(Name = ("mainDistributedSpace"), IsRequired = (false))]
        public CefSharp.DevTools.Overlay.BoxStyle MainDistributedSpace
        {
            get;
            set;
        }

        /// <summary>
        /// Style of content-distribution space on the cross axis (align-content).
        /// </summary>
        [DataMember(Name = ("crossDistributedSpace"), IsRequired = (false))]
        public CefSharp.DevTools.Overlay.BoxStyle CrossDistributedSpace
        {
            get;
            set;
        }

        /// <summary>
        /// Style of empty space caused by row gaps (gap/row-gap).
        /// </summary>
        [DataMember(Name = ("rowGapSpace"), IsRequired = (false))]
        public CefSharp.DevTools.Overlay.BoxStyle RowGapSpace
        {
            get;
            set;
        }

        /// <summary>
        /// Style of empty space caused by columns gaps (gap/column-gap).
        /// </summary>
        [DataMember(Name = ("columnGapSpace"), IsRequired = (false))]
        public CefSharp.DevTools.Overlay.BoxStyle ColumnGapSpace
        {
            get;
            set;
        }

        /// <summary>
        /// Style of the self-alignment line (align-items).
        /// </summary>
        [DataMember(Name = ("crossAlignment"), IsRequired = (false))]
        public CefSharp.DevTools.Overlay.LineStyle CrossAlignment
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Configuration data for the highlighting of Flex item elements.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class FlexItemHighlightConfig : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Style of the box representing the item&apos;s base size
        /// </summary>
        [DataMember(Name = ("baseSizeBox"), IsRequired = (false))]
        public CefSharp.DevTools.Overlay.BoxStyle BaseSizeBox
        {
            get;
            set;
        }

        /// <summary>
        /// Style of the border around the box representing the item&apos;s base size
        /// </summary>
        [DataMember(Name = ("baseSizeBorder"), IsRequired = (false))]
        public CefSharp.DevTools.Overlay.LineStyle BaseSizeBorder
        {
            get;
            set;
        }

        /// <summary>
        /// Style of the arrow representing if the item grew or shrank
        /// </summary>
        [DataMember(Name = ("flexibilityArrow"), IsRequired = (false))]
        public CefSharp.DevTools.Overlay.LineStyle FlexibilityArrow
        {
            get;
            set;
        }
    }

    /// <summary>
    /// The line pattern (default: solid)
    /// </summary>
    public enum LineStylePattern
    {
        /// <summary>
        /// dashed
        /// </summary>
        [EnumMember(Value = ("dashed"))]
        Dashed,
        /// <summary>
        /// dotted
        /// </summary>
        [EnumMember(Value = ("dotted"))]
        Dotted
    }

    /// <summary>
    /// Style information for drawing a line.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class LineStyle : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The color of the line (default: transparent)
        /// </summary>
        [DataMember(Name = ("color"), IsRequired = (false))]
        public CefSharp.DevTools.DOM.RGBA Color
        {
            get;
            set;
        }

        /// <summary>
        /// The line pattern (default: solid)
        /// </summary>
        public CefSharp.DevTools.Overlay.LineStylePattern? Pattern
        {
            get
            {
                return (CefSharp.DevTools.Overlay.LineStylePattern? )(StringToEnum(typeof(CefSharp.DevTools.Overlay.LineStylePattern? ), pattern));
            }

            set
            {
                this.pattern = (EnumToString(value));
            }
        }

        /// <summary>
        /// The line pattern (default: solid)
        /// </summary>
        [DataMember(Name = ("pattern"), IsRequired = (false))]
        internal string pattern
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Style information for drawing a box.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class BoxStyle : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The background color for the box (default: transparent)
        /// </summary>
        [DataMember(Name = ("fillColor"), IsRequired = (false))]
        public CefSharp.DevTools.DOM.RGBA FillColor
        {
            get;
            set;
        }

        /// <summary>
        /// The hatching color for the box (default: transparent)
        /// </summary>
        [DataMember(Name = ("hatchColor"), IsRequired = (false))]
        public CefSharp.DevTools.DOM.RGBA HatchColor
        {
            get;
            set;
        }
    }

    /// <summary>
    /// ContrastAlgorithm
    /// </summary>
    public enum ContrastAlgorithm
    {
        /// <summary>
        /// aa
        /// </summary>
        [EnumMember(Value = ("aa"))]
        Aa,
        /// <summary>
        /// aaa
        /// </summary>
        [EnumMember(Value = ("aaa"))]
        Aaa,
        /// <summary>
        /// apca
        /// </summary>
        [EnumMember(Value = ("apca"))]
        Apca
    }

    /// <summary>
    /// Configuration data for the highlighting of page elements.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class HighlightConfig : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Whether the node info tooltip should be shown (default: false).
        /// </summary>
        [DataMember(Name = ("showInfo"), IsRequired = (false))]
        public bool? ShowInfo
        {
            get;
            set;
        }

        /// <summary>
        /// Whether the node styles in the tooltip (default: false).
        /// </summary>
        [DataMember(Name = ("showStyles"), IsRequired = (false))]
        public bool? ShowStyles
        {
            get;
            set;
        }

        /// <summary>
        /// Whether the rulers should be shown (default: false).
        /// </summary>
        [DataMember(Name = ("showRulers"), IsRequired = (false))]
        public bool? ShowRulers
        {
            get;
            set;
        }

        /// <summary>
        /// Whether the a11y info should be shown (default: true).
        /// </summary>
        [DataMember(Name = ("showAccessibilityInfo"), IsRequired = (false))]
        public bool? ShowAccessibilityInfo
        {
            get;
            set;
        }

        /// <summary>
        /// Whether the extension lines from node to the rulers should be shown (default: false).
        /// </summary>
        [DataMember(Name = ("showExtensionLines"), IsRequired = (false))]
        public bool? ShowExtensionLines
        {
            get;
            set;
        }

        /// <summary>
        /// The content box highlight fill color (default: transparent).
        /// </summary>
        [DataMember(Name = ("contentColor"), IsRequired = (false))]
        public CefSharp.DevTools.DOM.RGBA ContentColor
        {
            get;
            set;
        }

        /// <summary>
        /// The padding highlight fill color (default: transparent).
        /// </summary>
        [DataMember(Name = ("paddingColor"), IsRequired = (false))]
        public CefSharp.DevTools.DOM.RGBA PaddingColor
        {
            get;
            set;
        }

        /// <summary>
        /// The border highlight fill color (default: transparent).
        /// </summary>
        [DataMember(Name = ("borderColor"), IsRequired = (false))]
        public CefSharp.DevTools.DOM.RGBA BorderColor
        {
            get;
            set;
        }

        /// <summary>
        /// The margin highlight fill color (default: transparent).
        /// </summary>
        [DataMember(Name = ("marginColor"), IsRequired = (false))]
        public CefSharp.DevTools.DOM.RGBA MarginColor
        {
            get;
            set;
        }

        /// <summary>
        /// The event target element highlight fill color (default: transparent).
        /// </summary>
        [DataMember(Name = ("eventTargetColor"), IsRequired = (false))]
        public CefSharp.DevTools.DOM.RGBA EventTargetColor
        {
            get;
            set;
        }

        /// <summary>
        /// The shape outside fill color (default: transparent).
        /// </summary>
        [DataMember(Name = ("shapeColor"), IsRequired = (false))]
        public CefSharp.DevTools.DOM.RGBA ShapeColor
        {
            get;
            set;
        }

        /// <summary>
        /// The shape margin fill color (default: transparent).
        /// </summary>
        [DataMember(Name = ("shapeMarginColor"), IsRequired = (false))]
        public CefSharp.DevTools.DOM.RGBA ShapeMarginColor
        {
            get;
            set;
        }

        /// <summary>
        /// The grid layout color (default: transparent).
        /// </summary>
        [DataMember(Name = ("cssGridColor"), IsRequired = (false))]
        public CefSharp.DevTools.DOM.RGBA CssGridColor
        {
            get;
            set;
        }

        /// <summary>
        /// The color format used to format color styles (default: hex).
        /// </summary>
        public CefSharp.DevTools.Overlay.ColorFormat? ColorFormat
        {
            get
            {
                return (CefSharp.DevTools.Overlay.ColorFormat? )(StringToEnum(typeof(CefSharp.DevTools.Overlay.ColorFormat? ), colorFormat));
            }

            set
            {
                this.colorFormat = (EnumToString(value));
            }
        }

        /// <summary>
        /// The color format used to format color styles (default: hex).
        /// </summary>
        [DataMember(Name = ("colorFormat"), IsRequired = (false))]
        internal string colorFormat
        {
            get;
            set;
        }

        /// <summary>
        /// The grid layout highlight configuration (default: all transparent).
        /// </summary>
        [DataMember(Name = ("gridHighlightConfig"), IsRequired = (false))]
        public CefSharp.DevTools.Overlay.GridHighlightConfig GridHighlightConfig
        {
            get;
            set;
        }

        /// <summary>
        /// The flex container highlight configuration (default: all transparent).
        /// </summary>
        [DataMember(Name = ("flexContainerHighlightConfig"), IsRequired = (false))]
        public CefSharp.DevTools.Overlay.FlexContainerHighlightConfig FlexContainerHighlightConfig
        {
            get;
            set;
        }

        /// <summary>
        /// The flex item highlight configuration (default: all transparent).
        /// </summary>
        [DataMember(Name = ("flexItemHighlightConfig"), IsRequired = (false))]
        public CefSharp.DevTools.Overlay.FlexItemHighlightConfig FlexItemHighlightConfig
        {
            get;
            set;
        }

        /// <summary>
        /// The contrast algorithm to use for the contrast ratio (default: aa).
        /// </summary>
        public CefSharp.DevTools.Overlay.ContrastAlgorithm? ContrastAlgorithm
        {
            get
            {
                return (CefSharp.DevTools.Overlay.ContrastAlgorithm? )(StringToEnum(typeof(CefSharp.DevTools.Overlay.ContrastAlgorithm? ), contrastAlgorithm));
            }

            set
            {
                this.contrastAlgorithm = (EnumToString(value));
            }
        }

        /// <summary>
        /// The contrast algorithm to use for the contrast ratio (default: aa).
        /// </summary>
        [DataMember(Name = ("contrastAlgorithm"), IsRequired = (false))]
        internal string contrastAlgorithm
        {
            get;
            set;
        }

        /// <summary>
        /// The container query container highlight configuration (default: all transparent).
        /// </summary>
        [DataMember(Name = ("containerQueryContainerHighlightConfig"), IsRequired = (false))]
        public CefSharp.DevTools.Overlay.ContainerQueryContainerHighlightConfig ContainerQueryContainerHighlightConfig
        {
            get;
            set;
        }
    }

    /// <summary>
    /// ColorFormat
    /// </summary>
    public enum ColorFormat
    {
        /// <summary>
        /// rgb
        /// </summary>
        [EnumMember(Value = ("rgb"))]
        Rgb,
        /// <summary>
        /// hsl
        /// </summary>
        [EnumMember(Value = ("hsl"))]
        Hsl,
        /// <summary>
        /// hwb
        /// </summary>
        [EnumMember(Value = ("hwb"))]
        Hwb,
        /// <summary>
        /// hex
        /// </summary>
        [EnumMember(Value = ("hex"))]
        Hex
    }

    /// <summary>
    /// Configurations for Persistent Grid Highlight
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class GridNodeHighlightConfig : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// A descriptor for the highlight appearance.
        /// </summary>
        [DataMember(Name = ("gridHighlightConfig"), IsRequired = (true))]
        public CefSharp.DevTools.Overlay.GridHighlightConfig GridHighlightConfig
        {
            get;
            set;
        }

        /// <summary>
        /// Identifier of the node to highlight.
        /// </summary>
        [DataMember(Name = ("nodeId"), IsRequired = (true))]
        public int NodeId
        {
            get;
            set;
        }
    }

    /// <summary>
    /// FlexNodeHighlightConfig
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class FlexNodeHighlightConfig : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// A descriptor for the highlight appearance of flex containers.
        /// </summary>
        [DataMember(Name = ("flexContainerHighlightConfig"), IsRequired = (true))]
        public CefSharp.DevTools.Overlay.FlexContainerHighlightConfig FlexContainerHighlightConfig
        {
            get;
            set;
        }

        /// <summary>
        /// Identifier of the node to highlight.
        /// </summary>
        [DataMember(Name = ("nodeId"), IsRequired = (true))]
        public int NodeId
        {
            get;
            set;
        }
    }

    /// <summary>
    /// ScrollSnapContainerHighlightConfig
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class ScrollSnapContainerHighlightConfig : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The style of the snapport border (default: transparent)
        /// </summary>
        [DataMember(Name = ("snapportBorder"), IsRequired = (false))]
        public CefSharp.DevTools.Overlay.LineStyle SnapportBorder
        {
            get;
            set;
        }

        /// <summary>
        /// The style of the snap area border (default: transparent)
        /// </summary>
        [DataMember(Name = ("snapAreaBorder"), IsRequired = (false))]
        public CefSharp.DevTools.Overlay.LineStyle SnapAreaBorder
        {
            get;
            set;
        }

        /// <summary>
        /// The margin highlight fill color (default: transparent).
        /// </summary>
        [DataMember(Name = ("scrollMarginColor"), IsRequired = (false))]
        public CefSharp.DevTools.DOM.RGBA ScrollMarginColor
        {
            get;
            set;
        }

        /// <summary>
        /// The padding highlight fill color (default: transparent).
        /// </summary>
        [DataMember(Name = ("scrollPaddingColor"), IsRequired = (false))]
        public CefSharp.DevTools.DOM.RGBA ScrollPaddingColor
        {
            get;
            set;
        }
    }

    /// <summary>
    /// ScrollSnapHighlightConfig
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class ScrollSnapHighlightConfig : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// A descriptor for the highlight appearance of scroll snap containers.
        /// </summary>
        [DataMember(Name = ("scrollSnapContainerHighlightConfig"), IsRequired = (true))]
        public CefSharp.DevTools.Overlay.ScrollSnapContainerHighlightConfig ScrollSnapContainerHighlightConfig
        {
            get;
            set;
        }

        /// <summary>
        /// Identifier of the node to highlight.
        /// </summary>
        [DataMember(Name = ("nodeId"), IsRequired = (true))]
        public int NodeId
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Configuration for dual screen hinge
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class HingeConfig : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// A rectangle represent hinge
        /// </summary>
        [DataMember(Name = ("rect"), IsRequired = (true))]
        public CefSharp.DevTools.DOM.Rect Rect
        {
            get;
            set;
        }

        /// <summary>
        /// The content box highlight fill color (default: a dark color).
        /// </summary>
        [DataMember(Name = ("contentColor"), IsRequired = (false))]
        public CefSharp.DevTools.DOM.RGBA ContentColor
        {
            get;
            set;
        }

        /// <summary>
        /// The content box highlight outline color (default: transparent).
        /// </summary>
        [DataMember(Name = ("outlineColor"), IsRequired = (false))]
        public CefSharp.DevTools.DOM.RGBA OutlineColor
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Configuration for Window Controls Overlay
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class WindowControlsOverlayConfig : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Whether the title bar CSS should be shown when emulating the Window Controls Overlay.
        /// </summary>
        [DataMember(Name = ("showCSS"), IsRequired = (true))]
        public bool ShowCSS
        {
            get;
            set;
        }

        /// <summary>
        /// Selected platforms to show the overlay.
        /// </summary>
        [DataMember(Name = ("selectedPlatform"), IsRequired = (true))]
        public string SelectedPlatform
        {
            get;
            set;
        }

        /// <summary>
        /// The theme color defined in app manifest.
        /// </summary>
        [DataMember(Name = ("themeColor"), IsRequired = (true))]
        public string ThemeColor
        {
            get;
            set;
        }
    }

    /// <summary>
    /// ContainerQueryHighlightConfig
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class ContainerQueryHighlightConfig : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// A descriptor for the highlight appearance of container query containers.
        /// </summary>
        [DataMember(Name = ("containerQueryContainerHighlightConfig"), IsRequired = (true))]
        public CefSharp.DevTools.Overlay.ContainerQueryContainerHighlightConfig ContainerQueryContainerHighlightConfig
        {
            get;
            set;
        }

        /// <summary>
        /// Identifier of the container node to highlight.
        /// </summary>
        [DataMember(Name = ("nodeId"), IsRequired = (true))]
        public int NodeId
        {
            get;
            set;
        }
    }

    /// <summary>
    /// ContainerQueryContainerHighlightConfig
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class ContainerQueryContainerHighlightConfig : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The style of the container border.
        /// </summary>
        [DataMember(Name = ("containerBorder"), IsRequired = (false))]
        public CefSharp.DevTools.Overlay.LineStyle ContainerBorder
        {
            get;
            set;
        }

        /// <summary>
        /// The style of the descendants&apos; borders.
        /// </summary>
        [DataMember(Name = ("descendantBorder"), IsRequired = (false))]
        public CefSharp.DevTools.Overlay.LineStyle DescendantBorder
        {
            get;
            set;
        }
    }

    /// <summary>
    /// IsolatedElementHighlightConfig
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class IsolatedElementHighlightConfig : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// A descriptor for the highlight appearance of an element in isolation mode.
        /// </summary>
        [DataMember(Name = ("isolationModeHighlightConfig"), IsRequired = (true))]
        public CefSharp.DevTools.Overlay.IsolationModeHighlightConfig IsolationModeHighlightConfig
        {
            get;
            set;
        }

        /// <summary>
        /// Identifier of the isolated element to highlight.
        /// </summary>
        [DataMember(Name = ("nodeId"), IsRequired = (true))]
        public int NodeId
        {
            get;
            set;
        }
    }

    /// <summary>
    /// IsolationModeHighlightConfig
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class IsolationModeHighlightConfig : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The fill color of the resizers (default: transparent).
        /// </summary>
        [DataMember(Name = ("resizerColor"), IsRequired = (false))]
        public CefSharp.DevTools.DOM.RGBA ResizerColor
        {
            get;
            set;
        }

        /// <summary>
        /// The fill color for resizer handles (default: transparent).
        /// </summary>
        [DataMember(Name = ("resizerHandleColor"), IsRequired = (false))]
        public CefSharp.DevTools.DOM.RGBA ResizerHandleColor
        {
            get;
            set;
        }

        /// <summary>
        /// The fill color for the mask covering non-isolated elements (default: transparent).
        /// </summary>
        [DataMember(Name = ("maskColor"), IsRequired = (false))]
        public CefSharp.DevTools.DOM.RGBA MaskColor
        {
            get;
            set;
        }
    }

    /// <summary>
    /// InspectMode
    /// </summary>
    public enum InspectMode
    {
        /// <summary>
        /// searchForNode
        /// </summary>
        [EnumMember(Value = ("searchForNode"))]
        SearchForNode,
        /// <summary>
        /// searchForUAShadowDOM
        /// </summary>
        [EnumMember(Value = ("searchForUAShadowDOM"))]
        SearchForUAShadowDOM,
        /// <summary>
        /// captureAreaScreenshot
        /// </summary>
        [EnumMember(Value = ("captureAreaScreenshot"))]
        CaptureAreaScreenshot,
        /// <summary>
        /// showDistances
        /// </summary>
        [EnumMember(Value = ("showDistances"))]
        ShowDistances,
        /// <summary>
        /// none
        /// </summary>
        [EnumMember(Value = ("none"))]
        None
    }

    /// <summary>
    /// Fired when the node should be inspected. This happens after call to `setInspectMode` or when
    /// user manually inspects an element.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class InspectNodeRequestedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Id of the node to inspect.
        /// </summary>
        [DataMember(Name = ("backendNodeId"), IsRequired = (true))]
        public int BackendNodeId
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired when the node should be highlighted. This happens after call to `setInspectMode`.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class NodeHighlightRequestedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// NodeId
        /// </summary>
        [DataMember(Name = ("nodeId"), IsRequired = (true))]
        public int NodeId
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired when user asks to capture screenshot of some area on the page.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class ScreenshotRequestedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Viewport to capture, in device independent pixels (dip).
        /// </summary>
        [DataMember(Name = ("viewport"), IsRequired = (true))]
        public CefSharp.DevTools.Page.Viewport Viewport
        {
            get;
            private set;
        }
    }
}

namespace CefSharp.DevTools.Page
{
    /// <summary>
    /// Indicates whether a frame has been identified as an ad.
    /// </summary>
    public enum AdFrameType
    {
        /// <summary>
        /// none
        /// </summary>
        [EnumMember(Value = ("none"))]
        None,
        /// <summary>
        /// child
        /// </summary>
        [EnumMember(Value = ("child"))]
        Child,
        /// <summary>
        /// root
        /// </summary>
        [EnumMember(Value = ("root"))]
        Root
    }

    /// <summary>
    /// AdFrameExplanation
    /// </summary>
    public enum AdFrameExplanation
    {
        /// <summary>
        /// ParentIsAd
        /// </summary>
        [EnumMember(Value = ("ParentIsAd"))]
        ParentIsAd,
        /// <summary>
        /// CreatedByAdScript
        /// </summary>
        [EnumMember(Value = ("CreatedByAdScript"))]
        CreatedByAdScript,
        /// <summary>
        /// MatchedBlockingRule
        /// </summary>
        [EnumMember(Value = ("MatchedBlockingRule"))]
        MatchedBlockingRule
    }

    /// <summary>
    /// Indicates whether a frame has been identified as an ad and why.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class AdFrameStatus : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// AdFrameType
        /// </summary>
        public CefSharp.DevTools.Page.AdFrameType AdFrameType
        {
            get
            {
                return (CefSharp.DevTools.Page.AdFrameType)(StringToEnum(typeof(CefSharp.DevTools.Page.AdFrameType), adFrameType));
            }

            set
            {
                this.adFrameType = (EnumToString(value));
            }
        }

        /// <summary>
        /// AdFrameType
        /// </summary>
        [DataMember(Name = ("adFrameType"), IsRequired = (true))]
        internal string adFrameType
        {
            get;
            set;
        }

        /// <summary>
        /// Explanations
        /// </summary>
        public CefSharp.DevTools.Page.AdFrameExplanation[] Explanations
        {
            get
            {
                return (CefSharp.DevTools.Page.AdFrameExplanation[])(StringToEnum(typeof(CefSharp.DevTools.Page.AdFrameExplanation[]), explanations));
            }

            set
            {
                this.explanations = (EnumToString(value));
            }
        }

        /// <summary>
        /// Explanations
        /// </summary>
        [DataMember(Name = ("explanations"), IsRequired = (false))]
        internal string explanations
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Identifies the bottom-most script which caused the frame to be labelled
    /// as an ad.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class AdScriptId : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Script Id of the bottom-most script which caused the frame to be labelled
        /// as an ad.
        /// </summary>
        [DataMember(Name = ("scriptId"), IsRequired = (true))]
        public string ScriptId
        {
            get;
            set;
        }

        /// <summary>
        /// Id of adScriptId&apos;s debugger.
        /// </summary>
        [DataMember(Name = ("debuggerId"), IsRequired = (true))]
        public string DebuggerId
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Indicates whether the frame is a secure context and why it is the case.
    /// </summary>
    public enum SecureContextType
    {
        /// <summary>
        /// Secure
        /// </summary>
        [EnumMember(Value = ("Secure"))]
        Secure,
        /// <summary>
        /// SecureLocalhost
        /// </summary>
        [EnumMember(Value = ("SecureLocalhost"))]
        SecureLocalhost,
        /// <summary>
        /// InsecureScheme
        /// </summary>
        [EnumMember(Value = ("InsecureScheme"))]
        InsecureScheme,
        /// <summary>
        /// InsecureAncestor
        /// </summary>
        [EnumMember(Value = ("InsecureAncestor"))]
        InsecureAncestor
    }

    /// <summary>
    /// Indicates whether the frame is cross-origin isolated and why it is the case.
    /// </summary>
    public enum CrossOriginIsolatedContextType
    {
        /// <summary>
        /// Isolated
        /// </summary>
        [EnumMember(Value = ("Isolated"))]
        Isolated,
        /// <summary>
        /// NotIsolated
        /// </summary>
        [EnumMember(Value = ("NotIsolated"))]
        NotIsolated,
        /// <summary>
        /// NotIsolatedFeatureDisabled
        /// </summary>
        [EnumMember(Value = ("NotIsolatedFeatureDisabled"))]
        NotIsolatedFeatureDisabled
    }

    /// <summary>
    /// GatedAPIFeatures
    /// </summary>
    public enum GatedAPIFeatures
    {
        /// <summary>
        /// SharedArrayBuffers
        /// </summary>
        [EnumMember(Value = ("SharedArrayBuffers"))]
        SharedArrayBuffers,
        /// <summary>
        /// SharedArrayBuffersTransferAllowed
        /// </summary>
        [EnumMember(Value = ("SharedArrayBuffersTransferAllowed"))]
        SharedArrayBuffersTransferAllowed,
        /// <summary>
        /// PerformanceMeasureMemory
        /// </summary>
        [EnumMember(Value = ("PerformanceMeasureMemory"))]
        PerformanceMeasureMemory,
        /// <summary>
        /// PerformanceProfile
        /// </summary>
        [EnumMember(Value = ("PerformanceProfile"))]
        PerformanceProfile
    }

    /// <summary>
    /// All Permissions Policy features. This enum should match the one defined
    /// in third_party/blink/renderer/core/permissions_policy/permissions_policy_features.json5.
    /// </summary>
    public enum PermissionsPolicyFeature
    {
        /// <summary>
        /// accelerometer
        /// </summary>
        [EnumMember(Value = ("accelerometer"))]
        Accelerometer,
        /// <summary>
        /// all-screens-capture
        /// </summary>
        [EnumMember(Value = ("all-screens-capture"))]
        AllScreensCapture,
        /// <summary>
        /// ambient-light-sensor
        /// </summary>
        [EnumMember(Value = ("ambient-light-sensor"))]
        AmbientLightSensor,
        /// <summary>
        /// attribution-reporting
        /// </summary>
        [EnumMember(Value = ("attribution-reporting"))]
        AttributionReporting,
        /// <summary>
        /// autoplay
        /// </summary>
        [EnumMember(Value = ("autoplay"))]
        Autoplay,
        /// <summary>
        /// bluetooth
        /// </summary>
        [EnumMember(Value = ("bluetooth"))]
        Bluetooth,
        /// <summary>
        /// browsing-topics
        /// </summary>
        [EnumMember(Value = ("browsing-topics"))]
        BrowsingTopics,
        /// <summary>
        /// camera
        /// </summary>
        [EnumMember(Value = ("camera"))]
        Camera,
        /// <summary>
        /// captured-surface-control
        /// </summary>
        [EnumMember(Value = ("captured-surface-control"))]
        CapturedSurfaceControl,
        /// <summary>
        /// ch-dpr
        /// </summary>
        [EnumMember(Value = ("ch-dpr"))]
        ChDpr,
        /// <summary>
        /// ch-device-memory
        /// </summary>
        [EnumMember(Value = ("ch-device-memory"))]
        ChDeviceMemory,
        /// <summary>
        /// ch-downlink
        /// </summary>
        [EnumMember(Value = ("ch-downlink"))]
        ChDownlink,
        /// <summary>
        /// ch-ect
        /// </summary>
        [EnumMember(Value = ("ch-ect"))]
        ChEct,
        /// <summary>
        /// ch-prefers-color-scheme
        /// </summary>
        [EnumMember(Value = ("ch-prefers-color-scheme"))]
        ChPrefersColorScheme,
        /// <summary>
        /// ch-prefers-reduced-motion
        /// </summary>
        [EnumMember(Value = ("ch-prefers-reduced-motion"))]
        ChPrefersReducedMotion,
        /// <summary>
        /// ch-prefers-reduced-transparency
        /// </summary>
        [EnumMember(Value = ("ch-prefers-reduced-transparency"))]
        ChPrefersReducedTransparency,
        /// <summary>
        /// ch-rtt
        /// </summary>
        [EnumMember(Value = ("ch-rtt"))]
        ChRtt,
        /// <summary>
        /// ch-save-data
        /// </summary>
        [EnumMember(Value = ("ch-save-data"))]
        ChSaveData,
        /// <summary>
        /// ch-ua
        /// </summary>
        [EnumMember(Value = ("ch-ua"))]
        ChUa,
        /// <summary>
        /// ch-ua-arch
        /// </summary>
        [EnumMember(Value = ("ch-ua-arch"))]
        ChUaArch,
        /// <summary>
        /// ch-ua-bitness
        /// </summary>
        [EnumMember(Value = ("ch-ua-bitness"))]
        ChUaBitness,
        /// <summary>
        /// ch-ua-platform
        /// </summary>
        [EnumMember(Value = ("ch-ua-platform"))]
        ChUaPlatform,
        /// <summary>
        /// ch-ua-model
        /// </summary>
        [EnumMember(Value = ("ch-ua-model"))]
        ChUaModel,
        /// <summary>
        /// ch-ua-mobile
        /// </summary>
        [EnumMember(Value = ("ch-ua-mobile"))]
        ChUaMobile,
        /// <summary>
        /// ch-ua-form-factors
        /// </summary>
        [EnumMember(Value = ("ch-ua-form-factors"))]
        ChUaFormFactors,
        /// <summary>
        /// ch-ua-full-version
        /// </summary>
        [EnumMember(Value = ("ch-ua-full-version"))]
        ChUaFullVersion,
        /// <summary>
        /// ch-ua-full-version-list
        /// </summary>
        [EnumMember(Value = ("ch-ua-full-version-list"))]
        ChUaFullVersionList,
        /// <summary>
        /// ch-ua-platform-version
        /// </summary>
        [EnumMember(Value = ("ch-ua-platform-version"))]
        ChUaPlatformVersion,
        /// <summary>
        /// ch-ua-wow64
        /// </summary>
        [EnumMember(Value = ("ch-ua-wow64"))]
        ChUaWow64,
        /// <summary>
        /// ch-viewport-height
        /// </summary>
        [EnumMember(Value = ("ch-viewport-height"))]
        ChViewportHeight,
        /// <summary>
        /// ch-viewport-width
        /// </summary>
        [EnumMember(Value = ("ch-viewport-width"))]
        ChViewportWidth,
        /// <summary>
        /// ch-width
        /// </summary>
        [EnumMember(Value = ("ch-width"))]
        ChWidth,
        /// <summary>
        /// clipboard-read
        /// </summary>
        [EnumMember(Value = ("clipboard-read"))]
        ClipboardRead,
        /// <summary>
        /// clipboard-write
        /// </summary>
        [EnumMember(Value = ("clipboard-write"))]
        ClipboardWrite,
        /// <summary>
        /// compute-pressure
        /// </summary>
        [EnumMember(Value = ("compute-pressure"))]
        ComputePressure,
        /// <summary>
        /// cross-origin-isolated
        /// </summary>
        [EnumMember(Value = ("cross-origin-isolated"))]
        CrossOriginIsolated,
        /// <summary>
        /// deferred-fetch
        /// </summary>
        [EnumMember(Value = ("deferred-fetch"))]
        DeferredFetch,
        /// <summary>
        /// digital-credentials-get
        /// </summary>
        [EnumMember(Value = ("digital-credentials-get"))]
        DigitalCredentialsGet,
        /// <summary>
        /// direct-sockets
        /// </summary>
        [EnumMember(Value = ("direct-sockets"))]
        DirectSockets,
        /// <summary>
        /// display-capture
        /// </summary>
        [EnumMember(Value = ("display-capture"))]
        DisplayCapture,
        /// <summary>
        /// document-domain
        /// </summary>
        [EnumMember(Value = ("document-domain"))]
        DocumentDomain,
        /// <summary>
        /// encrypted-media
        /// </summary>
        [EnumMember(Value = ("encrypted-media"))]
        EncryptedMedia,
        /// <summary>
        /// execution-while-out-of-viewport
        /// </summary>
        [EnumMember(Value = ("execution-while-out-of-viewport"))]
        ExecutionWhileOutOfViewport,
        /// <summary>
        /// execution-while-not-rendered
        /// </summary>
        [EnumMember(Value = ("execution-while-not-rendered"))]
        ExecutionWhileNotRendered,
        /// <summary>
        /// focus-without-user-activation
        /// </summary>
        [EnumMember(Value = ("focus-without-user-activation"))]
        FocusWithoutUserActivation,
        /// <summary>
        /// fullscreen
        /// </summary>
        [EnumMember(Value = ("fullscreen"))]
        Fullscreen,
        /// <summary>
        /// frobulate
        /// </summary>
        [EnumMember(Value = ("frobulate"))]
        Frobulate,
        /// <summary>
        /// gamepad
        /// </summary>
        [EnumMember(Value = ("gamepad"))]
        Gamepad,
        /// <summary>
        /// geolocation
        /// </summary>
        [EnumMember(Value = ("geolocation"))]
        Geolocation,
        /// <summary>
        /// gyroscope
        /// </summary>
        [EnumMember(Value = ("gyroscope"))]
        Gyroscope,
        /// <summary>
        /// hid
        /// </summary>
        [EnumMember(Value = ("hid"))]
        Hid,
        /// <summary>
        /// identity-credentials-get
        /// </summary>
        [EnumMember(Value = ("identity-credentials-get"))]
        IdentityCredentialsGet,
        /// <summary>
        /// idle-detection
        /// </summary>
        [EnumMember(Value = ("idle-detection"))]
        IdleDetection,
        /// <summary>
        /// interest-cohort
        /// </summary>
        [EnumMember(Value = ("interest-cohort"))]
        InterestCohort,
        /// <summary>
        /// join-ad-interest-group
        /// </summary>
        [EnumMember(Value = ("join-ad-interest-group"))]
        JoinAdInterestGroup,
        /// <summary>
        /// keyboard-map
        /// </summary>
        [EnumMember(Value = ("keyboard-map"))]
        KeyboardMap,
        /// <summary>
        /// local-fonts
        /// </summary>
        [EnumMember(Value = ("local-fonts"))]
        LocalFonts,
        /// <summary>
        /// magnetometer
        /// </summary>
        [EnumMember(Value = ("magnetometer"))]
        Magnetometer,
        /// <summary>
        /// media-playback-while-not-visible
        /// </summary>
        [EnumMember(Value = ("media-playback-while-not-visible"))]
        MediaPlaybackWhileNotVisible,
        /// <summary>
        /// microphone
        /// </summary>
        [EnumMember(Value = ("microphone"))]
        Microphone,
        /// <summary>
        /// midi
        /// </summary>
        [EnumMember(Value = ("midi"))]
        Midi,
        /// <summary>
        /// otp-credentials
        /// </summary>
        [EnumMember(Value = ("otp-credentials"))]
        OtpCredentials,
        /// <summary>
        /// payment
        /// </summary>
        [EnumMember(Value = ("payment"))]
        Payment,
        /// <summary>
        /// picture-in-picture
        /// </summary>
        [EnumMember(Value = ("picture-in-picture"))]
        PictureInPicture,
        /// <summary>
        /// private-aggregation
        /// </summary>
        [EnumMember(Value = ("private-aggregation"))]
        PrivateAggregation,
        /// <summary>
        /// private-state-token-issuance
        /// </summary>
        [EnumMember(Value = ("private-state-token-issuance"))]
        PrivateStateTokenIssuance,
        /// <summary>
        /// private-state-token-redemption
        /// </summary>
        [EnumMember(Value = ("private-state-token-redemption"))]
        PrivateStateTokenRedemption,
        /// <summary>
        /// publickey-credentials-create
        /// </summary>
        [EnumMember(Value = ("publickey-credentials-create"))]
        PublickeyCredentialsCreate,
        /// <summary>
        /// publickey-credentials-get
        /// </summary>
        [EnumMember(Value = ("publickey-credentials-get"))]
        PublickeyCredentialsGet,
        /// <summary>
        /// run-ad-auction
        /// </summary>
        [EnumMember(Value = ("run-ad-auction"))]
        RunAdAuction,
        /// <summary>
        /// screen-wake-lock
        /// </summary>
        [EnumMember(Value = ("screen-wake-lock"))]
        ScreenWakeLock,
        /// <summary>
        /// serial
        /// </summary>
        [EnumMember(Value = ("serial"))]
        Serial,
        /// <summary>
        /// shared-autofill
        /// </summary>
        [EnumMember(Value = ("shared-autofill"))]
        SharedAutofill,
        /// <summary>
        /// shared-storage
        /// </summary>
        [EnumMember(Value = ("shared-storage"))]
        SharedStorage,
        /// <summary>
        /// shared-storage-select-url
        /// </summary>
        [EnumMember(Value = ("shared-storage-select-url"))]
        SharedStorageSelectUrl,
        /// <summary>
        /// smart-card
        /// </summary>
        [EnumMember(Value = ("smart-card"))]
        SmartCard,
        /// <summary>
        /// speaker-selection
        /// </summary>
        [EnumMember(Value = ("speaker-selection"))]
        SpeakerSelection,
        /// <summary>
        /// storage-access
        /// </summary>
        [EnumMember(Value = ("storage-access"))]
        StorageAccess,
        /// <summary>
        /// sub-apps
        /// </summary>
        [EnumMember(Value = ("sub-apps"))]
        SubApps,
        /// <summary>
        /// sync-xhr
        /// </summary>
        [EnumMember(Value = ("sync-xhr"))]
        SyncXhr,
        /// <summary>
        /// unload
        /// </summary>
        [EnumMember(Value = ("unload"))]
        Unload,
        /// <summary>
        /// usb
        /// </summary>
        [EnumMember(Value = ("usb"))]
        Usb,
        /// <summary>
        /// usb-unrestricted
        /// </summary>
        [EnumMember(Value = ("usb-unrestricted"))]
        UsbUnrestricted,
        /// <summary>
        /// vertical-scroll
        /// </summary>
        [EnumMember(Value = ("vertical-scroll"))]
        VerticalScroll,
        /// <summary>
        /// web-printing
        /// </summary>
        [EnumMember(Value = ("web-printing"))]
        WebPrinting,
        /// <summary>
        /// web-share
        /// </summary>
        [EnumMember(Value = ("web-share"))]
        WebShare,
        /// <summary>
        /// window-management
        /// </summary>
        [EnumMember(Value = ("window-management"))]
        WindowManagement,
        /// <summary>
        /// xr-spatial-tracking
        /// </summary>
        [EnumMember(Value = ("xr-spatial-tracking"))]
        XrSpatialTracking
    }

    /// <summary>
    /// Reason for a permissions policy feature to be disabled.
    /// </summary>
    public enum PermissionsPolicyBlockReason
    {
        /// <summary>
        /// Header
        /// </summary>
        [EnumMember(Value = ("Header"))]
        Header,
        /// <summary>
        /// IframeAttribute
        /// </summary>
        [EnumMember(Value = ("IframeAttribute"))]
        IframeAttribute,
        /// <summary>
        /// InFencedFrameTree
        /// </summary>
        [EnumMember(Value = ("InFencedFrameTree"))]
        InFencedFrameTree,
        /// <summary>
        /// InIsolatedApp
        /// </summary>
        [EnumMember(Value = ("InIsolatedApp"))]
        InIsolatedApp
    }

    /// <summary>
    /// PermissionsPolicyBlockLocator
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class PermissionsPolicyBlockLocator : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// FrameId
        /// </summary>
        [DataMember(Name = ("frameId"), IsRequired = (true))]
        public string FrameId
        {
            get;
            set;
        }

        /// <summary>
        /// BlockReason
        /// </summary>
        public CefSharp.DevTools.Page.PermissionsPolicyBlockReason BlockReason
        {
            get
            {
                return (CefSharp.DevTools.Page.PermissionsPolicyBlockReason)(StringToEnum(typeof(CefSharp.DevTools.Page.PermissionsPolicyBlockReason), blockReason));
            }

            set
            {
                this.blockReason = (EnumToString(value));
            }
        }

        /// <summary>
        /// BlockReason
        /// </summary>
        [DataMember(Name = ("blockReason"), IsRequired = (true))]
        internal string blockReason
        {
            get;
            set;
        }
    }

    /// <summary>
    /// PermissionsPolicyFeatureState
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class PermissionsPolicyFeatureState : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Feature
        /// </summary>
        public CefSharp.DevTools.Page.PermissionsPolicyFeature Feature
        {
            get
            {
                return (CefSharp.DevTools.Page.PermissionsPolicyFeature)(StringToEnum(typeof(CefSharp.DevTools.Page.PermissionsPolicyFeature), feature));
            }

            set
            {
                this.feature = (EnumToString(value));
            }
        }

        /// <summary>
        /// Feature
        /// </summary>
        [DataMember(Name = ("feature"), IsRequired = (true))]
        internal string feature
        {
            get;
            set;
        }

        /// <summary>
        /// Allowed
        /// </summary>
        [DataMember(Name = ("allowed"), IsRequired = (true))]
        public bool Allowed
        {
            get;
            set;
        }

        /// <summary>
        /// Locator
        /// </summary>
        [DataMember(Name = ("locator"), IsRequired = (false))]
        public CefSharp.DevTools.Page.PermissionsPolicyBlockLocator Locator
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Origin Trial(https://www.chromium.org/blink/origin-trials) support.
    /// Status for an Origin Trial token.
    /// </summary>
    public enum OriginTrialTokenStatus
    {
        /// <summary>
        /// Success
        /// </summary>
        [EnumMember(Value = ("Success"))]
        Success,
        /// <summary>
        /// NotSupported
        /// </summary>
        [EnumMember(Value = ("NotSupported"))]
        NotSupported,
        /// <summary>
        /// Insecure
        /// </summary>
        [EnumMember(Value = ("Insecure"))]
        Insecure,
        /// <summary>
        /// Expired
        /// </summary>
        [EnumMember(Value = ("Expired"))]
        Expired,
        /// <summary>
        /// WrongOrigin
        /// </summary>
        [EnumMember(Value = ("WrongOrigin"))]
        WrongOrigin,
        /// <summary>
        /// InvalidSignature
        /// </summary>
        [EnumMember(Value = ("InvalidSignature"))]
        InvalidSignature,
        /// <summary>
        /// Malformed
        /// </summary>
        [EnumMember(Value = ("Malformed"))]
        Malformed,
        /// <summary>
        /// WrongVersion
        /// </summary>
        [EnumMember(Value = ("WrongVersion"))]
        WrongVersion,
        /// <summary>
        /// FeatureDisabled
        /// </summary>
        [EnumMember(Value = ("FeatureDisabled"))]
        FeatureDisabled,
        /// <summary>
        /// TokenDisabled
        /// </summary>
        [EnumMember(Value = ("TokenDisabled"))]
        TokenDisabled,
        /// <summary>
        /// FeatureDisabledForUser
        /// </summary>
        [EnumMember(Value = ("FeatureDisabledForUser"))]
        FeatureDisabledForUser,
        /// <summary>
        /// UnknownTrial
        /// </summary>
        [EnumMember(Value = ("UnknownTrial"))]
        UnknownTrial
    }

    /// <summary>
    /// Status for an Origin Trial.
    /// </summary>
    public enum OriginTrialStatus
    {
        /// <summary>
        /// Enabled
        /// </summary>
        [EnumMember(Value = ("Enabled"))]
        Enabled,
        /// <summary>
        /// ValidTokenNotProvided
        /// </summary>
        [EnumMember(Value = ("ValidTokenNotProvided"))]
        ValidTokenNotProvided,
        /// <summary>
        /// OSNotSupported
        /// </summary>
        [EnumMember(Value = ("OSNotSupported"))]
        OSNotSupported,
        /// <summary>
        /// TrialNotAllowed
        /// </summary>
        [EnumMember(Value = ("TrialNotAllowed"))]
        TrialNotAllowed
    }

    /// <summary>
    /// OriginTrialUsageRestriction
    /// </summary>
    public enum OriginTrialUsageRestriction
    {
        /// <summary>
        /// None
        /// </summary>
        [EnumMember(Value = ("None"))]
        None,
        /// <summary>
        /// Subset
        /// </summary>
        [EnumMember(Value = ("Subset"))]
        Subset
    }

    /// <summary>
    /// OriginTrialToken
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class OriginTrialToken : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Origin
        /// </summary>
        [DataMember(Name = ("origin"), IsRequired = (true))]
        public string Origin
        {
            get;
            set;
        }

        /// <summary>
        /// MatchSubDomains
        /// </summary>
        [DataMember(Name = ("matchSubDomains"), IsRequired = (true))]
        public bool MatchSubDomains
        {
            get;
            set;
        }

        /// <summary>
        /// TrialName
        /// </summary>
        [DataMember(Name = ("trialName"), IsRequired = (true))]
        public string TrialName
        {
            get;
            set;
        }

        /// <summary>
        /// ExpiryTime
        /// </summary>
        [DataMember(Name = ("expiryTime"), IsRequired = (true))]
        public double ExpiryTime
        {
            get;
            set;
        }

        /// <summary>
        /// IsThirdParty
        /// </summary>
        [DataMember(Name = ("isThirdParty"), IsRequired = (true))]
        public bool IsThirdParty
        {
            get;
            set;
        }

        /// <summary>
        /// UsageRestriction
        /// </summary>
        public CefSharp.DevTools.Page.OriginTrialUsageRestriction UsageRestriction
        {
            get
            {
                return (CefSharp.DevTools.Page.OriginTrialUsageRestriction)(StringToEnum(typeof(CefSharp.DevTools.Page.OriginTrialUsageRestriction), usageRestriction));
            }

            set
            {
                this.usageRestriction = (EnumToString(value));
            }
        }

        /// <summary>
        /// UsageRestriction
        /// </summary>
        [DataMember(Name = ("usageRestriction"), IsRequired = (true))]
        internal string usageRestriction
        {
            get;
            set;
        }
    }

    /// <summary>
    /// OriginTrialTokenWithStatus
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class OriginTrialTokenWithStatus : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// RawTokenText
        /// </summary>
        [DataMember(Name = ("rawTokenText"), IsRequired = (true))]
        public string RawTokenText
        {
            get;
            set;
        }

        /// <summary>
        /// `parsedToken` is present only when the token is extractable and
        /// parsable.
        /// </summary>
        [DataMember(Name = ("parsedToken"), IsRequired = (false))]
        public CefSharp.DevTools.Page.OriginTrialToken ParsedToken
        {
            get;
            set;
        }

        /// <summary>
        /// Status
        /// </summary>
        public CefSharp.DevTools.Page.OriginTrialTokenStatus Status
        {
            get
            {
                return (CefSharp.DevTools.Page.OriginTrialTokenStatus)(StringToEnum(typeof(CefSharp.DevTools.Page.OriginTrialTokenStatus), status));
            }

            set
            {
                this.status = (EnumToString(value));
            }
        }

        /// <summary>
        /// Status
        /// </summary>
        [DataMember(Name = ("status"), IsRequired = (true))]
        internal string status
        {
            get;
            set;
        }
    }

    /// <summary>
    /// OriginTrial
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class OriginTrial : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// TrialName
        /// </summary>
        [DataMember(Name = ("trialName"), IsRequired = (true))]
        public string TrialName
        {
            get;
            set;
        }

        /// <summary>
        /// Status
        /// </summary>
        public CefSharp.DevTools.Page.OriginTrialStatus Status
        {
            get
            {
                return (CefSharp.DevTools.Page.OriginTrialStatus)(StringToEnum(typeof(CefSharp.DevTools.Page.OriginTrialStatus), status));
            }

            set
            {
                this.status = (EnumToString(value));
            }
        }

        /// <summary>
        /// Status
        /// </summary>
        [DataMember(Name = ("status"), IsRequired = (true))]
        internal string status
        {
            get;
            set;
        }

        /// <summary>
        /// TokensWithStatus
        /// </summary>
        [DataMember(Name = ("tokensWithStatus"), IsRequired = (true))]
        public System.Collections.Generic.IList<CefSharp.DevTools.Page.OriginTrialTokenWithStatus> TokensWithStatus
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Information about the Frame on the page.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class Frame : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Frame unique identifier.
        /// </summary>
        [DataMember(Name = ("id"), IsRequired = (true))]
        public string Id
        {
            get;
            set;
        }

        /// <summary>
        /// Parent frame identifier.
        /// </summary>
        [DataMember(Name = ("parentId"), IsRequired = (false))]
        public string ParentId
        {
            get;
            set;
        }

        /// <summary>
        /// Identifier of the loader associated with this frame.
        /// </summary>
        [DataMember(Name = ("loaderId"), IsRequired = (true))]
        public string LoaderId
        {
            get;
            set;
        }

        /// <summary>
        /// Frame&apos;s name as specified in the tag.
        /// </summary>
        [DataMember(Name = ("name"), IsRequired = (false))]
        public string Name
        {
            get;
            set;
        }

        /// <summary>
        /// Frame document&apos;s URL without fragment.
        /// </summary>
        [DataMember(Name = ("url"), IsRequired = (true))]
        public string Url
        {
            get;
            set;
        }

        /// <summary>
        /// Frame document&apos;s URL fragment including the &apos;#&apos;.
        /// </summary>
        [DataMember(Name = ("urlFragment"), IsRequired = (false))]
        public string UrlFragment
        {
            get;
            set;
        }

        /// <summary>
        /// Frame document&apos;s registered domain, taking the public suffixes list into account.
        /// Extracted from the Frame&apos;s url.
        /// Example URLs: http://www.google.com/file.html -&gt; &quot;google.com&quot;
        ///               http://a.b.co.uk/file.html      -&gt; &quot;b.co.uk&quot;
        /// </summary>
        [DataMember(Name = ("domainAndRegistry"), IsRequired = (true))]
        public string DomainAndRegistry
        {
            get;
            set;
        }

        /// <summary>
        /// Frame document&apos;s security origin.
        /// </summary>
        [DataMember(Name = ("securityOrigin"), IsRequired = (true))]
        public string SecurityOrigin
        {
            get;
            set;
        }

        /// <summary>
        /// Frame document&apos;s mimeType as determined by the browser.
        /// </summary>
        [DataMember(Name = ("mimeType"), IsRequired = (true))]
        public string MimeType
        {
            get;
            set;
        }

        /// <summary>
        /// If the frame failed to load, this contains the URL that could not be loaded. Note that unlike url above, this URL may contain a fragment.
        /// </summary>
        [DataMember(Name = ("unreachableUrl"), IsRequired = (false))]
        public string UnreachableUrl
        {
            get;
            set;
        }

        /// <summary>
        /// Indicates whether this frame was tagged as an ad and why.
        /// </summary>
        [DataMember(Name = ("adFrameStatus"), IsRequired = (false))]
        public CefSharp.DevTools.Page.AdFrameStatus AdFrameStatus
        {
            get;
            set;
        }

        /// <summary>
        /// Indicates whether the main document is a secure context and explains why that is the case.
        /// </summary>
        public CefSharp.DevTools.Page.SecureContextType SecureContextType
        {
            get
            {
                return (CefSharp.DevTools.Page.SecureContextType)(StringToEnum(typeof(CefSharp.DevTools.Page.SecureContextType), secureContextType));
            }

            set
            {
                this.secureContextType = (EnumToString(value));
            }
        }

        /// <summary>
        /// Indicates whether the main document is a secure context and explains why that is the case.
        /// </summary>
        [DataMember(Name = ("secureContextType"), IsRequired = (true))]
        internal string secureContextType
        {
            get;
            set;
        }

        /// <summary>
        /// Indicates whether this is a cross origin isolated context.
        /// </summary>
        public CefSharp.DevTools.Page.CrossOriginIsolatedContextType CrossOriginIsolatedContextType
        {
            get
            {
                return (CefSharp.DevTools.Page.CrossOriginIsolatedContextType)(StringToEnum(typeof(CefSharp.DevTools.Page.CrossOriginIsolatedContextType), crossOriginIsolatedContextType));
            }

            set
            {
                this.crossOriginIsolatedContextType = (EnumToString(value));
            }
        }

        /// <summary>
        /// Indicates whether this is a cross origin isolated context.
        /// </summary>
        [DataMember(Name = ("crossOriginIsolatedContextType"), IsRequired = (true))]
        internal string crossOriginIsolatedContextType
        {
            get;
            set;
        }

        /// <summary>
        /// Indicated which gated APIs / features are available.
        /// </summary>
        public CefSharp.DevTools.Page.GatedAPIFeatures[] GatedAPIFeatures
        {
            get
            {
                return (CefSharp.DevTools.Page.GatedAPIFeatures[])(StringToEnum(typeof(CefSharp.DevTools.Page.GatedAPIFeatures[]), gatedAPIFeatures));
            }

            set
            {
                this.gatedAPIFeatures = (EnumToString(value));
            }
        }

        /// <summary>
        /// Indicated which gated APIs / features are available.
        /// </summary>
        [DataMember(Name = ("gatedAPIFeatures"), IsRequired = (true))]
        internal string gatedAPIFeatures
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Information about the Resource on the page.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class FrameResource : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Resource URL.
        /// </summary>
        [DataMember(Name = ("url"), IsRequired = (true))]
        public string Url
        {
            get;
            set;
        }

        /// <summary>
        /// Type of this resource.
        /// </summary>
        public CefSharp.DevTools.Network.ResourceType Type
        {
            get
            {
                return (CefSharp.DevTools.Network.ResourceType)(StringToEnum(typeof(CefSharp.DevTools.Network.ResourceType), type));
            }

            set
            {
                this.type = (EnumToString(value));
            }
        }

        /// <summary>
        /// Type of this resource.
        /// </summary>
        [DataMember(Name = ("type"), IsRequired = (true))]
        internal string type
        {
            get;
            set;
        }

        /// <summary>
        /// Resource mimeType as determined by the browser.
        /// </summary>
        [DataMember(Name = ("mimeType"), IsRequired = (true))]
        public string MimeType
        {
            get;
            set;
        }

        /// <summary>
        /// last-modified timestamp as reported by server.
        /// </summary>
        [DataMember(Name = ("lastModified"), IsRequired = (false))]
        public double? LastModified
        {
            get;
            set;
        }

        /// <summary>
        /// Resource content size.
        /// </summary>
        [DataMember(Name = ("contentSize"), IsRequired = (false))]
        public double? ContentSize
        {
            get;
            set;
        }

        /// <summary>
        /// True if the resource failed to load.
        /// </summary>
        [DataMember(Name = ("failed"), IsRequired = (false))]
        public bool? Failed
        {
            get;
            set;
        }

        /// <summary>
        /// True if the resource was canceled during loading.
        /// </summary>
        [DataMember(Name = ("canceled"), IsRequired = (false))]
        public bool? Canceled
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Information about the Frame hierarchy along with their cached resources.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class FrameResourceTree : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Frame information for this tree item.
        /// </summary>
        [DataMember(Name = ("frame"), IsRequired = (true))]
        public CefSharp.DevTools.Page.Frame Frame
        {
            get;
            set;
        }

        /// <summary>
        /// Child frames.
        /// </summary>
        [DataMember(Name = ("childFrames"), IsRequired = (false))]
        public System.Collections.Generic.IList<CefSharp.DevTools.Page.FrameResourceTree> ChildFrames
        {
            get;
            set;
        }

        /// <summary>
        /// Information about frame resources.
        /// </summary>
        [DataMember(Name = ("resources"), IsRequired = (true))]
        public System.Collections.Generic.IList<CefSharp.DevTools.Page.FrameResource> Resources
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Information about the Frame hierarchy.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class FrameTree : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Frame information for this tree item.
        /// </summary>
        [DataMember(Name = ("frame"), IsRequired = (true))]
        public CefSharp.DevTools.Page.Frame Frame
        {
            get;
            set;
        }

        /// <summary>
        /// Child frames.
        /// </summary>
        [DataMember(Name = ("childFrames"), IsRequired = (false))]
        public System.Collections.Generic.IList<CefSharp.DevTools.Page.FrameTree> ChildFrames
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Transition type.
    /// </summary>
    public enum TransitionType
    {
        /// <summary>
        /// link
        /// </summary>
        [EnumMember(Value = ("link"))]
        Link,
        /// <summary>
        /// typed
        /// </summary>
        [EnumMember(Value = ("typed"))]
        Typed,
        /// <summary>
        /// address_bar
        /// </summary>
        [EnumMember(Value = ("address_bar"))]
        AddressBar,
        /// <summary>
        /// auto_bookmark
        /// </summary>
        [EnumMember(Value = ("auto_bookmark"))]
        AutoBookmark,
        /// <summary>
        /// auto_subframe
        /// </summary>
        [EnumMember(Value = ("auto_subframe"))]
        AutoSubframe,
        /// <summary>
        /// manual_subframe
        /// </summary>
        [EnumMember(Value = ("manual_subframe"))]
        ManualSubframe,
        /// <summary>
        /// generated
        /// </summary>
        [EnumMember(Value = ("generated"))]
        Generated,
        /// <summary>
        /// auto_toplevel
        /// </summary>
        [EnumMember(Value = ("auto_toplevel"))]
        AutoToplevel,
        /// <summary>
        /// form_submit
        /// </summary>
        [EnumMember(Value = ("form_submit"))]
        FormSubmit,
        /// <summary>
        /// reload
        /// </summary>
        [EnumMember(Value = ("reload"))]
        Reload,
        /// <summary>
        /// keyword
        /// </summary>
        [EnumMember(Value = ("keyword"))]
        Keyword,
        /// <summary>
        /// keyword_generated
        /// </summary>
        [EnumMember(Value = ("keyword_generated"))]
        KeywordGenerated,
        /// <summary>
        /// other
        /// </summary>
        [EnumMember(Value = ("other"))]
        Other
    }

    /// <summary>
    /// Navigation history entry.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class NavigationEntry : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Unique id of the navigation history entry.
        /// </summary>
        [DataMember(Name = ("id"), IsRequired = (true))]
        public int Id
        {
            get;
            set;
        }

        /// <summary>
        /// URL of the navigation history entry.
        /// </summary>
        [DataMember(Name = ("url"), IsRequired = (true))]
        public string Url
        {
            get;
            set;
        }

        /// <summary>
        /// URL that the user typed in the url bar.
        /// </summary>
        [DataMember(Name = ("userTypedURL"), IsRequired = (true))]
        public string UserTypedURL
        {
            get;
            set;
        }

        /// <summary>
        /// Title of the navigation history entry.
        /// </summary>
        [DataMember(Name = ("title"), IsRequired = (true))]
        public string Title
        {
            get;
            set;
        }

        /// <summary>
        /// Transition type.
        /// </summary>
        public CefSharp.DevTools.Page.TransitionType TransitionType
        {
            get
            {
                return (CefSharp.DevTools.Page.TransitionType)(StringToEnum(typeof(CefSharp.DevTools.Page.TransitionType), transitionType));
            }

            set
            {
                this.transitionType = (EnumToString(value));
            }
        }

        /// <summary>
        /// Transition type.
        /// </summary>
        [DataMember(Name = ("transitionType"), IsRequired = (true))]
        internal string transitionType
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Screencast frame metadata.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class ScreencastFrameMetadata : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Top offset in DIP.
        /// </summary>
        [DataMember(Name = ("offsetTop"), IsRequired = (true))]
        public double OffsetTop
        {
            get;
            set;
        }

        /// <summary>
        /// Page scale factor.
        /// </summary>
        [DataMember(Name = ("pageScaleFactor"), IsRequired = (true))]
        public double PageScaleFactor
        {
            get;
            set;
        }

        /// <summary>
        /// Device screen width in DIP.
        /// </summary>
        [DataMember(Name = ("deviceWidth"), IsRequired = (true))]
        public double DeviceWidth
        {
            get;
            set;
        }

        /// <summary>
        /// Device screen height in DIP.
        /// </summary>
        [DataMember(Name = ("deviceHeight"), IsRequired = (true))]
        public double DeviceHeight
        {
            get;
            set;
        }

        /// <summary>
        /// Position of horizontal scroll in CSS pixels.
        /// </summary>
        [DataMember(Name = ("scrollOffsetX"), IsRequired = (true))]
        public double ScrollOffsetX
        {
            get;
            set;
        }

        /// <summary>
        /// Position of vertical scroll in CSS pixels.
        /// </summary>
        [DataMember(Name = ("scrollOffsetY"), IsRequired = (true))]
        public double ScrollOffsetY
        {
            get;
            set;
        }

        /// <summary>
        /// Frame swap timestamp.
        /// </summary>
        [DataMember(Name = ("timestamp"), IsRequired = (false))]
        public double? Timestamp
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Javascript dialog type.
    /// </summary>
    public enum DialogType
    {
        /// <summary>
        /// alert
        /// </summary>
        [EnumMember(Value = ("alert"))]
        Alert,
        /// <summary>
        /// confirm
        /// </summary>
        [EnumMember(Value = ("confirm"))]
        Confirm,
        /// <summary>
        /// prompt
        /// </summary>
        [EnumMember(Value = ("prompt"))]
        Prompt,
        /// <summary>
        /// beforeunload
        /// </summary>
        [EnumMember(Value = ("beforeunload"))]
        Beforeunload
    }

    /// <summary>
    /// Error while paring app manifest.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class AppManifestError : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Error message.
        /// </summary>
        [DataMember(Name = ("message"), IsRequired = (true))]
        public string Message
        {
            get;
            set;
        }

        /// <summary>
        /// If critical, this is a non-recoverable parse error.
        /// </summary>
        [DataMember(Name = ("critical"), IsRequired = (true))]
        public int Critical
        {
            get;
            set;
        }

        /// <summary>
        /// Error line.
        /// </summary>
        [DataMember(Name = ("line"), IsRequired = (true))]
        public int Line
        {
            get;
            set;
        }

        /// <summary>
        /// Error column.
        /// </summary>
        [DataMember(Name = ("column"), IsRequired = (true))]
        public int Column
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Parsed app manifest properties.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class AppManifestParsedProperties : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Computed scope value
        /// </summary>
        [DataMember(Name = ("scope"), IsRequired = (true))]
        public string Scope
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Layout viewport position and dimensions.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class LayoutViewport : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Horizontal offset relative to the document (CSS pixels).
        /// </summary>
        [DataMember(Name = ("pageX"), IsRequired = (true))]
        public int PageX
        {
            get;
            set;
        }

        /// <summary>
        /// Vertical offset relative to the document (CSS pixels).
        /// </summary>
        [DataMember(Name = ("pageY"), IsRequired = (true))]
        public int PageY
        {
            get;
            set;
        }

        /// <summary>
        /// Width (CSS pixels), excludes scrollbar if present.
        /// </summary>
        [DataMember(Name = ("clientWidth"), IsRequired = (true))]
        public int ClientWidth
        {
            get;
            set;
        }

        /// <summary>
        /// Height (CSS pixels), excludes scrollbar if present.
        /// </summary>
        [DataMember(Name = ("clientHeight"), IsRequired = (true))]
        public int ClientHeight
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Visual viewport position, dimensions, and scale.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class VisualViewport : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Horizontal offset relative to the layout viewport (CSS pixels).
        /// </summary>
        [DataMember(Name = ("offsetX"), IsRequired = (true))]
        public double OffsetX
        {
            get;
            set;
        }

        /// <summary>
        /// Vertical offset relative to the layout viewport (CSS pixels).
        /// </summary>
        [DataMember(Name = ("offsetY"), IsRequired = (true))]
        public double OffsetY
        {
            get;
            set;
        }

        /// <summary>
        /// Horizontal offset relative to the document (CSS pixels).
        /// </summary>
        [DataMember(Name = ("pageX"), IsRequired = (true))]
        public double PageX
        {
            get;
            set;
        }

        /// <summary>
        /// Vertical offset relative to the document (CSS pixels).
        /// </summary>
        [DataMember(Name = ("pageY"), IsRequired = (true))]
        public double PageY
        {
            get;
            set;
        }

        /// <summary>
        /// Width (CSS pixels), excludes scrollbar if present.
        /// </summary>
        [DataMember(Name = ("clientWidth"), IsRequired = (true))]
        public double ClientWidth
        {
            get;
            set;
        }

        /// <summary>
        /// Height (CSS pixels), excludes scrollbar if present.
        /// </summary>
        [DataMember(Name = ("clientHeight"), IsRequired = (true))]
        public double ClientHeight
        {
            get;
            set;
        }

        /// <summary>
        /// Scale relative to the ideal viewport (size at width=device-width).
        /// </summary>
        [DataMember(Name = ("scale"), IsRequired = (true))]
        public double Scale
        {
            get;
            set;
        }

        /// <summary>
        /// Page zoom factor (CSS to device independent pixels ratio).
        /// </summary>
        [DataMember(Name = ("zoom"), IsRequired = (false))]
        public double? Zoom
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Viewport for capturing screenshot.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class Viewport : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// X offset in device independent pixels (dip).
        /// </summary>
        [DataMember(Name = ("x"), IsRequired = (true))]
        public double X
        {
            get;
            set;
        }

        /// <summary>
        /// Y offset in device independent pixels (dip).
        /// </summary>
        [DataMember(Name = ("y"), IsRequired = (true))]
        public double Y
        {
            get;
            set;
        }

        /// <summary>
        /// Rectangle width in device independent pixels (dip).
        /// </summary>
        [DataMember(Name = ("width"), IsRequired = (true))]
        public double Width
        {
            get;
            set;
        }

        /// <summary>
        /// Rectangle height in device independent pixels (dip).
        /// </summary>
        [DataMember(Name = ("height"), IsRequired = (true))]
        public double Height
        {
            get;
            set;
        }

        /// <summary>
        /// Page scale factor.
        /// </summary>
        [DataMember(Name = ("scale"), IsRequired = (true))]
        public double Scale
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Generic font families collection.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class FontFamilies : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The standard font-family.
        /// </summary>
        [DataMember(Name = ("standard"), IsRequired = (false))]
        public string Standard
        {
            get;
            set;
        }

        /// <summary>
        /// The fixed font-family.
        /// </summary>
        [DataMember(Name = ("fixed"), IsRequired = (false))]
        public string Fixed
        {
            get;
            set;
        }

        /// <summary>
        /// The serif font-family.
        /// </summary>
        [DataMember(Name = ("serif"), IsRequired = (false))]
        public string Serif
        {
            get;
            set;
        }

        /// <summary>
        /// The sansSerif font-family.
        /// </summary>
        [DataMember(Name = ("sansSerif"), IsRequired = (false))]
        public string SansSerif
        {
            get;
            set;
        }

        /// <summary>
        /// The cursive font-family.
        /// </summary>
        [DataMember(Name = ("cursive"), IsRequired = (false))]
        public string Cursive
        {
            get;
            set;
        }

        /// <summary>
        /// The fantasy font-family.
        /// </summary>
        [DataMember(Name = ("fantasy"), IsRequired = (false))]
        public string Fantasy
        {
            get;
            set;
        }

        /// <summary>
        /// The math font-family.
        /// </summary>
        [DataMember(Name = ("math"), IsRequired = (false))]
        public string Math
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Font families collection for a script.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class ScriptFontFamilies : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Name of the script which these font families are defined for.
        /// </summary>
        [DataMember(Name = ("script"), IsRequired = (true))]
        public string Script
        {
            get;
            set;
        }

        /// <summary>
        /// Generic font families collection for the script.
        /// </summary>
        [DataMember(Name = ("fontFamilies"), IsRequired = (true))]
        public CefSharp.DevTools.Page.FontFamilies FontFamilies
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Default font sizes.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class FontSizes : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Default standard font size.
        /// </summary>
        [DataMember(Name = ("standard"), IsRequired = (false))]
        public int? Standard
        {
            get;
            set;
        }

        /// <summary>
        /// Default fixed font size.
        /// </summary>
        [DataMember(Name = ("fixed"), IsRequired = (false))]
        public int? Fixed
        {
            get;
            set;
        }
    }

    /// <summary>
    /// ClientNavigationReason
    /// </summary>
    public enum ClientNavigationReason
    {
        /// <summary>
        /// anchorClick
        /// </summary>
        [EnumMember(Value = ("anchorClick"))]
        AnchorClick,
        /// <summary>
        /// formSubmissionGet
        /// </summary>
        [EnumMember(Value = ("formSubmissionGet"))]
        FormSubmissionGet,
        /// <summary>
        /// formSubmissionPost
        /// </summary>
        [EnumMember(Value = ("formSubmissionPost"))]
        FormSubmissionPost,
        /// <summary>
        /// httpHeaderRefresh
        /// </summary>
        [EnumMember(Value = ("httpHeaderRefresh"))]
        HttpHeaderRefresh,
        /// <summary>
        /// initialFrameNavigation
        /// </summary>
        [EnumMember(Value = ("initialFrameNavigation"))]
        InitialFrameNavigation,
        /// <summary>
        /// metaTagRefresh
        /// </summary>
        [EnumMember(Value = ("metaTagRefresh"))]
        MetaTagRefresh,
        /// <summary>
        /// other
        /// </summary>
        [EnumMember(Value = ("other"))]
        Other,
        /// <summary>
        /// pageBlockInterstitial
        /// </summary>
        [EnumMember(Value = ("pageBlockInterstitial"))]
        PageBlockInterstitial,
        /// <summary>
        /// reload
        /// </summary>
        [EnumMember(Value = ("reload"))]
        Reload,
        /// <summary>
        /// scriptInitiated
        /// </summary>
        [EnumMember(Value = ("scriptInitiated"))]
        ScriptInitiated
    }

    /// <summary>
    /// ClientNavigationDisposition
    /// </summary>
    public enum ClientNavigationDisposition
    {
        /// <summary>
        /// currentTab
        /// </summary>
        [EnumMember(Value = ("currentTab"))]
        CurrentTab,
        /// <summary>
        /// newTab
        /// </summary>
        [EnumMember(Value = ("newTab"))]
        NewTab,
        /// <summary>
        /// newWindow
        /// </summary>
        [EnumMember(Value = ("newWindow"))]
        NewWindow,
        /// <summary>
        /// download
        /// </summary>
        [EnumMember(Value = ("download"))]
        Download
    }

    /// <summary>
    /// InstallabilityErrorArgument
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class InstallabilityErrorArgument : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Argument name (e.g. name:&apos;minimum-icon-size-in-pixels&apos;).
        /// </summary>
        [DataMember(Name = ("name"), IsRequired = (true))]
        public string Name
        {
            get;
            set;
        }

        /// <summary>
        /// Argument value (e.g. value:&apos;64&apos;).
        /// </summary>
        [DataMember(Name = ("value"), IsRequired = (true))]
        public string Value
        {
            get;
            set;
        }
    }

    /// <summary>
    /// The installability error
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class InstallabilityError : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The error id (e.g. &apos;manifest-missing-suitable-icon&apos;).
        /// </summary>
        [DataMember(Name = ("errorId"), IsRequired = (true))]
        public string ErrorId
        {
            get;
            set;
        }

        /// <summary>
        /// The list of error arguments (e.g. {name:&apos;minimum-icon-size-in-pixels&apos;, value:&apos;64&apos;}).
        /// </summary>
        [DataMember(Name = ("errorArguments"), IsRequired = (true))]
        public System.Collections.Generic.IList<CefSharp.DevTools.Page.InstallabilityErrorArgument> ErrorArguments
        {
            get;
            set;
        }
    }

    /// <summary>
    /// The referring-policy used for the navigation.
    /// </summary>
    public enum ReferrerPolicy
    {
        /// <summary>
        /// noReferrer
        /// </summary>
        [EnumMember(Value = ("noReferrer"))]
        NoReferrer,
        /// <summary>
        /// noReferrerWhenDowngrade
        /// </summary>
        [EnumMember(Value = ("noReferrerWhenDowngrade"))]
        NoReferrerWhenDowngrade,
        /// <summary>
        /// origin
        /// </summary>
        [EnumMember(Value = ("origin"))]
        Origin,
        /// <summary>
        /// originWhenCrossOrigin
        /// </summary>
        [EnumMember(Value = ("originWhenCrossOrigin"))]
        OriginWhenCrossOrigin,
        /// <summary>
        /// sameOrigin
        /// </summary>
        [EnumMember(Value = ("sameOrigin"))]
        SameOrigin,
        /// <summary>
        /// strictOrigin
        /// </summary>
        [EnumMember(Value = ("strictOrigin"))]
        StrictOrigin,
        /// <summary>
        /// strictOriginWhenCrossOrigin
        /// </summary>
        [EnumMember(Value = ("strictOriginWhenCrossOrigin"))]
        StrictOriginWhenCrossOrigin,
        /// <summary>
        /// unsafeUrl
        /// </summary>
        [EnumMember(Value = ("unsafeUrl"))]
        UnsafeUrl
    }

    /// <summary>
    /// Per-script compilation cache parameters for `Page.produceCompilationCache`
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class CompilationCacheParams : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The URL of the script to produce a compilation cache entry for.
        /// </summary>
        [DataMember(Name = ("url"), IsRequired = (true))]
        public string Url
        {
            get;
            set;
        }

        /// <summary>
        /// A hint to the backend whether eager compilation is recommended.
        /// (the actual compilation mode used is upon backend discretion).
        /// </summary>
        [DataMember(Name = ("eager"), IsRequired = (false))]
        public bool? Eager
        {
            get;
            set;
        }
    }

    /// <summary>
    /// FileFilter
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class FileFilter : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Name
        /// </summary>
        [DataMember(Name = ("name"), IsRequired = (false))]
        public string Name
        {
            get;
            set;
        }

        /// <summary>
        /// Accepts
        /// </summary>
        [DataMember(Name = ("accepts"), IsRequired = (false))]
        public string[] Accepts
        {
            get;
            set;
        }
    }

    /// <summary>
    /// FileHandler
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class FileHandler : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Action
        /// </summary>
        [DataMember(Name = ("action"), IsRequired = (true))]
        public string Action
        {
            get;
            set;
        }

        /// <summary>
        /// Name
        /// </summary>
        [DataMember(Name = ("name"), IsRequired = (true))]
        public string Name
        {
            get;
            set;
        }

        /// <summary>
        /// Icons
        /// </summary>
        [DataMember(Name = ("icons"), IsRequired = (false))]
        public System.Collections.Generic.IList<CefSharp.DevTools.Page.ImageResource> Icons
        {
            get;
            set;
        }

        /// <summary>
        /// Mimic a map, name is the key, accepts is the value.
        /// </summary>
        [DataMember(Name = ("accepts"), IsRequired = (false))]
        public System.Collections.Generic.IList<CefSharp.DevTools.Page.FileFilter> Accepts
        {
            get;
            set;
        }

        /// <summary>
        /// Won&apos;t repeat the enums, using string for easy comparison. Same as the
        /// other enums below.
        /// </summary>
        [DataMember(Name = ("launchType"), IsRequired = (true))]
        public string LaunchType
        {
            get;
            set;
        }
    }

    /// <summary>
    /// The image definition used in both icon and screenshot.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class ImageResource : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The src field in the definition, but changing to url in favor of
        /// consistency.
        /// </summary>
        [DataMember(Name = ("url"), IsRequired = (true))]
        public string Url
        {
            get;
            set;
        }

        /// <summary>
        /// Sizes
        /// </summary>
        [DataMember(Name = ("sizes"), IsRequired = (false))]
        public string Sizes
        {
            get;
            set;
        }

        /// <summary>
        /// Type
        /// </summary>
        [DataMember(Name = ("type"), IsRequired = (false))]
        public string Type
        {
            get;
            set;
        }
    }

    /// <summary>
    /// LaunchHandler
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class LaunchHandler : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// ClientMode
        /// </summary>
        [DataMember(Name = ("clientMode"), IsRequired = (true))]
        public string ClientMode
        {
            get;
            set;
        }
    }

    /// <summary>
    /// ProtocolHandler
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class ProtocolHandler : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Protocol
        /// </summary>
        [DataMember(Name = ("protocol"), IsRequired = (true))]
        public string Protocol
        {
            get;
            set;
        }

        /// <summary>
        /// Url
        /// </summary>
        [DataMember(Name = ("url"), IsRequired = (true))]
        public string Url
        {
            get;
            set;
        }
    }

    /// <summary>
    /// RelatedApplication
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class RelatedApplication : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Id
        /// </summary>
        [DataMember(Name = ("id"), IsRequired = (false))]
        public string Id
        {
            get;
            set;
        }

        /// <summary>
        /// Url
        /// </summary>
        [DataMember(Name = ("url"), IsRequired = (true))]
        public string Url
        {
            get;
            set;
        }
    }

    /// <summary>
    /// ScopeExtension
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class ScopeExtension : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Instead of using tuple, this field always returns the serialized string
        /// for easy understanding and comparison.
        /// </summary>
        [DataMember(Name = ("origin"), IsRequired = (true))]
        public string Origin
        {
            get;
            set;
        }

        /// <summary>
        /// HasOriginWildcard
        /// </summary>
        [DataMember(Name = ("hasOriginWildcard"), IsRequired = (true))]
        public bool HasOriginWildcard
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Screenshot
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class Screenshot : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Image
        /// </summary>
        [DataMember(Name = ("image"), IsRequired = (true))]
        public CefSharp.DevTools.Page.ImageResource Image
        {
            get;
            set;
        }

        /// <summary>
        /// FormFactor
        /// </summary>
        [DataMember(Name = ("formFactor"), IsRequired = (true))]
        public string FormFactor
        {
            get;
            set;
        }

        /// <summary>
        /// Label
        /// </summary>
        [DataMember(Name = ("label"), IsRequired = (false))]
        public string Label
        {
            get;
            set;
        }
    }

    /// <summary>
    /// ShareTarget
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class ShareTarget : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Action
        /// </summary>
        [DataMember(Name = ("action"), IsRequired = (true))]
        public string Action
        {
            get;
            set;
        }

        /// <summary>
        /// Method
        /// </summary>
        [DataMember(Name = ("method"), IsRequired = (true))]
        public string Method
        {
            get;
            set;
        }

        /// <summary>
        /// Enctype
        /// </summary>
        [DataMember(Name = ("enctype"), IsRequired = (true))]
        public string Enctype
        {
            get;
            set;
        }

        /// <summary>
        /// Embed the ShareTargetParams
        /// </summary>
        [DataMember(Name = ("title"), IsRequired = (false))]
        public string Title
        {
            get;
            set;
        }

        /// <summary>
        /// Text
        /// </summary>
        [DataMember(Name = ("text"), IsRequired = (false))]
        public string Text
        {
            get;
            set;
        }

        /// <summary>
        /// Url
        /// </summary>
        [DataMember(Name = ("url"), IsRequired = (false))]
        public string Url
        {
            get;
            set;
        }

        /// <summary>
        /// Files
        /// </summary>
        [DataMember(Name = ("files"), IsRequired = (false))]
        public System.Collections.Generic.IList<CefSharp.DevTools.Page.FileFilter> Files
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Shortcut
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class Shortcut : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Name
        /// </summary>
        [DataMember(Name = ("name"), IsRequired = (true))]
        public string Name
        {
            get;
            set;
        }

        /// <summary>
        /// Url
        /// </summary>
        [DataMember(Name = ("url"), IsRequired = (true))]
        public string Url
        {
            get;
            set;
        }
    }

    /// <summary>
    /// WebAppManifest
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class WebAppManifest : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// BackgroundColor
        /// </summary>
        [DataMember(Name = ("backgroundColor"), IsRequired = (false))]
        public string BackgroundColor
        {
            get;
            set;
        }

        /// <summary>
        /// The extra description provided by the manifest.
        /// </summary>
        [DataMember(Name = ("description"), IsRequired = (false))]
        public string Description
        {
            get;
            set;
        }

        /// <summary>
        /// Dir
        /// </summary>
        [DataMember(Name = ("dir"), IsRequired = (false))]
        public string Dir
        {
            get;
            set;
        }

        /// <summary>
        /// Display
        /// </summary>
        [DataMember(Name = ("display"), IsRequired = (false))]
        public string Display
        {
            get;
            set;
        }

        /// <summary>
        /// The overrided display mode controlled by the user.
        /// </summary>
        [DataMember(Name = ("displayOverrides"), IsRequired = (false))]
        public string[] DisplayOverrides
        {
            get;
            set;
        }

        /// <summary>
        /// The handlers to open files.
        /// </summary>
        [DataMember(Name = ("fileHandlers"), IsRequired = (false))]
        public System.Collections.Generic.IList<CefSharp.DevTools.Page.FileHandler> FileHandlers
        {
            get;
            set;
        }

        /// <summary>
        /// Icons
        /// </summary>
        [DataMember(Name = ("icons"), IsRequired = (false))]
        public System.Collections.Generic.IList<CefSharp.DevTools.Page.ImageResource> Icons
        {
            get;
            set;
        }

        /// <summary>
        /// Id
        /// </summary>
        [DataMember(Name = ("id"), IsRequired = (false))]
        public string Id
        {
            get;
            set;
        }

        /// <summary>
        /// Lang
        /// </summary>
        [DataMember(Name = ("lang"), IsRequired = (false))]
        public string Lang
        {
            get;
            set;
        }

        /// <summary>
        /// TODO(crbug.com/1231886): This field is non-standard and part of a Chrome
        /// experiment. See:
        /// https://github.com/WICG/web-app-launch/blob/main/launch_handler.md
        /// </summary>
        [DataMember(Name = ("launchHandler"), IsRequired = (false))]
        public CefSharp.DevTools.Page.LaunchHandler LaunchHandler
        {
            get;
            set;
        }

        /// <summary>
        /// Name
        /// </summary>
        [DataMember(Name = ("name"), IsRequired = (false))]
        public string Name
        {
            get;
            set;
        }

        /// <summary>
        /// Orientation
        /// </summary>
        [DataMember(Name = ("orientation"), IsRequired = (false))]
        public string Orientation
        {
            get;
            set;
        }

        /// <summary>
        /// PreferRelatedApplications
        /// </summary>
        [DataMember(Name = ("preferRelatedApplications"), IsRequired = (false))]
        public bool? PreferRelatedApplications
        {
            get;
            set;
        }

        /// <summary>
        /// The handlers to open protocols.
        /// </summary>
        [DataMember(Name = ("protocolHandlers"), IsRequired = (false))]
        public System.Collections.Generic.IList<CefSharp.DevTools.Page.ProtocolHandler> ProtocolHandlers
        {
            get;
            set;
        }

        /// <summary>
        /// RelatedApplications
        /// </summary>
        [DataMember(Name = ("relatedApplications"), IsRequired = (false))]
        public System.Collections.Generic.IList<CefSharp.DevTools.Page.RelatedApplication> RelatedApplications
        {
            get;
            set;
        }

        /// <summary>
        /// Scope
        /// </summary>
        [DataMember(Name = ("scope"), IsRequired = (false))]
        public string Scope
        {
            get;
            set;
        }

        /// <summary>
        /// Non-standard, see
        /// https://github.com/WICG/manifest-incubations/blob/gh-pages/scope_extensions-explainer.md
        /// </summary>
        [DataMember(Name = ("scopeExtensions"), IsRequired = (false))]
        public System.Collections.Generic.IList<CefSharp.DevTools.Page.ScopeExtension> ScopeExtensions
        {
            get;
            set;
        }

        /// <summary>
        /// The screenshots used by chromium.
        /// </summary>
        [DataMember(Name = ("screenshots"), IsRequired = (false))]
        public System.Collections.Generic.IList<CefSharp.DevTools.Page.Screenshot> Screenshots
        {
            get;
            set;
        }

        /// <summary>
        /// ShareTarget
        /// </summary>
        [DataMember(Name = ("shareTarget"), IsRequired = (false))]
        public CefSharp.DevTools.Page.ShareTarget ShareTarget
        {
            get;
            set;
        }

        /// <summary>
        /// ShortName
        /// </summary>
        [DataMember(Name = ("shortName"), IsRequired = (false))]
        public string ShortName
        {
            get;
            set;
        }

        /// <summary>
        /// Shortcuts
        /// </summary>
        [DataMember(Name = ("shortcuts"), IsRequired = (false))]
        public System.Collections.Generic.IList<CefSharp.DevTools.Page.Shortcut> Shortcuts
        {
            get;
            set;
        }

        /// <summary>
        /// StartUrl
        /// </summary>
        [DataMember(Name = ("startUrl"), IsRequired = (false))]
        public string StartUrl
        {
            get;
            set;
        }

        /// <summary>
        /// ThemeColor
        /// </summary>
        [DataMember(Name = ("themeColor"), IsRequired = (false))]
        public string ThemeColor
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Enum of possible auto-response for permission / prompt dialogs.
    /// </summary>
    public enum AutoResponseMode
    {
        /// <summary>
        /// none
        /// </summary>
        [EnumMember(Value = ("none"))]
        None,
        /// <summary>
        /// autoAccept
        /// </summary>
        [EnumMember(Value = ("autoAccept"))]
        AutoAccept,
        /// <summary>
        /// autoReject
        /// </summary>
        [EnumMember(Value = ("autoReject"))]
        AutoReject,
        /// <summary>
        /// autoOptOut
        /// </summary>
        [EnumMember(Value = ("autoOptOut"))]
        AutoOptOut
    }

    /// <summary>
    /// The type of a frameNavigated event.
    /// </summary>
    public enum NavigationType
    {
        /// <summary>
        /// Navigation
        /// </summary>
        [EnumMember(Value = ("Navigation"))]
        Navigation,
        /// <summary>
        /// BackForwardCacheRestore
        /// </summary>
        [EnumMember(Value = ("BackForwardCacheRestore"))]
        BackForwardCacheRestore
    }

    /// <summary>
    /// List of not restored reasons for back-forward cache.
    /// </summary>
    public enum BackForwardCacheNotRestoredReason
    {
        /// <summary>
        /// NotPrimaryMainFrame
        /// </summary>
        [EnumMember(Value = ("NotPrimaryMainFrame"))]
        NotPrimaryMainFrame,
        /// <summary>
        /// BackForwardCacheDisabled
        /// </summary>
        [EnumMember(Value = ("BackForwardCacheDisabled"))]
        BackForwardCacheDisabled,
        /// <summary>
        /// RelatedActiveContentsExist
        /// </summary>
        [EnumMember(Value = ("RelatedActiveContentsExist"))]
        RelatedActiveContentsExist,
        /// <summary>
        /// HTTPStatusNotOK
        /// </summary>
        [EnumMember(Value = ("HTTPStatusNotOK"))]
        HTTPStatusNotOK,
        /// <summary>
        /// SchemeNotHTTPOrHTTPS
        /// </summary>
        [EnumMember(Value = ("SchemeNotHTTPOrHTTPS"))]
        SchemeNotHTTPOrHTTPS,
        /// <summary>
        /// Loading
        /// </summary>
        [EnumMember(Value = ("Loading"))]
        Loading,
        /// <summary>
        /// WasGrantedMediaAccess
        /// </summary>
        [EnumMember(Value = ("WasGrantedMediaAccess"))]
        WasGrantedMediaAccess,
        /// <summary>
        /// DisableForRenderFrameHostCalled
        /// </summary>
        [EnumMember(Value = ("DisableForRenderFrameHostCalled"))]
        DisableForRenderFrameHostCalled,
        /// <summary>
        /// DomainNotAllowed
        /// </summary>
        [EnumMember(Value = ("DomainNotAllowed"))]
        DomainNotAllowed,
        /// <summary>
        /// HTTPMethodNotGET
        /// </summary>
        [EnumMember(Value = ("HTTPMethodNotGET"))]
        HTTPMethodNotGET,
        /// <summary>
        /// SubframeIsNavigating
        /// </summary>
        [EnumMember(Value = ("SubframeIsNavigating"))]
        SubframeIsNavigating,
        /// <summary>
        /// Timeout
        /// </summary>
        [EnumMember(Value = ("Timeout"))]
        Timeout,
        /// <summary>
        /// CacheLimit
        /// </summary>
        [EnumMember(Value = ("CacheLimit"))]
        CacheLimit,
        /// <summary>
        /// JavaScriptExecution
        /// </summary>
        [EnumMember(Value = ("JavaScriptExecution"))]
        JavaScriptExecution,
        /// <summary>
        /// RendererProcessKilled
        /// </summary>
        [EnumMember(Value = ("RendererProcessKilled"))]
        RendererProcessKilled,
        /// <summary>
        /// RendererProcessCrashed
        /// </summary>
        [EnumMember(Value = ("RendererProcessCrashed"))]
        RendererProcessCrashed,
        /// <summary>
        /// SchedulerTrackedFeatureUsed
        /// </summary>
        [EnumMember(Value = ("SchedulerTrackedFeatureUsed"))]
        SchedulerTrackedFeatureUsed,
        /// <summary>
        /// ConflictingBrowsingInstance
        /// </summary>
        [EnumMember(Value = ("ConflictingBrowsingInstance"))]
        ConflictingBrowsingInstance,
        /// <summary>
        /// CacheFlushed
        /// </summary>
        [EnumMember(Value = ("CacheFlushed"))]
        CacheFlushed,
        /// <summary>
        /// ServiceWorkerVersionActivation
        /// </summary>
        [EnumMember(Value = ("ServiceWorkerVersionActivation"))]
        ServiceWorkerVersionActivation,
        /// <summary>
        /// SessionRestored
        /// </summary>
        [EnumMember(Value = ("SessionRestored"))]
        SessionRestored,
        /// <summary>
        /// ServiceWorkerPostMessage
        /// </summary>
        [EnumMember(Value = ("ServiceWorkerPostMessage"))]
        ServiceWorkerPostMessage,
        /// <summary>
        /// EnteredBackForwardCacheBeforeServiceWorkerHostAdded
        /// </summary>
        [EnumMember(Value = ("EnteredBackForwardCacheBeforeServiceWorkerHostAdded"))]
        EnteredBackForwardCacheBeforeServiceWorkerHostAdded,
        /// <summary>
        /// RenderFrameHostReused_SameSite
        /// </summary>
        [EnumMember(Value = ("RenderFrameHostReused_SameSite"))]
        RenderFrameHostReusedSameSite,
        /// <summary>
        /// RenderFrameHostReused_CrossSite
        /// </summary>
        [EnumMember(Value = ("RenderFrameHostReused_CrossSite"))]
        RenderFrameHostReusedCrossSite,
        /// <summary>
        /// ServiceWorkerClaim
        /// </summary>
        [EnumMember(Value = ("ServiceWorkerClaim"))]
        ServiceWorkerClaim,
        /// <summary>
        /// IgnoreEventAndEvict
        /// </summary>
        [EnumMember(Value = ("IgnoreEventAndEvict"))]
        IgnoreEventAndEvict,
        /// <summary>
        /// HaveInnerContents
        /// </summary>
        [EnumMember(Value = ("HaveInnerContents"))]
        HaveInnerContents,
        /// <summary>
        /// TimeoutPuttingInCache
        /// </summary>
        [EnumMember(Value = ("TimeoutPuttingInCache"))]
        TimeoutPuttingInCache,
        /// <summary>
        /// BackForwardCacheDisabledByLowMemory
        /// </summary>
        [EnumMember(Value = ("BackForwardCacheDisabledByLowMemory"))]
        BackForwardCacheDisabledByLowMemory,
        /// <summary>
        /// BackForwardCacheDisabledByCommandLine
        /// </summary>
        [EnumMember(Value = ("BackForwardCacheDisabledByCommandLine"))]
        BackForwardCacheDisabledByCommandLine,
        /// <summary>
        /// NetworkRequestDatapipeDrainedAsBytesConsumer
        /// </summary>
        [EnumMember(Value = ("NetworkRequestDatapipeDrainedAsBytesConsumer"))]
        NetworkRequestDatapipeDrainedAsBytesConsumer,
        /// <summary>
        /// NetworkRequestRedirected
        /// </summary>
        [EnumMember(Value = ("NetworkRequestRedirected"))]
        NetworkRequestRedirected,
        /// <summary>
        /// NetworkRequestTimeout
        /// </summary>
        [EnumMember(Value = ("NetworkRequestTimeout"))]
        NetworkRequestTimeout,
        /// <summary>
        /// NetworkExceedsBufferLimit
        /// </summary>
        [EnumMember(Value = ("NetworkExceedsBufferLimit"))]
        NetworkExceedsBufferLimit,
        /// <summary>
        /// NavigationCancelledWhileRestoring
        /// </summary>
        [EnumMember(Value = ("NavigationCancelledWhileRestoring"))]
        NavigationCancelledWhileRestoring,
        /// <summary>
        /// NotMostRecentNavigationEntry
        /// </summary>
        [EnumMember(Value = ("NotMostRecentNavigationEntry"))]
        NotMostRecentNavigationEntry,
        /// <summary>
        /// BackForwardCacheDisabledForPrerender
        /// </summary>
        [EnumMember(Value = ("BackForwardCacheDisabledForPrerender"))]
        BackForwardCacheDisabledForPrerender,
        /// <summary>
        /// UserAgentOverrideDiffers
        /// </summary>
        [EnumMember(Value = ("UserAgentOverrideDiffers"))]
        UserAgentOverrideDiffers,
        /// <summary>
        /// ForegroundCacheLimit
        /// </summary>
        [EnumMember(Value = ("ForegroundCacheLimit"))]
        ForegroundCacheLimit,
        /// <summary>
        /// BrowsingInstanceNotSwapped
        /// </summary>
        [EnumMember(Value = ("BrowsingInstanceNotSwapped"))]
        BrowsingInstanceNotSwapped,
        /// <summary>
        /// BackForwardCacheDisabledForDelegate
        /// </summary>
        [EnumMember(Value = ("BackForwardCacheDisabledForDelegate"))]
        BackForwardCacheDisabledForDelegate,
        /// <summary>
        /// UnloadHandlerExistsInMainFrame
        /// </summary>
        [EnumMember(Value = ("UnloadHandlerExistsInMainFrame"))]
        UnloadHandlerExistsInMainFrame,
        /// <summary>
        /// UnloadHandlerExistsInSubFrame
        /// </summary>
        [EnumMember(Value = ("UnloadHandlerExistsInSubFrame"))]
        UnloadHandlerExistsInSubFrame,
        /// <summary>
        /// ServiceWorkerUnregistration
        /// </summary>
        [EnumMember(Value = ("ServiceWorkerUnregistration"))]
        ServiceWorkerUnregistration,
        /// <summary>
        /// CacheControlNoStore
        /// </summary>
        [EnumMember(Value = ("CacheControlNoStore"))]
        CacheControlNoStore,
        /// <summary>
        /// CacheControlNoStoreCookieModified
        /// </summary>
        [EnumMember(Value = ("CacheControlNoStoreCookieModified"))]
        CacheControlNoStoreCookieModified,
        /// <summary>
        /// CacheControlNoStoreHTTPOnlyCookieModified
        /// </summary>
        [EnumMember(Value = ("CacheControlNoStoreHTTPOnlyCookieModified"))]
        CacheControlNoStoreHTTPOnlyCookieModified,
        /// <summary>
        /// NoResponseHead
        /// </summary>
        [EnumMember(Value = ("NoResponseHead"))]
        NoResponseHead,
        /// <summary>
        /// Unknown
        /// </summary>
        [EnumMember(Value = ("Unknown"))]
        Unknown,
        /// <summary>
        /// ActivationNavigationsDisallowedForBug1234857
        /// </summary>
        [EnumMember(Value = ("ActivationNavigationsDisallowedForBug1234857"))]
        ActivationNavigationsDisallowedForBug1234857,
        /// <summary>
        /// ErrorDocument
        /// </summary>
        [EnumMember(Value = ("ErrorDocument"))]
        ErrorDocument,
        /// <summary>
        /// FencedFramesEmbedder
        /// </summary>
        [EnumMember(Value = ("FencedFramesEmbedder"))]
        FencedFramesEmbedder,
        /// <summary>
        /// CookieDisabled
        /// </summary>
        [EnumMember(Value = ("CookieDisabled"))]
        CookieDisabled,
        /// <summary>
        /// HTTPAuthRequired
        /// </summary>
        [EnumMember(Value = ("HTTPAuthRequired"))]
        HTTPAuthRequired,
        /// <summary>
        /// CookieFlushed
        /// </summary>
        [EnumMember(Value = ("CookieFlushed"))]
        CookieFlushed,
        /// <summary>
        /// BroadcastChannelOnMessage
        /// </summary>
        [EnumMember(Value = ("BroadcastChannelOnMessage"))]
        BroadcastChannelOnMessage,
        /// <summary>
        /// WebViewSettingsChanged
        /// </summary>
        [EnumMember(Value = ("WebViewSettingsChanged"))]
        WebViewSettingsChanged,
        /// <summary>
        /// WebViewJavaScriptObjectChanged
        /// </summary>
        [EnumMember(Value = ("WebViewJavaScriptObjectChanged"))]
        WebViewJavaScriptObjectChanged,
        /// <summary>
        /// WebViewMessageListenerInjected
        /// </summary>
        [EnumMember(Value = ("WebViewMessageListenerInjected"))]
        WebViewMessageListenerInjected,
        /// <summary>
        /// WebViewSafeBrowsingAllowlistChanged
        /// </summary>
        [EnumMember(Value = ("WebViewSafeBrowsingAllowlistChanged"))]
        WebViewSafeBrowsingAllowlistChanged,
        /// <summary>
        /// WebViewDocumentStartJavascriptChanged
        /// </summary>
        [EnumMember(Value = ("WebViewDocumentStartJavascriptChanged"))]
        WebViewDocumentStartJavascriptChanged,
        /// <summary>
        /// WebSocket
        /// </summary>
        [EnumMember(Value = ("WebSocket"))]
        WebSocket,
        /// <summary>
        /// WebTransport
        /// </summary>
        [EnumMember(Value = ("WebTransport"))]
        WebTransport,
        /// <summary>
        /// WebRTC
        /// </summary>
        [EnumMember(Value = ("WebRTC"))]
        WebRTC,
        /// <summary>
        /// MainResourceHasCacheControlNoStore
        /// </summary>
        [EnumMember(Value = ("MainResourceHasCacheControlNoStore"))]
        MainResourceHasCacheControlNoStore,
        /// <summary>
        /// MainResourceHasCacheControlNoCache
        /// </summary>
        [EnumMember(Value = ("MainResourceHasCacheControlNoCache"))]
        MainResourceHasCacheControlNoCache,
        /// <summary>
        /// SubresourceHasCacheControlNoStore
        /// </summary>
        [EnumMember(Value = ("SubresourceHasCacheControlNoStore"))]
        SubresourceHasCacheControlNoStore,
        /// <summary>
        /// SubresourceHasCacheControlNoCache
        /// </summary>
        [EnumMember(Value = ("SubresourceHasCacheControlNoCache"))]
        SubresourceHasCacheControlNoCache,
        /// <summary>
        /// ContainsPlugins
        /// </summary>
        [EnumMember(Value = ("ContainsPlugins"))]
        ContainsPlugins,
        /// <summary>
        /// DocumentLoaded
        /// </summary>
        [EnumMember(Value = ("DocumentLoaded"))]
        DocumentLoaded,
        /// <summary>
        /// OutstandingNetworkRequestOthers
        /// </summary>
        [EnumMember(Value = ("OutstandingNetworkRequestOthers"))]
        OutstandingNetworkRequestOthers,
        /// <summary>
        /// RequestedMIDIPermission
        /// </summary>
        [EnumMember(Value = ("RequestedMIDIPermission"))]
        RequestedMIDIPermission,
        /// <summary>
        /// RequestedAudioCapturePermission
        /// </summary>
        [EnumMember(Value = ("RequestedAudioCapturePermission"))]
        RequestedAudioCapturePermission,
        /// <summary>
        /// RequestedVideoCapturePermission
        /// </summary>
        [EnumMember(Value = ("RequestedVideoCapturePermission"))]
        RequestedVideoCapturePermission,
        /// <summary>
        /// RequestedBackForwardCacheBlockedSensors
        /// </summary>
        [EnumMember(Value = ("RequestedBackForwardCacheBlockedSensors"))]
        RequestedBackForwardCacheBlockedSensors,
        /// <summary>
        /// RequestedBackgroundWorkPermission
        /// </summary>
        [EnumMember(Value = ("RequestedBackgroundWorkPermission"))]
        RequestedBackgroundWorkPermission,
        /// <summary>
        /// BroadcastChannel
        /// </summary>
        [EnumMember(Value = ("BroadcastChannel"))]
        BroadcastChannel,
        /// <summary>
        /// WebXR
        /// </summary>
        [EnumMember(Value = ("WebXR"))]
        WebXR,
        /// <summary>
        /// SharedWorker
        /// </summary>
        [EnumMember(Value = ("SharedWorker"))]
        SharedWorker,
        /// <summary>
        /// WebLocks
        /// </summary>
        [EnumMember(Value = ("WebLocks"))]
        WebLocks,
        /// <summary>
        /// WebHID
        /// </summary>
        [EnumMember(Value = ("WebHID"))]
        WebHID,
        /// <summary>
        /// WebShare
        /// </summary>
        [EnumMember(Value = ("WebShare"))]
        WebShare,
        /// <summary>
        /// RequestedStorageAccessGrant
        /// </summary>
        [EnumMember(Value = ("RequestedStorageAccessGrant"))]
        RequestedStorageAccessGrant,
        /// <summary>
        /// WebNfc
        /// </summary>
        [EnumMember(Value = ("WebNfc"))]
        WebNfc,
        /// <summary>
        /// OutstandingNetworkRequestFetch
        /// </summary>
        [EnumMember(Value = ("OutstandingNetworkRequestFetch"))]
        OutstandingNetworkRequestFetch,
        /// <summary>
        /// OutstandingNetworkRequestXHR
        /// </summary>
        [EnumMember(Value = ("OutstandingNetworkRequestXHR"))]
        OutstandingNetworkRequestXHR,
        /// <summary>
        /// AppBanner
        /// </summary>
        [EnumMember(Value = ("AppBanner"))]
        AppBanner,
        /// <summary>
        /// Printing
        /// </summary>
        [EnumMember(Value = ("Printing"))]
        Printing,
        /// <summary>
        /// WebDatabase
        /// </summary>
        [EnumMember(Value = ("WebDatabase"))]
        WebDatabase,
        /// <summary>
        /// PictureInPicture
        /// </summary>
        [EnumMember(Value = ("PictureInPicture"))]
        PictureInPicture,
        /// <summary>
        /// SpeechRecognizer
        /// </summary>
        [EnumMember(Value = ("SpeechRecognizer"))]
        SpeechRecognizer,
        /// <summary>
        /// IdleManager
        /// </summary>
        [EnumMember(Value = ("IdleManager"))]
        IdleManager,
        /// <summary>
        /// PaymentManager
        /// </summary>
        [EnumMember(Value = ("PaymentManager"))]
        PaymentManager,
        /// <summary>
        /// SpeechSynthesis
        /// </summary>
        [EnumMember(Value = ("SpeechSynthesis"))]
        SpeechSynthesis,
        /// <summary>
        /// KeyboardLock
        /// </summary>
        [EnumMember(Value = ("KeyboardLock"))]
        KeyboardLock,
        /// <summary>
        /// WebOTPService
        /// </summary>
        [EnumMember(Value = ("WebOTPService"))]
        WebOTPService,
        /// <summary>
        /// OutstandingNetworkRequestDirectSocket
        /// </summary>
        [EnumMember(Value = ("OutstandingNetworkRequestDirectSocket"))]
        OutstandingNetworkRequestDirectSocket,
        /// <summary>
        /// InjectedJavascript
        /// </summary>
        [EnumMember(Value = ("InjectedJavascript"))]
        InjectedJavascript,
        /// <summary>
        /// InjectedStyleSheet
        /// </summary>
        [EnumMember(Value = ("InjectedStyleSheet"))]
        InjectedStyleSheet,
        /// <summary>
        /// KeepaliveRequest
        /// </summary>
        [EnumMember(Value = ("KeepaliveRequest"))]
        KeepaliveRequest,
        /// <summary>
        /// IndexedDBEvent
        /// </summary>
        [EnumMember(Value = ("IndexedDBEvent"))]
        IndexedDBEvent,
        /// <summary>
        /// Dummy
        /// </summary>
        [EnumMember(Value = ("Dummy"))]
        Dummy,
        /// <summary>
        /// JsNetworkRequestReceivedCacheControlNoStoreResource
        /// </summary>
        [EnumMember(Value = ("JsNetworkRequestReceivedCacheControlNoStoreResource"))]
        JsNetworkRequestReceivedCacheControlNoStoreResource,
        /// <summary>
        /// WebRTCSticky
        /// </summary>
        [EnumMember(Value = ("WebRTCSticky"))]
        WebRTCSticky,
        /// <summary>
        /// WebTransportSticky
        /// </summary>
        [EnumMember(Value = ("WebTransportSticky"))]
        WebTransportSticky,
        /// <summary>
        /// WebSocketSticky
        /// </summary>
        [EnumMember(Value = ("WebSocketSticky"))]
        WebSocketSticky,
        /// <summary>
        /// SmartCard
        /// </summary>
        [EnumMember(Value = ("SmartCard"))]
        SmartCard,
        /// <summary>
        /// LiveMediaStreamTrack
        /// </summary>
        [EnumMember(Value = ("LiveMediaStreamTrack"))]
        LiveMediaStreamTrack,
        /// <summary>
        /// UnloadHandler
        /// </summary>
        [EnumMember(Value = ("UnloadHandler"))]
        UnloadHandler,
        /// <summary>
        /// ParserAborted
        /// </summary>
        [EnumMember(Value = ("ParserAborted"))]
        ParserAborted,
        /// <summary>
        /// ContentSecurityHandler
        /// </summary>
        [EnumMember(Value = ("ContentSecurityHandler"))]
        ContentSecurityHandler,
        /// <summary>
        /// ContentWebAuthenticationAPI
        /// </summary>
        [EnumMember(Value = ("ContentWebAuthenticationAPI"))]
        ContentWebAuthenticationAPI,
        /// <summary>
        /// ContentFileChooser
        /// </summary>
        [EnumMember(Value = ("ContentFileChooser"))]
        ContentFileChooser,
        /// <summary>
        /// ContentSerial
        /// </summary>
        [EnumMember(Value = ("ContentSerial"))]
        ContentSerial,
        /// <summary>
        /// ContentFileSystemAccess
        /// </summary>
        [EnumMember(Value = ("ContentFileSystemAccess"))]
        ContentFileSystemAccess,
        /// <summary>
        /// ContentMediaDevicesDispatcherHost
        /// </summary>
        [EnumMember(Value = ("ContentMediaDevicesDispatcherHost"))]
        ContentMediaDevicesDispatcherHost,
        /// <summary>
        /// ContentWebBluetooth
        /// </summary>
        [EnumMember(Value = ("ContentWebBluetooth"))]
        ContentWebBluetooth,
        /// <summary>
        /// ContentWebUSB
        /// </summary>
        [EnumMember(Value = ("ContentWebUSB"))]
        ContentWebUSB,
        /// <summary>
        /// ContentMediaSessionService
        /// </summary>
        [EnumMember(Value = ("ContentMediaSessionService"))]
        ContentMediaSessionService,
        /// <summary>
        /// ContentScreenReader
        /// </summary>
        [EnumMember(Value = ("ContentScreenReader"))]
        ContentScreenReader,
        /// <summary>
        /// EmbedderPopupBlockerTabHelper
        /// </summary>
        [EnumMember(Value = ("EmbedderPopupBlockerTabHelper"))]
        EmbedderPopupBlockerTabHelper,
        /// <summary>
        /// EmbedderSafeBrowsingTriggeredPopupBlocker
        /// </summary>
        [EnumMember(Value = ("EmbedderSafeBrowsingTriggeredPopupBlocker"))]
        EmbedderSafeBrowsingTriggeredPopupBlocker,
        /// <summary>
        /// EmbedderSafeBrowsingThreatDetails
        /// </summary>
        [EnumMember(Value = ("EmbedderSafeBrowsingThreatDetails"))]
        EmbedderSafeBrowsingThreatDetails,
        /// <summary>
        /// EmbedderAppBannerManager
        /// </summary>
        [EnumMember(Value = ("EmbedderAppBannerManager"))]
        EmbedderAppBannerManager,
        /// <summary>
        /// EmbedderDomDistillerViewerSource
        /// </summary>
        [EnumMember(Value = ("EmbedderDomDistillerViewerSource"))]
        EmbedderDomDistillerViewerSource,
        /// <summary>
        /// EmbedderDomDistillerSelfDeletingRequestDelegate
        /// </summary>
        [EnumMember(Value = ("EmbedderDomDistillerSelfDeletingRequestDelegate"))]
        EmbedderDomDistillerSelfDeletingRequestDelegate,
        /// <summary>
        /// EmbedderOomInterventionTabHelper
        /// </summary>
        [EnumMember(Value = ("EmbedderOomInterventionTabHelper"))]
        EmbedderOomInterventionTabHelper,
        /// <summary>
        /// EmbedderOfflinePage
        /// </summary>
        [EnumMember(Value = ("EmbedderOfflinePage"))]
        EmbedderOfflinePage,
        /// <summary>
        /// EmbedderChromePasswordManagerClientBindCredentialManager
        /// </summary>
        [EnumMember(Value = ("EmbedderChromePasswordManagerClientBindCredentialManager"))]
        EmbedderChromePasswordManagerClientBindCredentialManager,
        /// <summary>
        /// EmbedderPermissionRequestManager
        /// </summary>
        [EnumMember(Value = ("EmbedderPermissionRequestManager"))]
        EmbedderPermissionRequestManager,
        /// <summary>
        /// EmbedderModalDialog
        /// </summary>
        [EnumMember(Value = ("EmbedderModalDialog"))]
        EmbedderModalDialog,
        /// <summary>
        /// EmbedderExtensions
        /// </summary>
        [EnumMember(Value = ("EmbedderExtensions"))]
        EmbedderExtensions,
        /// <summary>
        /// EmbedderExtensionMessaging
        /// </summary>
        [EnumMember(Value = ("EmbedderExtensionMessaging"))]
        EmbedderExtensionMessaging,
        /// <summary>
        /// EmbedderExtensionMessagingForOpenPort
        /// </summary>
        [EnumMember(Value = ("EmbedderExtensionMessagingForOpenPort"))]
        EmbedderExtensionMessagingForOpenPort,
        /// <summary>
        /// EmbedderExtensionSentMessageToCachedFrame
        /// </summary>
        [EnumMember(Value = ("EmbedderExtensionSentMessageToCachedFrame"))]
        EmbedderExtensionSentMessageToCachedFrame,
        /// <summary>
        /// RequestedByWebViewClient
        /// </summary>
        [EnumMember(Value = ("RequestedByWebViewClient"))]
        RequestedByWebViewClient
    }

    /// <summary>
    /// Types of not restored reasons for back-forward cache.
    /// </summary>
    public enum BackForwardCacheNotRestoredReasonType
    {
        /// <summary>
        /// SupportPending
        /// </summary>
        [EnumMember(Value = ("SupportPending"))]
        SupportPending,
        /// <summary>
        /// PageSupportNeeded
        /// </summary>
        [EnumMember(Value = ("PageSupportNeeded"))]
        PageSupportNeeded,
        /// <summary>
        /// Circumstantial
        /// </summary>
        [EnumMember(Value = ("Circumstantial"))]
        Circumstantial
    }

    /// <summary>
    /// BackForwardCacheBlockingDetails
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class BackForwardCacheBlockingDetails : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Url of the file where blockage happened. Optional because of tests.
        /// </summary>
        [DataMember(Name = ("url"), IsRequired = (false))]
        public string Url
        {
            get;
            set;
        }

        /// <summary>
        /// Function name where blockage happened. Optional because of anonymous functions and tests.
        /// </summary>
        [DataMember(Name = ("function"), IsRequired = (false))]
        public string Function
        {
            get;
            set;
        }

        /// <summary>
        /// Line number in the script (0-based).
        /// </summary>
        [DataMember(Name = ("lineNumber"), IsRequired = (true))]
        public int LineNumber
        {
            get;
            set;
        }

        /// <summary>
        /// Column number in the script (0-based).
        /// </summary>
        [DataMember(Name = ("columnNumber"), IsRequired = (true))]
        public int ColumnNumber
        {
            get;
            set;
        }
    }

    /// <summary>
    /// BackForwardCacheNotRestoredExplanation
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class BackForwardCacheNotRestoredExplanation : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Type of the reason
        /// </summary>
        public CefSharp.DevTools.Page.BackForwardCacheNotRestoredReasonType Type
        {
            get
            {
                return (CefSharp.DevTools.Page.BackForwardCacheNotRestoredReasonType)(StringToEnum(typeof(CefSharp.DevTools.Page.BackForwardCacheNotRestoredReasonType), type));
            }

            set
            {
                this.type = (EnumToString(value));
            }
        }

        /// <summary>
        /// Type of the reason
        /// </summary>
        [DataMember(Name = ("type"), IsRequired = (true))]
        internal string type
        {
            get;
            set;
        }

        /// <summary>
        /// Not restored reason
        /// </summary>
        public CefSharp.DevTools.Page.BackForwardCacheNotRestoredReason Reason
        {
            get
            {
                return (CefSharp.DevTools.Page.BackForwardCacheNotRestoredReason)(StringToEnum(typeof(CefSharp.DevTools.Page.BackForwardCacheNotRestoredReason), reason));
            }

            set
            {
                this.reason = (EnumToString(value));
            }
        }

        /// <summary>
        /// Not restored reason
        /// </summary>
        [DataMember(Name = ("reason"), IsRequired = (true))]
        internal string reason
        {
            get;
            set;
        }

        /// <summary>
        /// Context associated with the reason. The meaning of this context is
        /// dependent on the reason:
        /// - EmbedderExtensionSentMessageToCachedFrame: the extension ID.
        /// </summary>
        [DataMember(Name = ("context"), IsRequired = (false))]
        public string Context
        {
            get;
            set;
        }

        /// <summary>
        /// Details
        /// </summary>
        [DataMember(Name = ("details"), IsRequired = (false))]
        public System.Collections.Generic.IList<CefSharp.DevTools.Page.BackForwardCacheBlockingDetails> Details
        {
            get;
            set;
        }
    }

    /// <summary>
    /// BackForwardCacheNotRestoredExplanationTree
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class BackForwardCacheNotRestoredExplanationTree : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// URL of each frame
        /// </summary>
        [DataMember(Name = ("url"), IsRequired = (true))]
        public string Url
        {
            get;
            set;
        }

        /// <summary>
        /// Not restored reasons of each frame
        /// </summary>
        [DataMember(Name = ("explanations"), IsRequired = (true))]
        public System.Collections.Generic.IList<CefSharp.DevTools.Page.BackForwardCacheNotRestoredExplanation> Explanations
        {
            get;
            set;
        }

        /// <summary>
        /// Array of children frame
        /// </summary>
        [DataMember(Name = ("children"), IsRequired = (true))]
        public System.Collections.Generic.IList<CefSharp.DevTools.Page.BackForwardCacheNotRestoredExplanationTree> Children
        {
            get;
            set;
        }
    }

    /// <summary>
    /// domContentEventFired
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class DomContentEventFiredEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Timestamp
        /// </summary>
        [DataMember(Name = ("timestamp"), IsRequired = (true))]
        public double Timestamp
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Input mode.
    /// </summary>
    public enum FileChooserOpenedMode
    {
        /// <summary>
        /// selectSingle
        /// </summary>
        [EnumMember(Value = ("selectSingle"))]
        SelectSingle,
        /// <summary>
        /// selectMultiple
        /// </summary>
        [EnumMember(Value = ("selectMultiple"))]
        SelectMultiple
    }

    /// <summary>
    /// Emitted only when `page.interceptFileChooser` is enabled.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class FileChooserOpenedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Id of the frame containing input node.
        /// </summary>
        [DataMember(Name = ("frameId"), IsRequired = (true))]
        public string FrameId
        {
            get;
            private set;
        }

        /// <summary>
        /// Input mode.
        /// </summary>
        public CefSharp.DevTools.Page.FileChooserOpenedMode Mode
        {
            get
            {
                return (CefSharp.DevTools.Page.FileChooserOpenedMode)(StringToEnum(typeof(CefSharp.DevTools.Page.FileChooserOpenedMode), mode));
            }

            set
            {
                this.mode = (EnumToString(value));
            }
        }

        /// <summary>
        /// Input mode.
        /// </summary>
        [DataMember(Name = ("mode"), IsRequired = (true))]
        internal string mode
        {
            get;
            private set;
        }

        /// <summary>
        /// Input node id. Only present for file choosers opened via an `&lt;input type=&quot;file&quot; &gt;` element.
        /// </summary>
        [DataMember(Name = ("backendNodeId"), IsRequired = (false))]
        public int? BackendNodeId
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired when frame has been attached to its parent.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class FrameAttachedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Id of the frame that has been attached.
        /// </summary>
        [DataMember(Name = ("frameId"), IsRequired = (true))]
        public string FrameId
        {
            get;
            private set;
        }

        /// <summary>
        /// Parent frame identifier.
        /// </summary>
        [DataMember(Name = ("parentFrameId"), IsRequired = (true))]
        public string ParentFrameId
        {
            get;
            private set;
        }

        /// <summary>
        /// JavaScript stack trace of when frame was attached, only set if frame initiated from script.
        /// </summary>
        [DataMember(Name = ("stack"), IsRequired = (false))]
        public CefSharp.DevTools.Runtime.StackTrace Stack
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired when frame no longer has a scheduled navigation.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class FrameClearedScheduledNavigationEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Id of the frame that has cleared its scheduled navigation.
        /// </summary>
        [DataMember(Name = ("frameId"), IsRequired = (true))]
        public string FrameId
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// FrameDetachedReason
    /// </summary>
    public enum FrameDetachedReason
    {
        /// <summary>
        /// remove
        /// </summary>
        [EnumMember(Value = ("remove"))]
        Remove,
        /// <summary>
        /// swap
        /// </summary>
        [EnumMember(Value = ("swap"))]
        Swap
    }

    /// <summary>
    /// Fired when frame has been detached from its parent.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class FrameDetachedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Id of the frame that has been detached.
        /// </summary>
        [DataMember(Name = ("frameId"), IsRequired = (true))]
        public string FrameId
        {
            get;
            private set;
        }

        /// <summary>
        /// Reason
        /// </summary>
        public CefSharp.DevTools.Page.FrameDetachedReason Reason
        {
            get
            {
                return (CefSharp.DevTools.Page.FrameDetachedReason)(StringToEnum(typeof(CefSharp.DevTools.Page.FrameDetachedReason), reason));
            }

            set
            {
                this.reason = (EnumToString(value));
            }
        }

        /// <summary>
        /// Reason
        /// </summary>
        [DataMember(Name = ("reason"), IsRequired = (true))]
        internal string reason
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired once navigation of the frame has completed. Frame is now associated with the new loader.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class FrameNavigatedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Frame object.
        /// </summary>
        [DataMember(Name = ("frame"), IsRequired = (true))]
        public CefSharp.DevTools.Page.Frame Frame
        {
            get;
            private set;
        }

        /// <summary>
        /// Type
        /// </summary>
        public CefSharp.DevTools.Page.NavigationType Type
        {
            get
            {
                return (CefSharp.DevTools.Page.NavigationType)(StringToEnum(typeof(CefSharp.DevTools.Page.NavigationType), type));
            }

            set
            {
                this.type = (EnumToString(value));
            }
        }

        /// <summary>
        /// Type
        /// </summary>
        [DataMember(Name = ("type"), IsRequired = (true))]
        internal string type
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired when opening document to write to.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class DocumentOpenedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Frame object.
        /// </summary>
        [DataMember(Name = ("frame"), IsRequired = (true))]
        public CefSharp.DevTools.Page.Frame Frame
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired when a renderer-initiated navigation is requested.
    /// Navigation may still be cancelled after the event is issued.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class FrameRequestedNavigationEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Id of the frame that is being navigated.
        /// </summary>
        [DataMember(Name = ("frameId"), IsRequired = (true))]
        public string FrameId
        {
            get;
            private set;
        }

        /// <summary>
        /// The reason for the navigation.
        /// </summary>
        public CefSharp.DevTools.Page.ClientNavigationReason Reason
        {
            get
            {
                return (CefSharp.DevTools.Page.ClientNavigationReason)(StringToEnum(typeof(CefSharp.DevTools.Page.ClientNavigationReason), reason));
            }

            set
            {
                this.reason = (EnumToString(value));
            }
        }

        /// <summary>
        /// The reason for the navigation.
        /// </summary>
        [DataMember(Name = ("reason"), IsRequired = (true))]
        internal string reason
        {
            get;
            private set;
        }

        /// <summary>
        /// The destination URL for the requested navigation.
        /// </summary>
        [DataMember(Name = ("url"), IsRequired = (true))]
        public string Url
        {
            get;
            private set;
        }

        /// <summary>
        /// The disposition for the navigation.
        /// </summary>
        public CefSharp.DevTools.Page.ClientNavigationDisposition Disposition
        {
            get
            {
                return (CefSharp.DevTools.Page.ClientNavigationDisposition)(StringToEnum(typeof(CefSharp.DevTools.Page.ClientNavigationDisposition), disposition));
            }

            set
            {
                this.disposition = (EnumToString(value));
            }
        }

        /// <summary>
        /// The disposition for the navigation.
        /// </summary>
        [DataMember(Name = ("disposition"), IsRequired = (true))]
        internal string disposition
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired when frame schedules a potential navigation.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class FrameScheduledNavigationEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Id of the frame that has scheduled a navigation.
        /// </summary>
        [DataMember(Name = ("frameId"), IsRequired = (true))]
        public string FrameId
        {
            get;
            private set;
        }

        /// <summary>
        /// Delay (in seconds) until the navigation is scheduled to begin. The navigation is not
        /// guaranteed to start.
        /// </summary>
        [DataMember(Name = ("delay"), IsRequired = (true))]
        public double Delay
        {
            get;
            private set;
        }

        /// <summary>
        /// The reason for the navigation.
        /// </summary>
        public CefSharp.DevTools.Page.ClientNavigationReason Reason
        {
            get
            {
                return (CefSharp.DevTools.Page.ClientNavigationReason)(StringToEnum(typeof(CefSharp.DevTools.Page.ClientNavigationReason), reason));
            }

            set
            {
                this.reason = (EnumToString(value));
            }
        }

        /// <summary>
        /// The reason for the navigation.
        /// </summary>
        [DataMember(Name = ("reason"), IsRequired = (true))]
        internal string reason
        {
            get;
            private set;
        }

        /// <summary>
        /// The destination URL for the scheduled navigation.
        /// </summary>
        [DataMember(Name = ("url"), IsRequired = (true))]
        public string Url
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired when frame has started loading.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class FrameStartedLoadingEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Id of the frame that has started loading.
        /// </summary>
        [DataMember(Name = ("frameId"), IsRequired = (true))]
        public string FrameId
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired when frame has stopped loading.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class FrameStoppedLoadingEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Id of the frame that has stopped loading.
        /// </summary>
        [DataMember(Name = ("frameId"), IsRequired = (true))]
        public string FrameId
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired when page is about to start a download.
    /// Deprecated. Use Browser.downloadWillBegin instead.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class DownloadWillBeginEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Id of the frame that caused download to begin.
        /// </summary>
        [DataMember(Name = ("frameId"), IsRequired = (true))]
        public string FrameId
        {
            get;
            private set;
        }

        /// <summary>
        /// Global unique identifier of the download.
        /// </summary>
        [DataMember(Name = ("guid"), IsRequired = (true))]
        public string Guid
        {
            get;
            private set;
        }

        /// <summary>
        /// URL of the resource being downloaded.
        /// </summary>
        [DataMember(Name = ("url"), IsRequired = (true))]
        public string Url
        {
            get;
            private set;
        }

        /// <summary>
        /// Suggested file name of the resource (the actual name of the file saved on disk may differ).
        /// </summary>
        [DataMember(Name = ("suggestedFilename"), IsRequired = (true))]
        public string SuggestedFilename
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Download status.
    /// </summary>
    public enum DownloadProgressState
    {
        /// <summary>
        /// inProgress
        /// </summary>
        [EnumMember(Value = ("inProgress"))]
        InProgress,
        /// <summary>
        /// completed
        /// </summary>
        [EnumMember(Value = ("completed"))]
        Completed,
        /// <summary>
        /// canceled
        /// </summary>
        [EnumMember(Value = ("canceled"))]
        Canceled
    }

    /// <summary>
    /// Fired when download makes progress. Last call has |done| == true.
    /// Deprecated. Use Browser.downloadProgress instead.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class DownloadProgressEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Global unique identifier of the download.
        /// </summary>
        [DataMember(Name = ("guid"), IsRequired = (true))]
        public string Guid
        {
            get;
            private set;
        }

        /// <summary>
        /// Total expected bytes to download.
        /// </summary>
        [DataMember(Name = ("totalBytes"), IsRequired = (true))]
        public double TotalBytes
        {
            get;
            private set;
        }

        /// <summary>
        /// Total bytes received.
        /// </summary>
        [DataMember(Name = ("receivedBytes"), IsRequired = (true))]
        public double ReceivedBytes
        {
            get;
            private set;
        }

        /// <summary>
        /// Download status.
        /// </summary>
        public CefSharp.DevTools.Page.DownloadProgressState State
        {
            get
            {
                return (CefSharp.DevTools.Page.DownloadProgressState)(StringToEnum(typeof(CefSharp.DevTools.Page.DownloadProgressState), state));
            }

            set
            {
                this.state = (EnumToString(value));
            }
        }

        /// <summary>
        /// Download status.
        /// </summary>
        [DataMember(Name = ("state"), IsRequired = (true))]
        internal string state
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired when a JavaScript initiated dialog (alert, confirm, prompt, or onbeforeunload) has been
    /// closed.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class JavascriptDialogClosedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Whether dialog was confirmed.
        /// </summary>
        [DataMember(Name = ("result"), IsRequired = (true))]
        public bool Result
        {
            get;
            private set;
        }

        /// <summary>
        /// User input in case of prompt.
        /// </summary>
        [DataMember(Name = ("userInput"), IsRequired = (true))]
        public string UserInput
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired when a JavaScript initiated dialog (alert, confirm, prompt, or onbeforeunload) is about to
    /// open.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class JavascriptDialogOpeningEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Frame url.
        /// </summary>
        [DataMember(Name = ("url"), IsRequired = (true))]
        public string Url
        {
            get;
            private set;
        }

        /// <summary>
        /// Message that will be displayed by the dialog.
        /// </summary>
        [DataMember(Name = ("message"), IsRequired = (true))]
        public string Message
        {
            get;
            private set;
        }

        /// <summary>
        /// Dialog type.
        /// </summary>
        public CefSharp.DevTools.Page.DialogType Type
        {
            get
            {
                return (CefSharp.DevTools.Page.DialogType)(StringToEnum(typeof(CefSharp.DevTools.Page.DialogType), type));
            }

            set
            {
                this.type = (EnumToString(value));
            }
        }

        /// <summary>
        /// Dialog type.
        /// </summary>
        [DataMember(Name = ("type"), IsRequired = (true))]
        internal string type
        {
            get;
            private set;
        }

        /// <summary>
        /// True iff browser is capable showing or acting on the given dialog. When browser has no
        /// dialog handler for given target, calling alert while Page domain is engaged will stall
        /// the page execution. Execution can be resumed via calling Page.handleJavaScriptDialog.
        /// </summary>
        [DataMember(Name = ("hasBrowserHandler"), IsRequired = (true))]
        public bool HasBrowserHandler
        {
            get;
            private set;
        }

        /// <summary>
        /// Default dialog prompt.
        /// </summary>
        [DataMember(Name = ("defaultPrompt"), IsRequired = (false))]
        public string DefaultPrompt
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired for top level page lifecycle events such as navigation, load, paint, etc.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class LifecycleEventEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Id of the frame.
        /// </summary>
        [DataMember(Name = ("frameId"), IsRequired = (true))]
        public string FrameId
        {
            get;
            private set;
        }

        /// <summary>
        /// Loader identifier. Empty string if the request is fetched from worker.
        /// </summary>
        [DataMember(Name = ("loaderId"), IsRequired = (true))]
        public string LoaderId
        {
            get;
            private set;
        }

        /// <summary>
        /// Name
        /// </summary>
        [DataMember(Name = ("name"), IsRequired = (true))]
        public string Name
        {
            get;
            private set;
        }

        /// <summary>
        /// Timestamp
        /// </summary>
        [DataMember(Name = ("timestamp"), IsRequired = (true))]
        public double Timestamp
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired for failed bfcache history navigations if BackForwardCache feature is enabled. Do
    /// not assume any ordering with the Page.frameNavigated event. This event is fired only for
    /// main-frame history navigation where the document changes (non-same-document navigations),
    /// when bfcache navigation fails.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class BackForwardCacheNotUsedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// The loader id for the associated navigation.
        /// </summary>
        [DataMember(Name = ("loaderId"), IsRequired = (true))]
        public string LoaderId
        {
            get;
            private set;
        }

        /// <summary>
        /// The frame id of the associated frame.
        /// </summary>
        [DataMember(Name = ("frameId"), IsRequired = (true))]
        public string FrameId
        {
            get;
            private set;
        }

        /// <summary>
        /// Array of reasons why the page could not be cached. This must not be empty.
        /// </summary>
        [DataMember(Name = ("notRestoredExplanations"), IsRequired = (true))]
        public System.Collections.Generic.IList<CefSharp.DevTools.Page.BackForwardCacheNotRestoredExplanation> NotRestoredExplanations
        {
            get;
            private set;
        }

        /// <summary>
        /// Tree structure of reasons why the page could not be cached for each frame.
        /// </summary>
        [DataMember(Name = ("notRestoredExplanationsTree"), IsRequired = (false))]
        public CefSharp.DevTools.Page.BackForwardCacheNotRestoredExplanationTree NotRestoredExplanationsTree
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// loadEventFired
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class LoadEventFiredEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Timestamp
        /// </summary>
        [DataMember(Name = ("timestamp"), IsRequired = (true))]
        public double Timestamp
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Navigation type
    /// </summary>
    public enum NavigatedWithinDocumentNavigationType
    {
        /// <summary>
        /// fragment
        /// </summary>
        [EnumMember(Value = ("fragment"))]
        Fragment,
        /// <summary>
        /// historyApi
        /// </summary>
        [EnumMember(Value = ("historyApi"))]
        HistoryApi,
        /// <summary>
        /// other
        /// </summary>
        [EnumMember(Value = ("other"))]
        Other
    }

    /// <summary>
    /// Fired when same-document navigation happens, e.g. due to history API usage or anchor navigation.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class NavigatedWithinDocumentEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Id of the frame.
        /// </summary>
        [DataMember(Name = ("frameId"), IsRequired = (true))]
        public string FrameId
        {
            get;
            private set;
        }

        /// <summary>
        /// Frame&apos;s new url.
        /// </summary>
        [DataMember(Name = ("url"), IsRequired = (true))]
        public string Url
        {
            get;
            private set;
        }

        /// <summary>
        /// Navigation type
        /// </summary>
        public CefSharp.DevTools.Page.NavigatedWithinDocumentNavigationType NavigationType
        {
            get
            {
                return (CefSharp.DevTools.Page.NavigatedWithinDocumentNavigationType)(StringToEnum(typeof(CefSharp.DevTools.Page.NavigatedWithinDocumentNavigationType), navigationType));
            }

            set
            {
                this.navigationType = (EnumToString(value));
            }
        }

        /// <summary>
        /// Navigation type
        /// </summary>
        [DataMember(Name = ("navigationType"), IsRequired = (true))]
        internal string navigationType
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Compressed image data requested by the `startScreencast`.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class ScreencastFrameEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Base64-encoded compressed image.
        /// </summary>
        [DataMember(Name = ("data"), IsRequired = (true))]
        public byte[] Data
        {
            get;
            private set;
        }

        /// <summary>
        /// Screencast frame metadata.
        /// </summary>
        [DataMember(Name = ("metadata"), IsRequired = (true))]
        public CefSharp.DevTools.Page.ScreencastFrameMetadata Metadata
        {
            get;
            private set;
        }

        /// <summary>
        /// Frame number.
        /// </summary>
        [DataMember(Name = ("sessionId"), IsRequired = (true))]
        public int SessionId
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired when the page with currently enabled screencast was shown or hidden `.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class ScreencastVisibilityChangedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// True if the page is visible.
        /// </summary>
        [DataMember(Name = ("visible"), IsRequired = (true))]
        public bool Visible
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired when a new window is going to be opened, via window.open(), link click, form submission,
    /// etc.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class WindowOpenEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// The URL for the new window.
        /// </summary>
        [DataMember(Name = ("url"), IsRequired = (true))]
        public string Url
        {
            get;
            private set;
        }

        /// <summary>
        /// Window name.
        /// </summary>
        [DataMember(Name = ("windowName"), IsRequired = (true))]
        public string WindowName
        {
            get;
            private set;
        }

        /// <summary>
        /// An array of enabled window features.
        /// </summary>
        [DataMember(Name = ("windowFeatures"), IsRequired = (true))]
        public string[] WindowFeatures
        {
            get;
            private set;
        }

        /// <summary>
        /// Whether or not it was triggered by user gesture.
        /// </summary>
        [DataMember(Name = ("userGesture"), IsRequired = (true))]
        public bool UserGesture
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Issued for every compilation cache generated. Is only available
    /// if Page.setGenerateCompilationCache is enabled.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class CompilationCacheProducedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Url
        /// </summary>
        [DataMember(Name = ("url"), IsRequired = (true))]
        public string Url
        {
            get;
            private set;
        }

        /// <summary>
        /// Base64-encoded data
        /// </summary>
        [DataMember(Name = ("data"), IsRequired = (true))]
        public byte[] Data
        {
            get;
            private set;
        }
    }
}

namespace CefSharp.DevTools.Performance
{
    /// <summary>
    /// Run-time execution metric.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class Metric : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Metric name.
        /// </summary>
        [DataMember(Name = ("name"), IsRequired = (true))]
        public string Name
        {
            get;
            set;
        }

        /// <summary>
        /// Metric value.
        /// </summary>
        [DataMember(Name = ("value"), IsRequired = (true))]
        public double Value
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Current values of the metrics.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class MetricsEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Current values of the metrics.
        /// </summary>
        [DataMember(Name = ("metrics"), IsRequired = (true))]
        public System.Collections.Generic.IList<CefSharp.DevTools.Performance.Metric> Metrics
        {
            get;
            private set;
        }

        /// <summary>
        /// Timestamp title.
        /// </summary>
        [DataMember(Name = ("title"), IsRequired = (true))]
        public string Title
        {
            get;
            private set;
        }
    }
}

namespace CefSharp.DevTools.PerformanceTimeline
{
    /// <summary>
    /// See https://github.com/WICG/LargestContentfulPaint and largest_contentful_paint.idl
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class LargestContentfulPaint : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// RenderTime
        /// </summary>
        [DataMember(Name = ("renderTime"), IsRequired = (true))]
        public double RenderTime
        {
            get;
            set;
        }

        /// <summary>
        /// LoadTime
        /// </summary>
        [DataMember(Name = ("loadTime"), IsRequired = (true))]
        public double LoadTime
        {
            get;
            set;
        }

        /// <summary>
        /// The number of pixels being painted.
        /// </summary>
        [DataMember(Name = ("size"), IsRequired = (true))]
        public double Size
        {
            get;
            set;
        }

        /// <summary>
        /// The id attribute of the element, if available.
        /// </summary>
        [DataMember(Name = ("elementId"), IsRequired = (false))]
        public string ElementId
        {
            get;
            set;
        }

        /// <summary>
        /// The URL of the image (may be trimmed).
        /// </summary>
        [DataMember(Name = ("url"), IsRequired = (false))]
        public string Url
        {
            get;
            set;
        }

        /// <summary>
        /// NodeId
        /// </summary>
        [DataMember(Name = ("nodeId"), IsRequired = (false))]
        public int? NodeId
        {
            get;
            set;
        }
    }

    /// <summary>
    /// LayoutShiftAttribution
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class LayoutShiftAttribution : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// PreviousRect
        /// </summary>
        [DataMember(Name = ("previousRect"), IsRequired = (true))]
        public CefSharp.DevTools.DOM.Rect PreviousRect
        {
            get;
            set;
        }

        /// <summary>
        /// CurrentRect
        /// </summary>
        [DataMember(Name = ("currentRect"), IsRequired = (true))]
        public CefSharp.DevTools.DOM.Rect CurrentRect
        {
            get;
            set;
        }

        /// <summary>
        /// NodeId
        /// </summary>
        [DataMember(Name = ("nodeId"), IsRequired = (false))]
        public int? NodeId
        {
            get;
            set;
        }
    }

    /// <summary>
    /// See https://wicg.github.io/layout-instability/#sec-layout-shift and layout_shift.idl
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class LayoutShift : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Score increment produced by this event.
        /// </summary>
        [DataMember(Name = ("value"), IsRequired = (true))]
        public double Value
        {
            get;
            set;
        }

        /// <summary>
        /// HadRecentInput
        /// </summary>
        [DataMember(Name = ("hadRecentInput"), IsRequired = (true))]
        public bool HadRecentInput
        {
            get;
            set;
        }

        /// <summary>
        /// LastInputTime
        /// </summary>
        [DataMember(Name = ("lastInputTime"), IsRequired = (true))]
        public double LastInputTime
        {
            get;
            set;
        }

        /// <summary>
        /// Sources
        /// </summary>
        [DataMember(Name = ("sources"), IsRequired = (true))]
        public System.Collections.Generic.IList<CefSharp.DevTools.PerformanceTimeline.LayoutShiftAttribution> Sources
        {
            get;
            set;
        }
    }

    /// <summary>
    /// TimelineEvent
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class TimelineEvent : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Identifies the frame that this event is related to. Empty for non-frame targets.
        /// </summary>
        [DataMember(Name = ("frameId"), IsRequired = (true))]
        public string FrameId
        {
            get;
            set;
        }

        /// <summary>
        /// The event type, as specified in https://w3c.github.io/performance-timeline/#dom-performanceentry-entrytype
        /// This determines which of the optional &quot;details&quot; fields is present.
        /// </summary>
        [DataMember(Name = ("type"), IsRequired = (true))]
        public string Type
        {
            get;
            set;
        }

        /// <summary>
        /// Name may be empty depending on the type.
        /// </summary>
        [DataMember(Name = ("name"), IsRequired = (true))]
        public string Name
        {
            get;
            set;
        }

        /// <summary>
        /// Time in seconds since Epoch, monotonically increasing within document lifetime.
        /// </summary>
        [DataMember(Name = ("time"), IsRequired = (true))]
        public double Time
        {
            get;
            set;
        }

        /// <summary>
        /// Event duration, if applicable.
        /// </summary>
        [DataMember(Name = ("duration"), IsRequired = (false))]
        public double? Duration
        {
            get;
            set;
        }

        /// <summary>
        /// LcpDetails
        /// </summary>
        [DataMember(Name = ("lcpDetails"), IsRequired = (false))]
        public CefSharp.DevTools.PerformanceTimeline.LargestContentfulPaint LcpDetails
        {
            get;
            set;
        }

        /// <summary>
        /// LayoutShiftDetails
        /// </summary>
        [DataMember(Name = ("layoutShiftDetails"), IsRequired = (false))]
        public CefSharp.DevTools.PerformanceTimeline.LayoutShift LayoutShiftDetails
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Sent when a performance timeline event is added. See reportPerformanceTimeline method.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class TimelineEventAddedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Event
        /// </summary>
        [DataMember(Name = ("event"), IsRequired = (true))]
        public CefSharp.DevTools.PerformanceTimeline.TimelineEvent Event
        {
            get;
            private set;
        }
    }
}

namespace CefSharp.DevTools.Security
{
    /// <summary>
    /// A description of mixed content (HTTP resources on HTTPS pages), as defined by
    /// https://www.w3.org/TR/mixed-content/#categories
    /// </summary>
    public enum MixedContentType
    {
        /// <summary>
        /// blockable
        /// </summary>
        [EnumMember(Value = ("blockable"))]
        Blockable,
        /// <summary>
        /// optionally-blockable
        /// </summary>
        [EnumMember(Value = ("optionally-blockable"))]
        OptionallyBlockable,
        /// <summary>
        /// none
        /// </summary>
        [EnumMember(Value = ("none"))]
        None
    }

    /// <summary>
    /// The security level of a page or resource.
    /// </summary>
    public enum SecurityState
    {
        /// <summary>
        /// unknown
        /// </summary>
        [EnumMember(Value = ("unknown"))]
        Unknown,
        /// <summary>
        /// neutral
        /// </summary>
        [EnumMember(Value = ("neutral"))]
        Neutral,
        /// <summary>
        /// insecure
        /// </summary>
        [EnumMember(Value = ("insecure"))]
        Insecure,
        /// <summary>
        /// secure
        /// </summary>
        [EnumMember(Value = ("secure"))]
        Secure,
        /// <summary>
        /// info
        /// </summary>
        [EnumMember(Value = ("info"))]
        Info,
        /// <summary>
        /// insecure-broken
        /// </summary>
        [EnumMember(Value = ("insecure-broken"))]
        InsecureBroken
    }

    /// <summary>
    /// Details about the security state of the page certificate.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class CertificateSecurityState : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Protocol name (e.g. &quot;TLS 1.2&quot; or &quot;QUIC&quot;).
        /// </summary>
        [DataMember(Name = ("protocol"), IsRequired = (true))]
        public string Protocol
        {
            get;
            set;
        }

        /// <summary>
        /// Key Exchange used by the connection, or the empty string if not applicable.
        /// </summary>
        [DataMember(Name = ("keyExchange"), IsRequired = (true))]
        public string KeyExchange
        {
            get;
            set;
        }

        /// <summary>
        /// (EC)DH group used by the connection, if applicable.
        /// </summary>
        [DataMember(Name = ("keyExchangeGroup"), IsRequired = (false))]
        public string KeyExchangeGroup
        {
            get;
            set;
        }

        /// <summary>
        /// Cipher name.
        /// </summary>
        [DataMember(Name = ("cipher"), IsRequired = (true))]
        public string Cipher
        {
            get;
            set;
        }

        /// <summary>
        /// TLS MAC. Note that AEAD ciphers do not have separate MACs.
        /// </summary>
        [DataMember(Name = ("mac"), IsRequired = (false))]
        public string Mac
        {
            get;
            set;
        }

        /// <summary>
        /// Page certificate.
        /// </summary>
        [DataMember(Name = ("certificate"), IsRequired = (true))]
        public string[] Certificate
        {
            get;
            set;
        }

        /// <summary>
        /// Certificate subject name.
        /// </summary>
        [DataMember(Name = ("subjectName"), IsRequired = (true))]
        public string SubjectName
        {
            get;
            set;
        }

        /// <summary>
        /// Name of the issuing CA.
        /// </summary>
        [DataMember(Name = ("issuer"), IsRequired = (true))]
        public string Issuer
        {
            get;
            set;
        }

        /// <summary>
        /// Certificate valid from date.
        /// </summary>
        [DataMember(Name = ("validFrom"), IsRequired = (true))]
        public double ValidFrom
        {
            get;
            set;
        }

        /// <summary>
        /// Certificate valid to (expiration) date
        /// </summary>
        [DataMember(Name = ("validTo"), IsRequired = (true))]
        public double ValidTo
        {
            get;
            set;
        }

        /// <summary>
        /// The highest priority network error code, if the certificate has an error.
        /// </summary>
        [DataMember(Name = ("certificateNetworkError"), IsRequired = (false))]
        public string CertificateNetworkError
        {
            get;
            set;
        }

        /// <summary>
        /// True if the certificate uses a weak signature algorithm.
        /// </summary>
        [DataMember(Name = ("certificateHasWeakSignature"), IsRequired = (true))]
        public bool CertificateHasWeakSignature
        {
            get;
            set;
        }

        /// <summary>
        /// True if the certificate has a SHA1 signature in the chain.
        /// </summary>
        [DataMember(Name = ("certificateHasSha1Signature"), IsRequired = (true))]
        public bool CertificateHasSha1Signature
        {
            get;
            set;
        }

        /// <summary>
        /// True if modern SSL
        /// </summary>
        [DataMember(Name = ("modernSSL"), IsRequired = (true))]
        public bool ModernSSL
        {
            get;
            set;
        }

        /// <summary>
        /// True if the connection is using an obsolete SSL protocol.
        /// </summary>
        [DataMember(Name = ("obsoleteSslProtocol"), IsRequired = (true))]
        public bool ObsoleteSslProtocol
        {
            get;
            set;
        }

        /// <summary>
        /// True if the connection is using an obsolete SSL key exchange.
        /// </summary>
        [DataMember(Name = ("obsoleteSslKeyExchange"), IsRequired = (true))]
        public bool ObsoleteSslKeyExchange
        {
            get;
            set;
        }

        /// <summary>
        /// True if the connection is using an obsolete SSL cipher.
        /// </summary>
        [DataMember(Name = ("obsoleteSslCipher"), IsRequired = (true))]
        public bool ObsoleteSslCipher
        {
            get;
            set;
        }

        /// <summary>
        /// True if the connection is using an obsolete SSL signature.
        /// </summary>
        [DataMember(Name = ("obsoleteSslSignature"), IsRequired = (true))]
        public bool ObsoleteSslSignature
        {
            get;
            set;
        }
    }

    /// <summary>
    /// SafetyTipStatus
    /// </summary>
    public enum SafetyTipStatus
    {
        /// <summary>
        /// badReputation
        /// </summary>
        [EnumMember(Value = ("badReputation"))]
        BadReputation,
        /// <summary>
        /// lookalike
        /// </summary>
        [EnumMember(Value = ("lookalike"))]
        Lookalike
    }

    /// <summary>
    /// SafetyTipInfo
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class SafetyTipInfo : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Describes whether the page triggers any safety tips or reputation warnings. Default is unknown.
        /// </summary>
        public CefSharp.DevTools.Security.SafetyTipStatus SafetyTipStatus
        {
            get
            {
                return (CefSharp.DevTools.Security.SafetyTipStatus)(StringToEnum(typeof(CefSharp.DevTools.Security.SafetyTipStatus), safetyTipStatus));
            }

            set
            {
                this.safetyTipStatus = (EnumToString(value));
            }
        }

        /// <summary>
        /// Describes whether the page triggers any safety tips or reputation warnings. Default is unknown.
        /// </summary>
        [DataMember(Name = ("safetyTipStatus"), IsRequired = (true))]
        internal string safetyTipStatus
        {
            get;
            set;
        }

        /// <summary>
        /// The URL the safety tip suggested (&quot;Did you mean?&quot;). Only filled in for lookalike matches.
        /// </summary>
        [DataMember(Name = ("safeUrl"), IsRequired = (false))]
        public string SafeUrl
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Security state information about the page.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class VisibleSecurityState : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The security level of the page.
        /// </summary>
        public CefSharp.DevTools.Security.SecurityState SecurityState
        {
            get
            {
                return (CefSharp.DevTools.Security.SecurityState)(StringToEnum(typeof(CefSharp.DevTools.Security.SecurityState), securityState));
            }

            set
            {
                this.securityState = (EnumToString(value));
            }
        }

        /// <summary>
        /// The security level of the page.
        /// </summary>
        [DataMember(Name = ("securityState"), IsRequired = (true))]
        internal string securityState
        {
            get;
            set;
        }

        /// <summary>
        /// Security state details about the page certificate.
        /// </summary>
        [DataMember(Name = ("certificateSecurityState"), IsRequired = (false))]
        public CefSharp.DevTools.Security.CertificateSecurityState CertificateSecurityState
        {
            get;
            set;
        }

        /// <summary>
        /// The type of Safety Tip triggered on the page. Note that this field will be set even if the Safety Tip UI was not actually shown.
        /// </summary>
        [DataMember(Name = ("safetyTipInfo"), IsRequired = (false))]
        public CefSharp.DevTools.Security.SafetyTipInfo SafetyTipInfo
        {
            get;
            set;
        }

        /// <summary>
        /// Array of security state issues ids.
        /// </summary>
        [DataMember(Name = ("securityStateIssueIds"), IsRequired = (true))]
        public string[] SecurityStateIssueIds
        {
            get;
            set;
        }
    }

    /// <summary>
    /// An explanation of an factor contributing to the security state.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class SecurityStateExplanation : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Security state representing the severity of the factor being explained.
        /// </summary>
        public CefSharp.DevTools.Security.SecurityState SecurityState
        {
            get
            {
                return (CefSharp.DevTools.Security.SecurityState)(StringToEnum(typeof(CefSharp.DevTools.Security.SecurityState), securityState));
            }

            set
            {
                this.securityState = (EnumToString(value));
            }
        }

        /// <summary>
        /// Security state representing the severity of the factor being explained.
        /// </summary>
        [DataMember(Name = ("securityState"), IsRequired = (true))]
        internal string securityState
        {
            get;
            set;
        }

        /// <summary>
        /// Title describing the type of factor.
        /// </summary>
        [DataMember(Name = ("title"), IsRequired = (true))]
        public string Title
        {
            get;
            set;
        }

        /// <summary>
        /// Short phrase describing the type of factor.
        /// </summary>
        [DataMember(Name = ("summary"), IsRequired = (true))]
        public string Summary
        {
            get;
            set;
        }

        /// <summary>
        /// Full text explanation of the factor.
        /// </summary>
        [DataMember(Name = ("description"), IsRequired = (true))]
        public string Description
        {
            get;
            set;
        }

        /// <summary>
        /// The type of mixed content described by the explanation.
        /// </summary>
        public CefSharp.DevTools.Security.MixedContentType MixedContentType
        {
            get
            {
                return (CefSharp.DevTools.Security.MixedContentType)(StringToEnum(typeof(CefSharp.DevTools.Security.MixedContentType), mixedContentType));
            }

            set
            {
                this.mixedContentType = (EnumToString(value));
            }
        }

        /// <summary>
        /// The type of mixed content described by the explanation.
        /// </summary>
        [DataMember(Name = ("mixedContentType"), IsRequired = (true))]
        internal string mixedContentType
        {
            get;
            set;
        }

        /// <summary>
        /// Page certificate.
        /// </summary>
        [DataMember(Name = ("certificate"), IsRequired = (true))]
        public string[] Certificate
        {
            get;
            set;
        }

        /// <summary>
        /// Recommendations to fix any issues.
        /// </summary>
        [DataMember(Name = ("recommendations"), IsRequired = (false))]
        public string[] Recommendations
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Information about insecure content on the page.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class InsecureContentStatus : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Always false.
        /// </summary>
        [DataMember(Name = ("ranMixedContent"), IsRequired = (true))]
        public bool RanMixedContent
        {
            get;
            set;
        }

        /// <summary>
        /// Always false.
        /// </summary>
        [DataMember(Name = ("displayedMixedContent"), IsRequired = (true))]
        public bool DisplayedMixedContent
        {
            get;
            set;
        }

        /// <summary>
        /// Always false.
        /// </summary>
        [DataMember(Name = ("containedMixedForm"), IsRequired = (true))]
        public bool ContainedMixedForm
        {
            get;
            set;
        }

        /// <summary>
        /// Always false.
        /// </summary>
        [DataMember(Name = ("ranContentWithCertErrors"), IsRequired = (true))]
        public bool RanContentWithCertErrors
        {
            get;
            set;
        }

        /// <summary>
        /// Always false.
        /// </summary>
        [DataMember(Name = ("displayedContentWithCertErrors"), IsRequired = (true))]
        public bool DisplayedContentWithCertErrors
        {
            get;
            set;
        }

        /// <summary>
        /// Always set to unknown.
        /// </summary>
        public CefSharp.DevTools.Security.SecurityState RanInsecureContentStyle
        {
            get
            {
                return (CefSharp.DevTools.Security.SecurityState)(StringToEnum(typeof(CefSharp.DevTools.Security.SecurityState), ranInsecureContentStyle));
            }

            set
            {
                this.ranInsecureContentStyle = (EnumToString(value));
            }
        }

        /// <summary>
        /// Always set to unknown.
        /// </summary>
        [DataMember(Name = ("ranInsecureContentStyle"), IsRequired = (true))]
        internal string ranInsecureContentStyle
        {
            get;
            set;
        }

        /// <summary>
        /// Always set to unknown.
        /// </summary>
        public CefSharp.DevTools.Security.SecurityState DisplayedInsecureContentStyle
        {
            get
            {
                return (CefSharp.DevTools.Security.SecurityState)(StringToEnum(typeof(CefSharp.DevTools.Security.SecurityState), displayedInsecureContentStyle));
            }

            set
            {
                this.displayedInsecureContentStyle = (EnumToString(value));
            }
        }

        /// <summary>
        /// Always set to unknown.
        /// </summary>
        [DataMember(Name = ("displayedInsecureContentStyle"), IsRequired = (true))]
        internal string displayedInsecureContentStyle
        {
            get;
            set;
        }
    }

    /// <summary>
    /// The action to take when a certificate error occurs. continue will continue processing the
    /// request and cancel will cancel the request.
    /// </summary>
    public enum CertificateErrorAction
    {
        /// <summary>
        /// continue
        /// </summary>
        [EnumMember(Value = ("continue"))]
        Continue,
        /// <summary>
        /// cancel
        /// </summary>
        [EnumMember(Value = ("cancel"))]
        Cancel
    }

    /// <summary>
    /// There is a certificate error. If overriding certificate errors is enabled, then it should be
    /// handled with the `handleCertificateError` command. Note: this event does not fire if the
    /// certificate error has been allowed internally. Only one client per target should override
    /// certificate errors at the same time.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class CertificateErrorEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// The ID of the event.
        /// </summary>
        [DataMember(Name = ("eventId"), IsRequired = (true))]
        public int EventId
        {
            get;
            private set;
        }

        /// <summary>
        /// The type of the error.
        /// </summary>
        [DataMember(Name = ("errorType"), IsRequired = (true))]
        public string ErrorType
        {
            get;
            private set;
        }

        /// <summary>
        /// The url that was requested.
        /// </summary>
        [DataMember(Name = ("requestURL"), IsRequired = (true))]
        public string RequestURL
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// The security state of the page changed.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class VisibleSecurityStateChangedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Security state information about the page.
        /// </summary>
        [DataMember(Name = ("visibleSecurityState"), IsRequired = (true))]
        public CefSharp.DevTools.Security.VisibleSecurityState VisibleSecurityState
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// The security state of the page changed. No longer being sent.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class SecurityStateChangedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Security state.
        /// </summary>
        public CefSharp.DevTools.Security.SecurityState SecurityState
        {
            get
            {
                return (CefSharp.DevTools.Security.SecurityState)(StringToEnum(typeof(CefSharp.DevTools.Security.SecurityState), securityState));
            }

            set
            {
                this.securityState = (EnumToString(value));
            }
        }

        /// <summary>
        /// Security state.
        /// </summary>
        [DataMember(Name = ("securityState"), IsRequired = (true))]
        internal string securityState
        {
            get;
            private set;
        }

        /// <summary>
        /// True if the page was loaded over cryptographic transport such as HTTPS.
        /// </summary>
        [DataMember(Name = ("schemeIsCryptographic"), IsRequired = (true))]
        public bool SchemeIsCryptographic
        {
            get;
            private set;
        }

        /// <summary>
        /// Previously a list of explanations for the security state. Now always
        /// empty.
        /// </summary>
        [DataMember(Name = ("explanations"), IsRequired = (true))]
        public System.Collections.Generic.IList<CefSharp.DevTools.Security.SecurityStateExplanation> Explanations
        {
            get;
            private set;
        }

        /// <summary>
        /// Information about insecure content on the page.
        /// </summary>
        [DataMember(Name = ("insecureContentStatus"), IsRequired = (true))]
        public CefSharp.DevTools.Security.InsecureContentStatus InsecureContentStatus
        {
            get;
            private set;
        }

        /// <summary>
        /// Overrides user-visible description of the state. Always omitted.
        /// </summary>
        [DataMember(Name = ("summary"), IsRequired = (false))]
        public string Summary
        {
            get;
            private set;
        }
    }
}

namespace CefSharp.DevTools.ServiceWorker
{
    /// <summary>
    /// ServiceWorker registration.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class ServiceWorkerRegistration : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// RegistrationId
        /// </summary>
        [DataMember(Name = ("registrationId"), IsRequired = (true))]
        public string RegistrationId
        {
            get;
            set;
        }

        /// <summary>
        /// ScopeURL
        /// </summary>
        [DataMember(Name = ("scopeURL"), IsRequired = (true))]
        public string ScopeURL
        {
            get;
            set;
        }

        /// <summary>
        /// IsDeleted
        /// </summary>
        [DataMember(Name = ("isDeleted"), IsRequired = (true))]
        public bool IsDeleted
        {
            get;
            set;
        }
    }

    /// <summary>
    /// ServiceWorkerVersionRunningStatus
    /// </summary>
    public enum ServiceWorkerVersionRunningStatus
    {
        /// <summary>
        /// stopped
        /// </summary>
        [EnumMember(Value = ("stopped"))]
        Stopped,
        /// <summary>
        /// starting
        /// </summary>
        [EnumMember(Value = ("starting"))]
        Starting,
        /// <summary>
        /// running
        /// </summary>
        [EnumMember(Value = ("running"))]
        Running,
        /// <summary>
        /// stopping
        /// </summary>
        [EnumMember(Value = ("stopping"))]
        Stopping
    }

    /// <summary>
    /// ServiceWorkerVersionStatus
    /// </summary>
    public enum ServiceWorkerVersionStatus
    {
        /// <summary>
        /// new
        /// </summary>
        [EnumMember(Value = ("new"))]
        New,
        /// <summary>
        /// installing
        /// </summary>
        [EnumMember(Value = ("installing"))]
        Installing,
        /// <summary>
        /// installed
        /// </summary>
        [EnumMember(Value = ("installed"))]
        Installed,
        /// <summary>
        /// activating
        /// </summary>
        [EnumMember(Value = ("activating"))]
        Activating,
        /// <summary>
        /// activated
        /// </summary>
        [EnumMember(Value = ("activated"))]
        Activated,
        /// <summary>
        /// redundant
        /// </summary>
        [EnumMember(Value = ("redundant"))]
        Redundant
    }

    /// <summary>
    /// ServiceWorker version.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class ServiceWorkerVersion : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// VersionId
        /// </summary>
        [DataMember(Name = ("versionId"), IsRequired = (true))]
        public string VersionId
        {
            get;
            set;
        }

        /// <summary>
        /// RegistrationId
        /// </summary>
        [DataMember(Name = ("registrationId"), IsRequired = (true))]
        public string RegistrationId
        {
            get;
            set;
        }

        /// <summary>
        /// ScriptURL
        /// </summary>
        [DataMember(Name = ("scriptURL"), IsRequired = (true))]
        public string ScriptURL
        {
            get;
            set;
        }

        /// <summary>
        /// RunningStatus
        /// </summary>
        public CefSharp.DevTools.ServiceWorker.ServiceWorkerVersionRunningStatus RunningStatus
        {
            get
            {
                return (CefSharp.DevTools.ServiceWorker.ServiceWorkerVersionRunningStatus)(StringToEnum(typeof(CefSharp.DevTools.ServiceWorker.ServiceWorkerVersionRunningStatus), runningStatus));
            }

            set
            {
                this.runningStatus = (EnumToString(value));
            }
        }

        /// <summary>
        /// RunningStatus
        /// </summary>
        [DataMember(Name = ("runningStatus"), IsRequired = (true))]
        internal string runningStatus
        {
            get;
            set;
        }

        /// <summary>
        /// Status
        /// </summary>
        public CefSharp.DevTools.ServiceWorker.ServiceWorkerVersionStatus Status
        {
            get
            {
                return (CefSharp.DevTools.ServiceWorker.ServiceWorkerVersionStatus)(StringToEnum(typeof(CefSharp.DevTools.ServiceWorker.ServiceWorkerVersionStatus), status));
            }

            set
            {
                this.status = (EnumToString(value));
            }
        }

        /// <summary>
        /// Status
        /// </summary>
        [DataMember(Name = ("status"), IsRequired = (true))]
        internal string status
        {
            get;
            set;
        }

        /// <summary>
        /// The Last-Modified header value of the main script.
        /// </summary>
        [DataMember(Name = ("scriptLastModified"), IsRequired = (false))]
        public double? ScriptLastModified
        {
            get;
            set;
        }

        /// <summary>
        /// The time at which the response headers of the main script were received from the server.
        /// For cached script it is the last time the cache entry was validated.
        /// </summary>
        [DataMember(Name = ("scriptResponseTime"), IsRequired = (false))]
        public double? ScriptResponseTime
        {
            get;
            set;
        }

        /// <summary>
        /// ControlledClients
        /// </summary>
        [DataMember(Name = ("controlledClients"), IsRequired = (false))]
        public string[] ControlledClients
        {
            get;
            set;
        }

        /// <summary>
        /// TargetId
        /// </summary>
        [DataMember(Name = ("targetId"), IsRequired = (false))]
        public string TargetId
        {
            get;
            set;
        }

        /// <summary>
        /// RouterRules
        /// </summary>
        [DataMember(Name = ("routerRules"), IsRequired = (false))]
        public string RouterRules
        {
            get;
            set;
        }
    }

    /// <summary>
    /// ServiceWorker error message.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class ServiceWorkerErrorMessage : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// ErrorMessage
        /// </summary>
        [DataMember(Name = ("errorMessage"), IsRequired = (true))]
        public string ErrorMessage
        {
            get;
            set;
        }

        /// <summary>
        /// RegistrationId
        /// </summary>
        [DataMember(Name = ("registrationId"), IsRequired = (true))]
        public string RegistrationId
        {
            get;
            set;
        }

        /// <summary>
        /// VersionId
        /// </summary>
        [DataMember(Name = ("versionId"), IsRequired = (true))]
        public string VersionId
        {
            get;
            set;
        }

        /// <summary>
        /// SourceURL
        /// </summary>
        [DataMember(Name = ("sourceURL"), IsRequired = (true))]
        public string SourceURL
        {
            get;
            set;
        }

        /// <summary>
        /// LineNumber
        /// </summary>
        [DataMember(Name = ("lineNumber"), IsRequired = (true))]
        public int LineNumber
        {
            get;
            set;
        }

        /// <summary>
        /// ColumnNumber
        /// </summary>
        [DataMember(Name = ("columnNumber"), IsRequired = (true))]
        public int ColumnNumber
        {
            get;
            set;
        }
    }

    /// <summary>
    /// workerErrorReported
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class WorkerErrorReportedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// ErrorMessage
        /// </summary>
        [DataMember(Name = ("errorMessage"), IsRequired = (true))]
        public CefSharp.DevTools.ServiceWorker.ServiceWorkerErrorMessage ErrorMessage
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// workerRegistrationUpdated
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class WorkerRegistrationUpdatedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Registrations
        /// </summary>
        [DataMember(Name = ("registrations"), IsRequired = (true))]
        public System.Collections.Generic.IList<CefSharp.DevTools.ServiceWorker.ServiceWorkerRegistration> Registrations
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// workerVersionUpdated
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class WorkerVersionUpdatedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Versions
        /// </summary>
        [DataMember(Name = ("versions"), IsRequired = (true))]
        public System.Collections.Generic.IList<CefSharp.DevTools.ServiceWorker.ServiceWorkerVersion> Versions
        {
            get;
            private set;
        }
    }
}

namespace CefSharp.DevTools.Storage
{
    /// <summary>
    /// Enum of possible storage types.
    /// </summary>
    public enum StorageType
    {
        /// <summary>
        /// appcache
        /// </summary>
        [EnumMember(Value = ("appcache"))]
        Appcache,
        /// <summary>
        /// cookies
        /// </summary>
        [EnumMember(Value = ("cookies"))]
        Cookies,
        /// <summary>
        /// file_systems
        /// </summary>
        [EnumMember(Value = ("file_systems"))]
        FileSystems,
        /// <summary>
        /// indexeddb
        /// </summary>
        [EnumMember(Value = ("indexeddb"))]
        Indexeddb,
        /// <summary>
        /// local_storage
        /// </summary>
        [EnumMember(Value = ("local_storage"))]
        LocalStorage,
        /// <summary>
        /// shader_cache
        /// </summary>
        [EnumMember(Value = ("shader_cache"))]
        ShaderCache,
        /// <summary>
        /// websql
        /// </summary>
        [EnumMember(Value = ("websql"))]
        Websql,
        /// <summary>
        /// service_workers
        /// </summary>
        [EnumMember(Value = ("service_workers"))]
        ServiceWorkers,
        /// <summary>
        /// cache_storage
        /// </summary>
        [EnumMember(Value = ("cache_storage"))]
        CacheStorage,
        /// <summary>
        /// interest_groups
        /// </summary>
        [EnumMember(Value = ("interest_groups"))]
        InterestGroups,
        /// <summary>
        /// shared_storage
        /// </summary>
        [EnumMember(Value = ("shared_storage"))]
        SharedStorage,
        /// <summary>
        /// storage_buckets
        /// </summary>
        [EnumMember(Value = ("storage_buckets"))]
        StorageBuckets,
        /// <summary>
        /// all
        /// </summary>
        [EnumMember(Value = ("all"))]
        All,
        /// <summary>
        /// other
        /// </summary>
        [EnumMember(Value = ("other"))]
        Other
    }

    /// <summary>
    /// Usage for a storage type.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class UsageForType : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Name of storage type.
        /// </summary>
        public CefSharp.DevTools.Storage.StorageType StorageType
        {
            get
            {
                return (CefSharp.DevTools.Storage.StorageType)(StringToEnum(typeof(CefSharp.DevTools.Storage.StorageType), storageType));
            }

            set
            {
                this.storageType = (EnumToString(value));
            }
        }

        /// <summary>
        /// Name of storage type.
        /// </summary>
        [DataMember(Name = ("storageType"), IsRequired = (true))]
        internal string storageType
        {
            get;
            set;
        }

        /// <summary>
        /// Storage usage (bytes).
        /// </summary>
        [DataMember(Name = ("usage"), IsRequired = (true))]
        public double Usage
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Pair of issuer origin and number of available (signed, but not used) Trust
    /// Tokens from that issuer.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class TrustTokens : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// IssuerOrigin
        /// </summary>
        [DataMember(Name = ("issuerOrigin"), IsRequired = (true))]
        public string IssuerOrigin
        {
            get;
            set;
        }

        /// <summary>
        /// Count
        /// </summary>
        [DataMember(Name = ("count"), IsRequired = (true))]
        public double Count
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Enum of interest group access types.
    /// </summary>
    public enum InterestGroupAccessType
    {
        /// <summary>
        /// join
        /// </summary>
        [EnumMember(Value = ("join"))]
        Join,
        /// <summary>
        /// leave
        /// </summary>
        [EnumMember(Value = ("leave"))]
        Leave,
        /// <summary>
        /// update
        /// </summary>
        [EnumMember(Value = ("update"))]
        Update,
        /// <summary>
        /// loaded
        /// </summary>
        [EnumMember(Value = ("loaded"))]
        Loaded,
        /// <summary>
        /// bid
        /// </summary>
        [EnumMember(Value = ("bid"))]
        Bid,
        /// <summary>
        /// win
        /// </summary>
        [EnumMember(Value = ("win"))]
        Win,
        /// <summary>
        /// additionalBid
        /// </summary>
        [EnumMember(Value = ("additionalBid"))]
        AdditionalBid,
        /// <summary>
        /// additionalBidWin
        /// </summary>
        [EnumMember(Value = ("additionalBidWin"))]
        AdditionalBidWin,
        /// <summary>
        /// topLevelBid
        /// </summary>
        [EnumMember(Value = ("topLevelBid"))]
        TopLevelBid,
        /// <summary>
        /// topLevelAdditionalBid
        /// </summary>
        [EnumMember(Value = ("topLevelAdditionalBid"))]
        TopLevelAdditionalBid,
        /// <summary>
        /// clear
        /// </summary>
        [EnumMember(Value = ("clear"))]
        Clear
    }

    /// <summary>
    /// Enum of auction events.
    /// </summary>
    public enum InterestGroupAuctionEventType
    {
        /// <summary>
        /// started
        /// </summary>
        [EnumMember(Value = ("started"))]
        Started,
        /// <summary>
        /// configResolved
        /// </summary>
        [EnumMember(Value = ("configResolved"))]
        ConfigResolved
    }

    /// <summary>
    /// Enum of network fetches auctions can do.
    /// </summary>
    public enum InterestGroupAuctionFetchType
    {
        /// <summary>
        /// bidderJs
        /// </summary>
        [EnumMember(Value = ("bidderJs"))]
        BidderJs,
        /// <summary>
        /// bidderWasm
        /// </summary>
        [EnumMember(Value = ("bidderWasm"))]
        BidderWasm,
        /// <summary>
        /// sellerJs
        /// </summary>
        [EnumMember(Value = ("sellerJs"))]
        SellerJs,
        /// <summary>
        /// bidderTrustedSignals
        /// </summary>
        [EnumMember(Value = ("bidderTrustedSignals"))]
        BidderTrustedSignals,
        /// <summary>
        /// sellerTrustedSignals
        /// </summary>
        [EnumMember(Value = ("sellerTrustedSignals"))]
        SellerTrustedSignals
    }

    /// <summary>
    /// Enum of shared storage access types.
    /// </summary>
    public enum SharedStorageAccessType
    {
        /// <summary>
        /// documentAddModule
        /// </summary>
        [EnumMember(Value = ("documentAddModule"))]
        DocumentAddModule,
        /// <summary>
        /// documentSelectURL
        /// </summary>
        [EnumMember(Value = ("documentSelectURL"))]
        DocumentSelectURL,
        /// <summary>
        /// documentRun
        /// </summary>
        [EnumMember(Value = ("documentRun"))]
        DocumentRun,
        /// <summary>
        /// documentSet
        /// </summary>
        [EnumMember(Value = ("documentSet"))]
        DocumentSet,
        /// <summary>
        /// documentAppend
        /// </summary>
        [EnumMember(Value = ("documentAppend"))]
        DocumentAppend,
        /// <summary>
        /// documentDelete
        /// </summary>
        [EnumMember(Value = ("documentDelete"))]
        DocumentDelete,
        /// <summary>
        /// documentClear
        /// </summary>
        [EnumMember(Value = ("documentClear"))]
        DocumentClear,
        /// <summary>
        /// documentGet
        /// </summary>
        [EnumMember(Value = ("documentGet"))]
        DocumentGet,
        /// <summary>
        /// workletSet
        /// </summary>
        [EnumMember(Value = ("workletSet"))]
        WorkletSet,
        /// <summary>
        /// workletAppend
        /// </summary>
        [EnumMember(Value = ("workletAppend"))]
        WorkletAppend,
        /// <summary>
        /// workletDelete
        /// </summary>
        [EnumMember(Value = ("workletDelete"))]
        WorkletDelete,
        /// <summary>
        /// workletClear
        /// </summary>
        [EnumMember(Value = ("workletClear"))]
        WorkletClear,
        /// <summary>
        /// workletGet
        /// </summary>
        [EnumMember(Value = ("workletGet"))]
        WorkletGet,
        /// <summary>
        /// workletKeys
        /// </summary>
        [EnumMember(Value = ("workletKeys"))]
        WorkletKeys,
        /// <summary>
        /// workletEntries
        /// </summary>
        [EnumMember(Value = ("workletEntries"))]
        WorkletEntries,
        /// <summary>
        /// workletLength
        /// </summary>
        [EnumMember(Value = ("workletLength"))]
        WorkletLength,
        /// <summary>
        /// workletRemainingBudget
        /// </summary>
        [EnumMember(Value = ("workletRemainingBudget"))]
        WorkletRemainingBudget,
        /// <summary>
        /// headerSet
        /// </summary>
        [EnumMember(Value = ("headerSet"))]
        HeaderSet,
        /// <summary>
        /// headerAppend
        /// </summary>
        [EnumMember(Value = ("headerAppend"))]
        HeaderAppend,
        /// <summary>
        /// headerDelete
        /// </summary>
        [EnumMember(Value = ("headerDelete"))]
        HeaderDelete,
        /// <summary>
        /// headerClear
        /// </summary>
        [EnumMember(Value = ("headerClear"))]
        HeaderClear
    }

    /// <summary>
    /// Struct for a single key-value pair in an origin&apos;s shared storage.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class SharedStorageEntry : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Key
        /// </summary>
        [DataMember(Name = ("key"), IsRequired = (true))]
        public string Key
        {
            get;
            set;
        }

        /// <summary>
        /// Value
        /// </summary>
        [DataMember(Name = ("value"), IsRequired = (true))]
        public string Value
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Details for an origin&apos;s shared storage.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class SharedStorageMetadata : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Time when the origin&apos;s shared storage was last created.
        /// </summary>
        [DataMember(Name = ("creationTime"), IsRequired = (true))]
        public double CreationTime
        {
            get;
            set;
        }

        /// <summary>
        /// Number of key-value pairs stored in origin&apos;s shared storage.
        /// </summary>
        [DataMember(Name = ("length"), IsRequired = (true))]
        public int Length
        {
            get;
            set;
        }

        /// <summary>
        /// Current amount of bits of entropy remaining in the navigation budget.
        /// </summary>
        [DataMember(Name = ("remainingBudget"), IsRequired = (true))]
        public double RemainingBudget
        {
            get;
            set;
        }

        /// <summary>
        /// Total number of bytes stored as key-value pairs in origin&apos;s shared
        /// storage.
        /// </summary>
        [DataMember(Name = ("bytesUsed"), IsRequired = (true))]
        public int BytesUsed
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Pair of reporting metadata details for a candidate URL for `selectURL()`.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class SharedStorageReportingMetadata : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// EventType
        /// </summary>
        [DataMember(Name = ("eventType"), IsRequired = (true))]
        public string EventType
        {
            get;
            set;
        }

        /// <summary>
        /// ReportingUrl
        /// </summary>
        [DataMember(Name = ("reportingUrl"), IsRequired = (true))]
        public string ReportingUrl
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Bundles a candidate URL with its reporting metadata.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class SharedStorageUrlWithMetadata : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Spec of candidate URL.
        /// </summary>
        [DataMember(Name = ("url"), IsRequired = (true))]
        public string Url
        {
            get;
            set;
        }

        /// <summary>
        /// Any associated reporting metadata.
        /// </summary>
        [DataMember(Name = ("reportingMetadata"), IsRequired = (true))]
        public System.Collections.Generic.IList<CefSharp.DevTools.Storage.SharedStorageReportingMetadata> ReportingMetadata
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Bundles the parameters for shared storage access events whose
    /// presence/absence can vary according to SharedStorageAccessType.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class SharedStorageAccessParams : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Spec of the module script URL.
        /// Present only for SharedStorageAccessType.documentAddModule.
        /// </summary>
        [DataMember(Name = ("scriptSourceUrl"), IsRequired = (false))]
        public string ScriptSourceUrl
        {
            get;
            set;
        }

        /// <summary>
        /// Name of the registered operation to be run.
        /// Present only for SharedStorageAccessType.documentRun and
        /// SharedStorageAccessType.documentSelectURL.
        /// </summary>
        [DataMember(Name = ("operationName"), IsRequired = (false))]
        public string OperationName
        {
            get;
            set;
        }

        /// <summary>
        /// The operation&apos;s serialized data in bytes (converted to a string).
        /// Present only for SharedStorageAccessType.documentRun and
        /// SharedStorageAccessType.documentSelectURL.
        /// </summary>
        [DataMember(Name = ("serializedData"), IsRequired = (false))]
        public string SerializedData
        {
            get;
            set;
        }

        /// <summary>
        /// Array of candidate URLs&apos; specs, along with any associated metadata.
        /// Present only for SharedStorageAccessType.documentSelectURL.
        /// </summary>
        [DataMember(Name = ("urlsWithMetadata"), IsRequired = (false))]
        public System.Collections.Generic.IList<CefSharp.DevTools.Storage.SharedStorageUrlWithMetadata> UrlsWithMetadata
        {
            get;
            set;
        }

        /// <summary>
        /// Key for a specific entry in an origin&apos;s shared storage.
        /// Present only for SharedStorageAccessType.documentSet,
        /// SharedStorageAccessType.documentAppend,
        /// SharedStorageAccessType.documentDelete,
        /// SharedStorageAccessType.workletSet,
        /// SharedStorageAccessType.workletAppend,
        /// SharedStorageAccessType.workletDelete,
        /// SharedStorageAccessType.workletGet,
        /// SharedStorageAccessType.headerSet,
        /// SharedStorageAccessType.headerAppend, and
        /// SharedStorageAccessType.headerDelete.
        /// </summary>
        [DataMember(Name = ("key"), IsRequired = (false))]
        public string Key
        {
            get;
            set;
        }

        /// <summary>
        /// Value for a specific entry in an origin&apos;s shared storage.
        /// Present only for SharedStorageAccessType.documentSet,
        /// SharedStorageAccessType.documentAppend,
        /// SharedStorageAccessType.workletSet,
        /// SharedStorageAccessType.workletAppend,
        /// SharedStorageAccessType.headerSet, and
        /// SharedStorageAccessType.headerAppend.
        /// </summary>
        [DataMember(Name = ("value"), IsRequired = (false))]
        public string Value
        {
            get;
            set;
        }

        /// <summary>
        /// Whether or not to set an entry for a key if that key is already present.
        /// Present only for SharedStorageAccessType.documentSet,
        /// SharedStorageAccessType.workletSet, and
        /// SharedStorageAccessType.headerSet.
        /// </summary>
        [DataMember(Name = ("ignoreIfPresent"), IsRequired = (false))]
        public bool? IgnoreIfPresent
        {
            get;
            set;
        }
    }

    /// <summary>
    /// StorageBucketsDurability
    /// </summary>
    public enum StorageBucketsDurability
    {
        /// <summary>
        /// relaxed
        /// </summary>
        [EnumMember(Value = ("relaxed"))]
        Relaxed,
        /// <summary>
        /// strict
        /// </summary>
        [EnumMember(Value = ("strict"))]
        Strict
    }

    /// <summary>
    /// StorageBucket
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class StorageBucket : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// StorageKey
        /// </summary>
        [DataMember(Name = ("storageKey"), IsRequired = (true))]
        public string StorageKey
        {
            get;
            set;
        }

        /// <summary>
        /// If not specified, it is the default bucket of the storageKey.
        /// </summary>
        [DataMember(Name = ("name"), IsRequired = (false))]
        public string Name
        {
            get;
            set;
        }
    }

    /// <summary>
    /// StorageBucketInfo
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class StorageBucketInfo : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Bucket
        /// </summary>
        [DataMember(Name = ("bucket"), IsRequired = (true))]
        public CefSharp.DevTools.Storage.StorageBucket Bucket
        {
            get;
            set;
        }

        /// <summary>
        /// Id
        /// </summary>
        [DataMember(Name = ("id"), IsRequired = (true))]
        public string Id
        {
            get;
            set;
        }

        /// <summary>
        /// Expiration
        /// </summary>
        [DataMember(Name = ("expiration"), IsRequired = (true))]
        public double Expiration
        {
            get;
            set;
        }

        /// <summary>
        /// Storage quota (bytes).
        /// </summary>
        [DataMember(Name = ("quota"), IsRequired = (true))]
        public double Quota
        {
            get;
            set;
        }

        /// <summary>
        /// Persistent
        /// </summary>
        [DataMember(Name = ("persistent"), IsRequired = (true))]
        public bool Persistent
        {
            get;
            set;
        }

        /// <summary>
        /// Durability
        /// </summary>
        public CefSharp.DevTools.Storage.StorageBucketsDurability Durability
        {
            get
            {
                return (CefSharp.DevTools.Storage.StorageBucketsDurability)(StringToEnum(typeof(CefSharp.DevTools.Storage.StorageBucketsDurability), durability));
            }

            set
            {
                this.durability = (EnumToString(value));
            }
        }

        /// <summary>
        /// Durability
        /// </summary>
        [DataMember(Name = ("durability"), IsRequired = (true))]
        internal string durability
        {
            get;
            set;
        }
    }

    /// <summary>
    /// AttributionReportingSourceType
    /// </summary>
    public enum AttributionReportingSourceType
    {
        /// <summary>
        /// navigation
        /// </summary>
        [EnumMember(Value = ("navigation"))]
        Navigation,
        /// <summary>
        /// event
        /// </summary>
        [EnumMember(Value = ("event"))]
        Event
    }

    /// <summary>
    /// AttributionReportingFilterDataEntry
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class AttributionReportingFilterDataEntry : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Key
        /// </summary>
        [DataMember(Name = ("key"), IsRequired = (true))]
        public string Key
        {
            get;
            set;
        }

        /// <summary>
        /// Values
        /// </summary>
        [DataMember(Name = ("values"), IsRequired = (true))]
        public string[] Values
        {
            get;
            set;
        }
    }

    /// <summary>
    /// AttributionReportingFilterConfig
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class AttributionReportingFilterConfig : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// FilterValues
        /// </summary>
        [DataMember(Name = ("filterValues"), IsRequired = (true))]
        public System.Collections.Generic.IList<CefSharp.DevTools.Storage.AttributionReportingFilterDataEntry> FilterValues
        {
            get;
            set;
        }

        /// <summary>
        /// duration in seconds
        /// </summary>
        [DataMember(Name = ("lookbackWindow"), IsRequired = (false))]
        public int? LookbackWindow
        {
            get;
            set;
        }
    }

    /// <summary>
    /// AttributionReportingFilterPair
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class AttributionReportingFilterPair : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Filters
        /// </summary>
        [DataMember(Name = ("filters"), IsRequired = (true))]
        public System.Collections.Generic.IList<CefSharp.DevTools.Storage.AttributionReportingFilterConfig> Filters
        {
            get;
            set;
        }

        /// <summary>
        /// NotFilters
        /// </summary>
        [DataMember(Name = ("notFilters"), IsRequired = (true))]
        public System.Collections.Generic.IList<CefSharp.DevTools.Storage.AttributionReportingFilterConfig> NotFilters
        {
            get;
            set;
        }
    }

    /// <summary>
    /// AttributionReportingAggregationKeysEntry
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class AttributionReportingAggregationKeysEntry : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Key
        /// </summary>
        [DataMember(Name = ("key"), IsRequired = (true))]
        public string Key
        {
            get;
            set;
        }

        /// <summary>
        /// Value
        /// </summary>
        [DataMember(Name = ("value"), IsRequired = (true))]
        public string Value
        {
            get;
            set;
        }
    }

    /// <summary>
    /// AttributionReportingEventReportWindows
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class AttributionReportingEventReportWindows : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// duration in seconds
        /// </summary>
        [DataMember(Name = ("start"), IsRequired = (true))]
        public int Start
        {
            get;
            set;
        }

        /// <summary>
        /// duration in seconds
        /// </summary>
        [DataMember(Name = ("ends"), IsRequired = (true))]
        public int[] Ends
        {
            get;
            set;
        }
    }

    /// <summary>
    /// AttributionReportingTriggerSpec
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class AttributionReportingTriggerSpec : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// number instead of integer because not all uint32 can be represented by
        /// int
        /// </summary>
        [DataMember(Name = ("triggerData"), IsRequired = (true))]
        public double[] TriggerData
        {
            get;
            set;
        }

        /// <summary>
        /// EventReportWindows
        /// </summary>
        [DataMember(Name = ("eventReportWindows"), IsRequired = (true))]
        public CefSharp.DevTools.Storage.AttributionReportingEventReportWindows EventReportWindows
        {
            get;
            set;
        }
    }

    /// <summary>
    /// AttributionReportingTriggerDataMatching
    /// </summary>
    public enum AttributionReportingTriggerDataMatching
    {
        /// <summary>
        /// exact
        /// </summary>
        [EnumMember(Value = ("exact"))]
        Exact,
        /// <summary>
        /// modulus
        /// </summary>
        [EnumMember(Value = ("modulus"))]
        Modulus
    }

    /// <summary>
    /// AttributionReportingAggregatableDebugReportingData
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class AttributionReportingAggregatableDebugReportingData : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// KeyPiece
        /// </summary>
        [DataMember(Name = ("keyPiece"), IsRequired = (true))]
        public string KeyPiece
        {
            get;
            set;
        }

        /// <summary>
        /// number instead of integer because not all uint32 can be represented by
        /// int
        /// </summary>
        [DataMember(Name = ("value"), IsRequired = (true))]
        public double Value
        {
            get;
            set;
        }

        /// <summary>
        /// Types
        /// </summary>
        [DataMember(Name = ("types"), IsRequired = (true))]
        public string[] Types
        {
            get;
            set;
        }
    }

    /// <summary>
    /// AttributionReportingAggregatableDebugReportingConfig
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class AttributionReportingAggregatableDebugReportingConfig : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// number instead of integer because not all uint32 can be represented by
        /// int, only present for source registrations
        /// </summary>
        [DataMember(Name = ("budget"), IsRequired = (false))]
        public double? Budget
        {
            get;
            set;
        }

        /// <summary>
        /// KeyPiece
        /// </summary>
        [DataMember(Name = ("keyPiece"), IsRequired = (true))]
        public string KeyPiece
        {
            get;
            set;
        }

        /// <summary>
        /// DebugData
        /// </summary>
        [DataMember(Name = ("debugData"), IsRequired = (true))]
        public System.Collections.Generic.IList<CefSharp.DevTools.Storage.AttributionReportingAggregatableDebugReportingData> DebugData
        {
            get;
            set;
        }

        /// <summary>
        /// AggregationCoordinatorOrigin
        /// </summary>
        [DataMember(Name = ("aggregationCoordinatorOrigin"), IsRequired = (false))]
        public string AggregationCoordinatorOrigin
        {
            get;
            set;
        }
    }

    /// <summary>
    /// AttributionReportingSourceRegistration
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class AttributionReportingSourceRegistration : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Time
        /// </summary>
        [DataMember(Name = ("time"), IsRequired = (true))]
        public double Time
        {
            get;
            set;
        }

        /// <summary>
        /// duration in seconds
        /// </summary>
        [DataMember(Name = ("expiry"), IsRequired = (true))]
        public int Expiry
        {
            get;
            set;
        }

        /// <summary>
        /// TriggerSpecs
        /// </summary>
        [DataMember(Name = ("triggerSpecs"), IsRequired = (true))]
        public System.Collections.Generic.IList<CefSharp.DevTools.Storage.AttributionReportingTriggerSpec> TriggerSpecs
        {
            get;
            set;
        }

        /// <summary>
        /// duration in seconds
        /// </summary>
        [DataMember(Name = ("aggregatableReportWindow"), IsRequired = (true))]
        public int AggregatableReportWindow
        {
            get;
            set;
        }

        /// <summary>
        /// Type
        /// </summary>
        public CefSharp.DevTools.Storage.AttributionReportingSourceType Type
        {
            get
            {
                return (CefSharp.DevTools.Storage.AttributionReportingSourceType)(StringToEnum(typeof(CefSharp.DevTools.Storage.AttributionReportingSourceType), type));
            }

            set
            {
                this.type = (EnumToString(value));
            }
        }

        /// <summary>
        /// Type
        /// </summary>
        [DataMember(Name = ("type"), IsRequired = (true))]
        internal string type
        {
            get;
            set;
        }

        /// <summary>
        /// SourceOrigin
        /// </summary>
        [DataMember(Name = ("sourceOrigin"), IsRequired = (true))]
        public string SourceOrigin
        {
            get;
            set;
        }

        /// <summary>
        /// ReportingOrigin
        /// </summary>
        [DataMember(Name = ("reportingOrigin"), IsRequired = (true))]
        public string ReportingOrigin
        {
            get;
            set;
        }

        /// <summary>
        /// DestinationSites
        /// </summary>
        [DataMember(Name = ("destinationSites"), IsRequired = (true))]
        public string[] DestinationSites
        {
            get;
            set;
        }

        /// <summary>
        /// EventId
        /// </summary>
        [DataMember(Name = ("eventId"), IsRequired = (true))]
        public string EventId
        {
            get;
            set;
        }

        /// <summary>
        /// Priority
        /// </summary>
        [DataMember(Name = ("priority"), IsRequired = (true))]
        public string Priority
        {
            get;
            set;
        }

        /// <summary>
        /// FilterData
        /// </summary>
        [DataMember(Name = ("filterData"), IsRequired = (true))]
        public System.Collections.Generic.IList<CefSharp.DevTools.Storage.AttributionReportingFilterDataEntry> FilterData
        {
            get;
            set;
        }

        /// <summary>
        /// AggregationKeys
        /// </summary>
        [DataMember(Name = ("aggregationKeys"), IsRequired = (true))]
        public System.Collections.Generic.IList<CefSharp.DevTools.Storage.AttributionReportingAggregationKeysEntry> AggregationKeys
        {
            get;
            set;
        }

        /// <summary>
        /// DebugKey
        /// </summary>
        [DataMember(Name = ("debugKey"), IsRequired = (false))]
        public string DebugKey
        {
            get;
            set;
        }

        /// <summary>
        /// TriggerDataMatching
        /// </summary>
        public CefSharp.DevTools.Storage.AttributionReportingTriggerDataMatching TriggerDataMatching
        {
            get
            {
                return (CefSharp.DevTools.Storage.AttributionReportingTriggerDataMatching)(StringToEnum(typeof(CefSharp.DevTools.Storage.AttributionReportingTriggerDataMatching), triggerDataMatching));
            }

            set
            {
                this.triggerDataMatching = (EnumToString(value));
            }
        }

        /// <summary>
        /// TriggerDataMatching
        /// </summary>
        [DataMember(Name = ("triggerDataMatching"), IsRequired = (true))]
        internal string triggerDataMatching
        {
            get;
            set;
        }

        /// <summary>
        /// DestinationLimitPriority
        /// </summary>
        [DataMember(Name = ("destinationLimitPriority"), IsRequired = (true))]
        public string DestinationLimitPriority
        {
            get;
            set;
        }

        /// <summary>
        /// AggregatableDebugReportingConfig
        /// </summary>
        [DataMember(Name = ("aggregatableDebugReportingConfig"), IsRequired = (true))]
        public CefSharp.DevTools.Storage.AttributionReportingAggregatableDebugReportingConfig AggregatableDebugReportingConfig
        {
            get;
            set;
        }
    }

    /// <summary>
    /// AttributionReportingSourceRegistrationResult
    /// </summary>
    public enum AttributionReportingSourceRegistrationResult
    {
        /// <summary>
        /// success
        /// </summary>
        [EnumMember(Value = ("success"))]
        Success,
        /// <summary>
        /// internalError
        /// </summary>
        [EnumMember(Value = ("internalError"))]
        InternalError,
        /// <summary>
        /// insufficientSourceCapacity
        /// </summary>
        [EnumMember(Value = ("insufficientSourceCapacity"))]
        InsufficientSourceCapacity,
        /// <summary>
        /// insufficientUniqueDestinationCapacity
        /// </summary>
        [EnumMember(Value = ("insufficientUniqueDestinationCapacity"))]
        InsufficientUniqueDestinationCapacity,
        /// <summary>
        /// excessiveReportingOrigins
        /// </summary>
        [EnumMember(Value = ("excessiveReportingOrigins"))]
        ExcessiveReportingOrigins,
        /// <summary>
        /// prohibitedByBrowserPolicy
        /// </summary>
        [EnumMember(Value = ("prohibitedByBrowserPolicy"))]
        ProhibitedByBrowserPolicy,
        /// <summary>
        /// successNoised
        /// </summary>
        [EnumMember(Value = ("successNoised"))]
        SuccessNoised,
        /// <summary>
        /// destinationReportingLimitReached
        /// </summary>
        [EnumMember(Value = ("destinationReportingLimitReached"))]
        DestinationReportingLimitReached,
        /// <summary>
        /// destinationGlobalLimitReached
        /// </summary>
        [EnumMember(Value = ("destinationGlobalLimitReached"))]
        DestinationGlobalLimitReached,
        /// <summary>
        /// destinationBothLimitsReached
        /// </summary>
        [EnumMember(Value = ("destinationBothLimitsReached"))]
        DestinationBothLimitsReached,
        /// <summary>
        /// reportingOriginsPerSiteLimitReached
        /// </summary>
        [EnumMember(Value = ("reportingOriginsPerSiteLimitReached"))]
        ReportingOriginsPerSiteLimitReached,
        /// <summary>
        /// exceedsMaxChannelCapacity
        /// </summary>
        [EnumMember(Value = ("exceedsMaxChannelCapacity"))]
        ExceedsMaxChannelCapacity,
        /// <summary>
        /// exceedsMaxTriggerStateCardinality
        /// </summary>
        [EnumMember(Value = ("exceedsMaxTriggerStateCardinality"))]
        ExceedsMaxTriggerStateCardinality,
        /// <summary>
        /// destinationPerDayReportingLimitReached
        /// </summary>
        [EnumMember(Value = ("destinationPerDayReportingLimitReached"))]
        DestinationPerDayReportingLimitReached
    }

    /// <summary>
    /// AttributionReportingSourceRegistrationTimeConfig
    /// </summary>
    public enum AttributionReportingSourceRegistrationTimeConfig
    {
        /// <summary>
        /// include
        /// </summary>
        [EnumMember(Value = ("include"))]
        Include,
        /// <summary>
        /// exclude
        /// </summary>
        [EnumMember(Value = ("exclude"))]
        Exclude
    }

    /// <summary>
    /// AttributionReportingAggregatableValueDictEntry
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class AttributionReportingAggregatableValueDictEntry : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Key
        /// </summary>
        [DataMember(Name = ("key"), IsRequired = (true))]
        public string Key
        {
            get;
            set;
        }

        /// <summary>
        /// number instead of integer because not all uint32 can be represented by
        /// int
        /// </summary>
        [DataMember(Name = ("value"), IsRequired = (true))]
        public double Value
        {
            get;
            set;
        }

        /// <summary>
        /// FilteringId
        /// </summary>
        [DataMember(Name = ("filteringId"), IsRequired = (true))]
        public string FilteringId
        {
            get;
            set;
        }
    }

    /// <summary>
    /// AttributionReportingAggregatableValueEntry
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class AttributionReportingAggregatableValueEntry : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Values
        /// </summary>
        [DataMember(Name = ("values"), IsRequired = (true))]
        public System.Collections.Generic.IList<CefSharp.DevTools.Storage.AttributionReportingAggregatableValueDictEntry> Values
        {
            get;
            set;
        }

        /// <summary>
        /// Filters
        /// </summary>
        [DataMember(Name = ("filters"), IsRequired = (true))]
        public CefSharp.DevTools.Storage.AttributionReportingFilterPair Filters
        {
            get;
            set;
        }
    }

    /// <summary>
    /// AttributionReportingEventTriggerData
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class AttributionReportingEventTriggerData : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Data
        /// </summary>
        [DataMember(Name = ("data"), IsRequired = (true))]
        public string Data
        {
            get;
            set;
        }

        /// <summary>
        /// Priority
        /// </summary>
        [DataMember(Name = ("priority"), IsRequired = (true))]
        public string Priority
        {
            get;
            set;
        }

        /// <summary>
        /// DedupKey
        /// </summary>
        [DataMember(Name = ("dedupKey"), IsRequired = (false))]
        public string DedupKey
        {
            get;
            set;
        }

        /// <summary>
        /// Filters
        /// </summary>
        [DataMember(Name = ("filters"), IsRequired = (true))]
        public CefSharp.DevTools.Storage.AttributionReportingFilterPair Filters
        {
            get;
            set;
        }
    }

    /// <summary>
    /// AttributionReportingAggregatableTriggerData
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class AttributionReportingAggregatableTriggerData : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// KeyPiece
        /// </summary>
        [DataMember(Name = ("keyPiece"), IsRequired = (true))]
        public string KeyPiece
        {
            get;
            set;
        }

        /// <summary>
        /// SourceKeys
        /// </summary>
        [DataMember(Name = ("sourceKeys"), IsRequired = (true))]
        public string[] SourceKeys
        {
            get;
            set;
        }

        /// <summary>
        /// Filters
        /// </summary>
        [DataMember(Name = ("filters"), IsRequired = (true))]
        public CefSharp.DevTools.Storage.AttributionReportingFilterPair Filters
        {
            get;
            set;
        }
    }

    /// <summary>
    /// AttributionReportingAggregatableDedupKey
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class AttributionReportingAggregatableDedupKey : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// DedupKey
        /// </summary>
        [DataMember(Name = ("dedupKey"), IsRequired = (false))]
        public string DedupKey
        {
            get;
            set;
        }

        /// <summary>
        /// Filters
        /// </summary>
        [DataMember(Name = ("filters"), IsRequired = (true))]
        public CefSharp.DevTools.Storage.AttributionReportingFilterPair Filters
        {
            get;
            set;
        }
    }

    /// <summary>
    /// AttributionReportingTriggerRegistration
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class AttributionReportingTriggerRegistration : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Filters
        /// </summary>
        [DataMember(Name = ("filters"), IsRequired = (true))]
        public CefSharp.DevTools.Storage.AttributionReportingFilterPair Filters
        {
            get;
            set;
        }

        /// <summary>
        /// DebugKey
        /// </summary>
        [DataMember(Name = ("debugKey"), IsRequired = (false))]
        public string DebugKey
        {
            get;
            set;
        }

        /// <summary>
        /// AggregatableDedupKeys
        /// </summary>
        [DataMember(Name = ("aggregatableDedupKeys"), IsRequired = (true))]
        public System.Collections.Generic.IList<CefSharp.DevTools.Storage.AttributionReportingAggregatableDedupKey> AggregatableDedupKeys
        {
            get;
            set;
        }

        /// <summary>
        /// EventTriggerData
        /// </summary>
        [DataMember(Name = ("eventTriggerData"), IsRequired = (true))]
        public System.Collections.Generic.IList<CefSharp.DevTools.Storage.AttributionReportingEventTriggerData> EventTriggerData
        {
            get;
            set;
        }

        /// <summary>
        /// AggregatableTriggerData
        /// </summary>
        [DataMember(Name = ("aggregatableTriggerData"), IsRequired = (true))]
        public System.Collections.Generic.IList<CefSharp.DevTools.Storage.AttributionReportingAggregatableTriggerData> AggregatableTriggerData
        {
            get;
            set;
        }

        /// <summary>
        /// AggregatableValues
        /// </summary>
        [DataMember(Name = ("aggregatableValues"), IsRequired = (true))]
        public System.Collections.Generic.IList<CefSharp.DevTools.Storage.AttributionReportingAggregatableValueEntry> AggregatableValues
        {
            get;
            set;
        }

        /// <summary>
        /// AggregatableFilteringIdMaxBytes
        /// </summary>
        [DataMember(Name = ("aggregatableFilteringIdMaxBytes"), IsRequired = (true))]
        public int AggregatableFilteringIdMaxBytes
        {
            get;
            set;
        }

        /// <summary>
        /// DebugReporting
        /// </summary>
        [DataMember(Name = ("debugReporting"), IsRequired = (true))]
        public bool DebugReporting
        {
            get;
            set;
        }

        /// <summary>
        /// AggregationCoordinatorOrigin
        /// </summary>
        [DataMember(Name = ("aggregationCoordinatorOrigin"), IsRequired = (false))]
        public string AggregationCoordinatorOrigin
        {
            get;
            set;
        }

        /// <summary>
        /// SourceRegistrationTimeConfig
        /// </summary>
        public CefSharp.DevTools.Storage.AttributionReportingSourceRegistrationTimeConfig SourceRegistrationTimeConfig
        {
            get
            {
                return (CefSharp.DevTools.Storage.AttributionReportingSourceRegistrationTimeConfig)(StringToEnum(typeof(CefSharp.DevTools.Storage.AttributionReportingSourceRegistrationTimeConfig), sourceRegistrationTimeConfig));
            }

            set
            {
                this.sourceRegistrationTimeConfig = (EnumToString(value));
            }
        }

        /// <summary>
        /// SourceRegistrationTimeConfig
        /// </summary>
        [DataMember(Name = ("sourceRegistrationTimeConfig"), IsRequired = (true))]
        internal string sourceRegistrationTimeConfig
        {
            get;
            set;
        }

        /// <summary>
        /// TriggerContextId
        /// </summary>
        [DataMember(Name = ("triggerContextId"), IsRequired = (false))]
        public string TriggerContextId
        {
            get;
            set;
        }

        /// <summary>
        /// AggregatableDebugReportingConfig
        /// </summary>
        [DataMember(Name = ("aggregatableDebugReportingConfig"), IsRequired = (true))]
        public CefSharp.DevTools.Storage.AttributionReportingAggregatableDebugReportingConfig AggregatableDebugReportingConfig
        {
            get;
            set;
        }
    }

    /// <summary>
    /// AttributionReportingEventLevelResult
    /// </summary>
    public enum AttributionReportingEventLevelResult
    {
        /// <summary>
        /// success
        /// </summary>
        [EnumMember(Value = ("success"))]
        Success,
        /// <summary>
        /// successDroppedLowerPriority
        /// </summary>
        [EnumMember(Value = ("successDroppedLowerPriority"))]
        SuccessDroppedLowerPriority,
        /// <summary>
        /// internalError
        /// </summary>
        [EnumMember(Value = ("internalError"))]
        InternalError,
        /// <summary>
        /// noCapacityForAttributionDestination
        /// </summary>
        [EnumMember(Value = ("noCapacityForAttributionDestination"))]
        NoCapacityForAttributionDestination,
        /// <summary>
        /// noMatchingSources
        /// </summary>
        [EnumMember(Value = ("noMatchingSources"))]
        NoMatchingSources,
        /// <summary>
        /// deduplicated
        /// </summary>
        [EnumMember(Value = ("deduplicated"))]
        Deduplicated,
        /// <summary>
        /// excessiveAttributions
        /// </summary>
        [EnumMember(Value = ("excessiveAttributions"))]
        ExcessiveAttributions,
        /// <summary>
        /// priorityTooLow
        /// </summary>
        [EnumMember(Value = ("priorityTooLow"))]
        PriorityTooLow,
        /// <summary>
        /// neverAttributedSource
        /// </summary>
        [EnumMember(Value = ("neverAttributedSource"))]
        NeverAttributedSource,
        /// <summary>
        /// excessiveReportingOrigins
        /// </summary>
        [EnumMember(Value = ("excessiveReportingOrigins"))]
        ExcessiveReportingOrigins,
        /// <summary>
        /// noMatchingSourceFilterData
        /// </summary>
        [EnumMember(Value = ("noMatchingSourceFilterData"))]
        NoMatchingSourceFilterData,
        /// <summary>
        /// prohibitedByBrowserPolicy
        /// </summary>
        [EnumMember(Value = ("prohibitedByBrowserPolicy"))]
        ProhibitedByBrowserPolicy,
        /// <summary>
        /// noMatchingConfigurations
        /// </summary>
        [EnumMember(Value = ("noMatchingConfigurations"))]
        NoMatchingConfigurations,
        /// <summary>
        /// excessiveReports
        /// </summary>
        [EnumMember(Value = ("excessiveReports"))]
        ExcessiveReports,
        /// <summary>
        /// falselyAttributedSource
        /// </summary>
        [EnumMember(Value = ("falselyAttributedSource"))]
        FalselyAttributedSource,
        /// <summary>
        /// reportWindowPassed
        /// </summary>
        [EnumMember(Value = ("reportWindowPassed"))]
        ReportWindowPassed,
        /// <summary>
        /// notRegistered
        /// </summary>
        [EnumMember(Value = ("notRegistered"))]
        NotRegistered,
        /// <summary>
        /// reportWindowNotStarted
        /// </summary>
        [EnumMember(Value = ("reportWindowNotStarted"))]
        ReportWindowNotStarted,
        /// <summary>
        /// noMatchingTriggerData
        /// </summary>
        [EnumMember(Value = ("noMatchingTriggerData"))]
        NoMatchingTriggerData
    }

    /// <summary>
    /// AttributionReportingAggregatableResult
    /// </summary>
    public enum AttributionReportingAggregatableResult
    {
        /// <summary>
        /// success
        /// </summary>
        [EnumMember(Value = ("success"))]
        Success,
        /// <summary>
        /// internalError
        /// </summary>
        [EnumMember(Value = ("internalError"))]
        InternalError,
        /// <summary>
        /// noCapacityForAttributionDestination
        /// </summary>
        [EnumMember(Value = ("noCapacityForAttributionDestination"))]
        NoCapacityForAttributionDestination,
        /// <summary>
        /// noMatchingSources
        /// </summary>
        [EnumMember(Value = ("noMatchingSources"))]
        NoMatchingSources,
        /// <summary>
        /// excessiveAttributions
        /// </summary>
        [EnumMember(Value = ("excessiveAttributions"))]
        ExcessiveAttributions,
        /// <summary>
        /// excessiveReportingOrigins
        /// </summary>
        [EnumMember(Value = ("excessiveReportingOrigins"))]
        ExcessiveReportingOrigins,
        /// <summary>
        /// noHistograms
        /// </summary>
        [EnumMember(Value = ("noHistograms"))]
        NoHistograms,
        /// <summary>
        /// insufficientBudget
        /// </summary>
        [EnumMember(Value = ("insufficientBudget"))]
        InsufficientBudget,
        /// <summary>
        /// noMatchingSourceFilterData
        /// </summary>
        [EnumMember(Value = ("noMatchingSourceFilterData"))]
        NoMatchingSourceFilterData,
        /// <summary>
        /// notRegistered
        /// </summary>
        [EnumMember(Value = ("notRegistered"))]
        NotRegistered,
        /// <summary>
        /// prohibitedByBrowserPolicy
        /// </summary>
        [EnumMember(Value = ("prohibitedByBrowserPolicy"))]
        ProhibitedByBrowserPolicy,
        /// <summary>
        /// deduplicated
        /// </summary>
        [EnumMember(Value = ("deduplicated"))]
        Deduplicated,
        /// <summary>
        /// reportWindowPassed
        /// </summary>
        [EnumMember(Value = ("reportWindowPassed"))]
        ReportWindowPassed,
        /// <summary>
        /// excessiveReports
        /// </summary>
        [EnumMember(Value = ("excessiveReports"))]
        ExcessiveReports
    }

    /// <summary>
    /// A single Related Website Set object.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class RelatedWebsiteSet : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The primary site of this set, along with the ccTLDs if there is any.
        /// </summary>
        [DataMember(Name = ("primarySites"), IsRequired = (true))]
        public string[] PrimarySites
        {
            get;
            set;
        }

        /// <summary>
        /// The associated sites of this set, along with the ccTLDs if there is any.
        /// </summary>
        [DataMember(Name = ("associatedSites"), IsRequired = (true))]
        public string[] AssociatedSites
        {
            get;
            set;
        }

        /// <summary>
        /// The service sites of this set, along with the ccTLDs if there is any.
        /// </summary>
        [DataMember(Name = ("serviceSites"), IsRequired = (true))]
        public string[] ServiceSites
        {
            get;
            set;
        }
    }

    /// <summary>
    /// A cache&apos;s contents have been modified.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class CacheStorageContentUpdatedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Origin to update.
        /// </summary>
        [DataMember(Name = ("origin"), IsRequired = (true))]
        public string Origin
        {
            get;
            private set;
        }

        /// <summary>
        /// Storage key to update.
        /// </summary>
        [DataMember(Name = ("storageKey"), IsRequired = (true))]
        public string StorageKey
        {
            get;
            private set;
        }

        /// <summary>
        /// Storage bucket to update.
        /// </summary>
        [DataMember(Name = ("bucketId"), IsRequired = (true))]
        public string BucketId
        {
            get;
            private set;
        }

        /// <summary>
        /// Name of cache in origin.
        /// </summary>
        [DataMember(Name = ("cacheName"), IsRequired = (true))]
        public string CacheName
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// A cache has been added/deleted.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class CacheStorageListUpdatedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Origin to update.
        /// </summary>
        [DataMember(Name = ("origin"), IsRequired = (true))]
        public string Origin
        {
            get;
            private set;
        }

        /// <summary>
        /// Storage key to update.
        /// </summary>
        [DataMember(Name = ("storageKey"), IsRequired = (true))]
        public string StorageKey
        {
            get;
            private set;
        }

        /// <summary>
        /// Storage bucket to update.
        /// </summary>
        [DataMember(Name = ("bucketId"), IsRequired = (true))]
        public string BucketId
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// The origin&apos;s IndexedDB object store has been modified.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class IndexedDBContentUpdatedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Origin to update.
        /// </summary>
        [DataMember(Name = ("origin"), IsRequired = (true))]
        public string Origin
        {
            get;
            private set;
        }

        /// <summary>
        /// Storage key to update.
        /// </summary>
        [DataMember(Name = ("storageKey"), IsRequired = (true))]
        public string StorageKey
        {
            get;
            private set;
        }

        /// <summary>
        /// Storage bucket to update.
        /// </summary>
        [DataMember(Name = ("bucketId"), IsRequired = (true))]
        public string BucketId
        {
            get;
            private set;
        }

        /// <summary>
        /// Database to update.
        /// </summary>
        [DataMember(Name = ("databaseName"), IsRequired = (true))]
        public string DatabaseName
        {
            get;
            private set;
        }

        /// <summary>
        /// ObjectStore to update.
        /// </summary>
        [DataMember(Name = ("objectStoreName"), IsRequired = (true))]
        public string ObjectStoreName
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// The origin&apos;s IndexedDB database list has been modified.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class IndexedDBListUpdatedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Origin to update.
        /// </summary>
        [DataMember(Name = ("origin"), IsRequired = (true))]
        public string Origin
        {
            get;
            private set;
        }

        /// <summary>
        /// Storage key to update.
        /// </summary>
        [DataMember(Name = ("storageKey"), IsRequired = (true))]
        public string StorageKey
        {
            get;
            private set;
        }

        /// <summary>
        /// Storage bucket to update.
        /// </summary>
        [DataMember(Name = ("bucketId"), IsRequired = (true))]
        public string BucketId
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// One of the interest groups was accessed. Note that these events are global
    /// to all targets sharing an interest group store.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class InterestGroupAccessedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// AccessTime
        /// </summary>
        [DataMember(Name = ("accessTime"), IsRequired = (true))]
        public double AccessTime
        {
            get;
            private set;
        }

        /// <summary>
        /// Type
        /// </summary>
        public CefSharp.DevTools.Storage.InterestGroupAccessType Type
        {
            get
            {
                return (CefSharp.DevTools.Storage.InterestGroupAccessType)(StringToEnum(typeof(CefSharp.DevTools.Storage.InterestGroupAccessType), type));
            }

            set
            {
                this.type = (EnumToString(value));
            }
        }

        /// <summary>
        /// Type
        /// </summary>
        [DataMember(Name = ("type"), IsRequired = (true))]
        internal string type
        {
            get;
            private set;
        }

        /// <summary>
        /// OwnerOrigin
        /// </summary>
        [DataMember(Name = ("ownerOrigin"), IsRequired = (true))]
        public string OwnerOrigin
        {
            get;
            private set;
        }

        /// <summary>
        /// Name
        /// </summary>
        [DataMember(Name = ("name"), IsRequired = (true))]
        public string Name
        {
            get;
            private set;
        }

        /// <summary>
        /// For topLevelBid/topLevelAdditionalBid, and when appropriate,
        /// win and additionalBidWin
        /// </summary>
        [DataMember(Name = ("componentSellerOrigin"), IsRequired = (false))]
        public string ComponentSellerOrigin
        {
            get;
            private set;
        }

        /// <summary>
        /// For bid or somethingBid event, if done locally and not on a server.
        /// </summary>
        [DataMember(Name = ("bid"), IsRequired = (false))]
        public double? Bid
        {
            get;
            private set;
        }

        /// <summary>
        /// BidCurrency
        /// </summary>
        [DataMember(Name = ("bidCurrency"), IsRequired = (false))]
        public string BidCurrency
        {
            get;
            private set;
        }

        /// <summary>
        /// For non-global events --- links to interestGroupAuctionEvent
        /// </summary>
        [DataMember(Name = ("uniqueAuctionId"), IsRequired = (false))]
        public string UniqueAuctionId
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// An auction involving interest groups is taking place. These events are
    /// target-specific.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class InterestGroupAuctionEventOccurredEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// EventTime
        /// </summary>
        [DataMember(Name = ("eventTime"), IsRequired = (true))]
        public double EventTime
        {
            get;
            private set;
        }

        /// <summary>
        /// Type
        /// </summary>
        public CefSharp.DevTools.Storage.InterestGroupAuctionEventType Type
        {
            get
            {
                return (CefSharp.DevTools.Storage.InterestGroupAuctionEventType)(StringToEnum(typeof(CefSharp.DevTools.Storage.InterestGroupAuctionEventType), type));
            }

            set
            {
                this.type = (EnumToString(value));
            }
        }

        /// <summary>
        /// Type
        /// </summary>
        [DataMember(Name = ("type"), IsRequired = (true))]
        internal string type
        {
            get;
            private set;
        }

        /// <summary>
        /// UniqueAuctionId
        /// </summary>
        [DataMember(Name = ("uniqueAuctionId"), IsRequired = (true))]
        public string UniqueAuctionId
        {
            get;
            private set;
        }

        /// <summary>
        /// Set for child auctions.
        /// </summary>
        [DataMember(Name = ("parentAuctionId"), IsRequired = (false))]
        public string ParentAuctionId
        {
            get;
            private set;
        }

        /// <summary>
        /// Set for started and configResolved
        /// </summary>
        [DataMember(Name = ("auctionConfig"), IsRequired = (false))]
        public object AuctionConfig
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Specifies which auctions a particular network fetch may be related to, and
    /// in what role. Note that it is not ordered with respect to
    /// Network.requestWillBeSent (but will happen before loadingFinished
    /// loadingFailed).
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class InterestGroupAuctionNetworkRequestCreatedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Type
        /// </summary>
        public CefSharp.DevTools.Storage.InterestGroupAuctionFetchType Type
        {
            get
            {
                return (CefSharp.DevTools.Storage.InterestGroupAuctionFetchType)(StringToEnum(typeof(CefSharp.DevTools.Storage.InterestGroupAuctionFetchType), type));
            }

            set
            {
                this.type = (EnumToString(value));
            }
        }

        /// <summary>
        /// Type
        /// </summary>
        [DataMember(Name = ("type"), IsRequired = (true))]
        internal string type
        {
            get;
            private set;
        }

        /// <summary>
        /// RequestId
        /// </summary>
        [DataMember(Name = ("requestId"), IsRequired = (true))]
        public string RequestId
        {
            get;
            private set;
        }

        /// <summary>
        /// This is the set of the auctions using the worklet that issued this
        /// request.  In the case of trusted signals, it&apos;s possible that only some of
        /// them actually care about the keys being queried.
        /// </summary>
        [DataMember(Name = ("auctions"), IsRequired = (true))]
        public string[] Auctions
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Shared storage was accessed by the associated page.
    /// The following parameters are included in all events.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class SharedStorageAccessedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Time of the access.
        /// </summary>
        [DataMember(Name = ("accessTime"), IsRequired = (true))]
        public double AccessTime
        {
            get;
            private set;
        }

        /// <summary>
        /// Enum value indicating the Shared Storage API method invoked.
        /// </summary>
        public CefSharp.DevTools.Storage.SharedStorageAccessType Type
        {
            get
            {
                return (CefSharp.DevTools.Storage.SharedStorageAccessType)(StringToEnum(typeof(CefSharp.DevTools.Storage.SharedStorageAccessType), type));
            }

            set
            {
                this.type = (EnumToString(value));
            }
        }

        /// <summary>
        /// Enum value indicating the Shared Storage API method invoked.
        /// </summary>
        [DataMember(Name = ("type"), IsRequired = (true))]
        internal string type
        {
            get;
            private set;
        }

        /// <summary>
        /// DevTools Frame Token for the primary frame tree&apos;s root.
        /// </summary>
        [DataMember(Name = ("mainFrameId"), IsRequired = (true))]
        public string MainFrameId
        {
            get;
            private set;
        }

        /// <summary>
        /// Serialized origin for the context that invoked the Shared Storage API.
        /// </summary>
        [DataMember(Name = ("ownerOrigin"), IsRequired = (true))]
        public string OwnerOrigin
        {
            get;
            private set;
        }

        /// <summary>
        /// The sub-parameters wrapped by `params` are all optional and their
        /// presence/absence depends on `type`.
        /// </summary>
        [DataMember(Name = ("params"), IsRequired = (true))]
        public CefSharp.DevTools.Storage.SharedStorageAccessParams Params
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// storageBucketCreatedOrUpdated
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class StorageBucketCreatedOrUpdatedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// BucketInfo
        /// </summary>
        [DataMember(Name = ("bucketInfo"), IsRequired = (true))]
        public CefSharp.DevTools.Storage.StorageBucketInfo BucketInfo
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// storageBucketDeleted
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class StorageBucketDeletedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// BucketId
        /// </summary>
        [DataMember(Name = ("bucketId"), IsRequired = (true))]
        public string BucketId
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// attributionReportingSourceRegistered
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class AttributionReportingSourceRegisteredEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Registration
        /// </summary>
        [DataMember(Name = ("registration"), IsRequired = (true))]
        public CefSharp.DevTools.Storage.AttributionReportingSourceRegistration Registration
        {
            get;
            private set;
        }

        /// <summary>
        /// Result
        /// </summary>
        public CefSharp.DevTools.Storage.AttributionReportingSourceRegistrationResult Result
        {
            get
            {
                return (CefSharp.DevTools.Storage.AttributionReportingSourceRegistrationResult)(StringToEnum(typeof(CefSharp.DevTools.Storage.AttributionReportingSourceRegistrationResult), result));
            }

            set
            {
                this.result = (EnumToString(value));
            }
        }

        /// <summary>
        /// Result
        /// </summary>
        [DataMember(Name = ("result"), IsRequired = (true))]
        internal string result
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// attributionReportingTriggerRegistered
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class AttributionReportingTriggerRegisteredEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Registration
        /// </summary>
        [DataMember(Name = ("registration"), IsRequired = (true))]
        public CefSharp.DevTools.Storage.AttributionReportingTriggerRegistration Registration
        {
            get;
            private set;
        }

        /// <summary>
        /// EventLevel
        /// </summary>
        public CefSharp.DevTools.Storage.AttributionReportingEventLevelResult EventLevel
        {
            get
            {
                return (CefSharp.DevTools.Storage.AttributionReportingEventLevelResult)(StringToEnum(typeof(CefSharp.DevTools.Storage.AttributionReportingEventLevelResult), eventLevel));
            }

            set
            {
                this.eventLevel = (EnumToString(value));
            }
        }

        /// <summary>
        /// EventLevel
        /// </summary>
        [DataMember(Name = ("eventLevel"), IsRequired = (true))]
        internal string eventLevel
        {
            get;
            private set;
        }

        /// <summary>
        /// Aggregatable
        /// </summary>
        public CefSharp.DevTools.Storage.AttributionReportingAggregatableResult Aggregatable
        {
            get
            {
                return (CefSharp.DevTools.Storage.AttributionReportingAggregatableResult)(StringToEnum(typeof(CefSharp.DevTools.Storage.AttributionReportingAggregatableResult), aggregatable));
            }

            set
            {
                this.aggregatable = (EnumToString(value));
            }
        }

        /// <summary>
        /// Aggregatable
        /// </summary>
        [DataMember(Name = ("aggregatable"), IsRequired = (true))]
        internal string aggregatable
        {
            get;
            private set;
        }
    }
}

namespace CefSharp.DevTools.SystemInfo
{
    /// <summary>
    /// Describes a single graphics processor (GPU).
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class GPUDevice : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// PCI ID of the GPU vendor, if available; 0 otherwise.
        /// </summary>
        [DataMember(Name = ("vendorId"), IsRequired = (true))]
        public double VendorId
        {
            get;
            set;
        }

        /// <summary>
        /// PCI ID of the GPU device, if available; 0 otherwise.
        /// </summary>
        [DataMember(Name = ("deviceId"), IsRequired = (true))]
        public double DeviceId
        {
            get;
            set;
        }

        /// <summary>
        /// Sub sys ID of the GPU, only available on Windows.
        /// </summary>
        [DataMember(Name = ("subSysId"), IsRequired = (false))]
        public double? SubSysId
        {
            get;
            set;
        }

        /// <summary>
        /// Revision of the GPU, only available on Windows.
        /// </summary>
        [DataMember(Name = ("revision"), IsRequired = (false))]
        public double? Revision
        {
            get;
            set;
        }

        /// <summary>
        /// String description of the GPU vendor, if the PCI ID is not available.
        /// </summary>
        [DataMember(Name = ("vendorString"), IsRequired = (true))]
        public string VendorString
        {
            get;
            set;
        }

        /// <summary>
        /// String description of the GPU device, if the PCI ID is not available.
        /// </summary>
        [DataMember(Name = ("deviceString"), IsRequired = (true))]
        public string DeviceString
        {
            get;
            set;
        }

        /// <summary>
        /// String description of the GPU driver vendor.
        /// </summary>
        [DataMember(Name = ("driverVendor"), IsRequired = (true))]
        public string DriverVendor
        {
            get;
            set;
        }

        /// <summary>
        /// String description of the GPU driver version.
        /// </summary>
        [DataMember(Name = ("driverVersion"), IsRequired = (true))]
        public string DriverVersion
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Describes the width and height dimensions of an entity.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class Size : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Width in pixels.
        /// </summary>
        [DataMember(Name = ("width"), IsRequired = (true))]
        public int Width
        {
            get;
            set;
        }

        /// <summary>
        /// Height in pixels.
        /// </summary>
        [DataMember(Name = ("height"), IsRequired = (true))]
        public int Height
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Describes a supported video decoding profile with its associated minimum and
    /// maximum resolutions.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class VideoDecodeAcceleratorCapability : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Video codec profile that is supported, e.g. VP9 Profile 2.
        /// </summary>
        [DataMember(Name = ("profile"), IsRequired = (true))]
        public string Profile
        {
            get;
            set;
        }

        /// <summary>
        /// Maximum video dimensions in pixels supported for this |profile|.
        /// </summary>
        [DataMember(Name = ("maxResolution"), IsRequired = (true))]
        public CefSharp.DevTools.SystemInfo.Size MaxResolution
        {
            get;
            set;
        }

        /// <summary>
        /// Minimum video dimensions in pixels supported for this |profile|.
        /// </summary>
        [DataMember(Name = ("minResolution"), IsRequired = (true))]
        public CefSharp.DevTools.SystemInfo.Size MinResolution
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Describes a supported video encoding profile with its associated maximum
    /// resolution and maximum framerate.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class VideoEncodeAcceleratorCapability : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Video codec profile that is supported, e.g H264 Main.
        /// </summary>
        [DataMember(Name = ("profile"), IsRequired = (true))]
        public string Profile
        {
            get;
            set;
        }

        /// <summary>
        /// Maximum video dimensions in pixels supported for this |profile|.
        /// </summary>
        [DataMember(Name = ("maxResolution"), IsRequired = (true))]
        public CefSharp.DevTools.SystemInfo.Size MaxResolution
        {
            get;
            set;
        }

        /// <summary>
        /// Maximum encoding framerate in frames per second supported for this
        /// |profile|, as fraction&apos;s numerator and denominator, e.g. 24/1 fps,
        /// 24000/1001 fps, etc.
        /// </summary>
        [DataMember(Name = ("maxFramerateNumerator"), IsRequired = (true))]
        public int MaxFramerateNumerator
        {
            get;
            set;
        }

        /// <summary>
        /// MaxFramerateDenominator
        /// </summary>
        [DataMember(Name = ("maxFramerateDenominator"), IsRequired = (true))]
        public int MaxFramerateDenominator
        {
            get;
            set;
        }
    }

    /// <summary>
    /// YUV subsampling type of the pixels of a given image.
    /// </summary>
    public enum SubsamplingFormat
    {
        /// <summary>
        /// yuv420
        /// </summary>
        [EnumMember(Value = ("yuv420"))]
        Yuv420,
        /// <summary>
        /// yuv422
        /// </summary>
        [EnumMember(Value = ("yuv422"))]
        Yuv422,
        /// <summary>
        /// yuv444
        /// </summary>
        [EnumMember(Value = ("yuv444"))]
        Yuv444
    }

    /// <summary>
    /// Image format of a given image.
    /// </summary>
    public enum ImageType
    {
        /// <summary>
        /// jpeg
        /// </summary>
        [EnumMember(Value = ("jpeg"))]
        Jpeg,
        /// <summary>
        /// webp
        /// </summary>
        [EnumMember(Value = ("webp"))]
        Webp,
        /// <summary>
        /// unknown
        /// </summary>
        [EnumMember(Value = ("unknown"))]
        Unknown
    }

    /// <summary>
    /// Describes a supported image decoding profile with its associated minimum and
    /// maximum resolutions and subsampling.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class ImageDecodeAcceleratorCapability : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Image coded, e.g. Jpeg.
        /// </summary>
        public CefSharp.DevTools.SystemInfo.ImageType ImageType
        {
            get
            {
                return (CefSharp.DevTools.SystemInfo.ImageType)(StringToEnum(typeof(CefSharp.DevTools.SystemInfo.ImageType), imageType));
            }

            set
            {
                this.imageType = (EnumToString(value));
            }
        }

        /// <summary>
        /// Image coded, e.g. Jpeg.
        /// </summary>
        [DataMember(Name = ("imageType"), IsRequired = (true))]
        internal string imageType
        {
            get;
            set;
        }

        /// <summary>
        /// Maximum supported dimensions of the image in pixels.
        /// </summary>
        [DataMember(Name = ("maxDimensions"), IsRequired = (true))]
        public CefSharp.DevTools.SystemInfo.Size MaxDimensions
        {
            get;
            set;
        }

        /// <summary>
        /// Minimum supported dimensions of the image in pixels.
        /// </summary>
        [DataMember(Name = ("minDimensions"), IsRequired = (true))]
        public CefSharp.DevTools.SystemInfo.Size MinDimensions
        {
            get;
            set;
        }

        /// <summary>
        /// Optional array of supported subsampling formats, e.g. 4:2:0, if known.
        /// </summary>
        public CefSharp.DevTools.SystemInfo.SubsamplingFormat[] Subsamplings
        {
            get
            {
                return (CefSharp.DevTools.SystemInfo.SubsamplingFormat[])(StringToEnum(typeof(CefSharp.DevTools.SystemInfo.SubsamplingFormat[]), subsamplings));
            }

            set
            {
                this.subsamplings = (EnumToString(value));
            }
        }

        /// <summary>
        /// Optional array of supported subsampling formats, e.g. 4:2:0, if known.
        /// </summary>
        [DataMember(Name = ("subsamplings"), IsRequired = (true))]
        internal string subsamplings
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Provides information about the GPU(s) on the system.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class GPUInfo : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The graphics devices on the system. Element 0 is the primary GPU.
        /// </summary>
        [DataMember(Name = ("devices"), IsRequired = (true))]
        public System.Collections.Generic.IList<CefSharp.DevTools.SystemInfo.GPUDevice> Devices
        {
            get;
            set;
        }

        /// <summary>
        /// An optional dictionary of additional GPU related attributes.
        /// </summary>
        [DataMember(Name = ("auxAttributes"), IsRequired = (false))]
        public object AuxAttributes
        {
            get;
            set;
        }

        /// <summary>
        /// An optional dictionary of graphics features and their status.
        /// </summary>
        [DataMember(Name = ("featureStatus"), IsRequired = (false))]
        public object FeatureStatus
        {
            get;
            set;
        }

        /// <summary>
        /// An optional array of GPU driver bug workarounds.
        /// </summary>
        [DataMember(Name = ("driverBugWorkarounds"), IsRequired = (true))]
        public string[] DriverBugWorkarounds
        {
            get;
            set;
        }

        /// <summary>
        /// Supported accelerated video decoding capabilities.
        /// </summary>
        [DataMember(Name = ("videoDecoding"), IsRequired = (true))]
        public System.Collections.Generic.IList<CefSharp.DevTools.SystemInfo.VideoDecodeAcceleratorCapability> VideoDecoding
        {
            get;
            set;
        }

        /// <summary>
        /// Supported accelerated video encoding capabilities.
        /// </summary>
        [DataMember(Name = ("videoEncoding"), IsRequired = (true))]
        public System.Collections.Generic.IList<CefSharp.DevTools.SystemInfo.VideoEncodeAcceleratorCapability> VideoEncoding
        {
            get;
            set;
        }

        /// <summary>
        /// Supported accelerated image decoding capabilities.
        /// </summary>
        [DataMember(Name = ("imageDecoding"), IsRequired = (true))]
        public System.Collections.Generic.IList<CefSharp.DevTools.SystemInfo.ImageDecodeAcceleratorCapability> ImageDecoding
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Represents process info.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class ProcessInfo : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Specifies process type.
        /// </summary>
        [DataMember(Name = ("type"), IsRequired = (true))]
        public string Type
        {
            get;
            set;
        }

        /// <summary>
        /// Specifies process id.
        /// </summary>
        [DataMember(Name = ("id"), IsRequired = (true))]
        public int Id
        {
            get;
            set;
        }

        /// <summary>
        /// Specifies cumulative CPU usage in seconds across all threads of the
        /// process since the process start.
        /// </summary>
        [DataMember(Name = ("cpuTime"), IsRequired = (true))]
        public double CpuTime
        {
            get;
            set;
        }
    }
}

namespace CefSharp.DevTools.Target
{
    /// <summary>
    /// TargetInfo
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class TargetInfo : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// TargetId
        /// </summary>
        [DataMember(Name = ("targetId"), IsRequired = (true))]
        public string TargetId
        {
            get;
            set;
        }

        /// <summary>
        /// List of types: https://source.chromium.org/chromium/chromium/src/+/main:content/browser/devtools/devtools_agent_host_impl.cc?ss=chromium&amp;q=f:devtools%20-f:out%20%22::kTypeTab%5B%5D%22
        /// </summary>
        [DataMember(Name = ("type"), IsRequired = (true))]
        public string Type
        {
            get;
            set;
        }

        /// <summary>
        /// Title
        /// </summary>
        [DataMember(Name = ("title"), IsRequired = (true))]
        public string Title
        {
            get;
            set;
        }

        /// <summary>
        /// Url
        /// </summary>
        [DataMember(Name = ("url"), IsRequired = (true))]
        public string Url
        {
            get;
            set;
        }

        /// <summary>
        /// Whether the target has an attached client.
        /// </summary>
        [DataMember(Name = ("attached"), IsRequired = (true))]
        public bool Attached
        {
            get;
            set;
        }

        /// <summary>
        /// Opener target Id
        /// </summary>
        [DataMember(Name = ("openerId"), IsRequired = (false))]
        public string OpenerId
        {
            get;
            set;
        }

        /// <summary>
        /// Whether the target has access to the originating window.
        /// </summary>
        [DataMember(Name = ("canAccessOpener"), IsRequired = (true))]
        public bool CanAccessOpener
        {
            get;
            set;
        }

        /// <summary>
        /// Frame id of originating window (is only set if target has an opener).
        /// </summary>
        [DataMember(Name = ("openerFrameId"), IsRequired = (false))]
        public string OpenerFrameId
        {
            get;
            set;
        }

        /// <summary>
        /// BrowserContextId
        /// </summary>
        [DataMember(Name = ("browserContextId"), IsRequired = (false))]
        public string BrowserContextId
        {
            get;
            set;
        }

        /// <summary>
        /// Provides additional details for specific target types. For example, for
        /// the type of &quot;page&quot;, this may be set to &quot;prerender&quot;.
        /// </summary>
        [DataMember(Name = ("subtype"), IsRequired = (false))]
        public string Subtype
        {
            get;
            set;
        }
    }

    /// <summary>
    /// A filter used by target query/discovery/auto-attach operations.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class FilterEntry : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// If set, causes exclusion of matching targets from the list.
        /// </summary>
        [DataMember(Name = ("exclude"), IsRequired = (false))]
        public bool? Exclude
        {
            get;
            set;
        }

        /// <summary>
        /// If not present, matches any type.
        /// </summary>
        [DataMember(Name = ("type"), IsRequired = (false))]
        public string Type
        {
            get;
            set;
        }
    }

    /// <summary>
    /// RemoteLocation
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class RemoteLocation : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Host
        /// </summary>
        [DataMember(Name = ("host"), IsRequired = (true))]
        public string Host
        {
            get;
            set;
        }

        /// <summary>
        /// Port
        /// </summary>
        [DataMember(Name = ("port"), IsRequired = (true))]
        public int Port
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Issued when attached to target because of auto-attach or `attachToTarget` command.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class AttachedToTargetEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Identifier assigned to the session used to send/receive messages.
        /// </summary>
        [DataMember(Name = ("sessionId"), IsRequired = (true))]
        public string SessionId
        {
            get;
            private set;
        }

        /// <summary>
        /// TargetInfo
        /// </summary>
        [DataMember(Name = ("targetInfo"), IsRequired = (true))]
        public CefSharp.DevTools.Target.TargetInfo TargetInfo
        {
            get;
            private set;
        }

        /// <summary>
        /// WaitingForDebugger
        /// </summary>
        [DataMember(Name = ("waitingForDebugger"), IsRequired = (true))]
        public bool WaitingForDebugger
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Issued when detached from target for any reason (including `detachFromTarget` command). Can be
    /// issued multiple times per target if multiple sessions have been attached to it.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class DetachedFromTargetEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Detached session identifier.
        /// </summary>
        [DataMember(Name = ("sessionId"), IsRequired = (true))]
        public string SessionId
        {
            get;
            private set;
        }

        /// <summary>
        /// Deprecated.
        /// </summary>
        [DataMember(Name = ("targetId"), IsRequired = (false))]
        public string TargetId
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Notifies about a new protocol message received from the session (as reported in
    /// `attachedToTarget` event).
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class ReceivedMessageFromTargetEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Identifier of a session which sends a message.
        /// </summary>
        [DataMember(Name = ("sessionId"), IsRequired = (true))]
        public string SessionId
        {
            get;
            private set;
        }

        /// <summary>
        /// Message
        /// </summary>
        [DataMember(Name = ("message"), IsRequired = (true))]
        public string Message
        {
            get;
            private set;
        }

        /// <summary>
        /// Deprecated.
        /// </summary>
        [DataMember(Name = ("targetId"), IsRequired = (false))]
        public string TargetId
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Issued when a possible inspection target is created.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class TargetCreatedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// TargetInfo
        /// </summary>
        [DataMember(Name = ("targetInfo"), IsRequired = (true))]
        public CefSharp.DevTools.Target.TargetInfo TargetInfo
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Issued when a target is destroyed.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class TargetDestroyedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// TargetId
        /// </summary>
        [DataMember(Name = ("targetId"), IsRequired = (true))]
        public string TargetId
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Issued when a target has crashed.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class TargetCrashedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// TargetId
        /// </summary>
        [DataMember(Name = ("targetId"), IsRequired = (true))]
        public string TargetId
        {
            get;
            private set;
        }

        /// <summary>
        /// Termination status type.
        /// </summary>
        [DataMember(Name = ("status"), IsRequired = (true))]
        public string Status
        {
            get;
            private set;
        }

        /// <summary>
        /// Termination error code.
        /// </summary>
        [DataMember(Name = ("errorCode"), IsRequired = (true))]
        public int ErrorCode
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Issued when some information about a target has changed. This only happens between
    /// `targetCreated` and `targetDestroyed`.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class TargetInfoChangedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// TargetInfo
        /// </summary>
        [DataMember(Name = ("targetInfo"), IsRequired = (true))]
        public CefSharp.DevTools.Target.TargetInfo TargetInfo
        {
            get;
            private set;
        }
    }
}

namespace CefSharp.DevTools.Tethering
{
    /// <summary>
    /// Informs that port was successfully bound and got a specified connection id.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class AcceptedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Port number that was successfully bound.
        /// </summary>
        [DataMember(Name = ("port"), IsRequired = (true))]
        public int Port
        {
            get;
            private set;
        }

        /// <summary>
        /// Connection id to be used.
        /// </summary>
        [DataMember(Name = ("connectionId"), IsRequired = (true))]
        public string ConnectionId
        {
            get;
            private set;
        }
    }
}

namespace CefSharp.DevTools.Tracing
{
    /// <summary>
    /// Controls how the trace buffer stores data.
    /// </summary>
    public enum TraceConfigRecordMode
    {
        /// <summary>
        /// recordUntilFull
        /// </summary>
        [EnumMember(Value = ("recordUntilFull"))]
        RecordUntilFull,
        /// <summary>
        /// recordContinuously
        /// </summary>
        [EnumMember(Value = ("recordContinuously"))]
        RecordContinuously,
        /// <summary>
        /// recordAsMuchAsPossible
        /// </summary>
        [EnumMember(Value = ("recordAsMuchAsPossible"))]
        RecordAsMuchAsPossible,
        /// <summary>
        /// echoToConsole
        /// </summary>
        [EnumMember(Value = ("echoToConsole"))]
        EchoToConsole
    }

    /// <summary>
    /// TraceConfig
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class TraceConfig : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Controls how the trace buffer stores data.
        /// </summary>
        public CefSharp.DevTools.Tracing.TraceConfigRecordMode? RecordMode
        {
            get
            {
                return (CefSharp.DevTools.Tracing.TraceConfigRecordMode? )(StringToEnum(typeof(CefSharp.DevTools.Tracing.TraceConfigRecordMode? ), recordMode));
            }

            set
            {
                this.recordMode = (EnumToString(value));
            }
        }

        /// <summary>
        /// Controls how the trace buffer stores data.
        /// </summary>
        [DataMember(Name = ("recordMode"), IsRequired = (false))]
        internal string recordMode
        {
            get;
            set;
        }

        /// <summary>
        /// Size of the trace buffer in kilobytes. If not specified or zero is passed, a default value
        /// of 200 MB would be used.
        /// </summary>
        [DataMember(Name = ("traceBufferSizeInKb"), IsRequired = (false))]
        public double? TraceBufferSizeInKb
        {
            get;
            set;
        }

        /// <summary>
        /// Turns on JavaScript stack sampling.
        /// </summary>
        [DataMember(Name = ("enableSampling"), IsRequired = (false))]
        public bool? EnableSampling
        {
            get;
            set;
        }

        /// <summary>
        /// Turns on system tracing.
        /// </summary>
        [DataMember(Name = ("enableSystrace"), IsRequired = (false))]
        public bool? EnableSystrace
        {
            get;
            set;
        }

        /// <summary>
        /// Turns on argument filter.
        /// </summary>
        [DataMember(Name = ("enableArgumentFilter"), IsRequired = (false))]
        public bool? EnableArgumentFilter
        {
            get;
            set;
        }

        /// <summary>
        /// Included category filters.
        /// </summary>
        [DataMember(Name = ("includedCategories"), IsRequired = (false))]
        public string[] IncludedCategories
        {
            get;
            set;
        }

        /// <summary>
        /// Excluded category filters.
        /// </summary>
        [DataMember(Name = ("excludedCategories"), IsRequired = (false))]
        public string[] ExcludedCategories
        {
            get;
            set;
        }

        /// <summary>
        /// Configuration to synthesize the delays in tracing.
        /// </summary>
        [DataMember(Name = ("syntheticDelays"), IsRequired = (false))]
        public string[] SyntheticDelays
        {
            get;
            set;
        }

        /// <summary>
        /// Configuration for memory dump triggers. Used only when &quot;memory-infra&quot; category is enabled.
        /// </summary>
        [DataMember(Name = ("memoryDumpConfig"), IsRequired = (false))]
        public CefSharp.DevTools.Tracing.MemoryDumpConfig MemoryDumpConfig
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Data format of a trace. Can be either the legacy JSON format or the
    /// protocol buffer format. Note that the JSON format will be deprecated soon.
    /// </summary>
    public enum StreamFormat
    {
        /// <summary>
        /// json
        /// </summary>
        [EnumMember(Value = ("json"))]
        Json,
        /// <summary>
        /// proto
        /// </summary>
        [EnumMember(Value = ("proto"))]
        Proto
    }

    /// <summary>
    /// Compression type to use for traces returned via streams.
    /// </summary>
    public enum StreamCompression
    {
        /// <summary>
        /// none
        /// </summary>
        [EnumMember(Value = ("none"))]
        None,
        /// <summary>
        /// gzip
        /// </summary>
        [EnumMember(Value = ("gzip"))]
        Gzip
    }

    /// <summary>
    /// Details exposed when memory request explicitly declared.
    /// Keep consistent with memory_dump_request_args.h and
    /// memory_instrumentation.mojom
    /// </summary>
    public enum MemoryDumpLevelOfDetail
    {
        /// <summary>
        /// background
        /// </summary>
        [EnumMember(Value = ("background"))]
        Background,
        /// <summary>
        /// light
        /// </summary>
        [EnumMember(Value = ("light"))]
        Light,
        /// <summary>
        /// detailed
        /// </summary>
        [EnumMember(Value = ("detailed"))]
        Detailed
    }

    /// <summary>
    /// Backend type to use for tracing. `chrome` uses the Chrome-integrated
    /// tracing service and is supported on all platforms. `system` is only
    /// supported on Chrome OS and uses the Perfetto system tracing service.
    /// `auto` chooses `system` when the perfettoConfig provided to Tracing.start
    /// specifies at least one non-Chrome data source; otherwise uses `chrome`.
    /// </summary>
    public enum TracingBackend
    {
        /// <summary>
        /// auto
        /// </summary>
        [EnumMember(Value = ("auto"))]
        Auto,
        /// <summary>
        /// chrome
        /// </summary>
        [EnumMember(Value = ("chrome"))]
        Chrome,
        /// <summary>
        /// system
        /// </summary>
        [EnumMember(Value = ("system"))]
        System
    }

    /// <summary>
    /// bufferUsage
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class BufferUsageEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// A number in range [0..1] that indicates the used size of event buffer as a fraction of its
        /// total size.
        /// </summary>
        [DataMember(Name = ("percentFull"), IsRequired = (false))]
        public double? PercentFull
        {
            get;
            private set;
        }

        /// <summary>
        /// An approximate number of events in the trace log.
        /// </summary>
        [DataMember(Name = ("eventCount"), IsRequired = (false))]
        public double? EventCount
        {
            get;
            private set;
        }

        /// <summary>
        /// A number in range [0..1] that indicates the used size of event buffer as a fraction of its
        /// total size.
        /// </summary>
        [DataMember(Name = ("value"), IsRequired = (false))]
        public double? Value
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Contains a bucket of collected trace events. When tracing is stopped collected events will be
    /// sent as a sequence of dataCollected events followed by tracingComplete event.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class DataCollectedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Value
        /// </summary>
        [DataMember(Name = ("value"), IsRequired = (true))]
        public System.Collections.Generic.IList<object> Value
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Signals that tracing is stopped and there is no trace buffers pending flush, all data were
    /// delivered via dataCollected events.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class TracingCompleteEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Indicates whether some trace data is known to have been lost, e.g. because the trace ring
        /// buffer wrapped around.
        /// </summary>
        [DataMember(Name = ("dataLossOccurred"), IsRequired = (true))]
        public bool DataLossOccurred
        {
            get;
            private set;
        }

        /// <summary>
        /// A handle of the stream that holds resulting trace data.
        /// </summary>
        [DataMember(Name = ("stream"), IsRequired = (false))]
        public string Stream
        {
            get;
            private set;
        }

        /// <summary>
        /// Trace data format of returned stream.
        /// </summary>
        public CefSharp.DevTools.Tracing.StreamFormat? TraceFormat
        {
            get
            {
                return (CefSharp.DevTools.Tracing.StreamFormat? )(StringToEnum(typeof(CefSharp.DevTools.Tracing.StreamFormat? ), traceFormat));
            }

            set
            {
                this.traceFormat = (EnumToString(value));
            }
        }

        /// <summary>
        /// Trace data format of returned stream.
        /// </summary>
        [DataMember(Name = ("traceFormat"), IsRequired = (false))]
        internal string traceFormat
        {
            get;
            private set;
        }

        /// <summary>
        /// Compression format of returned stream.
        /// </summary>
        public CefSharp.DevTools.Tracing.StreamCompression? StreamCompression
        {
            get
            {
                return (CefSharp.DevTools.Tracing.StreamCompression? )(StringToEnum(typeof(CefSharp.DevTools.Tracing.StreamCompression? ), streamCompression));
            }

            set
            {
                this.streamCompression = (EnumToString(value));
            }
        }

        /// <summary>
        /// Compression format of returned stream.
        /// </summary>
        [DataMember(Name = ("streamCompression"), IsRequired = (false))]
        internal string streamCompression
        {
            get;
            private set;
        }
    }
}

namespace CefSharp.DevTools.Fetch
{
    /// <summary>
    /// Stages of the request to handle. Request will intercept before the request is
    /// sent. Response will intercept after the response is received (but before response
    /// body is received).
    /// </summary>
    public enum RequestStage
    {
        /// <summary>
        /// Request
        /// </summary>
        [EnumMember(Value = ("Request"))]
        Request,
        /// <summary>
        /// Response
        /// </summary>
        [EnumMember(Value = ("Response"))]
        Response
    }

    /// <summary>
    /// RequestPattern
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class RequestPattern : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Wildcards (`&apos;*&apos;` -&gt; zero or more, `&apos;?&apos;` -&gt; exactly one) are allowed. Escape character is
        /// backslash. Omitting is equivalent to `&quot;*&quot;`.
        /// </summary>
        [DataMember(Name = ("urlPattern"), IsRequired = (false))]
        public string UrlPattern
        {
            get;
            set;
        }

        /// <summary>
        /// If set, only requests for matching resource types will be intercepted.
        /// </summary>
        public CefSharp.DevTools.Network.ResourceType? ResourceType
        {
            get
            {
                return (CefSharp.DevTools.Network.ResourceType? )(StringToEnum(typeof(CefSharp.DevTools.Network.ResourceType? ), resourceType));
            }

            set
            {
                this.resourceType = (EnumToString(value));
            }
        }

        /// <summary>
        /// If set, only requests for matching resource types will be intercepted.
        /// </summary>
        [DataMember(Name = ("resourceType"), IsRequired = (false))]
        internal string resourceType
        {
            get;
            set;
        }

        /// <summary>
        /// Stage at which to begin intercepting requests. Default is Request.
        /// </summary>
        public CefSharp.DevTools.Fetch.RequestStage? RequestStage
        {
            get
            {
                return (CefSharp.DevTools.Fetch.RequestStage? )(StringToEnum(typeof(CefSharp.DevTools.Fetch.RequestStage? ), requestStage));
            }

            set
            {
                this.requestStage = (EnumToString(value));
            }
        }

        /// <summary>
        /// Stage at which to begin intercepting requests. Default is Request.
        /// </summary>
        [DataMember(Name = ("requestStage"), IsRequired = (false))]
        internal string requestStage
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Response HTTP header entry
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class HeaderEntry : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Name
        /// </summary>
        [DataMember(Name = ("name"), IsRequired = (true))]
        public string Name
        {
            get;
            set;
        }

        /// <summary>
        /// Value
        /// </summary>
        [DataMember(Name = ("value"), IsRequired = (true))]
        public string Value
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Source of the authentication challenge.
    /// </summary>
    public enum AuthChallengeSource
    {
        /// <summary>
        /// Server
        /// </summary>
        [EnumMember(Value = ("Server"))]
        Server,
        /// <summary>
        /// Proxy
        /// </summary>
        [EnumMember(Value = ("Proxy"))]
        Proxy
    }

    /// <summary>
    /// Authorization challenge for HTTP status code 401 or 407.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class AuthChallenge : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Source of the authentication challenge.
        /// </summary>
        public CefSharp.DevTools.Fetch.AuthChallengeSource? Source
        {
            get
            {
                return (CefSharp.DevTools.Fetch.AuthChallengeSource? )(StringToEnum(typeof(CefSharp.DevTools.Fetch.AuthChallengeSource? ), source));
            }

            set
            {
                this.source = (EnumToString(value));
            }
        }

        /// <summary>
        /// Source of the authentication challenge.
        /// </summary>
        [DataMember(Name = ("source"), IsRequired = (false))]
        internal string source
        {
            get;
            set;
        }

        /// <summary>
        /// Origin of the challenger.
        /// </summary>
        [DataMember(Name = ("origin"), IsRequired = (true))]
        public string Origin
        {
            get;
            set;
        }

        /// <summary>
        /// The authentication scheme used, such as basic or digest
        /// </summary>
        [DataMember(Name = ("scheme"), IsRequired = (true))]
        public string Scheme
        {
            get;
            set;
        }

        /// <summary>
        /// The realm of the challenge. May be empty.
        /// </summary>
        [DataMember(Name = ("realm"), IsRequired = (true))]
        public string Realm
        {
            get;
            set;
        }
    }

    /// <summary>
    /// The decision on what to do in response to the authorization challenge.  Default means
    /// deferring to the default behavior of the net stack, which will likely either the Cancel
    /// authentication or display a popup dialog box.
    /// </summary>
    public enum AuthChallengeResponseResponse
    {
        /// <summary>
        /// Default
        /// </summary>
        [EnumMember(Value = ("Default"))]
        Default,
        /// <summary>
        /// CancelAuth
        /// </summary>
        [EnumMember(Value = ("CancelAuth"))]
        CancelAuth,
        /// <summary>
        /// ProvideCredentials
        /// </summary>
        [EnumMember(Value = ("ProvideCredentials"))]
        ProvideCredentials
    }

    /// <summary>
    /// Response to an AuthChallenge.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class AuthChallengeResponse : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The decision on what to do in response to the authorization challenge.  Default means
        /// deferring to the default behavior of the net stack, which will likely either the Cancel
        /// authentication or display a popup dialog box.
        /// </summary>
        public CefSharp.DevTools.Fetch.AuthChallengeResponseResponse Response
        {
            get
            {
                return (CefSharp.DevTools.Fetch.AuthChallengeResponseResponse)(StringToEnum(typeof(CefSharp.DevTools.Fetch.AuthChallengeResponseResponse), response));
            }

            set
            {
                this.response = (EnumToString(value));
            }
        }

        /// <summary>
        /// The decision on what to do in response to the authorization challenge.  Default means
        /// deferring to the default behavior of the net stack, which will likely either the Cancel
        /// authentication or display a popup dialog box.
        /// </summary>
        [DataMember(Name = ("response"), IsRequired = (true))]
        internal string response
        {
            get;
            set;
        }

        /// <summary>
        /// The username to provide, possibly empty. Should only be set if response is
        /// ProvideCredentials.
        /// </summary>
        [DataMember(Name = ("username"), IsRequired = (false))]
        public string Username
        {
            get;
            set;
        }

        /// <summary>
        /// The password to provide, possibly empty. Should only be set if response is
        /// ProvideCredentials.
        /// </summary>
        [DataMember(Name = ("password"), IsRequired = (false))]
        public string Password
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Issued when the domain is enabled and the request URL matches the
    /// specified filter. The request is paused until the client responds
    /// with one of continueRequest, failRequest or fulfillRequest.
    /// The stage of the request can be determined by presence of responseErrorReason
    /// and responseStatusCode -- the request is at the response stage if either
    /// of these fields is present and in the request stage otherwise.
    /// Redirect responses and subsequent requests are reported similarly to regular
    /// responses and requests. Redirect responses may be distinguished by the value
    /// of `responseStatusCode` (which is one of 301, 302, 303, 307, 308) along with
    /// presence of the `location` header. Requests resulting from a redirect will
    /// have `redirectedRequestId` field set.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class RequestPausedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Each request the page makes will have a unique id.
        /// </summary>
        [DataMember(Name = ("requestId"), IsRequired = (true))]
        public string RequestId
        {
            get;
            private set;
        }

        /// <summary>
        /// The details of the request.
        /// </summary>
        [DataMember(Name = ("request"), IsRequired = (true))]
        public CefSharp.DevTools.Network.Request Request
        {
            get;
            private set;
        }

        /// <summary>
        /// The id of the frame that initiated the request.
        /// </summary>
        [DataMember(Name = ("frameId"), IsRequired = (true))]
        public string FrameId
        {
            get;
            private set;
        }

        /// <summary>
        /// How the requested resource will be used.
        /// </summary>
        public CefSharp.DevTools.Network.ResourceType ResourceType
        {
            get
            {
                return (CefSharp.DevTools.Network.ResourceType)(StringToEnum(typeof(CefSharp.DevTools.Network.ResourceType), resourceType));
            }

            set
            {
                this.resourceType = (EnumToString(value));
            }
        }

        /// <summary>
        /// How the requested resource will be used.
        /// </summary>
        [DataMember(Name = ("resourceType"), IsRequired = (true))]
        internal string resourceType
        {
            get;
            private set;
        }

        /// <summary>
        /// Response error if intercepted at response stage.
        /// </summary>
        public CefSharp.DevTools.Network.ErrorReason? ResponseErrorReason
        {
            get
            {
                return (CefSharp.DevTools.Network.ErrorReason? )(StringToEnum(typeof(CefSharp.DevTools.Network.ErrorReason? ), responseErrorReason));
            }

            set
            {
                this.responseErrorReason = (EnumToString(value));
            }
        }

        /// <summary>
        /// Response error if intercepted at response stage.
        /// </summary>
        [DataMember(Name = ("responseErrorReason"), IsRequired = (false))]
        internal string responseErrorReason
        {
            get;
            private set;
        }

        /// <summary>
        /// Response code if intercepted at response stage.
        /// </summary>
        [DataMember(Name = ("responseStatusCode"), IsRequired = (false))]
        public int? ResponseStatusCode
        {
            get;
            private set;
        }

        /// <summary>
        /// Response status text if intercepted at response stage.
        /// </summary>
        [DataMember(Name = ("responseStatusText"), IsRequired = (false))]
        public string ResponseStatusText
        {
            get;
            private set;
        }

        /// <summary>
        /// Response headers if intercepted at the response stage.
        /// </summary>
        [DataMember(Name = ("responseHeaders"), IsRequired = (false))]
        public System.Collections.Generic.IList<CefSharp.DevTools.Fetch.HeaderEntry> ResponseHeaders
        {
            get;
            private set;
        }

        /// <summary>
        /// If the intercepted request had a corresponding Network.requestWillBeSent event fired for it,
        /// then this networkId will be the same as the requestId present in the requestWillBeSent event.
        /// </summary>
        [DataMember(Name = ("networkId"), IsRequired = (false))]
        public string NetworkId
        {
            get;
            private set;
        }

        /// <summary>
        /// If the request is due to a redirect response from the server, the id of the request that
        /// has caused the redirect.
        /// </summary>
        [DataMember(Name = ("redirectedRequestId"), IsRequired = (false))]
        public string RedirectedRequestId
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Issued when the domain is enabled with handleAuthRequests set to true.
    /// The request is paused until client responds with continueWithAuth.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class AuthRequiredEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Each request the page makes will have a unique id.
        /// </summary>
        [DataMember(Name = ("requestId"), IsRequired = (true))]
        public string RequestId
        {
            get;
            private set;
        }

        /// <summary>
        /// The details of the request.
        /// </summary>
        [DataMember(Name = ("request"), IsRequired = (true))]
        public CefSharp.DevTools.Network.Request Request
        {
            get;
            private set;
        }

        /// <summary>
        /// The id of the frame that initiated the request.
        /// </summary>
        [DataMember(Name = ("frameId"), IsRequired = (true))]
        public string FrameId
        {
            get;
            private set;
        }

        /// <summary>
        /// How the requested resource will be used.
        /// </summary>
        public CefSharp.DevTools.Network.ResourceType ResourceType
        {
            get
            {
                return (CefSharp.DevTools.Network.ResourceType)(StringToEnum(typeof(CefSharp.DevTools.Network.ResourceType), resourceType));
            }

            set
            {
                this.resourceType = (EnumToString(value));
            }
        }

        /// <summary>
        /// How the requested resource will be used.
        /// </summary>
        [DataMember(Name = ("resourceType"), IsRequired = (true))]
        internal string resourceType
        {
            get;
            private set;
        }

        /// <summary>
        /// Details of the Authorization Challenge encountered.
        /// If this is set, client should respond with continueRequest that
        /// contains AuthChallengeResponse.
        /// </summary>
        [DataMember(Name = ("authChallenge"), IsRequired = (true))]
        public CefSharp.DevTools.Fetch.AuthChallenge AuthChallenge
        {
            get;
            private set;
        }
    }
}

namespace CefSharp.DevTools.WebAudio
{
    /// <summary>
    /// Enum of BaseAudioContext types
    /// </summary>
    public enum ContextType
    {
        /// <summary>
        /// realtime
        /// </summary>
        [EnumMember(Value = ("realtime"))]
        Realtime,
        /// <summary>
        /// offline
        /// </summary>
        [EnumMember(Value = ("offline"))]
        Offline
    }

    /// <summary>
    /// Enum of AudioContextState from the spec
    /// </summary>
    public enum ContextState
    {
        /// <summary>
        /// suspended
        /// </summary>
        [EnumMember(Value = ("suspended"))]
        Suspended,
        /// <summary>
        /// running
        /// </summary>
        [EnumMember(Value = ("running"))]
        Running,
        /// <summary>
        /// closed
        /// </summary>
        [EnumMember(Value = ("closed"))]
        Closed
    }

    /// <summary>
    /// Enum of AudioNode::ChannelCountMode from the spec
    /// </summary>
    public enum ChannelCountMode
    {
        /// <summary>
        /// clamped-max
        /// </summary>
        [EnumMember(Value = ("clamped-max"))]
        ClampedMax,
        /// <summary>
        /// explicit
        /// </summary>
        [EnumMember(Value = ("explicit"))]
        Explicit,
        /// <summary>
        /// max
        /// </summary>
        [EnumMember(Value = ("max"))]
        Max
    }

    /// <summary>
    /// Enum of AudioNode::ChannelInterpretation from the spec
    /// </summary>
    public enum ChannelInterpretation
    {
        /// <summary>
        /// discrete
        /// </summary>
        [EnumMember(Value = ("discrete"))]
        Discrete,
        /// <summary>
        /// speakers
        /// </summary>
        [EnumMember(Value = ("speakers"))]
        Speakers
    }

    /// <summary>
    /// Enum of AudioParam::AutomationRate from the spec
    /// </summary>
    public enum AutomationRate
    {
        /// <summary>
        /// a-rate
        /// </summary>
        [EnumMember(Value = ("a-rate"))]
        ARate,
        /// <summary>
        /// k-rate
        /// </summary>
        [EnumMember(Value = ("k-rate"))]
        KRate
    }

    /// <summary>
    /// Fields in AudioContext that change in real-time.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class ContextRealtimeData : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The current context time in second in BaseAudioContext.
        /// </summary>
        [DataMember(Name = ("currentTime"), IsRequired = (true))]
        public double CurrentTime
        {
            get;
            set;
        }

        /// <summary>
        /// The time spent on rendering graph divided by render quantum duration,
        /// and multiplied by 100. 100 means the audio renderer reached the full
        /// capacity and glitch may occur.
        /// </summary>
        [DataMember(Name = ("renderCapacity"), IsRequired = (true))]
        public double RenderCapacity
        {
            get;
            set;
        }

        /// <summary>
        /// A running mean of callback interval.
        /// </summary>
        [DataMember(Name = ("callbackIntervalMean"), IsRequired = (true))]
        public double CallbackIntervalMean
        {
            get;
            set;
        }

        /// <summary>
        /// A running variance of callback interval.
        /// </summary>
        [DataMember(Name = ("callbackIntervalVariance"), IsRequired = (true))]
        public double CallbackIntervalVariance
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Protocol object for BaseAudioContext
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class BaseAudioContext : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// ContextId
        /// </summary>
        [DataMember(Name = ("contextId"), IsRequired = (true))]
        public string ContextId
        {
            get;
            set;
        }

        /// <summary>
        /// ContextType
        /// </summary>
        public CefSharp.DevTools.WebAudio.ContextType ContextType
        {
            get
            {
                return (CefSharp.DevTools.WebAudio.ContextType)(StringToEnum(typeof(CefSharp.DevTools.WebAudio.ContextType), contextType));
            }

            set
            {
                this.contextType = (EnumToString(value));
            }
        }

        /// <summary>
        /// ContextType
        /// </summary>
        [DataMember(Name = ("contextType"), IsRequired = (true))]
        internal string contextType
        {
            get;
            set;
        }

        /// <summary>
        /// ContextState
        /// </summary>
        public CefSharp.DevTools.WebAudio.ContextState ContextState
        {
            get
            {
                return (CefSharp.DevTools.WebAudio.ContextState)(StringToEnum(typeof(CefSharp.DevTools.WebAudio.ContextState), contextState));
            }

            set
            {
                this.contextState = (EnumToString(value));
            }
        }

        /// <summary>
        /// ContextState
        /// </summary>
        [DataMember(Name = ("contextState"), IsRequired = (true))]
        internal string contextState
        {
            get;
            set;
        }

        /// <summary>
        /// RealtimeData
        /// </summary>
        [DataMember(Name = ("realtimeData"), IsRequired = (false))]
        public CefSharp.DevTools.WebAudio.ContextRealtimeData RealtimeData
        {
            get;
            set;
        }

        /// <summary>
        /// Platform-dependent callback buffer size.
        /// </summary>
        [DataMember(Name = ("callbackBufferSize"), IsRequired = (true))]
        public double CallbackBufferSize
        {
            get;
            set;
        }

        /// <summary>
        /// Number of output channels supported by audio hardware in use.
        /// </summary>
        [DataMember(Name = ("maxOutputChannelCount"), IsRequired = (true))]
        public double MaxOutputChannelCount
        {
            get;
            set;
        }

        /// <summary>
        /// Context sample rate.
        /// </summary>
        [DataMember(Name = ("sampleRate"), IsRequired = (true))]
        public double SampleRate
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Protocol object for AudioListener
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class AudioListener : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// ListenerId
        /// </summary>
        [DataMember(Name = ("listenerId"), IsRequired = (true))]
        public string ListenerId
        {
            get;
            set;
        }

        /// <summary>
        /// ContextId
        /// </summary>
        [DataMember(Name = ("contextId"), IsRequired = (true))]
        public string ContextId
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Protocol object for AudioNode
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class AudioNode : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// NodeId
        /// </summary>
        [DataMember(Name = ("nodeId"), IsRequired = (true))]
        public string NodeId
        {
            get;
            set;
        }

        /// <summary>
        /// ContextId
        /// </summary>
        [DataMember(Name = ("contextId"), IsRequired = (true))]
        public string ContextId
        {
            get;
            set;
        }

        /// <summary>
        /// NodeType
        /// </summary>
        [DataMember(Name = ("nodeType"), IsRequired = (true))]
        public string NodeType
        {
            get;
            set;
        }

        /// <summary>
        /// NumberOfInputs
        /// </summary>
        [DataMember(Name = ("numberOfInputs"), IsRequired = (true))]
        public double NumberOfInputs
        {
            get;
            set;
        }

        /// <summary>
        /// NumberOfOutputs
        /// </summary>
        [DataMember(Name = ("numberOfOutputs"), IsRequired = (true))]
        public double NumberOfOutputs
        {
            get;
            set;
        }

        /// <summary>
        /// ChannelCount
        /// </summary>
        [DataMember(Name = ("channelCount"), IsRequired = (true))]
        public double ChannelCount
        {
            get;
            set;
        }

        /// <summary>
        /// ChannelCountMode
        /// </summary>
        public CefSharp.DevTools.WebAudio.ChannelCountMode ChannelCountMode
        {
            get
            {
                return (CefSharp.DevTools.WebAudio.ChannelCountMode)(StringToEnum(typeof(CefSharp.DevTools.WebAudio.ChannelCountMode), channelCountMode));
            }

            set
            {
                this.channelCountMode = (EnumToString(value));
            }
        }

        /// <summary>
        /// ChannelCountMode
        /// </summary>
        [DataMember(Name = ("channelCountMode"), IsRequired = (true))]
        internal string channelCountMode
        {
            get;
            set;
        }

        /// <summary>
        /// ChannelInterpretation
        /// </summary>
        public CefSharp.DevTools.WebAudio.ChannelInterpretation ChannelInterpretation
        {
            get
            {
                return (CefSharp.DevTools.WebAudio.ChannelInterpretation)(StringToEnum(typeof(CefSharp.DevTools.WebAudio.ChannelInterpretation), channelInterpretation));
            }

            set
            {
                this.channelInterpretation = (EnumToString(value));
            }
        }

        /// <summary>
        /// ChannelInterpretation
        /// </summary>
        [DataMember(Name = ("channelInterpretation"), IsRequired = (true))]
        internal string channelInterpretation
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Protocol object for AudioParam
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class AudioParam : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// ParamId
        /// </summary>
        [DataMember(Name = ("paramId"), IsRequired = (true))]
        public string ParamId
        {
            get;
            set;
        }

        /// <summary>
        /// NodeId
        /// </summary>
        [DataMember(Name = ("nodeId"), IsRequired = (true))]
        public string NodeId
        {
            get;
            set;
        }

        /// <summary>
        /// ContextId
        /// </summary>
        [DataMember(Name = ("contextId"), IsRequired = (true))]
        public string ContextId
        {
            get;
            set;
        }

        /// <summary>
        /// ParamType
        /// </summary>
        [DataMember(Name = ("paramType"), IsRequired = (true))]
        public string ParamType
        {
            get;
            set;
        }

        /// <summary>
        /// Rate
        /// </summary>
        public CefSharp.DevTools.WebAudio.AutomationRate Rate
        {
            get
            {
                return (CefSharp.DevTools.WebAudio.AutomationRate)(StringToEnum(typeof(CefSharp.DevTools.WebAudio.AutomationRate), rate));
            }

            set
            {
                this.rate = (EnumToString(value));
            }
        }

        /// <summary>
        /// Rate
        /// </summary>
        [DataMember(Name = ("rate"), IsRequired = (true))]
        internal string rate
        {
            get;
            set;
        }

        /// <summary>
        /// DefaultValue
        /// </summary>
        [DataMember(Name = ("defaultValue"), IsRequired = (true))]
        public double DefaultValue
        {
            get;
            set;
        }

        /// <summary>
        /// MinValue
        /// </summary>
        [DataMember(Name = ("minValue"), IsRequired = (true))]
        public double MinValue
        {
            get;
            set;
        }

        /// <summary>
        /// MaxValue
        /// </summary>
        [DataMember(Name = ("maxValue"), IsRequired = (true))]
        public double MaxValue
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Notifies that a new BaseAudioContext has been created.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class ContextCreatedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Context
        /// </summary>
        [DataMember(Name = ("context"), IsRequired = (true))]
        public CefSharp.DevTools.WebAudio.BaseAudioContext Context
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Notifies that an existing BaseAudioContext will be destroyed.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class ContextWillBeDestroyedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// ContextId
        /// </summary>
        [DataMember(Name = ("contextId"), IsRequired = (true))]
        public string ContextId
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Notifies that existing BaseAudioContext has changed some properties (id stays the same)..
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class ContextChangedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Context
        /// </summary>
        [DataMember(Name = ("context"), IsRequired = (true))]
        public CefSharp.DevTools.WebAudio.BaseAudioContext Context
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Notifies that the construction of an AudioListener has finished.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class AudioListenerCreatedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Listener
        /// </summary>
        [DataMember(Name = ("listener"), IsRequired = (true))]
        public CefSharp.DevTools.WebAudio.AudioListener Listener
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Notifies that a new AudioListener has been created.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class AudioListenerWillBeDestroyedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// ContextId
        /// </summary>
        [DataMember(Name = ("contextId"), IsRequired = (true))]
        public string ContextId
        {
            get;
            private set;
        }

        /// <summary>
        /// ListenerId
        /// </summary>
        [DataMember(Name = ("listenerId"), IsRequired = (true))]
        public string ListenerId
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Notifies that a new AudioNode has been created.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class AudioNodeCreatedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Node
        /// </summary>
        [DataMember(Name = ("node"), IsRequired = (true))]
        public CefSharp.DevTools.WebAudio.AudioNode Node
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Notifies that an existing AudioNode has been destroyed.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class AudioNodeWillBeDestroyedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// ContextId
        /// </summary>
        [DataMember(Name = ("contextId"), IsRequired = (true))]
        public string ContextId
        {
            get;
            private set;
        }

        /// <summary>
        /// NodeId
        /// </summary>
        [DataMember(Name = ("nodeId"), IsRequired = (true))]
        public string NodeId
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Notifies that a new AudioParam has been created.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class AudioParamCreatedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Param
        /// </summary>
        [DataMember(Name = ("param"), IsRequired = (true))]
        public CefSharp.DevTools.WebAudio.AudioParam Param
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Notifies that an existing AudioParam has been destroyed.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class AudioParamWillBeDestroyedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// ContextId
        /// </summary>
        [DataMember(Name = ("contextId"), IsRequired = (true))]
        public string ContextId
        {
            get;
            private set;
        }

        /// <summary>
        /// NodeId
        /// </summary>
        [DataMember(Name = ("nodeId"), IsRequired = (true))]
        public string NodeId
        {
            get;
            private set;
        }

        /// <summary>
        /// ParamId
        /// </summary>
        [DataMember(Name = ("paramId"), IsRequired = (true))]
        public string ParamId
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Notifies that two AudioNodes are connected.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class NodesConnectedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// ContextId
        /// </summary>
        [DataMember(Name = ("contextId"), IsRequired = (true))]
        public string ContextId
        {
            get;
            private set;
        }

        /// <summary>
        /// SourceId
        /// </summary>
        [DataMember(Name = ("sourceId"), IsRequired = (true))]
        public string SourceId
        {
            get;
            private set;
        }

        /// <summary>
        /// DestinationId
        /// </summary>
        [DataMember(Name = ("destinationId"), IsRequired = (true))]
        public string DestinationId
        {
            get;
            private set;
        }

        /// <summary>
        /// SourceOutputIndex
        /// </summary>
        [DataMember(Name = ("sourceOutputIndex"), IsRequired = (false))]
        public double? SourceOutputIndex
        {
            get;
            private set;
        }

        /// <summary>
        /// DestinationInputIndex
        /// </summary>
        [DataMember(Name = ("destinationInputIndex"), IsRequired = (false))]
        public double? DestinationInputIndex
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Notifies that AudioNodes are disconnected. The destination can be null, and it means all the outgoing connections from the source are disconnected.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class NodesDisconnectedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// ContextId
        /// </summary>
        [DataMember(Name = ("contextId"), IsRequired = (true))]
        public string ContextId
        {
            get;
            private set;
        }

        /// <summary>
        /// SourceId
        /// </summary>
        [DataMember(Name = ("sourceId"), IsRequired = (true))]
        public string SourceId
        {
            get;
            private set;
        }

        /// <summary>
        /// DestinationId
        /// </summary>
        [DataMember(Name = ("destinationId"), IsRequired = (true))]
        public string DestinationId
        {
            get;
            private set;
        }

        /// <summary>
        /// SourceOutputIndex
        /// </summary>
        [DataMember(Name = ("sourceOutputIndex"), IsRequired = (false))]
        public double? SourceOutputIndex
        {
            get;
            private set;
        }

        /// <summary>
        /// DestinationInputIndex
        /// </summary>
        [DataMember(Name = ("destinationInputIndex"), IsRequired = (false))]
        public double? DestinationInputIndex
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Notifies that an AudioNode is connected to an AudioParam.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class NodeParamConnectedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// ContextId
        /// </summary>
        [DataMember(Name = ("contextId"), IsRequired = (true))]
        public string ContextId
        {
            get;
            private set;
        }

        /// <summary>
        /// SourceId
        /// </summary>
        [DataMember(Name = ("sourceId"), IsRequired = (true))]
        public string SourceId
        {
            get;
            private set;
        }

        /// <summary>
        /// DestinationId
        /// </summary>
        [DataMember(Name = ("destinationId"), IsRequired = (true))]
        public string DestinationId
        {
            get;
            private set;
        }

        /// <summary>
        /// SourceOutputIndex
        /// </summary>
        [DataMember(Name = ("sourceOutputIndex"), IsRequired = (false))]
        public double? SourceOutputIndex
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Notifies that an AudioNode is disconnected to an AudioParam.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class NodeParamDisconnectedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// ContextId
        /// </summary>
        [DataMember(Name = ("contextId"), IsRequired = (true))]
        public string ContextId
        {
            get;
            private set;
        }

        /// <summary>
        /// SourceId
        /// </summary>
        [DataMember(Name = ("sourceId"), IsRequired = (true))]
        public string SourceId
        {
            get;
            private set;
        }

        /// <summary>
        /// DestinationId
        /// </summary>
        [DataMember(Name = ("destinationId"), IsRequired = (true))]
        public string DestinationId
        {
            get;
            private set;
        }

        /// <summary>
        /// SourceOutputIndex
        /// </summary>
        [DataMember(Name = ("sourceOutputIndex"), IsRequired = (false))]
        public double? SourceOutputIndex
        {
            get;
            private set;
        }
    }
}

namespace CefSharp.DevTools.WebAuthn
{
    /// <summary>
    /// AuthenticatorProtocol
    /// </summary>
    public enum AuthenticatorProtocol
    {
        /// <summary>
        /// u2f
        /// </summary>
        [EnumMember(Value = ("u2f"))]
        U2f,
        /// <summary>
        /// ctap2
        /// </summary>
        [EnumMember(Value = ("ctap2"))]
        Ctap2
    }

    /// <summary>
    /// Ctap2Version
    /// </summary>
    public enum Ctap2Version
    {
        /// <summary>
        /// ctap2_0
        /// </summary>
        [EnumMember(Value = ("ctap2_0"))]
        Ctap20,
        /// <summary>
        /// ctap2_1
        /// </summary>
        [EnumMember(Value = ("ctap2_1"))]
        Ctap21
    }

    /// <summary>
    /// AuthenticatorTransport
    /// </summary>
    public enum AuthenticatorTransport
    {
        /// <summary>
        /// usb
        /// </summary>
        [EnumMember(Value = ("usb"))]
        Usb,
        /// <summary>
        /// nfc
        /// </summary>
        [EnumMember(Value = ("nfc"))]
        Nfc,
        /// <summary>
        /// ble
        /// </summary>
        [EnumMember(Value = ("ble"))]
        Ble,
        /// <summary>
        /// cable
        /// </summary>
        [EnumMember(Value = ("cable"))]
        Cable,
        /// <summary>
        /// internal
        /// </summary>
        [EnumMember(Value = ("internal"))]
        Internal
    }

    /// <summary>
    /// VirtualAuthenticatorOptions
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class VirtualAuthenticatorOptions : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Protocol
        /// </summary>
        public CefSharp.DevTools.WebAuthn.AuthenticatorProtocol Protocol
        {
            get
            {
                return (CefSharp.DevTools.WebAuthn.AuthenticatorProtocol)(StringToEnum(typeof(CefSharp.DevTools.WebAuthn.AuthenticatorProtocol), protocol));
            }

            set
            {
                this.protocol = (EnumToString(value));
            }
        }

        /// <summary>
        /// Protocol
        /// </summary>
        [DataMember(Name = ("protocol"), IsRequired = (true))]
        internal string protocol
        {
            get;
            set;
        }

        /// <summary>
        /// Defaults to ctap2_0. Ignored if |protocol| == u2f.
        /// </summary>
        public CefSharp.DevTools.WebAuthn.Ctap2Version? Ctap2Version
        {
            get
            {
                return (CefSharp.DevTools.WebAuthn.Ctap2Version? )(StringToEnum(typeof(CefSharp.DevTools.WebAuthn.Ctap2Version? ), ctap2Version));
            }

            set
            {
                this.ctap2Version = (EnumToString(value));
            }
        }

        /// <summary>
        /// Defaults to ctap2_0. Ignored if |protocol| == u2f.
        /// </summary>
        [DataMember(Name = ("ctap2Version"), IsRequired = (false))]
        internal string ctap2Version
        {
            get;
            set;
        }

        /// <summary>
        /// Transport
        /// </summary>
        public CefSharp.DevTools.WebAuthn.AuthenticatorTransport Transport
        {
            get
            {
                return (CefSharp.DevTools.WebAuthn.AuthenticatorTransport)(StringToEnum(typeof(CefSharp.DevTools.WebAuthn.AuthenticatorTransport), transport));
            }

            set
            {
                this.transport = (EnumToString(value));
            }
        }

        /// <summary>
        /// Transport
        /// </summary>
        [DataMember(Name = ("transport"), IsRequired = (true))]
        internal string transport
        {
            get;
            set;
        }

        /// <summary>
        /// Defaults to false.
        /// </summary>
        [DataMember(Name = ("hasResidentKey"), IsRequired = (false))]
        public bool? HasResidentKey
        {
            get;
            set;
        }

        /// <summary>
        /// Defaults to false.
        /// </summary>
        [DataMember(Name = ("hasUserVerification"), IsRequired = (false))]
        public bool? HasUserVerification
        {
            get;
            set;
        }

        /// <summary>
        /// If set to true, the authenticator will support the largeBlob extension.
        /// https://w3c.github.io/webauthn#largeBlob
        /// Defaults to false.
        /// </summary>
        [DataMember(Name = ("hasLargeBlob"), IsRequired = (false))]
        public bool? HasLargeBlob
        {
            get;
            set;
        }

        /// <summary>
        /// If set to true, the authenticator will support the credBlob extension.
        /// https://fidoalliance.org/specs/fido-v2.1-rd-20201208/fido-client-to-authenticator-protocol-v2.1-rd-20201208.html#sctn-credBlob-extension
        /// Defaults to false.
        /// </summary>
        [DataMember(Name = ("hasCredBlob"), IsRequired = (false))]
        public bool? HasCredBlob
        {
            get;
            set;
        }

        /// <summary>
        /// If set to true, the authenticator will support the minPinLength extension.
        /// https://fidoalliance.org/specs/fido-v2.1-ps-20210615/fido-client-to-authenticator-protocol-v2.1-ps-20210615.html#sctn-minpinlength-extension
        /// Defaults to false.
        /// </summary>
        [DataMember(Name = ("hasMinPinLength"), IsRequired = (false))]
        public bool? HasMinPinLength
        {
            get;
            set;
        }

        /// <summary>
        /// If set to true, the authenticator will support the prf extension.
        /// https://w3c.github.io/webauthn/#prf-extension
        /// Defaults to false.
        /// </summary>
        [DataMember(Name = ("hasPrf"), IsRequired = (false))]
        public bool? HasPrf
        {
            get;
            set;
        }

        /// <summary>
        /// If set to true, tests of user presence will succeed immediately.
        /// Otherwise, they will not be resolved. Defaults to true.
        /// </summary>
        [DataMember(Name = ("automaticPresenceSimulation"), IsRequired = (false))]
        public bool? AutomaticPresenceSimulation
        {
            get;
            set;
        }

        /// <summary>
        /// Sets whether User Verification succeeds or fails for an authenticator.
        /// Defaults to false.
        /// </summary>
        [DataMember(Name = ("isUserVerified"), IsRequired = (false))]
        public bool? IsUserVerified
        {
            get;
            set;
        }

        /// <summary>
        /// Credentials created by this authenticator will have the backup
        /// eligibility (BE) flag set to this value. Defaults to false.
        /// https://w3c.github.io/webauthn/#sctn-credential-backup
        /// </summary>
        [DataMember(Name = ("defaultBackupEligibility"), IsRequired = (false))]
        public bool? DefaultBackupEligibility
        {
            get;
            set;
        }

        /// <summary>
        /// Credentials created by this authenticator will have the backup state
        /// (BS) flag set to this value. Defaults to false.
        /// https://w3c.github.io/webauthn/#sctn-credential-backup
        /// </summary>
        [DataMember(Name = ("defaultBackupState"), IsRequired = (false))]
        public bool? DefaultBackupState
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Credential
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class Credential : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// CredentialId
        /// </summary>
        [DataMember(Name = ("credentialId"), IsRequired = (true))]
        public byte[] CredentialId
        {
            get;
            set;
        }

        /// <summary>
        /// IsResidentCredential
        /// </summary>
        [DataMember(Name = ("isResidentCredential"), IsRequired = (true))]
        public bool IsResidentCredential
        {
            get;
            set;
        }

        /// <summary>
        /// Relying Party ID the credential is scoped to. Must be set when adding a
        /// credential.
        /// </summary>
        [DataMember(Name = ("rpId"), IsRequired = (false))]
        public string RpId
        {
            get;
            set;
        }

        /// <summary>
        /// The ECDSA P-256 private key in PKCS#8 format.
        /// </summary>
        [DataMember(Name = ("privateKey"), IsRequired = (true))]
        public byte[] PrivateKey
        {
            get;
            set;
        }

        /// <summary>
        /// An opaque byte sequence with a maximum size of 64 bytes mapping the
        /// credential to a specific user.
        /// </summary>
        [DataMember(Name = ("userHandle"), IsRequired = (false))]
        public byte[] UserHandle
        {
            get;
            set;
        }

        /// <summary>
        /// Signature counter. This is incremented by one for each successful
        /// assertion.
        /// See https://w3c.github.io/webauthn/#signature-counter
        /// </summary>
        [DataMember(Name = ("signCount"), IsRequired = (true))]
        public int SignCount
        {
            get;
            set;
        }

        /// <summary>
        /// The large blob associated with the credential.
        /// See https://w3c.github.io/webauthn/#sctn-large-blob-extension
        /// </summary>
        [DataMember(Name = ("largeBlob"), IsRequired = (false))]
        public byte[] LargeBlob
        {
            get;
            set;
        }

        /// <summary>
        /// Assertions returned by this credential will have the backup eligibility
        /// (BE) flag set to this value. Defaults to the authenticator&apos;s
        /// defaultBackupEligibility value.
        /// </summary>
        [DataMember(Name = ("backupEligibility"), IsRequired = (false))]
        public bool? BackupEligibility
        {
            get;
            set;
        }

        /// <summary>
        /// Assertions returned by this credential will have the backup state (BS)
        /// flag set to this value. Defaults to the authenticator&apos;s
        /// defaultBackupState value.
        /// </summary>
        [DataMember(Name = ("backupState"), IsRequired = (false))]
        public bool? BackupState
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Triggered when a credential is added to an authenticator.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class CredentialAddedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// AuthenticatorId
        /// </summary>
        [DataMember(Name = ("authenticatorId"), IsRequired = (true))]
        public string AuthenticatorId
        {
            get;
            private set;
        }

        /// <summary>
        /// Credential
        /// </summary>
        [DataMember(Name = ("credential"), IsRequired = (true))]
        public CefSharp.DevTools.WebAuthn.Credential Credential
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Triggered when a credential is used in a webauthn assertion.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class CredentialAssertedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// AuthenticatorId
        /// </summary>
        [DataMember(Name = ("authenticatorId"), IsRequired = (true))]
        public string AuthenticatorId
        {
            get;
            private set;
        }

        /// <summary>
        /// Credential
        /// </summary>
        [DataMember(Name = ("credential"), IsRequired = (true))]
        public CefSharp.DevTools.WebAuthn.Credential Credential
        {
            get;
            private set;
        }
    }
}

namespace CefSharp.DevTools.Media
{
    /// <summary>
    /// Keep in sync with MediaLogMessageLevel
    /// We are currently keeping the message level &apos;error&apos; separate from the
    /// PlayerError type because right now they represent different things,
    /// this one being a DVLOG(ERROR) style log message that gets printed
    /// based on what log level is selected in the UI, and the other is a
    /// representation of a media::PipelineStatus object. Soon however we&apos;re
    /// going to be moving away from using PipelineStatus for errors and
    /// introducing a new error type which should hopefully let us integrate
    /// the error log level into the PlayerError type.
    /// </summary>
    public enum PlayerMessageLevel
    {
        /// <summary>
        /// error
        /// </summary>
        [EnumMember(Value = ("error"))]
        Error,
        /// <summary>
        /// warning
        /// </summary>
        [EnumMember(Value = ("warning"))]
        Warning,
        /// <summary>
        /// info
        /// </summary>
        [EnumMember(Value = ("info"))]
        Info,
        /// <summary>
        /// debug
        /// </summary>
        [EnumMember(Value = ("debug"))]
        Debug
    }

    /// <summary>
    /// Have one type per entry in MediaLogRecord::Type
    /// Corresponds to kMessage
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class PlayerMessage : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Keep in sync with MediaLogMessageLevel
        /// We are currently keeping the message level &apos;error&apos; separate from the
        /// PlayerError type because right now they represent different things,
        /// this one being a DVLOG(ERROR) style log message that gets printed
        /// based on what log level is selected in the UI, and the other is a
        /// representation of a media::PipelineStatus object. Soon however we&apos;re
        /// going to be moving away from using PipelineStatus for errors and
        /// introducing a new error type which should hopefully let us integrate
        /// the error log level into the PlayerError type.
        /// </summary>
        public CefSharp.DevTools.Media.PlayerMessageLevel Level
        {
            get
            {
                return (CefSharp.DevTools.Media.PlayerMessageLevel)(StringToEnum(typeof(CefSharp.DevTools.Media.PlayerMessageLevel), level));
            }

            set
            {
                this.level = (EnumToString(value));
            }
        }

        /// <summary>
        /// Keep in sync with MediaLogMessageLevel
        /// We are currently keeping the message level &apos;error&apos; separate from the
        /// PlayerError type because right now they represent different things,
        /// this one being a DVLOG(ERROR) style log message that gets printed
        /// based on what log level is selected in the UI, and the other is a
        /// representation of a media::PipelineStatus object. Soon however we&apos;re
        /// going to be moving away from using PipelineStatus for errors and
        /// introducing a new error type which should hopefully let us integrate
        /// the error log level into the PlayerError type.
        /// </summary>
        [DataMember(Name = ("level"), IsRequired = (true))]
        internal string level
        {
            get;
            set;
        }

        /// <summary>
        /// Message
        /// </summary>
        [DataMember(Name = ("message"), IsRequired = (true))]
        public string Message
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Corresponds to kMediaPropertyChange
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class PlayerProperty : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Name
        /// </summary>
        [DataMember(Name = ("name"), IsRequired = (true))]
        public string Name
        {
            get;
            set;
        }

        /// <summary>
        /// Value
        /// </summary>
        [DataMember(Name = ("value"), IsRequired = (true))]
        public string Value
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Corresponds to kMediaEventTriggered
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class PlayerEvent : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Timestamp
        /// </summary>
        [DataMember(Name = ("timestamp"), IsRequired = (true))]
        public double Timestamp
        {
            get;
            set;
        }

        /// <summary>
        /// Value
        /// </summary>
        [DataMember(Name = ("value"), IsRequired = (true))]
        public string Value
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Represents logged source line numbers reported in an error.
    /// NOTE: file and line are from chromium c++ implementation code, not js.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class PlayerErrorSourceLocation : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// File
        /// </summary>
        [DataMember(Name = ("file"), IsRequired = (true))]
        public string File
        {
            get;
            set;
        }

        /// <summary>
        /// Line
        /// </summary>
        [DataMember(Name = ("line"), IsRequired = (true))]
        public int Line
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Corresponds to kMediaError
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class PlayerError : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// ErrorType
        /// </summary>
        [DataMember(Name = ("errorType"), IsRequired = (true))]
        public string ErrorType
        {
            get;
            set;
        }

        /// <summary>
        /// Code is the numeric enum entry for a specific set of error codes, such
        /// as PipelineStatusCodes in media/base/pipeline_status.h
        /// </summary>
        [DataMember(Name = ("code"), IsRequired = (true))]
        public int Code
        {
            get;
            set;
        }

        /// <summary>
        /// A trace of where this error was caused / where it passed through.
        /// </summary>
        [DataMember(Name = ("stack"), IsRequired = (true))]
        public System.Collections.Generic.IList<CefSharp.DevTools.Media.PlayerErrorSourceLocation> Stack
        {
            get;
            set;
        }

        /// <summary>
        /// Errors potentially have a root cause error, ie, a DecoderError might be
        /// caused by an WindowsError
        /// </summary>
        [DataMember(Name = ("cause"), IsRequired = (true))]
        public System.Collections.Generic.IList<CefSharp.DevTools.Media.PlayerError> Cause
        {
            get;
            set;
        }

        /// <summary>
        /// Extra data attached to an error, such as an HRESULT, Video Codec, etc.
        /// </summary>
        [DataMember(Name = ("data"), IsRequired = (true))]
        public object Data
        {
            get;
            set;
        }
    }

    /// <summary>
    /// This can be called multiple times, and can be used to set / override /
    /// remove player properties. A null propValue indicates removal.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class PlayerPropertiesChangedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// PlayerId
        /// </summary>
        [DataMember(Name = ("playerId"), IsRequired = (true))]
        public string PlayerId
        {
            get;
            private set;
        }

        /// <summary>
        /// Properties
        /// </summary>
        [DataMember(Name = ("properties"), IsRequired = (true))]
        public System.Collections.Generic.IList<CefSharp.DevTools.Media.PlayerProperty> Properties
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Send events as a list, allowing them to be batched on the browser for less
    /// congestion. If batched, events must ALWAYS be in chronological order.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class PlayerEventsAddedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// PlayerId
        /// </summary>
        [DataMember(Name = ("playerId"), IsRequired = (true))]
        public string PlayerId
        {
            get;
            private set;
        }

        /// <summary>
        /// Events
        /// </summary>
        [DataMember(Name = ("events"), IsRequired = (true))]
        public System.Collections.Generic.IList<CefSharp.DevTools.Media.PlayerEvent> Events
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Send a list of any messages that need to be delivered.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class PlayerMessagesLoggedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// PlayerId
        /// </summary>
        [DataMember(Name = ("playerId"), IsRequired = (true))]
        public string PlayerId
        {
            get;
            private set;
        }

        /// <summary>
        /// Messages
        /// </summary>
        [DataMember(Name = ("messages"), IsRequired = (true))]
        public System.Collections.Generic.IList<CefSharp.DevTools.Media.PlayerMessage> Messages
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Send a list of any errors that need to be delivered.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class PlayerErrorsRaisedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// PlayerId
        /// </summary>
        [DataMember(Name = ("playerId"), IsRequired = (true))]
        public string PlayerId
        {
            get;
            private set;
        }

        /// <summary>
        /// Errors
        /// </summary>
        [DataMember(Name = ("errors"), IsRequired = (true))]
        public System.Collections.Generic.IList<CefSharp.DevTools.Media.PlayerError> Errors
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Called whenever a player is created, or when a new agent joins and receives
    /// a list of active players. If an agent is restored, it will receive the full
    /// list of player ids and all events again.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class PlayersCreatedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Players
        /// </summary>
        [DataMember(Name = ("players"), IsRequired = (true))]
        public string[] Players
        {
            get;
            private set;
        }
    }
}

namespace CefSharp.DevTools.DeviceAccess
{
    /// <summary>
    /// Device information displayed in a user prompt to select a device.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class PromptDevice : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Id
        /// </summary>
        [DataMember(Name = ("id"), IsRequired = (true))]
        public string Id
        {
            get;
            set;
        }

        /// <summary>
        /// Display name as it appears in a device request user prompt.
        /// </summary>
        [DataMember(Name = ("name"), IsRequired = (true))]
        public string Name
        {
            get;
            set;
        }
    }

    /// <summary>
    /// A device request opened a user prompt to select a device. Respond with the
    /// selectPrompt or cancelPrompt command.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class DeviceRequestPromptedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Id
        /// </summary>
        [DataMember(Name = ("id"), IsRequired = (true))]
        public string Id
        {
            get;
            private set;
        }

        /// <summary>
        /// Devices
        /// </summary>
        [DataMember(Name = ("devices"), IsRequired = (true))]
        public System.Collections.Generic.IList<CefSharp.DevTools.DeviceAccess.PromptDevice> Devices
        {
            get;
            private set;
        }
    }
}

namespace CefSharp.DevTools.Preload
{
    /// <summary>
    /// Corresponds to SpeculationRuleSet
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class RuleSet : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Id
        /// </summary>
        [DataMember(Name = ("id"), IsRequired = (true))]
        public string Id
        {
            get;
            set;
        }

        /// <summary>
        /// Identifies a document which the rule set is associated with.
        /// </summary>
        [DataMember(Name = ("loaderId"), IsRequired = (true))]
        public string LoaderId
        {
            get;
            set;
        }

        /// <summary>
        /// Source text of JSON representing the rule set. If it comes from
        /// `&lt;script&gt;` tag, it is the textContent of the node. Note that it is
        /// a JSON for valid case.
        /// 
        /// See also:
        /// - https://wicg.github.io/nav-speculation/speculation-rules.html
        /// - https://github.com/WICG/nav-speculation/blob/main/triggers.md
        /// </summary>
        [DataMember(Name = ("sourceText"), IsRequired = (true))]
        public string SourceText
        {
            get;
            set;
        }

        /// <summary>
        /// A speculation rule set is either added through an inline
        /// `&lt;script&gt;` tag or through an external resource via the
        /// &apos;Speculation-Rules&apos; HTTP header. For the first case, we include
        /// the BackendNodeId of the relevant `&lt;script&gt;` tag. For the second
        /// case, we include the external URL where the rule set was loaded
        /// from, and also RequestId if Network domain is enabled.
        /// 
        /// See also:
        /// - https://wicg.github.io/nav-speculation/speculation-rules.html#speculation-rules-script
        /// - https://wicg.github.io/nav-speculation/speculation-rules.html#speculation-rules-header
        /// </summary>
        [DataMember(Name = ("backendNodeId"), IsRequired = (false))]
        public int? BackendNodeId
        {
            get;
            set;
        }

        /// <summary>
        /// Url
        /// </summary>
        [DataMember(Name = ("url"), IsRequired = (false))]
        public string Url
        {
            get;
            set;
        }

        /// <summary>
        /// RequestId
        /// </summary>
        [DataMember(Name = ("requestId"), IsRequired = (false))]
        public string RequestId
        {
            get;
            set;
        }

        /// <summary>
        /// Error information
        /// `errorMessage` is null iff `errorType` is null.
        /// </summary>
        public CefSharp.DevTools.Preload.RuleSetErrorType? ErrorType
        {
            get
            {
                return (CefSharp.DevTools.Preload.RuleSetErrorType? )(StringToEnum(typeof(CefSharp.DevTools.Preload.RuleSetErrorType? ), errorType));
            }

            set
            {
                this.errorType = (EnumToString(value));
            }
        }

        /// <summary>
        /// Error information
        /// `errorMessage` is null iff `errorType` is null.
        /// </summary>
        [DataMember(Name = ("errorType"), IsRequired = (false))]
        internal string errorType
        {
            get;
            set;
        }

        /// <summary>
        /// TODO(https://crbug.com/1425354): Replace this property with structured error.
        /// </summary>
        [DataMember(Name = ("errorMessage"), IsRequired = (false))]
        public string ErrorMessage
        {
            get;
            set;
        }
    }

    /// <summary>
    /// RuleSetErrorType
    /// </summary>
    public enum RuleSetErrorType
    {
        /// <summary>
        /// SourceIsNotJsonObject
        /// </summary>
        [EnumMember(Value = ("SourceIsNotJsonObject"))]
        SourceIsNotJsonObject,
        /// <summary>
        /// InvalidRulesSkipped
        /// </summary>
        [EnumMember(Value = ("InvalidRulesSkipped"))]
        InvalidRulesSkipped
    }

    /// <summary>
    /// The type of preloading attempted. It corresponds to
    /// mojom::SpeculationAction (although PrefetchWithSubresources is omitted as it
    /// isn&apos;t being used by clients).
    /// </summary>
    public enum SpeculationAction
    {
        /// <summary>
        /// Prefetch
        /// </summary>
        [EnumMember(Value = ("Prefetch"))]
        Prefetch,
        /// <summary>
        /// Prerender
        /// </summary>
        [EnumMember(Value = ("Prerender"))]
        Prerender
    }

    /// <summary>
    /// Corresponds to mojom::SpeculationTargetHint.
    /// See https://github.com/WICG/nav-speculation/blob/main/triggers.md#window-name-targeting-hints
    /// </summary>
    public enum SpeculationTargetHint
    {
        /// <summary>
        /// Blank
        /// </summary>
        [EnumMember(Value = ("Blank"))]
        Blank,
        /// <summary>
        /// Self
        /// </summary>
        [EnumMember(Value = ("Self"))]
        Self
    }

    /// <summary>
    /// A key that identifies a preloading attempt.
    /// 
    /// The url used is the url specified by the trigger (i.e. the initial URL), and
    /// not the final url that is navigated to. For example, prerendering allows
    /// same-origin main frame navigations during the attempt, but the attempt is
    /// still keyed with the initial URL.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class PreloadingAttemptKey : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// LoaderId
        /// </summary>
        [DataMember(Name = ("loaderId"), IsRequired = (true))]
        public string LoaderId
        {
            get;
            set;
        }

        /// <summary>
        /// Action
        /// </summary>
        public CefSharp.DevTools.Preload.SpeculationAction Action
        {
            get
            {
                return (CefSharp.DevTools.Preload.SpeculationAction)(StringToEnum(typeof(CefSharp.DevTools.Preload.SpeculationAction), action));
            }

            set
            {
                this.action = (EnumToString(value));
            }
        }

        /// <summary>
        /// Action
        /// </summary>
        [DataMember(Name = ("action"), IsRequired = (true))]
        internal string action
        {
            get;
            set;
        }

        /// <summary>
        /// Url
        /// </summary>
        [DataMember(Name = ("url"), IsRequired = (true))]
        public string Url
        {
            get;
            set;
        }

        /// <summary>
        /// TargetHint
        /// </summary>
        public CefSharp.DevTools.Preload.SpeculationTargetHint? TargetHint
        {
            get
            {
                return (CefSharp.DevTools.Preload.SpeculationTargetHint? )(StringToEnum(typeof(CefSharp.DevTools.Preload.SpeculationTargetHint? ), targetHint));
            }

            set
            {
                this.targetHint = (EnumToString(value));
            }
        }

        /// <summary>
        /// TargetHint
        /// </summary>
        [DataMember(Name = ("targetHint"), IsRequired = (false))]
        internal string targetHint
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Lists sources for a preloading attempt, specifically the ids of rule sets
    /// that had a speculation rule that triggered the attempt, and the
    /// BackendNodeIds of &lt;a href&gt; or &lt;area href&gt; elements that triggered the
    /// attempt (in the case of attempts triggered by a document rule). It is
    /// possible for multiple rule sets and links to trigger a single attempt.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class PreloadingAttemptSource : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Key
        /// </summary>
        [DataMember(Name = ("key"), IsRequired = (true))]
        public CefSharp.DevTools.Preload.PreloadingAttemptKey Key
        {
            get;
            set;
        }

        /// <summary>
        /// RuleSetIds
        /// </summary>
        [DataMember(Name = ("ruleSetIds"), IsRequired = (true))]
        public string[] RuleSetIds
        {
            get;
            set;
        }

        /// <summary>
        /// NodeIds
        /// </summary>
        [DataMember(Name = ("nodeIds"), IsRequired = (true))]
        public int[] NodeIds
        {
            get;
            set;
        }
    }

    /// <summary>
    /// List of FinalStatus reasons for Prerender2.
    /// </summary>
    public enum PrerenderFinalStatus
    {
        /// <summary>
        /// Activated
        /// </summary>
        [EnumMember(Value = ("Activated"))]
        Activated,
        /// <summary>
        /// Destroyed
        /// </summary>
        [EnumMember(Value = ("Destroyed"))]
        Destroyed,
        /// <summary>
        /// LowEndDevice
        /// </summary>
        [EnumMember(Value = ("LowEndDevice"))]
        LowEndDevice,
        /// <summary>
        /// InvalidSchemeRedirect
        /// </summary>
        [EnumMember(Value = ("InvalidSchemeRedirect"))]
        InvalidSchemeRedirect,
        /// <summary>
        /// InvalidSchemeNavigation
        /// </summary>
        [EnumMember(Value = ("InvalidSchemeNavigation"))]
        InvalidSchemeNavigation,
        /// <summary>
        /// NavigationRequestBlockedByCsp
        /// </summary>
        [EnumMember(Value = ("NavigationRequestBlockedByCsp"))]
        NavigationRequestBlockedByCsp,
        /// <summary>
        /// MainFrameNavigation
        /// </summary>
        [EnumMember(Value = ("MainFrameNavigation"))]
        MainFrameNavigation,
        /// <summary>
        /// MojoBinderPolicy
        /// </summary>
        [EnumMember(Value = ("MojoBinderPolicy"))]
        MojoBinderPolicy,
        /// <summary>
        /// RendererProcessCrashed
        /// </summary>
        [EnumMember(Value = ("RendererProcessCrashed"))]
        RendererProcessCrashed,
        /// <summary>
        /// RendererProcessKilled
        /// </summary>
        [EnumMember(Value = ("RendererProcessKilled"))]
        RendererProcessKilled,
        /// <summary>
        /// Download
        /// </summary>
        [EnumMember(Value = ("Download"))]
        Download,
        /// <summary>
        /// TriggerDestroyed
        /// </summary>
        [EnumMember(Value = ("TriggerDestroyed"))]
        TriggerDestroyed,
        /// <summary>
        /// NavigationNotCommitted
        /// </summary>
        [EnumMember(Value = ("NavigationNotCommitted"))]
        NavigationNotCommitted,
        /// <summary>
        /// NavigationBadHttpStatus
        /// </summary>
        [EnumMember(Value = ("NavigationBadHttpStatus"))]
        NavigationBadHttpStatus,
        /// <summary>
        /// ClientCertRequested
        /// </summary>
        [EnumMember(Value = ("ClientCertRequested"))]
        ClientCertRequested,
        /// <summary>
        /// NavigationRequestNetworkError
        /// </summary>
        [EnumMember(Value = ("NavigationRequestNetworkError"))]
        NavigationRequestNetworkError,
        /// <summary>
        /// CancelAllHostsForTesting
        /// </summary>
        [EnumMember(Value = ("CancelAllHostsForTesting"))]
        CancelAllHostsForTesting,
        /// <summary>
        /// DidFailLoad
        /// </summary>
        [EnumMember(Value = ("DidFailLoad"))]
        DidFailLoad,
        /// <summary>
        /// Stop
        /// </summary>
        [EnumMember(Value = ("Stop"))]
        Stop,
        /// <summary>
        /// SslCertificateError
        /// </summary>
        [EnumMember(Value = ("SslCertificateError"))]
        SslCertificateError,
        /// <summary>
        /// LoginAuthRequested
        /// </summary>
        [EnumMember(Value = ("LoginAuthRequested"))]
        LoginAuthRequested,
        /// <summary>
        /// UaChangeRequiresReload
        /// </summary>
        [EnumMember(Value = ("UaChangeRequiresReload"))]
        UaChangeRequiresReload,
        /// <summary>
        /// BlockedByClient
        /// </summary>
        [EnumMember(Value = ("BlockedByClient"))]
        BlockedByClient,
        /// <summary>
        /// AudioOutputDeviceRequested
        /// </summary>
        [EnumMember(Value = ("AudioOutputDeviceRequested"))]
        AudioOutputDeviceRequested,
        /// <summary>
        /// MixedContent
        /// </summary>
        [EnumMember(Value = ("MixedContent"))]
        MixedContent,
        /// <summary>
        /// TriggerBackgrounded
        /// </summary>
        [EnumMember(Value = ("TriggerBackgrounded"))]
        TriggerBackgrounded,
        /// <summary>
        /// MemoryLimitExceeded
        /// </summary>
        [EnumMember(Value = ("MemoryLimitExceeded"))]
        MemoryLimitExceeded,
        /// <summary>
        /// DataSaverEnabled
        /// </summary>
        [EnumMember(Value = ("DataSaverEnabled"))]
        DataSaverEnabled,
        /// <summary>
        /// TriggerUrlHasEffectiveUrl
        /// </summary>
        [EnumMember(Value = ("TriggerUrlHasEffectiveUrl"))]
        TriggerUrlHasEffectiveUrl,
        /// <summary>
        /// ActivatedBeforeStarted
        /// </summary>
        [EnumMember(Value = ("ActivatedBeforeStarted"))]
        ActivatedBeforeStarted,
        /// <summary>
        /// InactivePageRestriction
        /// </summary>
        [EnumMember(Value = ("InactivePageRestriction"))]
        InactivePageRestriction,
        /// <summary>
        /// StartFailed
        /// </summary>
        [EnumMember(Value = ("StartFailed"))]
        StartFailed,
        /// <summary>
        /// TimeoutBackgrounded
        /// </summary>
        [EnumMember(Value = ("TimeoutBackgrounded"))]
        TimeoutBackgrounded,
        /// <summary>
        /// CrossSiteRedirectInInitialNavigation
        /// </summary>
        [EnumMember(Value = ("CrossSiteRedirectInInitialNavigation"))]
        CrossSiteRedirectInInitialNavigation,
        /// <summary>
        /// CrossSiteNavigationInInitialNavigation
        /// </summary>
        [EnumMember(Value = ("CrossSiteNavigationInInitialNavigation"))]
        CrossSiteNavigationInInitialNavigation,
        /// <summary>
        /// SameSiteCrossOriginRedirectNotOptInInInitialNavigation
        /// </summary>
        [EnumMember(Value = ("SameSiteCrossOriginRedirectNotOptInInInitialNavigation"))]
        SameSiteCrossOriginRedirectNotOptInInInitialNavigation,
        /// <summary>
        /// SameSiteCrossOriginNavigationNotOptInInInitialNavigation
        /// </summary>
        [EnumMember(Value = ("SameSiteCrossOriginNavigationNotOptInInInitialNavigation"))]
        SameSiteCrossOriginNavigationNotOptInInInitialNavigation,
        /// <summary>
        /// ActivationNavigationParameterMismatch
        /// </summary>
        [EnumMember(Value = ("ActivationNavigationParameterMismatch"))]
        ActivationNavigationParameterMismatch,
        /// <summary>
        /// ActivatedInBackground
        /// </summary>
        [EnumMember(Value = ("ActivatedInBackground"))]
        ActivatedInBackground,
        /// <summary>
        /// EmbedderHostDisallowed
        /// </summary>
        [EnumMember(Value = ("EmbedderHostDisallowed"))]
        EmbedderHostDisallowed,
        /// <summary>
        /// ActivationNavigationDestroyedBeforeSuccess
        /// </summary>
        [EnumMember(Value = ("ActivationNavigationDestroyedBeforeSuccess"))]
        ActivationNavigationDestroyedBeforeSuccess,
        /// <summary>
        /// TabClosedByUserGesture
        /// </summary>
        [EnumMember(Value = ("TabClosedByUserGesture"))]
        TabClosedByUserGesture,
        /// <summary>
        /// TabClosedWithoutUserGesture
        /// </summary>
        [EnumMember(Value = ("TabClosedWithoutUserGesture"))]
        TabClosedWithoutUserGesture,
        /// <summary>
        /// PrimaryMainFrameRendererProcessCrashed
        /// </summary>
        [EnumMember(Value = ("PrimaryMainFrameRendererProcessCrashed"))]
        PrimaryMainFrameRendererProcessCrashed,
        /// <summary>
        /// PrimaryMainFrameRendererProcessKilled
        /// </summary>
        [EnumMember(Value = ("PrimaryMainFrameRendererProcessKilled"))]
        PrimaryMainFrameRendererProcessKilled,
        /// <summary>
        /// ActivationFramePolicyNotCompatible
        /// </summary>
        [EnumMember(Value = ("ActivationFramePolicyNotCompatible"))]
        ActivationFramePolicyNotCompatible,
        /// <summary>
        /// PreloadingDisabled
        /// </summary>
        [EnumMember(Value = ("PreloadingDisabled"))]
        PreloadingDisabled,
        /// <summary>
        /// BatterySaverEnabled
        /// </summary>
        [EnumMember(Value = ("BatterySaverEnabled"))]
        BatterySaverEnabled,
        /// <summary>
        /// ActivatedDuringMainFrameNavigation
        /// </summary>
        [EnumMember(Value = ("ActivatedDuringMainFrameNavigation"))]
        ActivatedDuringMainFrameNavigation,
        /// <summary>
        /// PreloadingUnsupportedByWebContents
        /// </summary>
        [EnumMember(Value = ("PreloadingUnsupportedByWebContents"))]
        PreloadingUnsupportedByWebContents,
        /// <summary>
        /// CrossSiteRedirectInMainFrameNavigation
        /// </summary>
        [EnumMember(Value = ("CrossSiteRedirectInMainFrameNavigation"))]
        CrossSiteRedirectInMainFrameNavigation,
        /// <summary>
        /// CrossSiteNavigationInMainFrameNavigation
        /// </summary>
        [EnumMember(Value = ("CrossSiteNavigationInMainFrameNavigation"))]
        CrossSiteNavigationInMainFrameNavigation,
        /// <summary>
        /// SameSiteCrossOriginRedirectNotOptInInMainFrameNavigation
        /// </summary>
        [EnumMember(Value = ("SameSiteCrossOriginRedirectNotOptInInMainFrameNavigation"))]
        SameSiteCrossOriginRedirectNotOptInInMainFrameNavigation,
        /// <summary>
        /// SameSiteCrossOriginNavigationNotOptInInMainFrameNavigation
        /// </summary>
        [EnumMember(Value = ("SameSiteCrossOriginNavigationNotOptInInMainFrameNavigation"))]
        SameSiteCrossOriginNavigationNotOptInInMainFrameNavigation,
        /// <summary>
        /// MemoryPressureOnTrigger
        /// </summary>
        [EnumMember(Value = ("MemoryPressureOnTrigger"))]
        MemoryPressureOnTrigger,
        /// <summary>
        /// MemoryPressureAfterTriggered
        /// </summary>
        [EnumMember(Value = ("MemoryPressureAfterTriggered"))]
        MemoryPressureAfterTriggered,
        /// <summary>
        /// PrerenderingDisabledByDevTools
        /// </summary>
        [EnumMember(Value = ("PrerenderingDisabledByDevTools"))]
        PrerenderingDisabledByDevTools,
        /// <summary>
        /// SpeculationRuleRemoved
        /// </summary>
        [EnumMember(Value = ("SpeculationRuleRemoved"))]
        SpeculationRuleRemoved,
        /// <summary>
        /// ActivatedWithAuxiliaryBrowsingContexts
        /// </summary>
        [EnumMember(Value = ("ActivatedWithAuxiliaryBrowsingContexts"))]
        ActivatedWithAuxiliaryBrowsingContexts,
        /// <summary>
        /// MaxNumOfRunningEagerPrerendersExceeded
        /// </summary>
        [EnumMember(Value = ("MaxNumOfRunningEagerPrerendersExceeded"))]
        MaxNumOfRunningEagerPrerendersExceeded,
        /// <summary>
        /// MaxNumOfRunningNonEagerPrerendersExceeded
        /// </summary>
        [EnumMember(Value = ("MaxNumOfRunningNonEagerPrerendersExceeded"))]
        MaxNumOfRunningNonEagerPrerendersExceeded,
        /// <summary>
        /// MaxNumOfRunningEmbedderPrerendersExceeded
        /// </summary>
        [EnumMember(Value = ("MaxNumOfRunningEmbedderPrerendersExceeded"))]
        MaxNumOfRunningEmbedderPrerendersExceeded,
        /// <summary>
        /// PrerenderingUrlHasEffectiveUrl
        /// </summary>
        [EnumMember(Value = ("PrerenderingUrlHasEffectiveUrl"))]
        PrerenderingUrlHasEffectiveUrl,
        /// <summary>
        /// RedirectedPrerenderingUrlHasEffectiveUrl
        /// </summary>
        [EnumMember(Value = ("RedirectedPrerenderingUrlHasEffectiveUrl"))]
        RedirectedPrerenderingUrlHasEffectiveUrl,
        /// <summary>
        /// ActivationUrlHasEffectiveUrl
        /// </summary>
        [EnumMember(Value = ("ActivationUrlHasEffectiveUrl"))]
        ActivationUrlHasEffectiveUrl,
        /// <summary>
        /// JavaScriptInterfaceAdded
        /// </summary>
        [EnumMember(Value = ("JavaScriptInterfaceAdded"))]
        JavaScriptInterfaceAdded,
        /// <summary>
        /// JavaScriptInterfaceRemoved
        /// </summary>
        [EnumMember(Value = ("JavaScriptInterfaceRemoved"))]
        JavaScriptInterfaceRemoved,
        /// <summary>
        /// AllPrerenderingCanceled
        /// </summary>
        [EnumMember(Value = ("AllPrerenderingCanceled"))]
        AllPrerenderingCanceled,
        /// <summary>
        /// WindowClosed
        /// </summary>
        [EnumMember(Value = ("WindowClosed"))]
        WindowClosed,
        /// <summary>
        /// SlowNetwork
        /// </summary>
        [EnumMember(Value = ("SlowNetwork"))]
        SlowNetwork,
        /// <summary>
        /// OtherPrerenderedPageActivated
        /// </summary>
        [EnumMember(Value = ("OtherPrerenderedPageActivated"))]
        OtherPrerenderedPageActivated
    }

    /// <summary>
    /// Preloading status values, see also PreloadingTriggeringOutcome. This
    /// status is shared by prefetchStatusUpdated and prerenderStatusUpdated.
    /// </summary>
    public enum PreloadingStatus
    {
        /// <summary>
        /// Pending
        /// </summary>
        [EnumMember(Value = ("Pending"))]
        Pending,
        /// <summary>
        /// Running
        /// </summary>
        [EnumMember(Value = ("Running"))]
        Running,
        /// <summary>
        /// Ready
        /// </summary>
        [EnumMember(Value = ("Ready"))]
        Ready,
        /// <summary>
        /// Success
        /// </summary>
        [EnumMember(Value = ("Success"))]
        Success,
        /// <summary>
        /// Failure
        /// </summary>
        [EnumMember(Value = ("Failure"))]
        Failure,
        /// <summary>
        /// NotSupported
        /// </summary>
        [EnumMember(Value = ("NotSupported"))]
        NotSupported
    }

    /// <summary>
    /// TODO(https://crbug.com/1384419): revisit the list of PrefetchStatus and
    /// filter out the ones that aren&apos;t necessary to the developers.
    /// </summary>
    public enum PrefetchStatus
    {
        /// <summary>
        /// PrefetchAllowed
        /// </summary>
        [EnumMember(Value = ("PrefetchAllowed"))]
        PrefetchAllowed,
        /// <summary>
        /// PrefetchFailedIneligibleRedirect
        /// </summary>
        [EnumMember(Value = ("PrefetchFailedIneligibleRedirect"))]
        PrefetchFailedIneligibleRedirect,
        /// <summary>
        /// PrefetchFailedInvalidRedirect
        /// </summary>
        [EnumMember(Value = ("PrefetchFailedInvalidRedirect"))]
        PrefetchFailedInvalidRedirect,
        /// <summary>
        /// PrefetchFailedMIMENotSupported
        /// </summary>
        [EnumMember(Value = ("PrefetchFailedMIMENotSupported"))]
        PrefetchFailedMIMENotSupported,
        /// <summary>
        /// PrefetchFailedNetError
        /// </summary>
        [EnumMember(Value = ("PrefetchFailedNetError"))]
        PrefetchFailedNetError,
        /// <summary>
        /// PrefetchFailedNon2XX
        /// </summary>
        [EnumMember(Value = ("PrefetchFailedNon2XX"))]
        PrefetchFailedNon2XX,
        /// <summary>
        /// PrefetchFailedPerPageLimitExceeded
        /// </summary>
        [EnumMember(Value = ("PrefetchFailedPerPageLimitExceeded"))]
        PrefetchFailedPerPageLimitExceeded,
        /// <summary>
        /// PrefetchEvictedAfterCandidateRemoved
        /// </summary>
        [EnumMember(Value = ("PrefetchEvictedAfterCandidateRemoved"))]
        PrefetchEvictedAfterCandidateRemoved,
        /// <summary>
        /// PrefetchEvictedForNewerPrefetch
        /// </summary>
        [EnumMember(Value = ("PrefetchEvictedForNewerPrefetch"))]
        PrefetchEvictedForNewerPrefetch,
        /// <summary>
        /// PrefetchHeldback
        /// </summary>
        [EnumMember(Value = ("PrefetchHeldback"))]
        PrefetchHeldback,
        /// <summary>
        /// PrefetchIneligibleRetryAfter
        /// </summary>
        [EnumMember(Value = ("PrefetchIneligibleRetryAfter"))]
        PrefetchIneligibleRetryAfter,
        /// <summary>
        /// PrefetchIsPrivacyDecoy
        /// </summary>
        [EnumMember(Value = ("PrefetchIsPrivacyDecoy"))]
        PrefetchIsPrivacyDecoy,
        /// <summary>
        /// PrefetchIsStale
        /// </summary>
        [EnumMember(Value = ("PrefetchIsStale"))]
        PrefetchIsStale,
        /// <summary>
        /// PrefetchNotEligibleBrowserContextOffTheRecord
        /// </summary>
        [EnumMember(Value = ("PrefetchNotEligibleBrowserContextOffTheRecord"))]
        PrefetchNotEligibleBrowserContextOffTheRecord,
        /// <summary>
        /// PrefetchNotEligibleDataSaverEnabled
        /// </summary>
        [EnumMember(Value = ("PrefetchNotEligibleDataSaverEnabled"))]
        PrefetchNotEligibleDataSaverEnabled,
        /// <summary>
        /// PrefetchNotEligibleExistingProxy
        /// </summary>
        [EnumMember(Value = ("PrefetchNotEligibleExistingProxy"))]
        PrefetchNotEligibleExistingProxy,
        /// <summary>
        /// PrefetchNotEligibleHostIsNonUnique
        /// </summary>
        [EnumMember(Value = ("PrefetchNotEligibleHostIsNonUnique"))]
        PrefetchNotEligibleHostIsNonUnique,
        /// <summary>
        /// PrefetchNotEligibleNonDefaultStoragePartition
        /// </summary>
        [EnumMember(Value = ("PrefetchNotEligibleNonDefaultStoragePartition"))]
        PrefetchNotEligibleNonDefaultStoragePartition,
        /// <summary>
        /// PrefetchNotEligibleSameSiteCrossOriginPrefetchRequiredProxy
        /// </summary>
        [EnumMember(Value = ("PrefetchNotEligibleSameSiteCrossOriginPrefetchRequiredProxy"))]
        PrefetchNotEligibleSameSiteCrossOriginPrefetchRequiredProxy,
        /// <summary>
        /// PrefetchNotEligibleSchemeIsNotHttps
        /// </summary>
        [EnumMember(Value = ("PrefetchNotEligibleSchemeIsNotHttps"))]
        PrefetchNotEligibleSchemeIsNotHttps,
        /// <summary>
        /// PrefetchNotEligibleUserHasCookies
        /// </summary>
        [EnumMember(Value = ("PrefetchNotEligibleUserHasCookies"))]
        PrefetchNotEligibleUserHasCookies,
        /// <summary>
        /// PrefetchNotEligibleUserHasServiceWorker
        /// </summary>
        [EnumMember(Value = ("PrefetchNotEligibleUserHasServiceWorker"))]
        PrefetchNotEligibleUserHasServiceWorker,
        /// <summary>
        /// PrefetchNotEligibleBatterySaverEnabled
        /// </summary>
        [EnumMember(Value = ("PrefetchNotEligibleBatterySaverEnabled"))]
        PrefetchNotEligibleBatterySaverEnabled,
        /// <summary>
        /// PrefetchNotEligiblePreloadingDisabled
        /// </summary>
        [EnumMember(Value = ("PrefetchNotEligiblePreloadingDisabled"))]
        PrefetchNotEligiblePreloadingDisabled,
        /// <summary>
        /// PrefetchNotFinishedInTime
        /// </summary>
        [EnumMember(Value = ("PrefetchNotFinishedInTime"))]
        PrefetchNotFinishedInTime,
        /// <summary>
        /// PrefetchNotStarted
        /// </summary>
        [EnumMember(Value = ("PrefetchNotStarted"))]
        PrefetchNotStarted,
        /// <summary>
        /// PrefetchNotUsedCookiesChanged
        /// </summary>
        [EnumMember(Value = ("PrefetchNotUsedCookiesChanged"))]
        PrefetchNotUsedCookiesChanged,
        /// <summary>
        /// PrefetchProxyNotAvailable
        /// </summary>
        [EnumMember(Value = ("PrefetchProxyNotAvailable"))]
        PrefetchProxyNotAvailable,
        /// <summary>
        /// PrefetchResponseUsed
        /// </summary>
        [EnumMember(Value = ("PrefetchResponseUsed"))]
        PrefetchResponseUsed,
        /// <summary>
        /// PrefetchSuccessfulButNotUsed
        /// </summary>
        [EnumMember(Value = ("PrefetchSuccessfulButNotUsed"))]
        PrefetchSuccessfulButNotUsed,
        /// <summary>
        /// PrefetchNotUsedProbeFailed
        /// </summary>
        [EnumMember(Value = ("PrefetchNotUsedProbeFailed"))]
        PrefetchNotUsedProbeFailed
    }

    /// <summary>
    /// Information of headers to be displayed when the header mismatch occurred.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class PrerenderMismatchedHeaders : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// HeaderName
        /// </summary>
        [DataMember(Name = ("headerName"), IsRequired = (true))]
        public string HeaderName
        {
            get;
            set;
        }

        /// <summary>
        /// InitialValue
        /// </summary>
        [DataMember(Name = ("initialValue"), IsRequired = (false))]
        public string InitialValue
        {
            get;
            set;
        }

        /// <summary>
        /// ActivationValue
        /// </summary>
        [DataMember(Name = ("activationValue"), IsRequired = (false))]
        public string ActivationValue
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Upsert. Currently, it is only emitted when a rule set added.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class RuleSetUpdatedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// RuleSet
        /// </summary>
        [DataMember(Name = ("ruleSet"), IsRequired = (true))]
        public CefSharp.DevTools.Preload.RuleSet RuleSet
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// ruleSetRemoved
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class RuleSetRemovedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Id
        /// </summary>
        [DataMember(Name = ("id"), IsRequired = (true))]
        public string Id
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired when a preload enabled state is updated.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class PreloadEnabledStateUpdatedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// DisabledByPreference
        /// </summary>
        [DataMember(Name = ("disabledByPreference"), IsRequired = (true))]
        public bool DisabledByPreference
        {
            get;
            private set;
        }

        /// <summary>
        /// DisabledByDataSaver
        /// </summary>
        [DataMember(Name = ("disabledByDataSaver"), IsRequired = (true))]
        public bool DisabledByDataSaver
        {
            get;
            private set;
        }

        /// <summary>
        /// DisabledByBatterySaver
        /// </summary>
        [DataMember(Name = ("disabledByBatterySaver"), IsRequired = (true))]
        public bool DisabledByBatterySaver
        {
            get;
            private set;
        }

        /// <summary>
        /// DisabledByHoldbackPrefetchSpeculationRules
        /// </summary>
        [DataMember(Name = ("disabledByHoldbackPrefetchSpeculationRules"), IsRequired = (true))]
        public bool DisabledByHoldbackPrefetchSpeculationRules
        {
            get;
            private set;
        }

        /// <summary>
        /// DisabledByHoldbackPrerenderSpeculationRules
        /// </summary>
        [DataMember(Name = ("disabledByHoldbackPrerenderSpeculationRules"), IsRequired = (true))]
        public bool DisabledByHoldbackPrerenderSpeculationRules
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired when a prefetch attempt is updated.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class PrefetchStatusUpdatedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Key
        /// </summary>
        [DataMember(Name = ("key"), IsRequired = (true))]
        public CefSharp.DevTools.Preload.PreloadingAttemptKey Key
        {
            get;
            private set;
        }

        /// <summary>
        /// The frame id of the frame initiating prefetch.
        /// </summary>
        [DataMember(Name = ("initiatingFrameId"), IsRequired = (true))]
        public string InitiatingFrameId
        {
            get;
            private set;
        }

        /// <summary>
        /// PrefetchUrl
        /// </summary>
        [DataMember(Name = ("prefetchUrl"), IsRequired = (true))]
        public string PrefetchUrl
        {
            get;
            private set;
        }

        /// <summary>
        /// Status
        /// </summary>
        public CefSharp.DevTools.Preload.PreloadingStatus Status
        {
            get
            {
                return (CefSharp.DevTools.Preload.PreloadingStatus)(StringToEnum(typeof(CefSharp.DevTools.Preload.PreloadingStatus), status));
            }

            set
            {
                this.status = (EnumToString(value));
            }
        }

        /// <summary>
        /// Status
        /// </summary>
        [DataMember(Name = ("status"), IsRequired = (true))]
        internal string status
        {
            get;
            private set;
        }

        /// <summary>
        /// PrefetchStatus
        /// </summary>
        public CefSharp.DevTools.Preload.PrefetchStatus PrefetchStatus
        {
            get
            {
                return (CefSharp.DevTools.Preload.PrefetchStatus)(StringToEnum(typeof(CefSharp.DevTools.Preload.PrefetchStatus), prefetchStatus));
            }

            set
            {
                this.prefetchStatus = (EnumToString(value));
            }
        }

        /// <summary>
        /// PrefetchStatus
        /// </summary>
        [DataMember(Name = ("prefetchStatus"), IsRequired = (true))]
        internal string prefetchStatus
        {
            get;
            private set;
        }

        /// <summary>
        /// RequestId
        /// </summary>
        [DataMember(Name = ("requestId"), IsRequired = (true))]
        public string RequestId
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired when a prerender attempt is updated.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class PrerenderStatusUpdatedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Key
        /// </summary>
        [DataMember(Name = ("key"), IsRequired = (true))]
        public CefSharp.DevTools.Preload.PreloadingAttemptKey Key
        {
            get;
            private set;
        }

        /// <summary>
        /// Status
        /// </summary>
        public CefSharp.DevTools.Preload.PreloadingStatus Status
        {
            get
            {
                return (CefSharp.DevTools.Preload.PreloadingStatus)(StringToEnum(typeof(CefSharp.DevTools.Preload.PreloadingStatus), status));
            }

            set
            {
                this.status = (EnumToString(value));
            }
        }

        /// <summary>
        /// Status
        /// </summary>
        [DataMember(Name = ("status"), IsRequired = (true))]
        internal string status
        {
            get;
            private set;
        }

        /// <summary>
        /// PrerenderStatus
        /// </summary>
        public CefSharp.DevTools.Preload.PrerenderFinalStatus? PrerenderStatus
        {
            get
            {
                return (CefSharp.DevTools.Preload.PrerenderFinalStatus? )(StringToEnum(typeof(CefSharp.DevTools.Preload.PrerenderFinalStatus? ), prerenderStatus));
            }

            set
            {
                this.prerenderStatus = (EnumToString(value));
            }
        }

        /// <summary>
        /// PrerenderStatus
        /// </summary>
        [DataMember(Name = ("prerenderStatus"), IsRequired = (false))]
        internal string prerenderStatus
        {
            get;
            private set;
        }

        /// <summary>
        /// This is used to give users more information about the name of Mojo interface
        /// that is incompatible with prerender and has caused the cancellation of the attempt.
        /// </summary>
        [DataMember(Name = ("disallowedMojoInterface"), IsRequired = (false))]
        public string DisallowedMojoInterface
        {
            get;
            private set;
        }

        /// <summary>
        /// MismatchedHeaders
        /// </summary>
        [DataMember(Name = ("mismatchedHeaders"), IsRequired = (false))]
        public System.Collections.Generic.IList<CefSharp.DevTools.Preload.PrerenderMismatchedHeaders> MismatchedHeaders
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Send a list of sources for all preloading attempts in a document.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class PreloadingAttemptSourcesUpdatedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// LoaderId
        /// </summary>
        [DataMember(Name = ("loaderId"), IsRequired = (true))]
        public string LoaderId
        {
            get;
            private set;
        }

        /// <summary>
        /// PreloadingAttemptSources
        /// </summary>
        [DataMember(Name = ("preloadingAttemptSources"), IsRequired = (true))]
        public System.Collections.Generic.IList<CefSharp.DevTools.Preload.PreloadingAttemptSource> PreloadingAttemptSources
        {
            get;
            private set;
        }
    }
}

namespace CefSharp.DevTools.FedCm
{
    /// <summary>
    /// Whether this is a sign-up or sign-in action for this account, i.e.
    /// whether this account has ever been used to sign in to this RP before.
    /// </summary>
    public enum LoginState
    {
        /// <summary>
        /// SignIn
        /// </summary>
        [EnumMember(Value = ("SignIn"))]
        SignIn,
        /// <summary>
        /// SignUp
        /// </summary>
        [EnumMember(Value = ("SignUp"))]
        SignUp
    }

    /// <summary>
    /// The types of FedCM dialogs.
    /// </summary>
    public enum DialogType
    {
        /// <summary>
        /// AccountChooser
        /// </summary>
        [EnumMember(Value = ("AccountChooser"))]
        AccountChooser,
        /// <summary>
        /// AutoReauthn
        /// </summary>
        [EnumMember(Value = ("AutoReauthn"))]
        AutoReauthn,
        /// <summary>
        /// ConfirmIdpLogin
        /// </summary>
        [EnumMember(Value = ("ConfirmIdpLogin"))]
        ConfirmIdpLogin,
        /// <summary>
        /// Error
        /// </summary>
        [EnumMember(Value = ("Error"))]
        Error
    }

    /// <summary>
    /// The buttons on the FedCM dialog.
    /// </summary>
    public enum DialogButton
    {
        /// <summary>
        /// ConfirmIdpLoginContinue
        /// </summary>
        [EnumMember(Value = ("ConfirmIdpLoginContinue"))]
        ConfirmIdpLoginContinue,
        /// <summary>
        /// ErrorGotIt
        /// </summary>
        [EnumMember(Value = ("ErrorGotIt"))]
        ErrorGotIt,
        /// <summary>
        /// ErrorMoreDetails
        /// </summary>
        [EnumMember(Value = ("ErrorMoreDetails"))]
        ErrorMoreDetails
    }

    /// <summary>
    /// The URLs that each account has
    /// </summary>
    public enum AccountUrlType
    {
        /// <summary>
        /// TermsOfService
        /// </summary>
        [EnumMember(Value = ("TermsOfService"))]
        TermsOfService,
        /// <summary>
        /// PrivacyPolicy
        /// </summary>
        [EnumMember(Value = ("PrivacyPolicy"))]
        PrivacyPolicy
    }

    /// <summary>
    /// Corresponds to IdentityRequestAccount
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class Account : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// AccountId
        /// </summary>
        [DataMember(Name = ("accountId"), IsRequired = (true))]
        public string AccountId
        {
            get;
            set;
        }

        /// <summary>
        /// Email
        /// </summary>
        [DataMember(Name = ("email"), IsRequired = (true))]
        public string Email
        {
            get;
            set;
        }

        /// <summary>
        /// Name
        /// </summary>
        [DataMember(Name = ("name"), IsRequired = (true))]
        public string Name
        {
            get;
            set;
        }

        /// <summary>
        /// GivenName
        /// </summary>
        [DataMember(Name = ("givenName"), IsRequired = (true))]
        public string GivenName
        {
            get;
            set;
        }

        /// <summary>
        /// PictureUrl
        /// </summary>
        [DataMember(Name = ("pictureUrl"), IsRequired = (true))]
        public string PictureUrl
        {
            get;
            set;
        }

        /// <summary>
        /// IdpConfigUrl
        /// </summary>
        [DataMember(Name = ("idpConfigUrl"), IsRequired = (true))]
        public string IdpConfigUrl
        {
            get;
            set;
        }

        /// <summary>
        /// IdpLoginUrl
        /// </summary>
        [DataMember(Name = ("idpLoginUrl"), IsRequired = (true))]
        public string IdpLoginUrl
        {
            get;
            set;
        }

        /// <summary>
        /// LoginState
        /// </summary>
        public CefSharp.DevTools.FedCm.LoginState LoginState
        {
            get
            {
                return (CefSharp.DevTools.FedCm.LoginState)(StringToEnum(typeof(CefSharp.DevTools.FedCm.LoginState), loginState));
            }

            set
            {
                this.loginState = (EnumToString(value));
            }
        }

        /// <summary>
        /// LoginState
        /// </summary>
        [DataMember(Name = ("loginState"), IsRequired = (true))]
        internal string loginState
        {
            get;
            set;
        }

        /// <summary>
        /// These two are only set if the loginState is signUp
        /// </summary>
        [DataMember(Name = ("termsOfServiceUrl"), IsRequired = (false))]
        public string TermsOfServiceUrl
        {
            get;
            set;
        }

        /// <summary>
        /// PrivacyPolicyUrl
        /// </summary>
        [DataMember(Name = ("privacyPolicyUrl"), IsRequired = (false))]
        public string PrivacyPolicyUrl
        {
            get;
            set;
        }
    }

    /// <summary>
    /// dialogShown
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class DialogShownEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// DialogId
        /// </summary>
        [DataMember(Name = ("dialogId"), IsRequired = (true))]
        public string DialogId
        {
            get;
            private set;
        }

        /// <summary>
        /// DialogType
        /// </summary>
        public CefSharp.DevTools.FedCm.DialogType DialogType
        {
            get
            {
                return (CefSharp.DevTools.FedCm.DialogType)(StringToEnum(typeof(CefSharp.DevTools.FedCm.DialogType), dialogType));
            }

            set
            {
                this.dialogType = (EnumToString(value));
            }
        }

        /// <summary>
        /// DialogType
        /// </summary>
        [DataMember(Name = ("dialogType"), IsRequired = (true))]
        internal string dialogType
        {
            get;
            private set;
        }

        /// <summary>
        /// Accounts
        /// </summary>
        [DataMember(Name = ("accounts"), IsRequired = (true))]
        public System.Collections.Generic.IList<CefSharp.DevTools.FedCm.Account> Accounts
        {
            get;
            private set;
        }

        /// <summary>
        /// These exist primarily so that the caller can verify the
        /// RP context was used appropriately.
        /// </summary>
        [DataMember(Name = ("title"), IsRequired = (true))]
        public string Title
        {
            get;
            private set;
        }

        /// <summary>
        /// Subtitle
        /// </summary>
        [DataMember(Name = ("subtitle"), IsRequired = (false))]
        public string Subtitle
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Triggered when a dialog is closed, either by user action, JS abort,
    /// or a command below.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class DialogClosedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// DialogId
        /// </summary>
        [DataMember(Name = ("dialogId"), IsRequired = (true))]
        public string DialogId
        {
            get;
            private set;
        }
    }
}

namespace CefSharp.DevTools.PWA
{
    /// <summary>
    /// The following types are the replica of
    /// https://crsrc.org/c/chrome/browser/web_applications/proto/web_app_os_integration_state.proto;drc=9910d3be894c8f142c977ba1023f30a656bc13fc;l=67
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class FileHandlerAccept : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// New name of the mimetype according to
        /// https://www.iana.org/assignments/media-types/media-types.xhtml
        /// </summary>
        [DataMember(Name = ("mediaType"), IsRequired = (true))]
        public string MediaType
        {
            get;
            set;
        }

        /// <summary>
        /// FileExtensions
        /// </summary>
        [DataMember(Name = ("fileExtensions"), IsRequired = (true))]
        public string[] FileExtensions
        {
            get;
            set;
        }
    }

    /// <summary>
    /// FileHandler
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class FileHandler : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Action
        /// </summary>
        [DataMember(Name = ("action"), IsRequired = (true))]
        public string Action
        {
            get;
            set;
        }

        /// <summary>
        /// Accepts
        /// </summary>
        [DataMember(Name = ("accepts"), IsRequired = (true))]
        public System.Collections.Generic.IList<CefSharp.DevTools.PWA.FileHandlerAccept> Accepts
        {
            get;
            set;
        }

        /// <summary>
        /// DisplayName
        /// </summary>
        [DataMember(Name = ("displayName"), IsRequired = (true))]
        public string DisplayName
        {
            get;
            set;
        }
    }

    /// <summary>
    /// If user prefers opening the app in browser or an app window.
    /// </summary>
    public enum DisplayMode
    {
        /// <summary>
        /// standalone
        /// </summary>
        [EnumMember(Value = ("standalone"))]
        Standalone,
        /// <summary>
        /// browser
        /// </summary>
        [EnumMember(Value = ("browser"))]
        Browser
    }
}

namespace CefSharp.DevTools.BluetoothEmulation
{
    /// <summary>
    /// Indicates the various states of Central.
    /// </summary>
    public enum CentralState
    {
        /// <summary>
        /// absent
        /// </summary>
        [EnumMember(Value = ("absent"))]
        Absent,
        /// <summary>
        /// powered-off
        /// </summary>
        [EnumMember(Value = ("powered-off"))]
        PoweredOff,
        /// <summary>
        /// powered-on
        /// </summary>
        [EnumMember(Value = ("powered-on"))]
        PoweredOn
    }

    /// <summary>
    /// Stores the manufacturer data
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class ManufacturerData : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Company identifier
        /// https://bitbucket.org/bluetooth-SIG/public/src/main/assigned_numbers/company_identifiers/company_identifiers.yaml
        /// https://usb.org/developers
        /// </summary>
        [DataMember(Name = ("key"), IsRequired = (true))]
        public int Key
        {
            get;
            set;
        }

        /// <summary>
        /// Manufacturer-specific data
        /// </summary>
        [DataMember(Name = ("data"), IsRequired = (true))]
        public byte[] Data
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Stores the byte data of the advertisement packet sent by a Bluetooth device.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class ScanRecord : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Name
        /// </summary>
        [DataMember(Name = ("name"), IsRequired = (false))]
        public string Name
        {
            get;
            set;
        }

        /// <summary>
        /// Uuids
        /// </summary>
        [DataMember(Name = ("uuids"), IsRequired = (false))]
        public string[] Uuids
        {
            get;
            set;
        }

        /// <summary>
        /// Stores the external appearance description of the device.
        /// </summary>
        [DataMember(Name = ("appearance"), IsRequired = (false))]
        public int? Appearance
        {
            get;
            set;
        }

        /// <summary>
        /// Stores the transmission power of a broadcasting device.
        /// </summary>
        [DataMember(Name = ("txPower"), IsRequired = (false))]
        public int? TxPower
        {
            get;
            set;
        }

        /// <summary>
        /// Key is the company identifier and the value is an array of bytes of
        /// manufacturer specific data.
        /// </summary>
        [DataMember(Name = ("manufacturerData"), IsRequired = (false))]
        public System.Collections.Generic.IList<CefSharp.DevTools.BluetoothEmulation.ManufacturerData> ManufacturerData
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Stores the advertisement packet information that is sent by a Bluetooth device.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class ScanEntry : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// DeviceAddress
        /// </summary>
        [DataMember(Name = ("deviceAddress"), IsRequired = (true))]
        public string DeviceAddress
        {
            get;
            set;
        }

        /// <summary>
        /// Rssi
        /// </summary>
        [DataMember(Name = ("rssi"), IsRequired = (true))]
        public int Rssi
        {
            get;
            set;
        }

        /// <summary>
        /// ScanRecord
        /// </summary>
        [DataMember(Name = ("scanRecord"), IsRequired = (true))]
        public CefSharp.DevTools.BluetoothEmulation.ScanRecord ScanRecord
        {
            get;
            set;
        }
    }
}

namespace CefSharp.DevTools.Debugger
{
    /// <summary>
    /// Location in the source code.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class Location : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Script identifier as reported in the `Debugger.scriptParsed`.
        /// </summary>
        [DataMember(Name = ("scriptId"), IsRequired = (true))]
        public string ScriptId
        {
            get;
            set;
        }

        /// <summary>
        /// Line number in the script (0-based).
        /// </summary>
        [DataMember(Name = ("lineNumber"), IsRequired = (true))]
        public int LineNumber
        {
            get;
            set;
        }

        /// <summary>
        /// Column number in the script (0-based).
        /// </summary>
        [DataMember(Name = ("columnNumber"), IsRequired = (false))]
        public int? ColumnNumber
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Location in the source code.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class ScriptPosition : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// LineNumber
        /// </summary>
        [DataMember(Name = ("lineNumber"), IsRequired = (true))]
        public int LineNumber
        {
            get;
            set;
        }

        /// <summary>
        /// ColumnNumber
        /// </summary>
        [DataMember(Name = ("columnNumber"), IsRequired = (true))]
        public int ColumnNumber
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Location range within one script.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class LocationRange : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// ScriptId
        /// </summary>
        [DataMember(Name = ("scriptId"), IsRequired = (true))]
        public string ScriptId
        {
            get;
            set;
        }

        /// <summary>
        /// Start
        /// </summary>
        [DataMember(Name = ("start"), IsRequired = (true))]
        public CefSharp.DevTools.Debugger.ScriptPosition Start
        {
            get;
            set;
        }

        /// <summary>
        /// End
        /// </summary>
        [DataMember(Name = ("end"), IsRequired = (true))]
        public CefSharp.DevTools.Debugger.ScriptPosition End
        {
            get;
            set;
        }
    }

    /// <summary>
    /// JavaScript call frame. Array of call frames form the call stack.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class CallFrame : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Call frame identifier. This identifier is only valid while the virtual machine is paused.
        /// </summary>
        [DataMember(Name = ("callFrameId"), IsRequired = (true))]
        public string CallFrameId
        {
            get;
            set;
        }

        /// <summary>
        /// Name of the JavaScript function called on this call frame.
        /// </summary>
        [DataMember(Name = ("functionName"), IsRequired = (true))]
        public string FunctionName
        {
            get;
            set;
        }

        /// <summary>
        /// Location in the source code.
        /// </summary>
        [DataMember(Name = ("functionLocation"), IsRequired = (false))]
        public CefSharp.DevTools.Debugger.Location FunctionLocation
        {
            get;
            set;
        }

        /// <summary>
        /// Location in the source code.
        /// </summary>
        [DataMember(Name = ("location"), IsRequired = (true))]
        public CefSharp.DevTools.Debugger.Location Location
        {
            get;
            set;
        }

        /// <summary>
        /// JavaScript script name or url.
        /// Deprecated in favor of using the `location.scriptId` to resolve the URL via a previously
        /// sent `Debugger.scriptParsed` event.
        /// </summary>
        [DataMember(Name = ("url"), IsRequired = (true))]
        public string Url
        {
            get;
            set;
        }

        /// <summary>
        /// Scope chain for this call frame.
        /// </summary>
        [DataMember(Name = ("scopeChain"), IsRequired = (true))]
        public System.Collections.Generic.IList<CefSharp.DevTools.Debugger.Scope> ScopeChain
        {
            get;
            set;
        }

        /// <summary>
        /// `this` object for this call frame.
        /// </summary>
        [DataMember(Name = ("this"), IsRequired = (true))]
        public CefSharp.DevTools.Runtime.RemoteObject This
        {
            get;
            set;
        }

        /// <summary>
        /// The value being returned, if the function is at return point.
        /// </summary>
        [DataMember(Name = ("returnValue"), IsRequired = (false))]
        public CefSharp.DevTools.Runtime.RemoteObject ReturnValue
        {
            get;
            set;
        }

        /// <summary>
        /// Valid only while the VM is paused and indicates whether this frame
        /// can be restarted or not. Note that a `true` value here does not
        /// guarantee that Debugger#restartFrame with this CallFrameId will be
        /// successful, but it is very likely.
        /// </summary>
        [DataMember(Name = ("canBeRestarted"), IsRequired = (false))]
        public bool? CanBeRestarted
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Scope type.
    /// </summary>
    public enum ScopeType
    {
        /// <summary>
        /// global
        /// </summary>
        [EnumMember(Value = ("global"))]
        Global,
        /// <summary>
        /// local
        /// </summary>
        [EnumMember(Value = ("local"))]
        Local,
        /// <summary>
        /// with
        /// </summary>
        [EnumMember(Value = ("with"))]
        With,
        /// <summary>
        /// closure
        /// </summary>
        [EnumMember(Value = ("closure"))]
        Closure,
        /// <summary>
        /// catch
        /// </summary>
        [EnumMember(Value = ("catch"))]
        Catch,
        /// <summary>
        /// block
        /// </summary>
        [EnumMember(Value = ("block"))]
        Block,
        /// <summary>
        /// script
        /// </summary>
        [EnumMember(Value = ("script"))]
        Script,
        /// <summary>
        /// eval
        /// </summary>
        [EnumMember(Value = ("eval"))]
        Eval,
        /// <summary>
        /// module
        /// </summary>
        [EnumMember(Value = ("module"))]
        Module,
        /// <summary>
        /// wasm-expression-stack
        /// </summary>
        [EnumMember(Value = ("wasm-expression-stack"))]
        WasmExpressionStack
    }

    /// <summary>
    /// Scope description.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class Scope : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Scope type.
        /// </summary>
        public CefSharp.DevTools.Debugger.ScopeType Type
        {
            get
            {
                return (CefSharp.DevTools.Debugger.ScopeType)(StringToEnum(typeof(CefSharp.DevTools.Debugger.ScopeType), type));
            }

            set
            {
                this.type = (EnumToString(value));
            }
        }

        /// <summary>
        /// Scope type.
        /// </summary>
        [DataMember(Name = ("type"), IsRequired = (true))]
        internal string type
        {
            get;
            set;
        }

        /// <summary>
        /// Object representing the scope. For `global` and `with` scopes it represents the actual
        /// object; for the rest of the scopes, it is artificial transient object enumerating scope
        /// variables as its properties.
        /// </summary>
        [DataMember(Name = ("object"), IsRequired = (true))]
        public CefSharp.DevTools.Runtime.RemoteObject Object
        {
            get;
            set;
        }

        /// <summary>
        /// Name
        /// </summary>
        [DataMember(Name = ("name"), IsRequired = (false))]
        public string Name
        {
            get;
            set;
        }

        /// <summary>
        /// Location in the source code where scope starts
        /// </summary>
        [DataMember(Name = ("startLocation"), IsRequired = (false))]
        public CefSharp.DevTools.Debugger.Location StartLocation
        {
            get;
            set;
        }

        /// <summary>
        /// Location in the source code where scope ends
        /// </summary>
        [DataMember(Name = ("endLocation"), IsRequired = (false))]
        public CefSharp.DevTools.Debugger.Location EndLocation
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Search match for resource.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class SearchMatch : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Line number in resource content.
        /// </summary>
        [DataMember(Name = ("lineNumber"), IsRequired = (true))]
        public double LineNumber
        {
            get;
            set;
        }

        /// <summary>
        /// Line with match content.
        /// </summary>
        [DataMember(Name = ("lineContent"), IsRequired = (true))]
        public string LineContent
        {
            get;
            set;
        }
    }

    /// <summary>
    /// BreakLocationType
    /// </summary>
    public enum BreakLocationType
    {
        /// <summary>
        /// debuggerStatement
        /// </summary>
        [EnumMember(Value = ("debuggerStatement"))]
        DebuggerStatement,
        /// <summary>
        /// call
        /// </summary>
        [EnumMember(Value = ("call"))]
        Call,
        /// <summary>
        /// return
        /// </summary>
        [EnumMember(Value = ("return"))]
        Return
    }

    /// <summary>
    /// BreakLocation
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class BreakLocation : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Script identifier as reported in the `Debugger.scriptParsed`.
        /// </summary>
        [DataMember(Name = ("scriptId"), IsRequired = (true))]
        public string ScriptId
        {
            get;
            set;
        }

        /// <summary>
        /// Line number in the script (0-based).
        /// </summary>
        [DataMember(Name = ("lineNumber"), IsRequired = (true))]
        public int LineNumber
        {
            get;
            set;
        }

        /// <summary>
        /// Column number in the script (0-based).
        /// </summary>
        [DataMember(Name = ("columnNumber"), IsRequired = (false))]
        public int? ColumnNumber
        {
            get;
            set;
        }

        /// <summary>
        /// Type
        /// </summary>
        public CefSharp.DevTools.Debugger.BreakLocationType? Type
        {
            get
            {
                return (CefSharp.DevTools.Debugger.BreakLocationType? )(StringToEnum(typeof(CefSharp.DevTools.Debugger.BreakLocationType? ), type));
            }

            set
            {
                this.type = (EnumToString(value));
            }
        }

        /// <summary>
        /// Type
        /// </summary>
        [DataMember(Name = ("type"), IsRequired = (false))]
        internal string type
        {
            get;
            set;
        }
    }

    /// <summary>
    /// WasmDisassemblyChunk
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class WasmDisassemblyChunk : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The next chunk of disassembled lines.
        /// </summary>
        [DataMember(Name = ("lines"), IsRequired = (true))]
        public string[] Lines
        {
            get;
            set;
        }

        /// <summary>
        /// The bytecode offsets describing the start of each line.
        /// </summary>
        [DataMember(Name = ("bytecodeOffsets"), IsRequired = (true))]
        public int[] BytecodeOffsets
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Enum of possible script languages.
    /// </summary>
    public enum ScriptLanguage
    {
        /// <summary>
        /// JavaScript
        /// </summary>
        [EnumMember(Value = ("JavaScript"))]
        JavaScript,
        /// <summary>
        /// WebAssembly
        /// </summary>
        [EnumMember(Value = ("WebAssembly"))]
        WebAssembly
    }

    /// <summary>
    /// Type of the debug symbols.
    /// </summary>
    public enum DebugSymbolsType
    {
        /// <summary>
        /// None
        /// </summary>
        [EnumMember(Value = ("None"))]
        None,
        /// <summary>
        /// SourceMap
        /// </summary>
        [EnumMember(Value = ("SourceMap"))]
        SourceMap,
        /// <summary>
        /// EmbeddedDWARF
        /// </summary>
        [EnumMember(Value = ("EmbeddedDWARF"))]
        EmbeddedDWARF,
        /// <summary>
        /// ExternalDWARF
        /// </summary>
        [EnumMember(Value = ("ExternalDWARF"))]
        ExternalDWARF
    }

    /// <summary>
    /// Debug symbols available for a wasm script.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public partial class DebugSymbols : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Type of the debug symbols.
        /// </summary>
        public CefSharp.DevTools.Debugger.DebugSymbolsType Type
        {
            get
            {
                return (CefSharp.DevTools.Debugger.DebugSymbolsType)(StringToEnum(typeof(CefSharp.DevTools.Debugger.DebugSymbolsType), type));
            }

            set
            {
                this.type = (EnumToString(value));
            }
        }

        /// <summary>
        /// Type of the debug symbols.
        /// </summary>
        [DataMember(Name = ("type"), IsRequired = (true))]
        internal string type
        {
            get;
            set;
        }

        /// <summary>
        /// URL of the external symbol source.
        /// </summary>
        [DataMember(Name = ("externalURL"), IsRequired = (false))]
        public string ExternalURL
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Fired when breakpoint is resolved to an actual script and location.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class BreakpointResolvedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Breakpoint unique identifier.
        /// </summary>
        [DataMember(Name = ("breakpointId"), IsRequired = (true))]
        public string BreakpointId
        {
            get;
            private set;
        }

        /// <summary>
        /// Actual breakpoint location.
        /// </summary>
        [DataMember(Name = ("location"), IsRequired = (true))]
        public CefSharp.DevTools.Debugger.Location Location
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Pause reason.
    /// </summary>
    public enum PausedReason
    {
        /// <summary>
        /// ambiguous
        /// </summary>
        [EnumMember(Value = ("ambiguous"))]
        Ambiguous,
        /// <summary>
        /// assert
        /// </summary>
        [EnumMember(Value = ("assert"))]
        Assert,
        /// <summary>
        /// CSPViolation
        /// </summary>
        [EnumMember(Value = ("CSPViolation"))]
        CSPViolation,
        /// <summary>
        /// debugCommand
        /// </summary>
        [EnumMember(Value = ("debugCommand"))]
        DebugCommand,
        /// <summary>
        /// DOM
        /// </summary>
        [EnumMember(Value = ("DOM"))]
        DOM,
        /// <summary>
        /// EventListener
        /// </summary>
        [EnumMember(Value = ("EventListener"))]
        EventListener,
        /// <summary>
        /// exception
        /// </summary>
        [EnumMember(Value = ("exception"))]
        Exception,
        /// <summary>
        /// instrumentation
        /// </summary>
        [EnumMember(Value = ("instrumentation"))]
        Instrumentation,
        /// <summary>
        /// OOM
        /// </summary>
        [EnumMember(Value = ("OOM"))]
        OOM,
        /// <summary>
        /// other
        /// </summary>
        [EnumMember(Value = ("other"))]
        Other,
        /// <summary>
        /// promiseRejection
        /// </summary>
        [EnumMember(Value = ("promiseRejection"))]
        PromiseRejection,
        /// <summary>
        /// XHR
        /// </summary>
        [EnumMember(Value = ("XHR"))]
        XHR,
        /// <summary>
        /// step
        /// </summary>
        [EnumMember(Value = ("step"))]
        Step
    }

    /// <summary>
    /// Fired when the virtual machine stopped on breakpoint or exception or any other stop criteria.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class PausedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Call stack the virtual machine stopped on.
        /// </summary>
        [DataMember(Name = ("callFrames"), IsRequired = (true))]
        public System.Collections.Generic.IList<CefSharp.DevTools.Debugger.CallFrame> CallFrames
        {
            get;
            private set;
        }

        /// <summary>
        /// Pause reason.
        /// </summary>
        public CefSharp.DevTools.Debugger.PausedReason Reason
        {
            get
            {
                return (CefSharp.DevTools.Debugger.PausedReason)(StringToEnum(typeof(CefSharp.DevTools.Debugger.PausedReason), reason));
            }

            set
            {
                this.reason = (EnumToString(value));
            }
        }

        /// <summary>
        /// Pause reason.
        /// </summary>
        [DataMember(Name = ("reason"), IsRequired = (true))]
        internal string reason
        {
            get;
            private set;
        }

        /// <summary>
        /// Object containing break-specific auxiliary properties.
        /// </summary>
        [DataMember(Name = ("data"), IsRequired = (false))]
        public object Data
        {
            get;
            private set;
        }

        /// <summary>
        /// Hit breakpoints IDs
        /// </summary>
        [DataMember(Name = ("hitBreakpoints"), IsRequired = (false))]
        public string[] HitBreakpoints
        {
            get;
            private set;
        }

        /// <summary>
        /// Async stack trace, if any.
        /// </summary>
        [DataMember(Name = ("asyncStackTrace"), IsRequired = (false))]
        public CefSharp.DevTools.Runtime.StackTrace AsyncStackTrace
        {
            get;
            private set;
        }

        /// <summary>
        /// Async stack trace, if any.
        /// </summary>
        [DataMember(Name = ("asyncStackTraceId"), IsRequired = (false))]
        public CefSharp.DevTools.Runtime.StackTraceId AsyncStackTraceId
        {
            get;
            private set;
        }

        /// <summary>
        /// Never present, will be removed.
        /// </summary>
        [DataMember(Name = ("asyncCallStackTraceId"), IsRequired = (false))]
        public CefSharp.DevTools.Runtime.StackTraceId AsyncCallStackTraceId
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired when virtual machine fails to parse the script.
    /// </summary>
    [System.Runtime.Serialization.DataContractAttribute]
    public class ScriptFailedToParseEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Identifier of the script parsed.
        /// </summary>
        [DataMember(Name = ("scriptId"), IsRequired = (true))]
        public string ScriptId
        {
            get;
            private set;
        }

        /// <summary>
        /// URL or name of the script parsed (if any).
        /// </summary>
        [DataMember(Name = ("url"), IsRequired = (true))]
        public string Url
        {
            get;
            private set;
        }

        /// <summary>
        /// Line offset of the script within the resource with given URL (for script tags).
        /// </summary>
        [DataMember(Name = ("startLine"), IsRequired = (true))]
        public int StartLine
        {
            get;
            private set;
        }

        /// <summary>
        /// Column offset of the script within the resource with given URL.
        /// </summary>
        [DataMember(Name = ("startColumn"), IsRequired = (true))]
        public int StartColumn
        {
            get;
            private set;
        }

        /// <summary>
        /// Last line of the script.
        /// </summary>
        [DataMember(Name = ("endLine"), IsRequired = (true))]
        public int EndLine
        {
            get;
            private set;
        }

        /// <summary>
        /// Length of the last line of the script.
        /// </summary>
        [DataMember(Name = ("endColumn"), IsRequired = (true))]
        public int EndColumn
        {
            get;
            private set;
        }

        /// <summary>
        /// Specifies script creation context.
        /// </summary>
        [DataMember(Name = ("executionContextId"), IsRequired = (true))]
        public int ExecutionContextId
        {
            get;
            private set;
        }

        /// <summary>
        /// Content hash of the script, SHA-256.
        /// </summary>
        [DataMember(Name = ("hash"), IsRequired = (true))]
        public string Hash
        {
            get;
            private set;
        }

        /// <summary>
        /// Embedder-specific auxiliary data likely matching {isDefault: boolean, type: &apos;default&apos;|&apos;isolated&apos;|&apos;worker&apos;, frameId: string}
        /// </summary>
        [DataMember(Name = ("executionContextAuxData"), IsRequired = (false))]
        public object ExecutionContextAuxData
        {
            get;
            private set;
        }

        /// <summary>
        /// URL of source map associated with script (if any).
        /// </summary>
        [DataMember(Name = ("sourceMapURL"), IsRequired = (false))]
        public string SourceMapURL
        {
            get;
            private set;
        }

        /// <summary>
        /// True, if this script has sourceURL.
        /// </summary>
        [DataMember(Name = ("hasSourceURL"), IsRequired = (false))]
        public bool? HasSourceURL
        {
            get;
            private set;
        }

        /// <summary>
        /// True, if this script is ES6 module.
        /// </summary>
        [DataMember(Name = ("isModule"), IsRequired = (false))]
        public bool? IsModule
        {
            get;
            private set;
        }

        /// <summary>
        /// This script length.
        /// </summary>
        [DataMember(Name = ("length"), IsRequired = (false))]
        public int? Length
        {
            get;
            private set;
        }

        /// <summary>
        /// JavaScript top stack frame of where the script parsed event was triggered if available.
        /// </summary>
        [DataMember(Name = ("stackTrace"), IsRequired = (false))]
        public CefSharp.DevTools.Runtime.StackTrace StackTrace
        {
            get;
            private set;
        }

        /// <summ