// Copyright © 2020 The CefSharp Authors. All rights reserved.
//
// Use of this source code is governed by a BSD-style license that can be found in the LICENSE file.
//
// **This code was generated by a tool, do not change directly**
// CHROMIUM VERSION 129.0.6668.90
using System.Text.Json.Serialization;

namespace CefSharp.DevTools.Accessibility
{
    /// <summary>
    /// Enum of possible property types.
    /// </summary>
    public enum AXValueType
    {
        /// <summary>
        /// boolean
        /// </summary>
        [JsonPropertyName("boolean")]
        Boolean,
        /// <summary>
        /// tristate
        /// </summary>
        [JsonPropertyName("tristate")]
        Tristate,
        /// <summary>
        /// booleanOrUndefined
        /// </summary>
        [JsonPropertyName("booleanOrUndefined")]
        BooleanOrUndefined,
        /// <summary>
        /// idref
        /// </summary>
        [JsonPropertyName("idref")]
        Idref,
        /// <summary>
        /// idrefList
        /// </summary>
        [JsonPropertyName("idrefList")]
        IdrefList,
        /// <summary>
        /// integer
        /// </summary>
        [JsonPropertyName("integer")]
        Integer,
        /// <summary>
        /// node
        /// </summary>
        [JsonPropertyName("node")]
        Node,
        /// <summary>
        /// nodeList
        /// </summary>
        [JsonPropertyName("nodeList")]
        NodeList,
        /// <summary>
        /// number
        /// </summary>
        [JsonPropertyName("number")]
        Number,
        /// <summary>
        /// string
        /// </summary>
        [JsonPropertyName("string")]
        String,
        /// <summary>
        /// computedString
        /// </summary>
        [JsonPropertyName("computedString")]
        ComputedString,
        /// <summary>
        /// token
        /// </summary>
        [JsonPropertyName("token")]
        Token,
        /// <summary>
        /// tokenList
        /// </summary>
        [JsonPropertyName("tokenList")]
        TokenList,
        /// <summary>
        /// domRelation
        /// </summary>
        [JsonPropertyName("domRelation")]
        DomRelation,
        /// <summary>
        /// role
        /// </summary>
        [JsonPropertyName("role")]
        Role,
        /// <summary>
        /// internalRole
        /// </summary>
        [JsonPropertyName("internalRole")]
        InternalRole,
        /// <summary>
        /// valueUndefined
        /// </summary>
        [JsonPropertyName("valueUndefined")]
        ValueUndefined
    }

    /// <summary>
    /// Enum of possible property sources.
    /// </summary>
    public enum AXValueSourceType
    {
        /// <summary>
        /// attribute
        /// </summary>
        [JsonPropertyName("attribute")]
        Attribute,
        /// <summary>
        /// implicit
        /// </summary>
        [JsonPropertyName("implicit")]
        Implicit,
        /// <summary>
        /// style
        /// </summary>
        [JsonPropertyName("style")]
        Style,
        /// <summary>
        /// contents
        /// </summary>
        [JsonPropertyName("contents")]
        Contents,
        /// <summary>
        /// placeholder
        /// </summary>
        [JsonPropertyName("placeholder")]
        Placeholder,
        /// <summary>
        /// relatedElement
        /// </summary>
        [JsonPropertyName("relatedElement")]
        RelatedElement
    }

    /// <summary>
    /// Enum of possible native property sources (as a subtype of a particular AXValueSourceType).
    /// </summary>
    public enum AXValueNativeSourceType
    {
        /// <summary>
        /// description
        /// </summary>
        [JsonPropertyName("description")]
        Description,
        /// <summary>
        /// figcaption
        /// </summary>
        [JsonPropertyName("figcaption")]
        Figcaption,
        /// <summary>
        /// label
        /// </summary>
        [JsonPropertyName("label")]
        Label,
        /// <summary>
        /// labelfor
        /// </summary>
        [JsonPropertyName("labelfor")]
        Labelfor,
        /// <summary>
        /// labelwrapped
        /// </summary>
        [JsonPropertyName("labelwrapped")]
        Labelwrapped,
        /// <summary>
        /// legend
        /// </summary>
        [JsonPropertyName("legend")]
        Legend,
        /// <summary>
        /// rubyannotation
        /// </summary>
        [JsonPropertyName("rubyannotation")]
        Rubyannotation,
        /// <summary>
        /// tablecaption
        /// </summary>
        [JsonPropertyName("tablecaption")]
        Tablecaption,
        /// <summary>
        /// title
        /// </summary>
        [JsonPropertyName("title")]
        Title,
        /// <summary>
        /// other
        /// </summary>
        [JsonPropertyName("other")]
        Other
    }

    /// <summary>
    /// A single source for a computed AX property.
    /// </summary>
    public partial class AXValueSource : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// What type of source this is.
        /// </summary>
        [JsonPropertyName("type")]
        public CefSharp.DevTools.Accessibility.AXValueSourceType Type
        {
            get;
            set;
        }

        /// <summary>
        /// The value of this property source.
        /// </summary>
        [JsonPropertyName("value")]
        public CefSharp.DevTools.Accessibility.AXValue Value
        {
            get;
            set;
        }

        /// <summary>
        /// The name of the relevant attribute, if any.
        /// </summary>
        [JsonPropertyName("attribute")]
        public string Attribute
        {
            get;
            set;
        }

        /// <summary>
        /// The value of the relevant attribute, if any.
        /// </summary>
        [JsonPropertyName("attributeValue")]
        public CefSharp.DevTools.Accessibility.AXValue AttributeValue
        {
            get;
            set;
        }

        /// <summary>
        /// Whether this source is superseded by a higher priority source.
        /// </summary>
        [JsonPropertyName("superseded")]
        public bool? Superseded
        {
            get;
            set;
        }

        /// <summary>
        /// The native markup source for this value, e.g. a `&lt;label&gt;` element.
        /// </summary>
        [JsonPropertyName("nativeSource")]
        public CefSharp.DevTools.Accessibility.AXValueNativeSourceType? NativeSource
        {
            get;
            set;
        }

        /// <summary>
        /// The value, such as a node or node list, of the native source.
        /// </summary>
        [JsonPropertyName("nativeSourceValue")]
        public CefSharp.DevTools.Accessibility.AXValue NativeSourceValue
        {
            get;
            set;
        }

        /// <summary>
        /// Whether the value for this property is invalid.
        /// </summary>
        [JsonPropertyName("invalid")]
        public bool? Invalid
        {
            get;
            set;
        }

        /// <summary>
        /// Reason for the value being invalid, if it is.
        /// </summary>
        [JsonPropertyName("invalidReason")]
        public string InvalidReason
        {
            get;
            set;
        }
    }

    /// <summary>
    /// AXRelatedNode
    /// </summary>
    public partial class AXRelatedNode : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The BackendNodeId of the related DOM node.
        /// </summary>
        [JsonPropertyName("backendDOMNodeId")]
        public int BackendDOMNodeId
        {
            get;
            set;
        }

        /// <summary>
        /// The IDRef value provided, if any.
        /// </summary>
        [JsonPropertyName("idref")]
        public string Idref
        {
            get;
            set;
        }

        /// <summary>
        /// The text alternative of this node in the current context.
        /// </summary>
        [JsonPropertyName("text")]
        public string Text
        {
            get;
            set;
        }
    }

    /// <summary>
    /// AXProperty
    /// </summary>
    public partial class AXProperty : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The name of this property.
        /// </summary>
        [JsonPropertyName("name")]
        public CefSharp.DevTools.Accessibility.AXPropertyName Name
        {
            get;
            set;
        }

        /// <summary>
        /// The value of this property.
        /// </summary>
        [JsonPropertyName("value")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.Accessibility.AXValue Value
        {
            get;
            set;
        }
    }

    /// <summary>
    /// A single computed AX property.
    /// </summary>
    public partial class AXValue : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The type of this value.
        /// </summary>
        [JsonPropertyName("type")]
        public CefSharp.DevTools.Accessibility.AXValueType Type
        {
            get;
            set;
        }

        /// <summary>
        /// The computed value of this property.
        /// </summary>
        [JsonPropertyName("value")]
        public object Value
        {
            get;
            set;
        }

        /// <summary>
        /// One or more related nodes, if applicable.
        /// </summary>
        [JsonPropertyName("relatedNodes")]
        public System.Collections.Generic.IList<CefSharp.DevTools.Accessibility.AXRelatedNode> RelatedNodes
        {
            get;
            set;
        }

        /// <summary>
        /// The sources which contributed to the computation of this property.
        /// </summary>
        [JsonPropertyName("sources")]
        public System.Collections.Generic.IList<CefSharp.DevTools.Accessibility.AXValueSource> Sources
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Values of AXProperty name:
    /// - from &apos;busy&apos; to &apos;roledescription&apos;: states which apply to every AX node
    /// - from &apos;live&apos; to &apos;root&apos;: attributes which apply to nodes in live regions
    /// - from &apos;autocomplete&apos; to &apos;valuetext&apos;: attributes which apply to widgets
    /// - from &apos;checked&apos; to &apos;selected&apos;: states which apply to widgets
    /// - from &apos;activedescendant&apos; to &apos;owns&apos; - relationships between elements other than parent/child/sibling.
    /// </summary>
    public enum AXPropertyName
    {
        /// <summary>
        /// busy
        /// </summary>
        [JsonPropertyName("busy")]
        Busy,
        /// <summary>
        /// disabled
        /// </summary>
        [JsonPropertyName("disabled")]
        Disabled,
        /// <summary>
        /// editable
        /// </summary>
        [JsonPropertyName("editable")]
        Editable,
        /// <summary>
        /// focusable
        /// </summary>
        [JsonPropertyName("focusable")]
        Focusable,
        /// <summary>
        /// focused
        /// </summary>
        [JsonPropertyName("focused")]
        Focused,
        /// <summary>
        /// hidden
        /// </summary>
        [JsonPropertyName("hidden")]
        Hidden,
        /// <summary>
        /// hiddenRoot
        /// </summary>
        [JsonPropertyName("hiddenRoot")]
        HiddenRoot,
        /// <summary>
        /// invalid
        /// </summary>
        [JsonPropertyName("invalid")]
        Invalid,
        /// <summary>
        /// keyshortcuts
        /// </summary>
        [JsonPropertyName("keyshortcuts")]
        Keyshortcuts,
        /// <summary>
        /// settable
        /// </summary>
        [JsonPropertyName("settable")]
        Settable,
        /// <summary>
        /// roledescription
        /// </summary>
        [JsonPropertyName("roledescription")]
        Roledescription,
        /// <summary>
        /// live
        /// </summary>
        [JsonPropertyName("live")]
        Live,
        /// <summary>
        /// atomic
        /// </summary>
        [JsonPropertyName("atomic")]
        Atomic,
        /// <summary>
        /// relevant
        /// </summary>
        [JsonPropertyName("relevant")]
        Relevant,
        /// <summary>
        /// root
        /// </summary>
        [JsonPropertyName("root")]
        Root,
        /// <summary>
        /// autocomplete
        /// </summary>
        [JsonPropertyName("autocomplete")]
        Autocomplete,
        /// <summary>
        /// hasPopup
        /// </summary>
        [JsonPropertyName("hasPopup")]
        HasPopup,
        /// <summary>
        /// level
        /// </summary>
        [JsonPropertyName("level")]
        Level,
        /// <summary>
        /// multiselectable
        /// </summary>
        [JsonPropertyName("multiselectable")]
        Multiselectable,
        /// <summary>
        /// orientation
        /// </summary>
        [JsonPropertyName("orientation")]
        Orientation,
        /// <summary>
        /// multiline
        /// </summary>
        [JsonPropertyName("multiline")]
        Multiline,
        /// <summary>
        /// readonly
        /// </summary>
        [JsonPropertyName("readonly")]
        Readonly,
        /// <summary>
        /// required
        /// </summary>
        [JsonPropertyName("required")]
        Required,
        /// <summary>
        /// valuemin
        /// </summary>
        [JsonPropertyName("valuemin")]
        Valuemin,
        /// <summary>
        /// valuemax
        /// </summary>
        [JsonPropertyName("valuemax")]
        Valuemax,
        /// <summary>
        /// valuetext
        /// </summary>
        [JsonPropertyName("valuetext")]
        Valuetext,
        /// <summary>
        /// checked
        /// </summary>
        [JsonPropertyName("checked")]
        Checked,
        /// <summary>
        /// expanded
        /// </summary>
        [JsonPropertyName("expanded")]
        Expanded,
        /// <summary>
        /// modal
        /// </summary>
        [JsonPropertyName("modal")]
        Modal,
        /// <summary>
        /// pressed
        /// </summary>
        [JsonPropertyName("pressed")]
        Pressed,
        /// <summary>
        /// selected
        /// </summary>
        [JsonPropertyName("selected")]
        Selected,
        /// <summary>
        /// activedescendant
        /// </summary>
        [JsonPropertyName("activedescendant")]
        Activedescendant,
        /// <summary>
        /// controls
        /// </summary>
        [JsonPropertyName("controls")]
        Controls,
        /// <summary>
        /// describedby
        /// </summary>
        [JsonPropertyName("describedby")]
        Describedby,
        /// <summary>
        /// details
        /// </summary>
        [JsonPropertyName("details")]
        Details,
        /// <summary>
        /// errormessage
        /// </summary>
        [JsonPropertyName("errormessage")]
        Errormessage,
        /// <summary>
        /// flowto
        /// </summary>
        [JsonPropertyName("flowto")]
        Flowto,
        /// <summary>
        /// labelledby
        /// </summary>
        [JsonPropertyName("labelledby")]
        Labelledby,
        /// <summary>
        /// owns
        /// </summary>
        [JsonPropertyName("owns")]
        Owns,
        /// <summary>
        /// url
        /// </summary>
        [JsonPropertyName("url")]
        Url
    }

    /// <summary>
    /// A node in the accessibility tree.
    /// </summary>
    public partial class AXNode : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Unique identifier for this node.
        /// </summary>
        [JsonPropertyName("nodeId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string NodeId
        {
            get;
            set;
        }

        /// <summary>
        /// Whether this node is ignored for accessibility
        /// </summary>
        [JsonPropertyName("ignored")]
        public bool Ignored
        {
            get;
            set;
        }

        /// <summary>
        /// Collection of reasons why this node is hidden.
        /// </summary>
        [JsonPropertyName("ignoredReasons")]
        public System.Collections.Generic.IList<CefSharp.DevTools.Accessibility.AXProperty> IgnoredReasons
        {
            get;
            set;
        }

        /// <summary>
        /// This `Node`&apos;s role, whether explicit or implicit.
        /// </summary>
        [JsonPropertyName("role")]
        public CefSharp.DevTools.Accessibility.AXValue Role
        {
            get;
            set;
        }

        /// <summary>
        /// This `Node`&apos;s Chrome raw role.
        /// </summary>
        [JsonPropertyName("chromeRole")]
        public CefSharp.DevTools.Accessibility.AXValue ChromeRole
        {
            get;
            set;
        }

        /// <summary>
        /// The accessible name for this `Node`.
        /// </summary>
        [JsonPropertyName("name")]
        public CefSharp.DevTools.Accessibility.AXValue Name
        {
            get;
            set;
        }

        /// <summary>
        /// The accessible description for this `Node`.
        /// </summary>
        [JsonPropertyName("description")]
        public CefSharp.DevTools.Accessibility.AXValue Description
        {
            get;
            set;
        }

        /// <summary>
        /// The value for this `Node`.
        /// </summary>
        [JsonPropertyName("value")]
        public CefSharp.DevTools.Accessibility.AXValue Value
        {
            get;
            set;
        }

        /// <summary>
        /// All other properties
        /// </summary>
        [JsonPropertyName("properties")]
        public System.Collections.Generic.IList<CefSharp.DevTools.Accessibility.AXProperty> Properties
        {
            get;
            set;
        }

        /// <summary>
        /// ID for this node&apos;s parent.
        /// </summary>
        [JsonPropertyName("parentId")]
        public string ParentId
        {
            get;
            set;
        }

        /// <summary>
        /// IDs for each of this node&apos;s child nodes.
        /// </summary>
        [JsonPropertyName("childIds")]
        public string[] ChildIds
        {
            get;
            set;
        }

        /// <summary>
        /// The backend ID for the associated DOM node, if any.
        /// </summary>
        [JsonPropertyName("backendDOMNodeId")]
        public int? BackendDOMNodeId
        {
            get;
            set;
        }

        /// <summary>
        /// The frame ID for the frame associated with this nodes document.
        /// </summary>
        [JsonPropertyName("frameId")]
        public string FrameId
        {
            get;
            set;
        }
    }

    /// <summary>
    /// The loadComplete event mirrors the load complete event sent by the browser to assistive
    /// technology when the web page has finished loading.
    /// </summary>
    public class LoadCompleteEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// New document root node.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("root")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.Accessibility.AXNode Root
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// The nodesUpdated event is sent every time a previously requested node has changed the in tree.
    /// </summary>
    public class NodesUpdatedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Updated node data.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("nodes")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public System.Collections.Generic.IList<CefSharp.DevTools.Accessibility.AXNode> Nodes
        {
            get;
            private set;
        }
    }
}

namespace CefSharp.DevTools.Animation
{
    /// <summary>
    /// Animation type of `Animation`.
    /// </summary>
    public enum AnimationType
    {
        /// <summary>
        /// CSSTransition
        /// </summary>
        [JsonPropertyName("CSSTransition")]
        CSSTransition,
        /// <summary>
        /// CSSAnimation
        /// </summary>
        [JsonPropertyName("CSSAnimation")]
        CSSAnimation,
        /// <summary>
        /// WebAnimation
        /// </summary>
        [JsonPropertyName("WebAnimation")]
        WebAnimation
    }

    /// <summary>
    /// Animation instance.
    /// </summary>
    public partial class Animation : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// `Animation`&apos;s id.
        /// </summary>
        [JsonPropertyName("id")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Id
        {
            get;
            set;
        }

        /// <summary>
        /// `Animation`&apos;s name.
        /// </summary>
        [JsonPropertyName("name")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Name
        {
            get;
            set;
        }

        /// <summary>
        /// `Animation`&apos;s internal paused state.
        /// </summary>
        [JsonPropertyName("pausedState")]
        public bool PausedState
        {
            get;
            set;
        }

        /// <summary>
        /// `Animation`&apos;s play state.
        /// </summary>
        [JsonPropertyName("playState")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string PlayState
        {
            get;
            set;
        }

        /// <summary>
        /// `Animation`&apos;s playback rate.
        /// </summary>
        [JsonPropertyName("playbackRate")]
        public double PlaybackRate
        {
            get;
            set;
        }

        /// <summary>
        /// `Animation`&apos;s start time.
        /// Milliseconds for time based animations and
        /// percentage [0 - 100] for scroll driven animations
        /// (i.e. when viewOrScrollTimeline exists).
        /// </summary>
        [JsonPropertyName("startTime")]
        public double StartTime
        {
            get;
            set;
        }

        /// <summary>
        /// `Animation`&apos;s current time.
        /// </summary>
        [JsonPropertyName("currentTime")]
        public double CurrentTime
        {
            get;
            set;
        }

        /// <summary>
        /// Animation type of `Animation`.
        /// </summary>
        [JsonPropertyName("type")]
        public CefSharp.DevTools.Animation.AnimationType Type
        {
            get;
            set;
        }

        /// <summary>
        /// `Animation`&apos;s source animation node.
        /// </summary>
        [JsonPropertyName("source")]
        public CefSharp.DevTools.Animation.AnimationEffect Source
        {
            get;
            set;
        }

        /// <summary>
        /// A unique ID for `Animation` representing the sources that triggered this CSS
        /// animation/transition.
        /// </summary>
        [JsonPropertyName("cssId")]
        public string CssId
        {
            get;
            set;
        }

        /// <summary>
        /// View or scroll timeline
        /// </summary>
        [JsonPropertyName("viewOrScrollTimeline")]
        public CefSharp.DevTools.Animation.ViewOrScrollTimeline ViewOrScrollTimeline
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Timeline instance
    /// </summary>
    public partial class ViewOrScrollTimeline : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Scroll container node
        /// </summary>
        [JsonPropertyName("sourceNodeId")]
        public int? SourceNodeId
        {
            get;
            set;
        }

        /// <summary>
        /// Represents the starting scroll position of the timeline
        /// as a length offset in pixels from scroll origin.
        /// </summary>
        [JsonPropertyName("startOffset")]
        public double? StartOffset
        {
            get;
            set;
        }

        /// <summary>
        /// Represents the ending scroll position of the timeline
        /// as a length offset in pixels from scroll origin.
        /// </summary>
        [JsonPropertyName("endOffset")]
        public double? EndOffset
        {
            get;
            set;
        }

        /// <summary>
        /// The element whose principal box&apos;s visibility in the
        /// scrollport defined the progress of the timeline.
        /// Does not exist for animations with ScrollTimeline
        /// </summary>
        [JsonPropertyName("subjectNodeId")]
        public int? SubjectNodeId
        {
            get;
            set;
        }

        /// <summary>
        /// Orientation of the scroll
        /// </summary>
        [JsonPropertyName("axis")]
        public CefSharp.DevTools.DOM.ScrollOrientation Axis
        {
            get;
            set;
        }
    }

    /// <summary>
    /// AnimationEffect instance
    /// </summary>
    public partial class AnimationEffect : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// `AnimationEffect`&apos;s delay.
        /// </summary>
        [JsonPropertyName("delay")]
        public double Delay
        {
            get;
            set;
        }

        /// <summary>
        /// `AnimationEffect`&apos;s end delay.
        /// </summary>
        [JsonPropertyName("endDelay")]
        public double EndDelay
        {
            get;
            set;
        }

        /// <summary>
        /// `AnimationEffect`&apos;s iteration start.
        /// </summary>
        [JsonPropertyName("iterationStart")]
        public double IterationStart
        {
            get;
            set;
        }

        /// <summary>
        /// `AnimationEffect`&apos;s iterations.
        /// </summary>
        [JsonPropertyName("iterations")]
        public double Iterations
        {
            get;
            set;
        }

        /// <summary>
        /// `AnimationEffect`&apos;s iteration duration.
        /// Milliseconds for time based animations and
        /// percentage [0 - 100] for scroll driven animations
        /// (i.e. when viewOrScrollTimeline exists).
        /// </summary>
        [JsonPropertyName("duration")]
        public double Duration
        {
            get;
            set;
        }

        /// <summary>
        /// `AnimationEffect`&apos;s playback direction.
        /// </summary>
        [JsonPropertyName("direction")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Direction
        {
            get;
            set;
        }

        /// <summary>
        /// `AnimationEffect`&apos;s fill mode.
        /// </summary>
        [JsonPropertyName("fill")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Fill
        {
            get;
            set;
        }

        /// <summary>
        /// `AnimationEffect`&apos;s target node.
        /// </summary>
        [JsonPropertyName("backendNodeId")]
        public int? BackendNodeId
        {
            get;
            set;
        }

        /// <summary>
        /// `AnimationEffect`&apos;s keyframes.
        /// </summary>
        [JsonPropertyName("keyframesRule")]
        public CefSharp.DevTools.Animation.KeyframesRule KeyframesRule
        {
            get;
            set;
        }

        /// <summary>
        /// `AnimationEffect`&apos;s timing function.
        /// </summary>
        [JsonPropertyName("easing")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Easing
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Keyframes Rule
    /// </summary>
    public partial class KeyframesRule : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// CSS keyframed animation&apos;s name.
        /// </summary>
        [JsonPropertyName("name")]
        public string Name
        {
            get;
            set;
        }

        /// <summary>
        /// List of animation keyframes.
        /// </summary>
        [JsonPropertyName("keyframes")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public System.Collections.Generic.IList<CefSharp.DevTools.Animation.KeyframeStyle> Keyframes
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Keyframe Style
    /// </summary>
    public partial class KeyframeStyle : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Keyframe&apos;s time offset.
        /// </summary>
        [JsonPropertyName("offset")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Offset
        {
            get;
            set;
        }

        /// <summary>
        /// `AnimationEffect`&apos;s timing function.
        /// </summary>
        [JsonPropertyName("easing")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Easing
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Event for when an animation has been cancelled.
    /// </summary>
    public class AnimationCanceledEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Id of the animation that was cancelled.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("id")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Id
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Event for each animation that has been created.
    /// </summary>
    public class AnimationCreatedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Id of the animation that was created.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("id")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Id
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Event for animation that has been started.
    /// </summary>
    public class AnimationStartedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Animation that was started.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("animation")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.Animation.Animation Animation
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Event for animation that has been updated.
    /// </summary>
    public class AnimationUpdatedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Animation that was updated.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("animation")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.Animation.Animation Animation
        {
            get;
            private set;
        }
    }
}

namespace CefSharp.DevTools.Audits
{
    /// <summary>
    /// Information about a cookie that is affected by an inspector issue.
    /// </summary>
    public partial class AffectedCookie : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The following three properties uniquely identify a cookie
        /// </summary>
        [JsonPropertyName("name")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Name
        {
            get;
            set;
        }

        /// <summary>
        /// Path
        /// </summary>
        [JsonPropertyName("path")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Path
        {
            get;
            set;
        }

        /// <summary>
        /// Domain
        /// </summary>
        [JsonPropertyName("domain")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Domain
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Information about a request that is affected by an inspector issue.
    /// </summary>
    public partial class AffectedRequest : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The unique request id.
        /// </summary>
        [JsonPropertyName("requestId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string RequestId
        {
            get;
            set;
        }

        /// <summary>
        /// Url
        /// </summary>
        [JsonPropertyName("url")]
        public string Url
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Information about the frame affected by an inspector issue.
    /// </summary>
    public partial class AffectedFrame : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// FrameId
        /// </summary>
        [JsonPropertyName("frameId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string FrameId
        {
            get;
            set;
        }
    }

    /// <summary>
    /// CookieExclusionReason
    /// </summary>
    public enum CookieExclusionReason
    {
        /// <summary>
        /// ExcludeSameSiteUnspecifiedTreatedAsLax
        /// </summary>
        [JsonPropertyName("ExcludeSameSiteUnspecifiedTreatedAsLax")]
        ExcludeSameSiteUnspecifiedTreatedAsLax,
        /// <summary>
        /// ExcludeSameSiteNoneInsecure
        /// </summary>
        [JsonPropertyName("ExcludeSameSiteNoneInsecure")]
        ExcludeSameSiteNoneInsecure,
        /// <summary>
        /// ExcludeSameSiteLax
        /// </summary>
        [JsonPropertyName("ExcludeSameSiteLax")]
        ExcludeSameSiteLax,
        /// <summary>
        /// ExcludeSameSiteStrict
        /// </summary>
        [JsonPropertyName("ExcludeSameSiteStrict")]
        ExcludeSameSiteStrict,
        /// <summary>
        /// ExcludeInvalidSameParty
        /// </summary>
        [JsonPropertyName("ExcludeInvalidSameParty")]
        ExcludeInvalidSameParty,
        /// <summary>
        /// ExcludeSamePartyCrossPartyContext
        /// </summary>
        [JsonPropertyName("ExcludeSamePartyCrossPartyContext")]
        ExcludeSamePartyCrossPartyContext,
        /// <summary>
        /// ExcludeDomainNonASCII
        /// </summary>
        [JsonPropertyName("ExcludeDomainNonASCII")]
        ExcludeDomainNonASCII,
        /// <summary>
        /// ExcludeThirdPartyCookieBlockedInFirstPartySet
        /// </summary>
        [JsonPropertyName("ExcludeThirdPartyCookieBlockedInFirstPartySet")]
        ExcludeThirdPartyCookieBlockedInFirstPartySet,
        /// <summary>
        /// ExcludeThirdPartyPhaseout
        /// </summary>
        [JsonPropertyName("ExcludeThirdPartyPhaseout")]
        ExcludeThirdPartyPhaseout
    }

    /// <summary>
    /// CookieWarningReason
    /// </summary>
    public enum CookieWarningReason
    {
        /// <summary>
        /// WarnSameSiteUnspecifiedCrossSiteContext
        /// </summary>
        [JsonPropertyName("WarnSameSiteUnspecifiedCrossSiteContext")]
        WarnSameSiteUnspecifiedCrossSiteContext,
        /// <summary>
        /// WarnSameSiteNoneInsecure
        /// </summary>
        [JsonPropertyName("WarnSameSiteNoneInsecure")]
        WarnSameSiteNoneInsecure,
        /// <summary>
        /// WarnSameSiteUnspecifiedLaxAllowUnsafe
        /// </summary>
        [JsonPropertyName("WarnSameSiteUnspecifiedLaxAllowUnsafe")]
        WarnSameSiteUnspecifiedLaxAllowUnsafe,
        /// <summary>
        /// WarnSameSiteStrictLaxDowngradeStrict
        /// </summary>
        [JsonPropertyName("WarnSameSiteStrictLaxDowngradeStrict")]
        WarnSameSiteStrictLaxDowngradeStrict,
        /// <summary>
        /// WarnSameSiteStrictCrossDowngradeStrict
        /// </summary>
        [JsonPropertyName("WarnSameSiteStrictCrossDowngradeStrict")]
        WarnSameSiteStrictCrossDowngradeStrict,
        /// <summary>
        /// WarnSameSiteStrictCrossDowngradeLax
        /// </summary>
        [JsonPropertyName("WarnSameSiteStrictCrossDowngradeLax")]
        WarnSameSiteStrictCrossDowngradeLax,
        /// <summary>
        /// WarnSameSiteLaxCrossDowngradeStrict
        /// </summary>
        [JsonPropertyName("WarnSameSiteLaxCrossDowngradeStrict")]
        WarnSameSiteLaxCrossDowngradeStrict,
        /// <summary>
        /// WarnSameSiteLaxCrossDowngradeLax
        /// </summary>
        [JsonPropertyName("WarnSameSiteLaxCrossDowngradeLax")]
        WarnSameSiteLaxCrossDowngradeLax,
        /// <summary>
        /// WarnAttributeValueExceedsMaxSize
        /// </summary>
        [JsonPropertyName("WarnAttributeValueExceedsMaxSize")]
        WarnAttributeValueExceedsMaxSize,
        /// <summary>
        /// WarnDomainNonASCII
        /// </summary>
        [JsonPropertyName("WarnDomainNonASCII")]
        WarnDomainNonASCII,
        /// <summary>
        /// WarnThirdPartyPhaseout
        /// </summary>
        [JsonPropertyName("WarnThirdPartyPhaseout")]
        WarnThirdPartyPhaseout,
        /// <summary>
        /// WarnCrossSiteRedirectDowngradeChangesInclusion
        /// </summary>
        [JsonPropertyName("WarnCrossSiteRedirectDowngradeChangesInclusion")]
        WarnCrossSiteRedirectDowngradeChangesInclusion
    }

    /// <summary>
    /// CookieOperation
    /// </summary>
    public enum CookieOperation
    {
        /// <summary>
        /// SetCookie
        /// </summary>
        [JsonPropertyName("SetCookie")]
        SetCookie,
        /// <summary>
        /// ReadCookie
        /// </summary>
        [JsonPropertyName("ReadCookie")]
        ReadCookie
    }

    /// <summary>
    /// This information is currently necessary, as the front-end has a difficult
    /// time finding a specific cookie. With this, we can convey specific error
    /// information without the cookie.
    /// </summary>
    public partial class CookieIssueDetails : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// If AffectedCookie is not set then rawCookieLine contains the raw
        /// Set-Cookie header string. This hints at a problem where the
        /// cookie line is syntactically or semantically malformed in a way
        /// that no valid cookie could be created.
        /// </summary>
        [JsonPropertyName("cookie")]
        public CefSharp.DevTools.Audits.AffectedCookie Cookie
        {
            get;
            set;
        }

        /// <summary>
        /// RawCookieLine
        /// </summary>
        [JsonPropertyName("rawCookieLine")]
        public string RawCookieLine
        {
            get;
            set;
        }

        /// <summary>
        /// CookieWarningReasons
        /// </summary>
        [JsonPropertyName("cookieWarningReasons")]
        public CefSharp.DevTools.Audits.CookieWarningReason[] CookieWarningReasons
        {
            get;
            set;
        }

        /// <summary>
        /// CookieExclusionReasons
        /// </summary>
        [JsonPropertyName("cookieExclusionReasons")]
        public CefSharp.DevTools.Audits.CookieExclusionReason[] CookieExclusionReasons
        {
            get;
            set;
        }

        /// <summary>
        /// Optionally identifies the site-for-cookies and the cookie url, which
        /// may be used by the front-end as additional context.
        /// </summary>
        [JsonPropertyName("operation")]
        public CefSharp.DevTools.Audits.CookieOperation Operation
        {
            get;
            set;
        }

        /// <summary>
        /// SiteForCookies
        /// </summary>
        [JsonPropertyName("siteForCookies")]
        public string SiteForCookies
        {
            get;
            set;
        }

        /// <summary>
        /// CookieUrl
        /// </summary>
        [JsonPropertyName("cookieUrl")]
        public string CookieUrl
        {
            get;
            set;
        }

        /// <summary>
        /// Request
        /// </summary>
        [JsonPropertyName("request")]
        public CefSharp.DevTools.Audits.AffectedRequest Request
        {
            get;
            set;
        }
    }

    /// <summary>
    /// MixedContentResolutionStatus
    /// </summary>
    public enum MixedContentResolutionStatus
    {
        /// <summary>
        /// MixedContentBlocked
        /// </summary>
        [JsonPropertyName("MixedContentBlocked")]
        MixedContentBlocked,
        /// <summary>
        /// MixedContentAutomaticallyUpgraded
        /// </summary>
        [JsonPropertyName("MixedContentAutomaticallyUpgraded")]
        MixedContentAutomaticallyUpgraded,
        /// <summary>
        /// MixedContentWarning
        /// </summary>
        [JsonPropertyName("MixedContentWarning")]
        MixedContentWarning
    }

    /// <summary>
    /// MixedContentResourceType
    /// </summary>
    public enum MixedContentResourceType
    {
        /// <summary>
        /// AttributionSrc
        /// </summary>
        [JsonPropertyName("AttributionSrc")]
        AttributionSrc,
        /// <summary>
        /// Audio
        /// </summary>
        [JsonPropertyName("Audio")]
        Audio,
        /// <summary>
        /// Beacon
        /// </summary>
        [JsonPropertyName("Beacon")]
        Beacon,
        /// <summary>
        /// CSPReport
        /// </summary>
        [JsonPropertyName("CSPReport")]
        CSPReport,
        /// <summary>
        /// Download
        /// </summary>
        [JsonPropertyName("Download")]
        Download,
        /// <summary>
        /// EventSource
        /// </summary>
        [JsonPropertyName("EventSource")]
        EventSource,
        /// <summary>
        /// Favicon
        /// </summary>
        [JsonPropertyName("Favicon")]
        Favicon,
        /// <summary>
        /// Font
        /// </summary>
        [JsonPropertyName("Font")]
        Font,
        /// <summary>
        /// Form
        /// </summary>
        [JsonPropertyName("Form")]
        Form,
        /// <summary>
        /// Frame
        /// </summary>
        [JsonPropertyName("Frame")]
        Frame,
        /// <summary>
        /// Image
        /// </summary>
        [JsonPropertyName("Image")]
        Image,
        /// <summary>
        /// Import
        /// </summary>
        [JsonPropertyName("Import")]
        Import,
        /// <summary>
        /// JSON
        /// </summary>
        [JsonPropertyName("JSON")]
        JSON,
        /// <summary>
        /// Manifest
        /// </summary>
        [JsonPropertyName("Manifest")]
        Manifest,
        /// <summary>
        /// Ping
        /// </summary>
        [JsonPropertyName("Ping")]
        Ping,
        /// <summary>
        /// PluginData
        /// </summary>
        [JsonPropertyName("PluginData")]
        PluginData,
        /// <summary>
        /// PluginResource
        /// </summary>
        [JsonPropertyName("PluginResource")]
        PluginResource,
        /// <summary>
        /// Prefetch
        /// </summary>
        [JsonPropertyName("Prefetch")]
        Prefetch,
        /// <summary>
        /// Resource
        /// </summary>
        [JsonPropertyName("Resource")]
        Resource,
        /// <summary>
        /// Script
        /// </summary>
        [JsonPropertyName("Script")]
        Script,
        /// <summary>
        /// ServiceWorker
        /// </summary>
        [JsonPropertyName("ServiceWorker")]
        ServiceWorker,
        /// <summary>
        /// SharedWorker
        /// </summary>
        [JsonPropertyName("SharedWorker")]
        SharedWorker,
        /// <summary>
        /// SpeculationRules
        /// </summary>
        [JsonPropertyName("SpeculationRules")]
        SpeculationRules,
        /// <summary>
        /// Stylesheet
        /// </summary>
        [JsonPropertyName("Stylesheet")]
        Stylesheet,
        /// <summary>
        /// Track
        /// </summary>
        [JsonPropertyName("Track")]
        Track,
        /// <summary>
        /// Video
        /// </summary>
        [JsonPropertyName("Video")]
        Video,
        /// <summary>
        /// Worker
        /// </summary>
        [JsonPropertyName("Worker")]
        Worker,
        /// <summary>
        /// XMLHttpRequest
        /// </summary>
        [JsonPropertyName("XMLHttpRequest")]
        XMLHttpRequest,
        /// <summary>
        /// XSLT
        /// </summary>
        [JsonPropertyName("XSLT")]
        XSLT
    }

    /// <summary>
    /// MixedContentIssueDetails
    /// </summary>
    public partial class MixedContentIssueDetails : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The type of resource causing the mixed content issue (css, js, iframe,
        /// form,...). Marked as optional because it is mapped to from
        /// blink::mojom::RequestContextType, which will be replaced
        /// by network::mojom::RequestDestination
        /// </summary>
        [JsonPropertyName("resourceType")]
        public CefSharp.DevTools.Audits.MixedContentResourceType? ResourceType
        {
            get;
            set;
        }

        /// <summary>
        /// The way the mixed content issue is being resolved.
        /// </summary>
        [JsonPropertyName("resolutionStatus")]
        public CefSharp.DevTools.Audits.MixedContentResolutionStatus ResolutionStatus
        {
            get;
            set;
        }

        /// <summary>
        /// The unsafe http url causing the mixed content issue.
        /// </summary>
        [JsonPropertyName("insecureURL")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string InsecureURL
        {
            get;
            set;
        }

        /// <summary>
        /// The url responsible for the call to an unsafe url.
        /// </summary>
        [JsonPropertyName("mainResourceURL")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string MainResourceURL
        {
            get;
            set;
        }

        /// <summary>
        /// The mixed content request.
        /// Does not always exist (e.g. for unsafe form submission urls).
        /// </summary>
        [JsonPropertyName("request")]
        public CefSharp.DevTools.Audits.AffectedRequest Request
        {
            get;
            set;
        }

        /// <summary>
        /// Optional because not every mixed content issue is necessarily linked to a frame.
        /// </summary>
        [JsonPropertyName("frame")]
        public CefSharp.DevTools.Audits.AffectedFrame Frame
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Enum indicating the reason a response has been blocked. These reasons are
    /// refinements of the net error BLOCKED_BY_RESPONSE.
    /// </summary>
    public enum BlockedByResponseReason
    {
        /// <summary>
        /// CoepFrameResourceNeedsCoepHeader
        /// </summary>
        [JsonPropertyName("CoepFrameResourceNeedsCoepHeader")]
        CoepFrameResourceNeedsCoepHeader,
        /// <summary>
        /// CoopSandboxedIFrameCannotNavigateToCoopPage
        /// </summary>
        [JsonPropertyName("CoopSandboxedIFrameCannotNavigateToCoopPage")]
        CoopSandboxedIFrameCannotNavigateToCoopPage,
        /// <summary>
        /// CorpNotSameOrigin
        /// </summary>
        [JsonPropertyName("CorpNotSameOrigin")]
        CorpNotSameOrigin,
        /// <summary>
        /// CorpNotSameOriginAfterDefaultedToSameOriginByCoep
        /// </summary>
        [JsonPropertyName("CorpNotSameOriginAfterDefaultedToSameOriginByCoep")]
        CorpNotSameOriginAfterDefaultedToSameOriginByCoep,
        /// <summary>
        /// CorpNotSameOriginAfterDefaultedToSameOriginByDip
        /// </summary>
        [JsonPropertyName("CorpNotSameOriginAfterDefaultedToSameOriginByDip")]
        CorpNotSameOriginAfterDefaultedToSameOriginByDip,
        /// <summary>
        /// CorpNotSameOriginAfterDefaultedToSameOriginByCoepAndDip
        /// </summary>
        [JsonPropertyName("CorpNotSameOriginAfterDefaultedToSameOriginByCoepAndDip")]
        CorpNotSameOriginAfterDefaultedToSameOriginByCoepAndDip,
        /// <summary>
        /// CorpNotSameSite
        /// </summary>
        [JsonPropertyName("CorpNotSameSite")]
        CorpNotSameSite
    }

    /// <summary>
    /// Details for a request that has been blocked with the BLOCKED_BY_RESPONSE
    /// code. Currently only used for COEP/COOP, but may be extended to include
    /// some CSP errors in the future.
    /// </summary>
    public partial class BlockedByResponseIssueDetails : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Request
        /// </summary>
        [JsonPropertyName("request")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.Audits.AffectedRequest Request
        {
            get;
            set;
        }

        /// <summary>
        /// ParentFrame
        /// </summary>
        [JsonPropertyName("parentFrame")]
        public CefSharp.DevTools.Audits.AffectedFrame ParentFrame
        {
            get;
            set;
        }

        /// <summary>
        /// BlockedFrame
        /// </summary>
        [JsonPropertyName("blockedFrame")]
        public CefSharp.DevTools.Audits.AffectedFrame BlockedFrame
        {
            get;
            set;
        }

        /// <summary>
        /// Reason
        /// </summary>
        [JsonPropertyName("reason")]
        public CefSharp.DevTools.Audits.BlockedByResponseReason Reason
        {
            get;
            set;
        }
    }

    /// <summary>
    /// HeavyAdResolutionStatus
    /// </summary>
    public enum HeavyAdResolutionStatus
    {
        /// <summary>
        /// HeavyAdBlocked
        /// </summary>
        [JsonPropertyName("HeavyAdBlocked")]
        HeavyAdBlocked,
        /// <summary>
        /// HeavyAdWarning
        /// </summary>
        [JsonPropertyName("HeavyAdWarning")]
        HeavyAdWarning
    }

    /// <summary>
    /// HeavyAdReason
    /// </summary>
    public enum HeavyAdReason
    {
        /// <summary>
        /// NetworkTotalLimit
        /// </summary>
        [JsonPropertyName("NetworkTotalLimit")]
        NetworkTotalLimit,
        /// <summary>
        /// CpuTotalLimit
        /// </summary>
        [JsonPropertyName("CpuTotalLimit")]
        CpuTotalLimit,
        /// <summary>
        /// CpuPeakLimit
        /// </summary>
        [JsonPropertyName("CpuPeakLimit")]
        CpuPeakLimit
    }

    /// <summary>
    /// HeavyAdIssueDetails
    /// </summary>
    public partial class HeavyAdIssueDetails : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The resolution status, either blocking the content or warning.
        /// </summary>
        [JsonPropertyName("resolution")]
        public CefSharp.DevTools.Audits.HeavyAdResolutionStatus Resolution
        {
            get;
            set;
        }

        /// <summary>
        /// The reason the ad was blocked, total network or cpu or peak cpu.
        /// </summary>
        [JsonPropertyName("reason")]
        public CefSharp.DevTools.Audits.HeavyAdReason Reason
        {
            get;
            set;
        }

        /// <summary>
        /// The frame that was blocked.
        /// </summary>
        [JsonPropertyName("frame")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.Audits.AffectedFrame Frame
        {
            get;
            set;
        }
    }

    /// <summary>
    /// ContentSecurityPolicyViolationType
    /// </summary>
    public enum ContentSecurityPolicyViolationType
    {
        /// <summary>
        /// kInlineViolation
        /// </summary>
        [JsonPropertyName("kInlineViolation")]
        KInlineViolation,
        /// <summary>
        /// kEvalViolation
        /// </summary>
        [JsonPropertyName("kEvalViolation")]
        KEvalViolation,
        /// <summary>
        /// kURLViolation
        /// </summary>
        [JsonPropertyName("kURLViolation")]
        KURLViolation,
        /// <summary>
        /// kTrustedTypesSinkViolation
        /// </summary>
        [JsonPropertyName("kTrustedTypesSinkViolation")]
        KTrustedTypesSinkViolation,
        /// <summary>
        /// kTrustedTypesPolicyViolation
        /// </summary>
        [JsonPropertyName("kTrustedTypesPolicyViolation")]
        KTrustedTypesPolicyViolation,
        /// <summary>
        /// kWasmEvalViolation
        /// </summary>
        [JsonPropertyName("kWasmEvalViolation")]
        KWasmEvalViolation
    }

    /// <summary>
    /// SourceCodeLocation
    /// </summary>
    public partial class SourceCodeLocation : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// ScriptId
        /// </summary>
        [JsonPropertyName("scriptId")]
        public string ScriptId
        {
            get;
            set;
        }

        /// <summary>
        /// Url
        /// </summary>
        [JsonPropertyName("url")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Url
        {
            get;
            set;
        }

        /// <summary>
        /// LineNumber
        /// </summary>
        [JsonPropertyName("lineNumber")]
        public int LineNumber
        {
            get;
            set;
        }

        /// <summary>
        /// ColumnNumber
        /// </summary>
        [JsonPropertyName("columnNumber")]
        public int ColumnNumber
        {
            get;
            set;
        }
    }

    /// <summary>
    /// ContentSecurityPolicyIssueDetails
    /// </summary>
    public partial class ContentSecurityPolicyIssueDetails : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The url not included in allowed sources.
        /// </summary>
        [JsonPropertyName("blockedURL")]
        public string BlockedURL
        {
            get;
            set;
        }

        /// <summary>
        /// Specific directive that is violated, causing the CSP issue.
        /// </summary>
        [JsonPropertyName("violatedDirective")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string ViolatedDirective
        {
            get;
            set;
        }

        /// <summary>
        /// IsReportOnly
        /// </summary>
        [JsonPropertyName("isReportOnly")]
        public bool IsReportOnly
        {
            get;
            set;
        }

        /// <summary>
        /// ContentSecurityPolicyViolationType
        /// </summary>
        [JsonPropertyName("contentSecurityPolicyViolationType")]
        public CefSharp.DevTools.Audits.ContentSecurityPolicyViolationType ContentSecurityPolicyViolationType
        {
            get;
            set;
        }

        /// <summary>
        /// FrameAncestor
        /// </summary>
        [JsonPropertyName("frameAncestor")]
        public CefSharp.DevTools.Audits.AffectedFrame FrameAncestor
        {
            get;
            set;
        }

        /// <summary>
        /// SourceCodeLocation
        /// </summary>
        [JsonPropertyName("sourceCodeLocation")]
        public CefSharp.DevTools.Audits.SourceCodeLocation SourceCodeLocation
        {
            get;
            set;
        }

        /// <summary>
        /// ViolatingNodeId
        /// </summary>
        [JsonPropertyName("violatingNodeId")]
        public int? ViolatingNodeId
        {
            get;
            set;
        }
    }

    /// <summary>
    /// SharedArrayBufferIssueType
    /// </summary>
    public enum SharedArrayBufferIssueType
    {
        /// <summary>
        /// TransferIssue
        /// </summary>
        [JsonPropertyName("TransferIssue")]
        TransferIssue,
        /// <summary>
        /// CreationIssue
        /// </summary>
        [JsonPropertyName("CreationIssue")]
        CreationIssue
    }

    /// <summary>
    /// Details for a issue arising from an SAB being instantiated in, or
    /// transferred to a context that is not cross-origin isolated.
    /// </summary>
    public partial class SharedArrayBufferIssueDetails : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// SourceCodeLocation
        /// </summary>
        [JsonPropertyName("sourceCodeLocation")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.Audits.SourceCodeLocation SourceCodeLocation
        {
            get;
            set;
        }

        /// <summary>
        /// IsWarning
        /// </summary>
        [JsonPropertyName("isWarning")]
        public bool IsWarning
        {
            get;
            set;
        }

        /// <summary>
        /// Type
        /// </summary>
        [JsonPropertyName("type")]
        public CefSharp.DevTools.Audits.SharedArrayBufferIssueType Type
        {
            get;
            set;
        }
    }

    /// <summary>
    /// LowTextContrastIssueDetails
    /// </summary>
    public partial class LowTextContrastIssueDetails : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// ViolatingNodeId
        /// </summary>
        [JsonPropertyName("violatingNodeId")]
        public int ViolatingNodeId
        {
            get;
            set;
        }

        /// <summary>
        /// ViolatingNodeSelector
        /// </summary>
        [JsonPropertyName("violatingNodeSelector")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string ViolatingNodeSelector
        {
            get;
            set;
        }

        /// <summary>
        /// ContrastRatio
        /// </summary>
        [JsonPropertyName("contrastRatio")]
        public double ContrastRatio
        {
            get;
            set;
        }

        /// <summary>
        /// ThresholdAA
        /// </summary>
        [JsonPropertyName("thresholdAA")]
        public double ThresholdAA
        {
            get;
            set;
        }

        /// <summary>
        /// ThresholdAAA
        /// </summary>
        [JsonPropertyName("thresholdAAA")]
        public double ThresholdAAA
        {
            get;
            set;
        }

        /// <summary>
        /// FontSize
        /// </summary>
        [JsonPropertyName("fontSize")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string FontSize
        {
            get;
            set;
        }

        /// <summary>
        /// FontWeight
        /// </summary>
        [JsonPropertyName("fontWeight")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string FontWeight
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Details for a CORS related issue, e.g. a warning or error related to
    /// CORS RFC1918 enforcement.
    /// </summary>
    public partial class CorsIssueDetails : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// CorsErrorStatus
        /// </summary>
        [JsonPropertyName("corsErrorStatus")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.Network.CorsErrorStatus CorsErrorStatus
        {
            get;
            set;
        }

        /// <summary>
        /// IsWarning
        /// </summary>
        [JsonPropertyName("isWarning")]
        public bool IsWarning
        {
            get;
            set;
        }

        /// <summary>
        /// Request
        /// </summary>
        [JsonPropertyName("request")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.Audits.AffectedRequest Request
        {
            get;
            set;
        }

        /// <summary>
        /// Location
        /// </summary>
        [JsonPropertyName("location")]
        public CefSharp.DevTools.Audits.SourceCodeLocation Location
        {
            get;
            set;
        }

        /// <summary>
        /// InitiatorOrigin
        /// </summary>
        [JsonPropertyName("initiatorOrigin")]
        public string InitiatorOrigin
        {
            get;
            set;
        }

        /// <summary>
        /// ResourceIPAddressSpace
        /// </summary>
        [JsonPropertyName("resourceIPAddressSpace")]
        public CefSharp.DevTools.Network.IPAddressSpace? ResourceIPAddressSpace
        {
            get;
            set;
        }

        /// <summary>
        /// ClientSecurityState
        /// </summary>
        [JsonPropertyName("clientSecurityState")]
        public CefSharp.DevTools.Network.ClientSecurityState ClientSecurityState
        {
            get;
            set;
        }
    }

    /// <summary>
    /// AttributionReportingIssueType
    /// </summary>
    public enum AttributionReportingIssueType
    {
        /// <summary>
        /// PermissionPolicyDisabled
        /// </summary>
        [JsonPropertyName("PermissionPolicyDisabled")]
        PermissionPolicyDisabled,
        /// <summary>
        /// UntrustworthyReportingOrigin
        /// </summary>
        [JsonPropertyName("UntrustworthyReportingOrigin")]
        UntrustworthyReportingOrigin,
        /// <summary>
        /// InsecureContext
        /// </summary>
        [JsonPropertyName("InsecureContext")]
        InsecureContext,
        /// <summary>
        /// InvalidHeader
        /// </summary>
        [JsonPropertyName("InvalidHeader")]
        InvalidHeader,
        /// <summary>
        /// InvalidRegisterTriggerHeader
        /// </summary>
        [JsonPropertyName("InvalidRegisterTriggerHeader")]
        InvalidRegisterTriggerHeader,
        /// <summary>
        /// SourceAndTriggerHeaders
        /// </summary>
        [JsonPropertyName("SourceAndTriggerHeaders")]
        SourceAndTriggerHeaders,
        /// <summary>
        /// SourceIgnored
        /// </summary>
        [JsonPropertyName("SourceIgnored")]
        SourceIgnored,
        /// <summary>
        /// TriggerIgnored
        /// </summary>
        [JsonPropertyName("TriggerIgnored")]
        TriggerIgnored,
        /// <summary>
        /// OsSourceIgnored
        /// </summary>
        [JsonPropertyName("OsSourceIgnored")]
        OsSourceIgnored,
        /// <summary>
        /// OsTriggerIgnored
        /// </summary>
        [JsonPropertyName("OsTriggerIgnored")]
        OsTriggerIgnored,
        /// <summary>
        /// InvalidRegisterOsSourceHeader
        /// </summary>
        [JsonPropertyName("InvalidRegisterOsSourceHeader")]
        InvalidRegisterOsSourceHeader,
        /// <summary>
        /// InvalidRegisterOsTriggerHeader
        /// </summary>
        [JsonPropertyName("InvalidRegisterOsTriggerHeader")]
        InvalidRegisterOsTriggerHeader,
        /// <summary>
        /// WebAndOsHeaders
        /// </summary>
        [JsonPropertyName("WebAndOsHeaders")]
        WebAndOsHeaders,
        /// <summary>
        /// NoWebOrOsSupport
        /// </summary>
        [JsonPropertyName("NoWebOrOsSupport")]
        NoWebOrOsSupport,
        /// <summary>
        /// NavigationRegistrationWithoutTransientUserActivation
        /// </summary>
        [JsonPropertyName("NavigationRegistrationWithoutTransientUserActivation")]
        NavigationRegistrationWithoutTransientUserActivation,
        /// <summary>
        /// InvalidInfoHeader
        /// </summary>
        [JsonPropertyName("InvalidInfoHeader")]
        InvalidInfoHeader,
        /// <summary>
        /// NoRegisterSourceHeader
        /// </summary>
        [JsonPropertyName("NoRegisterSourceHeader")]
        NoRegisterSourceHeader,
        /// <summary>
        /// NoRegisterTriggerHeader
        /// </summary>
        [JsonPropertyName("NoRegisterTriggerHeader")]
        NoRegisterTriggerHeader,
        /// <summary>
        /// NoRegisterOsSourceHeader
        /// </summary>
        [JsonPropertyName("NoRegisterOsSourceHeader")]
        NoRegisterOsSourceHeader,
        /// <summary>
        /// NoRegisterOsTriggerHeader
        /// </summary>
        [JsonPropertyName("NoRegisterOsTriggerHeader")]
        NoRegisterOsTriggerHeader
    }

    /// <summary>
    /// SharedDictionaryError
    /// </summary>
    public enum SharedDictionaryError
    {
        /// <summary>
        /// UseErrorCrossOriginNoCorsRequest
        /// </summary>
        [JsonPropertyName("UseErrorCrossOriginNoCorsRequest")]
        UseErrorCrossOriginNoCorsRequest,
        /// <summary>
        /// UseErrorDictionaryLoadFailure
        /// </summary>
        [JsonPropertyName("UseErrorDictionaryLoadFailure")]
        UseErrorDictionaryLoadFailure,
        /// <summary>
        /// UseErrorMatchingDictionaryNotUsed
        /// </summary>
        [JsonPropertyName("UseErrorMatchingDictionaryNotUsed")]
        UseErrorMatchingDictionaryNotUsed,
        /// <summary>
        /// UseErrorUnexpectedContentDictionaryHeader
        /// </summary>
        [JsonPropertyName("UseErrorUnexpectedContentDictionaryHeader")]
        UseErrorUnexpectedContentDictionaryHeader,
        /// <summary>
        /// WriteErrorCossOriginNoCorsRequest
        /// </summary>
        [JsonPropertyName("WriteErrorCossOriginNoCorsRequest")]
        WriteErrorCossOriginNoCorsRequest,
        /// <summary>
        /// WriteErrorDisallowedBySettings
        /// </summary>
        [JsonPropertyName("WriteErrorDisallowedBySettings")]
        WriteErrorDisallowedBySettings,
        /// <summary>
        /// WriteErrorExpiredResponse
        /// </summary>
        [JsonPropertyName("WriteErrorExpiredResponse")]
        WriteErrorExpiredResponse,
        /// <summary>
        /// WriteErrorFeatureDisabled
        /// </summary>
        [JsonPropertyName("WriteErrorFeatureDisabled")]
        WriteErrorFeatureDisabled,
        /// <summary>
        /// WriteErrorInsufficientResources
        /// </summary>
        [JsonPropertyName("WriteErrorInsufficientResources")]
        WriteErrorInsufficientResources,
        /// <summary>
        /// WriteErrorInvalidMatchField
        /// </summary>
        [JsonPropertyName("WriteErrorInvalidMatchField")]
        WriteErrorInvalidMatchField,
        /// <summary>
        /// WriteErrorInvalidStructuredHeader
        /// </summary>
        [JsonPropertyName("WriteErrorInvalidStructuredHeader")]
        WriteErrorInvalidStructuredHeader,
        /// <summary>
        /// WriteErrorNavigationRequest
        /// </summary>
        [JsonPropertyName("WriteErrorNavigationRequest")]
        WriteErrorNavigationRequest,
        /// <summary>
        /// WriteErrorNoMatchField
        /// </summary>
        [JsonPropertyName("WriteErrorNoMatchField")]
        WriteErrorNoMatchField,
        /// <summary>
        /// WriteErrorNonListMatchDestField
        /// </summary>
        [JsonPropertyName("WriteErrorNonListMatchDestField")]
        WriteErrorNonListMatchDestField,
        /// <summary>
        /// WriteErrorNonSecureContext
        /// </summary>
        [JsonPropertyName("WriteErrorNonSecureContext")]
        WriteErrorNonSecureContext,
        /// <summary>
        /// WriteErrorNonStringIdField
        /// </summary>
        [JsonPropertyName("WriteErrorNonStringIdField")]
        WriteErrorNonStringIdField,
        /// <summary>
        /// WriteErrorNonStringInMatchDestList
        /// </summary>
        [JsonPropertyName("WriteErrorNonStringInMatchDestList")]
        WriteErrorNonStringInMatchDestList,
        /// <summary>
        /// WriteErrorNonStringMatchField
        /// </summary>
        [JsonPropertyName("WriteErrorNonStringMatchField")]
        WriteErrorNonStringMatchField,
        /// <summary>
        /// WriteErrorNonTokenTypeField
        /// </summary>
        [JsonPropertyName("WriteErrorNonTokenTypeField")]
        WriteErrorNonTokenTypeField,
        /// <summary>
        /// WriteErrorRequestAborted
        /// </summary>
        [JsonPropertyName("WriteErrorRequestAborted")]
        WriteErrorRequestAborted,
        /// <summary>
        /// WriteErrorShuttingDown
        /// </summary>
        [JsonPropertyName("WriteErrorShuttingDown")]
        WriteErrorShuttingDown,
        /// <summary>
        /// WriteErrorTooLongIdField
        /// </summary>
        [JsonPropertyName("WriteErrorTooLongIdField")]
        WriteErrorTooLongIdField,
        /// <summary>
        /// WriteErrorUnsupportedType
        /// </summary>
        [JsonPropertyName("WriteErrorUnsupportedType")]
        WriteErrorUnsupportedType
    }

    /// <summary>
    /// Details for issues around &quot;Attribution Reporting API&quot; usage.
    /// Explainer: https://github.com/WICG/attribution-reporting-api
    /// </summary>
    public partial class AttributionReportingIssueDetails : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// ViolationType
        /// </summary>
        [JsonPropertyName("violationType")]
        public CefSharp.DevTools.Audits.AttributionReportingIssueType ViolationType
        {
            get;
            set;
        }

        /// <summary>
        /// Request
        /// </summary>
        [JsonPropertyName("request")]
        public CefSharp.DevTools.Audits.AffectedRequest Request
        {
            get;
            set;
        }

        /// <summary>
        /// ViolatingNodeId
        /// </summary>
        [JsonPropertyName("violatingNodeId")]
        public int? ViolatingNodeId
        {
            get;
            set;
        }

        /// <summary>
        /// InvalidParameter
        /// </summary>
        [JsonPropertyName("invalidParameter")]
        public string InvalidParameter
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Details for issues about documents in Quirks Mode
    /// or Limited Quirks Mode that affects page layouting.
    /// </summary>
    public partial class QuirksModeIssueDetails : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// If false, it means the document&apos;s mode is &quot;quirks&quot;
        /// instead of &quot;limited-quirks&quot;.
        /// </summary>
        [JsonPropertyName("isLimitedQuirksMode")]
        public bool IsLimitedQuirksMode
        {
            get;
            set;
        }

        /// <summary>
        /// DocumentNodeId
        /// </summary>
        [JsonPropertyName("documentNodeId")]
        public int DocumentNodeId
        {
            get;
            set;
        }

        /// <summary>
        /// Url
        /// </summary>
        [JsonPropertyName("url")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Url
        {
            get;
            set;
        }

        /// <summary>
        /// FrameId
        /// </summary>
        [JsonPropertyName("frameId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string FrameId
        {
            get;
            set;
        }

        /// <summary>
        /// LoaderId
        /// </summary>
        [JsonPropertyName("loaderId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string LoaderId
        {
            get;
            set;
        }
    }

    /// <summary>
    /// NavigatorUserAgentIssueDetails
    /// </summary>
    public partial class NavigatorUserAgentIssueDetails : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Url
        /// </summary>
        [JsonPropertyName("url")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Url
        {
            get;
            set;
        }

        /// <summary>
        /// Location
        /// </summary>
        [JsonPropertyName("location")]
        public CefSharp.DevTools.Audits.SourceCodeLocation Location
        {
            get;
            set;
        }
    }

    /// <summary>
    /// SharedDictionaryIssueDetails
    /// </summary>
    public partial class SharedDictionaryIssueDetails : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// SharedDictionaryError
        /// </summary>
        [JsonPropertyName("sharedDictionaryError")]
        public CefSharp.DevTools.Audits.SharedDictionaryError SharedDictionaryError
        {
            get;
            set;
        }

        /// <summary>
        /// Request
        /// </summary>
        [JsonPropertyName("request")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.Audits.AffectedRequest Request
        {
            get;
            set;
        }
    }

    /// <summary>
    /// GenericIssueErrorType
    /// </summary>
    public enum GenericIssueErrorType
    {
        /// <summary>
        /// FormLabelForNameError
        /// </summary>
        [JsonPropertyName("FormLabelForNameError")]
        FormLabelForNameError,
        /// <summary>
        /// FormDuplicateIdForInputError
        /// </summary>
        [JsonPropertyName("FormDuplicateIdForInputError")]
        FormDuplicateIdForInputError,
        /// <summary>
        /// FormInputWithNoLabelError
        /// </summary>
        [JsonPropertyName("FormInputWithNoLabelError")]
        FormInputWithNoLabelError,
        /// <summary>
        /// FormAutocompleteAttributeEmptyError
        /// </summary>
        [JsonPropertyName("FormAutocompleteAttributeEmptyError")]
        FormAutocompleteAttributeEmptyError,
        /// <summary>
        /// FormEmptyIdAndNameAttributesForInputError
        /// </summary>
        [JsonPropertyName("FormEmptyIdAndNameAttributesForInputError")]
        FormEmptyIdAndNameAttributesForInputError,
        /// <summary>
        /// FormAriaLabelledByToNonExistingId
        /// </summary>
        [JsonPropertyName("FormAriaLabelledByToNonExistingId")]
        FormAriaLabelledByToNonExistingId,
        /// <summary>
        /// FormInputAssignedAutocompleteValueToIdOrNameAttributeError
        /// </summary>
        [JsonPropertyName("FormInputAssignedAutocompleteValueToIdOrNameAttributeError")]
        FormInputAssignedAutocompleteValueToIdOrNameAttributeError,
        /// <summary>
        /// FormLabelHasNeitherForNorNestedInput
        /// </summary>
        [JsonPropertyName("FormLabelHasNeitherForNorNestedInput")]
        FormLabelHasNeitherForNorNestedInput,
        /// <summary>
        /// FormLabelForMatchesNonExistingIdError
        /// </summary>
        [JsonPropertyName("FormLabelForMatchesNonExistingIdError")]
        FormLabelForMatchesNonExistingIdError,
        /// <summary>
        /// FormInputHasWrongButWellIntendedAutocompleteValueError
        /// </summary>
        [JsonPropertyName("FormInputHasWrongButWellIntendedAutocompleteValueError")]
        FormInputHasWrongButWellIntendedAutocompleteValueError,
        /// <summary>
        /// ResponseWasBlockedByORB
        /// </summary>
        [JsonPropertyName("ResponseWasBlockedByORB")]
        ResponseWasBlockedByORB
    }

    /// <summary>
    /// Depending on the concrete errorType, different properties are set.
    /// </summary>
    public partial class GenericIssueDetails : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Issues with the same errorType are aggregated in the frontend.
        /// </summary>
        [JsonPropertyName("errorType")]
        public CefSharp.DevTools.Audits.GenericIssueErrorType ErrorType
        {
            get;
            set;
        }

        /// <summary>
        /// FrameId
        /// </summary>
        [JsonPropertyName("frameId")]
        public string FrameId
        {
            get;
            set;
        }

        /// <summary>
        /// ViolatingNodeId
        /// </summary>
        [JsonPropertyName("violatingNodeId")]
        public int? ViolatingNodeId
        {
            get;
            set;
        }

        /// <summary>
        /// ViolatingNodeAttribute
        /// </summary>
        [JsonPropertyName("violatingNodeAttribute")]
        public string ViolatingNodeAttribute
        {
            get;
            set;
        }

        /// <summary>
        /// Request
        /// </summary>
        [JsonPropertyName("request")]
        public CefSharp.DevTools.Audits.AffectedRequest Request
        {
            get;
            set;
        }
    }

    /// <summary>
    /// This issue tracks information needed to print a deprecation message.
    /// https://source.chromium.org/chromium/chromium/src/+/main:third_party/blink/renderer/core/frame/third_party/blink/renderer/core/frame/deprecation/README.md
    /// </summary>
    public partial class DeprecationIssueDetails : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// AffectedFrame
        /// </summary>
        [JsonPropertyName("affectedFrame")]
        public CefSharp.DevTools.Audits.AffectedFrame AffectedFrame
        {
            get;
            set;
        }

        /// <summary>
        /// SourceCodeLocation
        /// </summary>
        [JsonPropertyName("sourceCodeLocation")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.Audits.SourceCodeLocation SourceCodeLocation
        {
            get;
            set;
        }

        /// <summary>
        /// One of the deprecation names from third_party/blink/renderer/core/frame/deprecation/deprecation.json5
        /// </summary>
        [JsonPropertyName("type")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Type
        {
            get;
            set;
        }
    }

    /// <summary>
    /// This issue warns about sites in the redirect chain of a finished navigation
    /// that may be flagged as trackers and have their state cleared if they don&apos;t
    /// receive a user interaction. Note that in this context &apos;site&apos; means eTLD+1.
    /// For example, if the URL `https://example.test:80/bounce` was in the
    /// redirect chain, the site reported would be `example.test`.
    /// </summary>
    public partial class BounceTrackingIssueDetails : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// TrackingSites
        /// </summary>
        [JsonPropertyName("trackingSites")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string[] TrackingSites
        {
            get;
            set;
        }
    }

    /// <summary>
    /// This issue warns about third-party sites that are accessing cookies on the
    /// current page, and have been permitted due to having a global metadata grant.
    /// Note that in this context &apos;site&apos; means eTLD+1. For example, if the URL
    /// `https://example.test:80/web_page` was accessing cookies, the site reported
    /// would be `example.test`.
    /// </summary>
    public partial class CookieDeprecationMetadataIssueDetails : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// AllowedSites
        /// </summary>
        [JsonPropertyName("allowedSites")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string[] AllowedSites
        {
            get;
            set;
        }

        /// <summary>
        /// OptOutPercentage
        /// </summary>
        [JsonPropertyName("optOutPercentage")]
        public double OptOutPercentage
        {
            get;
            set;
        }

        /// <summary>
        /// IsOptOutTopLevel
        /// </summary>
        [JsonPropertyName("isOptOutTopLevel")]
        public bool IsOptOutTopLevel
        {
            get;
            set;
        }

        /// <summary>
        /// Operation
        /// </summary>
        [JsonPropertyName("operation")]
        public CefSharp.DevTools.Audits.CookieOperation Operation
        {
            get;
            set;
        }
    }

    /// <summary>
    /// ClientHintIssueReason
    /// </summary>
    public enum ClientHintIssueReason
    {
        /// <summary>
        /// MetaTagAllowListInvalidOrigin
        /// </summary>
        [JsonPropertyName("MetaTagAllowListInvalidOrigin")]
        MetaTagAllowListInvalidOrigin,
        /// <summary>
        /// MetaTagModifiedHTML
        /// </summary>
        [JsonPropertyName("MetaTagModifiedHTML")]
        MetaTagModifiedHTML
    }

    /// <summary>
    /// FederatedAuthRequestIssueDetails
    /// </summary>
    public partial class FederatedAuthRequestIssueDetails : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// FederatedAuthRequestIssueReason
        /// </summary>
        [JsonPropertyName("federatedAuthRequestIssueReason")]
        public CefSharp.DevTools.Audits.FederatedAuthRequestIssueReason FederatedAuthRequestIssueReason
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Represents the failure reason when a federated authentication reason fails.
    /// Should be updated alongside RequestIdTokenStatus in
    /// third_party/blink/public/mojom/devtools/inspector_issue.mojom to include
    /// all cases except for success.
    /// </summary>
    public enum FederatedAuthRequestIssueReason
    {
        /// <summary>
        /// ShouldEmbargo
        /// </summary>
        [JsonPropertyName("ShouldEmbargo")]
        ShouldEmbargo,
        /// <summary>
        /// TooManyRequests
        /// </summary>
        [JsonPropertyName("TooManyRequests")]
        TooManyRequests,
        /// <summary>
        /// WellKnownHttpNotFound
        /// </summary>
        [JsonPropertyName("WellKnownHttpNotFound")]
        WellKnownHttpNotFound,
        /// <summary>
        /// WellKnownNoResponse
        /// </summary>
        [JsonPropertyName("WellKnownNoResponse")]
        WellKnownNoResponse,
        /// <summary>
        /// WellKnownInvalidResponse
        /// </summary>
        [JsonPropertyName("WellKnownInvalidResponse")]
        WellKnownInvalidResponse,
        /// <summary>
        /// WellKnownListEmpty
        /// </summary>
        [JsonPropertyName("WellKnownListEmpty")]
        WellKnownListEmpty,
        /// <summary>
        /// WellKnownInvalidContentType
        /// </summary>
        [JsonPropertyName("WellKnownInvalidContentType")]
        WellKnownInvalidContentType,
        /// <summary>
        /// ConfigNotInWellKnown
        /// </summary>
        [JsonPropertyName("ConfigNotInWellKnown")]
        ConfigNotInWellKnown,
        /// <summary>
        /// WellKnownTooBig
        /// </summary>
        [JsonPropertyName("WellKnownTooBig")]
        WellKnownTooBig,
        /// <summary>
        /// ConfigHttpNotFound
        /// </summary>
        [JsonPropertyName("ConfigHttpNotFound")]
        ConfigHttpNotFound,
        /// <summary>
        /// ConfigNoResponse
        /// </summary>
        [JsonPropertyName("ConfigNoResponse")]
        ConfigNoResponse,
        /// <summary>
        /// ConfigInvalidResponse
        /// </summary>
        [JsonPropertyName("ConfigInvalidResponse")]
        ConfigInvalidResponse,
        /// <summary>
        /// ConfigInvalidContentType
        /// </summary>
        [JsonPropertyName("ConfigInvalidContentType")]
        ConfigInvalidContentType,
        /// <summary>
        /// ClientMetadataHttpNotFound
        /// </summary>
        [JsonPropertyName("ClientMetadataHttpNotFound")]
        ClientMetadataHttpNotFound,
        /// <summary>
        /// ClientMetadataNoResponse
        /// </summary>
        [JsonPropertyName("ClientMetadataNoResponse")]
        ClientMetadataNoResponse,
        /// <summary>
        /// ClientMetadataInvalidResponse
        /// </summary>
        [JsonPropertyName("ClientMetadataInvalidResponse")]
        ClientMetadataInvalidResponse,
        /// <summary>
        /// ClientMetadataInvalidContentType
        /// </summary>
        [JsonPropertyName("ClientMetadataInvalidContentType")]
        ClientMetadataInvalidContentType,
        /// <summary>
        /// IdpNotPotentiallyTrustworthy
        /// </summary>
        [JsonPropertyName("IdpNotPotentiallyTrustworthy")]
        IdpNotPotentiallyTrustworthy,
        /// <summary>
        /// DisabledInSettings
        /// </summary>
        [JsonPropertyName("DisabledInSettings")]
        DisabledInSettings,
        /// <summary>
        /// DisabledInFlags
        /// </summary>
        [JsonPropertyName("DisabledInFlags")]
        DisabledInFlags,
        /// <summary>
        /// ErrorFetchingSignin
        /// </summary>
        [JsonPropertyName("ErrorFetchingSignin")]
        ErrorFetchingSignin,
        /// <summary>
        /// InvalidSigninResponse
        /// </summary>
        [JsonPropertyName("InvalidSigninResponse")]
        InvalidSigninResponse,
        /// <summary>
        /// AccountsHttpNotFound
        /// </summary>
        [JsonPropertyName("AccountsHttpNotFound")]
        AccountsHttpNotFound,
        /// <summary>
        /// AccountsNoResponse
        /// </summary>
        [JsonPropertyName("AccountsNoResponse")]
        AccountsNoResponse,
        /// <summary>
        /// AccountsInvalidResponse
        /// </summary>
        [JsonPropertyName("AccountsInvalidResponse")]
        AccountsInvalidResponse,
        /// <summary>
        /// AccountsListEmpty
        /// </summary>
        [JsonPropertyName("AccountsListEmpty")]
        AccountsListEmpty,
        /// <summary>
        /// AccountsInvalidContentType
        /// </summary>
        [JsonPropertyName("AccountsInvalidContentType")]
        AccountsInvalidContentType,
        /// <summary>
        /// IdTokenHttpNotFound
        /// </summary>
        [JsonPropertyName("IdTokenHttpNotFound")]
        IdTokenHttpNotFound,
        /// <summary>
        /// IdTokenNoResponse
        /// </summary>
        [JsonPropertyName("IdTokenNoResponse")]
        IdTokenNoResponse,
        /// <summary>
        /// IdTokenInvalidResponse
        /// </summary>
        [JsonPropertyName("IdTokenInvalidResponse")]
        IdTokenInvalidResponse,
        /// <summary>
        /// IdTokenIdpErrorResponse
        /// </summary>
        [JsonPropertyName("IdTokenIdpErrorResponse")]
        IdTokenIdpErrorResponse,
        /// <summary>
        /// IdTokenCrossSiteIdpErrorResponse
        /// </summary>
        [JsonPropertyName("IdTokenCrossSiteIdpErrorResponse")]
        IdTokenCrossSiteIdpErrorResponse,
        /// <summary>
        /// IdTokenInvalidRequest
        /// </summary>
        [JsonPropertyName("IdTokenInvalidRequest")]
        IdTokenInvalidRequest,
        /// <summary>
        /// IdTokenInvalidContentType
        /// </summary>
        [JsonPropertyName("IdTokenInvalidContentType")]
        IdTokenInvalidContentType,
        /// <summary>
        /// ErrorIdToken
        /// </summary>
        [JsonPropertyName("ErrorIdToken")]
        ErrorIdToken,
        /// <summary>
        /// Canceled
        /// </summary>
        [JsonPropertyName("Canceled")]
        Canceled,
        /// <summary>
        /// RpPageNotVisible
        /// </summary>
        [JsonPropertyName("RpPageNotVisible")]
        RpPageNotVisible,
        /// <summary>
        /// SilentMediationFailure
        /// </summary>
        [JsonPropertyName("SilentMediationFailure")]
        SilentMediationFailure,
        /// <summary>
        /// ThirdPartyCookiesBlocked
        /// </summary>
        [JsonPropertyName("ThirdPartyCookiesBlocked")]
        ThirdPartyCookiesBlocked,
        /// <summary>
        /// NotSignedInWithIdp
        /// </summary>
        [JsonPropertyName("NotSignedInWithIdp")]
        NotSignedInWithIdp,
        /// <summary>
        /// MissingTransientUserActivation
        /// </summary>
        [JsonPropertyName("MissingTransientUserActivation")]
        MissingTransientUserActivation,
        /// <summary>
        /// ReplacedByButtonMode
        /// </summary>
        [JsonPropertyName("ReplacedByButtonMode")]
        ReplacedByButtonMode,
        /// <summary>
        /// InvalidFieldsSpecified
        /// </summary>
        [JsonPropertyName("InvalidFieldsSpecified")]
        InvalidFieldsSpecified,
        /// <summary>
        /// RelyingPartyOriginIsOpaque
        /// </summary>
        [JsonPropertyName("RelyingPartyOriginIsOpaque")]
        RelyingPartyOriginIsOpaque,
        /// <summary>
        /// TypeNotMatching
        /// </summary>
        [JsonPropertyName("TypeNotMatching")]
        TypeNotMatching
    }

    /// <summary>
    /// FederatedAuthUserInfoRequestIssueDetails
    /// </summary>
    public partial class FederatedAuthUserInfoRequestIssueDetails : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// FederatedAuthUserInfoRequestIssueReason
        /// </summary>
        [JsonPropertyName("federatedAuthUserInfoRequestIssueReason")]
        public CefSharp.DevTools.Audits.FederatedAuthUserInfoRequestIssueReason FederatedAuthUserInfoRequestIssueReason
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Represents the failure reason when a getUserInfo() call fails.
    /// Should be updated alongside FederatedAuthUserInfoRequestResult in
    /// third_party/blink/public/mojom/devtools/inspector_issue.mojom.
    /// </summary>
    public enum FederatedAuthUserInfoRequestIssueReason
    {
        /// <summary>
        /// NotSameOrigin
        /// </summary>
        [JsonPropertyName("NotSameOrigin")]
        NotSameOrigin,
        /// <summary>
        /// NotIframe
        /// </summary>
        [JsonPropertyName("NotIframe")]
        NotIframe,
        /// <summary>
        /// NotPotentiallyTrustworthy
        /// </summary>
        [JsonPropertyName("NotPotentiallyTrustworthy")]
        NotPotentiallyTrustworthy,
        /// <summary>
        /// NoApiPermission
        /// </summary>
        [JsonPropertyName("NoApiPermission")]
        NoApiPermission,
        /// <summary>
        /// NotSignedInWithIdp
        /// </summary>
        [JsonPropertyName("NotSignedInWithIdp")]
        NotSignedInWithIdp,
        /// <summary>
        /// NoAccountSharingPermission
        /// </summary>
        [JsonPropertyName("NoAccountSharingPermission")]
        NoAccountSharingPermission,
        /// <summary>
        /// InvalidConfigOrWellKnown
        /// </summary>
        [JsonPropertyName("InvalidConfigOrWellKnown")]
        InvalidConfigOrWellKnown,
        /// <summary>
        /// InvalidAccountsResponse
        /// </summary>
        [JsonPropertyName("InvalidAccountsResponse")]
        InvalidAccountsResponse,
        /// <summary>
        /// NoReturningUserFromFetchedAccounts
        /// </summary>
        [JsonPropertyName("NoReturningUserFromFetchedAccounts")]
        NoReturningUserFromFetchedAccounts
    }

    /// <summary>
    /// This issue tracks client hints related issues. It&apos;s used to deprecate old
    /// features, encourage the use of new ones, and provide general guidance.
    /// </summary>
    public partial class ClientHintIssueDetails : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// SourceCodeLocation
        /// </summary>
        [JsonPropertyName("sourceCodeLocation")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.Audits.SourceCodeLocation SourceCodeLocation
        {
            get;
            set;
        }

        /// <summary>
        /// ClientHintIssueReason
        /// </summary>
        [JsonPropertyName("clientHintIssueReason")]
        public CefSharp.DevTools.Audits.ClientHintIssueReason ClientHintIssueReason
        {
            get;
            set;
        }
    }

    /// <summary>
    /// FailedRequestInfo
    /// </summary>
    public partial class FailedRequestInfo : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The URL that failed to load.
        /// </summary>
        [JsonPropertyName("url")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Url
        {
            get;
            set;
        }

        /// <summary>
        /// The failure message for the failed request.
        /// </summary>
        [JsonPropertyName("failureMessage")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string FailureMessage
        {
            get;
            set;
        }

        /// <summary>
        /// RequestId
        /// </summary>
        [JsonPropertyName("requestId")]
        public string RequestId
        {
            get;
            set;
        }
    }

    /// <summary>
    /// StyleSheetLoadingIssueReason
    /// </summary>
    public enum StyleSheetLoadingIssueReason
    {
        /// <summary>
        /// LateImportRule
        /// </summary>
        [JsonPropertyName("LateImportRule")]
        LateImportRule,
        /// <summary>
        /// RequestFailed
        /// </summary>
        [JsonPropertyName("RequestFailed")]
        RequestFailed
    }

    /// <summary>
    /// This issue warns when a referenced stylesheet couldn&apos;t be loaded.
    /// </summary>
    public partial class StylesheetLoadingIssueDetails : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Source code position that referenced the failing stylesheet.
        /// </summary>
        [JsonPropertyName("sourceCodeLocation")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.Audits.SourceCodeLocation SourceCodeLocation
        {
            get;
            set;
        }

        /// <summary>
        /// Reason why the stylesheet couldn&apos;t be loaded.
        /// </summary>
        [JsonPropertyName("styleSheetLoadingIssueReason")]
        public CefSharp.DevTools.Audits.StyleSheetLoadingIssueReason StyleSheetLoadingIssueReason
        {
            get;
            set;
        }

        /// <summary>
        /// Contains additional info when the failure was due to a request.
        /// </summary>
        [JsonPropertyName("failedRequestInfo")]
        public CefSharp.DevTools.Audits.FailedRequestInfo FailedRequestInfo
        {
            get;
            set;
        }
    }

    /// <summary>
    /// PropertyRuleIssueReason
    /// </summary>
    public enum PropertyRuleIssueReason
    {
        /// <summary>
        /// InvalidSyntax
        /// </summary>
        [JsonPropertyName("InvalidSyntax")]
        InvalidSyntax,
        /// <summary>
        /// InvalidInitialValue
        /// </summary>
        [JsonPropertyName("InvalidInitialValue")]
        InvalidInitialValue,
        /// <summary>
        /// InvalidInherits
        /// </summary>
        [JsonPropertyName("InvalidInherits")]
        InvalidInherits,
        /// <summary>
        /// InvalidName
        /// </summary>
        [JsonPropertyName("InvalidName")]
        InvalidName
    }

    /// <summary>
    /// This issue warns about errors in property rules that lead to property
    /// registrations being ignored.
    /// </summary>
    public partial class PropertyRuleIssueDetails : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Source code position of the property rule.
        /// </summary>
        [JsonPropertyName("sourceCodeLocation")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.Audits.SourceCodeLocation SourceCodeLocation
        {
            get;
            set;
        }

        /// <summary>
        /// Reason why the property rule was discarded.
        /// </summary>
        [JsonPropertyName("propertyRuleIssueReason")]
        public CefSharp.DevTools.Audits.PropertyRuleIssueReason PropertyRuleIssueReason
        {
            get;
            set;
        }

        /// <summary>
        /// The value of the property rule property that failed to parse
        /// </summary>
        [JsonPropertyName("propertyValue")]
        public string PropertyValue
        {
            get;
            set;
        }
    }

    /// <summary>
    /// A unique identifier for the type of issue. Each type may use one of the
    /// optional fields in InspectorIssueDetails to convey more specific
    /// information about the kind of issue.
    /// </summary>
    public enum InspectorIssueCode
    {
        /// <summary>
        /// CookieIssue
        /// </summary>
        [JsonPropertyName("CookieIssue")]
        CookieIssue,
        /// <summary>
        /// MixedContentIssue
        /// </summary>
        [JsonPropertyName("MixedContentIssue")]
        MixedContentIssue,
        /// <summary>
        /// BlockedByResponseIssue
        /// </summary>
        [JsonPropertyName("BlockedByResponseIssue")]
        BlockedByResponseIssue,
        /// <summary>
        /// HeavyAdIssue
        /// </summary>
        [JsonPropertyName("HeavyAdIssue")]
        HeavyAdIssue,
        /// <summary>
        /// ContentSecurityPolicyIssue
        /// </summary>
        [JsonPropertyName("ContentSecurityPolicyIssue")]
        ContentSecurityPolicyIssue,
        /// <summary>
        /// SharedArrayBufferIssue
        /// </summary>
        [JsonPropertyName("SharedArrayBufferIssue")]
        SharedArrayBufferIssue,
        /// <summary>
        /// LowTextContrastIssue
        /// </summary>
        [JsonPropertyName("LowTextContrastIssue")]
        LowTextContrastIssue,
        /// <summary>
        /// CorsIssue
        /// </summary>
        [JsonPropertyName("CorsIssue")]
        CorsIssue,
        /// <summary>
        /// AttributionReportingIssue
        /// </summary>
        [JsonPropertyName("AttributionReportingIssue")]
        AttributionReportingIssue,
        /// <summary>
        /// QuirksModeIssue
        /// </summary>
        [JsonPropertyName("QuirksModeIssue")]
        QuirksModeIssue,
        /// <summary>
        /// NavigatorUserAgentIssue
        /// </summary>
        [JsonPropertyName("NavigatorUserAgentIssue")]
        NavigatorUserAgentIssue,
        /// <summary>
        /// GenericIssue
        /// </summary>
        [JsonPropertyName("GenericIssue")]
        GenericIssue,
        /// <summary>
        /// DeprecationIssue
        /// </summary>
        [JsonPropertyName("DeprecationIssue")]
        DeprecationIssue,
        /// <summary>
        /// ClientHintIssue
        /// </summary>
        [JsonPropertyName("ClientHintIssue")]
        ClientHintIssue,
        /// <summary>
        /// FederatedAuthRequestIssue
        /// </summary>
        [JsonPropertyName("FederatedAuthRequestIssue")]
        FederatedAuthRequestIssue,
        /// <summary>
        /// BounceTrackingIssue
        /// </summary>
        [JsonPropertyName("BounceTrackingIssue")]
        BounceTrackingIssue,
        /// <summary>
        /// CookieDeprecationMetadataIssue
        /// </summary>
        [JsonPropertyName("CookieDeprecationMetadataIssue")]
        CookieDeprecationMetadataIssue,
        /// <summary>
        /// StylesheetLoadingIssue
        /// </summary>
        [JsonPropertyName("StylesheetLoadingIssue")]
        StylesheetLoadingIssue,
        /// <summary>
        /// FederatedAuthUserInfoRequestIssue
        /// </summary>
        [JsonPropertyName("FederatedAuthUserInfoRequestIssue")]
        FederatedAuthUserInfoRequestIssue,
        /// <summary>
        /// PropertyRuleIssue
        /// </summary>
        [JsonPropertyName("PropertyRuleIssue")]
        PropertyRuleIssue,
        /// <summary>
        /// SharedDictionaryIssue
        /// </summary>
        [JsonPropertyName("SharedDictionaryIssue")]
        SharedDictionaryIssue
    }

    /// <summary>
    /// This struct holds a list of optional fields with additional information
    /// specific to the kind of issue. When adding a new issue code, please also
    /// add a new optional field to this type.
    /// </summary>
    public partial class InspectorIssueDetails : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// CookieIssueDetails
        /// </summary>
        [JsonPropertyName("cookieIssueDetails")]
        public CefSharp.DevTools.Audits.CookieIssueDetails CookieIssueDetails
        {
            get;
            set;
        }

        /// <summary>
        /// MixedContentIssueDetails
        /// </summary>
        [JsonPropertyName("mixedContentIssueDetails")]
        public CefSharp.DevTools.Audits.MixedContentIssueDetails MixedContentIssueDetails
        {
            get;
            set;
        }

        /// <summary>
        /// BlockedByResponseIssueDetails
        /// </summary>
        [JsonPropertyName("blockedByResponseIssueDetails")]
        public CefSharp.DevTools.Audits.BlockedByResponseIssueDetails BlockedByResponseIssueDetails
        {
            get;
            set;
        }

        /// <summary>
        /// HeavyAdIssueDetails
        /// </summary>
        [JsonPropertyName("heavyAdIssueDetails")]
        public CefSharp.DevTools.Audits.HeavyAdIssueDetails HeavyAdIssueDetails
        {
            get;
            set;
        }

        /// <summary>
        /// ContentSecurityPolicyIssueDetails
        /// </summary>
        [JsonPropertyName("contentSecurityPolicyIssueDetails")]
        public CefSharp.DevTools.Audits.ContentSecurityPolicyIssueDetails ContentSecurityPolicyIssueDetails
        {
            get;
            set;
        }

        /// <summary>
        /// SharedArrayBufferIssueDetails
        /// </summary>
        [JsonPropertyName("sharedArrayBufferIssueDetails")]
        public CefSharp.DevTools.Audits.SharedArrayBufferIssueDetails SharedArrayBufferIssueDetails
        {
            get;
            set;
        }

        /// <summary>
        /// LowTextContrastIssueDetails
        /// </summary>
        [JsonPropertyName("lowTextContrastIssueDetails")]
        public CefSharp.DevTools.Audits.LowTextContrastIssueDetails LowTextContrastIssueDetails
        {
            get;
            set;
        }

        /// <summary>
        /// CorsIssueDetails
        /// </summary>
        [JsonPropertyName("corsIssueDetails")]
        public CefSharp.DevTools.Audits.CorsIssueDetails CorsIssueDetails
        {
            get;
            set;
        }

        /// <summary>
        /// AttributionReportingIssueDetails
        /// </summary>
        [JsonPropertyName("attributionReportingIssueDetails")]
        public CefSharp.DevTools.Audits.AttributionReportingIssueDetails AttributionReportingIssueDetails
        {
            get;
            set;
        }

        /// <summary>
        /// QuirksModeIssueDetails
        /// </summary>
        [JsonPropertyName("quirksModeIssueDetails")]
        public CefSharp.DevTools.Audits.QuirksModeIssueDetails QuirksModeIssueDetails
        {
            get;
            set;
        }

        /// <summary>
        /// NavigatorUserAgentIssueDetails
        /// </summary>
        [JsonPropertyName("navigatorUserAgentIssueDetails")]
        public CefSharp.DevTools.Audits.NavigatorUserAgentIssueDetails NavigatorUserAgentIssueDetails
        {
            get;
            set;
        }

        /// <summary>
        /// GenericIssueDetails
        /// </summary>
        [JsonPropertyName("genericIssueDetails")]
        public CefSharp.DevTools.Audits.GenericIssueDetails GenericIssueDetails
        {
            get;
            set;
        }

        /// <summary>
        /// DeprecationIssueDetails
        /// </summary>
        [JsonPropertyName("deprecationIssueDetails")]
        public CefSharp.DevTools.Audits.DeprecationIssueDetails DeprecationIssueDetails
        {
            get;
            set;
        }

        /// <summary>
        /// ClientHintIssueDetails
        /// </summary>
        [JsonPropertyName("clientHintIssueDetails")]
        public CefSharp.DevTools.Audits.ClientHintIssueDetails ClientHintIssueDetails
        {
            get;
            set;
        }

        /// <summary>
        /// FederatedAuthRequestIssueDetails
        /// </summary>
        [JsonPropertyName("federatedAuthRequestIssueDetails")]
        public CefSharp.DevTools.Audits.FederatedAuthRequestIssueDetails FederatedAuthRequestIssueDetails
        {
            get;
            set;
        }

        /// <summary>
        /// BounceTrackingIssueDetails
        /// </summary>
        [JsonPropertyName("bounceTrackingIssueDetails")]
        public CefSharp.DevTools.Audits.BounceTrackingIssueDetails BounceTrackingIssueDetails
        {
            get;
            set;
        }

        /// <summary>
        /// CookieDeprecationMetadataIssueDetails
        /// </summary>
        [JsonPropertyName("cookieDeprecationMetadataIssueDetails")]
        public CefSharp.DevTools.Audits.CookieDeprecationMetadataIssueDetails CookieDeprecationMetadataIssueDetails
        {
            get;
            set;
        }

        /// <summary>
        /// StylesheetLoadingIssueDetails
        /// </summary>
        [JsonPropertyName("stylesheetLoadingIssueDetails")]
        public CefSharp.DevTools.Audits.StylesheetLoadingIssueDetails StylesheetLoadingIssueDetails
        {
            get;
            set;
        }

        /// <summary>
        /// PropertyRuleIssueDetails
        /// </summary>
        [JsonPropertyName("propertyRuleIssueDetails")]
        public CefSharp.DevTools.Audits.PropertyRuleIssueDetails PropertyRuleIssueDetails
        {
            get;
            set;
        }

        /// <summary>
        /// FederatedAuthUserInfoRequestIssueDetails
        /// </summary>
        [JsonPropertyName("federatedAuthUserInfoRequestIssueDetails")]
        public CefSharp.DevTools.Audits.FederatedAuthUserInfoRequestIssueDetails FederatedAuthUserInfoRequestIssueDetails
        {
            get;
            set;
        }

        /// <summary>
        /// SharedDictionaryIssueDetails
        /// </summary>
        [JsonPropertyName("sharedDictionaryIssueDetails")]
        public CefSharp.DevTools.Audits.SharedDictionaryIssueDetails SharedDictionaryIssueDetails
        {
            get;
            set;
        }
    }

    /// <summary>
    /// An inspector issue reported from the back-end.
    /// </summary>
    public partial class InspectorIssue : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Code
        /// </summary>
        [JsonPropertyName("code")]
        public CefSharp.DevTools.Audits.InspectorIssueCode Code
        {
            get;
            set;
        }

        /// <summary>
        /// Details
        /// </summary>
        [JsonPropertyName("details")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.Audits.InspectorIssueDetails Details
        {
            get;
            set;
        }

        /// <summary>
        /// A unique id for this issue. May be omitted if no other entity (e.g.
        /// exception, CDP message, etc.) is referencing this issue.
        /// </summary>
        [JsonPropertyName("issueId")]
        public string IssueId
        {
            get;
            set;
        }
    }

    /// <summary>
    /// issueAdded
    /// </summary>
    public class IssueAddedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Issue
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("issue")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.Audits.InspectorIssue Issue
        {
            get;
            private set;
        }
    }
}

namespace CefSharp.DevTools.Extensions
{
    /// <summary>
    /// Storage areas.
    /// </summary>
    public enum StorageArea
    {
        /// <summary>
        /// session
        /// </summary>
        [JsonPropertyName("session")]
        Session,
        /// <summary>
        /// local
        /// </summary>
        [JsonPropertyName("local")]
        Local,
        /// <summary>
        /// sync
        /// </summary>
        [JsonPropertyName("sync")]
        Sync,
        /// <summary>
        /// managed
        /// </summary>
        [JsonPropertyName("managed")]
        Managed
    }
}

namespace CefSharp.DevTools.Autofill
{
    /// <summary>
    /// CreditCard
    /// </summary>
    public partial class CreditCard : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// 16-digit credit card number.
        /// </summary>
        [JsonPropertyName("number")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Number
        {
            get;
            set;
        }

        /// <summary>
        /// Name of the credit card owner.
        /// </summary>
        [JsonPropertyName("name")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Name
        {
            get;
            set;
        }

        /// <summary>
        /// 2-digit expiry month.
        /// </summary>
        [JsonPropertyName("expiryMonth")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string ExpiryMonth
        {
            get;
            set;
        }

        /// <summary>
        /// 4-digit expiry year.
        /// </summary>
        [JsonPropertyName("expiryYear")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string ExpiryYear
        {
            get;
            set;
        }

        /// <summary>
        /// 3-digit card verification code.
        /// </summary>
        [JsonPropertyName("cvc")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Cvc
        {
            get;
            set;
        }
    }

    /// <summary>
    /// AddressField
    /// </summary>
    public partial class AddressField : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// address field name, for example GIVEN_NAME.
        /// </summary>
        [JsonPropertyName("name")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Name
        {
            get;
            set;
        }

        /// <summary>
        /// address field value, for example Jon Doe.
        /// </summary>
        [JsonPropertyName("value")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Value
        {
            get;
            set;
        }
    }

    /// <summary>
    /// A list of address fields.
    /// </summary>
    public partial class AddressFields : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Fields
        /// </summary>
        [JsonPropertyName("fields")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public System.Collections.Generic.IList<CefSharp.DevTools.Autofill.AddressField> Fields
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Address
    /// </summary>
    public partial class Address : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// fields and values defining an address.
        /// </summary>
        [JsonPropertyName("fields")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public System.Collections.Generic.IList<CefSharp.DevTools.Autofill.AddressField> Fields
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Defines how an address can be displayed like in chrome://settings/addresses.
    /// Address UI is a two dimensional array, each inner array is an &quot;address information line&quot;, and when rendered in a UI surface should be displayed as such.
    /// The following address UI for instance:
    /// [[{name: &quot;GIVE_NAME&quot;, value: &quot;Jon&quot;}, {name: &quot;FAMILY_NAME&quot;, value: &quot;Doe&quot;}], [{name: &quot;CITY&quot;, value: &quot;Munich&quot;}, {name: &quot;ZIP&quot;, value: &quot;81456&quot;}]]
    /// should allow the receiver to render:
    /// Jon Doe
    /// Munich 81456
    /// </summary>
    public partial class AddressUI : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// A two dimension array containing the representation of values from an address profile.
        /// </summary>
        [JsonPropertyName("addressFields")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public System.Collections.Generic.IList<CefSharp.DevTools.Autofill.AddressFields> AddressFields
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Specified whether a filled field was done so by using the html autocomplete attribute or autofill heuristics.
    /// </summary>
    public enum FillingStrategy
    {
        /// <summary>
        /// autocompleteAttribute
        /// </summary>
        [JsonPropertyName("autocompleteAttribute")]
        AutocompleteAttribute,
        /// <summary>
        /// autofillInferred
        /// </summary>
        [JsonPropertyName("autofillInferred")]
        AutofillInferred
    }

    /// <summary>
    /// FilledField
    /// </summary>
    public partial class FilledField : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The type of the field, e.g text, password etc.
        /// </summary>
        [JsonPropertyName("htmlType")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string HtmlType
        {
            get;
            set;
        }

        /// <summary>
        /// the html id
        /// </summary>
        [JsonPropertyName("id")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Id
        {
            get;
            set;
        }

        /// <summary>
        /// the html name
        /// </summary>
        [JsonPropertyName("name")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Name
        {
            get;
            set;
        }

        /// <summary>
        /// the field value
        /// </summary>
        [JsonPropertyName("value")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Value
        {
            get;
            set;
        }

        /// <summary>
        /// The actual field type, e.g FAMILY_NAME
        /// </summary>
        [JsonPropertyName("autofillType")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string AutofillType
        {
            get;
            set;
        }

        /// <summary>
        /// The filling strategy
        /// </summary>
        [JsonPropertyName("fillingStrategy")]
        public CefSharp.DevTools.Autofill.FillingStrategy FillingStrategy
        {
            get;
            set;
        }

        /// <summary>
        /// The frame the field belongs to
        /// </summary>
        [JsonPropertyName("frameId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string FrameId
        {
            get;
            set;
        }

        /// <summary>
        /// The form field&apos;s DOM node
        /// </summary>
        [JsonPropertyName("fieldId")]
        public int FieldId
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Emitted when an address form is filled.
    /// </summary>
    public class AddressFormFilledEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Information about the fields that were filled
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("filledFields")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public System.Collections.Generic.IList<CefSharp.DevTools.Autofill.FilledField> FilledFields
        {
            get;
            private set;
        }

        /// <summary>
        /// An UI representation of the address used to fill the form.
        /// Consists of a 2D array where each child represents an address/profile line.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("addressUi")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.Autofill.AddressUI AddressUi
        {
            get;
            private set;
        }
    }
}

namespace CefSharp.DevTools.BackgroundService
{
    /// <summary>
    /// The Background Service that will be associated with the commands/events.
    /// Every Background Service operates independently, but they share the same
    /// API.
    /// </summary>
    public enum ServiceName
    {
        /// <summary>
        /// backgroundFetch
        /// </summary>
        [JsonPropertyName("backgroundFetch")]
        BackgroundFetch,
        /// <summary>
        /// backgroundSync
        /// </summary>
        [JsonPropertyName("backgroundSync")]
        BackgroundSync,
        /// <summary>
        /// pushMessaging
        /// </summary>
        [JsonPropertyName("pushMessaging")]
        PushMessaging,
        /// <summary>
        /// notifications
        /// </summary>
        [JsonPropertyName("notifications")]
        Notifications,
        /// <summary>
        /// paymentHandler
        /// </summary>
        [JsonPropertyName("paymentHandler")]
        PaymentHandler,
        /// <summary>
        /// periodicBackgroundSync
        /// </summary>
        [JsonPropertyName("periodicBackgroundSync")]
        PeriodicBackgroundSync
    }

    /// <summary>
    /// A key-value pair for additional event information to pass along.
    /// </summary>
    public partial class EventMetadata : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Key
        /// </summary>
        [JsonPropertyName("key")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Key
        {
            get;
            set;
        }

        /// <summary>
        /// Value
        /// </summary>
        [JsonPropertyName("value")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Value
        {
            get;
            set;
        }
    }

    /// <summary>
    /// BackgroundServiceEvent
    /// </summary>
    public partial class BackgroundServiceEvent : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Timestamp of the event (in seconds).
        /// </summary>
        [JsonPropertyName("timestamp")]
        public double Timestamp
        {
            get;
            set;
        }

        /// <summary>
        /// The origin this event belongs to.
        /// </summary>
        [JsonPropertyName("origin")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Origin
        {
            get;
            set;
        }

        /// <summary>
        /// The Service Worker ID that initiated the event.
        /// </summary>
        [JsonPropertyName("serviceWorkerRegistrationId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string ServiceWorkerRegistrationId
        {
            get;
            set;
        }

        /// <summary>
        /// The Background Service this event belongs to.
        /// </summary>
        [JsonPropertyName("service")]
        public CefSharp.DevTools.BackgroundService.ServiceName Service
        {
            get;
            set;
        }

        /// <summary>
        /// A description of the event.
        /// </summary>
        [JsonPropertyName("eventName")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string EventName
        {
            get;
            set;
        }

        /// <summary>
        /// An identifier that groups related events together.
        /// </summary>
        [JsonPropertyName("instanceId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string InstanceId
        {
            get;
            set;
        }

        /// <summary>
        /// A list of event-specific information.
        /// </summary>
        [JsonPropertyName("eventMetadata")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public System.Collections.Generic.IList<CefSharp.DevTools.BackgroundService.EventMetadata> EventMetadata
        {
            get;
            set;
        }

        /// <summary>
        /// Storage key this event belongs to.
        /// </summary>
        [JsonPropertyName("storageKey")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string StorageKey
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Called when the recording state for the service has been updated.
    /// </summary>
    public class RecordingStateChangedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// IsRecording
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("isRecording")]
        public bool IsRecording
        {
            get;
            private set;
        }

        /// <summary>
        /// Service
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("service")]
        public CefSharp.DevTools.BackgroundService.ServiceName Service
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Called with all existing backgroundServiceEvents when enabled, and all new
    /// events afterwards if enabled and recording.
    /// </summary>
    public class BackgroundServiceEventReceivedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// BackgroundServiceEvent
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("backgroundServiceEvent")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.BackgroundService.BackgroundServiceEvent BackgroundServiceEvent
        {
            get;
            private set;
        }
    }
}

namespace CefSharp.DevTools.Browser
{
    /// <summary>
    /// The state of the browser window.
    /// </summary>
    public enum WindowState
    {
        /// <summary>
        /// normal
        /// </summary>
        [JsonPropertyName("normal")]
        Normal,
        /// <summary>
        /// minimized
        /// </summary>
        [JsonPropertyName("minimized")]
        Minimized,
        /// <summary>
        /// maximized
        /// </summary>
        [JsonPropertyName("maximized")]
        Maximized,
        /// <summary>
        /// fullscreen
        /// </summary>
        [JsonPropertyName("fullscreen")]
        Fullscreen
    }

    /// <summary>
    /// Browser window bounds information
    /// </summary>
    public partial class Bounds : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The offset from the left edge of the screen to the window in pixels.
        /// </summary>
        [JsonPropertyName("left")]
        public int? Left
        {
            get;
            set;
        }

        /// <summary>
        /// The offset from the top edge of the screen to the window in pixels.
        /// </summary>
        [JsonPropertyName("top")]
        public int? Top
        {
            get;
            set;
        }

        /// <summary>
        /// The window width in pixels.
        /// </summary>
        [JsonPropertyName("width")]
        public int? Width
        {
            get;
            set;
        }

        /// <summary>
        /// The window height in pixels.
        /// </summary>
        [JsonPropertyName("height")]
        public int? Height
        {
            get;
            set;
        }

        /// <summary>
        /// The window state. Default to normal.
        /// </summary>
        [JsonPropertyName("windowState")]
        public CefSharp.DevTools.Browser.WindowState? WindowState
        {
            get;
            set;
        }
    }

    /// <summary>
    /// PermissionType
    /// </summary>
    public enum PermissionType
    {
        /// <summary>
        /// accessibilityEvents
        /// </summary>
        [JsonPropertyName("accessibilityEvents")]
        AccessibilityEvents,
        /// <summary>
        /// audioCapture
        /// </summary>
        [JsonPropertyName("audioCapture")]
        AudioCapture,
        /// <summary>
        /// backgroundSync
        /// </summary>
        [JsonPropertyName("backgroundSync")]
        BackgroundSync,
        /// <summary>
        /// backgroundFetch
        /// </summary>
        [JsonPropertyName("backgroundFetch")]
        BackgroundFetch,
        /// <summary>
        /// capturedSurfaceControl
        /// </summary>
        [JsonPropertyName("capturedSurfaceControl")]
        CapturedSurfaceControl,
        /// <summary>
        /// clipboardReadWrite
        /// </summary>
        [JsonPropertyName("clipboardReadWrite")]
        ClipboardReadWrite,
        /// <summary>
        /// clipboardSanitizedWrite
        /// </summary>
        [JsonPropertyName("clipboardSanitizedWrite")]
        ClipboardSanitizedWrite,
        /// <summary>
        /// displayCapture
        /// </summary>
        [JsonPropertyName("displayCapture")]
        DisplayCapture,
        /// <summary>
        /// durableStorage
        /// </summary>
        [JsonPropertyName("durableStorage")]
        DurableStorage,
        /// <summary>
        /// flash
        /// </summary>
        [JsonPropertyName("flash")]
        Flash,
        /// <summary>
        /// geolocation
        /// </summary>
        [JsonPropertyName("geolocation")]
        Geolocation,
        /// <summary>
        /// idleDetection
        /// </summary>
        [JsonPropertyName("idleDetection")]
        IdleDetection,
        /// <summary>
        /// localFonts
        /// </summary>
        [JsonPropertyName("localFonts")]
        LocalFonts,
        /// <summary>
        /// midi
        /// </summary>
        [JsonPropertyName("midi")]
        Midi,
        /// <summary>
        /// midiSysex
        /// </summary>
        [JsonPropertyName("midiSysex")]
        MidiSysex,
        /// <summary>
        /// nfc
        /// </summary>
        [JsonPropertyName("nfc")]
        Nfc,
        /// <summary>
        /// notifications
        /// </summary>
        [JsonPropertyName("notifications")]
        Notifications,
        /// <summary>
        /// paymentHandler
        /// </summary>
        [JsonPropertyName("paymentHandler")]
        PaymentHandler,
        /// <summary>
        /// periodicBackgroundSync
        /// </summary>
        [JsonPropertyName("periodicBackgroundSync")]
        PeriodicBackgroundSync,
        /// <summary>
        /// protectedMediaIdentifier
        /// </summary>
        [JsonPropertyName("protectedMediaIdentifier")]
        ProtectedMediaIdentifier,
        /// <summary>
        /// sensors
        /// </summary>
        [JsonPropertyName("sensors")]
        Sensors,
        /// <summary>
        /// storageAccess
        /// </summary>
        [JsonPropertyName("storageAccess")]
        StorageAccess,
        /// <summary>
        /// speakerSelection
        /// </summary>
        [JsonPropertyName("speakerSelection")]
        SpeakerSelection,
        /// <summary>
        /// topLevelStorageAccess
        /// </summary>
        [JsonPropertyName("topLevelStorageAccess")]
        TopLevelStorageAccess,
        /// <summary>
        /// videoCapture
        /// </summary>
        [JsonPropertyName("videoCapture")]
        VideoCapture,
        /// <summary>
        /// videoCapturePanTiltZoom
        /// </summary>
        [JsonPropertyName("videoCapturePanTiltZoom")]
        VideoCapturePanTiltZoom,
        /// <summary>
        /// wakeLockScreen
        /// </summary>
        [JsonPropertyName("wakeLockScreen")]
        WakeLockScreen,
        /// <summary>
        /// wakeLockSystem
        /// </summary>
        [JsonPropertyName("wakeLockSystem")]
        WakeLockSystem,
        /// <summary>
        /// windowManagement
        /// </summary>
        [JsonPropertyName("windowManagement")]
        WindowManagement
    }

    /// <summary>
    /// PermissionSetting
    /// </summary>
    public enum PermissionSetting
    {
        /// <summary>
        /// granted
        /// </summary>
        [JsonPropertyName("granted")]
        Granted,
        /// <summary>
        /// denied
        /// </summary>
        [JsonPropertyName("denied")]
        Denied,
        /// <summary>
        /// prompt
        /// </summary>
        [JsonPropertyName("prompt")]
        Prompt
    }

    /// <summary>
    /// Definition of PermissionDescriptor defined in the Permissions API:
    /// https://w3c.github.io/permissions/#dom-permissiondescriptor.
    /// </summary>
    public partial class PermissionDescriptor : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Name of permission.
        /// See https://cs.chromium.org/chromium/src/third_party/blink/renderer/modules/permissions/permission_descriptor.idl for valid permission names.
        /// </summary>
        [JsonPropertyName("name")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Name
        {
            get;
            set;
        }

        /// <summary>
        /// For &quot;midi&quot; permission, may also specify sysex control.
        /// </summary>
        [JsonPropertyName("sysex")]
        public bool? Sysex
        {
            get;
            set;
        }

        /// <summary>
        /// For &quot;push&quot; permission, may specify userVisibleOnly.
        /// Note that userVisibleOnly = true is the only currently supported type.
        /// </summary>
        [JsonPropertyName("userVisibleOnly")]
        public bool? UserVisibleOnly
        {
            get;
            set;
        }

        /// <summary>
        /// For &quot;clipboard&quot; permission, may specify allowWithoutSanitization.
        /// </summary>
        [JsonPropertyName("allowWithoutSanitization")]
        public bool? AllowWithoutSanitization
        {
            get;
            set;
        }

        /// <summary>
        /// For &quot;fullscreen&quot; permission, must specify allowWithoutGesture:true.
        /// </summary>
        [JsonPropertyName("allowWithoutGesture")]
        public bool? AllowWithoutGesture
        {
            get;
            set;
        }

        /// <summary>
        /// For &quot;camera&quot; permission, may specify panTiltZoom.
        /// </summary>
        [JsonPropertyName("panTiltZoom")]
        public bool? PanTiltZoom
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Browser command ids used by executeBrowserCommand.
    /// </summary>
    public enum BrowserCommandId
    {
        /// <summary>
        /// openTabSearch
        /// </summary>
        [JsonPropertyName("openTabSearch")]
        OpenTabSearch,
        /// <summary>
        /// closeTabSearch
        /// </summary>
        [JsonPropertyName("closeTabSearch")]
        CloseTabSearch
    }

    /// <summary>
    /// Chrome histogram bucket.
    /// </summary>
    public partial class Bucket : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Minimum value (inclusive).
        /// </summary>
        [JsonPropertyName("low")]
        public int Low
        {
            get;
            set;
        }

        /// <summary>
        /// Maximum value (exclusive).
        /// </summary>
        [JsonPropertyName("high")]
        public int High
        {
            get;
            set;
        }

        /// <summary>
        /// Number of samples.
        /// </summary>
        [JsonPropertyName("count")]
        public int Count
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Chrome histogram.
    /// </summary>
    public partial class Histogram : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Name.
        /// </summary>
        [JsonPropertyName("name")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Name
        {
            get;
            set;
        }

        /// <summary>
        /// Sum of sample values.
        /// </summary>
        [JsonPropertyName("sum")]
        public int Sum
        {
            get;
            set;
        }

        /// <summary>
        /// Total number of samples.
        /// </summary>
        [JsonPropertyName("count")]
        public int Count
        {
            get;
            set;
        }

        /// <summary>
        /// Buckets.
        /// </summary>
        [JsonPropertyName("buckets")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public System.Collections.Generic.IList<CefSharp.DevTools.Browser.Bucket> Buckets
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Fired when page is about to start a download.
    /// </summary>
    public class DownloadWillBeginEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Id of the frame that caused the download to begin.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("frameId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string FrameId
        {
            get;
            private set;
        }

        /// <summary>
        /// Global unique identifier of the download.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("guid")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Guid
        {
            get;
            private set;
        }

        /// <summary>
        /// URL of the resource being downloaded.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("url")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Url
        {
            get;
            private set;
        }

        /// <summary>
        /// Suggested file name of the resource (the actual name of the file saved on disk may differ).
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("suggestedFilename")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string SuggestedFilename
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Download status.
    /// </summary>
    public enum DownloadProgressState
    {
        /// <summary>
        /// inProgress
        /// </summary>
        [JsonPropertyName("inProgress")]
        InProgress,
        /// <summary>
        /// completed
        /// </summary>
        [JsonPropertyName("completed")]
        Completed,
        /// <summary>
        /// canceled
        /// </summary>
        [JsonPropertyName("canceled")]
        Canceled
    }

    /// <summary>
    /// Fired when download makes progress. Last call has |done| == true.
    /// </summary>
    public class DownloadProgressEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Global unique identifier of the download.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("guid")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Guid
        {
            get;
            private set;
        }

        /// <summary>
        /// Total expected bytes to download.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("totalBytes")]
        public double TotalBytes
        {
            get;
            private set;
        }

        /// <summary>
        /// Total bytes received.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("receivedBytes")]
        public double ReceivedBytes
        {
            get;
            private set;
        }

        /// <summary>
        /// Download status.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("state")]
        public CefSharp.DevTools.Browser.DownloadProgressState State
        {
            get;
            private set;
        }
    }
}

namespace CefSharp.DevTools.CSS
{
    /// <summary>
    /// Stylesheet type: &quot;injected&quot; for stylesheets injected via extension, &quot;user-agent&quot; for user-agent
    /// stylesheets, &quot;inspector&quot; for stylesheets created by the inspector (i.e. those holding the &quot;via
    /// inspector&quot; rules), &quot;regular&quot; for regular stylesheets.
    /// </summary>
    public enum StyleSheetOrigin
    {
        /// <summary>
        /// injected
        /// </summary>
        [JsonPropertyName("injected")]
        Injected,
        /// <summary>
        /// user-agent
        /// </summary>
        [JsonPropertyName("user-agent")]
        UserAgent,
        /// <summary>
        /// inspector
        /// </summary>
        [JsonPropertyName("inspector")]
        Inspector,
        /// <summary>
        /// regular
        /// </summary>
        [JsonPropertyName("regular")]
        Regular
    }

    /// <summary>
    /// CSS rule collection for a single pseudo style.
    /// </summary>
    public partial class PseudoElementMatches : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Pseudo element type.
        /// </summary>
        [JsonPropertyName("pseudoType")]
        public CefSharp.DevTools.DOM.PseudoType PseudoType
        {
            get;
            set;
        }

        /// <summary>
        /// Pseudo element custom ident.
        /// </summary>
        [JsonPropertyName("pseudoIdentifier")]
        public string PseudoIdentifier
        {
            get;
            set;
        }

        /// <summary>
        /// Matches of CSS rules applicable to the pseudo style.
        /// </summary>
        [JsonPropertyName("matches")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public System.Collections.Generic.IList<CefSharp.DevTools.CSS.RuleMatch> Matches
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Inherited CSS rule collection from ancestor node.
    /// </summary>
    public partial class InheritedStyleEntry : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The ancestor node&apos;s inline style, if any, in the style inheritance chain.
        /// </summary>
        [JsonPropertyName("inlineStyle")]
        public CefSharp.DevTools.CSS.CSSStyle InlineStyle
        {
            get;
            set;
        }

        /// <summary>
        /// Matches of CSS rules matching the ancestor node in the style inheritance chain.
        /// </summary>
        [JsonPropertyName("matchedCSSRules")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public System.Collections.Generic.IList<CefSharp.DevTools.CSS.RuleMatch> MatchedCSSRules
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Inherited pseudo element matches from pseudos of an ancestor node.
    /// </summary>
    public partial class InheritedPseudoElementMatches : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Matches of pseudo styles from the pseudos of an ancestor node.
        /// </summary>
        [JsonPropertyName("pseudoElements")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public System.Collections.Generic.IList<CefSharp.DevTools.CSS.PseudoElementMatches> PseudoElements
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Match data for a CSS rule.
    /// </summary>
    public partial class RuleMatch : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// CSS rule in the match.
        /// </summary>
        [JsonPropertyName("rule")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.CSS.CSSRule Rule
        {
            get;
            set;
        }

        /// <summary>
        /// Matching selector indices in the rule&apos;s selectorList selectors (0-based).
        /// </summary>
        [JsonPropertyName("matchingSelectors")]
        public int[] MatchingSelectors
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Data for a simple selector (these are delimited by commas in a selector list).
    /// </summary>
    public partial class Value : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Value text.
        /// </summary>
        [JsonPropertyName("text")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Text
        {
            get;
            set;
        }

        /// <summary>
        /// Value range in the underlying resource (if available).
        /// </summary>
        [JsonPropertyName("range")]
        public CefSharp.DevTools.CSS.SourceRange Range
        {
            get;
            set;
        }

        /// <summary>
        /// Specificity of the selector.
        /// </summary>
        [JsonPropertyName("specificity")]
        public CefSharp.DevTools.CSS.Specificity Specificity
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Specificity:
    /// https://drafts.csswg.org/selectors/#specificity-rules
    /// </summary>
    public partial class Specificity : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The a component, which represents the number of ID selectors.
        /// </summary>
        [JsonPropertyName("a")]
        public int A
        {
            get;
            set;
        }

        /// <summary>
        /// The b component, which represents the number of class selectors, attributes selectors, and
        /// pseudo-classes.
        /// </summary>
        [JsonPropertyName("b")]
        public int B
        {
            get;
            set;
        }

        /// <summary>
        /// The c component, which represents the number of type selectors and pseudo-elements.
        /// </summary>
        [JsonPropertyName("c")]
        public int C
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Selector list data.
    /// </summary>
    public partial class SelectorList : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Selectors in the list.
        /// </summary>
        [JsonPropertyName("selectors")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public System.Collections.Generic.IList<CefSharp.DevTools.CSS.Value> Selectors
        {
            get;
            set;
        }

        /// <summary>
        /// Rule selector text.
        /// </summary>
        [JsonPropertyName("text")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Text
        {
            get;
            set;
        }
    }

    /// <summary>
    /// CSS stylesheet metainformation.
    /// </summary>
    public partial class CSSStyleSheetHeader : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The stylesheet identifier.
        /// </summary>
        [JsonPropertyName("styleSheetId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string StyleSheetId
        {
            get;
            set;
        }

        /// <summary>
        /// Owner frame identifier.
        /// </summary>
        [JsonPropertyName("frameId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string FrameId
        {
            get;
            set;
        }

        /// <summary>
        /// Stylesheet resource URL. Empty if this is a constructed stylesheet created using
        /// new CSSStyleSheet() (but non-empty if this is a constructed stylesheet imported
        /// as a CSS module script).
        /// </summary>
        [JsonPropertyName("sourceURL")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string SourceURL
        {
            get;
            set;
        }

        /// <summary>
        /// URL of source map associated with the stylesheet (if any).
        /// </summary>
        [JsonPropertyName("sourceMapURL")]
        public string SourceMapURL
        {
            get;
            set;
        }

        /// <summary>
        /// Stylesheet origin.
        /// </summary>
        [JsonPropertyName("origin")]
        public CefSharp.DevTools.CSS.StyleSheetOrigin Origin
        {
            get;
            set;
        }

        /// <summary>
        /// Stylesheet title.
        /// </summary>
        [JsonPropertyName("title")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Title
        {
            get;
            set;
        }

        /// <summary>
        /// The backend id for the owner node of the stylesheet.
        /// </summary>
        [JsonPropertyName("ownerNode")]
        public int? OwnerNode
        {
            get;
            set;
        }

        /// <summary>
        /// Denotes whether the stylesheet is disabled.
        /// </summary>
        [JsonPropertyName("disabled")]
        public bool Disabled
        {
            get;
            set;
        }

        /// <summary>
        /// Whether the sourceURL field value comes from the sourceURL comment.
        /// </summary>
        [JsonPropertyName("hasSourceURL")]
        public bool? HasSourceURL
        {
            get;
            set;
        }

        /// <summary>
        /// Whether this stylesheet is created for STYLE tag by parser. This flag is not set for
        /// document.written STYLE tags.
        /// </summary>
        [JsonPropertyName("isInline")]
        public bool IsInline
        {
            get;
            set;
        }

        /// <summary>
        /// Whether this stylesheet is mutable. Inline stylesheets become mutable
        /// after they have been modified via CSSOM API.
        /// `&lt;link&gt;` element&apos;s stylesheets become mutable only if DevTools modifies them.
        /// Constructed stylesheets (new CSSStyleSheet()) are mutable immediately after creation.
        /// </summary>
        [JsonPropertyName("isMutable")]
        public bool IsMutable
        {
            get;
            set;
        }

        /// <summary>
        /// True if this stylesheet is created through new CSSStyleSheet() or imported as a
        /// CSS module script.
        /// </summary>
        [JsonPropertyName("isConstructed")]
        public bool IsConstructed
        {
            get;
            set;
        }

        /// <summary>
        /// Line offset of the stylesheet within the resource (zero based).
        /// </summary>
        [JsonPropertyName("startLine")]
        public double StartLine
        {
            get;
            set;
        }

        /// <summary>
        /// Column offset of the stylesheet within the resource (zero based).
        /// </summary>
        [JsonPropertyName("startColumn")]
        public double StartColumn
        {
            get;
            set;
        }

        /// <summary>
        /// Size of the content (in characters).
        /// </summary>
        [JsonPropertyName("length")]
        public double Length
        {
            get;
            set;
        }

        /// <summary>
        /// Line offset of the end of the stylesheet within the resource (zero based).
        /// </summary>
        [JsonPropertyName("endLine")]
        public double EndLine
        {
            get;
            set;
        }

        /// <summary>
        /// Column offset of the end of the stylesheet within the resource (zero based).
        /// </summary>
        [JsonPropertyName("endColumn")]
        public double EndColumn
        {
            get;
            set;
        }

        /// <summary>
        /// If the style sheet was loaded from a network resource, this indicates when the resource failed to load
        /// </summary>
        [JsonPropertyName("loadingFailed")]
        public bool? LoadingFailed
        {
            get;
            set;
        }
    }

    /// <summary>
    /// CSS rule representation.
    /// </summary>
    public partial class CSSRule : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The css style sheet identifier (absent for user agent stylesheet and user-specified
        /// stylesheet rules) this rule came from.
        /// </summary>
        [JsonPropertyName("styleSheetId")]
        public string StyleSheetId
        {
            get;
            set;
        }

        /// <summary>
        /// Rule selector data.
        /// </summary>
        [JsonPropertyName("selectorList")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.CSS.SelectorList SelectorList
        {
            get;
            set;
        }

        /// <summary>
        /// Array of selectors from ancestor style rules, sorted by distance from the current rule.
        /// </summary>
        [JsonPropertyName("nestingSelectors")]
        public string[] NestingSelectors
        {
            get;
            set;
        }

        /// <summary>
        /// Parent stylesheet&apos;s origin.
        /// </summary>
        [JsonPropertyName("origin")]
        public CefSharp.DevTools.CSS.StyleSheetOrigin Origin
        {
            get;
            set;
        }

        /// <summary>
        /// Associated style declaration.
        /// </summary>
        [JsonPropertyName("style")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.CSS.CSSStyle Style
        {
            get;
            set;
        }

        /// <summary>
        /// Media list array (for rules involving media queries). The array enumerates media queries
        /// starting with the innermost one, going outwards.
        /// </summary>
        [JsonPropertyName("media")]
        public System.Collections.Generic.IList<CefSharp.DevTools.CSS.CSSMedia> Media
        {
            get;
            set;
        }

        /// <summary>
        /// Container query list array (for rules involving container queries).
        /// The array enumerates container queries starting with the innermost one, going outwards.
        /// </summary>
        [JsonPropertyName("containerQueries")]
        public System.Collections.Generic.IList<CefSharp.DevTools.CSS.CSSContainerQuery> ContainerQueries
        {
            get;
            set;
        }

        /// <summary>
        /// @supports CSS at-rule array.
        /// The array enumerates @supports at-rules starting with the innermost one, going outwards.
        /// </summary>
        [JsonPropertyName("supports")]
        public System.Collections.Generic.IList<CefSharp.DevTools.CSS.CSSSupports> Supports
        {
            get;
            set;
        }

        /// <summary>
        /// Cascade layer array. Contains the layer hierarchy that this rule belongs to starting
        /// with the innermost layer and going outwards.
        /// </summary>
        [JsonPropertyName("layers")]
        public System.Collections.Generic.IList<CefSharp.DevTools.CSS.CSSLayer> Layers
        {
            get;
            set;
        }

        /// <summary>
        /// @scope CSS at-rule array.
        /// The array enumerates @scope at-rules starting with the innermost one, going outwards.
        /// </summary>
        [JsonPropertyName("scopes")]
        public System.Collections.Generic.IList<CefSharp.DevTools.CSS.CSSScope> Scopes
        {
            get;
            set;
        }

        /// <summary>
        /// The array keeps the types of ancestor CSSRules from the innermost going outwards.
        /// </summary>
        [JsonPropertyName("ruleTypes")]
        public CefSharp.DevTools.CSS.CSSRuleType[] RuleTypes
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Enum indicating the type of a CSS rule, used to represent the order of a style rule&apos;s ancestors.
    /// This list only contains rule types that are collected during the ancestor rule collection.
    /// </summary>
    public enum CSSRuleType
    {
        /// <summary>
        /// MediaRule
        /// </summary>
        [JsonPropertyName("MediaRule")]
        MediaRule,
        /// <summary>
        /// SupportsRule
        /// </summary>
        [JsonPropertyName("SupportsRule")]
        SupportsRule,
        /// <summary>
        /// ContainerRule
        /// </summary>
        [JsonPropertyName("ContainerRule")]
        ContainerRule,
        /// <summary>
        /// LayerRule
        /// </summary>
        [JsonPropertyName("LayerRule")]
        LayerRule,
        /// <summary>
        /// ScopeRule
        /// </summary>
        [JsonPropertyName("ScopeRule")]
        ScopeRule,
        /// <summary>
        /// StyleRule
        /// </summary>
        [JsonPropertyName("StyleRule")]
        StyleRule
    }

    /// <summary>
    /// CSS coverage information.
    /// </summary>
    public partial class RuleUsage : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The css style sheet identifier (absent for user agent stylesheet and user-specified
        /// stylesheet rules) this rule came from.
        /// </summary>
        [JsonPropertyName("styleSheetId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string StyleSheetId
        {
            get;
            set;
        }

        /// <summary>
        /// Offset of the start of the rule (including selector) from the beginning of the stylesheet.
        /// </summary>
        [JsonPropertyName("startOffset")]
        public double StartOffset
        {
            get;
            set;
        }

        /// <summary>
        /// Offset of the end of the rule body from the beginning of the stylesheet.
        /// </summary>
        [JsonPropertyName("endOffset")]
        public double EndOffset
        {
            get;
            set;
        }

        /// <summary>
        /// Indicates whether the rule was actually used by some element in the page.
        /// </summary>
        [JsonPropertyName("used")]
        public bool Used
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Text range within a resource. All numbers are zero-based.
    /// </summary>
    public partial class SourceRange : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Start line of range.
        /// </summary>
        [JsonPropertyName("startLine")]
        public int StartLine
        {
            get;
            set;
        }

        /// <summary>
        /// Start column of range (inclusive).
        /// </summary>
        [JsonPropertyName("startColumn")]
        public int StartColumn
        {
            get;
            set;
        }

        /// <summary>
        /// End line of range
        /// </summary>
        [JsonPropertyName("endLine")]
        public int EndLine
        {
            get;
            set;
        }

        /// <summary>
        /// End column of range (exclusive).
        /// </summary>
        [JsonPropertyName("endColumn")]
        public int EndColumn
        {
            get;
            set;
        }
    }

    /// <summary>
    /// ShorthandEntry
    /// </summary>
    public partial class ShorthandEntry : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Shorthand name.
        /// </summary>
        [JsonPropertyName("name")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Name
        {
            get;
            set;
        }

        /// <summary>
        /// Shorthand value.
        /// </summary>
        [JsonPropertyName("value")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Value
        {
            get;
            set;
        }

        /// <summary>
        /// Whether the property has &quot;!important&quot; annotation (implies `false` if absent).
        /// </summary>
        [JsonPropertyName("important")]
        public bool? Important
        {
            get;
            set;
        }
    }

    /// <summary>
    /// CSSComputedStyleProperty
    /// </summary>
    public partial class CSSComputedStyleProperty : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Computed style property name.
        /// </summary>
        [JsonPropertyName("name")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Name
        {
            get;
            set;
        }

        /// <summary>
        /// Computed style property value.
        /// </summary>
        [JsonPropertyName("value")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Value
        {
            get;
            set;
        }
    }

    /// <summary>
    /// CSS style representation.
    /// </summary>
    public partial class CSSStyle : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The css style sheet identifier (absent for user agent stylesheet and user-specified
        /// stylesheet rules) this rule came from.
        /// </summary>
        [JsonPropertyName("styleSheetId")]
        public string StyleSheetId
        {
            get;
            set;
        }

        /// <summary>
        /// CSS properties in the style.
        /// </summary>
        [JsonPropertyName("cssProperties")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public System.Collections.Generic.IList<CefSharp.DevTools.CSS.CSSProperty> CssProperties
        {
            get;
            set;
        }

        /// <summary>
        /// Computed values for all shorthands found in the style.
        /// </summary>
        [JsonPropertyName("shorthandEntries")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public System.Collections.Generic.IList<CefSharp.DevTools.CSS.ShorthandEntry> ShorthandEntries
        {
            get;
            set;
        }

        /// <summary>
        /// Style declaration text (if available).
        /// </summary>
        [JsonPropertyName("cssText")]
        public string CssText
        {
            get;
            set;
        }

        /// <summary>
        /// Style declaration range in the enclosing stylesheet (if available).
        /// </summary>
        [JsonPropertyName("range")]
        public CefSharp.DevTools.CSS.SourceRange Range
        {
            get;
            set;
        }
    }

    /// <summary>
    /// CSS property declaration data.
    /// </summary>
    public partial class CSSProperty : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The property name.
        /// </summary>
        [JsonPropertyName("name")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Name
        {
            get;
            set;
        }

        /// <summary>
        /// The property value.
        /// </summary>
        [JsonPropertyName("value")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Value
        {
            get;
            set;
        }

        /// <summary>
        /// Whether the property has &quot;!important&quot; annotation (implies `false` if absent).
        /// </summary>
        [JsonPropertyName("important")]
        public bool? Important
        {
            get;
            set;
        }

        /// <summary>
        /// Whether the property is implicit (implies `false` if absent).
        /// </summary>
        [JsonPropertyName("implicit")]
        public bool? Implicit
        {
            get;
            set;
        }

        /// <summary>
        /// The full property text as specified in the style.
        /// </summary>
        [JsonPropertyName("text")]
        public string Text
        {
            get;
            set;
        }

        /// <summary>
        /// Whether the property is understood by the browser (implies `true` if absent).
        /// </summary>
        [JsonPropertyName("parsedOk")]
        public bool? ParsedOk
        {
            get;
            set;
        }

        /// <summary>
        /// Whether the property is disabled by the user (present for source-based properties only).
        /// </summary>
        [JsonPropertyName("disabled")]
        public bool? Disabled
        {
            get;
            set;
        }

        /// <summary>
        /// The entire property range in the enclosing style declaration (if available).
        /// </summary>
        [JsonPropertyName("range")]
        public CefSharp.DevTools.CSS.SourceRange Range
        {
            get;
            set;
        }

        /// <summary>
        /// Parsed longhand components of this property if it is a shorthand.
        /// This field will be empty if the given property is not a shorthand.
        /// </summary>
        [JsonPropertyName("longhandProperties")]
        public System.Collections.Generic.IList<CefSharp.DevTools.CSS.CSSProperty> LonghandProperties
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Source of the media query: &quot;mediaRule&quot; if specified by a @media rule, &quot;importRule&quot; if
    /// specified by an @import rule, &quot;linkedSheet&quot; if specified by a &quot;media&quot; attribute in a linked
    /// stylesheet&apos;s LINK tag, &quot;inlineSheet&quot; if specified by a &quot;media&quot; attribute in an inline
    /// stylesheet&apos;s STYLE tag.
    /// </summary>
    public enum CSSMediaSource
    {
        /// <summary>
        /// mediaRule
        /// </summary>
        [JsonPropertyName("mediaRule")]
        MediaRule,
        /// <summary>
        /// importRule
        /// </summary>
        [JsonPropertyName("importRule")]
        ImportRule,
        /// <summary>
        /// linkedSheet
        /// </summary>
        [JsonPropertyName("linkedSheet")]
        LinkedSheet,
        /// <summary>
        /// inlineSheet
        /// </summary>
        [JsonPropertyName("inlineSheet")]
        InlineSheet
    }

    /// <summary>
    /// CSS media rule descriptor.
    /// </summary>
    public partial class CSSMedia : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Media query text.
        /// </summary>
        [JsonPropertyName("text")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Text
        {
            get;
            set;
        }

        /// <summary>
        /// Source of the media query: &quot;mediaRule&quot; if specified by a @media rule, &quot;importRule&quot; if
        /// specified by an @import rule, &quot;linkedSheet&quot; if specified by a &quot;media&quot; attribute in a linked
        /// stylesheet&apos;s LINK tag, &quot;inlineSheet&quot; if specified by a &quot;media&quot; attribute in an inline
        /// stylesheet&apos;s STYLE tag.
        /// </summary>
        [JsonPropertyName("source")]
        public CefSharp.DevTools.CSS.CSSMediaSource Source
        {
            get;
            set;
        }

        /// <summary>
        /// URL of the document containing the media query description.
        /// </summary>
        [JsonPropertyName("sourceURL")]
        public string SourceURL
        {
            get;
            set;
        }

        /// <summary>
        /// The associated rule (@media or @import) header range in the enclosing stylesheet (if
        /// available).
        /// </summary>
        [JsonPropertyName("range")]
        public CefSharp.DevTools.CSS.SourceRange Range
        {
            get;
            set;
        }

        /// <summary>
        /// Identifier of the stylesheet containing this object (if exists).
        /// </summary>
        [JsonPropertyName("styleSheetId")]
        public string StyleSheetId
        {
            get;
            set;
        }

        /// <summary>
        /// Array of media queries.
        /// </summary>
        [JsonPropertyName("mediaList")]
        public System.Collections.Generic.IList<CefSharp.DevTools.CSS.MediaQuery> MediaList
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Media query descriptor.
    /// </summary>
    public partial class MediaQuery : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Array of media query expressions.
        /// </summary>
        [JsonPropertyName("expressions")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public System.Collections.Generic.IList<CefSharp.DevTools.CSS.MediaQueryExpression> Expressions
        {
            get;
            set;
        }

        /// <summary>
        /// Whether the media query condition is satisfied.
        /// </summary>
        [JsonPropertyName("active")]
        public bool Active
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Media query expression descriptor.
    /// </summary>
    public partial class MediaQueryExpression : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Media query expression value.
        /// </summary>
        [JsonPropertyName("value")]
        public double Value
        {
            get;
            set;
        }

        /// <summary>
        /// Media query expression units.
        /// </summary>
        [JsonPropertyName("unit")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Unit
        {
            get;
            set;
        }

        /// <summary>
        /// Media query expression feature.
        /// </summary>
        [JsonPropertyName("feature")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Feature
        {
            get;
            set;
        }

        /// <summary>
        /// The associated range of the value text in the enclosing stylesheet (if available).
        /// </summary>
        [JsonPropertyName("valueRange")]
        public CefSharp.DevTools.CSS.SourceRange ValueRange
        {
            get;
            set;
        }

        /// <summary>
        /// Computed length of media query expression (if applicable).
        /// </summary>
        [JsonPropertyName("computedLength")]
        public double? ComputedLength
        {
            get;
            set;
        }
    }

    /// <summary>
    /// CSS container query rule descriptor.
    /// </summary>
    public partial class CSSContainerQuery : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Container query text.
        /// </summary>
        [JsonPropertyName("text")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Text
        {
            get;
            set;
        }

        /// <summary>
        /// The associated rule header range in the enclosing stylesheet (if
        /// available).
        /// </summary>
        [JsonPropertyName("range")]
        public CefSharp.DevTools.CSS.SourceRange Range
        {
            get;
            set;
        }

        /// <summary>
        /// Identifier of the stylesheet containing this object (if exists).
        /// </summary>
        [JsonPropertyName("styleSheetId")]
        public string StyleSheetId
        {
            get;
            set;
        }

        /// <summary>
        /// Optional name for the container.
        /// </summary>
        [JsonPropertyName("name")]
        public string Name
        {
            get;
            set;
        }

        /// <summary>
        /// Optional physical axes queried for the container.
        /// </summary>
        [JsonPropertyName("physicalAxes")]
        public CefSharp.DevTools.DOM.PhysicalAxes? PhysicalAxes
        {
            get;
            set;
        }

        /// <summary>
        /// Optional logical axes queried for the container.
        /// </summary>
        [JsonPropertyName("logicalAxes")]
        public CefSharp.DevTools.DOM.LogicalAxes? LogicalAxes
        {
            get;
            set;
        }
    }

    /// <summary>
    /// CSS Supports at-rule descriptor.
    /// </summary>
    public partial class CSSSupports : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Supports rule text.
        /// </summary>
        [JsonPropertyName("text")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Text
        {
            get;
            set;
        }

        /// <summary>
        /// Whether the supports condition is satisfied.
        /// </summary>
        [JsonPropertyName("active")]
        public bool Active
        {
            get;
            set;
        }

        /// <summary>
        /// The associated rule header range in the enclosing stylesheet (if
        /// available).
        /// </summary>
        [JsonPropertyName("range")]
        public CefSharp.DevTools.CSS.SourceRange Range
        {
            get;
            set;
        }

        /// <summary>
        /// Identifier of the stylesheet containing this object (if exists).
        /// </summary>
        [JsonPropertyName("styleSheetId")]
        public string StyleSheetId
        {
            get;
            set;
        }
    }

    /// <summary>
    /// CSS Scope at-rule descriptor.
    /// </summary>
    public partial class CSSScope : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Scope rule text.
        /// </summary>
        [JsonPropertyName("text")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Text
        {
            get;
            set;
        }

        /// <summary>
        /// The associated rule header range in the enclosing stylesheet (if
        /// available).
        /// </summary>
        [JsonPropertyName("range")]
        public CefSharp.DevTools.CSS.SourceRange Range
        {
            get;
            set;
        }

        /// <summary>
        /// Identifier of the stylesheet containing this object (if exists).
        /// </summary>
        [JsonPropertyName("styleSheetId")]
        public string StyleSheetId
        {
            get;
            set;
        }
    }

    /// <summary>
    /// CSS Layer at-rule descriptor.
    /// </summary>
    public partial class CSSLayer : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Layer name.
        /// </summary>
        [JsonPropertyName("text")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Text
        {
            get;
            set;
        }

        /// <summary>
        /// The associated rule header range in the enclosing stylesheet (if
        /// available).
        /// </summary>
        [JsonPropertyName("range")]
        public CefSharp.DevTools.CSS.SourceRange Range
        {
            get;
            set;
        }

        /// <summary>
        /// Identifier of the stylesheet containing this object (if exists).
        /// </summary>
        [JsonPropertyName("styleSheetId")]
        public string StyleSheetId
        {
            get;
            set;
        }
    }

    /// <summary>
    /// CSS Layer data.
    /// </summary>
    public partial class CSSLayerData : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Layer name.
        /// </summary>
        [JsonPropertyName("name")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Name
        {
            get;
            set;
        }

        /// <summary>
        /// Direct sub-layers
        /// </summary>
        [JsonPropertyName("subLayers")]
        public System.Collections.Generic.IList<CefSharp.DevTools.CSS.CSSLayerData> SubLayers
        {
            get;
            set;
        }

        /// <summary>
        /// Layer order. The order determines the order of the layer in the cascade order.
        /// A higher number has higher priority in the cascade order.
        /// </summary>
        [JsonPropertyName("order")]
        public double Order
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Information about amount of glyphs that were rendered with given font.
    /// </summary>
    public partial class PlatformFontUsage : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Font&apos;s family name reported by platform.
        /// </summary>
        [JsonPropertyName("familyName")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string FamilyName
        {
            get;
            set;
        }

        /// <summary>
        /// Font&apos;s PostScript name reported by platform.
        /// </summary>
        [JsonPropertyName("postScriptName")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string PostScriptName
        {
            get;
            set;
        }

        /// <summary>
        /// Indicates if the font was downloaded or resolved locally.
        /// </summary>
        [JsonPropertyName("isCustomFont")]
        public bool IsCustomFont
        {
            get;
            set;
        }

        /// <summary>
        /// Amount of glyphs that were rendered with this font.
        /// </summary>
        [JsonPropertyName("glyphCount")]
        public double GlyphCount
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Information about font variation axes for variable fonts
    /// </summary>
    public partial class FontVariationAxis : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The font-variation-setting tag (a.k.a. &quot;axis tag&quot;).
        /// </summary>
        [JsonPropertyName("tag")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Tag
        {
            get;
            set;
        }

        /// <summary>
        /// Human-readable variation name in the default language (normally, &quot;en&quot;).
        /// </summary>
        [JsonPropertyName("name")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Name
        {
            get;
            set;
        }

        /// <summary>
        /// The minimum value (inclusive) the font supports for this tag.
        /// </summary>
        [JsonPropertyName("minValue")]
        public double MinValue
        {
            get;
            set;
        }

        /// <summary>
        /// The maximum value (inclusive) the font supports for this tag.
        /// </summary>
        [JsonPropertyName("maxValue")]
        public double MaxValue
        {
            get;
            set;
        }

        /// <summary>
        /// The default value.
        /// </summary>
        [JsonPropertyName("defaultValue")]
        public double DefaultValue
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Properties of a web font: https://www.w3.org/TR/2008/REC-CSS2-20080411/fonts.html#font-descriptions
    /// and additional information such as platformFontFamily and fontVariationAxes.
    /// </summary>
    public partial class FontFace : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The font-family.
        /// </summary>
        [JsonPropertyName("fontFamily")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string FontFamily
        {
            get;
            set;
        }

        /// <summary>
        /// The font-style.
        /// </summary>
        [JsonPropertyName("fontStyle")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string FontStyle
        {
            get;
            set;
        }

        /// <summary>
        /// The font-variant.
        /// </summary>
        [JsonPropertyName("fontVariant")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string FontVariant
        {
            get;
            set;
        }

        /// <summary>
        /// The font-weight.
        /// </summary>
        [JsonPropertyName("fontWeight")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string FontWeight
        {
            get;
            set;
        }

        /// <summary>
        /// The font-stretch.
        /// </summary>
        [JsonPropertyName("fontStretch")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string FontStretch
        {
            get;
            set;
        }

        /// <summary>
        /// The font-display.
        /// </summary>
        [JsonPropertyName("fontDisplay")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string FontDisplay
        {
            get;
            set;
        }

        /// <summary>
        /// The unicode-range.
        /// </summary>
        [JsonPropertyName("unicodeRange")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string UnicodeRange
        {
            get;
            set;
        }

        /// <summary>
        /// The src.
        /// </summary>
        [JsonPropertyName("src")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Src
        {
            get;
            set;
        }

        /// <summary>
        /// The resolved platform font family
        /// </summary>
        [JsonPropertyName("platformFontFamily")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string PlatformFontFamily
        {
            get;
            set;
        }

        /// <summary>
        /// Available variation settings (a.k.a. &quot;axes&quot;).
        /// </summary>
        [JsonPropertyName("fontVariationAxes")]
        public System.Collections.Generic.IList<CefSharp.DevTools.CSS.FontVariationAxis> FontVariationAxes
        {
            get;
            set;
        }
    }

    /// <summary>
    /// CSS try rule representation.
    /// </summary>
    public partial class CSSTryRule : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The css style sheet identifier (absent for user agent stylesheet and user-specified
        /// stylesheet rules) this rule came from.
        /// </summary>
        [JsonPropertyName("styleSheetId")]
        public string StyleSheetId
        {
            get;
            set;
        }

        /// <summary>
        /// Parent stylesheet&apos;s origin.
        /// </summary>
        [JsonPropertyName("origin")]
        public CefSharp.DevTools.CSS.StyleSheetOrigin Origin
        {
            get;
            set;
        }

        /// <summary>
        /// Associated style declaration.
        /// </summary>
        [JsonPropertyName("style")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.CSS.CSSStyle Style
        {
            get;
            set;
        }
    }

    /// <summary>
    /// CSS @position-try rule representation.
    /// </summary>
    public partial class CSSPositionTryRule : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The prelude dashed-ident name
        /// </summary>
        [JsonPropertyName("name")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.CSS.Value Name
        {
            get;
            set;
        }

        /// <summary>
        /// The css style sheet identifier (absent for user agent stylesheet and user-specified
        /// stylesheet rules) this rule came from.
        /// </summary>
        [JsonPropertyName("styleSheetId")]
        public string StyleSheetId
        {
            get;
            set;
        }

        /// <summary>
        /// Parent stylesheet&apos;s origin.
        /// </summary>
        [JsonPropertyName("origin")]
        public CefSharp.DevTools.CSS.StyleSheetOrigin Origin
        {
            get;
            set;
        }

        /// <summary>
        /// Associated style declaration.
        /// </summary>
        [JsonPropertyName("style")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.CSS.CSSStyle Style
        {
            get;
            set;
        }

        /// <summary>
        /// Active
        /// </summary>
        [JsonPropertyName("active")]
        public bool Active
        {
            get;
            set;
        }
    }

    /// <summary>
    /// CSS keyframes rule representation.
    /// </summary>
    public partial class CSSKeyframesRule : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Animation name.
        /// </summary>
        [JsonPropertyName("animationName")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.CSS.Value AnimationName
        {
            get;
            set;
        }

        /// <summary>
        /// List of keyframes.
        /// </summary>
        [JsonPropertyName("keyframes")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public System.Collections.Generic.IList<CefSharp.DevTools.CSS.CSSKeyframeRule> Keyframes
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Representation of a custom property registration through CSS.registerProperty
    /// </summary>
    public partial class CSSPropertyRegistration : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// PropertyName
        /// </summary>
        [JsonPropertyName("propertyName")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string PropertyName
        {
            get;
            set;
        }

        /// <summary>
        /// InitialValue
        /// </summary>
        [JsonPropertyName("initialValue")]
        public CefSharp.DevTools.CSS.Value InitialValue
        {
            get;
            set;
        }

        /// <summary>
        /// Inherits
        /// </summary>
        [JsonPropertyName("inherits")]
        public bool Inherits
        {
            get;
            set;
        }

        /// <summary>
        /// Syntax
        /// </summary>
        [JsonPropertyName("syntax")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Syntax
        {
            get;
            set;
        }
    }

    /// <summary>
    /// CSS font-palette-values rule representation.
    /// </summary>
    public partial class CSSFontPaletteValuesRule : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The css style sheet identifier (absent for user agent stylesheet and user-specified
        /// stylesheet rules) this rule came from.
        /// </summary>
        [JsonPropertyName("styleSheetId")]
        public string StyleSheetId
        {
            get;
            set;
        }

        /// <summary>
        /// Parent stylesheet&apos;s origin.
        /// </summary>
        [JsonPropertyName("origin")]
        public CefSharp.DevTools.CSS.StyleSheetOrigin Origin
        {
            get;
            set;
        }

        /// <summary>
        /// Associated font palette name.
        /// </summary>
        [JsonPropertyName("fontPaletteName")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.CSS.Value FontPaletteName
        {
            get;
            set;
        }

        /// <summary>
        /// Associated style declaration.
        /// </summary>
        [JsonPropertyName("style")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.CSS.CSSStyle Style
        {
            get;
            set;
        }
    }

    /// <summary>
    /// CSS property at-rule representation.
    /// </summary>
    public partial class CSSPropertyRule : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The css style sheet identifier (absent for user agent stylesheet and user-specified
        /// stylesheet rules) this rule came from.
        /// </summary>
        [JsonPropertyName("styleSheetId")]
        public string StyleSheetId
        {
            get;
            set;
        }

        /// <summary>
        /// Parent stylesheet&apos;s origin.
        /// </summary>
        [JsonPropertyName("origin")]
        public CefSharp.DevTools.CSS.StyleSheetOrigin Origin
        {
            get;
            set;
        }

        /// <summary>
        /// Associated property name.
        /// </summary>
        [JsonPropertyName("propertyName")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.CSS.Value PropertyName
        {
            get;
            set;
        }

        /// <summary>
        /// Associated style declaration.
        /// </summary>
        [JsonPropertyName("style")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.CSS.CSSStyle Style
        {
            get;
            set;
        }
    }

    /// <summary>
    /// CSS keyframe rule representation.
    /// </summary>
    public partial class CSSKeyframeRule : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The css style sheet identifier (absent for user agent stylesheet and user-specified
        /// stylesheet rules) this rule came from.
        /// </summary>
        [JsonPropertyName("styleSheetId")]
        public string StyleSheetId
        {
            get;
            set;
        }

        /// <summary>
        /// Parent stylesheet&apos;s origin.
        /// </summary>
        [JsonPropertyName("origin")]
        public CefSharp.DevTools.CSS.StyleSheetOrigin Origin
        {
            get;
            set;
        }

        /// <summary>
        /// Associated key text.
        /// </summary>
        [JsonPropertyName("keyText")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.CSS.Value KeyText
        {
            get;
            set;
        }

        /// <summary>
        /// Associated style declaration.
        /// </summary>
        [JsonPropertyName("style")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.CSS.CSSStyle Style
        {
            get;
            set;
        }
    }

    /// <summary>
    /// A descriptor of operation to mutate style declaration text.
    /// </summary>
    public partial class StyleDeclarationEdit : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The css style sheet identifier.
        /// </summary>
        [JsonPropertyName("styleSheetId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string StyleSheetId
        {
            get;
            set;
        }

        /// <summary>
        /// The range of the style text in the enclosing stylesheet.
        /// </summary>
        [JsonPropertyName("range")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.CSS.SourceRange Range
        {
            get;
            set;
        }

        /// <summary>
        /// New style text.
        /// </summary>
        [JsonPropertyName("text")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Text
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Fires whenever a web font is updated.  A non-empty font parameter indicates a successfully loaded
    /// web font.
    /// </summary>
    public class FontsUpdatedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// The web font that has loaded.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("font")]
        public CefSharp.DevTools.CSS.FontFace Font
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired whenever an active document stylesheet is added.
    /// </summary>
    public class StyleSheetAddedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Added stylesheet metainfo.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("header")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.CSS.CSSStyleSheetHeader Header
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired whenever a stylesheet is changed as a result of the client operation.
    /// </summary>
    public class StyleSheetChangedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// StyleSheetId
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("styleSheetId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string StyleSheetId
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired whenever an active document stylesheet is removed.
    /// </summary>
    public class StyleSheetRemovedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Identifier of the removed stylesheet.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("styleSheetId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string StyleSheetId
        {
            get;
            private set;
        }
    }
}

namespace CefSharp.DevTools.CacheStorage
{
    /// <summary>
    /// type of HTTP response cached
    /// </summary>
    public enum CachedResponseType
    {
        /// <summary>
        /// basic
        /// </summary>
        [JsonPropertyName("basic")]
        Basic,
        /// <summary>
        /// cors
        /// </summary>
        [JsonPropertyName("cors")]
        Cors,
        /// <summary>
        /// default
        /// </summary>
        [JsonPropertyName("default")]
        Default,
        /// <summary>
        /// error
        /// </summary>
        [JsonPropertyName("error")]
        Error,
        /// <summary>
        /// opaqueResponse
        /// </summary>
        [JsonPropertyName("opaqueResponse")]
        OpaqueResponse,
        /// <summary>
        /// opaqueRedirect
        /// </summary>
        [JsonPropertyName("opaqueRedirect")]
        OpaqueRedirect
    }

    /// <summary>
    /// Data entry.
    /// </summary>
    public partial class DataEntry : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Request URL.
        /// </summary>
        [JsonPropertyName("requestURL")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string RequestURL
        {
            get;
            set;
        }

        /// <summary>
        /// Request method.
        /// </summary>
        [JsonPropertyName("requestMethod")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string RequestMethod
        {
            get;
            set;
        }

        /// <summary>
        /// Request headers
        /// </summary>
        [JsonPropertyName("requestHeaders")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public System.Collections.Generic.IList<CefSharp.DevTools.CacheStorage.Header> RequestHeaders
        {
            get;
            set;
        }

        /// <summary>
        /// Number of seconds since epoch.
        /// </summary>
        [JsonPropertyName("responseTime")]
        public double ResponseTime
        {
            get;
            set;
        }

        /// <summary>
        /// HTTP response status code.
        /// </summary>
        [JsonPropertyName("responseStatus")]
        public int ResponseStatus
        {
            get;
            set;
        }

        /// <summary>
        /// HTTP response status text.
        /// </summary>
        [JsonPropertyName("responseStatusText")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string ResponseStatusText
        {
            get;
            set;
        }

        /// <summary>
        /// HTTP response type
        /// </summary>
        [JsonPropertyName("responseType")]
        public CefSharp.DevTools.CacheStorage.CachedResponseType ResponseType
        {
            get;
            set;
        }

        /// <summary>
        /// Response headers
        /// </summary>
        [JsonPropertyName("responseHeaders")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public System.Collections.Generic.IList<CefSharp.DevTools.CacheStorage.Header> ResponseHeaders
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Cache identifier.
    /// </summary>
    public partial class Cache : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// An opaque unique id of the cache.
        /// </summary>
        [JsonPropertyName("cacheId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string CacheId
        {
            get;
            set;
        }

        /// <summary>
        /// Security origin of the cache.
        /// </summary>
        [JsonPropertyName("securityOrigin")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string SecurityOrigin
        {
            get;
            set;
        }

        /// <summary>
        /// Storage key of the cache.
        /// </summary>
        [JsonPropertyName("storageKey")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string StorageKey
        {
            get;
            set;
        }

        /// <summary>
        /// Storage bucket of the cache.
        /// </summary>
        [JsonPropertyName("storageBucket")]
        public CefSharp.DevTools.Storage.StorageBucket StorageBucket
        {
            get;
            set;
        }

        /// <summary>
        /// The name of the cache.
        /// </summary>
        [JsonPropertyName("cacheName")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string CacheName
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Header
    /// </summary>
    public partial class Header : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Name
        /// </summary>
        [JsonPropertyName("name")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Name
        {
            get;
            set;
        }

        /// <summary>
        /// Value
        /// </summary>
        [JsonPropertyName("value")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Value
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Cached response
    /// </summary>
    public partial class CachedResponse : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Entry content, base64-encoded.
        /// </summary>
        [JsonPropertyName("body")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public byte[] Body
        {
            get;
            set;
        }
    }
}

namespace CefSharp.DevTools.Cast
{
    /// <summary>
    /// Sink
    /// </summary>
    public partial class Sink : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Name
        /// </summary>
        [JsonPropertyName("name")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Name
        {
            get;
            set;
        }

        /// <summary>
        /// Id
        /// </summary>
        [JsonPropertyName("id")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Id
        {
            get;
            set;
        }

        /// <summary>
        /// Text describing the current session. Present only if there is an active
        /// session on the sink.
        /// </summary>
        [JsonPropertyName("session")]
        public string Session
        {
            get;
            set;
        }
    }

    /// <summary>
    /// This is fired whenever the list of available sinks changes. A sink is a
    /// device or a software surface that you can cast to.
    /// </summary>
    public class SinksUpdatedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Sinks
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("sinks")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public System.Collections.Generic.IList<CefSharp.DevTools.Cast.Sink> Sinks
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// This is fired whenever the outstanding issue/error message changes.
    /// |issueMessage| is empty if there is no issue.
    /// </summary>
    public class IssueUpdatedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// IssueMessage
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("issueMessage")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string IssueMessage
        {
            get;
            private set;
        }
    }
}

namespace CefSharp.DevTools.DOM
{
    /// <summary>
    /// Backend node with a friendly name.
    /// </summary>
    public partial class BackendNode : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// `Node`&apos;s nodeType.
        /// </summary>
        [JsonPropertyName("nodeType")]
        public int NodeType
        {
            get;
            set;
        }

        /// <summary>
        /// `Node`&apos;s nodeName.
        /// </summary>
        [JsonPropertyName("nodeName")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string NodeName
        {
            get;
            set;
        }

        /// <summary>
        /// BackendNodeId
        /// </summary>
        [JsonPropertyName("backendNodeId")]
        public int BackendNodeId
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Pseudo element type.
    /// </summary>
    public enum PseudoType
    {
        /// <summary>
        /// first-line
        /// </summary>
        [JsonPropertyName("first-line")]
        FirstLine,
        /// <summary>
        /// first-letter
        /// </summary>
        [JsonPropertyName("first-letter")]
        FirstLetter,
        /// <summary>
        /// before
        /// </summary>
        [JsonPropertyName("before")]
        Before,
        /// <summary>
        /// after
        /// </summary>
        [JsonPropertyName("after")]
        After,
        /// <summary>
        /// marker
        /// </summary>
        [JsonPropertyName("marker")]
        Marker,
        /// <summary>
        /// backdrop
        /// </summary>
        [JsonPropertyName("backdrop")]
        Backdrop,
        /// <summary>
        /// selection
        /// </summary>
        [JsonPropertyName("selection")]
        Selection,
        /// <summary>
        /// search-text
        /// </summary>
        [JsonPropertyName("search-text")]
        SearchText,
        /// <summary>
        /// target-text
        /// </summary>
        [JsonPropertyName("target-text")]
        TargetText,
        /// <summary>
        /// spelling-error
        /// </summary>
        [JsonPropertyName("spelling-error")]
        SpellingError,
        /// <summary>
        /// grammar-error
        /// </summary>
        [JsonPropertyName("grammar-error")]
        GrammarError,
        /// <summary>
        /// highlight
        /// </summary>
        [JsonPropertyName("highlight")]
        Highlight,
        /// <summary>
        /// first-line-inherited
        /// </summary>
        [JsonPropertyName("first-line-inherited")]
        FirstLineInherited,
        /// <summary>
        /// scroll-marker
        /// </summary>
        [JsonPropertyName("scroll-marker")]
        ScrollMarker,
        /// <summary>
        /// scroll-marker-group
        /// </summary>
        [JsonPropertyName("scroll-marker-group")]
        ScrollMarkerGroup,
        /// <summary>
        /// scroll-next-button
        /// </summary>
        [JsonPropertyName("scroll-next-button")]
        ScrollNextButton,
        /// <summary>
        /// scroll-prev-button
        /// </summary>
        [JsonPropertyName("scroll-prev-button")]
        ScrollPrevButton,
        /// <summary>
        /// scrollbar
        /// </summary>
        [JsonPropertyName("scrollbar")]
        Scrollbar,
        /// <summary>
        /// scrollbar-thumb
        /// </summary>
        [JsonPropertyName("scrollbar-thumb")]
        ScrollbarThumb,
        /// <summary>
        /// scrollbar-button
        /// </summary>
        [JsonPropertyName("scrollbar-button")]
        ScrollbarButton,
        /// <summary>
        /// scrollbar-track
        /// </summary>
        [JsonPropertyName("scrollbar-track")]
        ScrollbarTrack,
        /// <summary>
        /// scrollbar-track-piece
        /// </summary>
        [JsonPropertyName("scrollbar-track-piece")]
        ScrollbarTrackPiece,
        /// <summary>
        /// scrollbar-corner
        /// </summary>
        [JsonPropertyName("scrollbar-corner")]
        ScrollbarCorner,
        /// <summary>
        /// resizer
        /// </summary>
        [JsonPropertyName("resizer")]
        Resizer,
        /// <summary>
        /// input-list-button
        /// </summary>
        [JsonPropertyName("input-list-button")]
        InputListButton,
        /// <summary>
        /// view-transition
        /// </summary>
        [JsonPropertyName("view-transition")]
        ViewTransition,
        /// <summary>
        /// view-transition-group
        /// </summary>
        [JsonPropertyName("view-transition-group")]
        ViewTransitionGroup,
        /// <summary>
        /// view-transition-image-pair
        /// </summary>
        [JsonPropertyName("view-transition-image-pair")]
        ViewTransitionImagePair,
        /// <summary>
        /// view-transition-old
        /// </summary>
        [JsonPropertyName("view-transition-old")]
        ViewTransitionOld,
        /// <summary>
        /// view-transition-new
        /// </summary>
        [JsonPropertyName("view-transition-new")]
        ViewTransitionNew
    }

    /// <summary>
    /// Shadow root type.
    /// </summary>
    public enum ShadowRootType
    {
        /// <summary>
        /// user-agent
        /// </summary>
        [JsonPropertyName("user-agent")]
        UserAgent,
        /// <summary>
        /// open
        /// </summary>
        [JsonPropertyName("open")]
        Open,
        /// <summary>
        /// closed
        /// </summary>
        [JsonPropertyName("closed")]
        Closed
    }

    /// <summary>
    /// Document compatibility mode.
    /// </summary>
    public enum CompatibilityMode
    {
        /// <summary>
        /// QuirksMode
        /// </summary>
        [JsonPropertyName("QuirksMode")]
        QuirksMode,
        /// <summary>
        /// LimitedQuirksMode
        /// </summary>
        [JsonPropertyName("LimitedQuirksMode")]
        LimitedQuirksMode,
        /// <summary>
        /// NoQuirksMode
        /// </summary>
        [JsonPropertyName("NoQuirksMode")]
        NoQuirksMode
    }

    /// <summary>
    /// ContainerSelector physical axes
    /// </summary>
    public enum PhysicalAxes
    {
        /// <summary>
        /// Horizontal
        /// </summary>
        [JsonPropertyName("Horizontal")]
        Horizontal,
        /// <summary>
        /// Vertical
        /// </summary>
        [JsonPropertyName("Vertical")]
        Vertical,
        /// <summary>
        /// Both
        /// </summary>
        [JsonPropertyName("Both")]
        Both
    }

    /// <summary>
    /// ContainerSelector logical axes
    /// </summary>
    public enum LogicalAxes
    {
        /// <summary>
        /// Inline
        /// </summary>
        [JsonPropertyName("Inline")]
        Inline,
        /// <summary>
        /// Block
        /// </summary>
        [JsonPropertyName("Block")]
        Block,
        /// <summary>
        /// Both
        /// </summary>
        [JsonPropertyName("Both")]
        Both
    }

    /// <summary>
    /// Physical scroll orientation
    /// </summary>
    public enum ScrollOrientation
    {
        /// <summary>
        /// horizontal
        /// </summary>
        [JsonPropertyName("horizontal")]
        Horizontal,
        /// <summary>
        /// vertical
        /// </summary>
        [JsonPropertyName("vertical")]
        Vertical
    }

    /// <summary>
    /// DOM interaction is implemented in terms of mirror objects that represent the actual DOM nodes.
    /// DOMNode is a base node mirror type.
    /// </summary>
    public partial class Node : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Node identifier that is passed into the rest of the DOM messages as the `nodeId`. Backend
        /// will only push node with given `id` once. It is aware of all requested nodes and will only
        /// fire DOM events for nodes known to the client.
        /// </summary>
        [JsonPropertyName("nodeId")]
        public int NodeId
        {
            get;
            set;
        }

        /// <summary>
        /// The id of the parent node if any.
        /// </summary>
        [JsonPropertyName("parentId")]
        public int? ParentId
        {
            get;
            set;
        }

        /// <summary>
        /// The BackendNodeId for this node.
        /// </summary>
        [JsonPropertyName("backendNodeId")]
        public int BackendNodeId
        {
            get;
            set;
        }

        /// <summary>
        /// `Node`&apos;s nodeType.
        /// </summary>
        [JsonPropertyName("nodeType")]
        public int NodeType
        {
            get;
            set;
        }

        /// <summary>
        /// `Node`&apos;s nodeName.
        /// </summary>
        [JsonPropertyName("nodeName")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string NodeName
        {
            get;
            set;
        }

        /// <summary>
        /// `Node`&apos;s localName.
        /// </summary>
        [JsonPropertyName("localName")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string LocalName
        {
            get;
            set;
        }

        /// <summary>
        /// `Node`&apos;s nodeValue.
        /// </summary>
        [JsonPropertyName("nodeValue")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string NodeValue
        {
            get;
            set;
        }

        /// <summary>
        /// Child count for `Container` nodes.
        /// </summary>
        [JsonPropertyName("childNodeCount")]
        public int? ChildNodeCount
        {
            get;
            set;
        }

        /// <summary>
        /// Child nodes of this node when requested with children.
        /// </summary>
        [JsonPropertyName("children")]
        public System.Collections.Generic.IList<CefSharp.DevTools.DOM.Node> Children
        {
            get;
            set;
        }

        /// <summary>
        /// Attributes of the `Element` node in the form of flat array `[name1, value1, name2, value2]`.
        /// </summary>
        [JsonPropertyName("attributes")]
        public string[] Attributes
        {
            get;
            set;
        }

        /// <summary>
        /// Document URL that `Document` or `FrameOwner` node points to.
        /// </summary>
        [JsonPropertyName("documentURL")]
        public string DocumentURL
        {
            get;
            set;
        }

        /// <summary>
        /// Base URL that `Document` or `FrameOwner` node uses for URL completion.
        /// </summary>
        [JsonPropertyName("baseURL")]
        public string BaseURL
        {
            get;
            set;
        }

        /// <summary>
        /// `DocumentType`&apos;s publicId.
        /// </summary>
        [JsonPropertyName("publicId")]
        public string PublicId
        {
            get;
            set;
        }

        /// <summary>
        /// `DocumentType`&apos;s systemId.
        /// </summary>
        [JsonPropertyName("systemId")]
        public string SystemId
        {
            get;
            set;
        }

        /// <summary>
        /// `DocumentType`&apos;s internalSubset.
        /// </summary>
        [JsonPropertyName("internalSubset")]
        public string InternalSubset
        {
            get;
            set;
        }

        /// <summary>
        /// `Document`&apos;s XML version in case of XML documents.
        /// </summary>
        [JsonPropertyName("xmlVersion")]
        public string XmlVersion
        {
            get;
            set;
        }

        /// <summary>
        /// `Attr`&apos;s name.
        /// </summary>
        [JsonPropertyName("name")]
        public string Name
        {
            get;
            set;
        }

        /// <summary>
        /// `Attr`&apos;s value.
        /// </summary>
        [JsonPropertyName("value")]
        public string Value
        {
            get;
            set;
        }

        /// <summary>
        /// Pseudo element type for this node.
        /// </summary>
        [JsonPropertyName("pseudoType")]
        public CefSharp.DevTools.DOM.PseudoType? PseudoType
        {
            get;
            set;
        }

        /// <summary>
        /// Pseudo element identifier for this node. Only present if there is a
        /// valid pseudoType.
        /// </summary>
        [JsonPropertyName("pseudoIdentifier")]
        public string PseudoIdentifier
        {
            get;
            set;
        }

        /// <summary>
        /// Shadow root type.
        /// </summary>
        [JsonPropertyName("shadowRootType")]
        public CefSharp.DevTools.DOM.ShadowRootType? ShadowRootType
        {
            get;
            set;
        }

        /// <summary>
        /// Frame ID for frame owner elements.
        /// </summary>
        [JsonPropertyName("frameId")]
        public string FrameId
        {
            get;
            set;
        }

        /// <summary>
        /// Content document for frame owner elements.
        /// </summary>
        [JsonPropertyName("contentDocument")]
        public CefSharp.DevTools.DOM.Node ContentDocument
        {
            get;
            set;
        }

        /// <summary>
        /// Shadow root list for given element host.
        /// </summary>
        [JsonPropertyName("shadowRoots")]
        public System.Collections.Generic.IList<CefSharp.DevTools.DOM.Node> ShadowRoots
        {
            get;
            set;
        }

        /// <summary>
        /// Content document fragment for template elements.
        /// </summary>
        [JsonPropertyName("templateContent")]
        public CefSharp.DevTools.DOM.Node TemplateContent
        {
            get;
            set;
        }

        /// <summary>
        /// Pseudo elements associated with this node.
        /// </summary>
        [JsonPropertyName("pseudoElements")]
        public System.Collections.Generic.IList<CefSharp.DevTools.DOM.Node> PseudoElements
        {
            get;
            set;
        }

        /// <summary>
        /// Deprecated, as the HTML Imports API has been removed (crbug.com/937746).
        /// This property used to return the imported document for the HTMLImport links.
        /// The property is always undefined now.
        /// </summary>
        [JsonPropertyName("importedDocument")]
        public CefSharp.DevTools.DOM.Node ImportedDocument
        {
            get;
            set;
        }

        /// <summary>
        /// Distributed nodes for given insertion point.
        /// </summary>
        [JsonPropertyName("distributedNodes")]
        public System.Collections.Generic.IList<CefSharp.DevTools.DOM.BackendNode> DistributedNodes
        {
            get;
            set;
        }

        /// <summary>
        /// Whether the node is SVG.
        /// </summary>
        [JsonPropertyName("isSVG")]
        public bool? IsSVG
        {
            get;
            set;
        }

        /// <summary>
        /// CompatibilityMode
        /// </summary>
        [JsonPropertyName("compatibilityMode")]
        public CefSharp.DevTools.DOM.CompatibilityMode? CompatibilityMode
        {
            get;
            set;
        }

        /// <summary>
        /// AssignedSlot
        /// </summary>
        [JsonPropertyName("assignedSlot")]
        public CefSharp.DevTools.DOM.BackendNode AssignedSlot
        {
            get;
            set;
        }
    }

    /// <summary>
    /// A structure to hold the top-level node of a detached tree and an array of its retained descendants.
    /// </summary>
    public partial class DetachedElementInfo : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// TreeNode
        /// </summary>
        [JsonPropertyName("treeNode")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.DOM.Node TreeNode
        {
            get;
            set;
        }

        /// <summary>
        /// RetainedNodeIds
        /// </summary>
        [JsonPropertyName("retainedNodeIds")]
        public int[] RetainedNodeIds
        {
            get;
            set;
        }
    }

    /// <summary>
    /// A structure holding an RGBA color.
    /// </summary>
    public partial class RGBA : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The red component, in the [0-255] range.
        /// </summary>
        [JsonPropertyName("r")]
        public int R
        {
            get;
            set;
        }

        /// <summary>
        /// The green component, in the [0-255] range.
        /// </summary>
        [JsonPropertyName("g")]
        public int G
        {
            get;
            set;
        }

        /// <summary>
        /// The blue component, in the [0-255] range.
        /// </summary>
        [JsonPropertyName("b")]
        public int B
        {
            get;
            set;
        }

        /// <summary>
        /// The alpha component, in the [0-1] range (default: 1).
        /// </summary>
        [JsonPropertyName("a")]
        public double? A
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Box model.
    /// </summary>
    public partial class BoxModel : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Content box
        /// </summary>
        [JsonPropertyName("content")]
        public double[] Content
        {
            get;
            set;
        }

        /// <summary>
        /// Padding box
        /// </summary>
        [JsonPropertyName("padding")]
        public double[] Padding
        {
            get;
            set;
        }

        /// <summary>
        /// Border box
        /// </summary>
        [JsonPropertyName("border")]
        public double[] Border
        {
            get;
            set;
        }

        /// <summary>
        /// Margin box
        /// </summary>
        [JsonPropertyName("margin")]
        public double[] Margin
        {
            get;
            set;
        }

        /// <summary>
        /// Node width
        /// </summary>
        [JsonPropertyName("width")]
        public int Width
        {
            get;
            set;
        }

        /// <summary>
        /// Node height
        /// </summary>
        [JsonPropertyName("height")]
        public int Height
        {
            get;
            set;
        }

        /// <summary>
        /// Shape outside coordinates
        /// </summary>
        [JsonPropertyName("shapeOutside")]
        public CefSharp.DevTools.DOM.ShapeOutsideInfo ShapeOutside
        {
            get;
            set;
        }
    }

    /// <summary>
    /// CSS Shape Outside details.
    /// </summary>
    public partial class ShapeOutsideInfo : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Shape bounds
        /// </summary>
        [JsonPropertyName("bounds")]
        public double[] Bounds
        {
            get;
            set;
        }

        /// <summary>
        /// Shape coordinate details
        /// </summary>
        [JsonPropertyName("shape")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public object[] Shape
        {
            get;
            set;
        }

        /// <summary>
        /// Margin shape bounds
        /// </summary>
        [JsonPropertyName("marginShape")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public object[] MarginShape
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Rectangle.
    /// </summary>
    public partial class Rect : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// X coordinate
        /// </summary>
        [JsonPropertyName("x")]
        public double X
        {
            get;
            set;
        }

        /// <summary>
        /// Y coordinate
        /// </summary>
        [JsonPropertyName("y")]
        public double Y
        {
            get;
            set;
        }

        /// <summary>
        /// Rectangle width
        /// </summary>
        [JsonPropertyName("width")]
        public double Width
        {
            get;
            set;
        }

        /// <summary>
        /// Rectangle height
        /// </summary>
        [JsonPropertyName("height")]
        public double Height
        {
            get;
            set;
        }
    }

    /// <summary>
    /// CSSComputedStyleProperty
    /// </summary>
    public partial class CSSComputedStyleProperty : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Computed style property name.
        /// </summary>
        [JsonPropertyName("name")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Name
        {
            get;
            set;
        }

        /// <summary>
        /// Computed style property value.
        /// </summary>
        [JsonPropertyName("value")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Value
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Fired when `Element`&apos;s attribute is modified.
    /// </summary>
    public class AttributeModifiedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Id of the node that has changed.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("nodeId")]
        public int NodeId
        {
            get;
            private set;
        }

        /// <summary>
        /// Attribute name.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("name")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Name
        {
            get;
            private set;
        }

        /// <summary>
        /// Attribute value.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("value")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Value
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired when `Element`&apos;s attribute is removed.
    /// </summary>
    public class AttributeRemovedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Id of the node that has changed.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("nodeId")]
        public int NodeId
        {
            get;
            private set;
        }

        /// <summary>
        /// A ttribute name.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("name")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Name
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Mirrors `DOMCharacterDataModified` event.
    /// </summary>
    public class CharacterDataModifiedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Id of the node that has changed.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("nodeId")]
        public int NodeId
        {
            get;
            private set;
        }

        /// <summary>
        /// New text value.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("characterData")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string CharacterData
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired when `Container`&apos;s child node count has changed.
    /// </summary>
    public class ChildNodeCountUpdatedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Id of the node that has changed.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("nodeId")]
        public int NodeId
        {
            get;
            private set;
        }

        /// <summary>
        /// New node count.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("childNodeCount")]
        public int ChildNodeCount
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Mirrors `DOMNodeInserted` event.
    /// </summary>
    public class ChildNodeInsertedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Id of the node that has changed.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("parentNodeId")]
        public int ParentNodeId
        {
            get;
            private set;
        }

        /// <summary>
        /// Id of the previous sibling.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("previousNodeId")]
        public int PreviousNodeId
        {
            get;
            private set;
        }

        /// <summary>
        /// Inserted node data.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("node")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.DOM.Node Node
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Mirrors `DOMNodeRemoved` event.
    /// </summary>
    public class ChildNodeRemovedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Parent id.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("parentNodeId")]
        public int ParentNodeId
        {
            get;
            private set;
        }

        /// <summary>
        /// Id of the node that has been removed.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("nodeId")]
        public int NodeId
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Called when distribution is changed.
    /// </summary>
    public class DistributedNodesUpdatedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Insertion point where distributed nodes were updated.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("insertionPointId")]
        public int InsertionPointId
        {
            get;
            private set;
        }

        /// <summary>
        /// Distributed nodes for given insertion point.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("distributedNodes")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public System.Collections.Generic.IList<CefSharp.DevTools.DOM.BackendNode> DistributedNodes
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired when `Element`&apos;s inline style is modified via a CSS property modification.
    /// </summary>
    public class InlineStyleInvalidatedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Ids of the nodes for which the inline styles have been invalidated.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("nodeIds")]
        public int[] NodeIds
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Called when a pseudo element is added to an element.
    /// </summary>
    public class PseudoElementAddedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Pseudo element&apos;s parent element id.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("parentId")]
        public int ParentId
        {
            get;
            private set;
        }

        /// <summary>
        /// The added pseudo element.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("pseudoElement")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.DOM.Node PseudoElement
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Called when a pseudo element is removed from an element.
    /// </summary>
    public class PseudoElementRemovedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Pseudo element&apos;s parent element id.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("parentId")]
        public int ParentId
        {
            get;
            private set;
        }

        /// <summary>
        /// The removed pseudo element id.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("pseudoElementId")]
        public int PseudoElementId
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired when backend wants to provide client with the missing DOM structure. This happens upon
    /// most of the calls requesting node ids.
    /// </summary>
    public class SetChildNodesEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Parent node id to populate with children.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("parentId")]
        public int ParentId
        {
            get;
            private set;
        }

        /// <summary>
        /// Child nodes array.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("nodes")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public System.Collections.Generic.IList<CefSharp.DevTools.DOM.Node> Nodes
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Called when shadow root is popped from the element.
    /// </summary>
    public class ShadowRootPoppedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Host element id.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("hostId")]
        public int HostId
        {
            get;
            private set;
        }

        /// <summary>
        /// Shadow root id.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("rootId")]
        public int RootId
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Called when shadow root is pushed into the element.
    /// </summary>
    public class ShadowRootPushedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Host element id.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("hostId")]
        public int HostId
        {
            get;
            private set;
        }

        /// <summary>
        /// Shadow root.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("root")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.DOM.Node Root
        {
            get;
            private set;
        }
    }
}

namespace CefSharp.DevTools.DOMDebugger
{
    /// <summary>
    /// DOM breakpoint type.
    /// </summary>
    public enum DOMBreakpointType
    {
        /// <summary>
        /// subtree-modified
        /// </summary>
        [JsonPropertyName("subtree-modified")]
        SubtreeModified,
        /// <summary>
        /// attribute-modified
        /// </summary>
        [JsonPropertyName("attribute-modified")]
        AttributeModified,
        /// <summary>
        /// node-removed
        /// </summary>
        [JsonPropertyName("node-removed")]
        NodeRemoved
    }

    /// <summary>
    /// CSP Violation type.
    /// </summary>
    public enum CSPViolationType
    {
        /// <summary>
        /// trustedtype-sink-violation
        /// </summary>
        [JsonPropertyName("trustedtype-sink-violation")]
        TrustedtypeSinkViolation,
        /// <summary>
        /// trustedtype-policy-violation
        /// </summary>
        [JsonPropertyName("trustedtype-policy-violation")]
        TrustedtypePolicyViolation
    }

    /// <summary>
    /// Object event listener.
    /// </summary>
    public partial class EventListener : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// `EventListener`&apos;s type.
        /// </summary>
        [JsonPropertyName("type")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Type
        {
            get;
            set;
        }

        /// <summary>
        /// `EventListener`&apos;s useCapture.
        /// </summary>
        [JsonPropertyName("useCapture")]
        public bool UseCapture
        {
            get;
            set;
        }

        /// <summary>
        /// `EventListener`&apos;s passive flag.
        /// </summary>
        [JsonPropertyName("passive")]
        public bool Passive
        {
            get;
            set;
        }

        /// <summary>
        /// `EventListener`&apos;s once flag.
        /// </summary>
        [JsonPropertyName("once")]
        public bool Once
        {
            get;
            set;
        }

        /// <summary>
        /// Script id of the handler code.
        /// </summary>
        [JsonPropertyName("scriptId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string ScriptId
        {
            get;
            set;
        }

        /// <summary>
        /// Line number in the script (0-based).
        /// </summary>
        [JsonPropertyName("lineNumber")]
        public int LineNumber
        {
            get;
            set;
        }

        /// <summary>
        /// Column number in the script (0-based).
        /// </summary>
        [JsonPropertyName("columnNumber")]
        public int ColumnNumber
        {
            get;
            set;
        }

        /// <summary>
        /// Event handler function value.
        /// </summary>
        [JsonPropertyName("handler")]
        public CefSharp.DevTools.Runtime.RemoteObject Handler
        {
            get;
            set;
        }

        /// <summary>
        /// Event original handler function value.
        /// </summary>
        [JsonPropertyName("originalHandler")]
        public CefSharp.DevTools.Runtime.RemoteObject OriginalHandler
        {
            get;
            set;
        }

        /// <summary>
        /// Node the listener is added to (if any).
        /// </summary>
        [JsonPropertyName("backendNodeId")]
        public int? BackendNodeId
        {
            get;
            set;
        }
    }
}

namespace CefSharp.DevTools.DOMSnapshot
{
    /// <summary>
    /// A Node in the DOM tree.
    /// </summary>
    public partial class DOMNode : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// `Node`&apos;s nodeType.
        /// </summary>
        [JsonPropertyName("nodeType")]
        public int NodeType
        {
            get;
            set;
        }

        /// <summary>
        /// `Node`&apos;s nodeName.
        /// </summary>
        [JsonPropertyName("nodeName")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string NodeName
        {
            get;
            set;
        }

        /// <summary>
        /// `Node`&apos;s nodeValue.
        /// </summary>
        [JsonPropertyName("nodeValue")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string NodeValue
        {
            get;
            set;
        }

        /// <summary>
        /// Only set for textarea elements, contains the text value.
        /// </summary>
        [JsonPropertyName("textValue")]
        public string TextValue
        {
            get;
            set;
        }

        /// <summary>
        /// Only set for input elements, contains the input&apos;s associated text value.
        /// </summary>
        [JsonPropertyName("inputValue")]
        public string InputValue
        {
            get;
            set;
        }

        /// <summary>
        /// Only set for radio and checkbox input elements, indicates if the element has been checked
        /// </summary>
        [JsonPropertyName("inputChecked")]
        public bool? InputChecked
        {
            get;
            set;
        }

        /// <summary>
        /// Only set for option elements, indicates if the element has been selected
        /// </summary>
        [JsonPropertyName("optionSelected")]
        public bool? OptionSelected
        {
            get;
            set;
        }

        /// <summary>
        /// `Node`&apos;s id, corresponds to DOM.Node.backendNodeId.
        /// </summary>
        [JsonPropertyName("backendNodeId")]
        public int BackendNodeId
        {
            get;
            set;
        }

        /// <summary>
        /// The indexes of the node&apos;s child nodes in the `domNodes` array returned by `getSnapshot`, if
        /// any.
        /// </summary>
        [JsonPropertyName("childNodeIndexes")]
        public int[] ChildNodeIndexes
        {
            get;
            set;
        }

        /// <summary>
        /// Attributes of an `Element` node.
        /// </summary>
        [JsonPropertyName("attributes")]
        public System.Collections.Generic.IList<CefSharp.DevTools.DOMSnapshot.NameValue> Attributes
        {
            get;
            set;
        }

        /// <summary>
        /// Indexes of pseudo elements associated with this node in the `domNodes` array returned by
        /// `getSnapshot`, if any.
        /// </summary>
        [JsonPropertyName("pseudoElementIndexes")]
        public int[] PseudoElementIndexes
        {
            get;
            set;
        }

        /// <summary>
        /// The index of the node&apos;s related layout tree node in the `layoutTreeNodes` array returned by
        /// `getSnapshot`, if any.
        /// </summary>
        [JsonPropertyName("layoutNodeIndex")]
        public int? LayoutNodeIndex
        {
            get;
            set;
        }

        /// <summary>
        /// Document URL that `Document` or `FrameOwner` node points to.
        /// </summary>
        [JsonPropertyName("documentURL")]
        public string DocumentURL
        {
            get;
            set;
        }

        /// <summary>
        /// Base URL that `Document` or `FrameOwner` node uses for URL completion.
        /// </summary>
        [JsonPropertyName("baseURL")]
        public string BaseURL
        {
            get;
            set;
        }

        /// <summary>
        /// Only set for documents, contains the document&apos;s content language.
        /// </summary>
        [JsonPropertyName("contentLanguage")]
        public string ContentLanguage
        {
            get;
            set;
        }

        /// <summary>
        /// Only set for documents, contains the document&apos;s character set encoding.
        /// </summary>
        [JsonPropertyName("documentEncoding")]
        public string DocumentEncoding
        {
            get;
            set;
        }

        /// <summary>
        /// `DocumentType` node&apos;s publicId.
        /// </summary>
        [JsonPropertyName("publicId")]
        public string PublicId
        {
            get;
            set;
        }

        /// <summary>
        /// `DocumentType` node&apos;s systemId.
        /// </summary>
        [JsonPropertyName("systemId")]
        public string SystemId
        {
            get;
            set;
        }

        /// <summary>
        /// Frame ID for frame owner elements and also for the document node.
        /// </summary>
        [JsonPropertyName("frameId")]
        public string FrameId
        {
            get;
            set;
        }

        /// <summary>
        /// The index of a frame owner element&apos;s content document in the `domNodes` array returned by
        /// `getSnapshot`, if any.
        /// </summary>
        [JsonPropertyName("contentDocumentIndex")]
        public int? ContentDocumentIndex
        {
            get;
            set;
        }

        /// <summary>
        /// Type of a pseudo element node.
        /// </summary>
        [JsonPropertyName("pseudoType")]
        public CefSharp.DevTools.DOM.PseudoType? PseudoType
        {
            get;
            set;
        }

        /// <summary>
        /// Shadow root type.
        /// </summary>
        [JsonPropertyName("shadowRootType")]
        public CefSharp.DevTools.DOM.ShadowRootType? ShadowRootType
        {
            get;
            set;
        }

        /// <summary>
        /// Whether this DOM node responds to mouse clicks. This includes nodes that have had click
        /// event listeners attached via JavaScript as well as anchor tags that naturally navigate when
        /// clicked.
        /// </summary>
        [JsonPropertyName("isClickable")]
        public bool? IsClickable
        {
            get;
            set;
        }

        /// <summary>
        /// Details of the node&apos;s event listeners, if any.
        /// </summary>
        [JsonPropertyName("eventListeners")]
        public System.Collections.Generic.IList<CefSharp.DevTools.DOMDebugger.EventListener> EventListeners
        {
            get;
            set;
        }

        /// <summary>
        /// The selected url for nodes with a srcset attribute.
        /// </summary>
        [JsonPropertyName("currentSourceURL")]
        public string CurrentSourceURL
        {
            get;
            set;
        }

        /// <summary>
        /// The url of the script (if any) that generates this node.
        /// </summary>
        [JsonPropertyName("originURL")]
        public string OriginURL
        {
            get;
            set;
        }

        /// <summary>
        /// Scroll offsets, set when this node is a Document.
        /// </summary>
        [JsonPropertyName("scrollOffsetX")]
        public double? ScrollOffsetX
        {
            get;
            set;
        }

        /// <summary>
        /// ScrollOffsetY
        /// </summary>
        [JsonPropertyName("scrollOffsetY")]
        public double? ScrollOffsetY
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Details of post layout rendered text positions. The exact layout should not be regarded as
    /// stable and may change between versions.
    /// </summary>
    public partial class InlineTextBox : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The bounding box in document coordinates. Note that scroll offset of the document is ignored.
        /// </summary>
        [JsonPropertyName("boundingBox")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.DOM.Rect BoundingBox
        {
            get;
            set;
        }

        /// <summary>
        /// The starting index in characters, for this post layout textbox substring. Characters that
        /// would be represented as a surrogate pair in UTF-16 have length 2.
        /// </summary>
        [JsonPropertyName("startCharacterIndex")]
        public int StartCharacterIndex
        {
            get;
            set;
        }

        /// <summary>
        /// The number of characters in this post layout textbox substring. Characters that would be
        /// represented as a surrogate pair in UTF-16 have length 2.
        /// </summary>
        [JsonPropertyName("numCharacters")]
        public int NumCharacters
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Details of an element in the DOM tree with a LayoutObject.
    /// </summary>
    public partial class LayoutTreeNode : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The index of the related DOM node in the `domNodes` array returned by `getSnapshot`.
        /// </summary>
        [JsonPropertyName("domNodeIndex")]
        public int DomNodeIndex
        {
            get;
            set;
        }

        /// <summary>
        /// The bounding box in document coordinates. Note that scroll offset of the document is ignored.
        /// </summary>
        [JsonPropertyName("boundingBox")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.DOM.Rect BoundingBox
        {
            get;
            set;
        }

        /// <summary>
        /// Contents of the LayoutText, if any.
        /// </summary>
        [JsonPropertyName("layoutText")]
        public string LayoutText
        {
            get;
            set;
        }

        /// <summary>
        /// The post-layout inline text nodes, if any.
        /// </summary>
        [JsonPropertyName("inlineTextNodes")]
        public System.Collections.Generic.IList<CefSharp.DevTools.DOMSnapshot.InlineTextBox> InlineTextNodes
        {
            get;
            set;
        }

        /// <summary>
        /// Index into the `computedStyles` array returned by `getSnapshot`.
        /// </summary>
        [JsonPropertyName("styleIndex")]
        public int? StyleIndex
        {
            get;
            set;
        }

        /// <summary>
        /// Global paint order index, which is determined by the stacking order of the nodes. Nodes
        /// that are painted together will have the same index. Only provided if includePaintOrder in
        /// getSnapshot was true.
        /// </summary>
        [JsonPropertyName("paintOrder")]
        public int? PaintOrder
        {
            get;
            set;
        }

        /// <summary>
        /// Set to true to indicate the element begins a new stacking context.
        /// </summary>
        [JsonPropertyName("isStackingContext")]
        public bool? IsStackingContext
        {
            get;
            set;
        }
    }

    /// <summary>
    /// A subset of the full ComputedStyle as defined by the request whitelist.
    /// </summary>
    public partial class ComputedStyle : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Name/value pairs of computed style properties.
        /// </summary>
        [JsonPropertyName("properties")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public System.Collections.Generic.IList<CefSharp.DevTools.DOMSnapshot.NameValue> Properties
        {
            get;
            set;
        }
    }

    /// <summary>
    /// A name/value pair.
    /// </summary>
    public partial class NameValue : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Attribute/property name.
        /// </summary>
        [JsonPropertyName("name")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Name
        {
            get;
            set;
        }

        /// <summary>
        /// Attribute/property value.
        /// </summary>
        [JsonPropertyName("value")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Value
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Data that is only present on rare nodes.
    /// </summary>
    public partial class RareStringData : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Index
        /// </summary>
        [JsonPropertyName("index")]
        public int[] Index
        {
            get;
            set;
        }

        /// <summary>
        /// Value
        /// </summary>
        [JsonPropertyName("value")]
        public int[] Value
        {
            get;
            set;
        }
    }

    /// <summary>
    /// RareBooleanData
    /// </summary>
    public partial class RareBooleanData : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Index
        /// </summary>
        [JsonPropertyName("index")]
        public int[] Index
        {
            get;
            set;
        }
    }

    /// <summary>
    /// RareIntegerData
    /// </summary>
    public partial class RareIntegerData : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Index
        /// </summary>
        [JsonPropertyName("index")]
        public int[] Index
        {
            get;
            set;
        }

        /// <summary>
        /// Value
        /// </summary>
        [JsonPropertyName("value")]
        public int[] Value
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Document snapshot.
    /// </summary>
    public partial class DocumentSnapshot : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Document URL that `Document` or `FrameOwner` node points to.
        /// </summary>
        [JsonPropertyName("documentURL")]
        public int DocumentURL
        {
            get;
            set;
        }

        /// <summary>
        /// Document title.
        /// </summary>
        [JsonPropertyName("title")]
        public int Title
        {
            get;
            set;
        }

        /// <summary>
        /// Base URL that `Document` or `FrameOwner` node uses for URL completion.
        /// </summary>
        [JsonPropertyName("baseURL")]
        public int BaseURL
        {
            get;
            set;
        }

        /// <summary>
        /// Contains the document&apos;s content language.
        /// </summary>
        [JsonPropertyName("contentLanguage")]
        public int ContentLanguage
        {
            get;
            set;
        }

        /// <summary>
        /// Contains the document&apos;s character set encoding.
        /// </summary>
        [JsonPropertyName("encodingName")]
        public int EncodingName
        {
            get;
            set;
        }

        /// <summary>
        /// `DocumentType` node&apos;s publicId.
        /// </summary>
        [JsonPropertyName("publicId")]
        public int PublicId
        {
            get;
            set;
        }

        /// <summary>
        /// `DocumentType` node&apos;s systemId.
        /// </summary>
        [JsonPropertyName("systemId")]
        public int SystemId
        {
            get;
            set;
        }

        /// <summary>
        /// Frame ID for frame owner elements and also for the document node.
        /// </summary>
        [JsonPropertyName("frameId")]
        public int FrameId
        {
            get;
            set;
        }

        /// <summary>
        /// A table with dom nodes.
        /// </summary>
        [JsonPropertyName("nodes")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.DOMSnapshot.NodeTreeSnapshot Nodes
        {
            get;
            set;
        }

        /// <summary>
        /// The nodes in the layout tree.
        /// </summary>
        [JsonPropertyName("layout")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.DOMSnapshot.LayoutTreeSnapshot Layout
        {
            get;
            set;
        }

        /// <summary>
        /// The post-layout inline text nodes.
        /// </summary>
        [JsonPropertyName("textBoxes")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.DOMSnapshot.TextBoxSnapshot TextBoxes
        {
            get;
            set;
        }

        /// <summary>
        /// Horizontal scroll offset.
        /// </summary>
        [JsonPropertyName("scrollOffsetX")]
        public double? ScrollOffsetX
        {
            get;
            set;
        }

        /// <summary>
        /// Vertical scroll offset.
        /// </summary>
        [JsonPropertyName("scrollOffsetY")]
        public double? ScrollOffsetY
        {
            get;
            set;
        }

        /// <summary>
        /// Document content width.
        /// </summary>
        [JsonPropertyName("contentWidth")]
        public double? ContentWidth
        {
            get;
            set;
        }

        /// <summary>
        /// Document content height.
        /// </summary>
        [JsonPropertyName("contentHeight")]
        public double? ContentHeight
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Table containing nodes.
    /// </summary>
    public partial class NodeTreeSnapshot : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Parent node index.
        /// </summary>
        [JsonPropertyName("parentIndex")]
        public int[] ParentIndex
        {
            get;
            set;
        }

        /// <summary>
        /// `Node`&apos;s nodeType.
        /// </summary>
        [JsonPropertyName("nodeType")]
        public int[] NodeType
        {
            get;
            set;
        }

        /// <summary>
        /// Type of the shadow root the `Node` is in. String values are equal to the `ShadowRootType` enum.
        /// </summary>
        [JsonPropertyName("shadowRootType")]
        public CefSharp.DevTools.DOMSnapshot.RareStringData ShadowRootType
        {
            get;
            set;
        }

        /// <summary>
        /// `Node`&apos;s nodeName.
        /// </summary>
        [JsonPropertyName("nodeName")]
        public int[] NodeName
        {
            get;
            set;
        }

        /// <summary>
        /// `Node`&apos;s nodeValue.
        /// </summary>
        [JsonPropertyName("nodeValue")]
        public int[] NodeValue
        {
            get;
            set;
        }

        /// <summary>
        /// `Node`&apos;s id, corresponds to DOM.Node.backendNodeId.
        /// </summary>
        [JsonPropertyName("backendNodeId")]
        public int[] BackendNodeId
        {
            get;
            set;
        }

        /// <summary>
        /// Attributes of an `Element` node. Flatten name, value pairs.
        /// </summary>
        [JsonPropertyName("attributes")]
        public int[] Attributes
        {
            get;
            set;
        }

        /// <summary>
        /// Only set for textarea elements, contains the text value.
        /// </summary>
        [JsonPropertyName("textValue")]
        public CefSharp.DevTools.DOMSnapshot.RareStringData TextValue
        {
            get;
            set;
        }

        /// <summary>
        /// Only set for input elements, contains the input&apos;s associated text value.
        /// </summary>
        [JsonPropertyName("inputValue")]
        public CefSharp.DevTools.DOMSnapshot.RareStringData InputValue
        {
            get;
            set;
        }

        /// <summary>
        /// Only set for radio and checkbox input elements, indicates if the element has been checked
        /// </summary>
        [JsonPropertyName("inputChecked")]
        public CefSharp.DevTools.DOMSnapshot.RareBooleanData InputChecked
        {
            get;
            set;
        }

        /// <summary>
        /// Only set for option elements, indicates if the element has been selected
        /// </summary>
        [JsonPropertyName("optionSelected")]
        public CefSharp.DevTools.DOMSnapshot.RareBooleanData OptionSelected
        {
            get;
            set;
        }

        /// <summary>
        /// The index of the document in the list of the snapshot documents.
        /// </summary>
        [JsonPropertyName("contentDocumentIndex")]
        public CefSharp.DevTools.DOMSnapshot.RareIntegerData ContentDocumentIndex
        {
            get;
            set;
        }

        /// <summary>
        /// Type of a pseudo element node.
        /// </summary>
        [JsonPropertyName("pseudoType")]
        public CefSharp.DevTools.DOMSnapshot.RareStringData PseudoType
        {
            get;
            set;
        }

        /// <summary>
        /// Pseudo element identifier for this node. Only present if there is a
        /// valid pseudoType.
        /// </summary>
        [JsonPropertyName("pseudoIdentifier")]
        public CefSharp.DevTools.DOMSnapshot.RareStringData PseudoIdentifier
        {
            get;
            set;
        }

        /// <summary>
        /// Whether this DOM node responds to mouse clicks. This includes nodes that have had click
        /// event listeners attached via JavaScript as well as anchor tags that naturally navigate when
        /// clicked.
        /// </summary>
        [JsonPropertyName("isClickable")]
        public CefSharp.DevTools.DOMSnapshot.RareBooleanData IsClickable
        {
            get;
            set;
        }

        /// <summary>
        /// The selected url for nodes with a srcset attribute.
        /// </summary>
        [JsonPropertyName("currentSourceURL")]
        public CefSharp.DevTools.DOMSnapshot.RareStringData CurrentSourceURL
        {
            get;
            set;
        }

        /// <summary>
        /// The url of the script (if any) that generates this node.
        /// </summary>
        [JsonPropertyName("originURL")]
        public CefSharp.DevTools.DOMSnapshot.RareStringData OriginURL
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Table of details of an element in the DOM tree with a LayoutObject.
    /// </summary>
    public partial class LayoutTreeSnapshot : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Index of the corresponding node in the `NodeTreeSnapshot` array returned by `captureSnapshot`.
        /// </summary>
        [JsonPropertyName("nodeIndex")]
        public int[] NodeIndex
        {
            get;
            set;
        }

        /// <summary>
        /// Array of indexes specifying computed style strings, filtered according to the `computedStyles` parameter passed to `captureSnapshot`.
        /// </summary>
        [JsonPropertyName("styles")]
        public int[] Styles
        {
            get;
            set;
        }

        /// <summary>
        /// The absolute position bounding box.
        /// </summary>
        [JsonPropertyName("bounds")]
        public double[] Bounds
        {
            get;
            set;
        }

        /// <summary>
        /// Contents of the LayoutText, if any.
        /// </summary>
        [JsonPropertyName("text")]
        public int[] Text
        {
            get;
            set;
        }

        /// <summary>
        /// Stacking context information.
        /// </summary>
        [JsonPropertyName("stackingContexts")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.DOMSnapshot.RareBooleanData StackingContexts
        {
            get;
            set;
        }

        /// <summary>
        /// Global paint order index, which is determined by the stacking order of the nodes. Nodes
        /// that are painted together will have the same index. Only provided if includePaintOrder in
        /// captureSnapshot was true.
        /// </summary>
        [JsonPropertyName("paintOrders")]
        public int[] PaintOrders
        {
            get;
            set;
        }

        /// <summary>
        /// The offset rect of nodes. Only available when includeDOMRects is set to true
        /// </summary>
        [JsonPropertyName("offsetRects")]
        public double[] OffsetRects
        {
            get;
            set;
        }

        /// <summary>
        /// The scroll rect of nodes. Only available when includeDOMRects is set to true
        /// </summary>
        [JsonPropertyName("scrollRects")]
        public double[] ScrollRects
        {
            get;
            set;
        }

        /// <summary>
        /// The client rect of nodes. Only available when includeDOMRects is set to true
        /// </summary>
        [JsonPropertyName("clientRects")]
        public double[] ClientRects
        {
            get;
            set;
        }

        /// <summary>
        /// The list of background colors that are blended with colors of overlapping elements.
        /// </summary>
        [JsonPropertyName("blendedBackgroundColors")]
        public int[] BlendedBackgroundColors
        {
            get;
            set;
        }

        /// <summary>
        /// The list of computed text opacities.
        /// </summary>
        [JsonPropertyName("textColorOpacities")]
        public double[] TextColorOpacities
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Table of details of the post layout rendered text positions. The exact layout should not be regarded as
    /// stable and may change between versions.
    /// </summary>
    public partial class TextBoxSnapshot : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Index of the layout tree node that owns this box collection.
        /// </summary>
        [JsonPropertyName("layoutIndex")]
        public int[] LayoutIndex
        {
            get;
            set;
        }

        /// <summary>
        /// The absolute position bounding box.
        /// </summary>
        [JsonPropertyName("bounds")]
        public double[] Bounds
        {
            get;
            set;
        }

        /// <summary>
        /// The starting index in characters, for this post layout textbox substring. Characters that
        /// would be represented as a surrogate pair in UTF-16 have length 2.
        /// </summary>
        [JsonPropertyName("start")]
        public int[] Start
        {
            get;
            set;
        }

        /// <summary>
        /// The number of characters in this post layout textbox substring. Characters that would be
        /// represented as a surrogate pair in UTF-16 have length 2.
        /// </summary>
        [JsonPropertyName("length")]
        public int[] Length
        {
            get;
            set;
        }
    }
}

namespace CefSharp.DevTools.DOMStorage
{
    /// <summary>
    /// DOM Storage identifier.
    /// </summary>
    public partial class StorageId : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Security origin for the storage.
        /// </summary>
        [JsonPropertyName("securityOrigin")]
        public string SecurityOrigin
        {
            get;
            set;
        }

        /// <summary>
        /// Represents a key by which DOM Storage keys its CachedStorageAreas
        /// </summary>
        [JsonPropertyName("storageKey")]
        public string StorageKey
        {
            get;
            set;
        }

        /// <summary>
        /// Whether the storage is local storage (not session storage).
        /// </summary>
        [JsonPropertyName("isLocalStorage")]
        public bool IsLocalStorage
        {
            get;
            set;
        }
    }

    /// <summary>
    /// domStorageItemAdded
    /// </summary>
    public class DomStorageItemAddedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// StorageId
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("storageId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.DOMStorage.StorageId StorageId
        {
            get;
            private set;
        }

        /// <summary>
        /// Key
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("key")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Key
        {
            get;
            private set;
        }

        /// <summary>
        /// NewValue
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("newValue")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string NewValue
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// domStorageItemRemoved
    /// </summary>
    public class DomStorageItemRemovedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// StorageId
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("storageId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.DOMStorage.StorageId StorageId
        {
            get;
            private set;
        }

        /// <summary>
        /// Key
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("key")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Key
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// domStorageItemUpdated
    /// </summary>
    public class DomStorageItemUpdatedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// StorageId
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("storageId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.DOMStorage.StorageId StorageId
        {
            get;
            private set;
        }

        /// <summary>
        /// Key
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("key")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Key
        {
            get;
            private set;
        }

        /// <summary>
        /// OldValue
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("oldValue")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string OldValue
        {
            get;
            private set;
        }

        /// <summary>
        /// NewValue
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("newValue")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string NewValue
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// domStorageItemsCleared
    /// </summary>
    public class DomStorageItemsClearedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// StorageId
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("storageId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.DOMStorage.StorageId StorageId
        {
            get;
            private set;
        }
    }
}

namespace CefSharp.DevTools.Database
{
    /// <summary>
    /// Database object.
    /// </summary>
    public partial class Database : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Database ID.
        /// </summary>
        [JsonPropertyName("id")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Id
        {
            get;
            set;
        }

        /// <summary>
        /// Database domain.
        /// </summary>
        [JsonPropertyName("domain")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Domain
        {
            get;
            set;
        }

        /// <summary>
        /// Database name.
        /// </summary>
        [JsonPropertyName("name")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Name
        {
            get;
            set;
        }

        /// <summary>
        /// Database version.
        /// </summary>
        [JsonPropertyName("version")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Version
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Database error.
    /// </summary>
    public partial class Error : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Error message.
        /// </summary>
        [JsonPropertyName("message")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Message
        {
            get;
            set;
        }

        /// <summary>
        /// Error code.
        /// </summary>
        [JsonPropertyName("code")]
        public int Code
        {
            get;
            set;
        }
    }

    /// <summary>
    /// addDatabase
    /// </summary>
    public class AddDatabaseEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Database
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("database")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.Database.Database Database
        {
            get;
            private set;
        }
    }
}

namespace CefSharp.DevTools.Emulation
{
    /// <summary>
    /// Orientation type.
    /// </summary>
    public enum ScreenOrientationType
    {
        /// <summary>
        /// portraitPrimary
        /// </summary>
        [JsonPropertyName("portraitPrimary")]
        PortraitPrimary,
        /// <summary>
        /// portraitSecondary
        /// </summary>
        [JsonPropertyName("portraitSecondary")]
        PortraitSecondary,
        /// <summary>
        /// landscapePrimary
        /// </summary>
        [JsonPropertyName("landscapePrimary")]
        LandscapePrimary,
        /// <summary>
        /// landscapeSecondary
        /// </summary>
        [JsonPropertyName("landscapeSecondary")]
        LandscapeSecondary
    }

    /// <summary>
    /// Screen orientation.
    /// </summary>
    public partial class ScreenOrientation : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Orientation type.
        /// </summary>
        [JsonPropertyName("type")]
        public CefSharp.DevTools.Emulation.ScreenOrientationType Type
        {
            get;
            set;
        }

        /// <summary>
        /// Orientation angle.
        /// </summary>
        [JsonPropertyName("angle")]
        public int Angle
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Orientation of a display feature in relation to screen
    /// </summary>
    public enum DisplayFeatureOrientation
    {
        /// <summary>
        /// vertical
        /// </summary>
        [JsonPropertyName("vertical")]
        Vertical,
        /// <summary>
        /// horizontal
        /// </summary>
        [JsonPropertyName("horizontal")]
        Horizontal
    }

    /// <summary>
    /// DisplayFeature
    /// </summary>
    public partial class DisplayFeature : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Orientation of a display feature in relation to screen
        /// </summary>
        [JsonPropertyName("orientation")]
        public CefSharp.DevTools.Emulation.DisplayFeatureOrientation Orientation
        {
            get;
            set;
        }

        /// <summary>
        /// The offset from the screen origin in either the x (for vertical
        /// orientation) or y (for horizontal orientation) direction.
        /// </summary>
        [JsonPropertyName("offset")]
        public int Offset
        {
            get;
            set;
        }

        /// <summary>
        /// A display feature may mask content such that it is not physically
        /// displayed - this length along with the offset describes this area.
        /// A display feature that only splits content will have a 0 mask_length.
        /// </summary>
        [JsonPropertyName("maskLength")]
        public int MaskLength
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Current posture of the device
    /// </summary>
    public enum DevicePostureType
    {
        /// <summary>
        /// continuous
        /// </summary>
        [JsonPropertyName("continuous")]
        Continuous,
        /// <summary>
        /// folded
        /// </summary>
        [JsonPropertyName("folded")]
        Folded
    }

    /// <summary>
    /// DevicePosture
    /// </summary>
    public partial class DevicePosture : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Current posture of the device
        /// </summary>
        [JsonPropertyName("type")]
        public CefSharp.DevTools.Emulation.DevicePostureType Type
        {
            get;
            set;
        }
    }

    /// <summary>
    /// MediaFeature
    /// </summary>
    public partial class MediaFeature : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Name
        /// </summary>
        [JsonPropertyName("name")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Name
        {
            get;
            set;
        }

        /// <summary>
        /// Value
        /// </summary>
        [JsonPropertyName("value")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Value
        {
            get;
            set;
        }
    }

    /// <summary>
    /// advance: If the scheduler runs out of immediate work, the virtual time base may fast forward to
    /// allow the next delayed task (if any) to run; pause: The virtual time base may not advance;
    /// pauseIfNetworkFetchesPending: The virtual time base may not advance if there are any pending
    /// resource fetches.
    /// </summary>
    public enum VirtualTimePolicy
    {
        /// <summary>
        /// advance
        /// </summary>
        [JsonPropertyName("advance")]
        Advance,
        /// <summary>
        /// pause
        /// </summary>
        [JsonPropertyName("pause")]
        Pause,
        /// <summary>
        /// pauseIfNetworkFetchesPending
        /// </summary>
        [JsonPropertyName("pauseIfNetworkFetchesPending")]
        PauseIfNetworkFetchesPending
    }

    /// <summary>
    /// Used to specify User Agent Client Hints to emulate. See https://wicg.github.io/ua-client-hints
    /// </summary>
    public partial class UserAgentBrandVersion : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Brand
        /// </summary>
        [JsonPropertyName("brand")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Brand
        {
            get;
            set;
        }

        /// <summary>
        /// Version
        /// </summary>
        [JsonPropertyName("version")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Version
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Used to specify User Agent Client Hints to emulate. See https://wicg.github.io/ua-client-hints
    /// Missing optional values will be filled in by the target with what it would normally use.
    /// </summary>
    public partial class UserAgentMetadata : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Brands appearing in Sec-CH-UA.
        /// </summary>
        [JsonPropertyName("brands")]
        public System.Collections.Generic.IList<CefSharp.DevTools.Emulation.UserAgentBrandVersion> Brands
        {
            get;
            set;
        }

        /// <summary>
        /// Brands appearing in Sec-CH-UA-Full-Version-List.
        /// </summary>
        [JsonPropertyName("fullVersionList")]
        public System.Collections.Generic.IList<CefSharp.DevTools.Emulation.UserAgentBrandVersion> FullVersionList
        {
            get;
            set;
        }

        /// <summary>
        /// FullVersion
        /// </summary>
        [JsonPropertyName("fullVersion")]
        public string FullVersion
        {
            get;
            set;
        }

        /// <summary>
        /// Platform
        /// </summary>
        [JsonPropertyName("platform")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Platform
        {
            get;
            set;
        }

        /// <summary>
        /// PlatformVersion
        /// </summary>
        [JsonPropertyName("platformVersion")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string PlatformVersion
        {
            get;
            set;
        }

        /// <summary>
        /// Architecture
        /// </summary>
        [JsonPropertyName("architecture")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Architecture
        {
            get;
            set;
        }

        /// <summary>
        /// Model
        /// </summary>
        [JsonPropertyName("model")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Model
        {
            get;
            set;
        }

        /// <summary>
        /// Mobile
        /// </summary>
        [JsonPropertyName("mobile")]
        public bool Mobile
        {
            get;
            set;
        }

        /// <summary>
        /// Bitness
        /// </summary>
        [JsonPropertyName("bitness")]
        public string Bitness
        {
            get;
            set;
        }

        /// <summary>
        /// Wow64
        /// </summary>
        [JsonPropertyName("wow64")]
        public bool? Wow64
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Used to specify sensor types to emulate.
    /// See https://w3c.github.io/sensors/#automation for more information.
    /// </summary>
    public enum SensorType
    {
        /// <summary>
        /// absolute-orientation
        /// </summary>
        [JsonPropertyName("absolute-orientation")]
        AbsoluteOrientation,
        /// <summary>
        /// accelerometer
        /// </summary>
        [JsonPropertyName("accelerometer")]
        Accelerometer,
        /// <summary>
        /// ambient-light
        /// </summary>
        [JsonPropertyName("ambient-light")]
        AmbientLight,
        /// <summary>
        /// gravity
        /// </summary>
        [JsonPropertyName("gravity")]
        Gravity,
        /// <summary>
        /// gyroscope
        /// </summary>
        [JsonPropertyName("gyroscope")]
        Gyroscope,
        /// <summary>
        /// linear-acceleration
        /// </summary>
        [JsonPropertyName("linear-acceleration")]
        LinearAcceleration,
        /// <summary>
        /// magnetometer
        /// </summary>
        [JsonPropertyName("magnetometer")]
        Magnetometer,
        /// <summary>
        /// proximity
        /// </summary>
        [JsonPropertyName("proximity")]
        Proximity,
        /// <summary>
        /// relative-orientation
        /// </summary>
        [JsonPropertyName("relative-orientation")]
        RelativeOrientation
    }

    /// <summary>
    /// SensorMetadata
    /// </summary>
    public partial class SensorMetadata : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Available
        /// </summary>
        [JsonPropertyName("available")]
        public bool? Available
        {
            get;
            set;
        }

        /// <summary>
        /// MinimumFrequency
        /// </summary>
        [JsonPropertyName("minimumFrequency")]
        public double? MinimumFrequency
        {
            get;
            set;
        }

        /// <summary>
        /// MaximumFrequency
        /// </summary>
        [JsonPropertyName("maximumFrequency")]
        public double? MaximumFrequency
        {
            get;
            set;
        }
    }

    /// <summary>
    /// SensorReadingSingle
    /// </summary>
    public partial class SensorReadingSingle : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Value
        /// </summary>
        [JsonPropertyName("value")]
        public double Value
        {
            get;
            set;
        }
    }

    /// <summary>
    /// SensorReadingXYZ
    /// </summary>
    public partial class SensorReadingXYZ : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// X
        /// </summary>
        [JsonPropertyName("x")]
        public double X
        {
            get;
            set;
        }

        /// <summary>
        /// Y
        /// </summary>
        [JsonPropertyName("y")]
        public double Y
        {
            get;
            set;
        }

        /// <summary>
        /// Z
        /// </summary>
        [JsonPropertyName("z")]
        public double Z
        {
            get;
            set;
        }
    }

    /// <summary>
    /// SensorReadingQuaternion
    /// </summary>
    public partial class SensorReadingQuaternion : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// X
        /// </summary>
        [JsonPropertyName("x")]
        public double X
        {
            get;
            set;
        }

        /// <summary>
        /// Y
        /// </summary>
        [JsonPropertyName("y")]
        public double Y
        {
            get;
            set;
        }

        /// <summary>
        /// Z
        /// </summary>
        [JsonPropertyName("z")]
        public double Z
        {
            get;
            set;
        }

        /// <summary>
        /// W
        /// </summary>
        [JsonPropertyName("w")]
        public double W
        {
            get;
            set;
        }
    }

    /// <summary>
    /// SensorReading
    /// </summary>
    public partial class SensorReading : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Single
        /// </summary>
        [JsonPropertyName("single")]
        public CefSharp.DevTools.Emulation.SensorReadingSingle Single
        {
            get;
            set;
        }

        /// <summary>
        /// Xyz
        /// </summary>
        [JsonPropertyName("xyz")]
        public CefSharp.DevTools.Emulation.SensorReadingXYZ Xyz
        {
            get;
            set;
        }

        /// <summary>
        /// Quaternion
        /// </summary>
        [JsonPropertyName("quaternion")]
        public CefSharp.DevTools.Emulation.SensorReadingQuaternion Quaternion
        {
            get;
            set;
        }
    }

    /// <summary>
    /// PressureSource
    /// </summary>
    public enum PressureSource
    {
        /// <summary>
        /// cpu
        /// </summary>
        [JsonPropertyName("cpu")]
        Cpu
    }

    /// <summary>
    /// PressureState
    /// </summary>
    public enum PressureState
    {
        /// <summary>
        /// nominal
        /// </summary>
        [JsonPropertyName("nominal")]
        Nominal,
        /// <summary>
        /// fair
        /// </summary>
        [JsonPropertyName("fair")]
        Fair,
        /// <summary>
        /// serious
        /// </summary>
        [JsonPropertyName("serious")]
        Serious,
        /// <summary>
        /// critical
        /// </summary>
        [JsonPropertyName("critical")]
        Critical
    }

    /// <summary>
    /// PressureMetadata
    /// </summary>
    public partial class PressureMetadata : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Available
        /// </summary>
        [JsonPropertyName("available")]
        public bool? Available
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Enum of image types that can be disabled.
    /// </summary>
    public enum DisabledImageType
    {
        /// <summary>
        /// avif
        /// </summary>
        [JsonPropertyName("avif")]
        Avif,
        /// <summary>
        /// webp
        /// </summary>
        [JsonPropertyName("webp")]
        Webp
    }
}

namespace CefSharp.DevTools.HeadlessExperimental
{
    /// <summary>
    /// Image compression format (defaults to png).
    /// </summary>
    public enum ScreenshotParamsFormat
    {
        /// <summary>
        /// jpeg
        /// </summary>
        [JsonPropertyName("jpeg")]
        Jpeg,
        /// <summary>
        /// png
        /// </summary>
        [JsonPropertyName("png")]
        Png,
        /// <summary>
        /// webp
        /// </summary>
        [JsonPropertyName("webp")]
        Webp
    }

    /// <summary>
    /// Encoding options for a screenshot.
    /// </summary>
    public partial class ScreenshotParams : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Image compression format (defaults to png).
        /// </summary>
        [JsonPropertyName("format")]
        public CefSharp.DevTools.HeadlessExperimental.ScreenshotParamsFormat? Format
        {
            get;
            set;
        }

        /// <summary>
        /// Compression quality from range [0..100] (jpeg and webp only).
        /// </summary>
        [JsonPropertyName("quality")]
        public int? Quality
        {
            get;
            set;
        }

        /// <summary>
        /// Optimize image encoding for speed, not for resulting size (defaults to false)
        /// </summary>
        [JsonPropertyName("optimizeForSpeed")]
        public bool? OptimizeForSpeed
        {
            get;
            set;
        }
    }
}

namespace CefSharp.DevTools.FileSystem
{
    /// <summary>
    /// File
    /// </summary>
    public partial class File : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Name
        /// </summary>
        [JsonPropertyName("name")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Name
        {
            get;
            set;
        }

        /// <summary>
        /// Timestamp
        /// </summary>
        [JsonPropertyName("lastModified")]
        public double LastModified
        {
            get;
            set;
        }

        /// <summary>
        /// Size in bytes
        /// </summary>
        [JsonPropertyName("size")]
        public double Size
        {
            get;
            set;
        }

        /// <summary>
        /// Type
        /// </summary>
        [JsonPropertyName("type")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Type
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Directory
    /// </summary>
    public partial class Directory : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Name
        /// </summary>
        [JsonPropertyName("name")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Name
        {
            get;
            set;
        }

        /// <summary>
        /// NestedDirectories
        /// </summary>
        [JsonPropertyName("nestedDirectories")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string[] NestedDirectories
        {
            get;
            set;
        }

        /// <summary>
        /// Files that are directly nested under this directory.
        /// </summary>
        [JsonPropertyName("nestedFiles")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public System.Collections.Generic.IList<CefSharp.DevTools.FileSystem.File> NestedFiles
        {
            get;
            set;
        }
    }

    /// <summary>
    /// BucketFileSystemLocator
    /// </summary>
    public partial class BucketFileSystemLocator : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Storage key
        /// </summary>
        [JsonPropertyName("storageKey")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string StorageKey
        {
            get;
            set;
        }

        /// <summary>
        /// Bucket name. Not passing a `bucketName` will retrieve the default Bucket. (https://developer.mozilla.org/en-US/docs/Web/API/Storage_API#storage_buckets)
        /// </summary>
        [JsonPropertyName("bucketName")]
        public string BucketName
        {
            get;
            set;
        }

        /// <summary>
        /// Path to the directory using each path component as an array item.
        /// </summary>
        [JsonPropertyName("pathComponents")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string[] PathComponents
        {
            get;
            set;
        }
    }
}

namespace CefSharp.DevTools.IndexedDB
{
    /// <summary>
    /// Database with an array of object stores.
    /// </summary>
    public partial class DatabaseWithObjectStores : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Database name.
        /// </summary>
        [JsonPropertyName("name")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Name
        {
            get;
            set;
        }

        /// <summary>
        /// Database version (type is not &apos;integer&apos;, as the standard
        /// requires the version number to be &apos;unsigned long long&apos;)
        /// </summary>
        [JsonPropertyName("version")]
        public double Version
        {
            get;
            set;
        }

        /// <summary>
        /// Object stores in this database.
        /// </summary>
        [JsonPropertyName("objectStores")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public System.Collections.Generic.IList<CefSharp.DevTools.IndexedDB.ObjectStore> ObjectStores
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Object store.
    /// </summary>
    public partial class ObjectStore : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Object store name.
        /// </summary>
        [JsonPropertyName("name")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Name
        {
            get;
            set;
        }

        /// <summary>
        /// Object store key path.
        /// </summary>
        [JsonPropertyName("keyPath")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.IndexedDB.KeyPath KeyPath
        {
            get;
            set;
        }

        /// <summary>
        /// If true, object store has auto increment flag set.
        /// </summary>
        [JsonPropertyName("autoIncrement")]
        public bool AutoIncrement
        {
            get;
            set;
        }

        /// <summary>
        /// Indexes in this object store.
        /// </summary>
        [JsonPropertyName("indexes")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public System.Collections.Generic.IList<CefSharp.DevTools.IndexedDB.ObjectStoreIndex> Indexes
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Object store index.
    /// </summary>
    public partial class ObjectStoreIndex : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Index name.
        /// </summary>
        [JsonPropertyName("name")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Name
        {
            get;
            set;
        }

        /// <summary>
        /// Index key path.
        /// </summary>
        [JsonPropertyName("keyPath")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.IndexedDB.KeyPath KeyPath
        {
            get;
            set;
        }

        /// <summary>
        /// If true, index is unique.
        /// </summary>
        [JsonPropertyName("unique")]
        public bool Unique
        {
            get;
            set;
        }

        /// <summary>
        /// If true, index allows multiple entries for a key.
        /// </summary>
        [JsonPropertyName("multiEntry")]
        public bool MultiEntry
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Key type.
    /// </summary>
    public enum KeyType
    {
        /// <summary>
        /// number
        /// </summary>
        [JsonPropertyName("number")]
        Number,
        /// <summary>
        /// string
        /// </summary>
        [JsonPropertyName("string")]
        String,
        /// <summary>
        /// date
        /// </summary>
        [JsonPropertyName("date")]
        Date,
        /// <summary>
        /// array
        /// </summary>
        [JsonPropertyName("array")]
        Array
    }

    /// <summary>
    /// Key.
    /// </summary>
    public partial class Key : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Key type.
        /// </summary>
        [JsonPropertyName("type")]
        public CefSharp.DevTools.IndexedDB.KeyType Type
        {
            get;
            set;
        }

        /// <summary>
        /// Number value.
        /// </summary>
        [JsonPropertyName("number")]
        public double? Number
        {
            get;
            set;
        }

        /// <summary>
        /// String value.
        /// </summary>
        [JsonPropertyName("string")]
        public string String
        {
            get;
            set;
        }

        /// <summary>
        /// Date value.
        /// </summary>
        [JsonPropertyName("date")]
        public double? Date
        {
            get;
            set;
        }

        /// <summary>
        /// Array value.
        /// </summary>
        [JsonPropertyName("array")]
        public System.Collections.Generic.IList<CefSharp.DevTools.IndexedDB.Key> Array
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Key range.
    /// </summary>
    public partial class KeyRange : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Lower bound.
        /// </summary>
        [JsonPropertyName("lower")]
        public CefSharp.DevTools.IndexedDB.Key Lower
        {
            get;
            set;
        }

        /// <summary>
        /// Upper bound.
        /// </summary>
        [JsonPropertyName("upper")]
        public CefSharp.DevTools.IndexedDB.Key Upper
        {
            get;
            set;
        }

        /// <summary>
        /// If true lower bound is open.
        /// </summary>
        [JsonPropertyName("lowerOpen")]
        public bool LowerOpen
        {
            get;
            set;
        }

        /// <summary>
        /// If true upper bound is open.
        /// </summary>
        [JsonPropertyName("upperOpen")]
        public bool UpperOpen
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Data entry.
    /// </summary>
    public partial class DataEntry : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Key object.
        /// </summary>
        [JsonPropertyName("key")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.Runtime.RemoteObject Key
        {
            get;
            set;
        }

        /// <summary>
        /// Primary key object.
        /// </summary>
        [JsonPropertyName("primaryKey")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.Runtime.RemoteObject PrimaryKey
        {
            get;
            set;
        }

        /// <summary>
        /// Value object.
        /// </summary>
        [JsonPropertyName("value")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.Runtime.RemoteObject Value
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Key path type.
    /// </summary>
    public enum KeyPathType
    {
        /// <summary>
        /// null
        /// </summary>
        [JsonPropertyName("null")]
        Null,
        /// <summary>
        /// string
        /// </summary>
        [JsonPropertyName("string")]
        String,
        /// <summary>
        /// array
        /// </summary>
        [JsonPropertyName("array")]
        Array
    }

    /// <summary>
    /// Key path.
    /// </summary>
    public partial class KeyPath : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Key path type.
        /// </summary>
        [JsonPropertyName("type")]
        public CefSharp.DevTools.IndexedDB.KeyPathType Type
        {
            get;
            set;
        }

        /// <summary>
        /// String value.
        /// </summary>
        [JsonPropertyName("string")]
        public string String
        {
            get;
            set;
        }

        /// <summary>
        /// Array value.
        /// </summary>
        [JsonPropertyName("array")]
        public string[] Array
        {
            get;
            set;
        }
    }
}

namespace CefSharp.DevTools.Input
{
    /// <summary>
    /// TouchPoint
    /// </summary>
    public partial class TouchPoint : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// X coordinate of the event relative to the main frame&apos;s viewport in CSS pixels.
        /// </summary>
        [JsonPropertyName("x")]
        public double X
        {
            get;
            set;
        }

        /// <summary>
        /// Y coordinate of the event relative to the main frame&apos;s viewport in CSS pixels. 0 refers to
        /// the top of the viewport and Y increases as it proceeds towards the bottom of the viewport.
        /// </summary>
        [JsonPropertyName("y")]
        public double Y
        {
            get;
            set;
        }

        /// <summary>
        /// X radius of the touch area (default: 1.0).
        /// </summary>
        [JsonPropertyName("radiusX")]
        public double? RadiusX
        {
            get;
            set;
        }

        /// <summary>
        /// Y radius of the touch area (default: 1.0).
        /// </summary>
        [JsonPropertyName("radiusY")]
        public double? RadiusY
        {
            get;
            set;
        }

        /// <summary>
        /// Rotation angle (default: 0.0).
        /// </summary>
        [JsonPropertyName("rotationAngle")]
        public double? RotationAngle
        {
            get;
            set;
        }

        /// <summary>
        /// Force (default: 1.0).
        /// </summary>
        [JsonPropertyName("force")]
        public double? Force
        {
            get;
            set;
        }

        /// <summary>
        /// The normalized tangential pressure, which has a range of [-1,1] (default: 0).
        /// </summary>
        [JsonPropertyName("tangentialPressure")]
        public double? TangentialPressure
        {
            get;
            set;
        }

        /// <summary>
        /// The plane angle between the Y-Z plane and the plane containing both the stylus axis and the Y axis, in degrees of the range [-90,90], a positive tiltX is to the right (default: 0)
        /// </summary>
        [JsonPropertyName("tiltX")]
        public double? TiltX
        {
            get;
            set;
        }

        /// <summary>
        /// The plane angle between the X-Z plane and the plane containing both the stylus axis and the X axis, in degrees of the range [-90,90], a positive tiltY is towards the user (default: 0).
        /// </summary>
        [JsonPropertyName("tiltY")]
        public double? TiltY
        {
            get;
            set;
        }

        /// <summary>
        /// The clockwise rotation of a pen stylus around its own major axis, in degrees in the range [0,359] (default: 0).
        /// </summary>
        [JsonPropertyName("twist")]
        public int? Twist
        {
            get;
            set;
        }

        /// <summary>
        /// Identifier used to track touch sources between events, must be unique within an event.
        /// </summary>
        [JsonPropertyName("id")]
        public double? Id
        {
            get;
            set;
        }
    }

    /// <summary>
    /// GestureSourceType
    /// </summary>
    public enum GestureSourceType
    {
        /// <summary>
        /// default
        /// </summary>
        [JsonPropertyName("default")]
        Default,
        /// <summary>
        /// touch
        /// </summary>
        [JsonPropertyName("touch")]
        Touch,
        /// <summary>
        /// mouse
        /// </summary>
        [JsonPropertyName("mouse")]
        Mouse
    }

    /// <summary>
    /// MouseButton
    /// </summary>
    public enum MouseButton
    {
        /// <summary>
        /// none
        /// </summary>
        [JsonPropertyName("none")]
        None,
        /// <summary>
        /// left
        /// </summary>
        [JsonPropertyName("left")]
        Left,
        /// <summary>
        /// middle
        /// </summary>
        [JsonPropertyName("middle")]
        Middle,
        /// <summary>
        /// right
        /// </summary>
        [JsonPropertyName("right")]
        Right,
        /// <summary>
        /// back
        /// </summary>
        [JsonPropertyName("back")]
        Back,
        /// <summary>
        /// forward
        /// </summary>
        [JsonPropertyName("forward")]
        Forward
    }

    /// <summary>
    /// DragDataItem
    /// </summary>
    public partial class DragDataItem : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Mime type of the dragged data.
        /// </summary>
        [JsonPropertyName("mimeType")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string MimeType
        {
            get;
            set;
        }

        /// <summary>
        /// Depending of the value of `mimeType`, it contains the dragged link,
        /// text, HTML markup or any other data.
        /// </summary>
        [JsonPropertyName("data")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Data
        {
            get;
            set;
        }

        /// <summary>
        /// Title associated with a link. Only valid when `mimeType` == &quot;text/uri-list&quot;.
        /// </summary>
        [JsonPropertyName("title")]
        public string Title
        {
            get;
            set;
        }

        /// <summary>
        /// Stores the base URL for the contained markup. Only valid when `mimeType`
        /// == &quot;text/html&quot;.
        /// </summary>
        [JsonPropertyName("baseURL")]
        public string BaseURL
        {
            get;
            set;
        }
    }

    /// <summary>
    /// DragData
    /// </summary>
    public partial class DragData : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Items
        /// </summary>
        [JsonPropertyName("items")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public System.Collections.Generic.IList<CefSharp.DevTools.Input.DragDataItem> Items
        {
            get;
            set;
        }

        /// <summary>
        /// List of filenames that should be included when dropping
        /// </summary>
        [JsonPropertyName("files")]
        public string[] Files
        {
            get;
            set;
        }

        /// <summary>
        /// Bit field representing allowed drag operations. Copy = 1, Link = 2, Move = 16
        /// </summary>
        [JsonPropertyName("dragOperationsMask")]
        public int DragOperationsMask
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Emitted only when `Input.setInterceptDrags` is enabled. Use this data with `Input.dispatchDragEvent` to
    /// restore normal drag and drop behavior.
    /// </summary>
    public class DragInterceptedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Data
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("data")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.Input.DragData Data
        {
            get;
            private set;
        }
    }
}

namespace CefSharp.DevTools.Inspector
{
    /// <summary>
    /// Fired when remote debugging connection is about to be terminated. Contains detach reason.
    /// </summary>
    public class DetachedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// The reason why connection has been terminated.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("reason")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Reason
        {
            get;
            private set;
        }
    }
}

namespace CefSharp.DevTools.LayerTree
{
    /// <summary>
    /// Reason for rectangle to force scrolling on the main thread
    /// </summary>
    public enum ScrollRectType
    {
        /// <summary>
        /// RepaintsOnScroll
        /// </summary>
        [JsonPropertyName("RepaintsOnScroll")]
        RepaintsOnScroll,
        /// <summary>
        /// TouchEventHandler
        /// </summary>
        [JsonPropertyName("TouchEventHandler")]
        TouchEventHandler,
        /// <summary>
        /// WheelEventHandler
        /// </summary>
        [JsonPropertyName("WheelEventHandler")]
        WheelEventHandler
    }

    /// <summary>
    /// Rectangle where scrolling happens on the main thread.
    /// </summary>
    public partial class ScrollRect : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Rectangle itself.
        /// </summary>
        [JsonPropertyName("rect")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.DOM.Rect Rect
        {
            get;
            set;
        }

        /// <summary>
        /// Reason for rectangle to force scrolling on the main thread
        /// </summary>
        [JsonPropertyName("type")]
        public CefSharp.DevTools.LayerTree.ScrollRectType Type
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Sticky position constraints.
    /// </summary>
    public partial class StickyPositionConstraint : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Layout rectangle of the sticky element before being shifted
        /// </summary>
        [JsonPropertyName("stickyBoxRect")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.DOM.Rect StickyBoxRect
        {
            get;
            set;
        }

        /// <summary>
        /// Layout rectangle of the containing block of the sticky element
        /// </summary>
        [JsonPropertyName("containingBlockRect")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.DOM.Rect ContainingBlockRect
        {
            get;
            set;
        }

        /// <summary>
        /// The nearest sticky layer that shifts the sticky box
        /// </summary>
        [JsonPropertyName("nearestLayerShiftingStickyBox")]
        public string NearestLayerShiftingStickyBox
        {
            get;
            set;
        }

        /// <summary>
        /// The nearest sticky layer that shifts the containing block
        /// </summary>
        [JsonPropertyName("nearestLayerShiftingContainingBlock")]
        public string NearestLayerShiftingContainingBlock
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Serialized fragment of layer picture along with its offset within the layer.
    /// </summary>
    public partial class PictureTile : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Offset from owning layer left boundary
        /// </summary>
        [JsonPropertyName("x")]
        public double X
        {
            get;
            set;
        }

        /// <summary>
        /// Offset from owning layer top boundary
        /// </summary>
        [JsonPropertyName("y")]
        public double Y
        {
            get;
            set;
        }

        /// <summary>
        /// Base64-encoded snapshot data.
        /// </summary>
        [JsonPropertyName("picture")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public byte[] Picture
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Information about a compositing layer.
    /// </summary>
    public partial class Layer : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The unique id for this layer.
        /// </summary>
        [JsonPropertyName("layerId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string LayerId
        {
            get;
            set;
        }

        /// <summary>
        /// The id of parent (not present for root).
        /// </summary>
        [JsonPropertyName("parentLayerId")]
        public string ParentLayerId
        {
            get;
            set;
        }

        /// <summary>
        /// The backend id for the node associated with this layer.
        /// </summary>
        [JsonPropertyName("backendNodeId")]
        public int? BackendNodeId
        {
            get;
            set;
        }

        /// <summary>
        /// Offset from parent layer, X coordinate.
        /// </summary>
        [JsonPropertyName("offsetX")]
        public double OffsetX
        {
            get;
            set;
        }

        /// <summary>
        /// Offset from parent layer, Y coordinate.
        /// </summary>
        [JsonPropertyName("offsetY")]
        public double OffsetY
        {
            get;
            set;
        }

        /// <summary>
        /// Layer width.
        /// </summary>
        [JsonPropertyName("width")]
        public double Width
        {
            get;
            set;
        }

        /// <summary>
        /// Layer height.
        /// </summary>
        [JsonPropertyName("height")]
        public double Height
        {
            get;
            set;
        }

        /// <summary>
        /// Transformation matrix for layer, default is identity matrix
        /// </summary>
        [JsonPropertyName("transform")]
        public double[] Transform
        {
            get;
            set;
        }

        /// <summary>
        /// Transform anchor point X, absent if no transform specified
        /// </summary>
        [JsonPropertyName("anchorX")]
        public double? AnchorX
        {
            get;
            set;
        }

        /// <summary>
        /// Transform anchor point Y, absent if no transform specified
        /// </summary>
        [JsonPropertyName("anchorY")]
        public double? AnchorY
        {
            get;
            set;
        }

        /// <summary>
        /// Transform anchor point Z, absent if no transform specified
        /// </summary>
        [JsonPropertyName("anchorZ")]
        public double? AnchorZ
        {
            get;
            set;
        }

        /// <summary>
        /// Indicates how many time this layer has painted.
        /// </summary>
        [JsonPropertyName("paintCount")]
        public int PaintCount
        {
            get;
            set;
        }

        /// <summary>
        /// Indicates whether this layer hosts any content, rather than being used for
        /// transform/scrolling purposes only.
        /// </summary>
        [JsonPropertyName("drawsContent")]
        public bool DrawsContent
        {
            get;
            set;
        }

        /// <summary>
        /// Set if layer is not visible.
        /// </summary>
        [JsonPropertyName("invisible")]
        public bool? Invisible
        {
            get;
            set;
        }

        /// <summary>
        /// Rectangles scrolling on main thread only.
        /// </summary>
        [JsonPropertyName("scrollRects")]
        public System.Collections.Generic.IList<CefSharp.DevTools.LayerTree.ScrollRect> ScrollRects
        {
            get;
            set;
        }

        /// <summary>
        /// Sticky position constraint information
        /// </summary>
        [JsonPropertyName("stickyPositionConstraint")]
        public CefSharp.DevTools.LayerTree.StickyPositionConstraint StickyPositionConstraint
        {
            get;
            set;
        }
    }

    /// <summary>
    /// layerPainted
    /// </summary>
    public class LayerPaintedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// The id of the painted layer.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("layerId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string LayerId
        {
            get;
            private set;
        }

        /// <summary>
        /// Clip rectangle.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("clip")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.DOM.Rect Clip
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// layerTreeDidChange
    /// </summary>
    public class LayerTreeDidChangeEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Layer tree, absent if not in the compositing mode.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("layers")]
        public System.Collections.Generic.IList<CefSharp.DevTools.LayerTree.Layer> Layers
        {
            get;
            private set;
        }
    }
}

namespace CefSharp.DevTools.Log
{
    /// <summary>
    /// Log entry source.
    /// </summary>
    public enum LogEntrySource
    {
        /// <summary>
        /// xml
        /// </summary>
        [JsonPropertyName("xml")]
        Xml,
        /// <summary>
        /// javascript
        /// </summary>
        [JsonPropertyName("javascript")]
        Javascript,
        /// <summary>
        /// network
        /// </summary>
        [JsonPropertyName("network")]
        Network,
        /// <summary>
        /// storage
        /// </summary>
        [JsonPropertyName("storage")]
        Storage,
        /// <summary>
        /// appcache
        /// </summary>
        [JsonPropertyName("appcache")]
        Appcache,
        /// <summary>
        /// rendering
        /// </summary>
        [JsonPropertyName("rendering")]
        Rendering,
        /// <summary>
        /// security
        /// </summary>
        [JsonPropertyName("security")]
        Security,
        /// <summary>
        /// deprecation
        /// </summary>
        [JsonPropertyName("deprecation")]
        Deprecation,
        /// <summary>
        /// worker
        /// </summary>
        [JsonPropertyName("worker")]
        Worker,
        /// <summary>
        /// violation
        /// </summary>
        [JsonPropertyName("violation")]
        Violation,
        /// <summary>
        /// intervention
        /// </summary>
        [JsonPropertyName("intervention")]
        Intervention,
        /// <summary>
        /// recommendation
        /// </summary>
        [JsonPropertyName("recommendation")]
        Recommendation,
        /// <summary>
        /// other
        /// </summary>
        [JsonPropertyName("other")]
        Other
    }

    /// <summary>
    /// Log entry severity.
    /// </summary>
    public enum LogEntryLevel
    {
        /// <summary>
        /// verbose
        /// </summary>
        [JsonPropertyName("verbose")]
        Verbose,
        /// <summary>
        /// info
        /// </summary>
        [JsonPropertyName("info")]
        Info,
        /// <summary>
        /// warning
        /// </summary>
        [JsonPropertyName("warning")]
        Warning,
        /// <summary>
        /// error
        /// </summary>
        [JsonPropertyName("error")]
        Error
    }

    /// <summary>
    /// LogEntryCategory
    /// </summary>
    public enum LogEntryCategory
    {
        /// <summary>
        /// cors
        /// </summary>
        [JsonPropertyName("cors")]
        Cors
    }

    /// <summary>
    /// Log entry.
    /// </summary>
    public partial class LogEntry : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Log entry source.
        /// </summary>
        [JsonPropertyName("source")]
        public CefSharp.DevTools.Log.LogEntrySource Source
        {
            get;
            set;
        }

        /// <summary>
        /// Log entry severity.
        /// </summary>
        [JsonPropertyName("level")]
        public CefSharp.DevTools.Log.LogEntryLevel Level
        {
            get;
            set;
        }

        /// <summary>
        /// Logged text.
        /// </summary>
        [JsonPropertyName("text")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Text
        {
            get;
            set;
        }

        /// <summary>
        /// Category
        /// </summary>
        [JsonPropertyName("category")]
        public CefSharp.DevTools.Log.LogEntryCategory? Category
        {
            get;
            set;
        }

        /// <summary>
        /// Timestamp when this entry was added.
        /// </summary>
        [JsonPropertyName("timestamp")]
        public double Timestamp
        {
            get;
            set;
        }

        /// <summary>
        /// URL of the resource if known.
        /// </summary>
        [JsonPropertyName("url")]
        public string Url
        {
            get;
            set;
        }

        /// <summary>
        /// Line number in the resource.
        /// </summary>
        [JsonPropertyName("lineNumber")]
        public int? LineNumber
        {
            get;
            set;
        }

        /// <summary>
        /// JavaScript stack trace.
        /// </summary>
        [JsonPropertyName("stackTrace")]
        public CefSharp.DevTools.Runtime.StackTrace StackTrace
        {
            get;
            set;
        }

        /// <summary>
        /// Identifier of the network request associated with this entry.
        /// </summary>
        [JsonPropertyName("networkRequestId")]
        public string NetworkRequestId
        {
            get;
            set;
        }

        /// <summary>
        /// Identifier of the worker associated with this entry.
        /// </summary>
        [JsonPropertyName("workerId")]
        public string WorkerId
        {
            get;
            set;
        }

        /// <summary>
        /// Call arguments.
        /// </summary>
        [JsonPropertyName("args")]
        public System.Collections.Generic.IList<CefSharp.DevTools.Runtime.RemoteObject> Args
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Violation type.
    /// </summary>
    public enum ViolationSettingName
    {
        /// <summary>
        /// longTask
        /// </summary>
        [JsonPropertyName("longTask")]
        LongTask,
        /// <summary>
        /// longLayout
        /// </summary>
        [JsonPropertyName("longLayout")]
        LongLayout,
        /// <summary>
        /// blockedEvent
        /// </summary>
        [JsonPropertyName("blockedEvent")]
        BlockedEvent,
        /// <summary>
        /// blockedParser
        /// </summary>
        [JsonPropertyName("blockedParser")]
        BlockedParser,
        /// <summary>
        /// discouragedAPIUse
        /// </summary>
        [JsonPropertyName("discouragedAPIUse")]
        DiscouragedAPIUse,
        /// <summary>
        /// handler
        /// </summary>
        [JsonPropertyName("handler")]
        Handler,
        /// <summary>
        /// recurringHandler
        /// </summary>
        [JsonPropertyName("recurringHandler")]
        RecurringHandler
    }

    /// <summary>
    /// Violation configuration setting.
    /// </summary>
    public partial class ViolationSetting : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Violation type.
        /// </summary>
        [JsonPropertyName("name")]
        public CefSharp.DevTools.Log.ViolationSettingName Name
        {
            get;
            set;
        }

        /// <summary>
        /// Time threshold to trigger upon.
        /// </summary>
        [JsonPropertyName("threshold")]
        public double Threshold
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Issued when new message was logged.
    /// </summary>
    public class EntryAddedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// The entry.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("entry")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.Log.LogEntry Entry
        {
            get;
            private set;
        }
    }
}

namespace CefSharp.DevTools.Memory
{
    /// <summary>
    /// Memory pressure level.
    /// </summary>
    public enum PressureLevel
    {
        /// <summary>
        /// moderate
        /// </summary>
        [JsonPropertyName("moderate")]
        Moderate,
        /// <summary>
        /// critical
        /// </summary>
        [JsonPropertyName("critical")]
        Critical
    }

    /// <summary>
    /// Heap profile sample.
    /// </summary>
    public partial class SamplingProfileNode : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Size of the sampled allocation.
        /// </summary>
        [JsonPropertyName("size")]
        public double Size
        {
            get;
            set;
        }

        /// <summary>
        /// Total bytes attributed to this sample.
        /// </summary>
        [JsonPropertyName("total")]
        public double Total
        {
            get;
            set;
        }

        /// <summary>
        /// Execution stack at the point of allocation.
        /// </summary>
        [JsonPropertyName("stack")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string[] Stack
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Array of heap profile samples.
    /// </summary>
    public partial class SamplingProfile : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Samples
        /// </summary>
        [JsonPropertyName("samples")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public System.Collections.Generic.IList<CefSharp.DevTools.Memory.SamplingProfileNode> Samples
        {
            get;
            set;
        }

        /// <summary>
        /// Modules
        /// </summary>
        [JsonPropertyName("modules")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public System.Collections.Generic.IList<CefSharp.DevTools.Memory.Module> Modules
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Executable module information
    /// </summary>
    public partial class Module : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Name of the module.
        /// </summary>
        [JsonPropertyName("name")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Name
        {
            get;
            set;
        }

        /// <summary>
        /// UUID of the module.
        /// </summary>
        [JsonPropertyName("uuid")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Uuid
        {
            get;
            set;
        }

        /// <summary>
        /// Base address where the module is loaded into memory. Encoded as a decimal
        /// or hexadecimal (0x prefixed) string.
        /// </summary>
        [JsonPropertyName("baseAddress")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string BaseAddress
        {
            get;
            set;
        }

        /// <summary>
        /// Size of the module in bytes.
        /// </summary>
        [JsonPropertyName("size")]
        public double Size
        {
            get;
            set;
        }
    }
}

namespace CefSharp.DevTools.Network
{
    /// <summary>
    /// Resource type as it was perceived by the rendering engine.
    /// </summary>
    public enum ResourceType
    {
        /// <summary>
        /// Document
        /// </summary>
        [JsonPropertyName("Document")]
        Document,
        /// <summary>
        /// Stylesheet
        /// </summary>
        [JsonPropertyName("Stylesheet")]
        Stylesheet,
        /// <summary>
        /// Image
        /// </summary>
        [JsonPropertyName("Image")]
        Image,
        /// <summary>
        /// Media
        /// </summary>
        [JsonPropertyName("Media")]
        Media,
        /// <summary>
        /// Font
        /// </summary>
        [JsonPropertyName("Font")]
        Font,
        /// <summary>
        /// Script
        /// </summary>
        [JsonPropertyName("Script")]
        Script,
        /// <summary>
        /// TextTrack
        /// </summary>
        [JsonPropertyName("TextTrack")]
        TextTrack,
        /// <summary>
        /// XHR
        /// </summary>
        [JsonPropertyName("XHR")]
        XHR,
        /// <summary>
        /// Fetch
        /// </summary>
        [JsonPropertyName("Fetch")]
        Fetch,
        /// <summary>
        /// Prefetch
        /// </summary>
        [JsonPropertyName("Prefetch")]
        Prefetch,
        /// <summary>
        /// EventSource
        /// </summary>
        [JsonPropertyName("EventSource")]
        EventSource,
        /// <summary>
        /// WebSocket
        /// </summary>
        [JsonPropertyName("WebSocket")]
        WebSocket,
        /// <summary>
        /// Manifest
        /// </summary>
        [JsonPropertyName("Manifest")]
        Manifest,
        /// <summary>
        /// SignedExchange
        /// </summary>
        [JsonPropertyName("SignedExchange")]
        SignedExchange,
        /// <summary>
        /// Ping
        /// </summary>
        [JsonPropertyName("Ping")]
        Ping,
        /// <summary>
        /// CSPViolationReport
        /// </summary>
        [JsonPropertyName("CSPViolationReport")]
        CSPViolationReport,
        /// <summary>
        /// Preflight
        /// </summary>
        [JsonPropertyName("Preflight")]
        Preflight,
        /// <summary>
        /// Other
        /// </summary>
        [JsonPropertyName("Other")]
        Other
    }

    /// <summary>
    /// Network level fetch failure reason.
    /// </summary>
    public enum ErrorReason
    {
        /// <summary>
        /// Failed
        /// </summary>
        [JsonPropertyName("Failed")]
        Failed,
        /// <summary>
        /// Aborted
        /// </summary>
        [JsonPropertyName("Aborted")]
        Aborted,
        /// <summary>
        /// TimedOut
        /// </summary>
        [JsonPropertyName("TimedOut")]
        TimedOut,
        /// <summary>
        /// AccessDenied
        /// </summary>
        [JsonPropertyName("AccessDenied")]
        AccessDenied,
        /// <summary>
        /// ConnectionClosed
        /// </summary>
        [JsonPropertyName("ConnectionClosed")]
        ConnectionClosed,
        /// <summary>
        /// ConnectionReset
        /// </summary>
        [JsonPropertyName("ConnectionReset")]
        ConnectionReset,
        /// <summary>
        /// ConnectionRefused
        /// </summary>
        [JsonPropertyName("ConnectionRefused")]
        ConnectionRefused,
        /// <summary>
        /// ConnectionAborted
        /// </summary>
        [JsonPropertyName("ConnectionAborted")]
        ConnectionAborted,
        /// <summary>
        /// ConnectionFailed
        /// </summary>
        [JsonPropertyName("ConnectionFailed")]
        ConnectionFailed,
        /// <summary>
        /// NameNotResolved
        /// </summary>
        [JsonPropertyName("NameNotResolved")]
        NameNotResolved,
        /// <summary>
        /// InternetDisconnected
        /// </summary>
        [JsonPropertyName("InternetDisconnected")]
        InternetDisconnected,
        /// <summary>
        /// AddressUnreachable
        /// </summary>
        [JsonPropertyName("AddressUnreachable")]
        AddressUnreachable,
        /// <summary>
        /// BlockedByClient
        /// </summary>
        [JsonPropertyName("BlockedByClient")]
        BlockedByClient,
        /// <summary>
        /// BlockedByResponse
        /// </summary>
        [JsonPropertyName("BlockedByResponse")]
        BlockedByResponse
    }

    /// <summary>
    /// The underlying connection technology that the browser is supposedly using.
    /// </summary>
    public enum ConnectionType
    {
        /// <summary>
        /// none
        /// </summary>
        [JsonPropertyName("none")]
        None,
        /// <summary>
        /// cellular2g
        /// </summary>
        [JsonPropertyName("cellular2g")]
        Cellular2g,
        /// <summary>
        /// cellular3g
        /// </summary>
        [JsonPropertyName("cellular3g")]
        Cellular3g,
        /// <summary>
        /// cellular4g
        /// </summary>
        [JsonPropertyName("cellular4g")]
        Cellular4g,
        /// <summary>
        /// bluetooth
        /// </summary>
        [JsonPropertyName("bluetooth")]
        Bluetooth,
        /// <summary>
        /// ethernet
        /// </summary>
        [JsonPropertyName("ethernet")]
        Ethernet,
        /// <summary>
        /// wifi
        /// </summary>
        [JsonPropertyName("wifi")]
        Wifi,
        /// <summary>
        /// wimax
        /// </summary>
        [JsonPropertyName("wimax")]
        Wimax,
        /// <summary>
        /// other
        /// </summary>
        [JsonPropertyName("other")]
        Other
    }

    /// <summary>
    /// Represents the cookie&apos;s &apos;SameSite&apos; status:
    /// https://tools.ietf.org/html/draft-west-first-party-cookies
    /// </summary>
    public enum CookieSameSite
    {
        /// <summary>
        /// Strict
        /// </summary>
        [JsonPropertyName("Strict")]
        Strict,
        /// <summary>
        /// Lax
        /// </summary>
        [JsonPropertyName("Lax")]
        Lax,
        /// <summary>
        /// None
        /// </summary>
        [JsonPropertyName("None")]
        None
    }

    /// <summary>
    /// Represents the cookie&apos;s &apos;Priority&apos; status:
    /// https://tools.ietf.org/html/draft-west-cookie-priority-00
    /// </summary>
    public enum CookiePriority
    {
        /// <summary>
        /// Low
        /// </summary>
        [JsonPropertyName("Low")]
        Low,
        /// <summary>
        /// Medium
        /// </summary>
        [JsonPropertyName("Medium")]
        Medium,
        /// <summary>
        /// High
        /// </summary>
        [JsonPropertyName("High")]
        High
    }

    /// <summary>
    /// Represents the source scheme of the origin that originally set the cookie.
    /// A value of &quot;Unset&quot; allows protocol clients to emulate legacy cookie scope for the scheme.
    /// This is a temporary ability and it will be removed in the future.
    /// </summary>
    public enum CookieSourceScheme
    {
        /// <summary>
        /// Unset
        /// </summary>
        [JsonPropertyName("Unset")]
        Unset,
        /// <summary>
        /// NonSecure
        /// </summary>
        [JsonPropertyName("NonSecure")]
        NonSecure,
        /// <summary>
        /// Secure
        /// </summary>
        [JsonPropertyName("Secure")]
        Secure
    }

    /// <summary>
    /// Timing information for the request.
    /// </summary>
    public partial class ResourceTiming : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Timing&apos;s requestTime is a baseline in seconds, while the other numbers are ticks in
        /// milliseconds relatively to this requestTime.
        /// </summary>
        [JsonPropertyName("requestTime")]
        public double RequestTime
        {
            get;
            set;
        }

        /// <summary>
        /// Started resolving proxy.
        /// </summary>
        [JsonPropertyName("proxyStart")]
        public double ProxyStart
        {
            get;
            set;
        }

        /// <summary>
        /// Finished resolving proxy.
        /// </summary>
        [JsonPropertyName("proxyEnd")]
        public double ProxyEnd
        {
            get;
            set;
        }

        /// <summary>
        /// Started DNS address resolve.
        /// </summary>
        [JsonPropertyName("dnsStart")]
        public double DnsStart
        {
            get;
            set;
        }

        /// <summary>
        /// Finished DNS address resolve.
        /// </summary>
        [JsonPropertyName("dnsEnd")]
        public double DnsEnd
        {
            get;
            set;
        }

        /// <summary>
        /// Started connecting to the remote host.
        /// </summary>
        [JsonPropertyName("connectStart")]
        public double ConnectStart
        {
            get;
            set;
        }

        /// <summary>
        /// Connected to the remote host.
        /// </summary>
        [JsonPropertyName("connectEnd")]
        public double ConnectEnd
        {
            get;
            set;
        }

        /// <summary>
        /// Started SSL handshake.
        /// </summary>
        [JsonPropertyName("sslStart")]
        public double SslStart
        {
            get;
            set;
        }

        /// <summary>
        /// Finished SSL handshake.
        /// </summary>
        [JsonPropertyName("sslEnd")]
        public double SslEnd
        {
            get;
            set;
        }

        /// <summary>
        /// Started running ServiceWorker.
        /// </summary>
        [JsonPropertyName("workerStart")]
        public double WorkerStart
        {
            get;
            set;
        }

        /// <summary>
        /// Finished Starting ServiceWorker.
        /// </summary>
        [JsonPropertyName("workerReady")]
        public double WorkerReady
        {
            get;
            set;
        }

        /// <summary>
        /// Started fetch event.
        /// </summary>
        [JsonPropertyName("workerFetchStart")]
        public double WorkerFetchStart
        {
            get;
            set;
        }

        /// <summary>
        /// Settled fetch event respondWith promise.
        /// </summary>
        [JsonPropertyName("workerRespondWithSettled")]
        public double WorkerRespondWithSettled
        {
            get;
            set;
        }

        /// <summary>
        /// Started ServiceWorker static routing source evaluation.
        /// </summary>
        [JsonPropertyName("workerRouterEvaluationStart")]
        public double? WorkerRouterEvaluationStart
        {
            get;
            set;
        }

        /// <summary>
        /// Started cache lookup when the source was evaluated to `cache`.
        /// </summary>
        [JsonPropertyName("workerCacheLookupStart")]
        public double? WorkerCacheLookupStart
        {
            get;
            set;
        }

        /// <summary>
        /// Started sending request.
        /// </summary>
        [JsonPropertyName("sendStart")]
        public double SendStart
        {
            get;
            set;
        }

        /// <summary>
        /// Finished sending request.
        /// </summary>
        [JsonPropertyName("sendEnd")]
        public double SendEnd
        {
            get;
            set;
        }

        /// <summary>
        /// Time the server started pushing request.
        /// </summary>
        [JsonPropertyName("pushStart")]
        public double PushStart
        {
            get;
            set;
        }

        /// <summary>
        /// Time the server finished pushing request.
        /// </summary>
        [JsonPropertyName("pushEnd")]
        public double PushEnd
        {
            get;
            set;
        }

        /// <summary>
        /// Started receiving response headers.
        /// </summary>
        [JsonPropertyName("receiveHeadersStart")]
        public double ReceiveHeadersStart
        {
            get;
            set;
        }

        /// <summary>
        /// Finished receiving response headers.
        /// </summary>
        [JsonPropertyName("receiveHeadersEnd")]
        public double ReceiveHeadersEnd
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Loading priority of a resource request.
    /// </summary>
    public enum ResourcePriority
    {
        /// <summary>
        /// VeryLow
        /// </summary>
        [JsonPropertyName("VeryLow")]
        VeryLow,
        /// <summary>
        /// Low
        /// </summary>
        [JsonPropertyName("Low")]
        Low,
        /// <summary>
        /// Medium
        /// </summary>
        [JsonPropertyName("Medium")]
        Medium,
        /// <summary>
        /// High
        /// </summary>
        [JsonPropertyName("High")]
        High,
        /// <summary>
        /// VeryHigh
        /// </summary>
        [JsonPropertyName("VeryHigh")]
        VeryHigh
    }

    /// <summary>
    /// Post data entry for HTTP request
    /// </summary>
    public partial class PostDataEntry : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Bytes
        /// </summary>
        [JsonPropertyName("bytes")]
        public byte[] Bytes
        {
            get;
            set;
        }
    }

    /// <summary>
    /// The referrer policy of the request, as defined in https://www.w3.org/TR/referrer-policy/
    /// </summary>
    public enum RequestReferrerPolicy
    {
        /// <summary>
        /// unsafe-url
        /// </summary>
        [JsonPropertyName("unsafe-url")]
        UnsafeUrl,
        /// <summary>
        /// no-referrer-when-downgrade
        /// </summary>
        [JsonPropertyName("no-referrer-when-downgrade")]
        NoReferrerWhenDowngrade,
        /// <summary>
        /// no-referrer
        /// </summary>
        [JsonPropertyName("no-referrer")]
        NoReferrer,
        /// <summary>
        /// origin
        /// </summary>
        [JsonPropertyName("origin")]
        Origin,
        /// <summary>
        /// origin-when-cross-origin
        /// </summary>
        [JsonPropertyName("origin-when-cross-origin")]
        OriginWhenCrossOrigin,
        /// <summary>
        /// same-origin
        /// </summary>
        [JsonPropertyName("same-origin")]
        SameOrigin,
        /// <summary>
        /// strict-origin
        /// </summary>
        [JsonPropertyName("strict-origin")]
        StrictOrigin,
        /// <summary>
        /// strict-origin-when-cross-origin
        /// </summary>
        [JsonPropertyName("strict-origin-when-cross-origin")]
        StrictOriginWhenCrossOrigin
    }

    /// <summary>
    /// HTTP request data.
    /// </summary>
    public partial class Request : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Request URL (without fragment).
        /// </summary>
        [JsonPropertyName("url")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Url
        {
            get;
            set;
        }

        /// <summary>
        /// Fragment of the requested URL starting with hash, if present.
        /// </summary>
        [JsonPropertyName("urlFragment")]
        public string UrlFragment
        {
            get;
            set;
        }

        /// <summary>
        /// HTTP request method.
        /// </summary>
        [JsonPropertyName("method")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Method
        {
            get;
            set;
        }

        /// <summary>
        /// HTTP request headers.
        /// </summary>
        [JsonPropertyName("headers")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.Network.Headers Headers
        {
            get;
            set;
        }

        /// <summary>
        /// HTTP POST request data.
        /// Use postDataEntries instead.
        /// </summary>
        [JsonPropertyName("postData")]
        public string PostData
        {
            get;
            set;
        }

        /// <summary>
        /// True when the request has POST data. Note that postData might still be omitted when this flag is true when the data is too long.
        /// </summary>
        [JsonPropertyName("hasPostData")]
        public bool? HasPostData
        {
            get;
            set;
        }

        /// <summary>
        /// Request body elements (post data broken into individual entries).
        /// </summary>
        [JsonPropertyName("postDataEntries")]
        public System.Collections.Generic.IList<CefSharp.DevTools.Network.PostDataEntry> PostDataEntries
        {
            get;
            set;
        }

        /// <summary>
        /// The mixed content type of the request.
        /// </summary>
        [JsonPropertyName("mixedContentType")]
        public CefSharp.DevTools.Security.MixedContentType? MixedContentType
        {
            get;
            set;
        }

        /// <summary>
        /// Priority of the resource request at the time request is sent.
        /// </summary>
        [JsonPropertyName("initialPriority")]
        public CefSharp.DevTools.Network.ResourcePriority InitialPriority
        {
            get;
            set;
        }

        /// <summary>
        /// The referrer policy of the request, as defined in https://www.w3.org/TR/referrer-policy/
        /// </summary>
        [JsonPropertyName("referrerPolicy")]
        public CefSharp.DevTools.Network.RequestReferrerPolicy ReferrerPolicy
        {
            get;
            set;
        }

        /// <summary>
        /// Whether is loaded via link preload.
        /// </summary>
        [JsonPropertyName("isLinkPreload")]
        public bool? IsLinkPreload
        {
            get;
            set;
        }

        /// <summary>
        /// Set for requests when the TrustToken API is used. Contains the parameters
        /// passed by the developer (e.g. via &quot;fetch&quot;) as understood by the backend.
        /// </summary>
        [JsonPropertyName("trustTokenParams")]
        public CefSharp.DevTools.Network.TrustTokenParams TrustTokenParams
        {
            get;
            set;
        }

        /// <summary>
        /// True if this resource request is considered to be the &apos;same site&apos; as the
        /// request corresponding to the main frame.
        /// </summary>
        [JsonPropertyName("isSameSite")]
        public bool? IsSameSite
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Details of a signed certificate timestamp (SCT).
    /// </summary>
    public partial class SignedCertificateTimestamp : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Validation status.
        /// </summary>
        [JsonPropertyName("status")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Status
        {
            get;
            set;
        }

        /// <summary>
        /// Origin.
        /// </summary>
        [JsonPropertyName("origin")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Origin
        {
            get;
            set;
        }

        /// <summary>
        /// Log name / description.
        /// </summary>
        [JsonPropertyName("logDescription")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string LogDescription
        {
            get;
            set;
        }

        /// <summary>
        /// Log ID.
        /// </summary>
        [JsonPropertyName("logId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string LogId
        {
            get;
            set;
        }

        /// <summary>
        /// Issuance date. Unlike TimeSinceEpoch, this contains the number of
        /// milliseconds since January 1, 1970, UTC, not the number of seconds.
        /// </summary>
        [JsonPropertyName("timestamp")]
        public double Timestamp
        {
            get;
            set;
        }

        /// <summary>
        /// Hash algorithm.
        /// </summary>
        [JsonPropertyName("hashAlgorithm")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string HashAlgorithm
        {
            get;
            set;
        }

        /// <summary>
        /// Signature algorithm.
        /// </summary>
        [JsonPropertyName("signatureAlgorithm")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string SignatureAlgorithm
        {
            get;
            set;
        }

        /// <summary>
        /// Signature data.
        /// </summary>
        [JsonPropertyName("signatureData")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string SignatureData
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Security details about a request.
    /// </summary>
    public partial class SecurityDetails : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Protocol name (e.g. &quot;TLS 1.2&quot; or &quot;QUIC&quot;).
        /// </summary>
        [JsonPropertyName("protocol")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Protocol
        {
            get;
            set;
        }

        /// <summary>
        /// Key Exchange used by the connection, or the empty string if not applicable.
        /// </summary>
        [JsonPropertyName("keyExchange")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string KeyExchange
        {
            get;
            set;
        }

        /// <summary>
        /// (EC)DH group used by the connection, if applicable.
        /// </summary>
        [JsonPropertyName("keyExchangeGroup")]
        public string KeyExchangeGroup
        {
            get;
            set;
        }

        /// <summary>
        /// Cipher name.
        /// </summary>
        [JsonPropertyName("cipher")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Cipher
        {
            get;
            set;
        }

        /// <summary>
        /// TLS MAC. Note that AEAD ciphers do not have separate MACs.
        /// </summary>
        [JsonPropertyName("mac")]
        public string Mac
        {
            get;
            set;
        }

        /// <summary>
        /// Certificate ID value.
        /// </summary>
        [JsonPropertyName("certificateId")]
        public int CertificateId
        {
            get;
            set;
        }

        /// <summary>
        /// Certificate subject name.
        /// </summary>
        [JsonPropertyName("subjectName")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string SubjectName
        {
            get;
            set;
        }

        /// <summary>
        /// Subject Alternative Name (SAN) DNS names and IP addresses.
        /// </summary>
        [JsonPropertyName("sanList")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string[] SanList
        {
            get;
            set;
        }

        /// <summary>
        /// Name of the issuing CA.
        /// </summary>
        [JsonPropertyName("issuer")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Issuer
        {
            get;
            set;
        }

        /// <summary>
        /// Certificate valid from date.
        /// </summary>
        [JsonPropertyName("validFrom")]
        public double ValidFrom
        {
            get;
            set;
        }

        /// <summary>
        /// Certificate valid to (expiration) date
        /// </summary>
        [JsonPropertyName("validTo")]
        public double ValidTo
        {
            get;
            set;
        }

        /// <summary>
        /// List of signed certificate timestamps (SCTs).
        /// </summary>
        [JsonPropertyName("signedCertificateTimestampList")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public System.Collections.Generic.IList<CefSharp.DevTools.Network.SignedCertificateTimestamp> SignedCertificateTimestampList
        {
            get;
            set;
        }

        /// <summary>
        /// Whether the request complied with Certificate Transparency policy
        /// </summary>
        [JsonPropertyName("certificateTransparencyCompliance")]
        public CefSharp.DevTools.Network.CertificateTransparencyCompliance CertificateTransparencyCompliance
        {
            get;
            set;
        }

        /// <summary>
        /// The signature algorithm used by the server in the TLS server signature,
        /// represented as a TLS SignatureScheme code point. Omitted if not
        /// applicable or not known.
        /// </summary>
        [JsonPropertyName("serverSignatureAlgorithm")]
        public int? ServerSignatureAlgorithm
        {
            get;
            set;
        }

        /// <summary>
        /// Whether the connection used Encrypted ClientHello
        /// </summary>
        [JsonPropertyName("encryptedClientHello")]
        public bool EncryptedClientHello
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Whether the request complied with Certificate Transparency policy.
    /// </summary>
    public enum CertificateTransparencyCompliance
    {
        /// <summary>
        /// unknown
        /// </summary>
        [JsonPropertyName("unknown")]
        Unknown,
        /// <summary>
        /// not-compliant
        /// </summary>
        [JsonPropertyName("not-compliant")]
        NotCompliant,
        /// <summary>
        /// compliant
        /// </summary>
        [JsonPropertyName("compliant")]
        Compliant
    }

    /// <summary>
    /// The reason why request was blocked.
    /// </summary>
    public enum BlockedReason
    {
        /// <summary>
        /// other
        /// </summary>
        [JsonPropertyName("other")]
        Other,
        /// <summary>
        /// csp
        /// </summary>
        [JsonPropertyName("csp")]
        Csp,
        /// <summary>
        /// mixed-content
        /// </summary>
        [JsonPropertyName("mixed-content")]
        MixedContent,
        /// <summary>
        /// origin
        /// </summary>
        [JsonPropertyName("origin")]
        Origin,
        /// <summary>
        /// inspector
        /// </summary>
        [JsonPropertyName("inspector")]
        Inspector,
        /// <summary>
        /// subresource-filter
        /// </summary>
        [JsonPropertyName("subresource-filter")]
        SubresourceFilter,
        /// <summary>
        /// content-type
        /// </summary>
        [JsonPropertyName("content-type")]
        ContentType,
        /// <summary>
        /// coep-frame-resource-needs-coep-header
        /// </summary>
        [JsonPropertyName("coep-frame-resource-needs-coep-header")]
        CoepFrameResourceNeedsCoepHeader,
        /// <summary>
        /// coop-sandboxed-iframe-cannot-navigate-to-coop-page
        /// </summary>
        [JsonPropertyName("coop-sandboxed-iframe-cannot-navigate-to-coop-page")]
        CoopSandboxedIframeCannotNavigateToCoopPage,
        /// <summary>
        /// corp-not-same-origin
        /// </summary>
        [JsonPropertyName("corp-not-same-origin")]
        CorpNotSameOrigin,
        /// <summary>
        /// corp-not-same-origin-after-defaulted-to-same-origin-by-coep
        /// </summary>
        [JsonPropertyName("corp-not-same-origin-after-defaulted-to-same-origin-by-coep")]
        CorpNotSameOriginAfterDefaultedToSameOriginByCoep,
        /// <summary>
        /// corp-not-same-origin-after-defaulted-to-same-origin-by-dip
        /// </summary>
        [JsonPropertyName("corp-not-same-origin-after-defaulted-to-same-origin-by-dip")]
        CorpNotSameOriginAfterDefaultedToSameOriginByDip,
        /// <summary>
        /// corp-not-same-origin-after-defaulted-to-same-origin-by-coep-and-dip
        /// </summary>
        [JsonPropertyName("corp-not-same-origin-after-defaulted-to-same-origin-by-coep-and-dip")]
        CorpNotSameOriginAfterDefaultedToSameOriginByCoepAndDip,
        /// <summary>
        /// corp-not-same-site
        /// </summary>
        [JsonPropertyName("corp-not-same-site")]
        CorpNotSameSite
    }

    /// <summary>
    /// The reason why request was blocked.
    /// </summary>
    public enum CorsError
    {
        /// <summary>
        /// DisallowedByMode
        /// </summary>
        [JsonPropertyName("DisallowedByMode")]
        DisallowedByMode,
        /// <summary>
        /// InvalidResponse
        /// </summary>
        [JsonPropertyName("InvalidResponse")]
        InvalidResponse,
        /// <summary>
        /// WildcardOriginNotAllowed
        /// </summary>
        [JsonPropertyName("WildcardOriginNotAllowed")]
        WildcardOriginNotAllowed,
        /// <summary>
        /// MissingAllowOriginHeader
        /// </summary>
        [JsonPropertyName("MissingAllowOriginHeader")]
        MissingAllowOriginHeader,
        /// <summary>
        /// MultipleAllowOriginValues
        /// </summary>
        [JsonPropertyName("MultipleAllowOriginValues")]
        MultipleAllowOriginValues,
        /// <summary>
        /// InvalidAllowOriginValue
        /// </summary>
        [JsonPropertyName("InvalidAllowOriginValue")]
        InvalidAllowOriginValue,
        /// <summary>
        /// AllowOriginMismatch
        /// </summary>
        [JsonPropertyName("AllowOriginMismatch")]
        AllowOriginMismatch,
        /// <summary>
        /// InvalidAllowCredentials
        /// </summary>
        [JsonPropertyName("InvalidAllowCredentials")]
        InvalidAllowCredentials,
        /// <summary>
        /// CorsDisabledScheme
        /// </summary>
        [JsonPropertyName("CorsDisabledScheme")]
        CorsDisabledScheme,
        /// <summary>
        /// PreflightInvalidStatus
        /// </summary>
        [JsonPropertyName("PreflightInvalidStatus")]
        PreflightInvalidStatus,
        /// <summary>
        /// PreflightDisallowedRedirect
        /// </summary>
        [JsonPropertyName("PreflightDisallowedRedirect")]
        PreflightDisallowedRedirect,
        /// <summary>
        /// PreflightWildcardOriginNotAllowed
        /// </summary>
        [JsonPropertyName("PreflightWildcardOriginNotAllowed")]
        PreflightWildcardOriginNotAllowed,
        /// <summary>
        /// PreflightMissingAllowOriginHeader
        /// </summary>
        [JsonPropertyName("PreflightMissingAllowOriginHeader")]
        PreflightMissingAllowOriginHeader,
        /// <summary>
        /// PreflightMultipleAllowOriginValues
        /// </summary>
        [JsonPropertyName("PreflightMultipleAllowOriginValues")]
        PreflightMultipleAllowOriginValues,
        /// <summary>
        /// PreflightInvalidAllowOriginValue
        /// </summary>
        [JsonPropertyName("PreflightInvalidAllowOriginValue")]
        PreflightInvalidAllowOriginValue,
        /// <summary>
        /// PreflightAllowOriginMismatch
        /// </summary>
        [JsonPropertyName("PreflightAllowOriginMismatch")]
        PreflightAllowOriginMismatch,
        /// <summary>
        /// PreflightInvalidAllowCredentials
        /// </summary>
        [JsonPropertyName("PreflightInvalidAllowCredentials")]
        PreflightInvalidAllowCredentials,
        /// <summary>
        /// PreflightMissingAllowExternal
        /// </summary>
        [JsonPropertyName("PreflightMissingAllowExternal")]
        PreflightMissingAllowExternal,
        /// <summary>
        /// PreflightInvalidAllowExternal
        /// </summary>
        [JsonPropertyName("PreflightInvalidAllowExternal")]
        PreflightInvalidAllowExternal,
        /// <summary>
        /// PreflightMissingAllowPrivateNetwork
        /// </summary>
        [JsonPropertyName("PreflightMissingAllowPrivateNetwork")]
        PreflightMissingAllowPrivateNetwork,
        /// <summary>
        /// PreflightInvalidAllowPrivateNetwork
        /// </summary>
        [JsonPropertyName("PreflightInvalidAllowPrivateNetwork")]
        PreflightInvalidAllowPrivateNetwork,
        /// <summary>
        /// InvalidAllowMethodsPreflightResponse
        /// </summary>
        [JsonPropertyName("InvalidAllowMethodsPreflightResponse")]
        InvalidAllowMethodsPreflightResponse,
        /// <summary>
        /// InvalidAllowHeadersPreflightResponse
        /// </summary>
        [JsonPropertyName("InvalidAllowHeadersPreflightResponse")]
        InvalidAllowHeadersPreflightResponse,
        /// <summary>
        /// MethodDisallowedByPreflightResponse
        /// </summary>
        [JsonPropertyName("MethodDisallowedByPreflightResponse")]
        MethodDisallowedByPreflightResponse,
        /// <summary>
        /// HeaderDisallowedByPreflightResponse
        /// </summary>
        [JsonPropertyName("HeaderDisallowedByPreflightResponse")]
        HeaderDisallowedByPreflightResponse,
        /// <summary>
        /// RedirectContainsCredentials
        /// </summary>
        [JsonPropertyName("RedirectContainsCredentials")]
        RedirectContainsCredentials,
        /// <summary>
        /// InsecurePrivateNetwork
        /// </summary>
        [JsonPropertyName("InsecurePrivateNetwork")]
        InsecurePrivateNetwork,
        /// <summary>
        /// InvalidPrivateNetworkAccess
        /// </summary>
        [JsonPropertyName("InvalidPrivateNetworkAccess")]
        InvalidPrivateNetworkAccess,
        /// <summary>
        /// UnexpectedPrivateNetworkAccess
        /// </summary>
        [JsonPropertyName("UnexpectedPrivateNetworkAccess")]
        UnexpectedPrivateNetworkAccess,
        /// <summary>
        /// NoCorsRedirectModeNotFollow
        /// </summary>
        [JsonPropertyName("NoCorsRedirectModeNotFollow")]
        NoCorsRedirectModeNotFollow,
        /// <summary>
        /// PreflightMissingPrivateNetworkAccessId
        /// </summary>
        [JsonPropertyName("PreflightMissingPrivateNetworkAccessId")]
        PreflightMissingPrivateNetworkAccessId,
        /// <summary>
        /// PreflightMissingPrivateNetworkAccessName
        /// </summary>
        [JsonPropertyName("PreflightMissingPrivateNetworkAccessName")]
        PreflightMissingPrivateNetworkAccessName,
        /// <summary>
        /// PrivateNetworkAccessPermissionUnavailable
        /// </summary>
        [JsonPropertyName("PrivateNetworkAccessPermissionUnavailable")]
        PrivateNetworkAccessPermissionUnavailable,
        /// <summary>
        /// PrivateNetworkAccessPermissionDenied
        /// </summary>
        [JsonPropertyName("PrivateNetworkAccessPermissionDenied")]
        PrivateNetworkAccessPermissionDenied
    }

    /// <summary>
    /// CorsErrorStatus
    /// </summary>
    public partial class CorsErrorStatus : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// CorsError
        /// </summary>
        [JsonPropertyName("corsError")]
        public CefSharp.DevTools.Network.CorsError CorsError
        {
            get;
            set;
        }

        /// <summary>
        /// FailedParameter
        /// </summary>
        [JsonPropertyName("failedParameter")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string FailedParameter
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Source of serviceworker response.
    /// </summary>
    public enum ServiceWorkerResponseSource
    {
        /// <summary>
        /// cache-storage
        /// </summary>
        [JsonPropertyName("cache-storage")]
        CacheStorage,
        /// <summary>
        /// http-cache
        /// </summary>
        [JsonPropertyName("http-cache")]
        HttpCache,
        /// <summary>
        /// fallback-code
        /// </summary>
        [JsonPropertyName("fallback-code")]
        FallbackCode,
        /// <summary>
        /// network
        /// </summary>
        [JsonPropertyName("network")]
        Network
    }

    /// <summary>
    /// Only set for &quot;token-redemption&quot; operation and determine whether
    /// to request a fresh SRR or use a still valid cached SRR.
    /// </summary>
    public enum TrustTokenParamsRefreshPolicy
    {
        /// <summary>
        /// UseCached
        /// </summary>
        [JsonPropertyName("UseCached")]
        UseCached,
        /// <summary>
        /// Refresh
        /// </summary>
        [JsonPropertyName("Refresh")]
        Refresh
    }

    /// <summary>
    /// Determines what type of Trust Token operation is executed and
    /// depending on the type, some additional parameters. The values
    /// are specified in third_party/blink/renderer/core/fetch/trust_token.idl.
    /// </summary>
    public partial class TrustTokenParams : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Operation
        /// </summary>
        [JsonPropertyName("operation")]
        public CefSharp.DevTools.Network.TrustTokenOperationType Operation
        {
            get;
            set;
        }

        /// <summary>
        /// Only set for &quot;token-redemption&quot; operation and determine whether
        /// to request a fresh SRR or use a still valid cached SRR.
        /// </summary>
        [JsonPropertyName("refreshPolicy")]
        public CefSharp.DevTools.Network.TrustTokenParamsRefreshPolicy RefreshPolicy
        {
            get;
            set;
        }

        /// <summary>
        /// Origins of issuers from whom to request tokens or redemption
        /// records.
        /// </summary>
        [JsonPropertyName("issuers")]
        public string[] Issuers
        {
            get;
            set;
        }
    }

    /// <summary>
    /// TrustTokenOperationType
    /// </summary>
    public enum TrustTokenOperationType
    {
        /// <summary>
        /// Issuance
        /// </summary>
        [JsonPropertyName("Issuance")]
        Issuance,
        /// <summary>
        /// Redemption
        /// </summary>
        [JsonPropertyName("Redemption")]
        Redemption,
        /// <summary>
        /// Signing
        /// </summary>
        [JsonPropertyName("Signing")]
        Signing
    }

    /// <summary>
    /// The reason why Chrome uses a specific transport protocol for HTTP semantics.
    /// </summary>
    public enum AlternateProtocolUsage
    {
        /// <summary>
        /// alternativeJobWonWithoutRace
        /// </summary>
        [JsonPropertyName("alternativeJobWonWithoutRace")]
        AlternativeJobWonWithoutRace,
        /// <summary>
        /// alternativeJobWonRace
        /// </summary>
        [JsonPropertyName("alternativeJobWonRace")]
        AlternativeJobWonRace,
        /// <summary>
        /// mainJobWonRace
        /// </summary>
        [JsonPropertyName("mainJobWonRace")]
        MainJobWonRace,
        /// <summary>
        /// mappingMissing
        /// </summary>
        [JsonPropertyName("mappingMissing")]
        MappingMissing,
        /// <summary>
        /// broken
        /// </summary>
        [JsonPropertyName("broken")]
        Broken,
        /// <summary>
        /// dnsAlpnH3JobWonWithoutRace
        /// </summary>
        [JsonPropertyName("dnsAlpnH3JobWonWithoutRace")]
        DnsAlpnH3JobWonWithoutRace,
        /// <summary>
        /// dnsAlpnH3JobWonRace
        /// </summary>
        [JsonPropertyName("dnsAlpnH3JobWonRace")]
        DnsAlpnH3JobWonRace,
        /// <summary>
        /// unspecifiedReason
        /// </summary>
        [JsonPropertyName("unspecifiedReason")]
        UnspecifiedReason
    }

    /// <summary>
    /// Source of service worker router.
    /// </summary>
    public enum ServiceWorkerRouterSource
    {
        /// <summary>
        /// network
        /// </summary>
        [JsonPropertyName("network")]
        Network,
        /// <summary>
        /// cache
        /// </summary>
        [JsonPropertyName("cache")]
        Cache,
        /// <summary>
        /// fetch-event
        /// </summary>
        [JsonPropertyName("fetch-event")]
        FetchEvent,
        /// <summary>
        /// race-network-and-fetch-handler
        /// </summary>
        [JsonPropertyName("race-network-and-fetch-handler")]
        RaceNetworkAndFetchHandler
    }

    /// <summary>
    /// ServiceWorkerRouterInfo
    /// </summary>
    public partial class ServiceWorkerRouterInfo : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// ID of the rule matched. If there is a matched rule, this field will
        /// be set, otherwiser no value will be set.
        /// </summary>
        [JsonPropertyName("ruleIdMatched")]
        public int? RuleIdMatched
        {
            get;
            set;
        }

        /// <summary>
        /// The router source of the matched rule. If there is a matched rule, this
        /// field will be set, otherwise no value will be set.
        /// </summary>
        [JsonPropertyName("matchedSourceType")]
        public CefSharp.DevTools.Network.ServiceWorkerRouterSource? MatchedSourceType
        {
            get;
            set;
        }

        /// <summary>
        /// The actual router source used.
        /// </summary>
        [JsonPropertyName("actualSourceType")]
        public CefSharp.DevTools.Network.ServiceWorkerRouterSource? ActualSourceType
        {
            get;
            set;
        }
    }

    /// <summary>
    /// HTTP response data.
    /// </summary>
    public partial class Response : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Response URL. This URL can be different from CachedResource.url in case of redirect.
        /// </summary>
        [JsonPropertyName("url")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Url
        {
            get;
            set;
        }

        /// <summary>
        /// HTTP response status code.
        /// </summary>
        [JsonPropertyName("status")]
        public int Status
        {
            get;
            set;
        }

        /// <summary>
        /// HTTP response status text.
        /// </summary>
        [JsonPropertyName("statusText")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string StatusText
        {
            get;
            set;
        }

        /// <summary>
        /// HTTP response headers.
        /// </summary>
        [JsonPropertyName("headers")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.Network.Headers Headers
        {
            get;
            set;
        }

        /// <summary>
        /// HTTP response headers text. This has been replaced by the headers in Network.responseReceivedExtraInfo.
        /// </summary>
        [JsonPropertyName("headersText")]
        public string HeadersText
        {
            get;
            set;
        }

        /// <summary>
        /// Resource mimeType as determined by the browser.
        /// </summary>
        [JsonPropertyName("mimeType")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string MimeType
        {
            get;
            set;
        }

        /// <summary>
        /// Resource charset as determined by the browser (if applicable).
        /// </summary>
        [JsonPropertyName("charset")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Charset
        {
            get;
            set;
        }

        /// <summary>
        /// Refined HTTP request headers that were actually transmitted over the network.
        /// </summary>
        [JsonPropertyName("requestHeaders")]
        public CefSharp.DevTools.Network.Headers RequestHeaders
        {
            get;
            set;
        }

        /// <summary>
        /// HTTP request headers text. This has been replaced by the headers in Network.requestWillBeSentExtraInfo.
        /// </summary>
        [JsonPropertyName("requestHeadersText")]
        public string RequestHeadersText
        {
            get;
            set;
        }

        /// <summary>
        /// Specifies whether physical connection was actually reused for this request.
        /// </summary>
        [JsonPropertyName("connectionReused")]
        public bool ConnectionReused
        {
            get;
            set;
        }

        /// <summary>
        /// Physical connection id that was actually used for this request.
        /// </summary>
        [JsonPropertyName("connectionId")]
        public double ConnectionId
        {
            get;
            set;
        }

        /// <summary>
        /// Remote IP address.
        /// </summary>
        [JsonPropertyName("remoteIPAddress")]
        public string RemoteIPAddress
        {
            get;
            set;
        }

        /// <summary>
        /// Remote port.
        /// </summary>
        [JsonPropertyName("remotePort")]
        public int? RemotePort
        {
            get;
            set;
        }

        /// <summary>
        /// Specifies that the request was served from the disk cache.
        /// </summary>
        [JsonPropertyName("fromDiskCache")]
        public bool? FromDiskCache
        {
            get;
            set;
        }

        /// <summary>
        /// Specifies that the request was served from the ServiceWorker.
        /// </summary>
        [JsonPropertyName("fromServiceWorker")]
        public bool? FromServiceWorker
        {
            get;
            set;
        }

        /// <summary>
        /// Specifies that the request was served from the prefetch cache.
        /// </summary>
        [JsonPropertyName("fromPrefetchCache")]
        public bool? FromPrefetchCache
        {
            get;
            set;
        }

        /// <summary>
        /// Specifies that the request was served from the prefetch cache.
        /// </summary>
        [JsonPropertyName("fromEarlyHints")]
        public bool? FromEarlyHints
        {
            get;
            set;
        }

        /// <summary>
        /// Information about how ServiceWorker Static Router API was used. If this
        /// field is set with `matchedSourceType` field, a matching rule is found.
        /// If this field is set without `matchedSource`, no matching rule is found.
        /// Otherwise, the API is not used.
        /// </summary>
        [JsonPropertyName("serviceWorkerRouterInfo")]
        public CefSharp.DevTools.Network.ServiceWorkerRouterInfo ServiceWorkerRouterInfo
        {
            get;
            set;
        }

        /// <summary>
        /// Total number of bytes received for this request so far.
        /// </summary>
        [JsonPropertyName("encodedDataLength")]
        public double EncodedDataLength
        {
            get;
            set;
        }

        /// <summary>
        /// Timing information for the given request.
        /// </summary>
        [JsonPropertyName("timing")]
        public CefSharp.DevTools.Network.ResourceTiming Timing
        {
            get;
            set;
        }

        /// <summary>
        /// Response source of response from ServiceWorker.
        /// </summary>
        [JsonPropertyName("serviceWorkerResponseSource")]
        public CefSharp.DevTools.Network.ServiceWorkerResponseSource? ServiceWorkerResponseSource
        {
            get;
            set;
        }

        /// <summary>
        /// The time at which the returned response was generated.
        /// </summary>
        [JsonPropertyName("responseTime")]
        public double? ResponseTime
        {
            get;
            set;
        }

        /// <summary>
        /// Cache Storage Cache Name.
        /// </summary>
        [JsonPropertyName("cacheStorageCacheName")]
        public string CacheStorageCacheName
        {
            get;
            set;
        }

        /// <summary>
        /// Protocol used to fetch this request.
        /// </summary>
        [JsonPropertyName("protocol")]
        public string Protocol
        {
            get;
            set;
        }

        /// <summary>
        /// The reason why Chrome uses a specific transport protocol for HTTP semantics.
        /// </summary>
        [JsonPropertyName("alternateProtocolUsage")]
        public CefSharp.DevTools.Network.AlternateProtocolUsage? AlternateProtocolUsage
        {
            get;
            set;
        }

        /// <summary>
        /// Security state of the request resource.
        /// </summary>
        [JsonPropertyName("securityState")]
        public CefSharp.DevTools.Security.SecurityState SecurityState
        {
            get;
            set;
        }

        /// <summary>
        /// Security details for the request.
        /// </summary>
        [JsonPropertyName("securityDetails")]
        public CefSharp.DevTools.Network.SecurityDetails SecurityDetails
        {
            get;
            set;
        }
    }

    /// <summary>
    /// WebSocket request data.
    /// </summary>
    public partial class WebSocketRequest : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// HTTP request headers.
        /// </summary>
        [JsonPropertyName("headers")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.Network.Headers Headers
        {
            get;
            set;
        }
    }

    /// <summary>
    /// WebSocket response data.
    /// </summary>
    public partial class WebSocketResponse : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// HTTP response status code.
        /// </summary>
        [JsonPropertyName("status")]
        public int Status
        {
            get;
            set;
        }

        /// <summary>
        /// HTTP response status text.
        /// </summary>
        [JsonPropertyName("statusText")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string StatusText
        {
            get;
            set;
        }

        /// <summary>
        /// HTTP response headers.
        /// </summary>
        [JsonPropertyName("headers")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.Network.Headers Headers
        {
            get;
            set;
        }

        /// <summary>
        /// HTTP response headers text.
        /// </summary>
        [JsonPropertyName("headersText")]
        public string HeadersText
        {
            get;
            set;
        }

        /// <summary>
        /// HTTP request headers.
        /// </summary>
        [JsonPropertyName("requestHeaders")]
        public CefSharp.DevTools.Network.Headers RequestHeaders
        {
            get;
            set;
        }

        /// <summary>
        /// HTTP request headers text.
        /// </summary>
        [JsonPropertyName("requestHeadersText")]
        public string RequestHeadersText
        {
            get;
            set;
        }
    }

    /// <summary>
    /// WebSocket message data. This represents an entire WebSocket message, not just a fragmented frame as the name suggests.
    /// </summary>
    public partial class WebSocketFrame : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// WebSocket message opcode.
        /// </summary>
        [JsonPropertyName("opcode")]
        public double Opcode
        {
            get;
            set;
        }

        /// <summary>
        /// WebSocket message mask.
        /// </summary>
        [JsonPropertyName("mask")]
        public bool Mask
        {
            get;
            set;
        }

        /// <summary>
        /// WebSocket message payload data.
        /// If the opcode is 1, this is a text message and payloadData is a UTF-8 string.
        /// If the opcode isn&apos;t 1, then payloadData is a base64 encoded string representing binary data.
        /// </summary>
        [JsonPropertyName("payloadData")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string PayloadData
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Information about the cached resource.
    /// </summary>
    public partial class CachedResource : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Resource URL. This is the url of the original network request.
        /// </summary>
        [JsonPropertyName("url")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Url
        {
            get;
            set;
        }

        /// <summary>
        /// Type of this resource.
        /// </summary>
        [JsonPropertyName("type")]
        public CefSharp.DevTools.Network.ResourceType Type
        {
            get;
            set;
        }

        /// <summary>
        /// Cached response data.
        /// </summary>
        [JsonPropertyName("response")]
        public CefSharp.DevTools.Network.Response Response
        {
            get;
            set;
        }

        /// <summary>
        /// Cached response body size.
        /// </summary>
        [JsonPropertyName("bodySize")]
        public double BodySize
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Type of this initiator.
    /// </summary>
    public enum InitiatorType
    {
        /// <summary>
        /// parser
        /// </summary>
        [JsonPropertyName("parser")]
        Parser,
        /// <summary>
        /// script
        /// </summary>
        [JsonPropertyName("script")]
        Script,
        /// <summary>
        /// preload
        /// </summary>
        [JsonPropertyName("preload")]
        Preload,
        /// <summary>
        /// SignedExchange
        /// </summary>
        [JsonPropertyName("SignedExchange")]
        SignedExchange,
        /// <summary>
        /// preflight
        /// </summary>
        [JsonPropertyName("preflight")]
        Preflight,
        /// <summary>
        /// other
        /// </summary>
        [JsonPropertyName("other")]
        Other
    }

    /// <summary>
    /// Information about the request initiator.
    /// </summary>
    public partial class Initiator : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Type of this initiator.
        /// </summary>
        [JsonPropertyName("type")]
        public CefSharp.DevTools.Network.InitiatorType Type
        {
            get;
            set;
        }

        /// <summary>
        /// Initiator JavaScript stack trace, set for Script only.
        /// </summary>
        [JsonPropertyName("stack")]
        public CefSharp.DevTools.Runtime.StackTrace Stack
        {
            get;
            set;
        }

        /// <summary>
        /// Initiator URL, set for Parser type or for Script type (when script is importing module) or for SignedExchange type.
        /// </summary>
        [JsonPropertyName("url")]
        public string Url
        {
            get;
            set;
        }

        /// <summary>
        /// Initiator line number, set for Parser type or for Script type (when script is importing
        /// module) (0-based).
        /// </summary>
        [JsonPropertyName("lineNumber")]
        public double? LineNumber
        {
            get;
            set;
        }

        /// <summary>
        /// Initiator column number, set for Parser type or for Script type (when script is importing
        /// module) (0-based).
        /// </summary>
        [JsonPropertyName("columnNumber")]
        public double? ColumnNumber
        {
            get;
            set;
        }

        /// <summary>
        /// Set if another request triggered this request (e.g. preflight).
        /// </summary>
        [JsonPropertyName("requestId")]
        public string RequestId
        {
            get;
            set;
        }
    }

    /// <summary>
    /// cookiePartitionKey object
    /// The representation of the components of the key that are created by the cookiePartitionKey class contained in net/cookies/cookie_partition_key.h.
    /// </summary>
    public partial class CookiePartitionKey : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The site of the top-level URL the browser was visiting at the start
        /// of the request to the endpoint that set the cookie.
        /// </summary>
        [JsonPropertyName("topLevelSite")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string TopLevelSite
        {
            get;
            set;
        }

        /// <summary>
        /// Indicates if the cookie has any ancestors that are cross-site to the topLevelSite.
        /// </summary>
        [JsonPropertyName("hasCrossSiteAncestor")]
        public bool HasCrossSiteAncestor
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Cookie object
    /// </summary>
    public partial class Cookie : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Cookie name.
        /// </summary>
        [JsonPropertyName("name")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Name
        {
            get;
            set;
        }

        /// <summary>
        /// Cookie value.
        /// </summary>
        [JsonPropertyName("value")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Value
        {
            get;
            set;
        }

        /// <summary>
        /// Cookie domain.
        /// </summary>
        [JsonPropertyName("domain")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Domain
        {
            get;
            set;
        }

        /// <summary>
        /// Cookie path.
        /// </summary>
        [JsonPropertyName("path")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Path
        {
            get;
            set;
        }

        /// <summary>
        /// Cookie expiration date as the number of seconds since the UNIX epoch.
        /// </summary>
        [JsonPropertyName("expires")]
        public double Expires
        {
            get;
            set;
        }

        /// <summary>
        /// Cookie size.
        /// </summary>
        [JsonPropertyName("size")]
        public int Size
        {
            get;
            set;
        }

        /// <summary>
        /// True if cookie is http-only.
        /// </summary>
        [JsonPropertyName("httpOnly")]
        public bool HttpOnly
        {
            get;
            set;
        }

        /// <summary>
        /// True if cookie is secure.
        /// </summary>
        [JsonPropertyName("secure")]
        public bool Secure
        {
            get;
            set;
        }

        /// <summary>
        /// True in case of session cookie.
        /// </summary>
        [JsonPropertyName("session")]
        public bool Session
        {
            get;
            set;
        }

        /// <summary>
        /// Cookie SameSite type.
        /// </summary>
        [JsonPropertyName("sameSite")]
        public CefSharp.DevTools.Network.CookieSameSite? SameSite
        {
            get;
            set;
        }

        /// <summary>
        /// Cookie Priority
        /// </summary>
        [JsonPropertyName("priority")]
        public CefSharp.DevTools.Network.CookiePriority Priority
        {
            get;
            set;
        }

        /// <summary>
        /// True if cookie is SameParty.
        /// </summary>
        [JsonPropertyName("sameParty")]
        public bool SameParty
        {
            get;
            set;
        }

        /// <summary>
        /// Cookie source scheme type.
        /// </summary>
        [JsonPropertyName("sourceScheme")]
        public CefSharp.DevTools.Network.CookieSourceScheme SourceScheme
        {
            get;
            set;
        }

        /// <summary>
        /// Cookie source port. Valid values are {-1, [1, 65535]}, -1 indicates an unspecified port.
        /// An unspecified port value allows protocol clients to emulate legacy cookie scope for the port.
        /// This is a temporary ability and it will be removed in the future.
        /// </summary>
        [JsonPropertyName("sourcePort")]
        public int SourcePort
        {
            get;
            set;
        }

        /// <summary>
        /// Cookie partition key.
        /// </summary>
        [JsonPropertyName("partitionKey")]
        public CefSharp.DevTools.Network.CookiePartitionKey PartitionKey
        {
            get;
            set;
        }

        /// <summary>
        /// True if cookie partition key is opaque.
        /// </summary>
        [JsonPropertyName("partitionKeyOpaque")]
        public bool? PartitionKeyOpaque
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Types of reasons why a cookie may not be stored from a response.
    /// </summary>
    public enum SetCookieBlockedReason
    {
        /// <summary>
        /// SecureOnly
        /// </summary>
        [JsonPropertyName("SecureOnly")]
        SecureOnly,
        /// <summary>
        /// SameSiteStrict
        /// </summary>
        [JsonPropertyName("SameSiteStrict")]
        SameSiteStrict,
        /// <summary>
        /// SameSiteLax
        /// </summary>
        [JsonPropertyName("SameSiteLax")]
        SameSiteLax,
        /// <summary>
        /// SameSiteUnspecifiedTreatedAsLax
        /// </summary>
        [JsonPropertyName("SameSiteUnspecifiedTreatedAsLax")]
        SameSiteUnspecifiedTreatedAsLax,
        /// <summary>
        /// SameSiteNoneInsecure
        /// </summary>
        [JsonPropertyName("SameSiteNoneInsecure")]
        SameSiteNoneInsecure,
        /// <summary>
        /// UserPreferences
        /// </summary>
        [JsonPropertyName("UserPreferences")]
        UserPreferences,
        /// <summary>
        /// ThirdPartyPhaseout
        /// </summary>
        [JsonPropertyName("ThirdPartyPhaseout")]
        ThirdPartyPhaseout,
        /// <summary>
        /// ThirdPartyBlockedInFirstPartySet
        /// </summary>
        [JsonPropertyName("ThirdPartyBlockedInFirstPartySet")]
        ThirdPartyBlockedInFirstPartySet,
        /// <summary>
        /// SyntaxError
        /// </summary>
        [JsonPropertyName("SyntaxError")]
        SyntaxError,
        /// <summary>
        /// SchemeNotSupported
        /// </summary>
        [JsonPropertyName("SchemeNotSupported")]
        SchemeNotSupported,
        /// <summary>
        /// OverwriteSecure
        /// </summary>
        [JsonPropertyName("OverwriteSecure")]
        OverwriteSecure,
        /// <summary>
        /// InvalidDomain
        /// </summary>
        [JsonPropertyName("InvalidDomain")]
        InvalidDomain,
        /// <summary>
        /// InvalidPrefix
        /// </summary>
        [JsonPropertyName("InvalidPrefix")]
        InvalidPrefix,
        /// <summary>
        /// UnknownError
        /// </summary>
        [JsonPropertyName("UnknownError")]
        UnknownError,
        /// <summary>
        /// SchemefulSameSiteStrict
        /// </summary>
        [JsonPropertyName("SchemefulSameSiteStrict")]
        SchemefulSameSiteStrict,
        /// <summary>
        /// SchemefulSameSiteLax
        /// </summary>
        [JsonPropertyName("SchemefulSameSiteLax")]
        SchemefulSameSiteLax,
        /// <summary>
        /// SchemefulSameSiteUnspecifiedTreatedAsLax
        /// </summary>
        [JsonPropertyName("SchemefulSameSiteUnspecifiedTreatedAsLax")]
        SchemefulSameSiteUnspecifiedTreatedAsLax,
        /// <summary>
        /// SamePartyFromCrossPartyContext
        /// </summary>
        [JsonPropertyName("SamePartyFromCrossPartyContext")]
        SamePartyFromCrossPartyContext,
        /// <summary>
        /// SamePartyConflictsWithOtherAttributes
        /// </summary>
        [JsonPropertyName("SamePartyConflictsWithOtherAttributes")]
        SamePartyConflictsWithOtherAttributes,
        /// <summary>
        /// NameValuePairExceedsMaxSize
        /// </summary>
        [JsonPropertyName("NameValuePairExceedsMaxSize")]
        NameValuePairExceedsMaxSize,
        /// <summary>
        /// DisallowedCharacter
        /// </summary>
        [JsonPropertyName("DisallowedCharacter")]
        DisallowedCharacter,
        /// <summary>
        /// NoCookieContent
        /// </summary>
        [JsonPropertyName("NoCookieContent")]
        NoCookieContent
    }

    /// <summary>
    /// Types of reasons why a cookie may not be sent with a request.
    /// </summary>
    public enum CookieBlockedReason
    {
        /// <summary>
        /// SecureOnly
        /// </summary>
        [JsonPropertyName("SecureOnly")]
        SecureOnly,
        /// <summary>
        /// NotOnPath
        /// </summary>
        [JsonPropertyName("NotOnPath")]
        NotOnPath,
        /// <summary>
        /// DomainMismatch
        /// </summary>
        [JsonPropertyName("DomainMismatch")]
        DomainMismatch,
        /// <summary>
        /// SameSiteStrict
        /// </summary>
        [JsonPropertyName("SameSiteStrict")]
        SameSiteStrict,
        /// <summary>
        /// SameSiteLax
        /// </summary>
        [JsonPropertyName("SameSiteLax")]
        SameSiteLax,
        /// <summary>
        /// SameSiteUnspecifiedTreatedAsLax
        /// </summary>
        [JsonPropertyName("SameSiteUnspecifiedTreatedAsLax")]
        SameSiteUnspecifiedTreatedAsLax,
        /// <summary>
        /// SameSiteNoneInsecure
        /// </summary>
        [JsonPropertyName("SameSiteNoneInsecure")]
        SameSiteNoneInsecure,
        /// <summary>
        /// UserPreferences
        /// </summary>
        [JsonPropertyName("UserPreferences")]
        UserPreferences,
        /// <summary>
        /// ThirdPartyPhaseout
        /// </summary>
        [JsonPropertyName("ThirdPartyPhaseout")]
        ThirdPartyPhaseout,
        /// <summary>
        /// ThirdPartyBlockedInFirstPartySet
        /// </summary>
        [JsonPropertyName("ThirdPartyBlockedInFirstPartySet")]
        ThirdPartyBlockedInFirstPartySet,
        /// <summary>
        /// UnknownError
        /// </summary>
        [JsonPropertyName("UnknownError")]
        UnknownError,
        /// <summary>
        /// SchemefulSameSiteStrict
        /// </summary>
        [JsonPropertyName("SchemefulSameSiteStrict")]
        SchemefulSameSiteStrict,
        /// <summary>
        /// SchemefulSameSiteLax
        /// </summary>
        [JsonPropertyName("SchemefulSameSiteLax")]
        SchemefulSameSiteLax,
        /// <summary>
        /// SchemefulSameSiteUnspecifiedTreatedAsLax
        /// </summary>
        [JsonPropertyName("SchemefulSameSiteUnspecifiedTreatedAsLax")]
        SchemefulSameSiteUnspecifiedTreatedAsLax,
        /// <summary>
        /// SamePartyFromCrossPartyContext
        /// </summary>
        [JsonPropertyName("SamePartyFromCrossPartyContext")]
        SamePartyFromCrossPartyContext,
        /// <summary>
        /// NameValuePairExceedsMaxSize
        /// </summary>
        [JsonPropertyName("NameValuePairExceedsMaxSize")]
        NameValuePairExceedsMaxSize
    }

    /// <summary>
    /// Types of reasons why a cookie should have been blocked by 3PCD but is exempted for the request.
    /// </summary>
    public enum CookieExemptionReason
    {
        /// <summary>
        /// None
        /// </summary>
        [JsonPropertyName("None")]
        None,
        /// <summary>
        /// UserSetting
        /// </summary>
        [JsonPropertyName("UserSetting")]
        UserSetting,
        /// <summary>
        /// TPCDMetadata
        /// </summary>
        [JsonPropertyName("TPCDMetadata")]
        TPCDMetadata,
        /// <summary>
        /// TPCDDeprecationTrial
        /// </summary>
        [JsonPropertyName("TPCDDeprecationTrial")]
        TPCDDeprecationTrial,
        /// <summary>
        /// TPCDHeuristics
        /// </summary>
        [JsonPropertyName("TPCDHeuristics")]
        TPCDHeuristics,
        /// <summary>
        /// EnterprisePolicy
        /// </summary>
        [JsonPropertyName("EnterprisePolicy")]
        EnterprisePolicy,
        /// <summary>
        /// StorageAccess
        /// </summary>
        [JsonPropertyName("StorageAccess")]
        StorageAccess,
        /// <summary>
        /// TopLevelStorageAccess
        /// </summary>
        [JsonPropertyName("TopLevelStorageAccess")]
        TopLevelStorageAccess,
        /// <summary>
        /// CorsOptIn
        /// </summary>
        [JsonPropertyName("CorsOptIn")]
        CorsOptIn,
        /// <summary>
        /// Scheme
        /// </summary>
        [JsonPropertyName("Scheme")]
        Scheme
    }

    /// <summary>
    /// A cookie which was not stored from a response with the corresponding reason.
    /// </summary>
    public partial class BlockedSetCookieWithReason : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The reason(s) this cookie was blocked.
        /// </summary>
        [JsonPropertyName("blockedReasons")]
        public CefSharp.DevTools.Network.SetCookieBlockedReason[] BlockedReasons
        {
            get;
            set;
        }

        /// <summary>
        /// The string representing this individual cookie as it would appear in the header.
        /// This is not the entire &quot;cookie&quot; or &quot;set-cookie&quot; header which could have multiple cookies.
        /// </summary>
        [JsonPropertyName("cookieLine")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string CookieLine
        {
            get;
            set;
        }

        /// <summary>
        /// The cookie object which represents the cookie which was not stored. It is optional because
        /// sometimes complete cookie information is not available, such as in the case of parsing
        /// errors.
        /// </summary>
        [JsonPropertyName("cookie")]
        public CefSharp.DevTools.Network.Cookie Cookie
        {
            get;
            set;
        }
    }

    /// <summary>
    /// A cookie should have been blocked by 3PCD but is exempted and stored from a response with the
    /// corresponding reason. A cookie could only have at most one exemption reason.
    /// </summary>
    public partial class ExemptedSetCookieWithReason : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The reason the cookie was exempted.
        /// </summary>
        [JsonPropertyName("exemptionReason")]
        public CefSharp.DevTools.Network.CookieExemptionReason ExemptionReason
        {
            get;
            set;
        }

        /// <summary>
        /// The string representing this individual cookie as it would appear in the header.
        /// </summary>
        [JsonPropertyName("cookieLine")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string CookieLine
        {
            get;
            set;
        }

        /// <summary>
        /// The cookie object representing the cookie.
        /// </summary>
        [JsonPropertyName("cookie")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.Network.Cookie Cookie
        {
            get;
            set;
        }
    }

    /// <summary>
    /// A cookie associated with the request which may or may not be sent with it.
    /// Includes the cookies itself and reasons for blocking or exemption.
    /// </summary>
    public partial class AssociatedCookie : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The cookie object representing the cookie which was not sent.
        /// </summary>
        [JsonPropertyName("cookie")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.Network.Cookie Cookie
        {
            get;
            set;
        }

        /// <summary>
        /// The reason(s) the cookie was blocked. If empty means the cookie is included.
        /// </summary>
        [JsonPropertyName("blockedReasons")]
        public CefSharp.DevTools.Network.CookieBlockedReason[] BlockedReasons
        {
            get;
            set;
        }

        /// <summary>
        /// The reason the cookie should have been blocked by 3PCD but is exempted. A cookie could
        /// only have at most one exemption reason.
        /// </summary>
        [JsonPropertyName("exemptionReason")]
        public CefSharp.DevTools.Network.CookieExemptionReason? ExemptionReason
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Cookie parameter object
    /// </summary>
    public partial class CookieParam : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Cookie name.
        /// </summary>
        [JsonPropertyName("name")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Name
        {
            get;
            set;
        }

        /// <summary>
        /// Cookie value.
        /// </summary>
        [JsonPropertyName("value")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Value
        {
            get;
            set;
        }

        /// <summary>
        /// The request-URI to associate with the setting of the cookie. This value can affect the
        /// default domain, path, source port, and source scheme values of the created cookie.
        /// </summary>
        [JsonPropertyName("url")]
        public string Url
        {
            get;
            set;
        }

        /// <summary>
        /// Cookie domain.
        /// </summary>
        [JsonPropertyName("domain")]
        public string Domain
        {
            get;
            set;
        }

        /// <summary>
        /// Cookie path.
        /// </summary>
        [JsonPropertyName("path")]
        public string Path
        {
            get;
            set;
        }

        /// <summary>
        /// True if cookie is secure.
        /// </summary>
        [JsonPropertyName("secure")]
        public bool? Secure
        {
            get;
            set;
        }

        /// <summary>
        /// True if cookie is http-only.
        /// </summary>
        [JsonPropertyName("httpOnly")]
        public bool? HttpOnly
        {
            get;
            set;
        }

        /// <summary>
        /// Cookie SameSite type.
        /// </summary>
        [JsonPropertyName("sameSite")]
        public CefSharp.DevTools.Network.CookieSameSite? SameSite
        {
            get;
            set;
        }

        /// <summary>
        /// Cookie expiration date, session cookie if not set
        /// </summary>
        [JsonPropertyName("expires")]
        public double? Expires
        {
            get;
            set;
        }

        /// <summary>
        /// Cookie Priority.
        /// </summary>
        [JsonPropertyName("priority")]
        public CefSharp.DevTools.Network.CookiePriority? Priority
        {
            get;
            set;
        }

        /// <summary>
        /// True if cookie is SameParty.
        /// </summary>
        [JsonPropertyName("sameParty")]
        public bool? SameParty
        {
            get;
            set;
        }

        /// <summary>
        /// Cookie source scheme type.
        /// </summary>
        [JsonPropertyName("sourceScheme")]
        public CefSharp.DevTools.Network.CookieSourceScheme? SourceScheme
        {
            get;
            set;
        }

        /// <summary>
        /// Cookie source port. Valid values are {-1, [1, 65535]}, -1 indicates an unspecified port.
        /// An unspecified port value allows protocol clients to emulate legacy cookie scope for the port.
        /// This is a temporary ability and it will be removed in the future.
        /// </summary>
        [JsonPropertyName("sourcePort")]
        public int? SourcePort
        {
            get;
            set;
        }

        /// <summary>
        /// Cookie partition key. If not set, the cookie will be set as not partitioned.
        /// </summary>
        [JsonPropertyName("partitionKey")]
        public CefSharp.DevTools.Network.CookiePartitionKey PartitionKey
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Source of the authentication challenge.
    /// </summary>
    public enum AuthChallengeSource
    {
        /// <summary>
        /// Server
        /// </summary>
        [JsonPropertyName("Server")]
        Server,
        /// <summary>
        /// Proxy
        /// </summary>
        [JsonPropertyName("Proxy")]
        Proxy
    }

    /// <summary>
    /// Authorization challenge for HTTP status code 401 or 407.
    /// </summary>
    public partial class AuthChallenge : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Source of the authentication challenge.
        /// </summary>
        [JsonPropertyName("source")]
        public CefSharp.DevTools.Network.AuthChallengeSource? Source
        {
            get;
            set;
        }

        /// <summary>
        /// Origin of the challenger.
        /// </summary>
        [JsonPropertyName("origin")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Origin
        {
            get;
            set;
        }

        /// <summary>
        /// The authentication scheme used, such as basic or digest
        /// </summary>
        [JsonPropertyName("scheme")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Scheme
        {
            get;
            set;
        }

        /// <summary>
        /// The realm of the challenge. May be empty.
        /// </summary>
        [JsonPropertyName("realm")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Realm
        {
            get;
            set;
        }
    }

    /// <summary>
    /// The decision on what to do in response to the authorization challenge.  Default means
    /// deferring to the default behavior of the net stack, which will likely either the Cancel
    /// authentication or display a popup dialog box.
    /// </summary>
    public enum AuthChallengeResponseResponse
    {
        /// <summary>
        /// Default
        /// </summary>
        [JsonPropertyName("Default")]
        Default,
        /// <summary>
        /// CancelAuth
        /// </summary>
        [JsonPropertyName("CancelAuth")]
        CancelAuth,
        /// <summary>
        /// ProvideCredentials
        /// </summary>
        [JsonPropertyName("ProvideCredentials")]
        ProvideCredentials
    }

    /// <summary>
    /// Response to an AuthChallenge.
    /// </summary>
    public partial class AuthChallengeResponse : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The decision on what to do in response to the authorization challenge.  Default means
        /// deferring to the default behavior of the net stack, which will likely either the Cancel
        /// authentication or display a popup dialog box.
        /// </summary>
        [JsonPropertyName("response")]
        public CefSharp.DevTools.Network.AuthChallengeResponseResponse Response
        {
            get;
            set;
        }

        /// <summary>
        /// The username to provide, possibly empty. Should only be set if response is
        /// ProvideCredentials.
        /// </summary>
        [JsonPropertyName("username")]
        public string Username
        {
            get;
            set;
        }

        /// <summary>
        /// The password to provide, possibly empty. Should only be set if response is
        /// ProvideCredentials.
        /// </summary>
        [JsonPropertyName("password")]
        public string Password
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Stages of the interception to begin intercepting. Request will intercept before the request is
    /// sent. Response will intercept after the response is received.
    /// </summary>
    public enum InterceptionStage
    {
        /// <summary>
        /// Request
        /// </summary>
        [JsonPropertyName("Request")]
        Request,
        /// <summary>
        /// HeadersReceived
        /// </summary>
        [JsonPropertyName("HeadersReceived")]
        HeadersReceived
    }

    /// <summary>
    /// Request pattern for interception.
    /// </summary>
    public partial class RequestPattern : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Wildcards (`&apos;*&apos;` -&gt; zero or more, `&apos;?&apos;` -&gt; exactly one) are allowed. Escape character is
        /// backslash. Omitting is equivalent to `&quot;*&quot;`.
        /// </summary>
        [JsonPropertyName("urlPattern")]
        public string UrlPattern
        {
            get;
            set;
        }

        /// <summary>
        /// If set, only requests for matching resource types will be intercepted.
        /// </summary>
        [JsonPropertyName("resourceType")]
        public CefSharp.DevTools.Network.ResourceType? ResourceType
        {
            get;
            set;
        }

        /// <summary>
        /// Stage at which to begin intercepting requests. Default is Request.
        /// </summary>
        [JsonPropertyName("interceptionStage")]
        public CefSharp.DevTools.Network.InterceptionStage? InterceptionStage
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Information about a signed exchange signature.
    /// https://wicg.github.io/webpackage/draft-yasskin-httpbis-origin-signed-exchanges-impl.html#rfc.section.3.1
    /// </summary>
    public partial class SignedExchangeSignature : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Signed exchange signature label.
        /// </summary>
        [JsonPropertyName("label")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Label
        {
            get;
            set;
        }

        /// <summary>
        /// The hex string of signed exchange signature.
        /// </summary>
        [JsonPropertyName("signature")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Signature
        {
            get;
            set;
        }

        /// <summary>
        /// Signed exchange signature integrity.
        /// </summary>
        [JsonPropertyName("integrity")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Integrity
        {
            get;
            set;
        }

        /// <summary>
        /// Signed exchange signature cert Url.
        /// </summary>
        [JsonPropertyName("certUrl")]
        public string CertUrl
        {
            get;
            set;
        }

        /// <summary>
        /// The hex string of signed exchange signature cert sha256.
        /// </summary>
        [JsonPropertyName("certSha256")]
        public string CertSha256
        {
            get;
            set;
        }

        /// <summary>
        /// Signed exchange signature validity Url.
        /// </summary>
        [JsonPropertyName("validityUrl")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string ValidityUrl
        {
            get;
            set;
        }

        /// <summary>
        /// Signed exchange signature date.
        /// </summary>
        [JsonPropertyName("date")]
        public int Date
        {
            get;
            set;
        }

        /// <summary>
        /// Signed exchange signature expires.
        /// </summary>
        [JsonPropertyName("expires")]
        public int Expires
        {
            get;
            set;
        }

        /// <summary>
        /// The encoded certificates.
        /// </summary>
        [JsonPropertyName("certificates")]
        public string[] Certificates
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Information about a signed exchange header.
    /// https://wicg.github.io/webpackage/draft-yasskin-httpbis-origin-signed-exchanges-impl.html#cbor-representation
    /// </summary>
    public partial class SignedExchangeHeader : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Signed exchange request URL.
        /// </summary>
        [JsonPropertyName("requestUrl")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string RequestUrl
        {
            get;
            set;
        }

        /// <summary>
        /// Signed exchange response code.
        /// </summary>
        [JsonPropertyName("responseCode")]
        public int ResponseCode
        {
            get;
            set;
        }

        /// <summary>
        /// Signed exchange response headers.
        /// </summary>
        [JsonPropertyName("responseHeaders")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.Network.Headers ResponseHeaders
        {
            get;
            set;
        }

        /// <summary>
        /// Signed exchange response signature.
        /// </summary>
        [JsonPropertyName("signatures")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public System.Collections.Generic.IList<CefSharp.DevTools.Network.SignedExchangeSignature> Signatures
        {
            get;
            set;
        }

        /// <summary>
        /// Signed exchange header integrity hash in the form of `sha256-&lt;base64-hash-value&gt;`.
        /// </summary>
        [JsonPropertyName("headerIntegrity")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string HeaderIntegrity
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Field type for a signed exchange related error.
    /// </summary>
    public enum SignedExchangeErrorField
    {
        /// <summary>
        /// signatureSig
        /// </summary>
        [JsonPropertyName("signatureSig")]
        SignatureSig,
        /// <summary>
        /// signatureIntegrity
        /// </summary>
        [JsonPropertyName("signatureIntegrity")]
        SignatureIntegrity,
        /// <summary>
        /// signatureCertUrl
        /// </summary>
        [JsonPropertyName("signatureCertUrl")]
        SignatureCertUrl,
        /// <summary>
        /// signatureCertSha256
        /// </summary>
        [JsonPropertyName("signatureCertSha256")]
        SignatureCertSha256,
        /// <summary>
        /// signatureValidityUrl
        /// </summary>
        [JsonPropertyName("signatureValidityUrl")]
        SignatureValidityUrl,
        /// <summary>
        /// signatureTimestamps
        /// </summary>
        [JsonPropertyName("signatureTimestamps")]
        SignatureTimestamps
    }

    /// <summary>
    /// Information about a signed exchange response.
    /// </summary>
    public partial class SignedExchangeError : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Error message.
        /// </summary>
        [JsonPropertyName("message")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Message
        {
            get;
            set;
        }

        /// <summary>
        /// The index of the signature which caused the error.
        /// </summary>
        [JsonPropertyName("signatureIndex")]
        public int? SignatureIndex
        {
            get;
            set;
        }

        /// <summary>
        /// The field which caused the error.
        /// </summary>
        [JsonPropertyName("errorField")]
        public CefSharp.DevTools.Network.SignedExchangeErrorField? ErrorField
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Information about a signed exchange response.
    /// </summary>
    public partial class SignedExchangeInfo : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The outer response of signed HTTP exchange which was received from network.
        /// </summary>
        [JsonPropertyName("outerResponse")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.Network.Response OuterResponse
        {
            get;
            set;
        }

        /// <summary>
        /// Information about the signed exchange header.
        /// </summary>
        [JsonPropertyName("header")]
        public CefSharp.DevTools.Network.SignedExchangeHeader Header
        {
            get;
            set;
        }

        /// <summary>
        /// Security details for the signed exchange header.
        /// </summary>
        [JsonPropertyName("securityDetails")]
        public CefSharp.DevTools.Network.SecurityDetails SecurityDetails
        {
            get;
            set;
        }

        /// <summary>
        /// Errors occurred while handling the signed exchange.
        /// </summary>
        [JsonPropertyName("errors")]
        public System.Collections.Generic.IList<CefSharp.DevTools.Network.SignedExchangeError> Errors
        {
            get;
            set;
        }
    }

    /// <summary>
    /// List of content encodings supported by the backend.
    /// </summary>
    public enum ContentEncoding
    {
        /// <summary>
        /// deflate
        /// </summary>
        [JsonPropertyName("deflate")]
        Deflate,
        /// <summary>
        /// gzip
        /// </summary>
        [JsonPropertyName("gzip")]
        Gzip,
        /// <summary>
        /// br
        /// </summary>
        [JsonPropertyName("br")]
        Br,
        /// <summary>
        /// zstd
        /// </summary>
        [JsonPropertyName("zstd")]
        Zstd
    }

    /// <summary>
    /// PrivateNetworkRequestPolicy
    /// </summary>
    public enum PrivateNetworkRequestPolicy
    {
        /// <summary>
        /// Allow
        /// </summary>
        [JsonPropertyName("Allow")]
        Allow,
        /// <summary>
        /// BlockFromInsecureToMorePrivate
        /// </summary>
        [JsonPropertyName("BlockFromInsecureToMorePrivate")]
        BlockFromInsecureToMorePrivate,
        /// <summary>
        /// WarnFromInsecureToMorePrivate
        /// </summary>
        [JsonPropertyName("WarnFromInsecureToMorePrivate")]
        WarnFromInsecureToMorePrivate,
        /// <summary>
        /// PreflightBlock
        /// </summary>
        [JsonPropertyName("PreflightBlock")]
        PreflightBlock,
        /// <summary>
        /// PreflightWarn
        /// </summary>
        [JsonPropertyName("PreflightWarn")]
        PreflightWarn
    }

    /// <summary>
    /// IPAddressSpace
    /// </summary>
    public enum IPAddressSpace
    {
        /// <summary>
        /// Local
        /// </summary>
        [JsonPropertyName("Local")]
        Local,
        /// <summary>
        /// Private
        /// </summary>
        [JsonPropertyName("Private")]
        Private,
        /// <summary>
        /// Public
        /// </summary>
        [JsonPropertyName("Public")]
        Public,
        /// <summary>
        /// Unknown
        /// </summary>
        [JsonPropertyName("Unknown")]
        Unknown
    }

    /// <summary>
    /// ConnectTiming
    /// </summary>
    public partial class ConnectTiming : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Timing&apos;s requestTime is a baseline in seconds, while the other numbers are ticks in
        /// milliseconds relatively to this requestTime. Matches ResourceTiming&apos;s requestTime for
        /// the same request (but not for redirected requests).
        /// </summary>
        [JsonPropertyName("requestTime")]
        public double RequestTime
        {
            get;
            set;
        }
    }

    /// <summary>
    /// ClientSecurityState
    /// </summary>
    public partial class ClientSecurityState : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// InitiatorIsSecureContext
        /// </summary>
        [JsonPropertyName("initiatorIsSecureContext")]
        public bool InitiatorIsSecureContext
        {
            get;
            set;
        }

        /// <summary>
        /// InitiatorIPAddressSpace
        /// </summary>
        [JsonPropertyName("initiatorIPAddressSpace")]
        public CefSharp.DevTools.Network.IPAddressSpace InitiatorIPAddressSpace
        {
            get;
            set;
        }

        /// <summary>
        /// PrivateNetworkRequestPolicy
        /// </summary>
        [JsonPropertyName("privateNetworkRequestPolicy")]
        public CefSharp.DevTools.Network.PrivateNetworkRequestPolicy PrivateNetworkRequestPolicy
        {
            get;
            set;
        }
    }

    /// <summary>
    /// CrossOriginOpenerPolicyValue
    /// </summary>
    public enum CrossOriginOpenerPolicyValue
    {
        /// <summary>
        /// SameOrigin
        /// </summary>
        [JsonPropertyName("SameOrigin")]
        SameOrigin,
        /// <summary>
        /// SameOriginAllowPopups
        /// </summary>
        [JsonPropertyName("SameOriginAllowPopups")]
        SameOriginAllowPopups,
        /// <summary>
        /// RestrictProperties
        /// </summary>
        [JsonPropertyName("RestrictProperties")]
        RestrictProperties,
        /// <summary>
        /// UnsafeNone
        /// </summary>
        [JsonPropertyName("UnsafeNone")]
        UnsafeNone,
        /// <summary>
        /// SameOriginPlusCoep
        /// </summary>
        [JsonPropertyName("SameOriginPlusCoep")]
        SameOriginPlusCoep,
        /// <summary>
        /// RestrictPropertiesPlusCoep
        /// </summary>
        [JsonPropertyName("RestrictPropertiesPlusCoep")]
        RestrictPropertiesPlusCoep,
        /// <summary>
        /// NoopenerAllowPopups
        /// </summary>
        [JsonPropertyName("NoopenerAllowPopups")]
        NoopenerAllowPopups
    }

    /// <summary>
    /// CrossOriginOpenerPolicyStatus
    /// </summary>
    public partial class CrossOriginOpenerPolicyStatus : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Value
        /// </summary>
        [JsonPropertyName("value")]
        public CefSharp.DevTools.Network.CrossOriginOpenerPolicyValue Value
        {
            get;
            set;
        }

        /// <summary>
        /// ReportOnlyValue
        /// </summary>
        [JsonPropertyName("reportOnlyValue")]
        public CefSharp.DevTools.Network.CrossOriginOpenerPolicyValue ReportOnlyValue
        {
            get;
            set;
        }

        /// <summary>
        /// ReportingEndpoint
        /// </summary>
        [JsonPropertyName("reportingEndpoint")]
        public string ReportingEndpoint
        {
            get;
            set;
        }

        /// <summary>
        /// ReportOnlyReportingEndpoint
        /// </summary>
        [JsonPropertyName("reportOnlyReportingEndpoint")]
        public string ReportOnlyReportingEndpoint
        {
            get;
            set;
        }
    }

    /// <summary>
    /// CrossOriginEmbedderPolicyValue
    /// </summary>
    public enum CrossOriginEmbedderPolicyValue
    {
        /// <summary>
        /// None
        /// </summary>
        [JsonPropertyName("None")]
        None,
        /// <summary>
        /// Credentialless
        /// </summary>
        [JsonPropertyName("Credentialless")]
        Credentialless,
        /// <summary>
        /// RequireCorp
        /// </summary>
        [JsonPropertyName("RequireCorp")]
        RequireCorp
    }

    /// <summary>
    /// CrossOriginEmbedderPolicyStatus
    /// </summary>
    public partial class CrossOriginEmbedderPolicyStatus : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Value
        /// </summary>
        [JsonPropertyName("value")]
        public CefSharp.DevTools.Network.CrossOriginEmbedderPolicyValue Value
        {
            get;
            set;
        }

        /// <summary>
        /// ReportOnlyValue
        /// </summary>
        [JsonPropertyName("reportOnlyValue")]
        public CefSharp.DevTools.Network.CrossOriginEmbedderPolicyValue ReportOnlyValue
        {
            get;
            set;
        }

        /// <summary>
        /// ReportingEndpoint
        /// </summary>
        [JsonPropertyName("reportingEndpoint")]
        public string ReportingEndpoint
        {
            get;
            set;
        }

        /// <summary>
        /// ReportOnlyReportingEndpoint
        /// </summary>
        [JsonPropertyName("reportOnlyReportingEndpoint")]
        public string ReportOnlyReportingEndpoint
        {
            get;
            set;
        }
    }

    /// <summary>
    /// ContentSecurityPolicySource
    /// </summary>
    public enum ContentSecurityPolicySource
    {
        /// <summary>
        /// HTTP
        /// </summary>
        [JsonPropertyName("HTTP")]
        HTTP,
        /// <summary>
        /// Meta
        /// </summary>
        [JsonPropertyName("Meta")]
        Meta
    }

    /// <summary>
    /// ContentSecurityPolicyStatus
    /// </summary>
    public partial class ContentSecurityPolicyStatus : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// EffectiveDirectives
        /// </summary>
        [JsonPropertyName("effectiveDirectives")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string EffectiveDirectives
        {
            get;
            set;
        }

        /// <summary>
        /// IsEnforced
        /// </summary>
        [JsonPropertyName("isEnforced")]
        public bool IsEnforced
        {
            get;
            set;
        }

        /// <summary>
        /// Source
        /// </summary>
        [JsonPropertyName("source")]
        public CefSharp.DevTools.Network.ContentSecurityPolicySource Source
        {
            get;
            set;
        }
    }

    /// <summary>
    /// SecurityIsolationStatus
    /// </summary>
    public partial class SecurityIsolationStatus : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Coop
        /// </summary>
        [JsonPropertyName("coop")]
        public CefSharp.DevTools.Network.CrossOriginOpenerPolicyStatus Coop
        {
            get;
            set;
        }

        /// <summary>
        /// Coep
        /// </summary>
        [JsonPropertyName("coep")]
        public CefSharp.DevTools.Network.CrossOriginEmbedderPolicyStatus Coep
        {
            get;
            set;
        }

        /// <summary>
        /// Csp
        /// </summary>
        [JsonPropertyName("csp")]
        public System.Collections.Generic.IList<CefSharp.DevTools.Network.ContentSecurityPolicyStatus> Csp
        {
            get;
            set;
        }
    }

    /// <summary>
    /// The status of a Reporting API report.
    /// </summary>
    public enum ReportStatus
    {
        /// <summary>
        /// Queued
        /// </summary>
        [JsonPropertyName("Queued")]
        Queued,
        /// <summary>
        /// Pending
        /// </summary>
        [JsonPropertyName("Pending")]
        Pending,
        /// <summary>
        /// MarkedForRemoval
        /// </summary>
        [JsonPropertyName("MarkedForRemoval")]
        MarkedForRemoval,
        /// <summary>
        /// Success
        /// </summary>
        [JsonPropertyName("Success")]
        Success
    }

    /// <summary>
    /// An object representing a report generated by the Reporting API.
    /// </summary>
    public partial class ReportingApiReport : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Id
        /// </summary>
        [JsonPropertyName("id")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Id
        {
            get;
            set;
        }

        /// <summary>
        /// The URL of the document that triggered the report.
        /// </summary>
        [JsonPropertyName("initiatorUrl")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string InitiatorUrl
        {
            get;
            set;
        }

        /// <summary>
        /// The name of the endpoint group that should be used to deliver the report.
        /// </summary>
        [JsonPropertyName("destination")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Destination
        {
            get;
            set;
        }

        /// <summary>
        /// The type of the report (specifies the set of data that is contained in the report body).
        /// </summary>
        [JsonPropertyName("type")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Type
        {
            get;
            set;
        }

        /// <summary>
        /// When the report was generated.
        /// </summary>
        [JsonPropertyName("timestamp")]
        public double Timestamp
        {
            get;
            set;
        }

        /// <summary>
        /// How many uploads deep the related request was.
        /// </summary>
        [JsonPropertyName("depth")]
        public int Depth
        {
            get;
            set;
        }

        /// <summary>
        /// The number of delivery attempts made so far, not including an active attempt.
        /// </summary>
        [JsonPropertyName("completedAttempts")]
        public int CompletedAttempts
        {
            get;
            set;
        }

        /// <summary>
        /// Body
        /// </summary>
        [JsonPropertyName("body")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public object Body
        {
            get;
            set;
        }

        /// <summary>
        /// Status
        /// </summary>
        [JsonPropertyName("status")]
        public CefSharp.DevTools.Network.ReportStatus Status
        {
            get;
            set;
        }
    }

    /// <summary>
    /// ReportingApiEndpoint
    /// </summary>
    public partial class ReportingApiEndpoint : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The URL of the endpoint to which reports may be delivered.
        /// </summary>
        [JsonPropertyName("url")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Url
        {
            get;
            set;
        }

        /// <summary>
        /// Name of the endpoint group.
        /// </summary>
        [JsonPropertyName("groupName")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string GroupName
        {
            get;
            set;
        }
    }

    /// <summary>
    /// An object providing the result of a network resource load.
    /// </summary>
    public partial class LoadNetworkResourcePageResult : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Success
        /// </summary>
        [JsonPropertyName("success")]
        public bool Success
        {
            get;
            set;
        }

        /// <summary>
        /// Optional values used for error reporting.
        /// </summary>
        [JsonPropertyName("netError")]
        public double? NetError
        {
            get;
            set;
        }

        /// <summary>
        /// NetErrorName
        /// </summary>
        [JsonPropertyName("netErrorName")]
        public string NetErrorName
        {
            get;
            set;
        }

        /// <summary>
        /// HttpStatusCode
        /// </summary>
        [JsonPropertyName("httpStatusCode")]
        public double? HttpStatusCode
        {
            get;
            set;
        }

        /// <summary>
        /// If successful, one of the following two fields holds the result.
        /// </summary>
        [JsonPropertyName("stream")]
        public string Stream
        {
            get;
            set;
        }

        /// <summary>
        /// Response headers.
        /// </summary>
        [JsonPropertyName("headers")]
        public CefSharp.DevTools.Network.Headers Headers
        {
            get;
            set;
        }
    }

    /// <summary>
    /// An options object that may be extended later to better support CORS,
    /// CORB and streaming.
    /// </summary>
    public partial class LoadNetworkResourceOptions : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// DisableCache
        /// </summary>
        [JsonPropertyName("disableCache")]
        public bool DisableCache
        {
            get;
            set;
        }

        /// <summary>
        /// IncludeCredentials
        /// </summary>
        [JsonPropertyName("includeCredentials")]
        public bool IncludeCredentials
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Fired when data chunk was received over the network.
    /// </summary>
    public class DataReceivedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Request identifier.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("requestId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string RequestId
        {
            get;
            private set;
        }

        /// <summary>
        /// Timestamp.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("timestamp")]
        public double Timestamp
        {
            get;
            private set;
        }

        /// <summary>
        /// Data chunk length.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("dataLength")]
        public int DataLength
        {
            get;
            private set;
        }

        /// <summary>
        /// Actual bytes received (might be less than dataLength for compressed encodings).
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("encodedDataLength")]
        public int EncodedDataLength
        {
            get;
            private set;
        }

        /// <summary>
        /// Data that was received.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("data")]
        public byte[] Data
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired when EventSource message is received.
    /// </summary>
    public class EventSourceMessageReceivedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Request identifier.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("requestId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string RequestId
        {
            get;
            private set;
        }

        /// <summary>
        /// Timestamp.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("timestamp")]
        public double Timestamp
        {
            get;
            private set;
        }

        /// <summary>
        /// Message type.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("eventName")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string EventName
        {
            get;
            private set;
        }

        /// <summary>
        /// Message identifier.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("eventId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string EventId
        {
            get;
            private set;
        }

        /// <summary>
        /// Message content.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("data")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Data
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired when HTTP request has failed to load.
    /// </summary>
    public class LoadingFailedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Request identifier.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("requestId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string RequestId
        {
            get;
            private set;
        }

        /// <summary>
        /// Timestamp.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("timestamp")]
        public double Timestamp
        {
            get;
            private set;
        }

        /// <summary>
        /// Resource type.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("type")]
        public CefSharp.DevTools.Network.ResourceType Type
        {
            get;
            private set;
        }

        /// <summary>
        /// Error message. List of network errors: https://cs.chromium.org/chromium/src/net/base/net_error_list.h
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("errorText")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string ErrorText
        {
            get;
            private set;
        }

        /// <summary>
        /// True if loading was canceled.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("canceled")]
        public bool? Canceled
        {
            get;
            private set;
        }

        /// <summary>
        /// The reason why loading was blocked, if any.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("blockedReason")]
        public CefSharp.DevTools.Network.BlockedReason? BlockedReason
        {
            get;
            private set;
        }

        /// <summary>
        /// The reason why loading was blocked by CORS, if any.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("corsErrorStatus")]
        public CefSharp.DevTools.Network.CorsErrorStatus CorsErrorStatus
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired when HTTP request has finished loading.
    /// </summary>
    public class LoadingFinishedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Request identifier.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("requestId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string RequestId
        {
            get;
            private set;
        }

        /// <summary>
        /// Timestamp.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("timestamp")]
        public double Timestamp
        {
            get;
            private set;
        }

        /// <summary>
        /// Total number of bytes received for this request.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("encodedDataLength")]
        public double EncodedDataLength
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Details of an intercepted HTTP request, which must be either allowed, blocked, modified or
    /// mocked.
    /// Deprecated, use Fetch.requestPaused instead.
    /// </summary>
    public class RequestInterceptedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Each request the page makes will have a unique id, however if any redirects are encountered
        /// while processing that fetch, they will be reported with the same id as the original fetch.
        /// Likewise if HTTP authentication is needed then the same fetch id will be used.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("interceptionId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string InterceptionId
        {
            get;
            private set;
        }

        /// <summary>
        /// Request
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("request")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.Network.Request Request
        {
            get;
            private set;
        }

        /// <summary>
        /// The id of the frame that initiated the request.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("frameId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string FrameId
        {
            get;
            private set;
        }

        /// <summary>
        /// How the requested resource will be used.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("resourceType")]
        public CefSharp.DevTools.Network.ResourceType ResourceType
        {
            get;
            private set;
        }

        /// <summary>
        /// Whether this is a navigation request, which can abort the navigation completely.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("isNavigationRequest")]
        public bool IsNavigationRequest
        {
            get;
            private set;
        }

        /// <summary>
        /// Set if the request is a navigation that will result in a download.
        /// Only present after response is received from the server (i.e. HeadersReceived stage).
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("isDownload")]
        public bool? IsDownload
        {
            get;
            private set;
        }

        /// <summary>
        /// Redirect location, only sent if a redirect was intercepted.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("redirectUrl")]
        public string RedirectUrl
        {
            get;
            private set;
        }

        /// <summary>
        /// Details of the Authorization Challenge encountered. If this is set then
        /// continueInterceptedRequest must contain an authChallengeResponse.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("authChallenge")]
        public CefSharp.DevTools.Network.AuthChallenge AuthChallenge
        {
            get;
            private set;
        }

        /// <summary>
        /// Response error if intercepted at response stage or if redirect occurred while intercepting
        /// request.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("responseErrorReason")]
        public CefSharp.DevTools.Network.ErrorReason? ResponseErrorReason
        {
            get;
            private set;
        }

        /// <summary>
        /// Response code if intercepted at response stage or if redirect occurred while intercepting
        /// request or auth retry occurred.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("responseStatusCode")]
        public int? ResponseStatusCode
        {
            get;
            private set;
        }

        /// <summary>
        /// Response headers if intercepted at the response stage or if redirect occurred while
        /// intercepting request or auth retry occurred.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("responseHeaders")]
        public CefSharp.DevTools.Network.Headers ResponseHeaders
        {
            get;
            private set;
        }

        /// <summary>
        /// If the intercepted request had a corresponding requestWillBeSent event fired for it, then
        /// this requestId will be the same as the requestId present in the requestWillBeSent event.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("requestId")]
        public string RequestId
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired if request ended up loading from cache.
    /// </summary>
    public class RequestServedFromCacheEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Request identifier.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("requestId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string RequestId
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired when page is about to send HTTP request.
    /// </summary>
    public class RequestWillBeSentEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Request identifier.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("requestId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string RequestId
        {
            get;
            private set;
        }

        /// <summary>
        /// Loader identifier. Empty string if the request is fetched from worker.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("loaderId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string LoaderId
        {
            get;
            private set;
        }

        /// <summary>
        /// URL of the document this request is loaded for.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("documentURL")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string DocumentURL
        {
            get;
            private set;
        }

        /// <summary>
        /// Request data.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("request")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.Network.Request Request
        {
            get;
            private set;
        }

        /// <summary>
        /// Timestamp.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("timestamp")]
        public double Timestamp
        {
            get;
            private set;
        }

        /// <summary>
        /// Timestamp.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("wallTime")]
        public double WallTime
        {
            get;
            private set;
        }

        /// <summary>
        /// Request initiator.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("initiator")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.Network.Initiator Initiator
        {
            get;
            private set;
        }

        /// <summary>
        /// In the case that redirectResponse is populated, this flag indicates whether
        /// requestWillBeSentExtraInfo and responseReceivedExtraInfo events will be or were emitted
        /// for the request which was just redirected.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("redirectHasExtraInfo")]
        public bool RedirectHasExtraInfo
        {
            get;
            private set;
        }

        /// <summary>
        /// Redirect response data.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("redirectResponse")]
        public CefSharp.DevTools.Network.Response RedirectResponse
        {
            get;
            private set;
        }

        /// <summary>
        /// Type of this resource.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("type")]
        public CefSharp.DevTools.Network.ResourceType? Type
        {
            get;
            private set;
        }

        /// <summary>
        /// Frame identifier.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("frameId")]
        public string FrameId
        {
            get;
            private set;
        }

        /// <summary>
        /// Whether the request is initiated by a user gesture. Defaults to false.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("hasUserGesture")]
        public bool? HasUserGesture
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired when resource loading priority is changed
    /// </summary>
    public class ResourceChangedPriorityEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Request identifier.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("requestId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string RequestId
        {
            get;
            private set;
        }

        /// <summary>
        /// New priority
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("newPriority")]
        public CefSharp.DevTools.Network.ResourcePriority NewPriority
        {
            get;
            private set;
        }

        /// <summary>
        /// Timestamp.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("timestamp")]
        public double Timestamp
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired when a signed exchange was received over the network
    /// </summary>
    public class SignedExchangeReceivedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Request identifier.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("requestId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string RequestId
        {
            get;
            private set;
        }

        /// <summary>
        /// Information about the signed exchange response.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("info")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.Network.SignedExchangeInfo Info
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired when HTTP response is available.
    /// </summary>
    public class ResponseReceivedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Request identifier.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("requestId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string RequestId
        {
            get;
            private set;
        }

        /// <summary>
        /// Loader identifier. Empty string if the request is fetched from worker.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("loaderId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string LoaderId
        {
            get;
            private set;
        }

        /// <summary>
        /// Timestamp.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("timestamp")]
        public double Timestamp
        {
            get;
            private set;
        }

        /// <summary>
        /// Resource type.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("type")]
        public CefSharp.DevTools.Network.ResourceType Type
        {
            get;
            private set;
        }

        /// <summary>
        /// Response data.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("response")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.Network.Response Response
        {
            get;
            private set;
        }

        /// <summary>
        /// Indicates whether requestWillBeSentExtraInfo and responseReceivedExtraInfo events will be
        /// or were emitted for this request.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("hasExtraInfo")]
        public bool HasExtraInfo
        {
            get;
            private set;
        }

        /// <summary>
        /// Frame identifier.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("frameId")]
        public string FrameId
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired when WebSocket is closed.
    /// </summary>
    public class WebSocketClosedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Request identifier.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("requestId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string RequestId
        {
            get;
            private set;
        }

        /// <summary>
        /// Timestamp.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("timestamp")]
        public double Timestamp
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired upon WebSocket creation.
    /// </summary>
    public class WebSocketCreatedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Request identifier.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("requestId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string RequestId
        {
            get;
            private set;
        }

        /// <summary>
        /// WebSocket request URL.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("url")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Url
        {
            get;
            private set;
        }

        /// <summary>
        /// Request initiator.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("initiator")]
        public CefSharp.DevTools.Network.Initiator Initiator
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired when WebSocket message error occurs.
    /// </summary>
    public class WebSocketFrameErrorEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Request identifier.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("requestId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string RequestId
        {
            get;
            private set;
        }

        /// <summary>
        /// Timestamp.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("timestamp")]
        public double Timestamp
        {
            get;
            private set;
        }

        /// <summary>
        /// WebSocket error message.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("errorMessage")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string ErrorMessage
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired when WebSocket message is received.
    /// </summary>
    public class WebSocketFrameReceivedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Request identifier.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("requestId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string RequestId
        {
            get;
            private set;
        }

        /// <summary>
        /// Timestamp.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("timestamp")]
        public double Timestamp
        {
            get;
            private set;
        }

        /// <summary>
        /// WebSocket response data.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("response")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.Network.WebSocketFrame Response
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired when WebSocket message is sent.
    /// </summary>
    public class WebSocketFrameSentEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Request identifier.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("requestId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string RequestId
        {
            get;
            private set;
        }

        /// <summary>
        /// Timestamp.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("timestamp")]
        public double Timestamp
        {
            get;
            private set;
        }

        /// <summary>
        /// WebSocket response data.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("response")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.Network.WebSocketFrame Response
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired when WebSocket handshake response becomes available.
    /// </summary>
    public class WebSocketHandshakeResponseReceivedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Request identifier.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("requestId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string RequestId
        {
            get;
            private set;
        }

        /// <summary>
        /// Timestamp.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("timestamp")]
        public double Timestamp
        {
            get;
            private set;
        }

        /// <summary>
        /// WebSocket response data.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("response")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.Network.WebSocketResponse Response
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired when WebSocket is about to initiate handshake.
    /// </summary>
    public class WebSocketWillSendHandshakeRequestEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Request identifier.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("requestId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string RequestId
        {
            get;
            private set;
        }

        /// <summary>
        /// Timestamp.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("timestamp")]
        public double Timestamp
        {
            get;
            private set;
        }

        /// <summary>
        /// UTC Timestamp.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("wallTime")]
        public double WallTime
        {
            get;
            private set;
        }

        /// <summary>
        /// WebSocket request data.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("request")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.Network.WebSocketRequest Request
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired upon WebTransport creation.
    /// </summary>
    public class WebTransportCreatedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// WebTransport identifier.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("transportId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string TransportId
        {
            get;
            private set;
        }

        /// <summary>
        /// WebTransport request URL.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("url")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Url
        {
            get;
            private set;
        }

        /// <summary>
        /// Timestamp.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("timestamp")]
        public double Timestamp
        {
            get;
            private set;
        }

        /// <summary>
        /// Request initiator.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("initiator")]
        public CefSharp.DevTools.Network.Initiator Initiator
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired when WebTransport handshake is finished.
    /// </summary>
    public class WebTransportConnectionEstablishedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// WebTransport identifier.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("transportId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string TransportId
        {
            get;
            private set;
        }

        /// <summary>
        /// Timestamp.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("timestamp")]
        public double Timestamp
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired when WebTransport is disposed.
    /// </summary>
    public class WebTransportClosedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// WebTransport identifier.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("transportId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string TransportId
        {
            get;
            private set;
        }

        /// <summary>
        /// Timestamp.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("timestamp")]
        public double Timestamp
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired when additional information about a requestWillBeSent event is available from the
    /// network stack. Not every requestWillBeSent event will have an additional
    /// requestWillBeSentExtraInfo fired for it, and there is no guarantee whether requestWillBeSent
    /// or requestWillBeSentExtraInfo will be fired first for the same request.
    /// </summary>
    public class RequestWillBeSentExtraInfoEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Request identifier. Used to match this information to an existing requestWillBeSent event.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("requestId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string RequestId
        {
            get;
            private set;
        }

        /// <summary>
        /// A list of cookies potentially associated to the requested URL. This includes both cookies sent with
        /// the request and the ones not sent; the latter are distinguished by having blockedReasons field set.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("associatedCookies")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public System.Collections.Generic.IList<CefSharp.DevTools.Network.AssociatedCookie> AssociatedCookies
        {
            get;
            private set;
        }

        /// <summary>
        /// Raw request headers as they will be sent over the wire.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("headers")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.Network.Headers Headers
        {
            get;
            private set;
        }

        /// <summary>
        /// Connection timing information for the request.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("connectTiming")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.Network.ConnectTiming ConnectTiming
        {
            get;
            private set;
        }

        /// <summary>
        /// The client security state set for the request.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("clientSecurityState")]
        public CefSharp.DevTools.Network.ClientSecurityState ClientSecurityState
        {
            get;
            private set;
        }

        /// <summary>
        /// Whether the site has partitioned cookies stored in a partition different than the current one.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("siteHasCookieInOtherPartition")]
        public bool? SiteHasCookieInOtherPartition
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired when additional information about a responseReceived event is available from the network
    /// stack. Not every responseReceived event will have an additional responseReceivedExtraInfo for
    /// it, and responseReceivedExtraInfo may be fired before or after responseReceived.
    /// </summary>
    public class ResponseReceivedExtraInfoEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Request identifier. Used to match this information to another responseReceived event.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("requestId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string RequestId
        {
            get;
            private set;
        }

        /// <summary>
        /// A list of cookies which were not stored from the response along with the corresponding
        /// reasons for blocking. The cookies here may not be valid due to syntax errors, which
        /// are represented by the invalid cookie line string instead of a proper cookie.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("blockedCookies")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public System.Collections.Generic.IList<CefSharp.DevTools.Network.BlockedSetCookieWithReason> BlockedCookies
        {
            get;
            private set;
        }

        /// <summary>
        /// Raw response headers as they were received over the wire.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("headers")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.Network.Headers Headers
        {
            get;
            private set;
        }

        /// <summary>
        /// The IP address space of the resource. The address space can only be determined once the transport
        /// established the connection, so we can&apos;t send it in `requestWillBeSentExtraInfo`.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("resourceIPAddressSpace")]
        public CefSharp.DevTools.Network.IPAddressSpace ResourceIPAddressSpace
        {
            get;
            private set;
        }

        /// <summary>
        /// The status code of the response. This is useful in cases the request failed and no responseReceived
        /// event is triggered, which is the case for, e.g., CORS errors. This is also the correct status code
        /// for cached requests, where the status in responseReceived is a 200 and this will be 304.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("statusCode")]
        public int StatusCode
        {
            get;
            private set;
        }

        /// <summary>
        /// Raw response header text as it was received over the wire. The raw text may not always be
        /// available, such as in the case of HTTP/2 or QUIC.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("headersText")]
        public string HeadersText
        {
            get;
            private set;
        }

        /// <summary>
        /// The cookie partition key that will be used to store partitioned cookies set in this response.
        /// Only sent when partitioned cookies are enabled.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("cookiePartitionKey")]
        public CefSharp.DevTools.Network.CookiePartitionKey CookiePartitionKey
        {
            get;
            private set;
        }

        /// <summary>
        /// True if partitioned cookies are enabled, but the partition key is not serializable to string.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("cookiePartitionKeyOpaque")]
        public bool? CookiePartitionKeyOpaque
        {
            get;
            private set;
        }

        /// <summary>
        /// A list of cookies which should have been blocked by 3PCD but are exempted and stored from
        /// the response with the corresponding reason.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("exemptedCookies")]
        public System.Collections.Generic.IList<CefSharp.DevTools.Network.ExemptedSetCookieWithReason> ExemptedCookies
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired when 103 Early Hints headers is received in addition to the common response.
    /// Not every responseReceived event will have an responseReceivedEarlyHints fired.
    /// Only one responseReceivedEarlyHints may be fired for eached responseReceived event.
    /// </summary>
    public class ResponseReceivedEarlyHintsEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Request identifier. Used to match this information to another responseReceived event.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("requestId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string RequestId
        {
            get;
            private set;
        }

        /// <summary>
        /// Raw response headers as they were received over the wire.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("headers")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.Network.Headers Headers
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Detailed success or error status of the operation.
    /// &apos;AlreadyExists&apos; also signifies a successful operation, as the result
    /// of the operation already exists und thus, the operation was abort
    /// preemptively (e.g. a cache hit).
    /// </summary>
    public enum TrustTokenOperationDoneStatus
    {
        /// <summary>
        /// Ok
        /// </summary>
        [JsonPropertyName("Ok")]
        Ok,
        /// <summary>
        /// InvalidArgument
        /// </summary>
        [JsonPropertyName("InvalidArgument")]
        InvalidArgument,
        /// <summary>
        /// MissingIssuerKeys
        /// </summary>
        [JsonPropertyName("MissingIssuerKeys")]
        MissingIssuerKeys,
        /// <summary>
        /// FailedPrecondition
        /// </summary>
        [JsonPropertyName("FailedPrecondition")]
        FailedPrecondition,
        /// <summary>
        /// ResourceExhausted
        /// </summary>
        [JsonPropertyName("ResourceExhausted")]
        ResourceExhausted,
        /// <summary>
        /// AlreadyExists
        /// </summary>
        [JsonPropertyName("AlreadyExists")]
        AlreadyExists,
        /// <summary>
        /// ResourceLimited
        /// </summary>
        [JsonPropertyName("ResourceLimited")]
        ResourceLimited,
        /// <summary>
        /// Unauthorized
        /// </summary>
        [JsonPropertyName("Unauthorized")]
        Unauthorized,
        /// <summary>
        /// BadResponse
        /// </summary>
        [JsonPropertyName("BadResponse")]
        BadResponse,
        /// <summary>
        /// InternalError
        /// </summary>
        [JsonPropertyName("InternalError")]
        InternalError,
        /// <summary>
        /// UnknownError
        /// </summary>
        [JsonPropertyName("UnknownError")]
        UnknownError,
        /// <summary>
        /// FulfilledLocally
        /// </summary>
        [JsonPropertyName("FulfilledLocally")]
        FulfilledLocally
    }

    /// <summary>
    /// Fired exactly once for each Trust Token operation. Depending on
    /// the type of the operation and whether the operation succeeded or
    /// failed, the event is fired before the corresponding request was sent
    /// or after the response was received.
    /// </summary>
    public class TrustTokenOperationDoneEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Detailed success or error status of the operation.
        /// &apos;AlreadyExists&apos; also signifies a successful operation, as the result
        /// of the operation already exists und thus, the operation was abort
        /// preemptively (e.g. a cache hit).
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("status")]
        public CefSharp.DevTools.Network.TrustTokenOperationDoneStatus Status
        {
            get;
            private set;
        }

        /// <summary>
        /// Type
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("type")]
        public CefSharp.DevTools.Network.TrustTokenOperationType Type
        {
            get;
            private set;
        }

        /// <summary>
        /// RequestId
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("requestId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string RequestId
        {
            get;
            private set;
        }

        /// <summary>
        /// Top level origin. The context in which the operation was attempted.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("topLevelOrigin")]
        public string TopLevelOrigin
        {
            get;
            private set;
        }

        /// <summary>
        /// Origin of the issuer in case of a &quot;Issuance&quot; or &quot;Redemption&quot; operation.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("issuerOrigin")]
        public string IssuerOrigin
        {
            get;
            private set;
        }

        /// <summary>
        /// The number of obtained Trust Tokens on a successful &quot;Issuance&quot; operation.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("issuedTokenCount")]
        public int? IssuedTokenCount
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired once when parsing the .wbn file has succeeded.
    /// The event contains the information about the web bundle contents.
    /// </summary>
    public class SubresourceWebBundleMetadataReceivedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Request identifier. Used to match this information to another event.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("requestId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string RequestId
        {
            get;
            private set;
        }

        /// <summary>
        /// A list of URLs of resources in the subresource Web Bundle.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("urls")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string[] Urls
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired once when parsing the .wbn file has failed.
    /// </summary>
    public class SubresourceWebBundleMetadataErrorEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Request identifier. Used to match this information to another event.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("requestId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string RequestId
        {
            get;
            private set;
        }

        /// <summary>
        /// Error message
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("errorMessage")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string ErrorMessage
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired when handling requests for resources within a .wbn file.
    /// Note: this will only be fired for resources that are requested by the webpage.
    /// </summary>
    public class SubresourceWebBundleInnerResponseParsedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Request identifier of the subresource request
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("innerRequestId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string InnerRequestId
        {
            get;
            private set;
        }

        /// <summary>
        /// URL of the subresource resource.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("innerRequestURL")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string InnerRequestURL
        {
            get;
            private set;
        }

        /// <summary>
        /// Bundle request identifier. Used to match this information to another event.
        /// This made be absent in case when the instrumentation was enabled only
        /// after webbundle was parsed.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("bundleRequestId")]
        public string BundleRequestId
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired when request for resources within a .wbn file failed.
    /// </summary>
    public class SubresourceWebBundleInnerResponseErrorEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Request identifier of the subresource request
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("innerRequestId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string InnerRequestId
        {
            get;
            private set;
        }

        /// <summary>
        /// URL of the subresource resource.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("innerRequestURL")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string InnerRequestURL
        {
            get;
            private set;
        }

        /// <summary>
        /// Error message
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("errorMessage")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string ErrorMessage
        {
            get;
            private set;
        }

        /// <summary>
        /// Bundle request identifier. Used to match this information to another event.
        /// This made be absent in case when the instrumentation was enabled only
        /// after webbundle was parsed.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("bundleRequestId")]
        public string BundleRequestId
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Is sent whenever a new report is added.
    /// And after &apos;enableReportingApi&apos; for all existing reports.
    /// </summary>
    public class ReportingApiReportAddedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Report
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("report")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.Network.ReportingApiReport Report
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// reportingApiReportUpdated
    /// </summary>
    public class ReportingApiReportUpdatedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Report
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("report")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.Network.ReportingApiReport Report
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// reportingApiEndpointsChangedForOrigin
    /// </summary>
    public class ReportingApiEndpointsChangedForOriginEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Origin of the document(s) which configured the endpoints.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("origin")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Origin
        {
            get;
            private set;
        }

        /// <summary>
        /// Endpoints
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("endpoints")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public System.Collections.Generic.IList<CefSharp.DevTools.Network.ReportingApiEndpoint> Endpoints
        {
            get;
            private set;
        }
    }
}

namespace CefSharp.DevTools.Overlay
{
    /// <summary>
    /// Configuration data for drawing the source order of an elements children.
    /// </summary>
    public partial class SourceOrderConfig : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// the color to outline the given element in.
        /// </summary>
        [JsonPropertyName("parentOutlineColor")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.DOM.RGBA ParentOutlineColor
        {
            get;
            set;
        }

        /// <summary>
        /// the color to outline the child elements in.
        /// </summary>
        [JsonPropertyName("childOutlineColor")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.DOM.RGBA ChildOutlineColor
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Configuration data for the highlighting of Grid elements.
    /// </summary>
    public partial class GridHighlightConfig : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Whether the extension lines from grid cells to the rulers should be shown (default: false).
        /// </summary>
        [JsonPropertyName("showGridExtensionLines")]
        public bool? ShowGridExtensionLines
        {
            get;
            set;
        }

        /// <summary>
        /// Show Positive line number labels (default: false).
        /// </summary>
        [JsonPropertyName("showPositiveLineNumbers")]
        public bool? ShowPositiveLineNumbers
        {
            get;
            set;
        }

        /// <summary>
        /// Show Negative line number labels (default: false).
        /// </summary>
        [JsonPropertyName("showNegativeLineNumbers")]
        public bool? ShowNegativeLineNumbers
        {
            get;
            set;
        }

        /// <summary>
        /// Show area name labels (default: false).
        /// </summary>
        [JsonPropertyName("showAreaNames")]
        public bool? ShowAreaNames
        {
            get;
            set;
        }

        /// <summary>
        /// Show line name labels (default: false).
        /// </summary>
        [JsonPropertyName("showLineNames")]
        public bool? ShowLineNames
        {
            get;
            set;
        }

        /// <summary>
        /// Show track size labels (default: false).
        /// </summary>
        [JsonPropertyName("showTrackSizes")]
        public bool? ShowTrackSizes
        {
            get;
            set;
        }

        /// <summary>
        /// The grid container border highlight color (default: transparent).
        /// </summary>
        [JsonPropertyName("gridBorderColor")]
        public CefSharp.DevTools.DOM.RGBA GridBorderColor
        {
            get;
            set;
        }

        /// <summary>
        /// The cell border color (default: transparent). Deprecated, please use rowLineColor and columnLineColor instead.
        /// </summary>
        [JsonPropertyName("cellBorderColor")]
        public CefSharp.DevTools.DOM.RGBA CellBorderColor
        {
            get;
            set;
        }

        /// <summary>
        /// The row line color (default: transparent).
        /// </summary>
        [JsonPropertyName("rowLineColor")]
        public CefSharp.DevTools.DOM.RGBA RowLineColor
        {
            get;
            set;
        }

        /// <summary>
        /// The column line color (default: transparent).
        /// </summary>
        [JsonPropertyName("columnLineColor")]
        public CefSharp.DevTools.DOM.RGBA ColumnLineColor
        {
            get;
            set;
        }

        /// <summary>
        /// Whether the grid border is dashed (default: false).
        /// </summary>
        [JsonPropertyName("gridBorderDash")]
        public bool? GridBorderDash
        {
            get;
            set;
        }

        /// <summary>
        /// Whether the cell border is dashed (default: false). Deprecated, please us rowLineDash and columnLineDash instead.
        /// </summary>
        [JsonPropertyName("cellBorderDash")]
        public bool? CellBorderDash
        {
            get;
            set;
        }

        /// <summary>
        /// Whether row lines are dashed (default: false).
        /// </summary>
        [JsonPropertyName("rowLineDash")]
        public bool? RowLineDash
        {
            get;
            set;
        }

        /// <summary>
        /// Whether column lines are dashed (default: false).
        /// </summary>
        [JsonPropertyName("columnLineDash")]
        public bool? ColumnLineDash
        {
            get;
            set;
        }

        /// <summary>
        /// The row gap highlight fill color (default: transparent).
        /// </summary>
        [JsonPropertyName("rowGapColor")]
        public CefSharp.DevTools.DOM.RGBA RowGapColor
        {
            get;
            set;
        }

        /// <summary>
        /// The row gap hatching fill color (default: transparent).
        /// </summary>
        [JsonPropertyName("rowHatchColor")]
        public CefSharp.DevTools.DOM.RGBA RowHatchColor
        {
            get;
            set;
        }

        /// <summary>
        /// The column gap highlight fill color (default: transparent).
        /// </summary>
        [JsonPropertyName("columnGapColor")]
        public CefSharp.DevTools.DOM.RGBA ColumnGapColor
        {
            get;
            set;
        }

        /// <summary>
        /// The column gap hatching fill color (default: transparent).
        /// </summary>
        [JsonPropertyName("columnHatchColor")]
        public CefSharp.DevTools.DOM.RGBA ColumnHatchColor
        {
            get;
            set;
        }

        /// <summary>
        /// The named grid areas border color (Default: transparent).
        /// </summary>
        [JsonPropertyName("areaBorderColor")]
        public CefSharp.DevTools.DOM.RGBA AreaBorderColor
        {
            get;
            set;
        }

        /// <summary>
        /// The grid container background color (Default: transparent).
        /// </summary>
        [JsonPropertyName("gridBackgroundColor")]
        public CefSharp.DevTools.DOM.RGBA GridBackgroundColor
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Configuration data for the highlighting of Flex container elements.
    /// </summary>
    public partial class FlexContainerHighlightConfig : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The style of the container border
        /// </summary>
        [JsonPropertyName("containerBorder")]
        public CefSharp.DevTools.Overlay.LineStyle ContainerBorder
        {
            get;
            set;
        }

        /// <summary>
        /// The style of the separator between lines
        /// </summary>
        [JsonPropertyName("lineSeparator")]
        public CefSharp.DevTools.Overlay.LineStyle LineSeparator
        {
            get;
            set;
        }

        /// <summary>
        /// The style of the separator between items
        /// </summary>
        [JsonPropertyName("itemSeparator")]
        public CefSharp.DevTools.Overlay.LineStyle ItemSeparator
        {
            get;
            set;
        }

        /// <summary>
        /// Style of content-distribution space on the main axis (justify-content).
        /// </summary>
        [JsonPropertyName("mainDistributedSpace")]
        public CefSharp.DevTools.Overlay.BoxStyle MainDistributedSpace
        {
            get;
            set;
        }

        /// <summary>
        /// Style of content-distribution space on the cross axis (align-content).
        /// </summary>
        [JsonPropertyName("crossDistributedSpace")]
        public CefSharp.DevTools.Overlay.BoxStyle CrossDistributedSpace
        {
            get;
            set;
        }

        /// <summary>
        /// Style of empty space caused by row gaps (gap/row-gap).
        /// </summary>
        [JsonPropertyName("rowGapSpace")]
        public CefSharp.DevTools.Overlay.BoxStyle RowGapSpace
        {
            get;
            set;
        }

        /// <summary>
        /// Style of empty space caused by columns gaps (gap/column-gap).
        /// </summary>
        [JsonPropertyName("columnGapSpace")]
        public CefSharp.DevTools.Overlay.BoxStyle ColumnGapSpace
        {
            get;
            set;
        }

        /// <summary>
        /// Style of the self-alignment line (align-items).
        /// </summary>
        [JsonPropertyName("crossAlignment")]
        public CefSharp.DevTools.Overlay.LineStyle CrossAlignment
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Configuration data for the highlighting of Flex item elements.
    /// </summary>
    public partial class FlexItemHighlightConfig : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Style of the box representing the item&apos;s base size
        /// </summary>
        [JsonPropertyName("baseSizeBox")]
        public CefSharp.DevTools.Overlay.BoxStyle BaseSizeBox
        {
            get;
            set;
        }

        /// <summary>
        /// Style of the border around the box representing the item&apos;s base size
        /// </summary>
        [JsonPropertyName("baseSizeBorder")]
        public CefSharp.DevTools.Overlay.LineStyle BaseSizeBorder
        {
            get;
            set;
        }

        /// <summary>
        /// Style of the arrow representing if the item grew or shrank
        /// </summary>
        [JsonPropertyName("flexibilityArrow")]
        public CefSharp.DevTools.Overlay.LineStyle FlexibilityArrow
        {
            get;
            set;
        }
    }

    /// <summary>
    /// The line pattern (default: solid)
    /// </summary>
    public enum LineStylePattern
    {
        /// <summary>
        /// dashed
        /// </summary>
        [JsonPropertyName("dashed")]
        Dashed,
        /// <summary>
        /// dotted
        /// </summary>
        [JsonPropertyName("dotted")]
        Dotted
    }

    /// <summary>
    /// Style information for drawing a line.
    /// </summary>
    public partial class LineStyle : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The color of the line (default: transparent)
        /// </summary>
        [JsonPropertyName("color")]
        public CefSharp.DevTools.DOM.RGBA Color
        {
            get;
            set;
        }

        /// <summary>
        /// The line pattern (default: solid)
        /// </summary>
        [JsonPropertyName("pattern")]
        public CefSharp.DevTools.Overlay.LineStylePattern? Pattern
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Style information for drawing a box.
    /// </summary>
    public partial class BoxStyle : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The background color for the box (default: transparent)
        /// </summary>
        [JsonPropertyName("fillColor")]
        public CefSharp.DevTools.DOM.RGBA FillColor
        {
            get;
            set;
        }

        /// <summary>
        /// The hatching color for the box (default: transparent)
        /// </summary>
        [JsonPropertyName("hatchColor")]
        public CefSharp.DevTools.DOM.RGBA HatchColor
        {
            get;
            set;
        }
    }

    /// <summary>
    /// ContrastAlgorithm
    /// </summary>
    public enum ContrastAlgorithm
    {
        /// <summary>
        /// aa
        /// </summary>
        [JsonPropertyName("aa")]
        Aa,
        /// <summary>
        /// aaa
        /// </summary>
        [JsonPropertyName("aaa")]
        Aaa,
        /// <summary>
        /// apca
        /// </summary>
        [JsonPropertyName("apca")]
        Apca
    }

    /// <summary>
    /// Configuration data for the highlighting of page elements.
    /// </summary>
    public partial class HighlightConfig : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Whether the node info tooltip should be shown (default: false).
        /// </summary>
        [JsonPropertyName("showInfo")]
        public bool? ShowInfo
        {
            get;
            set;
        }

        /// <summary>
        /// Whether the node styles in the tooltip (default: false).
        /// </summary>
        [JsonPropertyName("showStyles")]
        public bool? ShowStyles
        {
            get;
            set;
        }

        /// <summary>
        /// Whether the rulers should be shown (default: false).
        /// </summary>
        [JsonPropertyName("showRulers")]
        public bool? ShowRulers
        {
            get;
            set;
        }

        /// <summary>
        /// Whether the a11y info should be shown (default: true).
        /// </summary>
        [JsonPropertyName("showAccessibilityInfo")]
        public bool? ShowAccessibilityInfo
        {
            get;
            set;
        }

        /// <summary>
        /// Whether the extension lines from node to the rulers should be shown (default: false).
        /// </summary>
        [JsonPropertyName("showExtensionLines")]
        public bool? ShowExtensionLines
        {
            get;
            set;
        }

        /// <summary>
        /// The content box highlight fill color (default: transparent).
        /// </summary>
        [JsonPropertyName("contentColor")]
        public CefSharp.DevTools.DOM.RGBA ContentColor
        {
            get;
            set;
        }

        /// <summary>
        /// The padding highlight fill color (default: transparent).
        /// </summary>
        [JsonPropertyName("paddingColor")]
        public CefSharp.DevTools.DOM.RGBA PaddingColor
        {
            get;
            set;
        }

        /// <summary>
        /// The border highlight fill color (default: transparent).
        /// </summary>
        [JsonPropertyName("borderColor")]
        public CefSharp.DevTools.DOM.RGBA BorderColor
        {
            get;
            set;
        }

        /// <summary>
        /// The margin highlight fill color (default: transparent).
        /// </summary>
        [JsonPropertyName("marginColor")]
        public CefSharp.DevTools.DOM.RGBA MarginColor
        {
            get;
            set;
        }

        /// <summary>
        /// The event target element highlight fill color (default: transparent).
        /// </summary>
        [JsonPropertyName("eventTargetColor")]
        public CefSharp.DevTools.DOM.RGBA EventTargetColor
        {
            get;
            set;
        }

        /// <summary>
        /// The shape outside fill color (default: transparent).
        /// </summary>
        [JsonPropertyName("shapeColor")]
        public CefSharp.DevTools.DOM.RGBA ShapeColor
        {
            get;
            set;
        }

        /// <summary>
        /// The shape margin fill color (default: transparent).
        /// </summary>
        [JsonPropertyName("shapeMarginColor")]
        public CefSharp.DevTools.DOM.RGBA ShapeMarginColor
        {
            get;
            set;
        }

        /// <summary>
        /// The grid layout color (default: transparent).
        /// </summary>
        [JsonPropertyName("cssGridColor")]
        public CefSharp.DevTools.DOM.RGBA CssGridColor
        {
            get;
            set;
        }

        /// <summary>
        /// The color format used to format color styles (default: hex).
        /// </summary>
        [JsonPropertyName("colorFormat")]
        public CefSharp.DevTools.Overlay.ColorFormat? ColorFormat
        {
            get;
            set;
        }

        /// <summary>
        /// The grid layout highlight configuration (default: all transparent).
        /// </summary>
        [JsonPropertyName("gridHighlightConfig")]
        public CefSharp.DevTools.Overlay.GridHighlightConfig GridHighlightConfig
        {
            get;
            set;
        }

        /// <summary>
        /// The flex container highlight configuration (default: all transparent).
        /// </summary>
        [JsonPropertyName("flexContainerHighlightConfig")]
        public CefSharp.DevTools.Overlay.FlexContainerHighlightConfig FlexContainerHighlightConfig
        {
            get;
            set;
        }

        /// <summary>
        /// The flex item highlight configuration (default: all transparent).
        /// </summary>
        [JsonPropertyName("flexItemHighlightConfig")]
        public CefSharp.DevTools.Overlay.FlexItemHighlightConfig FlexItemHighlightConfig
        {
            get;
            set;
        }

        /// <summary>
        /// The contrast algorithm to use for the contrast ratio (default: aa).
        /// </summary>
        [JsonPropertyName("contrastAlgorithm")]
        public CefSharp.DevTools.Overlay.ContrastAlgorithm? ContrastAlgorithm
        {
            get;
            set;
        }

        /// <summary>
        /// The container query container highlight configuration (default: all transparent).
        /// </summary>
        [JsonPropertyName("containerQueryContainerHighlightConfig")]
        public CefSharp.DevTools.Overlay.ContainerQueryContainerHighlightConfig ContainerQueryContainerHighlightConfig
        {
            get;
            set;
        }
    }

    /// <summary>
    /// ColorFormat
    /// </summary>
    public enum ColorFormat
    {
        /// <summary>
        /// rgb
        /// </summary>
        [JsonPropertyName("rgb")]
        Rgb,
        /// <summary>
        /// hsl
        /// </summary>
        [JsonPropertyName("hsl")]
        Hsl,
        /// <summary>
        /// hwb
        /// </summary>
        [JsonPropertyName("hwb")]
        Hwb,
        /// <summary>
        /// hex
        /// </summary>
        [JsonPropertyName("hex")]
        Hex
    }

    /// <summary>
    /// Configurations for Persistent Grid Highlight
    /// </summary>
    public partial class GridNodeHighlightConfig : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// A descriptor for the highlight appearance.
        /// </summary>
        [JsonPropertyName("gridHighlightConfig")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.Overlay.GridHighlightConfig GridHighlightConfig
        {
            get;
            set;
        }

        /// <summary>
        /// Identifier of the node to highlight.
        /// </summary>
        [JsonPropertyName("nodeId")]
        public int NodeId
        {
            get;
            set;
        }
    }

    /// <summary>
    /// FlexNodeHighlightConfig
    /// </summary>
    public partial class FlexNodeHighlightConfig : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// A descriptor for the highlight appearance of flex containers.
        /// </summary>
        [JsonPropertyName("flexContainerHighlightConfig")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.Overlay.FlexContainerHighlightConfig FlexContainerHighlightConfig
        {
            get;
            set;
        }

        /// <summary>
        /// Identifier of the node to highlight.
        /// </summary>
        [JsonPropertyName("nodeId")]
        public int NodeId
        {
            get;
            set;
        }
    }

    /// <summary>
    /// ScrollSnapContainerHighlightConfig
    /// </summary>
    public partial class ScrollSnapContainerHighlightConfig : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The style of the snapport border (default: transparent)
        /// </summary>
        [JsonPropertyName("snapportBorder")]
        public CefSharp.DevTools.Overlay.LineStyle SnapportBorder
        {
            get;
            set;
        }

        /// <summary>
        /// The style of the snap area border (default: transparent)
        /// </summary>
        [JsonPropertyName("snapAreaBorder")]
        public CefSharp.DevTools.Overlay.LineStyle SnapAreaBorder
        {
            get;
            set;
        }

        /// <summary>
        /// The margin highlight fill color (default: transparent).
        /// </summary>
        [JsonPropertyName("scrollMarginColor")]
        public CefSharp.DevTools.DOM.RGBA ScrollMarginColor
        {
            get;
            set;
        }

        /// <summary>
        /// The padding highlight fill color (default: transparent).
        /// </summary>
        [JsonPropertyName("scrollPaddingColor")]
        public CefSharp.DevTools.DOM.RGBA ScrollPaddingColor
        {
            get;
            set;
        }
    }

    /// <summary>
    /// ScrollSnapHighlightConfig
    /// </summary>
    public partial class ScrollSnapHighlightConfig : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// A descriptor for the highlight appearance of scroll snap containers.
        /// </summary>
        [JsonPropertyName("scrollSnapContainerHighlightConfig")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.Overlay.ScrollSnapContainerHighlightConfig ScrollSnapContainerHighlightConfig
        {
            get;
            set;
        }

        /// <summary>
        /// Identifier of the node to highlight.
        /// </summary>
        [JsonPropertyName("nodeId")]
        public int NodeId
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Configuration for dual screen hinge
    /// </summary>
    public partial class HingeConfig : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// A rectangle represent hinge
        /// </summary>
        [JsonPropertyName("rect")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.DOM.Rect Rect
        {
            get;
            set;
        }

        /// <summary>
        /// The content box highlight fill color (default: a dark color).
        /// </summary>
        [JsonPropertyName("contentColor")]
        public CefSharp.DevTools.DOM.RGBA ContentColor
        {
            get;
            set;
        }

        /// <summary>
        /// The content box highlight outline color (default: transparent).
        /// </summary>
        [JsonPropertyName("outlineColor")]
        public CefSharp.DevTools.DOM.RGBA OutlineColor
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Configuration for Window Controls Overlay
    /// </summary>
    public partial class WindowControlsOverlayConfig : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Whether the title bar CSS should be shown when emulating the Window Controls Overlay.
        /// </summary>
        [JsonPropertyName("showCSS")]
        public bool ShowCSS
        {
            get;
            set;
        }

        /// <summary>
        /// Selected platforms to show the overlay.
        /// </summary>
        [JsonPropertyName("selectedPlatform")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string SelectedPlatform
        {
            get;
            set;
        }

        /// <summary>
        /// The theme color defined in app manifest.
        /// </summary>
        [JsonPropertyName("themeColor")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string ThemeColor
        {
            get;
            set;
        }
    }

    /// <summary>
    /// ContainerQueryHighlightConfig
    /// </summary>
    public partial class ContainerQueryHighlightConfig : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// A descriptor for the highlight appearance of container query containers.
        /// </summary>
        [JsonPropertyName("containerQueryContainerHighlightConfig")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.Overlay.ContainerQueryContainerHighlightConfig ContainerQueryContainerHighlightConfig
        {
            get;
            set;
        }

        /// <summary>
        /// Identifier of the container node to highlight.
        /// </summary>
        [JsonPropertyName("nodeId")]
        public int NodeId
        {
            get;
            set;
        }
    }

    /// <summary>
    /// ContainerQueryContainerHighlightConfig
    /// </summary>
    public partial class ContainerQueryContainerHighlightConfig : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The style of the container border.
        /// </summary>
        [JsonPropertyName("containerBorder")]
        public CefSharp.DevTools.Overlay.LineStyle ContainerBorder
        {
            get;
            set;
        }

        /// <summary>
        /// The style of the descendants&apos; borders.
        /// </summary>
        [JsonPropertyName("descendantBorder")]
        public CefSharp.DevTools.Overlay.LineStyle DescendantBorder
        {
            get;
            set;
        }
    }

    /// <summary>
    /// IsolatedElementHighlightConfig
    /// </summary>
    public partial class IsolatedElementHighlightConfig : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// A descriptor for the highlight appearance of an element in isolation mode.
        /// </summary>
        [JsonPropertyName("isolationModeHighlightConfig")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.Overlay.IsolationModeHighlightConfig IsolationModeHighlightConfig
        {
            get;
            set;
        }

        /// <summary>
        /// Identifier of the isolated element to highlight.
        /// </summary>
        [JsonPropertyName("nodeId")]
        public int NodeId
        {
            get;
            set;
        }
    }

    /// <summary>
    /// IsolationModeHighlightConfig
    /// </summary>
    public partial class IsolationModeHighlightConfig : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The fill color of the resizers (default: transparent).
        /// </summary>
        [JsonPropertyName("resizerColor")]
        public CefSharp.DevTools.DOM.RGBA ResizerColor
        {
            get;
            set;
        }

        /// <summary>
        /// The fill color for resizer handles (default: transparent).
        /// </summary>
        [JsonPropertyName("resizerHandleColor")]
        public CefSharp.DevTools.DOM.RGBA ResizerHandleColor
        {
            get;
            set;
        }

        /// <summary>
        /// The fill color for the mask covering non-isolated elements (default: transparent).
        /// </summary>
        [JsonPropertyName("maskColor")]
        public CefSharp.DevTools.DOM.RGBA MaskColor
        {
            get;
            set;
        }
    }

    /// <summary>
    /// InspectMode
    /// </summary>
    public enum InspectMode
    {
        /// <summary>
        /// searchForNode
        /// </summary>
        [JsonPropertyName("searchForNode")]
        SearchForNode,
        /// <summary>
        /// searchForUAShadowDOM
        /// </summary>
        [JsonPropertyName("searchForUAShadowDOM")]
        SearchForUAShadowDOM,
        /// <summary>
        /// captureAreaScreenshot
        /// </summary>
        [JsonPropertyName("captureAreaScreenshot")]
        CaptureAreaScreenshot,
        /// <summary>
        /// showDistances
        /// </summary>
        [JsonPropertyName("showDistances")]
        ShowDistances,
        /// <summary>
        /// none
        /// </summary>
        [JsonPropertyName("none")]
        None
    }

    /// <summary>
    /// Fired when the node should be inspected. This happens after call to `setInspectMode` or when
    /// user manually inspects an element.
    /// </summary>
    public class InspectNodeRequestedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Id of the node to inspect.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("backendNodeId")]
        public int BackendNodeId
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired when the node should be highlighted. This happens after call to `setInspectMode`.
    /// </summary>
    public class NodeHighlightRequestedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// NodeId
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("nodeId")]
        public int NodeId
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired when user asks to capture screenshot of some area on the page.
    /// </summary>
    public class ScreenshotRequestedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Viewport to capture, in device independent pixels (dip).
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("viewport")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.Page.Viewport Viewport
        {
            get;
            private set;
        }
    }
}

namespace CefSharp.DevTools.Page
{
    /// <summary>
    /// Indicates whether a frame has been identified as an ad.
    /// </summary>
    public enum AdFrameType
    {
        /// <summary>
        /// none
        /// </summary>
        [JsonPropertyName("none")]
        None,
        /// <summary>
        /// child
        /// </summary>
        [JsonPropertyName("child")]
        Child,
        /// <summary>
        /// root
        /// </summary>
        [JsonPropertyName("root")]
        Root
    }

    /// <summary>
    /// AdFrameExplanation
    /// </summary>
    public enum AdFrameExplanation
    {
        /// <summary>
        /// ParentIsAd
        /// </summary>
        [JsonPropertyName("ParentIsAd")]
        ParentIsAd,
        /// <summary>
        /// CreatedByAdScript
        /// </summary>
        [JsonPropertyName("CreatedByAdScript")]
        CreatedByAdScript,
        /// <summary>
        /// MatchedBlockingRule
        /// </summary>
        [JsonPropertyName("MatchedBlockingRule")]
        MatchedBlockingRule
    }

    /// <summary>
    /// Indicates whether a frame has been identified as an ad and why.
    /// </summary>
    public partial class AdFrameStatus : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// AdFrameType
        /// </summary>
        [JsonPropertyName("adFrameType")]
        public CefSharp.DevTools.Page.AdFrameType AdFrameType
        {
            get;
            set;
        }

        /// <summary>
        /// Explanations
        /// </summary>
        [JsonPropertyName("explanations")]
        public CefSharp.DevTools.Page.AdFrameExplanation[] Explanations
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Identifies the bottom-most script which caused the frame to be labelled
    /// as an ad.
    /// </summary>
    public partial class AdScriptId : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Script Id of the bottom-most script which caused the frame to be labelled
        /// as an ad.
        /// </summary>
        [JsonPropertyName("scriptId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string ScriptId
        {
            get;
            set;
        }

        /// <summary>
        /// Id of adScriptId&apos;s debugger.
        /// </summary>
        [JsonPropertyName("debuggerId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string DebuggerId
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Indicates whether the frame is a secure context and why it is the case.
    /// </summary>
    public enum SecureContextType
    {
        /// <summary>
        /// Secure
        /// </summary>
        [JsonPropertyName("Secure")]
        Secure,
        /// <summary>
        /// SecureLocalhost
        /// </summary>
        [JsonPropertyName("SecureLocalhost")]
        SecureLocalhost,
        /// <summary>
        /// InsecureScheme
        /// </summary>
        [JsonPropertyName("InsecureScheme")]
        InsecureScheme,
        /// <summary>
        /// InsecureAncestor
        /// </summary>
        [JsonPropertyName("InsecureAncestor")]
        InsecureAncestor
    }

    /// <summary>
    /// Indicates whether the frame is cross-origin isolated and why it is the case.
    /// </summary>
    public enum CrossOriginIsolatedContextType
    {
        /// <summary>
        /// Isolated
        /// </summary>
        [JsonPropertyName("Isolated")]
        Isolated,
        /// <summary>
        /// NotIsolated
        /// </summary>
        [JsonPropertyName("NotIsolated")]
        NotIsolated,
        /// <summary>
        /// NotIsolatedFeatureDisabled
        /// </summary>
        [JsonPropertyName("NotIsolatedFeatureDisabled")]
        NotIsolatedFeatureDisabled
    }

    /// <summary>
    /// GatedAPIFeatures
    /// </summary>
    public enum GatedAPIFeatures
    {
        /// <summary>
        /// SharedArrayBuffers
        /// </summary>
        [JsonPropertyName("SharedArrayBuffers")]
        SharedArrayBuffers,
        /// <summary>
        /// SharedArrayBuffersTransferAllowed
        /// </summary>
        [JsonPropertyName("SharedArrayBuffersTransferAllowed")]
        SharedArrayBuffersTransferAllowed,
        /// <summary>
        /// PerformanceMeasureMemory
        /// </summary>
        [JsonPropertyName("PerformanceMeasureMemory")]
        PerformanceMeasureMemory,
        /// <summary>
        /// PerformanceProfile
        /// </summary>
        [JsonPropertyName("PerformanceProfile")]
        PerformanceProfile
    }

    /// <summary>
    /// All Permissions Policy features. This enum should match the one defined
    /// in third_party/blink/renderer/core/permissions_policy/permissions_policy_features.json5.
    /// </summary>
    public enum PermissionsPolicyFeature
    {
        /// <summary>
        /// accelerometer
        /// </summary>
        [JsonPropertyName("accelerometer")]
        Accelerometer,
        /// <summary>
        /// all-screens-capture
        /// </summary>
        [JsonPropertyName("all-screens-capture")]
        AllScreensCapture,
        /// <summary>
        /// ambient-light-sensor
        /// </summary>
        [JsonPropertyName("ambient-light-sensor")]
        AmbientLightSensor,
        /// <summary>
        /// attribution-reporting
        /// </summary>
        [JsonPropertyName("attribution-reporting")]
        AttributionReporting,
        /// <summary>
        /// autoplay
        /// </summary>
        [JsonPropertyName("autoplay")]
        Autoplay,
        /// <summary>
        /// bluetooth
        /// </summary>
        [JsonPropertyName("bluetooth")]
        Bluetooth,
        /// <summary>
        /// browsing-topics
        /// </summary>
        [JsonPropertyName("browsing-topics")]
        BrowsingTopics,
        /// <summary>
        /// camera
        /// </summary>
        [JsonPropertyName("camera")]
        Camera,
        /// <summary>
        /// captured-surface-control
        /// </summary>
        [JsonPropertyName("captured-surface-control")]
        CapturedSurfaceControl,
        /// <summary>
        /// ch-dpr
        /// </summary>
        [JsonPropertyName("ch-dpr")]
        ChDpr,
        /// <summary>
        /// ch-device-memory
        /// </summary>
        [JsonPropertyName("ch-device-memory")]
        ChDeviceMemory,
        /// <summary>
        /// ch-downlink
        /// </summary>
        [JsonPropertyName("ch-downlink")]
        ChDownlink,
        /// <summary>
        /// ch-ect
        /// </summary>
        [JsonPropertyName("ch-ect")]
        ChEct,
        /// <summary>
        /// ch-prefers-color-scheme
        /// </summary>
        [JsonPropertyName("ch-prefers-color-scheme")]
        ChPrefersColorScheme,
        /// <summary>
        /// ch-prefers-reduced-motion
        /// </summary>
        [JsonPropertyName("ch-prefers-reduced-motion")]
        ChPrefersReducedMotion,
        /// <summary>
        /// ch-prefers-reduced-transparency
        /// </summary>
        [JsonPropertyName("ch-prefers-reduced-transparency")]
        ChPrefersReducedTransparency,
        /// <summary>
        /// ch-rtt
        /// </summary>
        [JsonPropertyName("ch-rtt")]
        ChRtt,
        /// <summary>
        /// ch-save-data
        /// </summary>
        [JsonPropertyName("ch-save-data")]
        ChSaveData,
        /// <summary>
        /// ch-ua
        /// </summary>
        [JsonPropertyName("ch-ua")]
        ChUa,
        /// <summary>
        /// ch-ua-arch
        /// </summary>
        [JsonPropertyName("ch-ua-arch")]
        ChUaArch,
        /// <summary>
        /// ch-ua-bitness
        /// </summary>
        [JsonPropertyName("ch-ua-bitness")]
        ChUaBitness,
        /// <summary>
        /// ch-ua-platform
        /// </summary>
        [JsonPropertyName("ch-ua-platform")]
        ChUaPlatform,
        /// <summary>
        /// ch-ua-model
        /// </summary>
        [JsonPropertyName("ch-ua-model")]
        ChUaModel,
        /// <summary>
        /// ch-ua-mobile
        /// </summary>
        [JsonPropertyName("ch-ua-mobile")]
        ChUaMobile,
        /// <summary>
        /// ch-ua-form-factors
        /// </summary>
        [JsonPropertyName("ch-ua-form-factors")]
        ChUaFormFactors,
        /// <summary>
        /// ch-ua-full-version
        /// </summary>
        [JsonPropertyName("ch-ua-full-version")]
        ChUaFullVersion,
        /// <summary>
        /// ch-ua-full-version-list
        /// </summary>
        [JsonPropertyName("ch-ua-full-version-list")]
        ChUaFullVersionList,
        /// <summary>
        /// ch-ua-platform-version
        /// </summary>
        [JsonPropertyName("ch-ua-platform-version")]
        ChUaPlatformVersion,
        /// <summary>
        /// ch-ua-wow64
        /// </summary>
        [JsonPropertyName("ch-ua-wow64")]
        ChUaWow64,
        /// <summary>
        /// ch-viewport-height
        /// </summary>
        [JsonPropertyName("ch-viewport-height")]
        ChViewportHeight,
        /// <summary>
        /// ch-viewport-width
        /// </summary>
        [JsonPropertyName("ch-viewport-width")]
        ChViewportWidth,
        /// <summary>
        /// ch-width
        /// </summary>
        [JsonPropertyName("ch-width")]
        ChWidth,
        /// <summary>
        /// clipboard-read
        /// </summary>
        [JsonPropertyName("clipboard-read")]
        ClipboardRead,
        /// <summary>
        /// clipboard-write
        /// </summary>
        [JsonPropertyName("clipboard-write")]
        ClipboardWrite,
        /// <summary>
        /// compute-pressure
        /// </summary>
        [JsonPropertyName("compute-pressure")]
        ComputePressure,
        /// <summary>
        /// cross-origin-isolated
        /// </summary>
        [JsonPropertyName("cross-origin-isolated")]
        CrossOriginIsolated,
        /// <summary>
        /// deferred-fetch
        /// </summary>
        [JsonPropertyName("deferred-fetch")]
        DeferredFetch,
        /// <summary>
        /// digital-credentials-get
        /// </summary>
        [JsonPropertyName("digital-credentials-get")]
        DigitalCredentialsGet,
        /// <summary>
        /// direct-sockets
        /// </summary>
        [JsonPropertyName("direct-sockets")]
        DirectSockets,
        /// <summary>
        /// display-capture
        /// </summary>
        [JsonPropertyName("display-capture")]
        DisplayCapture,
        /// <summary>
        /// document-domain
        /// </summary>
        [JsonPropertyName("document-domain")]
        DocumentDomain,
        /// <summary>
        /// encrypted-media
        /// </summary>
        [JsonPropertyName("encrypted-media")]
        EncryptedMedia,
        /// <summary>
        /// execution-while-out-of-viewport
        /// </summary>
        [JsonPropertyName("execution-while-out-of-viewport")]
        ExecutionWhileOutOfViewport,
        /// <summary>
        /// execution-while-not-rendered
        /// </summary>
        [JsonPropertyName("execution-while-not-rendered")]
        ExecutionWhileNotRendered,
        /// <summary>
        /// focus-without-user-activation
        /// </summary>
        [JsonPropertyName("focus-without-user-activation")]
        FocusWithoutUserActivation,
        /// <summary>
        /// fullscreen
        /// </summary>
        [JsonPropertyName("fullscreen")]
        Fullscreen,
        /// <summary>
        /// frobulate
        /// </summary>
        [JsonPropertyName("frobulate")]
        Frobulate,
        /// <summary>
        /// gamepad
        /// </summary>
        [JsonPropertyName("gamepad")]
        Gamepad,
        /// <summary>
        /// geolocation
        /// </summary>
        [JsonPropertyName("geolocation")]
        Geolocation,
        /// <summary>
        /// gyroscope
        /// </summary>
        [JsonPropertyName("gyroscope")]
        Gyroscope,
        /// <summary>
        /// hid
        /// </summary>
        [JsonPropertyName("hid")]
        Hid,
        /// <summary>
        /// identity-credentials-get
        /// </summary>
        [JsonPropertyName("identity-credentials-get")]
        IdentityCredentialsGet,
        /// <summary>
        /// idle-detection
        /// </summary>
        [JsonPropertyName("idle-detection")]
        IdleDetection,
        /// <summary>
        /// interest-cohort
        /// </summary>
        [JsonPropertyName("interest-cohort")]
        InterestCohort,
        /// <summary>
        /// join-ad-interest-group
        /// </summary>
        [JsonPropertyName("join-ad-interest-group")]
        JoinAdInterestGroup,
        /// <summary>
        /// keyboard-map
        /// </summary>
        [JsonPropertyName("keyboard-map")]
        KeyboardMap,
        /// <summary>
        /// local-fonts
        /// </summary>
        [JsonPropertyName("local-fonts")]
        LocalFonts,
        /// <summary>
        /// magnetometer
        /// </summary>
        [JsonPropertyName("magnetometer")]
        Magnetometer,
        /// <summary>
        /// media-playback-while-not-visible
        /// </summary>
        [JsonPropertyName("media-playback-while-not-visible")]
        MediaPlaybackWhileNotVisible,
        /// <summary>
        /// microphone
        /// </summary>
        [JsonPropertyName("microphone")]
        Microphone,
        /// <summary>
        /// midi
        /// </summary>
        [JsonPropertyName("midi")]
        Midi,
        /// <summary>
        /// otp-credentials
        /// </summary>
        [JsonPropertyName("otp-credentials")]
        OtpCredentials,
        /// <summary>
        /// payment
        /// </summary>
        [JsonPropertyName("payment")]
        Payment,
        /// <summary>
        /// picture-in-picture
        /// </summary>
        [JsonPropertyName("picture-in-picture")]
        PictureInPicture,
        /// <summary>
        /// private-aggregation
        /// </summary>
        [JsonPropertyName("private-aggregation")]
        PrivateAggregation,
        /// <summary>
        /// private-state-token-issuance
        /// </summary>
        [JsonPropertyName("private-state-token-issuance")]
        PrivateStateTokenIssuance,
        /// <summary>
        /// private-state-token-redemption
        /// </summary>
        [JsonPropertyName("private-state-token-redemption")]
        PrivateStateTokenRedemption,
        /// <summary>
        /// publickey-credentials-create
        /// </summary>
        [JsonPropertyName("publickey-credentials-create")]
        PublickeyCredentialsCreate,
        /// <summary>
        /// publickey-credentials-get
        /// </summary>
        [JsonPropertyName("publickey-credentials-get")]
        PublickeyCredentialsGet,
        /// <summary>
        /// run-ad-auction
        /// </summary>
        [JsonPropertyName("run-ad-auction")]
        RunAdAuction,
        /// <summary>
        /// screen-wake-lock
        /// </summary>
        [JsonPropertyName("screen-wake-lock")]
        ScreenWakeLock,
        /// <summary>
        /// serial
        /// </summary>
        [JsonPropertyName("serial")]
        Serial,
        /// <summary>
        /// shared-autofill
        /// </summary>
        [JsonPropertyName("shared-autofill")]
        SharedAutofill,
        /// <summary>
        /// shared-storage
        /// </summary>
        [JsonPropertyName("shared-storage")]
        SharedStorage,
        /// <summary>
        /// shared-storage-select-url
        /// </summary>
        [JsonPropertyName("shared-storage-select-url")]
        SharedStorageSelectUrl,
        /// <summary>
        /// smart-card
        /// </summary>
        [JsonPropertyName("smart-card")]
        SmartCard,
        /// <summary>
        /// speaker-selection
        /// </summary>
        [JsonPropertyName("speaker-selection")]
        SpeakerSelection,
        /// <summary>
        /// storage-access
        /// </summary>
        [JsonPropertyName("storage-access")]
        StorageAccess,
        /// <summary>
        /// sub-apps
        /// </summary>
        [JsonPropertyName("sub-apps")]
        SubApps,
        /// <summary>
        /// sync-xhr
        /// </summary>
        [JsonPropertyName("sync-xhr")]
        SyncXhr,
        /// <summary>
        /// unload
        /// </summary>
        [JsonPropertyName("unload")]
        Unload,
        /// <summary>
        /// usb
        /// </summary>
        [JsonPropertyName("usb")]
        Usb,
        /// <summary>
        /// usb-unrestricted
        /// </summary>
        [JsonPropertyName("usb-unrestricted")]
        UsbUnrestricted,
        /// <summary>
        /// vertical-scroll
        /// </summary>
        [JsonPropertyName("vertical-scroll")]
        VerticalScroll,
        /// <summary>
        /// web-printing
        /// </summary>
        [JsonPropertyName("web-printing")]
        WebPrinting,
        /// <summary>
        /// web-share
        /// </summary>
        [JsonPropertyName("web-share")]
        WebShare,
        /// <summary>
        /// window-management
        /// </summary>
        [JsonPropertyName("window-management")]
        WindowManagement,
        /// <summary>
        /// xr-spatial-tracking
        /// </summary>
        [JsonPropertyName("xr-spatial-tracking")]
        XrSpatialTracking
    }

    /// <summary>
    /// Reason for a permissions policy feature to be disabled.
    /// </summary>
    public enum PermissionsPolicyBlockReason
    {
        /// <summary>
        /// Header
        /// </summary>
        [JsonPropertyName("Header")]
        Header,
        /// <summary>
        /// IframeAttribute
        /// </summary>
        [JsonPropertyName("IframeAttribute")]
        IframeAttribute,
        /// <summary>
        /// InFencedFrameTree
        /// </summary>
        [JsonPropertyName("InFencedFrameTree")]
        InFencedFrameTree,
        /// <summary>
        /// InIsolatedApp
        /// </summary>
        [JsonPropertyName("InIsolatedApp")]
        InIsolatedApp
    }

    /// <summary>
    /// PermissionsPolicyBlockLocator
    /// </summary>
    public partial class PermissionsPolicyBlockLocator : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// FrameId
        /// </summary>
        [JsonPropertyName("frameId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string FrameId
        {
            get;
            set;
        }

        /// <summary>
        /// BlockReason
        /// </summary>
        [JsonPropertyName("blockReason")]
        public CefSharp.DevTools.Page.PermissionsPolicyBlockReason BlockReason
        {
            get;
            set;
        }
    }

    /// <summary>
    /// PermissionsPolicyFeatureState
    /// </summary>
    public partial class PermissionsPolicyFeatureState : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Feature
        /// </summary>
        [JsonPropertyName("feature")]
        public CefSharp.DevTools.Page.PermissionsPolicyFeature Feature
        {
            get;
            set;
        }

        /// <summary>
        /// Allowed
        /// </summary>
        [JsonPropertyName("allowed")]
        public bool Allowed
        {
            get;
            set;
        }

        /// <summary>
        /// Locator
        /// </summary>
        [JsonPropertyName("locator")]
        public CefSharp.DevTools.Page.PermissionsPolicyBlockLocator Locator
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Origin Trial(https://www.chromium.org/blink/origin-trials) support.
    /// Status for an Origin Trial token.
    /// </summary>
    public enum OriginTrialTokenStatus
    {
        /// <summary>
        /// Success
        /// </summary>
        [JsonPropertyName("Success")]
        Success,
        /// <summary>
        /// NotSupported
        /// </summary>
        [JsonPropertyName("NotSupported")]
        NotSupported,
        /// <summary>
        /// Insecure
        /// </summary>
        [JsonPropertyName("Insecure")]
        Insecure,
        /// <summary>
        /// Expired
        /// </summary>
        [JsonPropertyName("Expired")]
        Expired,
        /// <summary>
        /// WrongOrigin
        /// </summary>
        [JsonPropertyName("WrongOrigin")]
        WrongOrigin,
        /// <summary>
        /// InvalidSignature
        /// </summary>
        [JsonPropertyName("InvalidSignature")]
        InvalidSignature,
        /// <summary>
        /// Malformed
        /// </summary>
        [JsonPropertyName("Malformed")]
        Malformed,
        /// <summary>
        /// WrongVersion
        /// </summary>
        [JsonPropertyName("WrongVersion")]
        WrongVersion,
        /// <summary>
        /// FeatureDisabled
        /// </summary>
        [JsonPropertyName("FeatureDisabled")]
        FeatureDisabled,
        /// <summary>
        /// TokenDisabled
        /// </summary>
        [JsonPropertyName("TokenDisabled")]
        TokenDisabled,
        /// <summary>
        /// FeatureDisabledForUser
        /// </summary>
        [JsonPropertyName("FeatureDisabledForUser")]
        FeatureDisabledForUser,
        /// <summary>
        /// UnknownTrial
        /// </summary>
        [JsonPropertyName("UnknownTrial")]
        UnknownTrial
    }

    /// <summary>
    /// Status for an Origin Trial.
    /// </summary>
    public enum OriginTrialStatus
    {
        /// <summary>
        /// Enabled
        /// </summary>
        [JsonPropertyName("Enabled")]
        Enabled,
        /// <summary>
        /// ValidTokenNotProvided
        /// </summary>
        [JsonPropertyName("ValidTokenNotProvided")]
        ValidTokenNotProvided,
        /// <summary>
        /// OSNotSupported
        /// </summary>
        [JsonPropertyName("OSNotSupported")]
        OSNotSupported,
        /// <summary>
        /// TrialNotAllowed
        /// </summary>
        [JsonPropertyName("TrialNotAllowed")]
        TrialNotAllowed
    }

    /// <summary>
    /// OriginTrialUsageRestriction
    /// </summary>
    public enum OriginTrialUsageRestriction
    {
        /// <summary>
        /// None
        /// </summary>
        [JsonPropertyName("None")]
        None,
        /// <summary>
        /// Subset
        /// </summary>
        [JsonPropertyName("Subset")]
        Subset
    }

    /// <summary>
    /// OriginTrialToken
    /// </summary>
    public partial class OriginTrialToken : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Origin
        /// </summary>
        [JsonPropertyName("origin")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Origin
        {
            get;
            set;
        }

        /// <summary>
        /// MatchSubDomains
        /// </summary>
        [JsonPropertyName("matchSubDomains")]
        public bool MatchSubDomains
        {
            get;
            set;
        }

        /// <summary>
        /// TrialName
        /// </summary>
        [JsonPropertyName("trialName")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string TrialName
        {
            get;
            set;
        }

        /// <summary>
        /// ExpiryTime
        /// </summary>
        [JsonPropertyName("expiryTime")]
        public double ExpiryTime
        {
            get;
            set;
        }

        /// <summary>
        /// IsThirdParty
        /// </summary>
        [JsonPropertyName("isThirdParty")]
        public bool IsThirdParty
        {
            get;
            set;
        }

        /// <summary>
        /// UsageRestriction
        /// </summary>
        [JsonPropertyName("usageRestriction")]
        public CefSharp.DevTools.Page.OriginTrialUsageRestriction UsageRestriction
        {
            get;
            set;
        }
    }

    /// <summary>
    /// OriginTrialTokenWithStatus
    /// </summary>
    public partial class OriginTrialTokenWithStatus : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// RawTokenText
        /// </summary>
        [JsonPropertyName("rawTokenText")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string RawTokenText
        {
            get;
            set;
        }

        /// <summary>
        /// `parsedToken` is present only when the token is extractable and
        /// parsable.
        /// </summary>
        [JsonPropertyName("parsedToken")]
        public CefSharp.DevTools.Page.OriginTrialToken ParsedToken
        {
            get;
            set;
        }

        /// <summary>
        /// Status
        /// </summary>
        [JsonPropertyName("status")]
        public CefSharp.DevTools.Page.OriginTrialTokenStatus Status
        {
            get;
            set;
        }
    }

    /// <summary>
    /// OriginTrial
    /// </summary>
    public partial class OriginTrial : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// TrialName
        /// </summary>
        [JsonPropertyName("trialName")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string TrialName
        {
            get;
            set;
        }

        /// <summary>
        /// Status
        /// </summary>
        [JsonPropertyName("status")]
        public CefSharp.DevTools.Page.OriginTrialStatus Status
        {
            get;
            set;
        }

        /// <summary>
        /// TokensWithStatus
        /// </summary>
        [JsonPropertyName("tokensWithStatus")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public System.Collections.Generic.IList<CefSharp.DevTools.Page.OriginTrialTokenWithStatus> TokensWithStatus
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Information about the Frame on the page.
    /// </summary>
    public partial class Frame : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Frame unique identifier.
        /// </summary>
        [JsonPropertyName("id")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Id
        {
            get;
            set;
        }

        /// <summary>
        /// Parent frame identifier.
        /// </summary>
        [JsonPropertyName("parentId")]
        public string ParentId
        {
            get;
            set;
        }

        /// <summary>
        /// Identifier of the loader associated with this frame.
        /// </summary>
        [JsonPropertyName("loaderId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string LoaderId
        {
            get;
            set;
        }

        /// <summary>
        /// Frame&apos;s name as specified in the tag.
        /// </summary>
        [JsonPropertyName("name")]
        public string Name
        {
            get;
            set;
        }

        /// <summary>
        /// Frame document&apos;s URL without fragment.
        /// </summary>
        [JsonPropertyName("url")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Url
        {
            get;
            set;
        }

        /// <summary>
        /// Frame document&apos;s URL fragment including the &apos;#&apos;.
        /// </summary>
        [JsonPropertyName("urlFragment")]
        public string UrlFragment
        {
            get;
            set;
        }

        /// <summary>
        /// Frame document&apos;s registered domain, taking the public suffixes list into account.
        /// Extracted from the Frame&apos;s url.
        /// Example URLs: http://www.google.com/file.html -&gt; &quot;google.com&quot;
        ///               http://a.b.co.uk/file.html      -&gt; &quot;b.co.uk&quot;
        /// </summary>
        [JsonPropertyName("domainAndRegistry")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string DomainAndRegistry
        {
            get;
            set;
        }

        /// <summary>
        /// Frame document&apos;s security origin.
        /// </summary>
        [JsonPropertyName("securityOrigin")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string SecurityOrigin
        {
            get;
            set;
        }

        /// <summary>
        /// Frame document&apos;s mimeType as determined by the browser.
        /// </summary>
        [JsonPropertyName("mimeType")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string MimeType
        {
            get;
            set;
        }

        /// <summary>
        /// If the frame failed to load, this contains the URL that could not be loaded. Note that unlike url above, this URL may contain a fragment.
        /// </summary>
        [JsonPropertyName("unreachableUrl")]
        public string UnreachableUrl
        {
            get;
            set;
        }

        /// <summary>
        /// Indicates whether this frame was tagged as an ad and why.
        /// </summary>
        [JsonPropertyName("adFrameStatus")]
        public CefSharp.DevTools.Page.AdFrameStatus AdFrameStatus
        {
            get;
            set;
        }

        /// <summary>
        /// Indicates whether the main document is a secure context and explains why that is the case.
        /// </summary>
        [JsonPropertyName("secureContextType")]
        public CefSharp.DevTools.Page.SecureContextType SecureContextType
        {
            get;
            set;
        }

        /// <summary>
        /// Indicates whether this is a cross origin isolated context.
        /// </summary>
        [JsonPropertyName("crossOriginIsolatedContextType")]
        public CefSharp.DevTools.Page.CrossOriginIsolatedContextType CrossOriginIsolatedContextType
        {
            get;
            set;
        }

        /// <summary>
        /// Indicated which gated APIs / features are available.
        /// </summary>
        [JsonPropertyName("gatedAPIFeatures")]
        public CefSharp.DevTools.Page.GatedAPIFeatures[] GatedAPIFeatures
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Information about the Resource on the page.
    /// </summary>
    public partial class FrameResource : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Resource URL.
        /// </summary>
        [JsonPropertyName("url")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Url
        {
            get;
            set;
        }

        /// <summary>
        /// Type of this resource.
        /// </summary>
        [JsonPropertyName("type")]
        public CefSharp.DevTools.Network.ResourceType Type
        {
            get;
            set;
        }

        /// <summary>
        /// Resource mimeType as determined by the browser.
        /// </summary>
        [JsonPropertyName("mimeType")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string MimeType
        {
            get;
            set;
        }

        /// <summary>
        /// last-modified timestamp as reported by server.
        /// </summary>
        [JsonPropertyName("lastModified")]
        public double? LastModified
        {
            get;
            set;
        }

        /// <summary>
        /// Resource content size.
        /// </summary>
        [JsonPropertyName("contentSize")]
        public double? ContentSize
        {
            get;
            set;
        }

        /// <summary>
        /// True if the resource failed to load.
        /// </summary>
        [JsonPropertyName("failed")]
        public bool? Failed
        {
            get;
            set;
        }

        /// <summary>
        /// True if the resource was canceled during loading.
        /// </summary>
        [JsonPropertyName("canceled")]
        public bool? Canceled
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Information about the Frame hierarchy along with their cached resources.
    /// </summary>
    public partial class FrameResourceTree : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Frame information for this tree item.
        /// </summary>
        [JsonPropertyName("frame")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.Page.Frame Frame
        {
            get;
            set;
        }

        /// <summary>
        /// Child frames.
        /// </summary>
        [JsonPropertyName("childFrames")]
        public System.Collections.Generic.IList<CefSharp.DevTools.Page.FrameResourceTree> ChildFrames
        {
            get;
            set;
        }

        /// <summary>
        /// Information about frame resources.
        /// </summary>
        [JsonPropertyName("resources")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public System.Collections.Generic.IList<CefSharp.DevTools.Page.FrameResource> Resources
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Information about the Frame hierarchy.
    /// </summary>
    public partial class FrameTree : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Frame information for this tree item.
        /// </summary>
        [JsonPropertyName("frame")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.Page.Frame Frame
        {
            get;
            set;
        }

        /// <summary>
        /// Child frames.
        /// </summary>
        [JsonPropertyName("childFrames")]
        public System.Collections.Generic.IList<CefSharp.DevTools.Page.FrameTree> ChildFrames
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Transition type.
    /// </summary>
    public enum TransitionType
    {
        /// <summary>
        /// link
        /// </summary>
        [JsonPropertyName("link")]
        Link,
        /// <summary>
        /// typed
        /// </summary>
        [JsonPropertyName("typed")]
        Typed,
        /// <summary>
        /// address_bar
        /// </summary>
        [JsonPropertyName("address_bar")]
        AddressBar,
        /// <summary>
        /// auto_bookmark
        /// </summary>
        [JsonPropertyName("auto_bookmark")]
        AutoBookmark,
        /// <summary>
        /// auto_subframe
        /// </summary>
        [JsonPropertyName("auto_subframe")]
        AutoSubframe,
        /// <summary>
        /// manual_subframe
        /// </summary>
        [JsonPropertyName("manual_subframe")]
        ManualSubframe,
        /// <summary>
        /// generated
        /// </summary>
        [JsonPropertyName("generated")]
        Generated,
        /// <summary>
        /// auto_toplevel
        /// </summary>
        [JsonPropertyName("auto_toplevel")]
        AutoToplevel,
        /// <summary>
        /// form_submit
        /// </summary>
        [JsonPropertyName("form_submit")]
        FormSubmit,
        /// <summary>
        /// reload
        /// </summary>
        [JsonPropertyName("reload")]
        Reload,
        /// <summary>
        /// keyword
        /// </summary>
        [JsonPropertyName("keyword")]
        Keyword,
        /// <summary>
        /// keyword_generated
        /// </summary>
        [JsonPropertyName("keyword_generated")]
        KeywordGenerated,
        /// <summary>
        /// other
        /// </summary>
        [JsonPropertyName("other")]
        Other
    }

    /// <summary>
    /// Navigation history entry.
    /// </summary>
    public partial class NavigationEntry : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Unique id of the navigation history entry.
        /// </summary>
        [JsonPropertyName("id")]
        public int Id
        {
            get;
            set;
        }

        /// <summary>
        /// URL of the navigation history entry.
        /// </summary>
        [JsonPropertyName("url")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Url
        {
            get;
            set;
        }

        /// <summary>
        /// URL that the user typed in the url bar.
        /// </summary>
        [JsonPropertyName("userTypedURL")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string UserTypedURL
        {
            get;
            set;
        }

        /// <summary>
        /// Title of the navigation history entry.
        /// </summary>
        [JsonPropertyName("title")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Title
        {
            get;
            set;
        }

        /// <summary>
        /// Transition type.
        /// </summary>
        [JsonPropertyName("transitionType")]
        public CefSharp.DevTools.Page.TransitionType TransitionType
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Screencast frame metadata.
    /// </summary>
    public partial class ScreencastFrameMetadata : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Top offset in DIP.
        /// </summary>
        [JsonPropertyName("offsetTop")]
        public double OffsetTop
        {
            get;
            set;
        }

        /// <summary>
        /// Page scale factor.
        /// </summary>
        [JsonPropertyName("pageScaleFactor")]
        public double PageScaleFactor
        {
            get;
            set;
        }

        /// <summary>
        /// Device screen width in DIP.
        /// </summary>
        [JsonPropertyName("deviceWidth")]
        public double DeviceWidth
        {
            get;
            set;
        }

        /// <summary>
        /// Device screen height in DIP.
        /// </summary>
        [JsonPropertyName("deviceHeight")]
        public double DeviceHeight
        {
            get;
            set;
        }

        /// <summary>
        /// Position of horizontal scroll in CSS pixels.
        /// </summary>
        [JsonPropertyName("scrollOffsetX")]
        public double ScrollOffsetX
        {
            get;
            set;
        }

        /// <summary>
        /// Position of vertical scroll in CSS pixels.
        /// </summary>
        [JsonPropertyName("scrollOffsetY")]
        public double ScrollOffsetY
        {
            get;
            set;
        }

        /// <summary>
        /// Frame swap timestamp.
        /// </summary>
        [JsonPropertyName("timestamp")]
        public double? Timestamp
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Javascript dialog type.
    /// </summary>
    public enum DialogType
    {
        /// <summary>
        /// alert
        /// </summary>
        [JsonPropertyName("alert")]
        Alert,
        /// <summary>
        /// confirm
        /// </summary>
        [JsonPropertyName("confirm")]
        Confirm,
        /// <summary>
        /// prompt
        /// </summary>
        [JsonPropertyName("prompt")]
        Prompt,
        /// <summary>
        /// beforeunload
        /// </summary>
        [JsonPropertyName("beforeunload")]
        Beforeunload
    }

    /// <summary>
    /// Error while paring app manifest.
    /// </summary>
    public partial class AppManifestError : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Error message.
        /// </summary>
        [JsonPropertyName("message")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Message
        {
            get;
            set;
        }

        /// <summary>
        /// If critical, this is a non-recoverable parse error.
        /// </summary>
        [JsonPropertyName("critical")]
        public int Critical
        {
            get;
            set;
        }

        /// <summary>
        /// Error line.
        /// </summary>
        [JsonPropertyName("line")]
        public int Line
        {
            get;
            set;
        }

        /// <summary>
        /// Error column.
        /// </summary>
        [JsonPropertyName("column")]
        public int Column
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Parsed app manifest properties.
    /// </summary>
    public partial class AppManifestParsedProperties : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Computed scope value
        /// </summary>
        [JsonPropertyName("scope")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Scope
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Layout viewport position and dimensions.
    /// </summary>
    public partial class LayoutViewport : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Horizontal offset relative to the document (CSS pixels).
        /// </summary>
        [JsonPropertyName("pageX")]
        public int PageX
        {
            get;
            set;
        }

        /// <summary>
        /// Vertical offset relative to the document (CSS pixels).
        /// </summary>
        [JsonPropertyName("pageY")]
        public int PageY
        {
            get;
            set;
        }

        /// <summary>
        /// Width (CSS pixels), excludes scrollbar if present.
        /// </summary>
        [JsonPropertyName("clientWidth")]
        public int ClientWidth
        {
            get;
            set;
        }

        /// <summary>
        /// Height (CSS pixels), excludes scrollbar if present.
        /// </summary>
        [JsonPropertyName("clientHeight")]
        public int ClientHeight
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Visual viewport position, dimensions, and scale.
    /// </summary>
    public partial class VisualViewport : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Horizontal offset relative to the layout viewport (CSS pixels).
        /// </summary>
        [JsonPropertyName("offsetX")]
        public double OffsetX
        {
            get;
            set;
        }

        /// <summary>
        /// Vertical offset relative to the layout viewport (CSS pixels).
        /// </summary>
        [JsonPropertyName("offsetY")]
        public double OffsetY
        {
            get;
            set;
        }

        /// <summary>
        /// Horizontal offset relative to the document (CSS pixels).
        /// </summary>
        [JsonPropertyName("pageX")]
        public double PageX
        {
            get;
            set;
        }

        /// <summary>
        /// Vertical offset relative to the document (CSS pixels).
        /// </summary>
        [JsonPropertyName("pageY")]
        public double PageY
        {
            get;
            set;
        }

        /// <summary>
        /// Width (CSS pixels), excludes scrollbar if present.
        /// </summary>
        [JsonPropertyName("clientWidth")]
        public double ClientWidth
        {
            get;
            set;
        }

        /// <summary>
        /// Height (CSS pixels), excludes scrollbar if present.
        /// </summary>
        [JsonPropertyName("clientHeight")]
        public double ClientHeight
        {
            get;
            set;
        }

        /// <summary>
        /// Scale relative to the ideal viewport (size at width=device-width).
        /// </summary>
        [JsonPropertyName("scale")]
        public double Scale
        {
            get;
            set;
        }

        /// <summary>
        /// Page zoom factor (CSS to device independent pixels ratio).
        /// </summary>
        [JsonPropertyName("zoom")]
        public double? Zoom
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Viewport for capturing screenshot.
    /// </summary>
    public partial class Viewport : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// X offset in device independent pixels (dip).
        /// </summary>
        [JsonPropertyName("x")]
        public double X
        {
            get;
            set;
        }

        /// <summary>
        /// Y offset in device independent pixels (dip).
        /// </summary>
        [JsonPropertyName("y")]
        public double Y
        {
            get;
            set;
        }

        /// <summary>
        /// Rectangle width in device independent pixels (dip).
        /// </summary>
        [JsonPropertyName("width")]
        public double Width
        {
            get;
            set;
        }

        /// <summary>
        /// Rectangle height in device independent pixels (dip).
        /// </summary>
        [JsonPropertyName("height")]
        public double Height
        {
            get;
            set;
        }

        /// <summary>
        /// Page scale factor.
        /// </summary>
        [JsonPropertyName("scale")]
        public double Scale
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Generic font families collection.
    /// </summary>
    public partial class FontFamilies : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The standard font-family.
        /// </summary>
        [JsonPropertyName("standard")]
        public string Standard
        {
            get;
            set;
        }

        /// <summary>
        /// The fixed font-family.
        /// </summary>
        [JsonPropertyName("fixed")]
        public string Fixed
        {
            get;
            set;
        }

        /// <summary>
        /// The serif font-family.
        /// </summary>
        [JsonPropertyName("serif")]
        public string Serif
        {
            get;
            set;
        }

        /// <summary>
        /// The sansSerif font-family.
        /// </summary>
        [JsonPropertyName("sansSerif")]
        public string SansSerif
        {
            get;
            set;
        }

        /// <summary>
        /// The cursive font-family.
        /// </summary>
        [JsonPropertyName("cursive")]
        public string Cursive
        {
            get;
            set;
        }

        /// <summary>
        /// The fantasy font-family.
        /// </summary>
        [JsonPropertyName("fantasy")]
        public string Fantasy
        {
            get;
            set;
        }

        /// <summary>
        /// The math font-family.
        /// </summary>
        [JsonPropertyName("math")]
        public string Math
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Font families collection for a script.
    /// </summary>
    public partial class ScriptFontFamilies : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Name of the script which these font families are defined for.
        /// </summary>
        [JsonPropertyName("script")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Script
        {
            get;
            set;
        }

        /// <summary>
        /// Generic font families collection for the script.
        /// </summary>
        [JsonPropertyName("fontFamilies")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.Page.FontFamilies FontFamilies
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Default font sizes.
    /// </summary>
    public partial class FontSizes : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Default standard font size.
        /// </summary>
        [JsonPropertyName("standard")]
        public int? Standard
        {
            get;
            set;
        }

        /// <summary>
        /// Default fixed font size.
        /// </summary>
        [JsonPropertyName("fixed")]
        public int? Fixed
        {
            get;
            set;
        }
    }

    /// <summary>
    /// ClientNavigationReason
    /// </summary>
    public enum ClientNavigationReason
    {
        /// <summary>
        /// anchorClick
        /// </summary>
        [JsonPropertyName("anchorClick")]
        AnchorClick,
        /// <summary>
        /// formSubmissionGet
        /// </summary>
        [JsonPropertyName("formSubmissionGet")]
        FormSubmissionGet,
        /// <summary>
        /// formSubmissionPost
        /// </summary>
        [JsonPropertyName("formSubmissionPost")]
        FormSubmissionPost,
        /// <summary>
        /// httpHeaderRefresh
        /// </summary>
        [JsonPropertyName("httpHeaderRefresh")]
        HttpHeaderRefresh,
        /// <summary>
        /// initialFrameNavigation
        /// </summary>
        [JsonPropertyName("initialFrameNavigation")]
        InitialFrameNavigation,
        /// <summary>
        /// metaTagRefresh
        /// </summary>
        [JsonPropertyName("metaTagRefresh")]
        MetaTagRefresh,
        /// <summary>
        /// other
        /// </summary>
        [JsonPropertyName("other")]
        Other,
        /// <summary>
        /// pageBlockInterstitial
        /// </summary>
        [JsonPropertyName("pageBlockInterstitial")]
        PageBlockInterstitial,
        /// <summary>
        /// reload
        /// </summary>
        [JsonPropertyName("reload")]
        Reload,
        /// <summary>
        /// scriptInitiated
        /// </summary>
        [JsonPropertyName("scriptInitiated")]
        ScriptInitiated
    }

    /// <summary>
    /// ClientNavigationDisposition
    /// </summary>
    public enum ClientNavigationDisposition
    {
        /// <summary>
        /// currentTab
        /// </summary>
        [JsonPropertyName("currentTab")]
        CurrentTab,
        /// <summary>
        /// newTab
        /// </summary>
        [JsonPropertyName("newTab")]
        NewTab,
        /// <summary>
        /// newWindow
        /// </summary>
        [JsonPropertyName("newWindow")]
        NewWindow,
        /// <summary>
        /// download
        /// </summary>
        [JsonPropertyName("download")]
        Download
    }

    /// <summary>
    /// InstallabilityErrorArgument
    /// </summary>
    public partial class InstallabilityErrorArgument : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Argument name (e.g. name:&apos;minimum-icon-size-in-pixels&apos;).
        /// </summary>
        [JsonPropertyName("name")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Name
        {
            get;
            set;
        }

        /// <summary>
        /// Argument value (e.g. value:&apos;64&apos;).
        /// </summary>
        [JsonPropertyName("value")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Value
        {
            get;
            set;
        }
    }

    /// <summary>
    /// The installability error
    /// </summary>
    public partial class InstallabilityError : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The error id (e.g. &apos;manifest-missing-suitable-icon&apos;).
        /// </summary>
        [JsonPropertyName("errorId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string ErrorId
        {
            get;
            set;
        }

        /// <summary>
        /// The list of error arguments (e.g. {name:&apos;minimum-icon-size-in-pixels&apos;, value:&apos;64&apos;}).
        /// </summary>
        [JsonPropertyName("errorArguments")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public System.Collections.Generic.IList<CefSharp.DevTools.Page.InstallabilityErrorArgument> ErrorArguments
        {
            get;
            set;
        }
    }

    /// <summary>
    /// The referring-policy used for the navigation.
    /// </summary>
    public enum ReferrerPolicy
    {
        /// <summary>
        /// noReferrer
        /// </summary>
        [JsonPropertyName("noReferrer")]
        NoReferrer,
        /// <summary>
        /// noReferrerWhenDowngrade
        /// </summary>
        [JsonPropertyName("noReferrerWhenDowngrade")]
        NoReferrerWhenDowngrade,
        /// <summary>
        /// origin
        /// </summary>
        [JsonPropertyName("origin")]
        Origin,
        /// <summary>
        /// originWhenCrossOrigin
        /// </summary>
        [JsonPropertyName("originWhenCrossOrigin")]
        OriginWhenCrossOrigin,
        /// <summary>
        /// sameOrigin
        /// </summary>
        [JsonPropertyName("sameOrigin")]
        SameOrigin,
        /// <summary>
        /// strictOrigin
        /// </summary>
        [JsonPropertyName("strictOrigin")]
        StrictOrigin,
        /// <summary>
        /// strictOriginWhenCrossOrigin
        /// </summary>
        [JsonPropertyName("strictOriginWhenCrossOrigin")]
        StrictOriginWhenCrossOrigin,
        /// <summary>
        /// unsafeUrl
        /// </summary>
        [JsonPropertyName("unsafeUrl")]
        UnsafeUrl
    }

    /// <summary>
    /// Per-script compilation cache parameters for `Page.produceCompilationCache`
    /// </summary>
    public partial class CompilationCacheParams : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The URL of the script to produce a compilation cache entry for.
        /// </summary>
        [JsonPropertyName("url")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Url
        {
            get;
            set;
        }

        /// <summary>
        /// A hint to the backend whether eager compilation is recommended.
        /// (the actual compilation mode used is upon backend discretion).
        /// </summary>
        [JsonPropertyName("eager")]
        public bool? Eager
        {
            get;
            set;
        }
    }

    /// <summary>
    /// FileFilter
    /// </summary>
    public partial class FileFilter : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Name
        /// </summary>
        [JsonPropertyName("name")]
        public string Name
        {
            get;
            set;
        }

        /// <summary>
        /// Accepts
        /// </summary>
        [JsonPropertyName("accepts")]
        public string[] Accepts
        {
            get;
            set;
        }
    }

    /// <summary>
    /// FileHandler
    /// </summary>
    public partial class FileHandler : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Action
        /// </summary>
        [JsonPropertyName("action")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Action
        {
            get;
            set;
        }

        /// <summary>
        /// Name
        /// </summary>
        [JsonPropertyName("name")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Name
        {
            get;
            set;
        }

        /// <summary>
        /// Icons
        /// </summary>
        [JsonPropertyName("icons")]
        public System.Collections.Generic.IList<CefSharp.DevTools.Page.ImageResource> Icons
        {
            get;
            set;
        }

        /// <summary>
        /// Mimic a map, name is the key, accepts is the value.
        /// </summary>
        [JsonPropertyName("accepts")]
        public System.Collections.Generic.IList<CefSharp.DevTools.Page.FileFilter> Accepts
        {
            get;
            set;
        }

        /// <summary>
        /// Won&apos;t repeat the enums, using string for easy comparison. Same as the
        /// other enums below.
        /// </summary>
        [JsonPropertyName("launchType")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string LaunchType
        {
            get;
            set;
        }
    }

    /// <summary>
    /// The image definition used in both icon and screenshot.
    /// </summary>
    public partial class ImageResource : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The src field in the definition, but changing to url in favor of
        /// consistency.
        /// </summary>
        [JsonPropertyName("url")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Url
        {
            get;
            set;
        }

        /// <summary>
        /// Sizes
        /// </summary>
        [JsonPropertyName("sizes")]
        public string Sizes
        {
            get;
            set;
        }

        /// <summary>
        /// Type
        /// </summary>
        [JsonPropertyName("type")]
        public string Type
        {
            get;
            set;
        }
    }

    /// <summary>
    /// LaunchHandler
    /// </summary>
    public partial class LaunchHandler : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// ClientMode
        /// </summary>
        [JsonPropertyName("clientMode")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string ClientMode
        {
            get;
            set;
        }
    }

    /// <summary>
    /// ProtocolHandler
    /// </summary>
    public partial class ProtocolHandler : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Protocol
        /// </summary>
        [JsonPropertyName("protocol")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Protocol
        {
            get;
            set;
        }

        /// <summary>
        /// Url
        /// </summary>
        [JsonPropertyName("url")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Url
        {
            get;
            set;
        }
    }

    /// <summary>
    /// RelatedApplication
    /// </summary>
    public partial class RelatedApplication : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Id
        /// </summary>
        [JsonPropertyName("id")]
        public string Id
        {
            get;
            set;
        }

        /// <summary>
        /// Url
        /// </summary>
        [JsonPropertyName("url")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Url
        {
            get;
            set;
        }
    }

    /// <summary>
    /// ScopeExtension
    /// </summary>
    public partial class ScopeExtension : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Instead of using tuple, this field always returns the serialized string
        /// for easy understanding and comparison.
        /// </summary>
        [JsonPropertyName("origin")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Origin
        {
            get;
            set;
        }

        /// <summary>
        /// HasOriginWildcard
        /// </summary>
        [JsonPropertyName("hasOriginWildcard")]
        public bool HasOriginWildcard
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Screenshot
    /// </summary>
    public partial class Screenshot : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Image
        /// </summary>
        [JsonPropertyName("image")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.Page.ImageResource Image
        {
            get;
            set;
        }

        /// <summary>
        /// FormFactor
        /// </summary>
        [JsonPropertyName("formFactor")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string FormFactor
        {
            get;
            set;
        }

        /// <summary>
        /// Label
        /// </summary>
        [JsonPropertyName("label")]
        public string Label
        {
            get;
            set;
        }
    }

    /// <summary>
    /// ShareTarget
    /// </summary>
    public partial class ShareTarget : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Action
        /// </summary>
        [JsonPropertyName("action")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Action
        {
            get;
            set;
        }

        /// <summary>
        /// Method
        /// </summary>
        [JsonPropertyName("method")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Method
        {
            get;
            set;
        }

        /// <summary>
        /// Enctype
        /// </summary>
        [JsonPropertyName("enctype")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Enctype
        {
            get;
            set;
        }

        /// <summary>
        /// Embed the ShareTargetParams
        /// </summary>
        [JsonPropertyName("title")]
        public string Title
        {
            get;
            set;
        }

        /// <summary>
        /// Text
        /// </summary>
        [JsonPropertyName("text")]
        public string Text
        {
            get;
            set;
        }

        /// <summary>
        /// Url
        /// </summary>
        [JsonPropertyName("url")]
        public string Url
        {
            get;
            set;
        }

        /// <summary>
        /// Files
        /// </summary>
        [JsonPropertyName("files")]
        public System.Collections.Generic.IList<CefSharp.DevTools.Page.FileFilter> Files
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Shortcut
    /// </summary>
    public partial class Shortcut : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Name
        /// </summary>
        [JsonPropertyName("name")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Name
        {
            get;
            set;
        }

        /// <summary>
        /// Url
        /// </summary>
        [JsonPropertyName("url")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Url
        {
            get;
            set;
        }
    }

    /// <summary>
    /// WebAppManifest
    /// </summary>
    public partial class WebAppManifest : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// BackgroundColor
        /// </summary>
        [JsonPropertyName("backgroundColor")]
        public string BackgroundColor
        {
            get;
            set;
        }

        /// <summary>
        /// The extra description provided by the manifest.
        /// </summary>
        [JsonPropertyName("description")]
        public string Description
        {
            get;
            set;
        }

        /// <summary>
        /// Dir
        /// </summary>
        [JsonPropertyName("dir")]
        public string Dir
        {
            get;
            set;
        }

        /// <summary>
        /// Display
        /// </summary>
        [JsonPropertyName("display")]
        public string Display
        {
            get;
            set;
        }

        /// <summary>
        /// The overrided display mode controlled by the user.
        /// </summary>
        [JsonPropertyName("displayOverrides")]
        public string[] DisplayOverrides
        {
            get;
            set;
        }

        /// <summary>
        /// The handlers to open files.
        /// </summary>
        [JsonPropertyName("fileHandlers")]
        public System.Collections.Generic.IList<CefSharp.DevTools.Page.FileHandler> FileHandlers
        {
            get;
            set;
        }

        /// <summary>
        /// Icons
        /// </summary>
        [JsonPropertyName("icons")]
        public System.Collections.Generic.IList<CefSharp.DevTools.Page.ImageResource> Icons
        {
            get;
            set;
        }

        /// <summary>
        /// Id
        /// </summary>
        [JsonPropertyName("id")]
        public string Id
        {
            get;
            set;
        }

        /// <summary>
        /// Lang
        /// </summary>
        [JsonPropertyName("lang")]
        public string Lang
        {
            get;
            set;
        }

        /// <summary>
        /// TODO(crbug.com/1231886): This field is non-standard and part of a Chrome
        /// experiment. See:
        /// https://github.com/WICG/web-app-launch/blob/main/launch_handler.md
        /// </summary>
        [JsonPropertyName("launchHandler")]
        public CefSharp.DevTools.Page.LaunchHandler LaunchHandler
        {
            get;
            set;
        }

        /// <summary>
        /// Name
        /// </summary>
        [JsonPropertyName("name")]
        public string Name
        {
            get;
            set;
        }

        /// <summary>
        /// Orientation
        /// </summary>
        [JsonPropertyName("orientation")]
        public string Orientation
        {
            get;
            set;
        }

        /// <summary>
        /// PreferRelatedApplications
        /// </summary>
        [JsonPropertyName("preferRelatedApplications")]
        public bool? PreferRelatedApplications
        {
            get;
            set;
        }

        /// <summary>
        /// The handlers to open protocols.
        /// </summary>
        [JsonPropertyName("protocolHandlers")]
        public System.Collections.Generic.IList<CefSharp.DevTools.Page.ProtocolHandler> ProtocolHandlers
        {
            get;
            set;
        }

        /// <summary>
        /// RelatedApplications
        /// </summary>
        [JsonPropertyName("relatedApplications")]
        public System.Collections.Generic.IList<CefSharp.DevTools.Page.RelatedApplication> RelatedApplications
        {
            get;
            set;
        }

        /// <summary>
        /// Scope
        /// </summary>
        [JsonPropertyName("scope")]
        public string Scope
        {
            get;
            set;
        }

        /// <summary>
        /// Non-standard, see
        /// https://github.com/WICG/manifest-incubations/blob/gh-pages/scope_extensions-explainer.md
        /// </summary>
        [JsonPropertyName("scopeExtensions")]
        public System.Collections.Generic.IList<CefSharp.DevTools.Page.ScopeExtension> ScopeExtensions
        {
            get;
            set;
        }

        /// <summary>
        /// The screenshots used by chromium.
        /// </summary>
        [JsonPropertyName("screenshots")]
        public System.Collections.Generic.IList<CefSharp.DevTools.Page.Screenshot> Screenshots
        {
            get;
            set;
        }

        /// <summary>
        /// ShareTarget
        /// </summary>
        [JsonPropertyName("shareTarget")]
        public CefSharp.DevTools.Page.ShareTarget ShareTarget
        {
            get;
            set;
        }

        /// <summary>
        /// ShortName
        /// </summary>
        [JsonPropertyName("shortName")]
        public string ShortName
        {
            get;
            set;
        }

        /// <summary>
        /// Shortcuts
        /// </summary>
        [JsonPropertyName("shortcuts")]
        public System.Collections.Generic.IList<CefSharp.DevTools.Page.Shortcut> Shortcuts
        {
            get;
            set;
        }

        /// <summary>
        /// StartUrl
        /// </summary>
        [JsonPropertyName("startUrl")]
        public string StartUrl
        {
            get;
            set;
        }

        /// <summary>
        /// ThemeColor
        /// </summary>
        [JsonPropertyName("themeColor")]
        public string ThemeColor
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Enum of possible auto-response for permission / prompt dialogs.
    /// </summary>
    public enum AutoResponseMode
    {
        /// <summary>
        /// none
        /// </summary>
        [JsonPropertyName("none")]
        None,
        /// <summary>
        /// autoAccept
        /// </summary>
        [JsonPropertyName("autoAccept")]
        AutoAccept,
        /// <summary>
        /// autoReject
        /// </summary>
        [JsonPropertyName("autoReject")]
        AutoReject,
        /// <summary>
        /// autoOptOut
        /// </summary>
        [JsonPropertyName("autoOptOut")]
        AutoOptOut
    }

    /// <summary>
    /// The type of a frameNavigated event.
    /// </summary>
    public enum NavigationType
    {
        /// <summary>
        /// Navigation
        /// </summary>
        [JsonPropertyName("Navigation")]
        Navigation,
        /// <summary>
        /// BackForwardCacheRestore
        /// </summary>
        [JsonPropertyName("BackForwardCacheRestore")]
        BackForwardCacheRestore
    }

    /// <summary>
    /// List of not restored reasons for back-forward cache.
    /// </summary>
    public enum BackForwardCacheNotRestoredReason
    {
        /// <summary>
        /// NotPrimaryMainFrame
        /// </summary>
        [JsonPropertyName("NotPrimaryMainFrame")]
        NotPrimaryMainFrame,
        /// <summary>
        /// BackForwardCacheDisabled
        /// </summary>
        [JsonPropertyName("BackForwardCacheDisabled")]
        BackForwardCacheDisabled,
        /// <summary>
        /// RelatedActiveContentsExist
        /// </summary>
        [JsonPropertyName("RelatedActiveContentsExist")]
        RelatedActiveContentsExist,
        /// <summary>
        /// HTTPStatusNotOK
        /// </summary>
        [JsonPropertyName("HTTPStatusNotOK")]
        HTTPStatusNotOK,
        /// <summary>
        /// SchemeNotHTTPOrHTTPS
        /// </summary>
        [JsonPropertyName("SchemeNotHTTPOrHTTPS")]
        SchemeNotHTTPOrHTTPS,
        /// <summary>
        /// Loading
        /// </summary>
        [JsonPropertyName("Loading")]
        Loading,
        /// <summary>
        /// WasGrantedMediaAccess
        /// </summary>
        [JsonPropertyName("WasGrantedMediaAccess")]
        WasGrantedMediaAccess,
        /// <summary>
        /// DisableForRenderFrameHostCalled
        /// </summary>
        [JsonPropertyName("DisableForRenderFrameHostCalled")]
        DisableForRenderFrameHostCalled,
        /// <summary>
        /// DomainNotAllowed
        /// </summary>
        [JsonPropertyName("DomainNotAllowed")]
        DomainNotAllowed,
        /// <summary>
        /// HTTPMethodNotGET
        /// </summary>
        [JsonPropertyName("HTTPMethodNotGET")]
        HTTPMethodNotGET,
        /// <summary>
        /// SubframeIsNavigating
        /// </summary>
        [JsonPropertyName("SubframeIsNavigating")]
        SubframeIsNavigating,
        /// <summary>
        /// Timeout
        /// </summary>
        [JsonPropertyName("Timeout")]
        Timeout,
        /// <summary>
        /// CacheLimit
        /// </summary>
        [JsonPropertyName("CacheLimit")]
        CacheLimit,
        /// <summary>
        /// JavaScriptExecution
        /// </summary>
        [JsonPropertyName("JavaScriptExecution")]
        JavaScriptExecution,
        /// <summary>
        /// RendererProcessKilled
        /// </summary>
        [JsonPropertyName("RendererProcessKilled")]
        RendererProcessKilled,
        /// <summary>
        /// RendererProcessCrashed
        /// </summary>
        [JsonPropertyName("RendererProcessCrashed")]
        RendererProcessCrashed,
        /// <summary>
        /// SchedulerTrackedFeatureUsed
        /// </summary>
        [JsonPropertyName("SchedulerTrackedFeatureUsed")]
        SchedulerTrackedFeatureUsed,
        /// <summary>
        /// ConflictingBrowsingInstance
        /// </summary>
        [JsonPropertyName("ConflictingBrowsingInstance")]
        ConflictingBrowsingInstance,
        /// <summary>
        /// CacheFlushed
        /// </summary>
        [JsonPropertyName("CacheFlushed")]
        CacheFlushed,
        /// <summary>
        /// ServiceWorkerVersionActivation
        /// </summary>
        [JsonPropertyName("ServiceWorkerVersionActivation")]
        ServiceWorkerVersionActivation,
        /// <summary>
        /// SessionRestored
        /// </summary>
        [JsonPropertyName("SessionRestored")]
        SessionRestored,
        /// <summary>
        /// ServiceWorkerPostMessage
        /// </summary>
        [JsonPropertyName("ServiceWorkerPostMessage")]
        ServiceWorkerPostMessage,
        /// <summary>
        /// EnteredBackForwardCacheBeforeServiceWorkerHostAdded
        /// </summary>
        [JsonPropertyName("EnteredBackForwardCacheBeforeServiceWorkerHostAdded")]
        EnteredBackForwardCacheBeforeServiceWorkerHostAdded,
        /// <summary>
        /// RenderFrameHostReused_SameSite
        /// </summary>
        [JsonPropertyName("RenderFrameHostReused_SameSite")]
        RenderFrameHostReusedSameSite,
        /// <summary>
        /// RenderFrameHostReused_CrossSite
        /// </summary>
        [JsonPropertyName("RenderFrameHostReused_CrossSite")]
        RenderFrameHostReusedCrossSite,
        /// <summary>
        /// ServiceWorkerClaim
        /// </summary>
        [JsonPropertyName("ServiceWorkerClaim")]
        ServiceWorkerClaim,
        /// <summary>
        /// IgnoreEventAndEvict
        /// </summary>
        [JsonPropertyName("IgnoreEventAndEvict")]
        IgnoreEventAndEvict,
        /// <summary>
        /// HaveInnerContents
        /// </summary>
        [JsonPropertyName("HaveInnerContents")]
        HaveInnerContents,
        /// <summary>
        /// TimeoutPuttingInCache
        /// </summary>
        [JsonPropertyName("TimeoutPuttingInCache")]
        TimeoutPuttingInCache,
        /// <summary>
        /// BackForwardCacheDisabledByLowMemory
        /// </summary>
        [JsonPropertyName("BackForwardCacheDisabledByLowMemory")]
        BackForwardCacheDisabledByLowMemory,
        /// <summary>
        /// BackForwardCacheDisabledByCommandLine
        /// </summary>
        [JsonPropertyName("BackForwardCacheDisabledByCommandLine")]
        BackForwardCacheDisabledByCommandLine,
        /// <summary>
        /// NetworkRequestDatapipeDrainedAsBytesConsumer
        /// </summary>
        [JsonPropertyName("NetworkRequestDatapipeDrainedAsBytesConsumer")]
        NetworkRequestDatapipeDrainedAsBytesConsumer,
        /// <summary>
        /// NetworkRequestRedirected
        /// </summary>
        [JsonPropertyName("NetworkRequestRedirected")]
        NetworkRequestRedirected,
        /// <summary>
        /// NetworkRequestTimeout
        /// </summary>
        [JsonPropertyName("NetworkRequestTimeout")]
        NetworkRequestTimeout,
        /// <summary>
        /// NetworkExceedsBufferLimit
        /// </summary>
        [JsonPropertyName("NetworkExceedsBufferLimit")]
        NetworkExceedsBufferLimit,
        /// <summary>
        /// NavigationCancelledWhileRestoring
        /// </summary>
        [JsonPropertyName("NavigationCancelledWhileRestoring")]
        NavigationCancelledWhileRestoring,
        /// <summary>
        /// NotMostRecentNavigationEntry
        /// </summary>
        [JsonPropertyName("NotMostRecentNavigationEntry")]
        NotMostRecentNavigationEntry,
        /// <summary>
        /// BackForwardCacheDisabledForPrerender
        /// </summary>
        [JsonPropertyName("BackForwardCacheDisabledForPrerender")]
        BackForwardCacheDisabledForPrerender,
        /// <summary>
        /// UserAgentOverrideDiffers
        /// </summary>
        [JsonPropertyName("UserAgentOverrideDiffers")]
        UserAgentOverrideDiffers,
        /// <summary>
        /// ForegroundCacheLimit
        /// </summary>
        [JsonPropertyName("ForegroundCacheLimit")]
        ForegroundCacheLimit,
        /// <summary>
        /// BrowsingInstanceNotSwapped
        /// </summary>
        [JsonPropertyName("BrowsingInstanceNotSwapped")]
        BrowsingInstanceNotSwapped,
        /// <summary>
        /// BackForwardCacheDisabledForDelegate
        /// </summary>
        [JsonPropertyName("BackForwardCacheDisabledForDelegate")]
        BackForwardCacheDisabledForDelegate,
        /// <summary>
        /// UnloadHandlerExistsInMainFrame
        /// </summary>
        [JsonPropertyName("UnloadHandlerExistsInMainFrame")]
        UnloadHandlerExistsInMainFrame,
        /// <summary>
        /// UnloadHandlerExistsInSubFrame
        /// </summary>
        [JsonPropertyName("UnloadHandlerExistsInSubFrame")]
        UnloadHandlerExistsInSubFrame,
        /// <summary>
        /// ServiceWorkerUnregistration
        /// </summary>
        [JsonPropertyName("ServiceWorkerUnregistration")]
        ServiceWorkerUnregistration,
        /// <summary>
        /// CacheControlNoStore
        /// </summary>
        [JsonPropertyName("CacheControlNoStore")]
        CacheControlNoStore,
        /// <summary>
        /// CacheControlNoStoreCookieModified
        /// </summary>
        [JsonPropertyName("CacheControlNoStoreCookieModified")]
        CacheControlNoStoreCookieModified,
        /// <summary>
        /// CacheControlNoStoreHTTPOnlyCookieModified
        /// </summary>
        [JsonPropertyName("CacheControlNoStoreHTTPOnlyCookieModified")]
        CacheControlNoStoreHTTPOnlyCookieModified,
        /// <summary>
        /// NoResponseHead
        /// </summary>
        [JsonPropertyName("NoResponseHead")]
        NoResponseHead,
        /// <summary>
        /// Unknown
        /// </summary>
        [JsonPropertyName("Unknown")]
        Unknown,
        /// <summary>
        /// ActivationNavigationsDisallowedForBug1234857
        /// </summary>
        [JsonPropertyName("ActivationNavigationsDisallowedForBug1234857")]
        ActivationNavigationsDisallowedForBug1234857,
        /// <summary>
        /// ErrorDocument
        /// </summary>
        [JsonPropertyName("ErrorDocument")]
        ErrorDocument,
        /// <summary>
        /// FencedFramesEmbedder
        /// </summary>
        [JsonPropertyName("FencedFramesEmbedder")]
        FencedFramesEmbedder,
        /// <summary>
        /// CookieDisabled
        /// </summary>
        [JsonPropertyName("CookieDisabled")]
        CookieDisabled,
        /// <summary>
        /// HTTPAuthRequired
        /// </summary>
        [JsonPropertyName("HTTPAuthRequired")]
        HTTPAuthRequired,
        /// <summary>
        /// CookieFlushed
        /// </summary>
        [JsonPropertyName("CookieFlushed")]
        CookieFlushed,
        /// <summary>
        /// BroadcastChannelOnMessage
        /// </summary>
        [JsonPropertyName("BroadcastChannelOnMessage")]
        BroadcastChannelOnMessage,
        /// <summary>
        /// WebViewSettingsChanged
        /// </summary>
        [JsonPropertyName("WebViewSettingsChanged")]
        WebViewSettingsChanged,
        /// <summary>
        /// WebViewJavaScriptObjectChanged
        /// </summary>
        [JsonPropertyName("WebViewJavaScriptObjectChanged")]
        WebViewJavaScriptObjectChanged,
        /// <summary>
        /// WebViewMessageListenerInjected
        /// </summary>
        [JsonPropertyName("WebViewMessageListenerInjected")]
        WebViewMessageListenerInjected,
        /// <summary>
        /// WebViewSafeBrowsingAllowlistChanged
        /// </summary>
        [JsonPropertyName("WebViewSafeBrowsingAllowlistChanged")]
        WebViewSafeBrowsingAllowlistChanged,
        /// <summary>
        /// WebViewDocumentStartJavascriptChanged
        /// </summary>
        [JsonPropertyName("WebViewDocumentStartJavascriptChanged")]
        WebViewDocumentStartJavascriptChanged,
        /// <summary>
        /// WebSocket
        /// </summary>
        [JsonPropertyName("WebSocket")]
        WebSocket,
        /// <summary>
        /// WebTransport
        /// </summary>
        [JsonPropertyName("WebTransport")]
        WebTransport,
        /// <summary>
        /// WebRTC
        /// </summary>
        [JsonPropertyName("WebRTC")]
        WebRTC,
        /// <summary>
        /// MainResourceHasCacheControlNoStore
        /// </summary>
        [JsonPropertyName("MainResourceHasCacheControlNoStore")]
        MainResourceHasCacheControlNoStore,
        /// <summary>
        /// MainResourceHasCacheControlNoCache
        /// </summary>
        [JsonPropertyName("MainResourceHasCacheControlNoCache")]
        MainResourceHasCacheControlNoCache,
        /// <summary>
        /// SubresourceHasCacheControlNoStore
        /// </summary>
        [JsonPropertyName("SubresourceHasCacheControlNoStore")]
        SubresourceHasCacheControlNoStore,
        /// <summary>
        /// SubresourceHasCacheControlNoCache
        /// </summary>
        [JsonPropertyName("SubresourceHasCacheControlNoCache")]
        SubresourceHasCacheControlNoCache,
        /// <summary>
        /// ContainsPlugins
        /// </summary>
        [JsonPropertyName("ContainsPlugins")]
        ContainsPlugins,
        /// <summary>
        /// DocumentLoaded
        /// </summary>
        [JsonPropertyName("DocumentLoaded")]
        DocumentLoaded,
        /// <summary>
        /// OutstandingNetworkRequestOthers
        /// </summary>
        [JsonPropertyName("OutstandingNetworkRequestOthers")]
        OutstandingNetworkRequestOthers,
        /// <summary>
        /// RequestedMIDIPermission
        /// </summary>
        [JsonPropertyName("RequestedMIDIPermission")]
        RequestedMIDIPermission,
        /// <summary>
        /// RequestedAudioCapturePermission
        /// </summary>
        [JsonPropertyName("RequestedAudioCapturePermission")]
        RequestedAudioCapturePermission,
        /// <summary>
        /// RequestedVideoCapturePermission
        /// </summary>
        [JsonPropertyName("RequestedVideoCapturePermission")]
        RequestedVideoCapturePermission,
        /// <summary>
        /// RequestedBackForwardCacheBlockedSensors
        /// </summary>
        [JsonPropertyName("RequestedBackForwardCacheBlockedSensors")]
        RequestedBackForwardCacheBlockedSensors,
        /// <summary>
        /// RequestedBackgroundWorkPermission
        /// </summary>
        [JsonPropertyName("RequestedBackgroundWorkPermission")]
        RequestedBackgroundWorkPermission,
        /// <summary>
        /// BroadcastChannel
        /// </summary>
        [JsonPropertyName("BroadcastChannel")]
        BroadcastChannel,
        /// <summary>
        /// WebXR
        /// </summary>
        [JsonPropertyName("WebXR")]
        WebXR,
        /// <summary>
        /// SharedWorker
        /// </summary>
        [JsonPropertyName("SharedWorker")]
        SharedWorker,
        /// <summary>
        /// WebLocks
        /// </summary>
        [JsonPropertyName("WebLocks")]
        WebLocks,
        /// <summary>
        /// WebHID
        /// </summary>
        [JsonPropertyName("WebHID")]
        WebHID,
        /// <summary>
        /// WebShare
        /// </summary>
        [JsonPropertyName("WebShare")]
        WebShare,
        /// <summary>
        /// RequestedStorageAccessGrant
        /// </summary>
        [JsonPropertyName("RequestedStorageAccessGrant")]
        RequestedStorageAccessGrant,
        /// <summary>
        /// WebNfc
        /// </summary>
        [JsonPropertyName("WebNfc")]
        WebNfc,
        /// <summary>
        /// OutstandingNetworkRequestFetch
        /// </summary>
        [JsonPropertyName("OutstandingNetworkRequestFetch")]
        OutstandingNetworkRequestFetch,
        /// <summary>
        /// OutstandingNetworkRequestXHR
        /// </summary>
        [JsonPropertyName("OutstandingNetworkRequestXHR")]
        OutstandingNetworkRequestXHR,
        /// <summary>
        /// AppBanner
        /// </summary>
        [JsonPropertyName("AppBanner")]
        AppBanner,
        /// <summary>
        /// Printing
        /// </summary>
        [JsonPropertyName("Printing")]
        Printing,
        /// <summary>
        /// WebDatabase
        /// </summary>
        [JsonPropertyName("WebDatabase")]
        WebDatabase,
        /// <summary>
        /// PictureInPicture
        /// </summary>
        [JsonPropertyName("PictureInPicture")]
        PictureInPicture,
        /// <summary>
        /// SpeechRecognizer
        /// </summary>
        [JsonPropertyName("SpeechRecognizer")]
        SpeechRecognizer,
        /// <summary>
        /// IdleManager
        /// </summary>
        [JsonPropertyName("IdleManager")]
        IdleManager,
        /// <summary>
        /// PaymentManager
        /// </summary>
        [JsonPropertyName("PaymentManager")]
        PaymentManager,
        /// <summary>
        /// SpeechSynthesis
        /// </summary>
        [JsonPropertyName("SpeechSynthesis")]
        SpeechSynthesis,
        /// <summary>
        /// KeyboardLock
        /// </summary>
        [JsonPropertyName("KeyboardLock")]
        KeyboardLock,
        /// <summary>
        /// WebOTPService
        /// </summary>
        [JsonPropertyName("WebOTPService")]
        WebOTPService,
        /// <summary>
        /// OutstandingNetworkRequestDirectSocket
        /// </summary>
        [JsonPropertyName("OutstandingNetworkRequestDirectSocket")]
        OutstandingNetworkRequestDirectSocket,
        /// <summary>
        /// InjectedJavascript
        /// </summary>
        [JsonPropertyName("InjectedJavascript")]
        InjectedJavascript,
        /// <summary>
        /// InjectedStyleSheet
        /// </summary>
        [JsonPropertyName("InjectedStyleSheet")]
        InjectedStyleSheet,
        /// <summary>
        /// KeepaliveRequest
        /// </summary>
        [JsonPropertyName("KeepaliveRequest")]
        KeepaliveRequest,
        /// <summary>
        /// IndexedDBEvent
        /// </summary>
        [JsonPropertyName("IndexedDBEvent")]
        IndexedDBEvent,
        /// <summary>
        /// Dummy
        /// </summary>
        [JsonPropertyName("Dummy")]
        Dummy,
        /// <summary>
        /// JsNetworkRequestReceivedCacheControlNoStoreResource
        /// </summary>
        [JsonPropertyName("JsNetworkRequestReceivedCacheControlNoStoreResource")]
        JsNetworkRequestReceivedCacheControlNoStoreResource,
        /// <summary>
        /// WebRTCSticky
        /// </summary>
        [JsonPropertyName("WebRTCSticky")]
        WebRTCSticky,
        /// <summary>
        /// WebTransportSticky
        /// </summary>
        [JsonPropertyName("WebTransportSticky")]
        WebTransportSticky,
        /// <summary>
        /// WebSocketSticky
        /// </summary>
        [JsonPropertyName("WebSocketSticky")]
        WebSocketSticky,
        /// <summary>
        /// SmartCard
        /// </summary>
        [JsonPropertyName("SmartCard")]
        SmartCard,
        /// <summary>
        /// LiveMediaStreamTrack
        /// </summary>
        [JsonPropertyName("LiveMediaStreamTrack")]
        LiveMediaStreamTrack,
        /// <summary>
        /// UnloadHandler
        /// </summary>
        [JsonPropertyName("UnloadHandler")]
        UnloadHandler,
        /// <summary>
        /// ParserAborted
        /// </summary>
        [JsonPropertyName("ParserAborted")]
        ParserAborted,
        /// <summary>
        /// ContentSecurityHandler
        /// </summary>
        [JsonPropertyName("ContentSecurityHandler")]
        ContentSecurityHandler,
        /// <summary>
        /// ContentWebAuthenticationAPI
        /// </summary>
        [JsonPropertyName("ContentWebAuthenticationAPI")]
        ContentWebAuthenticationAPI,
        /// <summary>
        /// ContentFileChooser
        /// </summary>
        [JsonPropertyName("ContentFileChooser")]
        ContentFileChooser,
        /// <summary>
        /// ContentSerial
        /// </summary>
        [JsonPropertyName("ContentSerial")]
        ContentSerial,
        /// <summary>
        /// ContentFileSystemAccess
        /// </summary>
        [JsonPropertyName("ContentFileSystemAccess")]
        ContentFileSystemAccess,
        /// <summary>
        /// ContentMediaDevicesDispatcherHost
        /// </summary>
        [JsonPropertyName("ContentMediaDevicesDispatcherHost")]
        ContentMediaDevicesDispatcherHost,
        /// <summary>
        /// ContentWebBluetooth
        /// </summary>
        [JsonPropertyName("ContentWebBluetooth")]
        ContentWebBluetooth,
        /// <summary>
        /// ContentWebUSB
        /// </summary>
        [JsonPropertyName("ContentWebUSB")]
        ContentWebUSB,
        /// <summary>
        /// ContentMediaSessionService
        /// </summary>
        [JsonPropertyName("ContentMediaSessionService")]
        ContentMediaSessionService,
        /// <summary>
        /// ContentScreenReader
        /// </summary>
        [JsonPropertyName("ContentScreenReader")]
        ContentScreenReader,
        /// <summary>
        /// EmbedderPopupBlockerTabHelper
        /// </summary>
        [JsonPropertyName("EmbedderPopupBlockerTabHelper")]
        EmbedderPopupBlockerTabHelper,
        /// <summary>
        /// EmbedderSafeBrowsingTriggeredPopupBlocker
        /// </summary>
        [JsonPropertyName("EmbedderSafeBrowsingTriggeredPopupBlocker")]
        EmbedderSafeBrowsingTriggeredPopupBlocker,
        /// <summary>
        /// EmbedderSafeBrowsingThreatDetails
        /// </summary>
        [JsonPropertyName("EmbedderSafeBrowsingThreatDetails")]
        EmbedderSafeBrowsingThreatDetails,
        /// <summary>
        /// EmbedderAppBannerManager
        /// </summary>
        [JsonPropertyName("EmbedderAppBannerManager")]
        EmbedderAppBannerManager,
        /// <summary>
        /// EmbedderDomDistillerViewerSource
        /// </summary>
        [JsonPropertyName("EmbedderDomDistillerViewerSource")]
        EmbedderDomDistillerViewerSource,
        /// <summary>
        /// EmbedderDomDistillerSelfDeletingRequestDelegate
        /// </summary>
        [JsonPropertyName("EmbedderDomDistillerSelfDeletingRequestDelegate")]
        EmbedderDomDistillerSelfDeletingRequestDelegate,
        /// <summary>
        /// EmbedderOomInterventionTabHelper
        /// </summary>
        [JsonPropertyName("EmbedderOomInterventionTabHelper")]
        EmbedderOomInterventionTabHelper,
        /// <summary>
        /// EmbedderOfflinePage
        /// </summary>
        [JsonPropertyName("EmbedderOfflinePage")]
        EmbedderOfflinePage,
        /// <summary>
        /// EmbedderChromePasswordManagerClientBindCredentialManager
        /// </summary>
        [JsonPropertyName("EmbedderChromePasswordManagerClientBindCredentialManager")]
        EmbedderChromePasswordManagerClientBindCredentialManager,
        /// <summary>
        /// EmbedderPermissionRequestManager
        /// </summary>
        [JsonPropertyName("EmbedderPermissionRequestManager")]
        EmbedderPermissionRequestManager,
        /// <summary>
        /// EmbedderModalDialog
        /// </summary>
        [JsonPropertyName("EmbedderModalDialog")]
        EmbedderModalDialog,
        /// <summary>
        /// EmbedderExtensions
        /// </summary>
        [JsonPropertyName("EmbedderExtensions")]
        EmbedderExtensions,
        /// <summary>
        /// EmbedderExtensionMessaging
        /// </summary>
        [JsonPropertyName("EmbedderExtensionMessaging")]
        EmbedderExtensionMessaging,
        /// <summary>
        /// EmbedderExtensionMessagingForOpenPort
        /// </summary>
        [JsonPropertyName("EmbedderExtensionMessagingForOpenPort")]
        EmbedderExtensionMessagingForOpenPort,
        /// <summary>
        /// EmbedderExtensionSentMessageToCachedFrame
        /// </summary>
        [JsonPropertyName("EmbedderExtensionSentMessageToCachedFrame")]
        EmbedderExtensionSentMessageToCachedFrame,
        /// <summary>
        /// RequestedByWebViewClient
        /// </summary>
        [JsonPropertyName("RequestedByWebViewClient")]
        RequestedByWebViewClient
    }

    /// <summary>
    /// Types of not restored reasons for back-forward cache.
    /// </summary>
    public enum BackForwardCacheNotRestoredReasonType
    {
        /// <summary>
        /// SupportPending
        /// </summary>
        [JsonPropertyName("SupportPending")]
        SupportPending,
        /// <summary>
        /// PageSupportNeeded
        /// </summary>
        [JsonPropertyName("PageSupportNeeded")]
        PageSupportNeeded,
        /// <summary>
        /// Circumstantial
        /// </summary>
        [JsonPropertyName("Circumstantial")]
        Circumstantial
    }

    /// <summary>
    /// BackForwardCacheBlockingDetails
    /// </summary>
    public partial class BackForwardCacheBlockingDetails : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Url of the file where blockage happened. Optional because of tests.
        /// </summary>
        [JsonPropertyName("url")]
        public string Url
        {
            get;
            set;
        }

        /// <summary>
        /// Function name where blockage happened. Optional because of anonymous functions and tests.
        /// </summary>
        [JsonPropertyName("function")]
        public string Function
        {
            get;
            set;
        }

        /// <summary>
        /// Line number in the script (0-based).
        /// </summary>
        [JsonPropertyName("lineNumber")]
        public int LineNumber
        {
            get;
            set;
        }

        /// <summary>
        /// Column number in the script (0-based).
        /// </summary>
        [JsonPropertyName("columnNumber")]
        public int ColumnNumber
        {
            get;
            set;
        }
    }

    /// <summary>
    /// BackForwardCacheNotRestoredExplanation
    /// </summary>
    public partial class BackForwardCacheNotRestoredExplanation : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Type of the reason
        /// </summary>
        [JsonPropertyName("type")]
        public CefSharp.DevTools.Page.BackForwardCacheNotRestoredReasonType Type
        {
            get;
            set;
        }

        /// <summary>
        /// Not restored reason
        /// </summary>
        [JsonPropertyName("reason")]
        public CefSharp.DevTools.Page.BackForwardCacheNotRestoredReason Reason
        {
            get;
            set;
        }

        /// <summary>
        /// Context associated with the reason. The meaning of this context is
        /// dependent on the reason:
        /// - EmbedderExtensionSentMessageToCachedFrame: the extension ID.
        /// </summary>
        [JsonPropertyName("context")]
        public string Context
        {
            get;
            set;
        }

        /// <summary>
        /// Details
        /// </summary>
        [JsonPropertyName("details")]
        public System.Collections.Generic.IList<CefSharp.DevTools.Page.BackForwardCacheBlockingDetails> Details
        {
            get;
            set;
        }
    }

    /// <summary>
    /// BackForwardCacheNotRestoredExplanationTree
    /// </summary>
    public partial class BackForwardCacheNotRestoredExplanationTree : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// URL of each frame
        /// </summary>
        [JsonPropertyName("url")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Url
        {
            get;
            set;
        }

        /// <summary>
        /// Not restored reasons of each frame
        /// </summary>
        [JsonPropertyName("explanations")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public System.Collections.Generic.IList<CefSharp.DevTools.Page.BackForwardCacheNotRestoredExplanation> Explanations
        {
            get;
            set;
        }

        /// <summary>
        /// Array of children frame
        /// </summary>
        [JsonPropertyName("children")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public System.Collections.Generic.IList<CefSharp.DevTools.Page.BackForwardCacheNotRestoredExplanationTree> Children
        {
            get;
            set;
        }
    }

    /// <summary>
    /// domContentEventFired
    /// </summary>
    public class DomContentEventFiredEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Timestamp
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("timestamp")]
        public double Timestamp
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Input mode.
    /// </summary>
    public enum FileChooserOpenedMode
    {
        /// <summary>
        /// selectSingle
        /// </summary>
        [JsonPropertyName("selectSingle")]
        SelectSingle,
        /// <summary>
        /// selectMultiple
        /// </summary>
        [JsonPropertyName("selectMultiple")]
        SelectMultiple
    }

    /// <summary>
    /// Emitted only when `page.interceptFileChooser` is enabled.
    /// </summary>
    public class FileChooserOpenedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Id of the frame containing input node.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("frameId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string FrameId
        {
            get;
            private set;
        }

        /// <summary>
        /// Input mode.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("mode")]
        public CefSharp.DevTools.Page.FileChooserOpenedMode Mode
        {
            get;
            private set;
        }

        /// <summary>
        /// Input node id. Only present for file choosers opened via an `&lt;input type=&quot;file&quot; &gt;` element.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("backendNodeId")]
        public int? BackendNodeId
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired when frame has been attached to its parent.
    /// </summary>
    public class FrameAttachedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Id of the frame that has been attached.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("frameId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string FrameId
        {
            get;
            private set;
        }

        /// <summary>
        /// Parent frame identifier.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("parentFrameId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string ParentFrameId
        {
            get;
            private set;
        }

        /// <summary>
        /// JavaScript stack trace of when frame was attached, only set if frame initiated from script.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("stack")]
        public CefSharp.DevTools.Runtime.StackTrace Stack
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired when frame no longer has a scheduled navigation.
    /// </summary>
    public class FrameClearedScheduledNavigationEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Id of the frame that has cleared its scheduled navigation.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("frameId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string FrameId
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// FrameDetachedReason
    /// </summary>
    public enum FrameDetachedReason
    {
        /// <summary>
        /// remove
        /// </summary>
        [JsonPropertyName("remove")]
        Remove,
        /// <summary>
        /// swap
        /// </summary>
        [JsonPropertyName("swap")]
        Swap
    }

    /// <summary>
    /// Fired when frame has been detached from its parent.
    /// </summary>
    public class FrameDetachedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Id of the frame that has been detached.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("frameId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string FrameId
        {
            get;
            private set;
        }

        /// <summary>
        /// Reason
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("reason")]
        public CefSharp.DevTools.Page.FrameDetachedReason Reason
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired once navigation of the frame has completed. Frame is now associated with the new loader.
    /// </summary>
    public class FrameNavigatedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Frame object.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("frame")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.Page.Frame Frame
        {
            get;
            private set;
        }

        /// <summary>
        /// Type
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("type")]
        public CefSharp.DevTools.Page.NavigationType Type
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired when opening document to write to.
    /// </summary>
    public class DocumentOpenedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Frame object.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("frame")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.Page.Frame Frame
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired when a renderer-initiated navigation is requested.
    /// Navigation may still be cancelled after the event is issued.
    /// </summary>
    public class FrameRequestedNavigationEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Id of the frame that is being navigated.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("frameId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string FrameId
        {
            get;
            private set;
        }

        /// <summary>
        /// The reason for the navigation.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("reason")]
        public CefSharp.DevTools.Page.ClientNavigationReason Reason
        {
            get;
            private set;
        }

        /// <summary>
        /// The destination URL for the requested navigation.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("url")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Url
        {
            get;
            private set;
        }

        /// <summary>
        /// The disposition for the navigation.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("disposition")]
        public CefSharp.DevTools.Page.ClientNavigationDisposition Disposition
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired when frame schedules a potential navigation.
    /// </summary>
    public class FrameScheduledNavigationEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Id of the frame that has scheduled a navigation.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("frameId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string FrameId
        {
            get;
            private set;
        }

        /// <summary>
        /// Delay (in seconds) until the navigation is scheduled to begin. The navigation is not
        /// guaranteed to start.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("delay")]
        public double Delay
        {
            get;
            private set;
        }

        /// <summary>
        /// The reason for the navigation.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("reason")]
        public CefSharp.DevTools.Page.ClientNavigationReason Reason
        {
            get;
            private set;
        }

        /// <summary>
        /// The destination URL for the scheduled navigation.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("url")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Url
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired when frame has started loading.
    /// </summary>
    public class FrameStartedLoadingEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Id of the frame that has started loading.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("frameId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string FrameId
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired when frame has stopped loading.
    /// </summary>
    public class FrameStoppedLoadingEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Id of the frame that has stopped loading.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("frameId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string FrameId
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired when page is about to start a download.
    /// Deprecated. Use Browser.downloadWillBegin instead.
    /// </summary>
    public class DownloadWillBeginEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Id of the frame that caused download to begin.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("frameId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string FrameId
        {
            get;
            private set;
        }

        /// <summary>
        /// Global unique identifier of the download.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("guid")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Guid
        {
            get;
            private set;
        }

        /// <summary>
        /// URL of the resource being downloaded.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("url")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Url
        {
            get;
            private set;
        }

        /// <summary>
        /// Suggested file name of the resource (the actual name of the file saved on disk may differ).
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("suggestedFilename")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string SuggestedFilename
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Download status.
    /// </summary>
    public enum DownloadProgressState
    {
        /// <summary>
        /// inProgress
        /// </summary>
        [JsonPropertyName("inProgress")]
        InProgress,
        /// <summary>
        /// completed
        /// </summary>
        [JsonPropertyName("completed")]
        Completed,
        /// <summary>
        /// canceled
        /// </summary>
        [JsonPropertyName("canceled")]
        Canceled
    }

    /// <summary>
    /// Fired when download makes progress. Last call has |done| == true.
    /// Deprecated. Use Browser.downloadProgress instead.
    /// </summary>
    public class DownloadProgressEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Global unique identifier of the download.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("guid")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Guid
        {
            get;
            private set;
        }

        /// <summary>
        /// Total expected bytes to download.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("totalBytes")]
        public double TotalBytes
        {
            get;
            private set;
        }

        /// <summary>
        /// Total bytes received.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("receivedBytes")]
        public double ReceivedBytes
        {
            get;
            private set;
        }

        /// <summary>
        /// Download status.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("state")]
        public CefSharp.DevTools.Page.DownloadProgressState State
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired when a JavaScript initiated dialog (alert, confirm, prompt, or onbeforeunload) has been
    /// closed.
    /// </summary>
    public class JavascriptDialogClosedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Whether dialog was confirmed.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("result")]
        public bool Result
        {
            get;
            private set;
        }

        /// <summary>
        /// User input in case of prompt.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("userInput")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string UserInput
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired when a JavaScript initiated dialog (alert, confirm, prompt, or onbeforeunload) is about to
    /// open.
    /// </summary>
    public class JavascriptDialogOpeningEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Frame url.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("url")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Url
        {
            get;
            private set;
        }

        /// <summary>
        /// Message that will be displayed by the dialog.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("message")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Message
        {
            get;
            private set;
        }

        /// <summary>
        /// Dialog type.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("type")]
        public CefSharp.DevTools.Page.DialogType Type
        {
            get;
            private set;
        }

        /// <summary>
        /// True iff browser is capable showing or acting on the given dialog. When browser has no
        /// dialog handler for given target, calling alert while Page domain is engaged will stall
        /// the page execution. Execution can be resumed via calling Page.handleJavaScriptDialog.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("hasBrowserHandler")]
        public bool HasBrowserHandler
        {
            get;
            private set;
        }

        /// <summary>
        /// Default dialog prompt.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("defaultPrompt")]
        public string DefaultPrompt
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired for top level page lifecycle events such as navigation, load, paint, etc.
    /// </summary>
    public class LifecycleEventEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Id of the frame.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("frameId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string FrameId
        {
            get;
            private set;
        }

        /// <summary>
        /// Loader identifier. Empty string if the request is fetched from worker.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("loaderId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string LoaderId
        {
            get;
            private set;
        }

        /// <summary>
        /// Name
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("name")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Name
        {
            get;
            private set;
        }

        /// <summary>
        /// Timestamp
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("timestamp")]
        public double Timestamp
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired for failed bfcache history navigations if BackForwardCache feature is enabled. Do
    /// not assume any ordering with the Page.frameNavigated event. This event is fired only for
    /// main-frame history navigation where the document changes (non-same-document navigations),
    /// when bfcache navigation fails.
    /// </summary>
    public class BackForwardCacheNotUsedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// The loader id for the associated navigation.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("loaderId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string LoaderId
        {
            get;
            private set;
        }

        /// <summary>
        /// The frame id of the associated frame.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("frameId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string FrameId
        {
            get;
            private set;
        }

        /// <summary>
        /// Array of reasons why the page could not be cached. This must not be empty.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("notRestoredExplanations")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public System.Collections.Generic.IList<CefSharp.DevTools.Page.BackForwardCacheNotRestoredExplanation> NotRestoredExplanations
        {
            get;
            private set;
        }

        /// <summary>
        /// Tree structure of reasons why the page could not be cached for each frame.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("notRestoredExplanationsTree")]
        public CefSharp.DevTools.Page.BackForwardCacheNotRestoredExplanationTree NotRestoredExplanationsTree
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// loadEventFired
    /// </summary>
    public class LoadEventFiredEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Timestamp
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("timestamp")]
        public double Timestamp
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Navigation type
    /// </summary>
    public enum NavigatedWithinDocumentNavigationType
    {
        /// <summary>
        /// fragment
        /// </summary>
        [JsonPropertyName("fragment")]
        Fragment,
        /// <summary>
        /// historyApi
        /// </summary>
        [JsonPropertyName("historyApi")]
        HistoryApi,
        /// <summary>
        /// other
        /// </summary>
        [JsonPropertyName("other")]
        Other
    }

    /// <summary>
    /// Fired when same-document navigation happens, e.g. due to history API usage or anchor navigation.
    /// </summary>
    public class NavigatedWithinDocumentEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Id of the frame.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("frameId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string FrameId
        {
            get;
            private set;
        }

        /// <summary>
        /// Frame&apos;s new url.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("url")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Url
        {
            get;
            private set;
        }

        /// <summary>
        /// Navigation type
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("navigationType")]
        public CefSharp.DevTools.Page.NavigatedWithinDocumentNavigationType NavigationType
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Compressed image data requested by the `startScreencast`.
    /// </summary>
    public class ScreencastFrameEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Base64-encoded compressed image.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("data")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public byte[] Data
        {
            get;
            private set;
        }

        /// <summary>
        /// Screencast frame metadata.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("metadata")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.Page.ScreencastFrameMetadata Metadata
        {
            get;
            private set;
        }

        /// <summary>
        /// Frame number.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("sessionId")]
        public int SessionId
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired when the page with currently enabled screencast was shown or hidden `.
    /// </summary>
    public class ScreencastVisibilityChangedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// True if the page is visible.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("visible")]
        public bool Visible
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired when a new window is going to be opened, via window.open(), link click, form submission,
    /// etc.
    /// </summary>
    public class WindowOpenEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// The URL for the new window.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("url")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Url
        {
            get;
            private set;
        }

        /// <summary>
        /// Window name.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("windowName")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string WindowName
        {
            get;
            private set;
        }

        /// <summary>
        /// An array of enabled window features.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("windowFeatures")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string[] WindowFeatures
        {
            get;
            private set;
        }

        /// <summary>
        /// Whether or not it was triggered by user gesture.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("userGesture")]
        public bool UserGesture
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Issued for every compilation cache generated. Is only available
    /// if Page.setGenerateCompilationCache is enabled.
    /// </summary>
    public class CompilationCacheProducedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Url
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("url")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Url
        {
            get;
            private set;
        }

        /// <summary>
        /// Base64-encoded data
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("data")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public byte[] Data
        {
            get;
            private set;
        }
    }
}

namespace CefSharp.DevTools.Performance
{
    /// <summary>
    /// Run-time execution metric.
    /// </summary>
    public partial class Metric : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Metric name.
        /// </summary>
        [JsonPropertyName("name")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Name
        {
            get;
            set;
        }

        /// <summary>
        /// Metric value.
        /// </summary>
        [JsonPropertyName("value")]
        public double Value
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Current values of the metrics.
    /// </summary>
    public class MetricsEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Current values of the metrics.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("metrics")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public System.Collections.Generic.IList<CefSharp.DevTools.Performance.Metric> Metrics
        {
            get;
            private set;
        }

        /// <summary>
        /// Timestamp title.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("title")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Title
        {
            get;
            private set;
        }
    }
}

namespace CefSharp.DevTools.PerformanceTimeline
{
    /// <summary>
    /// See https://github.com/WICG/LargestContentfulPaint and largest_contentful_paint.idl
    /// </summary>
    public partial class LargestContentfulPaint : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// RenderTime
        /// </summary>
        [JsonPropertyName("renderTime")]
        public double RenderTime
        {
            get;
            set;
        }

        /// <summary>
        /// LoadTime
        /// </summary>
        [JsonPropertyName("loadTime")]
        public double LoadTime
        {
            get;
            set;
        }

        /// <summary>
        /// The number of pixels being painted.
        /// </summary>
        [JsonPropertyName("size")]
        public double Size
        {
            get;
            set;
        }

        /// <summary>
        /// The id attribute of the element, if available.
        /// </summary>
        [JsonPropertyName("elementId")]
        public string ElementId
        {
            get;
            set;
        }

        /// <summary>
        /// The URL of the image (may be trimmed).
        /// </summary>
        [JsonPropertyName("url")]
        public string Url
        {
            get;
            set;
        }

        /// <summary>
        /// NodeId
        /// </summary>
        [JsonPropertyName("nodeId")]
        public int? NodeId
        {
            get;
            set;
        }
    }

    /// <summary>
    /// LayoutShiftAttribution
    /// </summary>
    public partial class LayoutShiftAttribution : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// PreviousRect
        /// </summary>
        [JsonPropertyName("previousRect")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.DOM.Rect PreviousRect
        {
            get;
            set;
        }

        /// <summary>
        /// CurrentRect
        /// </summary>
        [JsonPropertyName("currentRect")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.DOM.Rect CurrentRect
        {
            get;
            set;
        }

        /// <summary>
        /// NodeId
        /// </summary>
        [JsonPropertyName("nodeId")]
        public int? NodeId
        {
            get;
            set;
        }
    }

    /// <summary>
    /// See https://wicg.github.io/layout-instability/#sec-layout-shift and layout_shift.idl
    /// </summary>
    public partial class LayoutShift : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Score increment produced by this event.
        /// </summary>
        [JsonPropertyName("value")]
        public double Value
        {
            get;
            set;
        }

        /// <summary>
        /// HadRecentInput
        /// </summary>
        [JsonPropertyName("hadRecentInput")]
        public bool HadRecentInput
        {
            get;
            set;
        }

        /// <summary>
        /// LastInputTime
        /// </summary>
        [JsonPropertyName("lastInputTime")]
        public double LastInputTime
        {
            get;
            set;
        }

        /// <summary>
        /// Sources
        /// </summary>
        [JsonPropertyName("sources")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public System.Collections.Generic.IList<CefSharp.DevTools.PerformanceTimeline.LayoutShiftAttribution> Sources
        {
            get;
            set;
        }
    }

    /// <summary>
    /// TimelineEvent
    /// </summary>
    public partial class TimelineEvent : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Identifies the frame that this event is related to. Empty for non-frame targets.
        /// </summary>
        [JsonPropertyName("frameId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string FrameId
        {
            get;
            set;
        }

        /// <summary>
        /// The event type, as specified in https://w3c.github.io/performance-timeline/#dom-performanceentry-entrytype
        /// This determines which of the optional &quot;details&quot; fields is present.
        /// </summary>
        [JsonPropertyName("type")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Type
        {
            get;
            set;
        }

        /// <summary>
        /// Name may be empty depending on the type.
        /// </summary>
        [JsonPropertyName("name")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Name
        {
            get;
            set;
        }

        /// <summary>
        /// Time in seconds since Epoch, monotonically increasing within document lifetime.
        /// </summary>
        [JsonPropertyName("time")]
        public double Time
        {
            get;
            set;
        }

        /// <summary>
        /// Event duration, if applicable.
        /// </summary>
        [JsonPropertyName("duration")]
        public double? Duration
        {
            get;
            set;
        }

        /// <summary>
        /// LcpDetails
        /// </summary>
        [JsonPropertyName("lcpDetails")]
        public CefSharp.DevTools.PerformanceTimeline.LargestContentfulPaint LcpDetails
        {
            get;
            set;
        }

        /// <summary>
        /// LayoutShiftDetails
        /// </summary>
        [JsonPropertyName("layoutShiftDetails")]
        public CefSharp.DevTools.PerformanceTimeline.LayoutShift LayoutShiftDetails
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Sent when a performance timeline event is added. See reportPerformanceTimeline method.
    /// </summary>
    public class TimelineEventAddedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Event
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("event")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.PerformanceTimeline.TimelineEvent Event
        {
            get;
            private set;
        }
    }
}

namespace CefSharp.DevTools.Security
{
    /// <summary>
    /// A description of mixed content (HTTP resources on HTTPS pages), as defined by
    /// https://www.w3.org/TR/mixed-content/#categories
    /// </summary>
    public enum MixedContentType
    {
        /// <summary>
        /// blockable
        /// </summary>
        [JsonPropertyName("blockable")]
        Blockable,
        /// <summary>
        /// optionally-blockable
        /// </summary>
        [JsonPropertyName("optionally-blockable")]
        OptionallyBlockable,
        /// <summary>
        /// none
        /// </summary>
        [JsonPropertyName("none")]
        None
    }

    /// <summary>
    /// The security level of a page or resource.
    /// </summary>
    public enum SecurityState
    {
        /// <summary>
        /// unknown
        /// </summary>
        [JsonPropertyName("unknown")]
        Unknown,
        /// <summary>
        /// neutral
        /// </summary>
        [JsonPropertyName("neutral")]
        Neutral,
        /// <summary>
        /// insecure
        /// </summary>
        [JsonPropertyName("insecure")]
        Insecure,
        /// <summary>
        /// secure
        /// </summary>
        [JsonPropertyName("secure")]
        Secure,
        /// <summary>
        /// info
        /// </summary>
        [JsonPropertyName("info")]
        Info,
        /// <summary>
        /// insecure-broken
        /// </summary>
        [JsonPropertyName("insecure-broken")]
        InsecureBroken
    }

    /// <summary>
    /// Details about the security state of the page certificate.
    /// </summary>
    public partial class CertificateSecurityState : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Protocol name (e.g. &quot;TLS 1.2&quot; or &quot;QUIC&quot;).
        /// </summary>
        [JsonPropertyName("protocol")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Protocol
        {
            get;
            set;
        }

        /// <summary>
        /// Key Exchange used by the connection, or the empty string if not applicable.
        /// </summary>
        [JsonPropertyName("keyExchange")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string KeyExchange
        {
            get;
            set;
        }

        /// <summary>
        /// (EC)DH group used by the connection, if applicable.
        /// </summary>
        [JsonPropertyName("keyExchangeGroup")]
        public string KeyExchangeGroup
        {
            get;
            set;
        }

        /// <summary>
        /// Cipher name.
        /// </summary>
        [JsonPropertyName("cipher")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Cipher
        {
            get;
            set;
        }

        /// <summary>
        /// TLS MAC. Note that AEAD ciphers do not have separate MACs.
        /// </summary>
        [JsonPropertyName("mac")]
        public string Mac
        {
            get;
            set;
        }

        /// <summary>
        /// Page certificate.
        /// </summary>
        [JsonPropertyName("certificate")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string[] Certificate
        {
            get;
            set;
        }

        /// <summary>
        /// Certificate subject name.
        /// </summary>
        [JsonPropertyName("subjectName")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string SubjectName
        {
            get;
            set;
        }

        /// <summary>
        /// Name of the issuing CA.
        /// </summary>
        [JsonPropertyName("issuer")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Issuer
        {
            get;
            set;
        }

        /// <summary>
        /// Certificate valid from date.
        /// </summary>
        [JsonPropertyName("validFrom")]
        public double ValidFrom
        {
            get;
            set;
        }

        /// <summary>
        /// Certificate valid to (expiration) date
        /// </summary>
        [JsonPropertyName("validTo")]
        public double ValidTo
        {
            get;
            set;
        }

        /// <summary>
        /// The highest priority network error code, if the certificate has an error.
        /// </summary>
        [JsonPropertyName("certificateNetworkError")]
        public string CertificateNetworkError
        {
            get;
            set;
        }

        /// <summary>
        /// True if the certificate uses a weak signature algorithm.
        /// </summary>
        [JsonPropertyName("certificateHasWeakSignature")]
        public bool CertificateHasWeakSignature
        {
            get;
            set;
        }

        /// <summary>
        /// True if the certificate has a SHA1 signature in the chain.
        /// </summary>
        [JsonPropertyName("certificateHasSha1Signature")]
        public bool CertificateHasSha1Signature
        {
            get;
            set;
        }

        /// <summary>
        /// True if modern SSL
        /// </summary>
        [JsonPropertyName("modernSSL")]
        public bool ModernSSL
        {
            get;
            set;
        }

        /// <summary>
        /// True if the connection is using an obsolete SSL protocol.
        /// </summary>
        [JsonPropertyName("obsoleteSslProtocol")]
        public bool ObsoleteSslProtocol
        {
            get;
            set;
        }

        /// <summary>
        /// True if the connection is using an obsolete SSL key exchange.
        /// </summary>
        [JsonPropertyName("obsoleteSslKeyExchange")]
        public bool ObsoleteSslKeyExchange
        {
            get;
            set;
        }

        /// <summary>
        /// True if the connection is using an obsolete SSL cipher.
        /// </summary>
        [JsonPropertyName("obsoleteSslCipher")]
        public bool ObsoleteSslCipher
        {
            get;
            set;
        }

        /// <summary>
        /// True if the connection is using an obsolete SSL signature.
        /// </summary>
        [JsonPropertyName("obsoleteSslSignature")]
        public bool ObsoleteSslSignature
        {
            get;
            set;
        }
    }

    /// <summary>
    /// SafetyTipStatus
    /// </summary>
    public enum SafetyTipStatus
    {
        /// <summary>
        /// badReputation
        /// </summary>
        [JsonPropertyName("badReputation")]
        BadReputation,
        /// <summary>
        /// lookalike
        /// </summary>
        [JsonPropertyName("lookalike")]
        Lookalike
    }

    /// <summary>
    /// SafetyTipInfo
    /// </summary>
    public partial class SafetyTipInfo : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Describes whether the page triggers any safety tips or reputation warnings. Default is unknown.
        /// </summary>
        [JsonPropertyName("safetyTipStatus")]
        public CefSharp.DevTools.Security.SafetyTipStatus SafetyTipStatus
        {
            get;
            set;
        }

        /// <summary>
        /// The URL the safety tip suggested (&quot;Did you mean?&quot;). Only filled in for lookalike matches.
        /// </summary>
        [JsonPropertyName("safeUrl")]
        public string SafeUrl
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Security state information about the page.
    /// </summary>
    public partial class VisibleSecurityState : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The security level of the page.
        /// </summary>
        [JsonPropertyName("securityState")]
        public CefSharp.DevTools.Security.SecurityState SecurityState
        {
            get;
            set;
        }

        /// <summary>
        /// Security state details about the page certificate.
        /// </summary>
        [JsonPropertyName("certificateSecurityState")]
        public CefSharp.DevTools.Security.CertificateSecurityState CertificateSecurityState
        {
            get;
            set;
        }

        /// <summary>
        /// The type of Safety Tip triggered on the page. Note that this field will be set even if the Safety Tip UI was not actually shown.
        /// </summary>
        [JsonPropertyName("safetyTipInfo")]
        public CefSharp.DevTools.Security.SafetyTipInfo SafetyTipInfo
        {
            get;
            set;
        }

        /// <summary>
        /// Array of security state issues ids.
        /// </summary>
        [JsonPropertyName("securityStateIssueIds")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string[] SecurityStateIssueIds
        {
            get;
            set;
        }
    }

    /// <summary>
    /// An explanation of an factor contributing to the security state.
    /// </summary>
    public partial class SecurityStateExplanation : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Security state representing the severity of the factor being explained.
        /// </summary>
        [JsonPropertyName("securityState")]
        public CefSharp.DevTools.Security.SecurityState SecurityState
        {
            get;
            set;
        }

        /// <summary>
        /// Title describing the type of factor.
        /// </summary>
        [JsonPropertyName("title")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Title
        {
            get;
            set;
        }

        /// <summary>
        /// Short phrase describing the type of factor.
        /// </summary>
        [JsonPropertyName("summary")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Summary
        {
            get;
            set;
        }

        /// <summary>
        /// Full text explanation of the factor.
        /// </summary>
        [JsonPropertyName("description")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Description
        {
            get;
            set;
        }

        /// <summary>
        /// The type of mixed content described by the explanation.
        /// </summary>
        [JsonPropertyName("mixedContentType")]
        public CefSharp.DevTools.Security.MixedContentType MixedContentType
        {
            get;
            set;
        }

        /// <summary>
        /// Page certificate.
        /// </summary>
        [JsonPropertyName("certificate")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string[] Certificate
        {
            get;
            set;
        }

        /// <summary>
        /// Recommendations to fix any issues.
        /// </summary>
        [JsonPropertyName("recommendations")]
        public string[] Recommendations
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Information about insecure content on the page.
    /// </summary>
    public partial class InsecureContentStatus : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Always false.
        /// </summary>
        [JsonPropertyName("ranMixedContent")]
        public bool RanMixedContent
        {
            get;
            set;
        }

        /// <summary>
        /// Always false.
        /// </summary>
        [JsonPropertyName("displayedMixedContent")]
        public bool DisplayedMixedContent
        {
            get;
            set;
        }

        /// <summary>
        /// Always false.
        /// </summary>
        [JsonPropertyName("containedMixedForm")]
        public bool ContainedMixedForm
        {
            get;
            set;
        }

        /// <summary>
        /// Always false.
        /// </summary>
        [JsonPropertyName("ranContentWithCertErrors")]
        public bool RanContentWithCertErrors
        {
            get;
            set;
        }

        /// <summary>
        /// Always false.
        /// </summary>
        [JsonPropertyName("displayedContentWithCertErrors")]
        public bool DisplayedContentWithCertErrors
        {
            get;
            set;
        }

        /// <summary>
        /// Always set to unknown.
        /// </summary>
        [JsonPropertyName("ranInsecureContentStyle")]
        public CefSharp.DevTools.Security.SecurityState RanInsecureContentStyle
        {
            get;
            set;
        }

        /// <summary>
        /// Always set to unknown.
        /// </summary>
        [JsonPropertyName("displayedInsecureContentStyle")]
        public CefSharp.DevTools.Security.SecurityState DisplayedInsecureContentStyle
        {
            get;
            set;
        }
    }

    /// <summary>
    /// The action to take when a certificate error occurs. continue will continue processing the
    /// request and cancel will cancel the request.
    /// </summary>
    public enum CertificateErrorAction
    {
        /// <summary>
        /// continue
        /// </summary>
        [JsonPropertyName("continue")]
        Continue,
        /// <summary>
        /// cancel
        /// </summary>
        [JsonPropertyName("cancel")]
        Cancel
    }

    /// <summary>
    /// There is a certificate error. If overriding certificate errors is enabled, then it should be
    /// handled with the `handleCertificateError` command. Note: this event does not fire if the
    /// certificate error has been allowed internally. Only one client per target should override
    /// certificate errors at the same time.
    /// </summary>
    public class CertificateErrorEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// The ID of the event.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("eventId")]
        public int EventId
        {
            get;
            private set;
        }

        /// <summary>
        /// The type of the error.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("errorType")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string ErrorType
        {
            get;
            private set;
        }

        /// <summary>
        /// The url that was requested.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("requestURL")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string RequestURL
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// The security state of the page changed.
    /// </summary>
    public class VisibleSecurityStateChangedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Security state information about the page.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("visibleSecurityState")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.Security.VisibleSecurityState VisibleSecurityState
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// The security state of the page changed. No longer being sent.
    /// </summary>
    public class SecurityStateChangedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Security state.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("securityState")]
        public CefSharp.DevTools.Security.SecurityState SecurityState
        {
            get;
            private set;
        }

        /// <summary>
        /// True if the page was loaded over cryptographic transport such as HTTPS.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("schemeIsCryptographic")]
        public bool SchemeIsCryptographic
        {
            get;
            private set;
        }

        /// <summary>
        /// Previously a list of explanations for the security state. Now always
        /// empty.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("explanations")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public System.Collections.Generic.IList<CefSharp.DevTools.Security.SecurityStateExplanation> Explanations
        {
            get;
            private set;
        }

        /// <summary>
        /// Information about insecure content on the page.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("insecureContentStatus")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.Security.InsecureContentStatus InsecureContentStatus
        {
            get;
            private set;
        }

        /// <summary>
        /// Overrides user-visible description of the state. Always omitted.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("summary")]
        public string Summary
        {
            get;
            private set;
        }
    }
}

namespace CefSharp.DevTools.ServiceWorker
{
    /// <summary>
    /// ServiceWorker registration.
    /// </summary>
    public partial class ServiceWorkerRegistration : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// RegistrationId
        /// </summary>
        [JsonPropertyName("registrationId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string RegistrationId
        {
            get;
            set;
        }

        /// <summary>
        /// ScopeURL
        /// </summary>
        [JsonPropertyName("scopeURL")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string ScopeURL
        {
            get;
            set;
        }

        /// <summary>
        /// IsDeleted
        /// </summary>
        [JsonPropertyName("isDeleted")]
        public bool IsDeleted
        {
            get;
            set;
        }
    }

    /// <summary>
    /// ServiceWorkerVersionRunningStatus
    /// </summary>
    public enum ServiceWorkerVersionRunningStatus
    {
        /// <summary>
        /// stopped
        /// </summary>
        [JsonPropertyName("stopped")]
        Stopped,
        /// <summary>
        /// starting
        /// </summary>
        [JsonPropertyName("starting")]
        Starting,
        /// <summary>
        /// running
        /// </summary>
        [JsonPropertyName("running")]
        Running,
        /// <summary>
        /// stopping
        /// </summary>
        [JsonPropertyName("stopping")]
        Stopping
    }

    /// <summary>
    /// ServiceWorkerVersionStatus
    /// </summary>
    public enum ServiceWorkerVersionStatus
    {
        /// <summary>
        /// new
        /// </summary>
        [JsonPropertyName("new")]
        New,
        /// <summary>
        /// installing
        /// </summary>
        [JsonPropertyName("installing")]
        Installing,
        /// <summary>
        /// installed
        /// </summary>
        [JsonPropertyName("installed")]
        Installed,
        /// <summary>
        /// activating
        /// </summary>
        [JsonPropertyName("activating")]
        Activating,
        /// <summary>
        /// activated
        /// </summary>
        [JsonPropertyName("activated")]
        Activated,
        /// <summary>
        /// redundant
        /// </summary>
        [JsonPropertyName("redundant")]
        Redundant
    }

    /// <summary>
    /// ServiceWorker version.
    /// </summary>
    public partial class ServiceWorkerVersion : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// VersionId
        /// </summary>
        [JsonPropertyName("versionId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string VersionId
        {
            get;
            set;
        }

        /// <summary>
        /// RegistrationId
        /// </summary>
        [JsonPropertyName("registrationId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string RegistrationId
        {
            get;
            set;
        }

        /// <summary>
        /// ScriptURL
        /// </summary>
        [JsonPropertyName("scriptURL")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string ScriptURL
        {
            get;
            set;
        }

        /// <summary>
        /// RunningStatus
        /// </summary>
        [JsonPropertyName("runningStatus")]
        public CefSharp.DevTools.ServiceWorker.ServiceWorkerVersionRunningStatus RunningStatus
        {
            get;
            set;
        }

        /// <summary>
        /// Status
        /// </summary>
        [JsonPropertyName("status")]
        public CefSharp.DevTools.ServiceWorker.ServiceWorkerVersionStatus Status
        {
            get;
            set;
        }

        /// <summary>
        /// The Last-Modified header value of the main script.
        /// </summary>
        [JsonPropertyName("scriptLastModified")]
        public double? ScriptLastModified
        {
            get;
            set;
        }

        /// <summary>
        /// The time at which the response headers of the main script were received from the server.
        /// For cached script it is the last time the cache entry was validated.
        /// </summary>
        [JsonPropertyName("scriptResponseTime")]
        public double? ScriptResponseTime
        {
            get;
            set;
        }

        /// <summary>
        /// ControlledClients
        /// </summary>
        [JsonPropertyName("controlledClients")]
        public string[] ControlledClients
        {
            get;
            set;
        }

        /// <summary>
        /// TargetId
        /// </summary>
        [JsonPropertyName("targetId")]
        public string TargetId
        {
            get;
            set;
        }

        /// <summary>
        /// RouterRules
        /// </summary>
        [JsonPropertyName("routerRules")]
        public string RouterRules
        {
            get;
            set;
        }
    }

    /// <summary>
    /// ServiceWorker error message.
    /// </summary>
    public partial class ServiceWorkerErrorMessage : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// ErrorMessage
        /// </summary>
        [JsonPropertyName("errorMessage")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string ErrorMessage
        {
            get;
            set;
        }

        /// <summary>
        /// RegistrationId
        /// </summary>
        [JsonPropertyName("registrationId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string RegistrationId
        {
            get;
            set;
        }

        /// <summary>
        /// VersionId
        /// </summary>
        [JsonPropertyName("versionId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string VersionId
        {
            get;
            set;
        }

        /// <summary>
        /// SourceURL
        /// </summary>
        [JsonPropertyName("sourceURL")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string SourceURL
        {
            get;
            set;
        }

        /// <summary>
        /// LineNumber
        /// </summary>
        [JsonPropertyName("lineNumber")]
        public int LineNumber
        {
            get;
            set;
        }

        /// <summary>
        /// ColumnNumber
        /// </summary>
        [JsonPropertyName("columnNumber")]
        public int ColumnNumber
        {
            get;
            set;
        }
    }

    /// <summary>
    /// workerErrorReported
    /// </summary>
    public class WorkerErrorReportedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// ErrorMessage
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("errorMessage")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.ServiceWorker.ServiceWorkerErrorMessage ErrorMessage
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// workerRegistrationUpdated
    /// </summary>
    public class WorkerRegistrationUpdatedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Registrations
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("registrations")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public System.Collections.Generic.IList<CefSharp.DevTools.ServiceWorker.ServiceWorkerRegistration> Registrations
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// workerVersionUpdated
    /// </summary>
    public class WorkerVersionUpdatedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Versions
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("versions")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public System.Collections.Generic.IList<CefSharp.DevTools.ServiceWorker.ServiceWorkerVersion> Versions
        {
            get;
            private set;
        }
    }
}

namespace CefSharp.DevTools.Storage
{
    /// <summary>
    /// Enum of possible storage types.
    /// </summary>
    public enum StorageType
    {
        /// <summary>
        /// appcache
        /// </summary>
        [JsonPropertyName("appcache")]
        Appcache,
        /// <summary>
        /// cookies
        /// </summary>
        [JsonPropertyName("cookies")]
        Cookies,
        /// <summary>
        /// file_systems
        /// </summary>
        [JsonPropertyName("file_systems")]
        FileSystems,
        /// <summary>
        /// indexeddb
        /// </summary>
        [JsonPropertyName("indexeddb")]
        Indexeddb,
        /// <summary>
        /// local_storage
        /// </summary>
        [JsonPropertyName("local_storage")]
        LocalStorage,
        /// <summary>
        /// shader_cache
        /// </summary>
        [JsonPropertyName("shader_cache")]
        ShaderCache,
        /// <summary>
        /// websql
        /// </summary>
        [JsonPropertyName("websql")]
        Websql,
        /// <summary>
        /// service_workers
        /// </summary>
        [JsonPropertyName("service_workers")]
        ServiceWorkers,
        /// <summary>
        /// cache_storage
        /// </summary>
        [JsonPropertyName("cache_storage")]
        CacheStorage,
        /// <summary>
        /// interest_groups
        /// </summary>
        [JsonPropertyName("interest_groups")]
        InterestGroups,
        /// <summary>
        /// shared_storage
        /// </summary>
        [JsonPropertyName("shared_storage")]
        SharedStorage,
        /// <summary>
        /// storage_buckets
        /// </summary>
        [JsonPropertyName("storage_buckets")]
        StorageBuckets,
        /// <summary>
        /// all
        /// </summary>
        [JsonPropertyName("all")]
        All,
        /// <summary>
        /// other
        /// </summary>
        [JsonPropertyName("other")]
        Other
    }

    /// <summary>
    /// Usage for a storage type.
    /// </summary>
    public partial class UsageForType : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Name of storage type.
        /// </summary>
        [JsonPropertyName("storageType")]
        public CefSharp.DevTools.Storage.StorageType StorageType
        {
            get;
            set;
        }

        /// <summary>
        /// Storage usage (bytes).
        /// </summary>
        [JsonPropertyName("usage")]
        public double Usage
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Pair of issuer origin and number of available (signed, but not used) Trust
    /// Tokens from that issuer.
    /// </summary>
    public partial class TrustTokens : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// IssuerOrigin
        /// </summary>
        [JsonPropertyName("issuerOrigin")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string IssuerOrigin
        {
            get;
            set;
        }

        /// <summary>
        /// Count
        /// </summary>
        [JsonPropertyName("count")]
        public double Count
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Enum of interest group access types.
    /// </summary>
    public enum InterestGroupAccessType
    {
        /// <summary>
        /// join
        /// </summary>
        [JsonPropertyName("join")]
        Join,
        /// <summary>
        /// leave
        /// </summary>
        [JsonPropertyName("leave")]
        Leave,
        /// <summary>
        /// update
        /// </summary>
        [JsonPropertyName("update")]
        Update,
        /// <summary>
        /// loaded
        /// </summary>
        [JsonPropertyName("loaded")]
        Loaded,
        /// <summary>
        /// bid
        /// </summary>
        [JsonPropertyName("bid")]
        Bid,
        /// <summary>
        /// win
        /// </summary>
        [JsonPropertyName("win")]
        Win,
        /// <summary>
        /// additionalBid
        /// </summary>
        [JsonPropertyName("additionalBid")]
        AdditionalBid,
        /// <summary>
        /// additionalBidWin
        /// </summary>
        [JsonPropertyName("additionalBidWin")]
        AdditionalBidWin,
        /// <summary>
        /// topLevelBid
        /// </summary>
        [JsonPropertyName("topLevelBid")]
        TopLevelBid,
        /// <summary>
        /// topLevelAdditionalBid
        /// </summary>
        [JsonPropertyName("topLevelAdditionalBid")]
        TopLevelAdditionalBid,
        /// <summary>
        /// clear
        /// </summary>
        [JsonPropertyName("clear")]
        Clear
    }

    /// <summary>
    /// Enum of auction events.
    /// </summary>
    public enum InterestGroupAuctionEventType
    {
        /// <summary>
        /// started
        /// </summary>
        [JsonPropertyName("started")]
        Started,
        /// <summary>
        /// configResolved
        /// </summary>
        [JsonPropertyName("configResolved")]
        ConfigResolved
    }

    /// <summary>
    /// Enum of network fetches auctions can do.
    /// </summary>
    public enum InterestGroupAuctionFetchType
    {
        /// <summary>
        /// bidderJs
        /// </summary>
        [JsonPropertyName("bidderJs")]
        BidderJs,
        /// <summary>
        /// bidderWasm
        /// </summary>
        [JsonPropertyName("bidderWasm")]
        BidderWasm,
        /// <summary>
        /// sellerJs
        /// </summary>
        [JsonPropertyName("sellerJs")]
        SellerJs,
        /// <summary>
        /// bidderTrustedSignals
        /// </summary>
        [JsonPropertyName("bidderTrustedSignals")]
        BidderTrustedSignals,
        /// <summary>
        /// sellerTrustedSignals
        /// </summary>
        [JsonPropertyName("sellerTrustedSignals")]
        SellerTrustedSignals
    }

    /// <summary>
    /// Enum of shared storage access types.
    /// </summary>
    public enum SharedStorageAccessType
    {
        /// <summary>
        /// documentAddModule
        /// </summary>
        [JsonPropertyName("documentAddModule")]
        DocumentAddModule,
        /// <summary>
        /// documentSelectURL
        /// </summary>
        [JsonPropertyName("documentSelectURL")]
        DocumentSelectURL,
        /// <summary>
        /// documentRun
        /// </summary>
        [JsonPropertyName("documentRun")]
        DocumentRun,
        /// <summary>
        /// documentSet
        /// </summary>
        [JsonPropertyName("documentSet")]
        DocumentSet,
        /// <summary>
        /// documentAppend
        /// </summary>
        [JsonPropertyName("documentAppend")]
        DocumentAppend,
        /// <summary>
        /// documentDelete
        /// </summary>
        [JsonPropertyName("documentDelete")]
        DocumentDelete,
        /// <summary>
        /// documentClear
        /// </summary>
        [JsonPropertyName("documentClear")]
        DocumentClear,
        /// <summary>
        /// documentGet
        /// </summary>
        [JsonPropertyName("documentGet")]
        DocumentGet,
        /// <summary>
        /// workletSet
        /// </summary>
        [JsonPropertyName("workletSet")]
        WorkletSet,
        /// <summary>
        /// workletAppend
        /// </summary>
        [JsonPropertyName("workletAppend")]
        WorkletAppend,
        /// <summary>
        /// workletDelete
        /// </summary>
        [JsonPropertyName("workletDelete")]
        WorkletDelete,
        /// <summary>
        /// workletClear
        /// </summary>
        [JsonPropertyName("workletClear")]
        WorkletClear,
        /// <summary>
        /// workletGet
        /// </summary>
        [JsonPropertyName("workletGet")]
        WorkletGet,
        /// <summary>
        /// workletKeys
        /// </summary>
        [JsonPropertyName("workletKeys")]
        WorkletKeys,
        /// <summary>
        /// workletEntries
        /// </summary>
        [JsonPropertyName("workletEntries")]
        WorkletEntries,
        /// <summary>
        /// workletLength
        /// </summary>
        [JsonPropertyName("workletLength")]
        WorkletLength,
        /// <summary>
        /// workletRemainingBudget
        /// </summary>
        [JsonPropertyName("workletRemainingBudget")]
        WorkletRemainingBudget,
        /// <summary>
        /// headerSet
        /// </summary>
        [JsonPropertyName("headerSet")]
        HeaderSet,
        /// <summary>
        /// headerAppend
        /// </summary>
        [JsonPropertyName("headerAppend")]
        HeaderAppend,
        /// <summary>
        /// headerDelete
        /// </summary>
        [JsonPropertyName("headerDelete")]
        HeaderDelete,
        /// <summary>
        /// headerClear
        /// </summary>
        [JsonPropertyName("headerClear")]
        HeaderClear
    }

    /// <summary>
    /// Struct for a single key-value pair in an origin&apos;s shared storage.
    /// </summary>
    public partial class SharedStorageEntry : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Key
        /// </summary>
        [JsonPropertyName("key")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Key
        {
            get;
            set;
        }

        /// <summary>
        /// Value
        /// </summary>
        [JsonPropertyName("value")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Value
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Details for an origin&apos;s shared storage.
    /// </summary>
    public partial class SharedStorageMetadata : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Time when the origin&apos;s shared storage was last created.
        /// </summary>
        [JsonPropertyName("creationTime")]
        public double CreationTime
        {
            get;
            set;
        }

        /// <summary>
        /// Number of key-value pairs stored in origin&apos;s shared storage.
        /// </summary>
        [JsonPropertyName("length")]
        public int Length
        {
            get;
            set;
        }

        /// <summary>
        /// Current amount of bits of entropy remaining in the navigation budget.
        /// </summary>
        [JsonPropertyName("remainingBudget")]
        public double RemainingBudget
        {
            get;
            set;
        }

        /// <summary>
        /// Total number of bytes stored as key-value pairs in origin&apos;s shared
        /// storage.
        /// </summary>
        [JsonPropertyName("bytesUsed")]
        public int BytesUsed
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Pair of reporting metadata details for a candidate URL for `selectURL()`.
    /// </summary>
    public partial class SharedStorageReportingMetadata : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// EventType
        /// </summary>
        [JsonPropertyName("eventType")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string EventType
        {
            get;
            set;
        }

        /// <summary>
        /// ReportingUrl
        /// </summary>
        [JsonPropertyName("reportingUrl")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string ReportingUrl
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Bundles a candidate URL with its reporting metadata.
    /// </summary>
    public partial class SharedStorageUrlWithMetadata : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Spec of candidate URL.
        /// </summary>
        [JsonPropertyName("url")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Url
        {
            get;
            set;
        }

        /// <summary>
        /// Any associated reporting metadata.
        /// </summary>
        [JsonPropertyName("reportingMetadata")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public System.Collections.Generic.IList<CefSharp.DevTools.Storage.SharedStorageReportingMetadata> ReportingMetadata
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Bundles the parameters for shared storage access events whose
    /// presence/absence can vary according to SharedStorageAccessType.
    /// </summary>
    public partial class SharedStorageAccessParams : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Spec of the module script URL.
        /// Present only for SharedStorageAccessType.documentAddModule.
        /// </summary>
        [JsonPropertyName("scriptSourceUrl")]
        public string ScriptSourceUrl
        {
            get;
            set;
        }

        /// <summary>
        /// Name of the registered operation to be run.
        /// Present only for SharedStorageAccessType.documentRun and
        /// SharedStorageAccessType.documentSelectURL.
        /// </summary>
        [JsonPropertyName("operationName")]
        public string OperationName
        {
            get;
            set;
        }

        /// <summary>
        /// The operation&apos;s serialized data in bytes (converted to a string).
        /// Present only for SharedStorageAccessType.documentRun and
        /// SharedStorageAccessType.documentSelectURL.
        /// </summary>
        [JsonPropertyName("serializedData")]
        public string SerializedData
        {
            get;
            set;
        }

        /// <summary>
        /// Array of candidate URLs&apos; specs, along with any associated metadata.
        /// Present only for SharedStorageAccessType.documentSelectURL.
        /// </summary>
        [JsonPropertyName("urlsWithMetadata")]
        public System.Collections.Generic.IList<CefSharp.DevTools.Storage.SharedStorageUrlWithMetadata> UrlsWithMetadata
        {
            get;
            set;
        }

        /// <summary>
        /// Key for a specific entry in an origin&apos;s shared storage.
        /// Present only for SharedStorageAccessType.documentSet,
        /// SharedStorageAccessType.documentAppend,
        /// SharedStorageAccessType.documentDelete,
        /// SharedStorageAccessType.workletSet,
        /// SharedStorageAccessType.workletAppend,
        /// SharedStorageAccessType.workletDelete,
        /// SharedStorageAccessType.workletGet,
        /// SharedStorageAccessType.headerSet,
        /// SharedStorageAccessType.headerAppend, and
        /// SharedStorageAccessType.headerDelete.
        /// </summary>
        [JsonPropertyName("key")]
        public string Key
        {
            get;
            set;
        }

        /// <summary>
        /// Value for a specific entry in an origin&apos;s shared storage.
        /// Present only for SharedStorageAccessType.documentSet,
        /// SharedStorageAccessType.documentAppend,
        /// SharedStorageAccessType.workletSet,
        /// SharedStorageAccessType.workletAppend,
        /// SharedStorageAccessType.headerSet, and
        /// SharedStorageAccessType.headerAppend.
        /// </summary>
        [JsonPropertyName("value")]
        public string Value
        {
            get;
            set;
        }

        /// <summary>
        /// Whether or not to set an entry for a key if that key is already present.
        /// Present only for SharedStorageAccessType.documentSet,
        /// SharedStorageAccessType.workletSet, and
        /// SharedStorageAccessType.headerSet.
        /// </summary>
        [JsonPropertyName("ignoreIfPresent")]
        public bool? IgnoreIfPresent
        {
            get;
            set;
        }
    }

    /// <summary>
    /// StorageBucketsDurability
    /// </summary>
    public enum StorageBucketsDurability
    {
        /// <summary>
        /// relaxed
        /// </summary>
        [JsonPropertyName("relaxed")]
        Relaxed,
        /// <summary>
        /// strict
        /// </summary>
        [JsonPropertyName("strict")]
        Strict
    }

    /// <summary>
    /// StorageBucket
    /// </summary>
    public partial class StorageBucket : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// StorageKey
        /// </summary>
        [JsonPropertyName("storageKey")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string StorageKey
        {
            get;
            set;
        }

        /// <summary>
        /// If not specified, it is the default bucket of the storageKey.
        /// </summary>
        [JsonPropertyName("name")]
        public string Name
        {
            get;
            set;
        }
    }

    /// <summary>
    /// StorageBucketInfo
    /// </summary>
    public partial class StorageBucketInfo : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Bucket
        /// </summary>
        [JsonPropertyName("bucket")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.Storage.StorageBucket Bucket
        {
            get;
            set;
        }

        /// <summary>
        /// Id
        /// </summary>
        [JsonPropertyName("id")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Id
        {
            get;
            set;
        }

        /// <summary>
        /// Expiration
        /// </summary>
        [JsonPropertyName("expiration")]
        public double Expiration
        {
            get;
            set;
        }

        /// <summary>
        /// Storage quota (bytes).
        /// </summary>
        [JsonPropertyName("quota")]
        public double Quota
        {
            get;
            set;
        }

        /// <summary>
        /// Persistent
        /// </summary>
        [JsonPropertyName("persistent")]
        public bool Persistent
        {
            get;
            set;
        }

        /// <summary>
        /// Durability
        /// </summary>
        [JsonPropertyName("durability")]
        public CefSharp.DevTools.Storage.StorageBucketsDurability Durability
        {
            get;
            set;
        }
    }

    /// <summary>
    /// AttributionReportingSourceType
    /// </summary>
    public enum AttributionReportingSourceType
    {
        /// <summary>
        /// navigation
        /// </summary>
        [JsonPropertyName("navigation")]
        Navigation,
        /// <summary>
        /// event
        /// </summary>
        [JsonPropertyName("event")]
        Event
    }

    /// <summary>
    /// AttributionReportingFilterDataEntry
    /// </summary>
    public partial class AttributionReportingFilterDataEntry : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Key
        /// </summary>
        [JsonPropertyName("key")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Key
        {
            get;
            set;
        }

        /// <summary>
        /// Values
        /// </summary>
        [JsonPropertyName("values")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string[] Values
        {
            get;
            set;
        }
    }

    /// <summary>
    /// AttributionReportingFilterConfig
    /// </summary>
    public partial class AttributionReportingFilterConfig : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// FilterValues
        /// </summary>
        [JsonPropertyName("filterValues")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public System.Collections.Generic.IList<CefSharp.DevTools.Storage.AttributionReportingFilterDataEntry> FilterValues
        {
            get;
            set;
        }

        /// <summary>
        /// duration in seconds
        /// </summary>
        [JsonPropertyName("lookbackWindow")]
        public int? LookbackWindow
        {
            get;
            set;
        }
    }

    /// <summary>
    /// AttributionReportingFilterPair
    /// </summary>
    public partial class AttributionReportingFilterPair : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Filters
        /// </summary>
        [JsonPropertyName("filters")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public System.Collections.Generic.IList<CefSharp.DevTools.Storage.AttributionReportingFilterConfig> Filters
        {
            get;
            set;
        }

        /// <summary>
        /// NotFilters
        /// </summary>
        [JsonPropertyName("notFilters")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public System.Collections.Generic.IList<CefSharp.DevTools.Storage.AttributionReportingFilterConfig> NotFilters
        {
            get;
            set;
        }
    }

    /// <summary>
    /// AttributionReportingAggregationKeysEntry
    /// </summary>
    public partial class AttributionReportingAggregationKeysEntry : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Key
        /// </summary>
        [JsonPropertyName("key")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Key
        {
            get;
            set;
        }

        /// <summary>
        /// Value
        /// </summary>
        [JsonPropertyName("value")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Value
        {
            get;
            set;
        }
    }

    /// <summary>
    /// AttributionReportingEventReportWindows
    /// </summary>
    public partial class AttributionReportingEventReportWindows : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// duration in seconds
        /// </summary>
        [JsonPropertyName("start")]
        public int Start
        {
            get;
            set;
        }

        /// <summary>
        /// duration in seconds
        /// </summary>
        [JsonPropertyName("ends")]
        public int[] Ends
        {
            get;
            set;
        }
    }

    /// <summary>
    /// AttributionReportingTriggerSpec
    /// </summary>
    public partial class AttributionReportingTriggerSpec : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// number instead of integer because not all uint32 can be represented by
        /// int
        /// </summary>
        [JsonPropertyName("triggerData")]
        public double[] TriggerData
        {
            get;
            set;
        }

        /// <summary>
        /// EventReportWindows
        /// </summary>
        [JsonPropertyName("eventReportWindows")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.Storage.AttributionReportingEventReportWindows EventReportWindows
        {
            get;
            set;
        }
    }

    /// <summary>
    /// AttributionReportingTriggerDataMatching
    /// </summary>
    public enum AttributionReportingTriggerDataMatching
    {
        /// <summary>
        /// exact
        /// </summary>
        [JsonPropertyName("exact")]
        Exact,
        /// <summary>
        /// modulus
        /// </summary>
        [JsonPropertyName("modulus")]
        Modulus
    }

    /// <summary>
    /// AttributionReportingAggregatableDebugReportingData
    /// </summary>
    public partial class AttributionReportingAggregatableDebugReportingData : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// KeyPiece
        /// </summary>
        [JsonPropertyName("keyPiece")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string KeyPiece
        {
            get;
            set;
        }

        /// <summary>
        /// number instead of integer because not all uint32 can be represented by
        /// int
        /// </summary>
        [JsonPropertyName("value")]
        public double Value
        {
            get;
            set;
        }

        /// <summary>
        /// Types
        /// </summary>
        [JsonPropertyName("types")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string[] Types
        {
            get;
            set;
        }
    }

    /// <summary>
    /// AttributionReportingAggregatableDebugReportingConfig
    /// </summary>
    public partial class AttributionReportingAggregatableDebugReportingConfig : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// number instead of integer because not all uint32 can be represented by
        /// int, only present for source registrations
        /// </summary>
        [JsonPropertyName("budget")]
        public double? Budget
        {
            get;
            set;
        }

        /// <summary>
        /// KeyPiece
        /// </summary>
        [JsonPropertyName("keyPiece")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string KeyPiece
        {
            get;
            set;
        }

        /// <summary>
        /// DebugData
        /// </summary>
        [JsonPropertyName("debugData")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public System.Collections.Generic.IList<CefSharp.DevTools.Storage.AttributionReportingAggregatableDebugReportingData> DebugData
        {
            get;
            set;
        }

        /// <summary>
        /// AggregationCoordinatorOrigin
        /// </summary>
        [JsonPropertyName("aggregationCoordinatorOrigin")]
        public string AggregationCoordinatorOrigin
        {
            get;
            set;
        }
    }

    /// <summary>
    /// AttributionReportingSourceRegistration
    /// </summary>
    public partial class AttributionReportingSourceRegistration : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Time
        /// </summary>
        [JsonPropertyName("time")]
        public double Time
        {
            get;
            set;
        }

        /// <summary>
        /// duration in seconds
        /// </summary>
        [JsonPropertyName("expiry")]
        public int Expiry
        {
            get;
            set;
        }

        /// <summary>
        /// TriggerSpecs
        /// </summary>
        [JsonPropertyName("triggerSpecs")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public System.Collections.Generic.IList<CefSharp.DevTools.Storage.AttributionReportingTriggerSpec> TriggerSpecs
        {
            get;
            set;
        }

        /// <summary>
        /// duration in seconds
        /// </summary>
        [JsonPropertyName("aggregatableReportWindow")]
        public int AggregatableReportWindow
        {
            get;
            set;
        }

        /// <summary>
        /// Type
        /// </summary>
        [JsonPropertyName("type")]
        public CefSharp.DevTools.Storage.AttributionReportingSourceType Type
        {
            get;
            set;
        }

        /// <summary>
        /// SourceOrigin
        /// </summary>
        [JsonPropertyName("sourceOrigin")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string SourceOrigin
        {
            get;
            set;
        }

        /// <summary>
        /// ReportingOrigin
        /// </summary>
        [JsonPropertyName("reportingOrigin")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string ReportingOrigin
        {
            get;
            set;
        }

        /// <summary>
        /// DestinationSites
        /// </summary>
        [JsonPropertyName("destinationSites")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string[] DestinationSites
        {
            get;
            set;
        }

        /// <summary>
        /// EventId
        /// </summary>
        [JsonPropertyName("eventId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string EventId
        {
            get;
            set;
        }

        /// <summary>
        /// Priority
        /// </summary>
        [JsonPropertyName("priority")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Priority
        {
            get;
            set;
        }

        /// <summary>
        /// FilterData
        /// </summary>
        [JsonPropertyName("filterData")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public System.Collections.Generic.IList<CefSharp.DevTools.Storage.AttributionReportingFilterDataEntry> FilterData
        {
            get;
            set;
        }

        /// <summary>
        /// AggregationKeys
        /// </summary>
        [JsonPropertyName("aggregationKeys")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public System.Collections.Generic.IList<CefSharp.DevTools.Storage.AttributionReportingAggregationKeysEntry> AggregationKeys
        {
            get;
            set;
        }

        /// <summary>
        /// DebugKey
        /// </summary>
        [JsonPropertyName("debugKey")]
        public string DebugKey
        {
            get;
            set;
        }

        /// <summary>
        /// TriggerDataMatching
        /// </summary>
        [JsonPropertyName("triggerDataMatching")]
        public CefSharp.DevTools.Storage.AttributionReportingTriggerDataMatching TriggerDataMatching
        {
            get;
            set;
        }

        /// <summary>
        /// DestinationLimitPriority
        /// </summary>
        [JsonPropertyName("destinationLimitPriority")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string DestinationLimitPriority
        {
            get;
            set;
        }

        /// <summary>
        /// AggregatableDebugReportingConfig
        /// </summary>
        [JsonPropertyName("aggregatableDebugReportingConfig")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.Storage.AttributionReportingAggregatableDebugReportingConfig AggregatableDebugReportingConfig
        {
            get;
            set;
        }
    }

    /// <summary>
    /// AttributionReportingSourceRegistrationResult
    /// </summary>
    public enum AttributionReportingSourceRegistrationResult
    {
        /// <summary>
        /// success
        /// </summary>
        [JsonPropertyName("success")]
        Success,
        /// <summary>
        /// internalError
        /// </summary>
        [JsonPropertyName("internalError")]
        InternalError,
        /// <summary>
        /// insufficientSourceCapacity
        /// </summary>
        [JsonPropertyName("insufficientSourceCapacity")]
        InsufficientSourceCapacity,
        /// <summary>
        /// insufficientUniqueDestinationCapacity
        /// </summary>
        [JsonPropertyName("insufficientUniqueDestinationCapacity")]
        InsufficientUniqueDestinationCapacity,
        /// <summary>
        /// excessiveReportingOrigins
        /// </summary>
        [JsonPropertyName("excessiveReportingOrigins")]
        ExcessiveReportingOrigins,
        /// <summary>
        /// prohibitedByBrowserPolicy
        /// </summary>
        [JsonPropertyName("prohibitedByBrowserPolicy")]
        ProhibitedByBrowserPolicy,
        /// <summary>
        /// successNoised
        /// </summary>
        [JsonPropertyName("successNoised")]
        SuccessNoised,
        /// <summary>
        /// destinationReportingLimitReached
        /// </summary>
        [JsonPropertyName("destinationReportingLimitReached")]
        DestinationReportingLimitReached,
        /// <summary>
        /// destinationGlobalLimitReached
        /// </summary>
        [JsonPropertyName("destinationGlobalLimitReached")]
        DestinationGlobalLimitReached,
        /// <summary>
        /// destinationBothLimitsReached
        /// </summary>
        [JsonPropertyName("destinationBothLimitsReached")]
        DestinationBothLimitsReached,
        /// <summary>
        /// reportingOriginsPerSiteLimitReached
        /// </summary>
        [JsonPropertyName("reportingOriginsPerSiteLimitReached")]
        ReportingOriginsPerSiteLimitReached,
        /// <summary>
        /// exceedsMaxChannelCapacity
        /// </summary>
        [JsonPropertyName("exceedsMaxChannelCapacity")]
        ExceedsMaxChannelCapacity,
        /// <summary>
        /// exceedsMaxTriggerStateCardinality
        /// </summary>
        [JsonPropertyName("exceedsMaxTriggerStateCardinality")]
        ExceedsMaxTriggerStateCardinality,
        /// <summary>
        /// destinationPerDayReportingLimitReached
        /// </summary>
        [JsonPropertyName("destinationPerDayReportingLimitReached")]
        DestinationPerDayReportingLimitReached
    }

    /// <summary>
    /// AttributionReportingSourceRegistrationTimeConfig
    /// </summary>
    public enum AttributionReportingSourceRegistrationTimeConfig
    {
        /// <summary>
        /// include
        /// </summary>
        [JsonPropertyName("include")]
        Include,
        /// <summary>
        /// exclude
        /// </summary>
        [JsonPropertyName("exclude")]
        Exclude
    }

    /// <summary>
    /// AttributionReportingAggregatableValueDictEntry
    /// </summary>
    public partial class AttributionReportingAggregatableValueDictEntry : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Key
        /// </summary>
        [JsonPropertyName("key")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Key
        {
            get;
            set;
        }

        /// <summary>
        /// number instead of integer because not all uint32 can be represented by
        /// int
        /// </summary>
        [JsonPropertyName("value")]
        public double Value
        {
            get;
            set;
        }

        /// <summary>
        /// FilteringId
        /// </summary>
        [JsonPropertyName("filteringId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string FilteringId
        {
            get;
            set;
        }
    }

    /// <summary>
    /// AttributionReportingAggregatableValueEntry
    /// </summary>
    public partial class AttributionReportingAggregatableValueEntry : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Values
        /// </summary>
        [JsonPropertyName("values")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public System.Collections.Generic.IList<CefSharp.DevTools.Storage.AttributionReportingAggregatableValueDictEntry> Values
        {
            get;
            set;
        }

        /// <summary>
        /// Filters
        /// </summary>
        [JsonPropertyName("filters")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.Storage.AttributionReportingFilterPair Filters
        {
            get;
            set;
        }
    }

    /// <summary>
    /// AttributionReportingEventTriggerData
    /// </summary>
    public partial class AttributionReportingEventTriggerData : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Data
        /// </summary>
        [JsonPropertyName("data")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Data
        {
            get;
            set;
        }

        /// <summary>
        /// Priority
        /// </summary>
        [JsonPropertyName("priority")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Priority
        {
            get;
            set;
        }

        /// <summary>
        /// DedupKey
        /// </summary>
        [JsonPropertyName("dedupKey")]
        public string DedupKey
        {
            get;
            set;
        }

        /// <summary>
        /// Filters
        /// </summary>
        [JsonPropertyName("filters")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.Storage.AttributionReportingFilterPair Filters
        {
            get;
            set;
        }
    }

    /// <summary>
    /// AttributionReportingAggregatableTriggerData
    /// </summary>
    public partial class AttributionReportingAggregatableTriggerData : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// KeyPiece
        /// </summary>
        [JsonPropertyName("keyPiece")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string KeyPiece
        {
            get;
            set;
        }

        /// <summary>
        /// SourceKeys
        /// </summary>
        [JsonPropertyName("sourceKeys")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string[] SourceKeys
        {
            get;
            set;
        }

        /// <summary>
        /// Filters
        /// </summary>
        [JsonPropertyName("filters")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.Storage.AttributionReportingFilterPair Filters
        {
            get;
            set;
        }
    }

    /// <summary>
    /// AttributionReportingAggregatableDedupKey
    /// </summary>
    public partial class AttributionReportingAggregatableDedupKey : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// DedupKey
        /// </summary>
        [JsonPropertyName("dedupKey")]
        public string DedupKey
        {
            get;
            set;
        }

        /// <summary>
        /// Filters
        /// </summary>
        [JsonPropertyName("filters")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.Storage.AttributionReportingFilterPair Filters
        {
            get;
            set;
        }
    }

    /// <summary>
    /// AttributionReportingTriggerRegistration
    /// </summary>
    public partial class AttributionReportingTriggerRegistration : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Filters
        /// </summary>
        [JsonPropertyName("filters")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.Storage.AttributionReportingFilterPair Filters
        {
            get;
            set;
        }

        /// <summary>
        /// DebugKey
        /// </summary>
        [JsonPropertyName("debugKey")]
        public string DebugKey
        {
            get;
            set;
        }

        /// <summary>
        /// AggregatableDedupKeys
        /// </summary>
        [JsonPropertyName("aggregatableDedupKeys")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public System.Collections.Generic.IList<CefSharp.DevTools.Storage.AttributionReportingAggregatableDedupKey> AggregatableDedupKeys
        {
            get;
            set;
        }

        /// <summary>
        /// EventTriggerData
        /// </summary>
        [JsonPropertyName("eventTriggerData")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public System.Collections.Generic.IList<CefSharp.DevTools.Storage.AttributionReportingEventTriggerData> EventTriggerData
        {
            get;
            set;
        }

        /// <summary>
        /// AggregatableTriggerData
        /// </summary>
        [JsonPropertyName("aggregatableTriggerData")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public System.Collections.Generic.IList<CefSharp.DevTools.Storage.AttributionReportingAggregatableTriggerData> AggregatableTriggerData
        {
            get;
            set;
        }

        /// <summary>
        /// AggregatableValues
        /// </summary>
        [JsonPropertyName("aggregatableValues")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public System.Collections.Generic.IList<CefSharp.DevTools.Storage.AttributionReportingAggregatableValueEntry> AggregatableValues
        {
            get;
            set;
        }

        /// <summary>
        /// AggregatableFilteringIdMaxBytes
        /// </summary>
        [JsonPropertyName("aggregatableFilteringIdMaxBytes")]
        public int AggregatableFilteringIdMaxBytes
        {
            get;
            set;
        }

        /// <summary>
        /// DebugReporting
        /// </summary>
        [JsonPropertyName("debugReporting")]
        public bool DebugReporting
        {
            get;
            set;
        }

        /// <summary>
        /// AggregationCoordinatorOrigin
        /// </summary>
        [JsonPropertyName("aggregationCoordinatorOrigin")]
        public string AggregationCoordinatorOrigin
        {
            get;
            set;
        }

        /// <summary>
        /// SourceRegistrationTimeConfig
        /// </summary>
        [JsonPropertyName("sourceRegistrationTimeConfig")]
        public CefSharp.DevTools.Storage.AttributionReportingSourceRegistrationTimeConfig SourceRegistrationTimeConfig
        {
            get;
            set;
        }

        /// <summary>
        /// TriggerContextId
        /// </summary>
        [JsonPropertyName("triggerContextId")]
        public string TriggerContextId
        {
            get;
            set;
        }

        /// <summary>
        /// AggregatableDebugReportingConfig
        /// </summary>
        [JsonPropertyName("aggregatableDebugReportingConfig")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.Storage.AttributionReportingAggregatableDebugReportingConfig AggregatableDebugReportingConfig
        {
            get;
            set;
        }
    }

    /// <summary>
    /// AttributionReportingEventLevelResult
    /// </summary>
    public enum AttributionReportingEventLevelResult
    {
        /// <summary>
        /// success
        /// </summary>
        [JsonPropertyName("success")]
        Success,
        /// <summary>
        /// successDroppedLowerPriority
        /// </summary>
        [JsonPropertyName("successDroppedLowerPriority")]
        SuccessDroppedLowerPriority,
        /// <summary>
        /// internalError
        /// </summary>
        [JsonPropertyName("internalError")]
        InternalError,
        /// <summary>
        /// noCapacityForAttributionDestination
        /// </summary>
        [JsonPropertyName("noCapacityForAttributionDestination")]
        NoCapacityForAttributionDestination,
        /// <summary>
        /// noMatchingSources
        /// </summary>
        [JsonPropertyName("noMatchingSources")]
        NoMatchingSources,
        /// <summary>
        /// deduplicated
        /// </summary>
        [JsonPropertyName("deduplicated")]
        Deduplicated,
        /// <summary>
        /// excessiveAttributions
        /// </summary>
        [JsonPropertyName("excessiveAttributions")]
        ExcessiveAttributions,
        /// <summary>
        /// priorityTooLow
        /// </summary>
        [JsonPropertyName("priorityTooLow")]
        PriorityTooLow,
        /// <summary>
        /// neverAttributedSource
        /// </summary>
        [JsonPropertyName("neverAttributedSource")]
        NeverAttributedSource,
        /// <summary>
        /// excessiveReportingOrigins
        /// </summary>
        [JsonPropertyName("excessiveReportingOrigins")]
        ExcessiveReportingOrigins,
        /// <summary>
        /// noMatchingSourceFilterData
        /// </summary>
        [JsonPropertyName("noMatchingSourceFilterData")]
        NoMatchingSourceFilterData,
        /// <summary>
        /// prohibitedByBrowserPolicy
        /// </summary>
        [JsonPropertyName("prohibitedByBrowserPolicy")]
        ProhibitedByBrowserPolicy,
        /// <summary>
        /// noMatchingConfigurations
        /// </summary>
        [JsonPropertyName("noMatchingConfigurations")]
        NoMatchingConfigurations,
        /// <summary>
        /// excessiveReports
        /// </summary>
        [JsonPropertyName("excessiveReports")]
        ExcessiveReports,
        /// <summary>
        /// falselyAttributedSource
        /// </summary>
        [JsonPropertyName("falselyAttributedSource")]
        FalselyAttributedSource,
        /// <summary>
        /// reportWindowPassed
        /// </summary>
        [JsonPropertyName("reportWindowPassed")]
        ReportWindowPassed,
        /// <summary>
        /// notRegistered
        /// </summary>
        [JsonPropertyName("notRegistered")]
        NotRegistered,
        /// <summary>
        /// reportWindowNotStarted
        /// </summary>
        [JsonPropertyName("reportWindowNotStarted")]
        ReportWindowNotStarted,
        /// <summary>
        /// noMatchingTriggerData
        /// </summary>
        [JsonPropertyName("noMatchingTriggerData")]
        NoMatchingTriggerData
    }

    /// <summary>
    /// AttributionReportingAggregatableResult
    /// </summary>
    public enum AttributionReportingAggregatableResult
    {
        /// <summary>
        /// success
        /// </summary>
        [JsonPropertyName("success")]
        Success,
        /// <summary>
        /// internalError
        /// </summary>
        [JsonPropertyName("internalError")]
        InternalError,
        /// <summary>
        /// noCapacityForAttributionDestination
        /// </summary>
        [JsonPropertyName("noCapacityForAttributionDestination")]
        NoCapacityForAttributionDestination,
        /// <summary>
        /// noMatchingSources
        /// </summary>
        [JsonPropertyName("noMatchingSources")]
        NoMatchingSources,
        /// <summary>
        /// excessiveAttributions
        /// </summary>
        [JsonPropertyName("excessiveAttributions")]
        ExcessiveAttributions,
        /// <summary>
        /// excessiveReportingOrigins
        /// </summary>
        [JsonPropertyName("excessiveReportingOrigins")]
        ExcessiveReportingOrigins,
        /// <summary>
        /// noHistograms
        /// </summary>
        [JsonPropertyName("noHistograms")]
        NoHistograms,
        /// <summary>
        /// insufficientBudget
        /// </summary>
        [JsonPropertyName("insufficientBudget")]
        InsufficientBudget,
        /// <summary>
        /// noMatchingSourceFilterData
        /// </summary>
        [JsonPropertyName("noMatchingSourceFilterData")]
        NoMatchingSourceFilterData,
        /// <summary>
        /// notRegistered
        /// </summary>
        [JsonPropertyName("notRegistered")]
        NotRegistered,
        /// <summary>
        /// prohibitedByBrowserPolicy
        /// </summary>
        [JsonPropertyName("prohibitedByBrowserPolicy")]
        ProhibitedByBrowserPolicy,
        /// <summary>
        /// deduplicated
        /// </summary>
        [JsonPropertyName("deduplicated")]
        Deduplicated,
        /// <summary>
        /// reportWindowPassed
        /// </summary>
        [JsonPropertyName("reportWindowPassed")]
        ReportWindowPassed,
        /// <summary>
        /// excessiveReports
        /// </summary>
        [JsonPropertyName("excessiveReports")]
        ExcessiveReports
    }

    /// <summary>
    /// A single Related Website Set object.
    /// </summary>
    public partial class RelatedWebsiteSet : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The primary site of this set, along with the ccTLDs if there is any.
        /// </summary>
        [JsonPropertyName("primarySites")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string[] PrimarySites
        {
            get;
            set;
        }

        /// <summary>
        /// The associated sites of this set, along with the ccTLDs if there is any.
        /// </summary>
        [JsonPropertyName("associatedSites")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string[] AssociatedSites
        {
            get;
            set;
        }

        /// <summary>
        /// The service sites of this set, along with the ccTLDs if there is any.
        /// </summary>
        [JsonPropertyName("serviceSites")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string[] ServiceSites
        {
            get;
            set;
        }
    }

    /// <summary>
    /// A cache&apos;s contents have been modified.
    /// </summary>
    public class CacheStorageContentUpdatedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Origin to update.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("origin")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Origin
        {
            get;
            private set;
        }

        /// <summary>
        /// Storage key to update.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("storageKey")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string StorageKey
        {
            get;
            private set;
        }

        /// <summary>
        /// Storage bucket to update.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("bucketId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string BucketId
        {
            get;
            private set;
        }

        /// <summary>
        /// Name of cache in origin.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("cacheName")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string CacheName
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// A cache has been added/deleted.
    /// </summary>
    public class CacheStorageListUpdatedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Origin to update.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("origin")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Origin
        {
            get;
            private set;
        }

        /// <summary>
        /// Storage key to update.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("storageKey")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string StorageKey
        {
            get;
            private set;
        }

        /// <summary>
        /// Storage bucket to update.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("bucketId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string BucketId
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// The origin&apos;s IndexedDB object store has been modified.
    /// </summary>
    public class IndexedDBContentUpdatedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Origin to update.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("origin")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Origin
        {
            get;
            private set;
        }

        /// <summary>
        /// Storage key to update.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("storageKey")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string StorageKey
        {
            get;
            private set;
        }

        /// <summary>
        /// Storage bucket to update.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("bucketId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string BucketId
        {
            get;
            private set;
        }

        /// <summary>
        /// Database to update.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("databaseName")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string DatabaseName
        {
            get;
            private set;
        }

        /// <summary>
        /// ObjectStore to update.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("objectStoreName")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string ObjectStoreName
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// The origin&apos;s IndexedDB database list has been modified.
    /// </summary>
    public class IndexedDBListUpdatedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Origin to update.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("origin")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Origin
        {
            get;
            private set;
        }

        /// <summary>
        /// Storage key to update.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("storageKey")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string StorageKey
        {
            get;
            private set;
        }

        /// <summary>
        /// Storage bucket to update.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("bucketId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string BucketId
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// One of the interest groups was accessed. Note that these events are global
    /// to all targets sharing an interest group store.
    /// </summary>
    public class InterestGroupAccessedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// AccessTime
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("accessTime")]
        public double AccessTime
        {
            get;
            private set;
        }

        /// <summary>
        /// Type
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("type")]
        public CefSharp.DevTools.Storage.InterestGroupAccessType Type
        {
            get;
            private set;
        }

        /// <summary>
        /// OwnerOrigin
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("ownerOrigin")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string OwnerOrigin
        {
            get;
            private set;
        }

        /// <summary>
        /// Name
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("name")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Name
        {
            get;
            private set;
        }

        /// <summary>
        /// For topLevelBid/topLevelAdditionalBid, and when appropriate,
        /// win and additionalBidWin
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("componentSellerOrigin")]
        public string ComponentSellerOrigin
        {
            get;
            private set;
        }

        /// <summary>
        /// For bid or somethingBid event, if done locally and not on a server.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("bid")]
        public double? Bid
        {
            get;
            private set;
        }

        /// <summary>
        /// BidCurrency
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("bidCurrency")]
        public string BidCurrency
        {
            get;
            private set;
        }

        /// <summary>
        /// For non-global events --- links to interestGroupAuctionEvent
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("uniqueAuctionId")]
        public string UniqueAuctionId
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// An auction involving interest groups is taking place. These events are
    /// target-specific.
    /// </summary>
    public class InterestGroupAuctionEventOccurredEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// EventTime
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("eventTime")]
        public double EventTime
        {
            get;
            private set;
        }

        /// <summary>
        /// Type
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("type")]
        public CefSharp.DevTools.Storage.InterestGroupAuctionEventType Type
        {
            get;
            private set;
        }

        /// <summary>
        /// UniqueAuctionId
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("uniqueAuctionId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string UniqueAuctionId
        {
            get;
            private set;
        }

        /// <summary>
        /// Set for child auctions.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("parentAuctionId")]
        public string ParentAuctionId
        {
            get;
            private set;
        }

        /// <summary>
        /// Set for started and configResolved
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("auctionConfig")]
        public object AuctionConfig
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Specifies which auctions a particular network fetch may be related to, and
    /// in what role. Note that it is not ordered with respect to
    /// Network.requestWillBeSent (but will happen before loadingFinished
    /// loadingFailed).
    /// </summary>
    public class InterestGroupAuctionNetworkRequestCreatedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Type
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("type")]
        public CefSharp.DevTools.Storage.InterestGroupAuctionFetchType Type
        {
            get;
            private set;
        }

        /// <summary>
        /// RequestId
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("requestId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string RequestId
        {
            get;
            private set;
        }

        /// <summary>
        /// This is the set of the auctions using the worklet that issued this
        /// request.  In the case of trusted signals, it&apos;s possible that only some of
        /// them actually care about the keys being queried.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("auctions")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string[] Auctions
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Shared storage was accessed by the associated page.
    /// The following parameters are included in all events.
    /// </summary>
    public class SharedStorageAccessedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Time of the access.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("accessTime")]
        public double AccessTime
        {
            get;
            private set;
        }

        /// <summary>
        /// Enum value indicating the Shared Storage API method invoked.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("type")]
        public CefSharp.DevTools.Storage.SharedStorageAccessType Type
        {
            get;
            private set;
        }

        /// <summary>
        /// DevTools Frame Token for the primary frame tree&apos;s root.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("mainFrameId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string MainFrameId
        {
            get;
            private set;
        }

        /// <summary>
        /// Serialized origin for the context that invoked the Shared Storage API.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("ownerOrigin")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string OwnerOrigin
        {
            get;
            private set;
        }

        /// <summary>
        /// The sub-parameters wrapped by `params` are all optional and their
        /// presence/absence depends on `type`.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("params")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.Storage.SharedStorageAccessParams Params
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// storageBucketCreatedOrUpdated
    /// </summary>
    public class StorageBucketCreatedOrUpdatedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// BucketInfo
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("bucketInfo")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.Storage.StorageBucketInfo BucketInfo
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// storageBucketDeleted
    /// </summary>
    public class StorageBucketDeletedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// BucketId
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("bucketId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string BucketId
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// attributionReportingSourceRegistered
    /// </summary>
    public class AttributionReportingSourceRegisteredEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Registration
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("registration")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.Storage.AttributionReportingSourceRegistration Registration
        {
            get;
            private set;
        }

        /// <summary>
        /// Result
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("result")]
        public CefSharp.DevTools.Storage.AttributionReportingSourceRegistrationResult Result
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// attributionReportingTriggerRegistered
    /// </summary>
    public class AttributionReportingTriggerRegisteredEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Registration
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("registration")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.Storage.AttributionReportingTriggerRegistration Registration
        {
            get;
            private set;
        }

        /// <summary>
        /// EventLevel
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("eventLevel")]
        public CefSharp.DevTools.Storage.AttributionReportingEventLevelResult EventLevel
        {
            get;
            private set;
        }

        /// <summary>
        /// Aggregatable
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("aggregatable")]
        public CefSharp.DevTools.Storage.AttributionReportingAggregatableResult Aggregatable
        {
            get;
            private set;
        }
    }
}

namespace CefSharp.DevTools.SystemInfo
{
    /// <summary>
    /// Describes a single graphics processor (GPU).
    /// </summary>
    public partial class GPUDevice : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// PCI ID of the GPU vendor, if available; 0 otherwise.
        /// </summary>
        [JsonPropertyName("vendorId")]
        public double VendorId
        {
            get;
            set;
        }

        /// <summary>
        /// PCI ID of the GPU device, if available; 0 otherwise.
        /// </summary>
        [JsonPropertyName("deviceId")]
        public double DeviceId
        {
            get;
            set;
        }

        /// <summary>
        /// Sub sys ID of the GPU, only available on Windows.
        /// </summary>
        [JsonPropertyName("subSysId")]
        public double? SubSysId
        {
            get;
            set;
        }

        /// <summary>
        /// Revision of the GPU, only available on Windows.
        /// </summary>
        [JsonPropertyName("revision")]
        public double? Revision
        {
            get;
            set;
        }

        /// <summary>
        /// String description of the GPU vendor, if the PCI ID is not available.
        /// </summary>
        [JsonPropertyName("vendorString")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string VendorString
        {
            get;
            set;
        }

        /// <summary>
        /// String description of the GPU device, if the PCI ID is not available.
        /// </summary>
        [JsonPropertyName("deviceString")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string DeviceString
        {
            get;
            set;
        }

        /// <summary>
        /// String description of the GPU driver vendor.
        /// </summary>
        [JsonPropertyName("driverVendor")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string DriverVendor
        {
            get;
            set;
        }

        /// <summary>
        /// String description of the GPU driver version.
        /// </summary>
        [JsonPropertyName("driverVersion")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string DriverVersion
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Describes the width and height dimensions of an entity.
    /// </summary>
    public partial class Size : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Width in pixels.
        /// </summary>
        [JsonPropertyName("width")]
        public int Width
        {
            get;
            set;
        }

        /// <summary>
        /// Height in pixels.
        /// </summary>
        [JsonPropertyName("height")]
        public int Height
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Describes a supported video decoding profile with its associated minimum and
    /// maximum resolutions.
    /// </summary>
    public partial class VideoDecodeAcceleratorCapability : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Video codec profile that is supported, e.g. VP9 Profile 2.
        /// </summary>
        [JsonPropertyName("profile")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Profile
        {
            get;
            set;
        }

        /// <summary>
        /// Maximum video dimensions in pixels supported for this |profile|.
        /// </summary>
        [JsonPropertyName("maxResolution")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.SystemInfo.Size MaxResolution
        {
            get;
            set;
        }

        /// <summary>
        /// Minimum video dimensions in pixels supported for this |profile|.
        /// </summary>
        [JsonPropertyName("minResolution")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.SystemInfo.Size MinResolution
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Describes a supported video encoding profile with its associated maximum
    /// resolution and maximum framerate.
    /// </summary>
    public partial class VideoEncodeAcceleratorCapability : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Video codec profile that is supported, e.g H264 Main.
        /// </summary>
        [JsonPropertyName("profile")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Profile
        {
            get;
            set;
        }

        /// <summary>
        /// Maximum video dimensions in pixels supported for this |profile|.
        /// </summary>
        [JsonPropertyName("maxResolution")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.SystemInfo.Size MaxResolution
        {
            get;
            set;
        }

        /// <summary>
        /// Maximum encoding framerate in frames per second supported for this
        /// |profile|, as fraction&apos;s numerator and denominator, e.g. 24/1 fps,
        /// 24000/1001 fps, etc.
        /// </summary>
        [JsonPropertyName("maxFramerateNumerator")]
        public int MaxFramerateNumerator
        {
            get;
            set;
        }

        /// <summary>
        /// MaxFramerateDenominator
        /// </summary>
        [JsonPropertyName("maxFramerateDenominator")]
        public int MaxFramerateDenominator
        {
            get;
            set;
        }
    }

    /// <summary>
    /// YUV subsampling type of the pixels of a given image.
    /// </summary>
    public enum SubsamplingFormat
    {
        /// <summary>
        /// yuv420
        /// </summary>
        [JsonPropertyName("yuv420")]
        Yuv420,
        /// <summary>
        /// yuv422
        /// </summary>
        [JsonPropertyName("yuv422")]
        Yuv422,
        /// <summary>
        /// yuv444
        /// </summary>
        [JsonPropertyName("yuv444")]
        Yuv444
    }

    /// <summary>
    /// Image format of a given image.
    /// </summary>
    public enum ImageType
    {
        /// <summary>
        /// jpeg
        /// </summary>
        [JsonPropertyName("jpeg")]
        Jpeg,
        /// <summary>
        /// webp
        /// </summary>
        [JsonPropertyName("webp")]
        Webp,
        /// <summary>
        /// unknown
        /// </summary>
        [JsonPropertyName("unknown")]
        Unknown
    }

    /// <summary>
    /// Describes a supported image decoding profile with its associated minimum and
    /// maximum resolutions and subsampling.
    /// </summary>
    public partial class ImageDecodeAcceleratorCapability : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Image coded, e.g. Jpeg.
        /// </summary>
        [JsonPropertyName("imageType")]
        public CefSharp.DevTools.SystemInfo.ImageType ImageType
        {
            get;
            set;
        }

        /// <summary>
        /// Maximum supported dimensions of the image in pixels.
        /// </summary>
        [JsonPropertyName("maxDimensions")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.SystemInfo.Size MaxDimensions
        {
            get;
            set;
        }

        /// <summary>
        /// Minimum supported dimensions of the image in pixels.
        /// </summary>
        [JsonPropertyName("minDimensions")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.SystemInfo.Size MinDimensions
        {
            get;
            set;
        }

        /// <summary>
        /// Optional array of supported subsampling formats, e.g. 4:2:0, if known.
        /// </summary>
        [JsonPropertyName("subsamplings")]
        public CefSharp.DevTools.SystemInfo.SubsamplingFormat[] Subsamplings
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Provides information about the GPU(s) on the system.
    /// </summary>
    public partial class GPUInfo : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The graphics devices on the system. Element 0 is the primary GPU.
        /// </summary>
        [JsonPropertyName("devices")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public System.Collections.Generic.IList<CefSharp.DevTools.SystemInfo.GPUDevice> Devices
        {
            get;
            set;
        }

        /// <summary>
        /// An optional dictionary of additional GPU related attributes.
        /// </summary>
        [JsonPropertyName("auxAttributes")]
        public object AuxAttributes
        {
            get;
            set;
        }

        /// <summary>
        /// An optional dictionary of graphics features and their status.
        /// </summary>
        [JsonPropertyName("featureStatus")]
        public object FeatureStatus
        {
            get;
            set;
        }

        /// <summary>
        /// An optional array of GPU driver bug workarounds.
        /// </summary>
        [JsonPropertyName("driverBugWorkarounds")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string[] DriverBugWorkarounds
        {
            get;
            set;
        }

        /// <summary>
        /// Supported accelerated video decoding capabilities.
        /// </summary>
        [JsonPropertyName("videoDecoding")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public System.Collections.Generic.IList<CefSharp.DevTools.SystemInfo.VideoDecodeAcceleratorCapability> VideoDecoding
        {
            get;
            set;
        }

        /// <summary>
        /// Supported accelerated video encoding capabilities.
        /// </summary>
        [JsonPropertyName("videoEncoding")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public System.Collections.Generic.IList<CefSharp.DevTools.SystemInfo.VideoEncodeAcceleratorCapability> VideoEncoding
        {
            get;
            set;
        }

        /// <summary>
        /// Supported accelerated image decoding capabilities.
        /// </summary>
        [JsonPropertyName("imageDecoding")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public System.Collections.Generic.IList<CefSharp.DevTools.SystemInfo.ImageDecodeAcceleratorCapability> ImageDecoding
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Represents process info.
    /// </summary>
    public partial class ProcessInfo : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Specifies process type.
        /// </summary>
        [JsonPropertyName("type")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Type
        {
            get;
            set;
        }

        /// <summary>
        /// Specifies process id.
        /// </summary>
        [JsonPropertyName("id")]
        public int Id
        {
            get;
            set;
        }

        /// <summary>
        /// Specifies cumulative CPU usage in seconds across all threads of the
        /// process since the process start.
        /// </summary>
        [JsonPropertyName("cpuTime")]
        public double CpuTime
        {
            get;
            set;
        }
    }
}

namespace CefSharp.DevTools.Target
{
    /// <summary>
    /// TargetInfo
    /// </summary>
    public partial class TargetInfo : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// TargetId
        /// </summary>
        [JsonPropertyName("targetId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string TargetId
        {
            get;
            set;
        }

        /// <summary>
        /// List of types: https://source.chromium.org/chromium/chromium/src/+/main:content/browser/devtools/devtools_agent_host_impl.cc?ss=chromium&amp;q=f:devtools%20-f:out%20%22::kTypeTab%5B%5D%22
        /// </summary>
        [JsonPropertyName("type")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Type
        {
            get;
            set;
        }

        /// <summary>
        /// Title
        /// </summary>
        [JsonPropertyName("title")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Title
        {
            get;
            set;
        }

        /// <summary>
        /// Url
        /// </summary>
        [JsonPropertyName("url")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Url
        {
            get;
            set;
        }

        /// <summary>
        /// Whether the target has an attached client.
        /// </summary>
        [JsonPropertyName("attached")]
        public bool Attached
        {
            get;
            set;
        }

        /// <summary>
        /// Opener target Id
        /// </summary>
        [JsonPropertyName("openerId")]
        public string OpenerId
        {
            get;
            set;
        }

        /// <summary>
        /// Whether the target has access to the originating window.
        /// </summary>
        [JsonPropertyName("canAccessOpener")]
        public bool CanAccessOpener
        {
            get;
            set;
        }

        /// <summary>
        /// Frame id of originating window (is only set if target has an opener).
        /// </summary>
        [JsonPropertyName("openerFrameId")]
        public string OpenerFrameId
        {
            get;
            set;
        }

        /// <summary>
        /// BrowserContextId
        /// </summary>
        [JsonPropertyName("browserContextId")]
        public string BrowserContextId
        {
            get;
            set;
        }

        /// <summary>
        /// Provides additional details for specific target types. For example, for
        /// the type of &quot;page&quot;, this may be set to &quot;prerender&quot;.
        /// </summary>
        [JsonPropertyName("subtype")]
        public string Subtype
        {
            get;
            set;
        }
    }

    /// <summary>
    /// A filter used by target query/discovery/auto-attach operations.
    /// </summary>
    public partial class FilterEntry : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// If set, causes exclusion of matching targets from the list.
        /// </summary>
        [JsonPropertyName("exclude")]
        public bool? Exclude
        {
            get;
            set;
        }

        /// <summary>
        /// If not present, matches any type.
        /// </summary>
        [JsonPropertyName("type")]
        public string Type
        {
            get;
            set;
        }
    }

    /// <summary>
    /// RemoteLocation
    /// </summary>
    public partial class RemoteLocation : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Host
        /// </summary>
        [JsonPropertyName("host")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Host
        {
            get;
            set;
        }

        /// <summary>
        /// Port
        /// </summary>
        [JsonPropertyName("port")]
        public int Port
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Issued when attached to target because of auto-attach or `attachToTarget` command.
    /// </summary>
    public class AttachedToTargetEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Identifier assigned to the session used to send/receive messages.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("sessionId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string SessionId
        {
            get;
            private set;
        }

        /// <summary>
        /// TargetInfo
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("targetInfo")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.Target.TargetInfo TargetInfo
        {
            get;
            private set;
        }

        /// <summary>
        /// WaitingForDebugger
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("waitingForDebugger")]
        public bool WaitingForDebugger
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Issued when detached from target for any reason (including `detachFromTarget` command). Can be
    /// issued multiple times per target if multiple sessions have been attached to it.
    /// </summary>
    public class DetachedFromTargetEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Detached session identifier.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("sessionId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string SessionId
        {
            get;
            private set;
        }

        /// <summary>
        /// Deprecated.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("targetId")]
        public string TargetId
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Notifies about a new protocol message received from the session (as reported in
    /// `attachedToTarget` event).
    /// </summary>
    public class ReceivedMessageFromTargetEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Identifier of a session which sends a message.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("sessionId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string SessionId
        {
            get;
            private set;
        }

        /// <summary>
        /// Message
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("message")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Message
        {
            get;
            private set;
        }

        /// <summary>
        /// Deprecated.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("targetId")]
        public string TargetId
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Issued when a possible inspection target is created.
    /// </summary>
    public class TargetCreatedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// TargetInfo
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("targetInfo")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.Target.TargetInfo TargetInfo
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Issued when a target is destroyed.
    /// </summary>
    public class TargetDestroyedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// TargetId
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("targetId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string TargetId
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Issued when a target has crashed.
    /// </summary>
    public class TargetCrashedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// TargetId
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("targetId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string TargetId
        {
            get;
            private set;
        }

        /// <summary>
        /// Termination status type.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("status")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Status
        {
            get;
            private set;
        }

        /// <summary>
        /// Termination error code.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("errorCode")]
        public int ErrorCode
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Issued when some information about a target has changed. This only happens between
    /// `targetCreated` and `targetDestroyed`.
    /// </summary>
    public class TargetInfoChangedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// TargetInfo
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("targetInfo")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.Target.TargetInfo TargetInfo
        {
            get;
            private set;
        }
    }
}

namespace CefSharp.DevTools.Tethering
{
    /// <summary>
    /// Informs that port was successfully bound and got a specified connection id.
    /// </summary>
    public class AcceptedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Port number that was successfully bound.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("port")]
        public int Port
        {
            get;
            private set;
        }

        /// <summary>
        /// Connection id to be used.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("connectionId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string ConnectionId
        {
            get;
            private set;
        }
    }
}

namespace CefSharp.DevTools.Tracing
{
    /// <summary>
    /// Controls how the trace buffer stores data.
    /// </summary>
    public enum TraceConfigRecordMode
    {
        /// <summary>
        /// recordUntilFull
        /// </summary>
        [JsonPropertyName("recordUntilFull")]
        RecordUntilFull,
        /// <summary>
        /// recordContinuously
        /// </summary>
        [JsonPropertyName("recordContinuously")]
        RecordContinuously,
        /// <summary>
        /// recordAsMuchAsPossible
        /// </summary>
        [JsonPropertyName("recordAsMuchAsPossible")]
        RecordAsMuchAsPossible,
        /// <summary>
        /// echoToConsole
        /// </summary>
        [JsonPropertyName("echoToConsole")]
        EchoToConsole
    }

    /// <summary>
    /// TraceConfig
    /// </summary>
    public partial class TraceConfig : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Controls how the trace buffer stores data.
        /// </summary>
        [JsonPropertyName("recordMode")]
        public CefSharp.DevTools.Tracing.TraceConfigRecordMode? RecordMode
        {
            get;
            set;
        }

        /// <summary>
        /// Size of the trace buffer in kilobytes. If not specified or zero is passed, a default value
        /// of 200 MB would be used.
        /// </summary>
        [JsonPropertyName("traceBufferSizeInKb")]
        public double? TraceBufferSizeInKb
        {
            get;
            set;
        }

        /// <summary>
        /// Turns on JavaScript stack sampling.
        /// </summary>
        [JsonPropertyName("enableSampling")]
        public bool? EnableSampling
        {
            get;
            set;
        }

        /// <summary>
        /// Turns on system tracing.
        /// </summary>
        [JsonPropertyName("enableSystrace")]
        public bool? EnableSystrace
        {
            get;
            set;
        }

        /// <summary>
        /// Turns on argument filter.
        /// </summary>
        [JsonPropertyName("enableArgumentFilter")]
        public bool? EnableArgumentFilter
        {
            get;
            set;
        }

        /// <summary>
        /// Included category filters.
        /// </summary>
        [JsonPropertyName("includedCategories")]
        public string[] IncludedCategories
        {
            get;
            set;
        }

        /// <summary>
        /// Excluded category filters.
        /// </summary>
        [JsonPropertyName("excludedCategories")]
        public string[] ExcludedCategories
        {
            get;
            set;
        }

        /// <summary>
        /// Configuration to synthesize the delays in tracing.
        /// </summary>
        [JsonPropertyName("syntheticDelays")]
        public string[] SyntheticDelays
        {
            get;
            set;
        }

        /// <summary>
        /// Configuration for memory dump triggers. Used only when &quot;memory-infra&quot; category is enabled.
        /// </summary>
        [JsonPropertyName("memoryDumpConfig")]
        public CefSharp.DevTools.Tracing.MemoryDumpConfig MemoryDumpConfig
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Data format of a trace. Can be either the legacy JSON format or the
    /// protocol buffer format. Note that the JSON format will be deprecated soon.
    /// </summary>
    public enum StreamFormat
    {
        /// <summary>
        /// json
        /// </summary>
        [JsonPropertyName("json")]
        Json,
        /// <summary>
        /// proto
        /// </summary>
        [JsonPropertyName("proto")]
        Proto
    }

    /// <summary>
    /// Compression type to use for traces returned via streams.
    /// </summary>
    public enum StreamCompression
    {
        /// <summary>
        /// none
        /// </summary>
        [JsonPropertyName("none")]
        None,
        /// <summary>
        /// gzip
        /// </summary>
        [JsonPropertyName("gzip")]
        Gzip
    }

    /// <summary>
    /// Details exposed when memory request explicitly declared.
    /// Keep consistent with memory_dump_request_args.h and
    /// memory_instrumentation.mojom
    /// </summary>
    public enum MemoryDumpLevelOfDetail
    {
        /// <summary>
        /// background
        /// </summary>
        [JsonPropertyName("background")]
        Background,
        /// <summary>
        /// light
        /// </summary>
        [JsonPropertyName("light")]
        Light,
        /// <summary>
        /// detailed
        /// </summary>
        [JsonPropertyName("detailed")]
        Detailed
    }

    /// <summary>
    /// Backend type to use for tracing. `chrome` uses the Chrome-integrated
    /// tracing service and is supported on all platforms. `system` is only
    /// supported on Chrome OS and uses the Perfetto system tracing service.
    /// `auto` chooses `system` when the perfettoConfig provided to Tracing.start
    /// specifies at least one non-Chrome data source; otherwise uses `chrome`.
    /// </summary>
    public enum TracingBackend
    {
        /// <summary>
        /// auto
        /// </summary>
        [JsonPropertyName("auto")]
        Auto,
        /// <summary>
        /// chrome
        /// </summary>
        [JsonPropertyName("chrome")]
        Chrome,
        /// <summary>
        /// system
        /// </summary>
        [JsonPropertyName("system")]
        System
    }

    /// <summary>
    /// bufferUsage
    /// </summary>
    public class BufferUsageEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// A number in range [0..1] that indicates the used size of event buffer as a fraction of its
        /// total size.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("percentFull")]
        public double? PercentFull
        {
            get;
            private set;
        }

        /// <summary>
        /// An approximate number of events in the trace log.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("eventCount")]
        public double? EventCount
        {
            get;
            private set;
        }

        /// <summary>
        /// A number in range [0..1] that indicates the used size of event buffer as a fraction of its
        /// total size.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("value")]
        public double? Value
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Contains a bucket of collected trace events. When tracing is stopped collected events will be
    /// sent as a sequence of dataCollected events followed by tracingComplete event.
    /// </summary>
    public class DataCollectedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Value
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("value")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public System.Collections.Generic.IList<object> Value
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Signals that tracing is stopped and there is no trace buffers pending flush, all data were
    /// delivered via dataCollected events.
    /// </summary>
    public class TracingCompleteEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Indicates whether some trace data is known to have been lost, e.g. because the trace ring
        /// buffer wrapped around.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("dataLossOccurred")]
        public bool DataLossOccurred
        {
            get;
            private set;
        }

        /// <summary>
        /// A handle of the stream that holds resulting trace data.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("stream")]
        public string Stream
        {
            get;
            private set;
        }

        /// <summary>
        /// Trace data format of returned stream.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("traceFormat")]
        public CefSharp.DevTools.Tracing.StreamFormat? TraceFormat
        {
            get;
            private set;
        }

        /// <summary>
        /// Compression format of returned stream.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("streamCompression")]
        public CefSharp.DevTools.Tracing.StreamCompression? StreamCompression
        {
            get;
            private set;
        }
    }
}

namespace CefSharp.DevTools.Fetch
{
    /// <summary>
    /// Stages of the request to handle. Request will intercept before the request is
    /// sent. Response will intercept after the response is received (but before response
    /// body is received).
    /// </summary>
    public enum RequestStage
    {
        /// <summary>
        /// Request
        /// </summary>
        [JsonPropertyName("Request")]
        Request,
        /// <summary>
        /// Response
        /// </summary>
        [JsonPropertyName("Response")]
        Response
    }

    /// <summary>
    /// RequestPattern
    /// </summary>
    public partial class RequestPattern : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Wildcards (`&apos;*&apos;` -&gt; zero or more, `&apos;?&apos;` -&gt; exactly one) are allowed. Escape character is
        /// backslash. Omitting is equivalent to `&quot;*&quot;`.
        /// </summary>
        [JsonPropertyName("urlPattern")]
        public string UrlPattern
        {
            get;
            set;
        }

        /// <summary>
        /// If set, only requests for matching resource types will be intercepted.
        /// </summary>
        [JsonPropertyName("resourceType")]
        public CefSharp.DevTools.Network.ResourceType? ResourceType
        {
            get;
            set;
        }

        /// <summary>
        /// Stage at which to begin intercepting requests. Default is Request.
        /// </summary>
        [JsonPropertyName("requestStage")]
        public CefSharp.DevTools.Fetch.RequestStage? RequestStage
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Response HTTP header entry
    /// </summary>
    public partial class HeaderEntry : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Name
        /// </summary>
        [JsonPropertyName("name")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Name
        {
            get;
            set;
        }

        /// <summary>
        /// Value
        /// </summary>
        [JsonPropertyName("value")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Value
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Source of the authentication challenge.
    /// </summary>
    public enum AuthChallengeSource
    {
        /// <summary>
        /// Server
        /// </summary>
        [JsonPropertyName("Server")]
        Server,
        /// <summary>
        /// Proxy
        /// </summary>
        [JsonPropertyName("Proxy")]
        Proxy
    }

    /// <summary>
    /// Authorization challenge for HTTP status code 401 or 407.
    /// </summary>
    public partial class AuthChallenge : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Source of the authentication challenge.
        /// </summary>
        [JsonPropertyName("source")]
        public CefSharp.DevTools.Fetch.AuthChallengeSource? Source
        {
            get;
            set;
        }

        /// <summary>
        /// Origin of the challenger.
        /// </summary>
        [JsonPropertyName("origin")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Origin
        {
            get;
            set;
        }

        /// <summary>
        /// The authentication scheme used, such as basic or digest
        /// </summary>
        [JsonPropertyName("scheme")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Scheme
        {
            get;
            set;
        }

        /// <summary>
        /// The realm of the challenge. May be empty.
        /// </summary>
        [JsonPropertyName("realm")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Realm
        {
            get;
            set;
        }
    }

    /// <summary>
    /// The decision on what to do in response to the authorization challenge.  Default means
    /// deferring to the default behavior of the net stack, which will likely either the Cancel
    /// authentication or display a popup dialog box.
    /// </summary>
    public enum AuthChallengeResponseResponse
    {
        /// <summary>
        /// Default
        /// </summary>
        [JsonPropertyName("Default")]
        Default,
        /// <summary>
        /// CancelAuth
        /// </summary>
        [JsonPropertyName("CancelAuth")]
        CancelAuth,
        /// <summary>
        /// ProvideCredentials
        /// </summary>
        [JsonPropertyName("ProvideCredentials")]
        ProvideCredentials
    }

    /// <summary>
    /// Response to an AuthChallenge.
    /// </summary>
    public partial class AuthChallengeResponse : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The decision on what to do in response to the authorization challenge.  Default means
        /// deferring to the default behavior of the net stack, which will likely either the Cancel
        /// authentication or display a popup dialog box.
        /// </summary>
        [JsonPropertyName("response")]
        public CefSharp.DevTools.Fetch.AuthChallengeResponseResponse Response
        {
            get;
            set;
        }

        /// <summary>
        /// The username to provide, possibly empty. Should only be set if response is
        /// ProvideCredentials.
        /// </summary>
        [JsonPropertyName("username")]
        public string Username
        {
            get;
            set;
        }

        /// <summary>
        /// The password to provide, possibly empty. Should only be set if response is
        /// ProvideCredentials.
        /// </summary>
        [JsonPropertyName("password")]
        public string Password
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Issued when the domain is enabled and the request URL matches the
    /// specified filter. The request is paused until the client responds
    /// with one of continueRequest, failRequest or fulfillRequest.
    /// The stage of the request can be determined by presence of responseErrorReason
    /// and responseStatusCode -- the request is at the response stage if either
    /// of these fields is present and in the request stage otherwise.
    /// Redirect responses and subsequent requests are reported similarly to regular
    /// responses and requests. Redirect responses may be distinguished by the value
    /// of `responseStatusCode` (which is one of 301, 302, 303, 307, 308) along with
    /// presence of the `location` header. Requests resulting from a redirect will
    /// have `redirectedRequestId` field set.
    /// </summary>
    public class RequestPausedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Each request the page makes will have a unique id.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("requestId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string RequestId
        {
            get;
            private set;
        }

        /// <summary>
        /// The details of the request.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("request")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.Network.Request Request
        {
            get;
            private set;
        }

        /// <summary>
        /// The id of the frame that initiated the request.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("frameId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string FrameId
        {
            get;
            private set;
        }

        /// <summary>
        /// How the requested resource will be used.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("resourceType")]
        public CefSharp.DevTools.Network.ResourceType ResourceType
        {
            get;
            private set;
        }

        /// <summary>
        /// Response error if intercepted at response stage.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("responseErrorReason")]
        public CefSharp.DevTools.Network.ErrorReason? ResponseErrorReason
        {
            get;
            private set;
        }

        /// <summary>
        /// Response code if intercepted at response stage.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("responseStatusCode")]
        public int? ResponseStatusCode
        {
            get;
            private set;
        }

        /// <summary>
        /// Response status text if intercepted at response stage.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("responseStatusText")]
        public string ResponseStatusText
        {
            get;
            private set;
        }

        /// <summary>
        /// Response headers if intercepted at the response stage.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("responseHeaders")]
        public System.Collections.Generic.IList<CefSharp.DevTools.Fetch.HeaderEntry> ResponseHeaders
        {
            get;
            private set;
        }

        /// <summary>
        /// If the intercepted request had a corresponding Network.requestWillBeSent event fired for it,
        /// then this networkId will be the same as the requestId present in the requestWillBeSent event.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("networkId")]
        public string NetworkId
        {
            get;
            private set;
        }

        /// <summary>
        /// If the request is due to a redirect response from the server, the id of the request that
        /// has caused the redirect.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("redirectedRequestId")]
        public string RedirectedRequestId
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Issued when the domain is enabled with handleAuthRequests set to true.
    /// The request is paused until client responds with continueWithAuth.
    /// </summary>
    public class AuthRequiredEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Each request the page makes will have a unique id.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("requestId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string RequestId
        {
            get;
            private set;
        }

        /// <summary>
        /// The details of the request.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("request")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.Network.Request Request
        {
            get;
            private set;
        }

        /// <summary>
        /// The id of the frame that initiated the request.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("frameId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string FrameId
        {
            get;
            private set;
        }

        /// <summary>
        /// How the requested resource will be used.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("resourceType")]
        public CefSharp.DevTools.Network.ResourceType ResourceType
        {
            get;
            private set;
        }

        /// <summary>
        /// Details of the Authorization Challenge encountered.
        /// If this is set, client should respond with continueRequest that
        /// contains AuthChallengeResponse.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("authChallenge")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.Fetch.AuthChallenge AuthChallenge
        {
            get;
            private set;
        }
    }
}

namespace CefSharp.DevTools.WebAudio
{
    /// <summary>
    /// Enum of BaseAudioContext types
    /// </summary>
    public enum ContextType
    {
        /// <summary>
        /// realtime
        /// </summary>
        [JsonPropertyName("realtime")]
        Realtime,
        /// <summary>
        /// offline
        /// </summary>
        [JsonPropertyName("offline")]
        Offline
    }

    /// <summary>
    /// Enum of AudioContextState from the spec
    /// </summary>
    public enum ContextState
    {
        /// <summary>
        /// suspended
        /// </summary>
        [JsonPropertyName("suspended")]
        Suspended,
        /// <summary>
        /// running
        /// </summary>
        [JsonPropertyName("running")]
        Running,
        /// <summary>
        /// closed
        /// </summary>
        [JsonPropertyName("closed")]
        Closed
    }

    /// <summary>
    /// Enum of AudioNode::ChannelCountMode from the spec
    /// </summary>
    public enum ChannelCountMode
    {
        /// <summary>
        /// clamped-max
        /// </summary>
        [JsonPropertyName("clamped-max")]
        ClampedMax,
        /// <summary>
        /// explicit
        /// </summary>
        [JsonPropertyName("explicit")]
        Explicit,
        /// <summary>
        /// max
        /// </summary>
        [JsonPropertyName("max")]
        Max
    }

    /// <summary>
    /// Enum of AudioNode::ChannelInterpretation from the spec
    /// </summary>
    public enum ChannelInterpretation
    {
        /// <summary>
        /// discrete
        /// </summary>
        [JsonPropertyName("discrete")]
        Discrete,
        /// <summary>
        /// speakers
        /// </summary>
        [JsonPropertyName("speakers")]
        Speakers
    }

    /// <summary>
    /// Enum of AudioParam::AutomationRate from the spec
    /// </summary>
    public enum AutomationRate
    {
        /// <summary>
        /// a-rate
        /// </summary>
        [JsonPropertyName("a-rate")]
        ARate,
        /// <summary>
        /// k-rate
        /// </summary>
        [JsonPropertyName("k-rate")]
        KRate
    }

    /// <summary>
    /// Fields in AudioContext that change in real-time.
    /// </summary>
    public partial class ContextRealtimeData : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The current context time in second in BaseAudioContext.
        /// </summary>
        [JsonPropertyName("currentTime")]
        public double CurrentTime
        {
            get;
            set;
        }

        /// <summary>
        /// The time spent on rendering graph divided by render quantum duration,
        /// and multiplied by 100. 100 means the audio renderer reached the full
        /// capacity and glitch may occur.
        /// </summary>
        [JsonPropertyName("renderCapacity")]
        public double RenderCapacity
        {
            get;
            set;
        }

        /// <summary>
        /// A running mean of callback interval.
        /// </summary>
        [JsonPropertyName("callbackIntervalMean")]
        public double CallbackIntervalMean
        {
            get;
            set;
        }

        /// <summary>
        /// A running variance of callback interval.
        /// </summary>
        [JsonPropertyName("callbackIntervalVariance")]
        public double CallbackIntervalVariance
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Protocol object for BaseAudioContext
    /// </summary>
    public partial class BaseAudioContext : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// ContextId
        /// </summary>
        [JsonPropertyName("contextId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string ContextId
        {
            get;
            set;
        }

        /// <summary>
        /// ContextType
        /// </summary>
        [JsonPropertyName("contextType")]
        public CefSharp.DevTools.WebAudio.ContextType ContextType
        {
            get;
            set;
        }

        /// <summary>
        /// ContextState
        /// </summary>
        [JsonPropertyName("contextState")]
        public CefSharp.DevTools.WebAudio.ContextState ContextState
        {
            get;
            set;
        }

        /// <summary>
        /// RealtimeData
        /// </summary>
        [JsonPropertyName("realtimeData")]
        public CefSharp.DevTools.WebAudio.ContextRealtimeData RealtimeData
        {
            get;
            set;
        }

        /// <summary>
        /// Platform-dependent callback buffer size.
        /// </summary>
        [JsonPropertyName("callbackBufferSize")]
        public double CallbackBufferSize
        {
            get;
            set;
        }

        /// <summary>
        /// Number of output channels supported by audio hardware in use.
        /// </summary>
        [JsonPropertyName("maxOutputChannelCount")]
        public double MaxOutputChannelCount
        {
            get;
            set;
        }

        /// <summary>
        /// Context sample rate.
        /// </summary>
        [JsonPropertyName("sampleRate")]
        public double SampleRate
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Protocol object for AudioListener
    /// </summary>
    public partial class AudioListener : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// ListenerId
        /// </summary>
        [JsonPropertyName("listenerId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string ListenerId
        {
            get;
            set;
        }

        /// <summary>
        /// ContextId
        /// </summary>
        [JsonPropertyName("contextId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string ContextId
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Protocol object for AudioNode
    /// </summary>
    public partial class AudioNode : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// NodeId
        /// </summary>
        [JsonPropertyName("nodeId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string NodeId
        {
            get;
            set;
        }

        /// <summary>
        /// ContextId
        /// </summary>
        [JsonPropertyName("contextId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string ContextId
        {
            get;
            set;
        }

        /// <summary>
        /// NodeType
        /// </summary>
        [JsonPropertyName("nodeType")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string NodeType
        {
            get;
            set;
        }

        /// <summary>
        /// NumberOfInputs
        /// </summary>
        [JsonPropertyName("numberOfInputs")]
        public double NumberOfInputs
        {
            get;
            set;
        }

        /// <summary>
        /// NumberOfOutputs
        /// </summary>
        [JsonPropertyName("numberOfOutputs")]
        public double NumberOfOutputs
        {
            get;
            set;
        }

        /// <summary>
        /// ChannelCount
        /// </summary>
        [JsonPropertyName("channelCount")]
        public double ChannelCount
        {
            get;
            set;
        }

        /// <summary>
        /// ChannelCountMode
        /// </summary>
        [JsonPropertyName("channelCountMode")]
        public CefSharp.DevTools.WebAudio.ChannelCountMode ChannelCountMode
        {
            get;
            set;
        }

        /// <summary>
        /// ChannelInterpretation
        /// </summary>
        [JsonPropertyName("channelInterpretation")]
        public CefSharp.DevTools.WebAudio.ChannelInterpretation ChannelInterpretation
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Protocol object for AudioParam
    /// </summary>
    public partial class AudioParam : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// ParamId
        /// </summary>
        [JsonPropertyName("paramId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string ParamId
        {
            get;
            set;
        }

        /// <summary>
        /// NodeId
        /// </summary>
        [JsonPropertyName("nodeId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string NodeId
        {
            get;
            set;
        }

        /// <summary>
        /// ContextId
        /// </summary>
        [JsonPropertyName("contextId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string ContextId
        {
            get;
            set;
        }

        /// <summary>
        /// ParamType
        /// </summary>
        [JsonPropertyName("paramType")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string ParamType
        {
            get;
            set;
        }

        /// <summary>
        /// Rate
        /// </summary>
        [JsonPropertyName("rate")]
        public CefSharp.DevTools.WebAudio.AutomationRate Rate
        {
            get;
            set;
        }

        /// <summary>
        /// DefaultValue
        /// </summary>
        [JsonPropertyName("defaultValue")]
        public double DefaultValue
        {
            get;
            set;
        }

        /// <summary>
        /// MinValue
        /// </summary>
        [JsonPropertyName("minValue")]
        public double MinValue
        {
            get;
            set;
        }

        /// <summary>
        /// MaxValue
        /// </summary>
        [JsonPropertyName("maxValue")]
        public double MaxValue
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Notifies that a new BaseAudioContext has been created.
    /// </summary>
    public class ContextCreatedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Context
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("context")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.WebAudio.BaseAudioContext Context
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Notifies that an existing BaseAudioContext will be destroyed.
    /// </summary>
    public class ContextWillBeDestroyedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// ContextId
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("contextId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string ContextId
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Notifies that existing BaseAudioContext has changed some properties (id stays the same)..
    /// </summary>
    public class ContextChangedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Context
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("context")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.WebAudio.BaseAudioContext Context
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Notifies that the construction of an AudioListener has finished.
    /// </summary>
    public class AudioListenerCreatedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Listener
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("listener")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.WebAudio.AudioListener Listener
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Notifies that a new AudioListener has been created.
    /// </summary>
    public class AudioListenerWillBeDestroyedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// ContextId
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("contextId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string ContextId
        {
            get;
            private set;
        }

        /// <summary>
        /// ListenerId
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("listenerId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string ListenerId
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Notifies that a new AudioNode has been created.
    /// </summary>
    public class AudioNodeCreatedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Node
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("node")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.WebAudio.AudioNode Node
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Notifies that an existing AudioNode has been destroyed.
    /// </summary>
    public class AudioNodeWillBeDestroyedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// ContextId
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("contextId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string ContextId
        {
            get;
            private set;
        }

        /// <summary>
        /// NodeId
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("nodeId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string NodeId
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Notifies that a new AudioParam has been created.
    /// </summary>
    public class AudioParamCreatedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Param
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("param")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.WebAudio.AudioParam Param
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Notifies that an existing AudioParam has been destroyed.
    /// </summary>
    public class AudioParamWillBeDestroyedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// ContextId
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("contextId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string ContextId
        {
            get;
            private set;
        }

        /// <summary>
        /// NodeId
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("nodeId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string NodeId
        {
            get;
            private set;
        }

        /// <summary>
        /// ParamId
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("paramId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string ParamId
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Notifies that two AudioNodes are connected.
    /// </summary>
    public class NodesConnectedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// ContextId
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("contextId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string ContextId
        {
            get;
            private set;
        }

        /// <summary>
        /// SourceId
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("sourceId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string SourceId
        {
            get;
            private set;
        }

        /// <summary>
        /// DestinationId
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("destinationId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string DestinationId
        {
            get;
            private set;
        }

        /// <summary>
        /// SourceOutputIndex
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("sourceOutputIndex")]
        public double? SourceOutputIndex
        {
            get;
            private set;
        }

        /// <summary>
        /// DestinationInputIndex
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("destinationInputIndex")]
        public double? DestinationInputIndex
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Notifies that AudioNodes are disconnected. The destination can be null, and it means all the outgoing connections from the source are disconnected.
    /// </summary>
    public class NodesDisconnectedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// ContextId
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("contextId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string ContextId
        {
            get;
            private set;
        }

        /// <summary>
        /// SourceId
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("sourceId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string SourceId
        {
            get;
            private set;
        }

        /// <summary>
        /// DestinationId
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("destinationId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string DestinationId
        {
            get;
            private set;
        }

        /// <summary>
        /// SourceOutputIndex
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("sourceOutputIndex")]
        public double? SourceOutputIndex
        {
            get;
            private set;
        }

        /// <summary>
        /// DestinationInputIndex
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("destinationInputIndex")]
        public double? DestinationInputIndex
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Notifies that an AudioNode is connected to an AudioParam.
    /// </summary>
    public class NodeParamConnectedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// ContextId
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("contextId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string ContextId
        {
            get;
            private set;
        }

        /// <summary>
        /// SourceId
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("sourceId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string SourceId
        {
            get;
            private set;
        }

        /// <summary>
        /// DestinationId
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("destinationId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string DestinationId
        {
            get;
            private set;
        }

        /// <summary>
        /// SourceOutputIndex
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("sourceOutputIndex")]
        public double? SourceOutputIndex
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Notifies that an AudioNode is disconnected to an AudioParam.
    /// </summary>
    public class NodeParamDisconnectedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// ContextId
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("contextId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string ContextId
        {
            get;
            private set;
        }

        /// <summary>
        /// SourceId
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("sourceId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string SourceId
        {
            get;
            private set;
        }

        /// <summary>
        /// DestinationId
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("destinationId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string DestinationId
        {
            get;
            private set;
        }

        /// <summary>
        /// SourceOutputIndex
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("sourceOutputIndex")]
        public double? SourceOutputIndex
        {
            get;
            private set;
        }
    }
}

namespace CefSharp.DevTools.WebAuthn
{
    /// <summary>
    /// AuthenticatorProtocol
    /// </summary>
    public enum AuthenticatorProtocol
    {
        /// <summary>
        /// u2f
        /// </summary>
        [JsonPropertyName("u2f")]
        U2f,
        /// <summary>
        /// ctap2
        /// </summary>
        [JsonPropertyName("ctap2")]
        Ctap2
    }

    /// <summary>
    /// Ctap2Version
    /// </summary>
    public enum Ctap2Version
    {
        /// <summary>
        /// ctap2_0
        /// </summary>
        [JsonPropertyName("ctap2_0")]
        Ctap20,
        /// <summary>
        /// ctap2_1
        /// </summary>
        [JsonPropertyName("ctap2_1")]
        Ctap21
    }

    /// <summary>
    /// AuthenticatorTransport
    /// </summary>
    public enum AuthenticatorTransport
    {
        /// <summary>
        /// usb
        /// </summary>
        [JsonPropertyName("usb")]
        Usb,
        /// <summary>
        /// nfc
        /// </summary>
        [JsonPropertyName("nfc")]
        Nfc,
        /// <summary>
        /// ble
        /// </summary>
        [JsonPropertyName("ble")]
        Ble,
        /// <summary>
        /// cable
        /// </summary>
        [JsonPropertyName("cable")]
        Cable,
        /// <summary>
        /// internal
        /// </summary>
        [JsonPropertyName("internal")]
        Internal
    }

    /// <summary>
    /// VirtualAuthenticatorOptions
    /// </summary>
    public partial class VirtualAuthenticatorOptions : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Protocol
        /// </summary>
        [JsonPropertyName("protocol")]
        public CefSharp.DevTools.WebAuthn.AuthenticatorProtocol Protocol
        {
            get;
            set;
        }

        /// <summary>
        /// Defaults to ctap2_0. Ignored if |protocol| == u2f.
        /// </summary>
        [JsonPropertyName("ctap2Version")]
        public CefSharp.DevTools.WebAuthn.Ctap2Version? Ctap2Version
        {
            get;
            set;
        }

        /// <summary>
        /// Transport
        /// </summary>
        [JsonPropertyName("transport")]
        public CefSharp.DevTools.WebAuthn.AuthenticatorTransport Transport
        {
            get;
            set;
        }

        /// <summary>
        /// Defaults to false.
        /// </summary>
        [JsonPropertyName("hasResidentKey")]
        public bool? HasResidentKey
        {
            get;
            set;
        }

        /// <summary>
        /// Defaults to false.
        /// </summary>
        [JsonPropertyName("hasUserVerification")]
        public bool? HasUserVerification
        {
            get;
            set;
        }

        /// <summary>
        /// If set to true, the authenticator will support the largeBlob extension.
        /// https://w3c.github.io/webauthn#largeBlob
        /// Defaults to false.
        /// </summary>
        [JsonPropertyName("hasLargeBlob")]
        public bool? HasLargeBlob
        {
            get;
            set;
        }

        /// <summary>
        /// If set to true, the authenticator will support the credBlob extension.
        /// https://fidoalliance.org/specs/fido-v2.1-rd-20201208/fido-client-to-authenticator-protocol-v2.1-rd-20201208.html#sctn-credBlob-extension
        /// Defaults to false.
        /// </summary>
        [JsonPropertyName("hasCredBlob")]
        public bool? HasCredBlob
        {
            get;
            set;
        }

        /// <summary>
        /// If set to true, the authenticator will support the minPinLength extension.
        /// https://fidoalliance.org/specs/fido-v2.1-ps-20210615/fido-client-to-authenticator-protocol-v2.1-ps-20210615.html#sctn-minpinlength-extension
        /// Defaults to false.
        /// </summary>
        [JsonPropertyName("hasMinPinLength")]
        public bool? HasMinPinLength
        {
            get;
            set;
        }

        /// <summary>
        /// If set to true, the authenticator will support the prf extension.
        /// https://w3c.github.io/webauthn/#prf-extension
        /// Defaults to false.
        /// </summary>
        [JsonPropertyName("hasPrf")]
        public bool? HasPrf
        {
            get;
            set;
        }

        /// <summary>
        /// If set to true, tests of user presence will succeed immediately.
        /// Otherwise, they will not be resolved. Defaults to true.
        /// </summary>
        [JsonPropertyName("automaticPresenceSimulation")]
        public bool? AutomaticPresenceSimulation
        {
            get;
            set;
        }

        /// <summary>
        /// Sets whether User Verification succeeds or fails for an authenticator.
        /// Defaults to false.
        /// </summary>
        [JsonPropertyName("isUserVerified")]
        public bool? IsUserVerified
        {
            get;
            set;
        }

        /// <summary>
        /// Credentials created by this authenticator will have the backup
        /// eligibility (BE) flag set to this value. Defaults to false.
        /// https://w3c.github.io/webauthn/#sctn-credential-backup
        /// </summary>
        [JsonPropertyName("defaultBackupEligibility")]
        public bool? DefaultBackupEligibility
        {
            get;
            set;
        }

        /// <summary>
        /// Credentials created by this authenticator will have the backup state
        /// (BS) flag set to this value. Defaults to false.
        /// https://w3c.github.io/webauthn/#sctn-credential-backup
        /// </summary>
        [JsonPropertyName("defaultBackupState")]
        public bool? DefaultBackupState
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Credential
    /// </summary>
    public partial class Credential : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// CredentialId
        /// </summary>
        [JsonPropertyName("credentialId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public byte[] CredentialId
        {
            get;
            set;
        }

        /// <summary>
        /// IsResidentCredential
        /// </summary>
        [JsonPropertyName("isResidentCredential")]
        public bool IsResidentCredential
        {
            get;
            set;
        }

        /// <summary>
        /// Relying Party ID the credential is scoped to. Must be set when adding a
        /// credential.
        /// </summary>
        [JsonPropertyName("rpId")]
        public string RpId
        {
            get;
            set;
        }

        /// <summary>
        /// The ECDSA P-256 private key in PKCS#8 format.
        /// </summary>
        [JsonPropertyName("privateKey")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public byte[] PrivateKey
        {
            get;
            set;
        }

        /// <summary>
        /// An opaque byte sequence with a maximum size of 64 bytes mapping the
        /// credential to a specific user.
        /// </summary>
        [JsonPropertyName("userHandle")]
        public byte[] UserHandle
        {
            get;
            set;
        }

        /// <summary>
        /// Signature counter. This is incremented by one for each successful
        /// assertion.
        /// See https://w3c.github.io/webauthn/#signature-counter
        /// </summary>
        [JsonPropertyName("signCount")]
        public int SignCount
        {
            get;
            set;
        }

        /// <summary>
        /// The large blob associated with the credential.
        /// See https://w3c.github.io/webauthn/#sctn-large-blob-extension
        /// </summary>
        [JsonPropertyName("largeBlob")]
        public byte[] LargeBlob
        {
            get;
            set;
        }

        /// <summary>
        /// Assertions returned by this credential will have the backup eligibility
        /// (BE) flag set to this value. Defaults to the authenticator&apos;s
        /// defaultBackupEligibility value.
        /// </summary>
        [JsonPropertyName("backupEligibility")]
        public bool? BackupEligibility
        {
            get;
            set;
        }

        /// <summary>
        /// Assertions returned by this credential will have the backup state (BS)
        /// flag set to this value. Defaults to the authenticator&apos;s
        /// defaultBackupState value.
        /// </summary>
        [JsonPropertyName("backupState")]
        public bool? BackupState
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Triggered when a credential is added to an authenticator.
    /// </summary>
    public class CredentialAddedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// AuthenticatorId
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("authenticatorId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string AuthenticatorId
        {
            get;
            private set;
        }

        /// <summary>
        /// Credential
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("credential")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.WebAuthn.Credential Credential
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Triggered when a credential is used in a webauthn assertion.
    /// </summary>
    public class CredentialAssertedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// AuthenticatorId
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("authenticatorId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string AuthenticatorId
        {
            get;
            private set;
        }

        /// <summary>
        /// Credential
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("credential")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.WebAuthn.Credential Credential
        {
            get;
            private set;
        }
    }
}

namespace CefSharp.DevTools.Media
{
    /// <summary>
    /// Keep in sync with MediaLogMessageLevel
    /// We are currently keeping the message level &apos;error&apos; separate from the
    /// PlayerError type because right now they represent different things,
    /// this one being a DVLOG(ERROR) style log message that gets printed
    /// based on what log level is selected in the UI, and the other is a
    /// representation of a media::PipelineStatus object. Soon however we&apos;re
    /// going to be moving away from using PipelineStatus for errors and
    /// introducing a new error type which should hopefully let us integrate
    /// the error log level into the PlayerError type.
    /// </summary>
    public enum PlayerMessageLevel
    {
        /// <summary>
        /// error
        /// </summary>
        [JsonPropertyName("error")]
        Error,
        /// <summary>
        /// warning
        /// </summary>
        [JsonPropertyName("warning")]
        Warning,
        /// <summary>
        /// info
        /// </summary>
        [JsonPropertyName("info")]
        Info,
        /// <summary>
        /// debug
        /// </summary>
        [JsonPropertyName("debug")]
        Debug
    }

    /// <summary>
    /// Have one type per entry in MediaLogRecord::Type
    /// Corresponds to kMessage
    /// </summary>
    public partial class PlayerMessage : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Keep in sync with MediaLogMessageLevel
        /// We are currently keeping the message level &apos;error&apos; separate from the
        /// PlayerError type because right now they represent different things,
        /// this one being a DVLOG(ERROR) style log message that gets printed
        /// based on what log level is selected in the UI, and the other is a
        /// representation of a media::PipelineStatus object. Soon however we&apos;re
        /// going to be moving away from using PipelineStatus for errors and
        /// introducing a new error type which should hopefully let us integrate
        /// the error log level into the PlayerError type.
        /// </summary>
        [JsonPropertyName("level")]
        public CefSharp.DevTools.Media.PlayerMessageLevel Level
        {
            get;
            set;
        }

        /// <summary>
        /// Message
        /// </summary>
        [JsonPropertyName("message")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Message
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Corresponds to kMediaPropertyChange
    /// </summary>
    public partial class PlayerProperty : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Name
        /// </summary>
        [JsonPropertyName("name")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Name
        {
            get;
            set;
        }

        /// <summary>
        /// Value
        /// </summary>
        [JsonPropertyName("value")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Value
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Corresponds to kMediaEventTriggered
    /// </summary>
    public partial class PlayerEvent : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Timestamp
        /// </summary>
        [JsonPropertyName("timestamp")]
        public double Timestamp
        {
            get;
            set;
        }

        /// <summary>
        /// Value
        /// </summary>
        [JsonPropertyName("value")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Value
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Represents logged source line numbers reported in an error.
    /// NOTE: file and line are from chromium c++ implementation code, not js.
    /// </summary>
    public partial class PlayerErrorSourceLocation : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// File
        /// </summary>
        [JsonPropertyName("file")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string File
        {
            get;
            set;
        }

        /// <summary>
        /// Line
        /// </summary>
        [JsonPropertyName("line")]
        public int Line
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Corresponds to kMediaError
    /// </summary>
    public partial class PlayerError : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// ErrorType
        /// </summary>
        [JsonPropertyName("errorType")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string ErrorType
        {
            get;
            set;
        }

        /// <summary>
        /// Code is the numeric enum entry for a specific set of error codes, such
        /// as PipelineStatusCodes in media/base/pipeline_status.h
        /// </summary>
        [JsonPropertyName("code")]
        public int Code
        {
            get;
            set;
        }

        /// <summary>
        /// A trace of where this error was caused / where it passed through.
        /// </summary>
        [JsonPropertyName("stack")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public System.Collections.Generic.IList<CefSharp.DevTools.Media.PlayerErrorSourceLocation> Stack
        {
            get;
            set;
        }

        /// <summary>
        /// Errors potentially have a root cause error, ie, a DecoderError might be
        /// caused by an WindowsError
        /// </summary>
        [JsonPropertyName("cause")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public System.Collections.Generic.IList<CefSharp.DevTools.Media.PlayerError> Cause
        {
            get;
            set;
        }

        /// <summary>
        /// Extra data attached to an error, such as an HRESULT, Video Codec, etc.
        /// </summary>
        [JsonPropertyName("data")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public object Data
        {
            get;
            set;
        }
    }

    /// <summary>
    /// This can be called multiple times, and can be used to set / override /
    /// remove player properties. A null propValue indicates removal.
    /// </summary>
    public class PlayerPropertiesChangedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// PlayerId
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("playerId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string PlayerId
        {
            get;
            private set;
        }

        /// <summary>
        /// Properties
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("properties")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public System.Collections.Generic.IList<CefSharp.DevTools.Media.PlayerProperty> Properties
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Send events as a list, allowing them to be batched on the browser for less
    /// congestion. If batched, events must ALWAYS be in chronological order.
    /// </summary>
    public class PlayerEventsAddedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// PlayerId
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("playerId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string PlayerId
        {
            get;
            private set;
        }

        /// <summary>
        /// Events
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("events")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public System.Collections.Generic.IList<CefSharp.DevTools.Media.PlayerEvent> Events
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Send a list of any messages that need to be delivered.
    /// </summary>
    public class PlayerMessagesLoggedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// PlayerId
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("playerId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string PlayerId
        {
            get;
            private set;
        }

        /// <summary>
        /// Messages
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("messages")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public System.Collections.Generic.IList<CefSharp.DevTools.Media.PlayerMessage> Messages
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Send a list of any errors that need to be delivered.
    /// </summary>
    public class PlayerErrorsRaisedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// PlayerId
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("playerId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string PlayerId
        {
            get;
            private set;
        }

        /// <summary>
        /// Errors
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("errors")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public System.Collections.Generic.IList<CefSharp.DevTools.Media.PlayerError> Errors
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Called whenever a player is created, or when a new agent joins and receives
    /// a list of active players. If an agent is restored, it will receive the full
    /// list of player ids and all events again.
    /// </summary>
    public class PlayersCreatedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Players
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("players")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string[] Players
        {
            get;
            private set;
        }
    }
}

namespace CefSharp.DevTools.DeviceAccess
{
    /// <summary>
    /// Device information displayed in a user prompt to select a device.
    /// </summary>
    public partial class PromptDevice : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Id
        /// </summary>
        [JsonPropertyName("id")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Id
        {
            get;
            set;
        }

        /// <summary>
        /// Display name as it appears in a device request user prompt.
        /// </summary>
        [JsonPropertyName("name")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Name
        {
            get;
            set;
        }
    }

    /// <summary>
    /// A device request opened a user prompt to select a device. Respond with the
    /// selectPrompt or cancelPrompt command.
    /// </summary>
    public class DeviceRequestPromptedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Id
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("id")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Id
        {
            get;
            private set;
        }

        /// <summary>
        /// Devices
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("devices")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public System.Collections.Generic.IList<CefSharp.DevTools.DeviceAccess.PromptDevice> Devices
        {
            get;
            private set;
        }
    }
}

namespace CefSharp.DevTools.Preload
{
    /// <summary>
    /// Corresponds to SpeculationRuleSet
    /// </summary>
    public partial class RuleSet : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Id
        /// </summary>
        [JsonPropertyName("id")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Id
        {
            get;
            set;
        }

        /// <summary>
        /// Identifies a document which the rule set is associated with.
        /// </summary>
        [JsonPropertyName("loaderId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string LoaderId
        {
            get;
            set;
        }

        /// <summary>
        /// Source text of JSON representing the rule set. If it comes from
        /// `&lt;script&gt;` tag, it is the textContent of the node. Note that it is
        /// a JSON for valid case.
        /// 
        /// See also:
        /// - https://wicg.github.io/nav-speculation/speculation-rules.html
        /// - https://github.com/WICG/nav-speculation/blob/main/triggers.md
        /// </summary>
        [JsonPropertyName("sourceText")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string SourceText
        {
            get;
            set;
        }

        /// <summary>
        /// A speculation rule set is either added through an inline
        /// `&lt;script&gt;` tag or through an external resource via the
        /// &apos;Speculation-Rules&apos; HTTP header. For the first case, we include
        /// the BackendNodeId of the relevant `&lt;script&gt;` tag. For the second
        /// case, we include the external URL where the rule set was loaded
        /// from, and also RequestId if Network domain is enabled.
        /// 
        /// See also:
        /// - https://wicg.github.io/nav-speculation/speculation-rules.html#speculation-rules-script
        /// - https://wicg.github.io/nav-speculation/speculation-rules.html#speculation-rules-header
        /// </summary>
        [JsonPropertyName("backendNodeId")]
        public int? BackendNodeId
        {
            get;
            set;
        }

        /// <summary>
        /// Url
        /// </summary>
        [JsonPropertyName("url")]
        public string Url
        {
            get;
            set;
        }

        /// <summary>
        /// RequestId
        /// </summary>
        [JsonPropertyName("requestId")]
        public string RequestId
        {
            get;
            set;
        }

        /// <summary>
        /// Error information
        /// `errorMessage` is null iff `errorType` is null.
        /// </summary>
        [JsonPropertyName("errorType")]
        public CefSharp.DevTools.Preload.RuleSetErrorType? ErrorType
        {
            get;
            set;
        }

        /// <summary>
        /// TODO(https://crbug.com/1425354): Replace this property with structured error.
        /// </summary>
        [JsonPropertyName("errorMessage")]
        public string ErrorMessage
        {
            get;
            set;
        }
    }

    /// <summary>
    /// RuleSetErrorType
    /// </summary>
    public enum RuleSetErrorType
    {
        /// <summary>
        /// SourceIsNotJsonObject
        /// </summary>
        [JsonPropertyName("SourceIsNotJsonObject")]
        SourceIsNotJsonObject,
        /// <summary>
        /// InvalidRulesSkipped
        /// </summary>
        [JsonPropertyName("InvalidRulesSkipped")]
        InvalidRulesSkipped
    }

    /// <summary>
    /// The type of preloading attempted. It corresponds to
    /// mojom::SpeculationAction (although PrefetchWithSubresources is omitted as it
    /// isn&apos;t being used by clients).
    /// </summary>
    public enum SpeculationAction
    {
        /// <summary>
        /// Prefetch
        /// </summary>
        [JsonPropertyName("Prefetch")]
        Prefetch,
        /// <summary>
        /// Prerender
        /// </summary>
        [JsonPropertyName("Prerender")]
        Prerender
    }

    /// <summary>
    /// Corresponds to mojom::SpeculationTargetHint.
    /// See https://github.com/WICG/nav-speculation/blob/main/triggers.md#window-name-targeting-hints
    /// </summary>
    public enum SpeculationTargetHint
    {
        /// <summary>
        /// Blank
        /// </summary>
        [JsonPropertyName("Blank")]
        Blank,
        /// <summary>
        /// Self
        /// </summary>
        [JsonPropertyName("Self")]
        Self
    }

    /// <summary>
    /// A key that identifies a preloading attempt.
    /// 
    /// The url used is the url specified by the trigger (i.e. the initial URL), and
    /// not the final url that is navigated to. For example, prerendering allows
    /// same-origin main frame navigations during the attempt, but the attempt is
    /// still keyed with the initial URL.
    /// </summary>
    public partial class PreloadingAttemptKey : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// LoaderId
        /// </summary>
        [JsonPropertyName("loaderId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string LoaderId
        {
            get;
            set;
        }

        /// <summary>
        /// Action
        /// </summary>
        [JsonPropertyName("action")]
        public CefSharp.DevTools.Preload.SpeculationAction Action
        {
            get;
            set;
        }

        /// <summary>
        /// Url
        /// </summary>
        [JsonPropertyName("url")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Url
        {
            get;
            set;
        }

        /// <summary>
        /// TargetHint
        /// </summary>
        [JsonPropertyName("targetHint")]
        public CefSharp.DevTools.Preload.SpeculationTargetHint? TargetHint
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Lists sources for a preloading attempt, specifically the ids of rule sets
    /// that had a speculation rule that triggered the attempt, and the
    /// BackendNodeIds of &lt;a href&gt; or &lt;area href&gt; elements that triggered the
    /// attempt (in the case of attempts triggered by a document rule). It is
    /// possible for multiple rule sets and links to trigger a single attempt.
    /// </summary>
    public partial class PreloadingAttemptSource : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Key
        /// </summary>
        [JsonPropertyName("key")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.Preload.PreloadingAttemptKey Key
        {
            get;
            set;
        }

        /// <summary>
        /// RuleSetIds
        /// </summary>
        [JsonPropertyName("ruleSetIds")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string[] RuleSetIds
        {
            get;
            set;
        }

        /// <summary>
        /// NodeIds
        /// </summary>
        [JsonPropertyName("nodeIds")]
        public int[] NodeIds
        {
            get;
            set;
        }
    }

    /// <summary>
    /// List of FinalStatus reasons for Prerender2.
    /// </summary>
    public enum PrerenderFinalStatus
    {
        /// <summary>
        /// Activated
        /// </summary>
        [JsonPropertyName("Activated")]
        Activated,
        /// <summary>
        /// Destroyed
        /// </summary>
        [JsonPropertyName("Destroyed")]
        Destroyed,
        /// <summary>
        /// LowEndDevice
        /// </summary>
        [JsonPropertyName("LowEndDevice")]
        LowEndDevice,
        /// <summary>
        /// InvalidSchemeRedirect
        /// </summary>
        [JsonPropertyName("InvalidSchemeRedirect")]
        InvalidSchemeRedirect,
        /// <summary>
        /// InvalidSchemeNavigation
        /// </summary>
        [JsonPropertyName("InvalidSchemeNavigation")]
        InvalidSchemeNavigation,
        /// <summary>
        /// NavigationRequestBlockedByCsp
        /// </summary>
        [JsonPropertyName("NavigationRequestBlockedByCsp")]
        NavigationRequestBlockedByCsp,
        /// <summary>
        /// MainFrameNavigation
        /// </summary>
        [JsonPropertyName("MainFrameNavigation")]
        MainFrameNavigation,
        /// <summary>
        /// MojoBinderPolicy
        /// </summary>
        [JsonPropertyName("MojoBinderPolicy")]
        MojoBinderPolicy,
        /// <summary>
        /// RendererProcessCrashed
        /// </summary>
        [JsonPropertyName("RendererProcessCrashed")]
        RendererProcessCrashed,
        /// <summary>
        /// RendererProcessKilled
        /// </summary>
        [JsonPropertyName("RendererProcessKilled")]
        RendererProcessKilled,
        /// <summary>
        /// Download
        /// </summary>
        [JsonPropertyName("Download")]
        Download,
        /// <summary>
        /// TriggerDestroyed
        /// </summary>
        [JsonPropertyName("TriggerDestroyed")]
        TriggerDestroyed,
        /// <summary>
        /// NavigationNotCommitted
        /// </summary>
        [JsonPropertyName("NavigationNotCommitted")]
        NavigationNotCommitted,
        /// <summary>
        /// NavigationBadHttpStatus
        /// </summary>
        [JsonPropertyName("NavigationBadHttpStatus")]
        NavigationBadHttpStatus,
        /// <summary>
        /// ClientCertRequested
        /// </summary>
        [JsonPropertyName("ClientCertRequested")]
        ClientCertRequested,
        /// <summary>
        /// NavigationRequestNetworkError
        /// </summary>
        [JsonPropertyName("NavigationRequestNetworkError")]
        NavigationRequestNetworkError,
        /// <summary>
        /// CancelAllHostsForTesting
        /// </summary>
        [JsonPropertyName("CancelAllHostsForTesting")]
        CancelAllHostsForTesting,
        /// <summary>
        /// DidFailLoad
        /// </summary>
        [JsonPropertyName("DidFailLoad")]
        DidFailLoad,
        /// <summary>
        /// Stop
        /// </summary>
        [JsonPropertyName("Stop")]
        Stop,
        /// <summary>
        /// SslCertificateError
        /// </summary>
        [JsonPropertyName("SslCertificateError")]
        SslCertificateError,
        /// <summary>
        /// LoginAuthRequested
        /// </summary>
        [JsonPropertyName("LoginAuthRequested")]
        LoginAuthRequested,
        /// <summary>
        /// UaChangeRequiresReload
        /// </summary>
        [JsonPropertyName("UaChangeRequiresReload")]
        UaChangeRequiresReload,
        /// <summary>
        /// BlockedByClient
        /// </summary>
        [JsonPropertyName("BlockedByClient")]
        BlockedByClient,
        /// <summary>
        /// AudioOutputDeviceRequested
        /// </summary>
        [JsonPropertyName("AudioOutputDeviceRequested")]
        AudioOutputDeviceRequested,
        /// <summary>
        /// MixedContent
        /// </summary>
        [JsonPropertyName("MixedContent")]
        MixedContent,
        /// <summary>
        /// TriggerBackgrounded
        /// </summary>
        [JsonPropertyName("TriggerBackgrounded")]
        TriggerBackgrounded,
        /// <summary>
        /// MemoryLimitExceeded
        /// </summary>
        [JsonPropertyName("MemoryLimitExceeded")]
        MemoryLimitExceeded,
        /// <summary>
        /// DataSaverEnabled
        /// </summary>
        [JsonPropertyName("DataSaverEnabled")]
        DataSaverEnabled,
        /// <summary>
        /// TriggerUrlHasEffectiveUrl
        /// </summary>
        [JsonPropertyName("TriggerUrlHasEffectiveUrl")]
        TriggerUrlHasEffectiveUrl,
        /// <summary>
        /// ActivatedBeforeStarted
        /// </summary>
        [JsonPropertyName("ActivatedBeforeStarted")]
        ActivatedBeforeStarted,
        /// <summary>
        /// InactivePageRestriction
        /// </summary>
        [JsonPropertyName("InactivePageRestriction")]
        InactivePageRestriction,
        /// <summary>
        /// StartFailed
        /// </summary>
        [JsonPropertyName("StartFailed")]
        StartFailed,
        /// <summary>
        /// TimeoutBackgrounded
        /// </summary>
        [JsonPropertyName("TimeoutBackgrounded")]
        TimeoutBackgrounded,
        /// <summary>
        /// CrossSiteRedirectInInitialNavigation
        /// </summary>
        [JsonPropertyName("CrossSiteRedirectInInitialNavigation")]
        CrossSiteRedirectInInitialNavigation,
        /// <summary>
        /// CrossSiteNavigationInInitialNavigation
        /// </summary>
        [JsonPropertyName("CrossSiteNavigationInInitialNavigation")]
        CrossSiteNavigationInInitialNavigation,
        /// <summary>
        /// SameSiteCrossOriginRedirectNotOptInInInitialNavigation
        /// </summary>
        [JsonPropertyName("SameSiteCrossOriginRedirectNotOptInInInitialNavigation")]
        SameSiteCrossOriginRedirectNotOptInInInitialNavigation,
        /// <summary>
        /// SameSiteCrossOriginNavigationNotOptInInInitialNavigation
        /// </summary>
        [JsonPropertyName("SameSiteCrossOriginNavigationNotOptInInInitialNavigation")]
        SameSiteCrossOriginNavigationNotOptInInInitialNavigation,
        /// <summary>
        /// ActivationNavigationParameterMismatch
        /// </summary>
        [JsonPropertyName("ActivationNavigationParameterMismatch")]
        ActivationNavigationParameterMismatch,
        /// <summary>
        /// ActivatedInBackground
        /// </summary>
        [JsonPropertyName("ActivatedInBackground")]
        ActivatedInBackground,
        /// <summary>
        /// EmbedderHostDisallowed
        /// </summary>
        [JsonPropertyName("EmbedderHostDisallowed")]
        EmbedderHostDisallowed,
        /// <summary>
        /// ActivationNavigationDestroyedBeforeSuccess
        /// </summary>
        [JsonPropertyName("ActivationNavigationDestroyedBeforeSuccess")]
        ActivationNavigationDestroyedBeforeSuccess,
        /// <summary>
        /// TabClosedByUserGesture
        /// </summary>
        [JsonPropertyName("TabClosedByUserGesture")]
        TabClosedByUserGesture,
        /// <summary>
        /// TabClosedWithoutUserGesture
        /// </summary>
        [JsonPropertyName("TabClosedWithoutUserGesture")]
        TabClosedWithoutUserGesture,
        /// <summary>
        /// PrimaryMainFrameRendererProcessCrashed
        /// </summary>
        [JsonPropertyName("PrimaryMainFrameRendererProcessCrashed")]
        PrimaryMainFrameRendererProcessCrashed,
        /// <summary>
        /// PrimaryMainFrameRendererProcessKilled
        /// </summary>
        [JsonPropertyName("PrimaryMainFrameRendererProcessKilled")]
        PrimaryMainFrameRendererProcessKilled,
        /// <summary>
        /// ActivationFramePolicyNotCompatible
        /// </summary>
        [JsonPropertyName("ActivationFramePolicyNotCompatible")]
        ActivationFramePolicyNotCompatible,
        /// <summary>
        /// PreloadingDisabled
        /// </summary>
        [JsonPropertyName("PreloadingDisabled")]
        PreloadingDisabled,
        /// <summary>
        /// BatterySaverEnabled
        /// </summary>
        [JsonPropertyName("BatterySaverEnabled")]
        BatterySaverEnabled,
        /// <summary>
        /// ActivatedDuringMainFrameNavigation
        /// </summary>
        [JsonPropertyName("ActivatedDuringMainFrameNavigation")]
        ActivatedDuringMainFrameNavigation,
        /// <summary>
        /// PreloadingUnsupportedByWebContents
        /// </summary>
        [JsonPropertyName("PreloadingUnsupportedByWebContents")]
        PreloadingUnsupportedByWebContents,
        /// <summary>
        /// CrossSiteRedirectInMainFrameNavigation
        /// </summary>
        [JsonPropertyName("CrossSiteRedirectInMainFrameNavigation")]
        CrossSiteRedirectInMainFrameNavigation,
        /// <summary>
        /// CrossSiteNavigationInMainFrameNavigation
        /// </summary>
        [JsonPropertyName("CrossSiteNavigationInMainFrameNavigation")]
        CrossSiteNavigationInMainFrameNavigation,
        /// <summary>
        /// SameSiteCrossOriginRedirectNotOptInInMainFrameNavigation
        /// </summary>
        [JsonPropertyName("SameSiteCrossOriginRedirectNotOptInInMainFrameNavigation")]
        SameSiteCrossOriginRedirectNotOptInInMainFrameNavigation,
        /// <summary>
        /// SameSiteCrossOriginNavigationNotOptInInMainFrameNavigation
        /// </summary>
        [JsonPropertyName("SameSiteCrossOriginNavigationNotOptInInMainFrameNavigation")]
        SameSiteCrossOriginNavigationNotOptInInMainFrameNavigation,
        /// <summary>
        /// MemoryPressureOnTrigger
        /// </summary>
        [JsonPropertyName("MemoryPressureOnTrigger")]
        MemoryPressureOnTrigger,
        /// <summary>
        /// MemoryPressureAfterTriggered
        /// </summary>
        [JsonPropertyName("MemoryPressureAfterTriggered")]
        MemoryPressureAfterTriggered,
        /// <summary>
        /// PrerenderingDisabledByDevTools
        /// </summary>
        [JsonPropertyName("PrerenderingDisabledByDevTools")]
        PrerenderingDisabledByDevTools,
        /// <summary>
        /// SpeculationRuleRemoved
        /// </summary>
        [JsonPropertyName("SpeculationRuleRemoved")]
        SpeculationRuleRemoved,
        /// <summary>
        /// ActivatedWithAuxiliaryBrowsingContexts
        /// </summary>
        [JsonPropertyName("ActivatedWithAuxiliaryBrowsingContexts")]
        ActivatedWithAuxiliaryBrowsingContexts,
        /// <summary>
        /// MaxNumOfRunningEagerPrerendersExceeded
        /// </summary>
        [JsonPropertyName("MaxNumOfRunningEagerPrerendersExceeded")]
        MaxNumOfRunningEagerPrerendersExceeded,
        /// <summary>
        /// MaxNumOfRunningNonEagerPrerendersExceeded
        /// </summary>
        [JsonPropertyName("MaxNumOfRunningNonEagerPrerendersExceeded")]
        MaxNumOfRunningNonEagerPrerendersExceeded,
        /// <summary>
        /// MaxNumOfRunningEmbedderPrerendersExceeded
        /// </summary>
        [JsonPropertyName("MaxNumOfRunningEmbedderPrerendersExceeded")]
        MaxNumOfRunningEmbedderPrerendersExceeded,
        /// <summary>
        /// PrerenderingUrlHasEffectiveUrl
        /// </summary>
        [JsonPropertyName("PrerenderingUrlHasEffectiveUrl")]
        PrerenderingUrlHasEffectiveUrl,
        /// <summary>
        /// RedirectedPrerenderingUrlHasEffectiveUrl
        /// </summary>
        [JsonPropertyName("RedirectedPrerenderingUrlHasEffectiveUrl")]
        RedirectedPrerenderingUrlHasEffectiveUrl,
        /// <summary>
        /// ActivationUrlHasEffectiveUrl
        /// </summary>
        [JsonPropertyName("ActivationUrlHasEffectiveUrl")]
        ActivationUrlHasEffectiveUrl,
        /// <summary>
        /// JavaScriptInterfaceAdded
        /// </summary>
        [JsonPropertyName("JavaScriptInterfaceAdded")]
        JavaScriptInterfaceAdded,
        /// <summary>
        /// JavaScriptInterfaceRemoved
        /// </summary>
        [JsonPropertyName("JavaScriptInterfaceRemoved")]
        JavaScriptInterfaceRemoved,
        /// <summary>
        /// AllPrerenderingCanceled
        /// </summary>
        [JsonPropertyName("AllPrerenderingCanceled")]
        AllPrerenderingCanceled,
        /// <summary>
        /// WindowClosed
        /// </summary>
        [JsonPropertyName("WindowClosed")]
        WindowClosed,
        /// <summary>
        /// SlowNetwork
        /// </summary>
        [JsonPropertyName("SlowNetwork")]
        SlowNetwork,
        /// <summary>
        /// OtherPrerenderedPageActivated
        /// </summary>
        [JsonPropertyName("OtherPrerenderedPageActivated")]
        OtherPrerenderedPageActivated
    }

    /// <summary>
    /// Preloading status values, see also PreloadingTriggeringOutcome. This
    /// status is shared by prefetchStatusUpdated and prerenderStatusUpdated.
    /// </summary>
    public enum PreloadingStatus
    {
        /// <summary>
        /// Pending
        /// </summary>
        [JsonPropertyName("Pending")]
        Pending,
        /// <summary>
        /// Running
        /// </summary>
        [JsonPropertyName("Running")]
        Running,
        /// <summary>
        /// Ready
        /// </summary>
        [JsonPropertyName("Ready")]
        Ready,
        /// <summary>
        /// Success
        /// </summary>
        [JsonPropertyName("Success")]
        Success,
        /// <summary>
        /// Failure
        /// </summary>
        [JsonPropertyName("Failure")]
        Failure,
        /// <summary>
        /// NotSupported
        /// </summary>
        [JsonPropertyName("NotSupported")]
        NotSupported
    }

    /// <summary>
    /// TODO(https://crbug.com/1384419): revisit the list of PrefetchStatus and
    /// filter out the ones that aren&apos;t necessary to the developers.
    /// </summary>
    public enum PrefetchStatus
    {
        /// <summary>
        /// PrefetchAllowed
        /// </summary>
        [JsonPropertyName("PrefetchAllowed")]
        PrefetchAllowed,
        /// <summary>
        /// PrefetchFailedIneligibleRedirect
        /// </summary>
        [JsonPropertyName("PrefetchFailedIneligibleRedirect")]
        PrefetchFailedIneligibleRedirect,
        /// <summary>
        /// PrefetchFailedInvalidRedirect
        /// </summary>
        [JsonPropertyName("PrefetchFailedInvalidRedirect")]
        PrefetchFailedInvalidRedirect,
        /// <summary>
        /// PrefetchFailedMIMENotSupported
        /// </summary>
        [JsonPropertyName("PrefetchFailedMIMENotSupported")]
        PrefetchFailedMIMENotSupported,
        /// <summary>
        /// PrefetchFailedNetError
        /// </summary>
        [JsonPropertyName("PrefetchFailedNetError")]
        PrefetchFailedNetError,
        /// <summary>
        /// PrefetchFailedNon2XX
        /// </summary>
        [JsonPropertyName("PrefetchFailedNon2XX")]
        PrefetchFailedNon2XX,
        /// <summary>
        /// PrefetchFailedPerPageLimitExceeded
        /// </summary>
        [JsonPropertyName("PrefetchFailedPerPageLimitExceeded")]
        PrefetchFailedPerPageLimitExceeded,
        /// <summary>
        /// PrefetchEvictedAfterCandidateRemoved
        /// </summary>
        [JsonPropertyName("PrefetchEvictedAfterCandidateRemoved")]
        PrefetchEvictedAfterCandidateRemoved,
        /// <summary>
        /// PrefetchEvictedForNewerPrefetch
        /// </summary>
        [JsonPropertyName("PrefetchEvictedForNewerPrefetch")]
        PrefetchEvictedForNewerPrefetch,
        /// <summary>
        /// PrefetchHeldback
        /// </summary>
        [JsonPropertyName("PrefetchHeldback")]
        PrefetchHeldback,
        /// <summary>
        /// PrefetchIneligibleRetryAfter
        /// </summary>
        [JsonPropertyName("PrefetchIneligibleRetryAfter")]
        PrefetchIneligibleRetryAfter,
        /// <summary>
        /// PrefetchIsPrivacyDecoy
        /// </summary>
        [JsonPropertyName("PrefetchIsPrivacyDecoy")]
        PrefetchIsPrivacyDecoy,
        /// <summary>
        /// PrefetchIsStale
        /// </summary>
        [JsonPropertyName("PrefetchIsStale")]
        PrefetchIsStale,
        /// <summary>
        /// PrefetchNotEligibleBrowserContextOffTheRecord
        /// </summary>
        [JsonPropertyName("PrefetchNotEligibleBrowserContextOffTheRecord")]
        PrefetchNotEligibleBrowserContextOffTheRecord,
        /// <summary>
        /// PrefetchNotEligibleDataSaverEnabled
        /// </summary>
        [JsonPropertyName("PrefetchNotEligibleDataSaverEnabled")]
        PrefetchNotEligibleDataSaverEnabled,
        /// <summary>
        /// PrefetchNotEligibleExistingProxy
        /// </summary>
        [JsonPropertyName("PrefetchNotEligibleExistingProxy")]
        PrefetchNotEligibleExistingProxy,
        /// <summary>
        /// PrefetchNotEligibleHostIsNonUnique
        /// </summary>
        [JsonPropertyName("PrefetchNotEligibleHostIsNonUnique")]
        PrefetchNotEligibleHostIsNonUnique,
        /// <summary>
        /// PrefetchNotEligibleNonDefaultStoragePartition
        /// </summary>
        [JsonPropertyName("PrefetchNotEligibleNonDefaultStoragePartition")]
        PrefetchNotEligibleNonDefaultStoragePartition,
        /// <summary>
        /// PrefetchNotEligibleSameSiteCrossOriginPrefetchRequiredProxy
        /// </summary>
        [JsonPropertyName("PrefetchNotEligibleSameSiteCrossOriginPrefetchRequiredProxy")]
        PrefetchNotEligibleSameSiteCrossOriginPrefetchRequiredProxy,
        /// <summary>
        /// PrefetchNotEligibleSchemeIsNotHttps
        /// </summary>
        [JsonPropertyName("PrefetchNotEligibleSchemeIsNotHttps")]
        PrefetchNotEligibleSchemeIsNotHttps,
        /// <summary>
        /// PrefetchNotEligibleUserHasCookies
        /// </summary>
        [JsonPropertyName("PrefetchNotEligibleUserHasCookies")]
        PrefetchNotEligibleUserHasCookies,
        /// <summary>
        /// PrefetchNotEligibleUserHasServiceWorker
        /// </summary>
        [JsonPropertyName("PrefetchNotEligibleUserHasServiceWorker")]
        PrefetchNotEligibleUserHasServiceWorker,
        /// <summary>
        /// PrefetchNotEligibleBatterySaverEnabled
        /// </summary>
        [JsonPropertyName("PrefetchNotEligibleBatterySaverEnabled")]
        PrefetchNotEligibleBatterySaverEnabled,
        /// <summary>
        /// PrefetchNotEligiblePreloadingDisabled
        /// </summary>
        [JsonPropertyName("PrefetchNotEligiblePreloadingDisabled")]
        PrefetchNotEligiblePreloadingDisabled,
        /// <summary>
        /// PrefetchNotFinishedInTime
        /// </summary>
        [JsonPropertyName("PrefetchNotFinishedInTime")]
        PrefetchNotFinishedInTime,
        /// <summary>
        /// PrefetchNotStarted
        /// </summary>
        [JsonPropertyName("PrefetchNotStarted")]
        PrefetchNotStarted,
        /// <summary>
        /// PrefetchNotUsedCookiesChanged
        /// </summary>
        [JsonPropertyName("PrefetchNotUsedCookiesChanged")]
        PrefetchNotUsedCookiesChanged,
        /// <summary>
        /// PrefetchProxyNotAvailable
        /// </summary>
        [JsonPropertyName("PrefetchProxyNotAvailable")]
        PrefetchProxyNotAvailable,
        /// <summary>
        /// PrefetchResponseUsed
        /// </summary>
        [JsonPropertyName("PrefetchResponseUsed")]
        PrefetchResponseUsed,
        /// <summary>
        /// PrefetchSuccessfulButNotUsed
        /// </summary>
        [JsonPropertyName("PrefetchSuccessfulButNotUsed")]
        PrefetchSuccessfulButNotUsed,
        /// <summary>
        /// PrefetchNotUsedProbeFailed
        /// </summary>
        [JsonPropertyName("PrefetchNotUsedProbeFailed")]
        PrefetchNotUsedProbeFailed
    }

    /// <summary>
    /// Information of headers to be displayed when the header mismatch occurred.
    /// </summary>
    public partial class PrerenderMismatchedHeaders : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// HeaderName
        /// </summary>
        [JsonPropertyName("headerName")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string HeaderName
        {
            get;
            set;
        }

        /// <summary>
        /// InitialValue
        /// </summary>
        [JsonPropertyName("initialValue")]
        public string InitialValue
        {
            get;
            set;
        }

        /// <summary>
        /// ActivationValue
        /// </summary>
        [JsonPropertyName("activationValue")]
        public string ActivationValue
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Upsert. Currently, it is only emitted when a rule set added.
    /// </summary>
    public class RuleSetUpdatedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// RuleSet
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("ruleSet")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.Preload.RuleSet RuleSet
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// ruleSetRemoved
    /// </summary>
    public class RuleSetRemovedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Id
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("id")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Id
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired when a preload enabled state is updated.
    /// </summary>
    public class PreloadEnabledStateUpdatedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// DisabledByPreference
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("disabledByPreference")]
        public bool DisabledByPreference
        {
            get;
            private set;
        }

        /// <summary>
        /// DisabledByDataSaver
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("disabledByDataSaver")]
        public bool DisabledByDataSaver
        {
            get;
            private set;
        }

        /// <summary>
        /// DisabledByBatterySaver
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("disabledByBatterySaver")]
        public bool DisabledByBatterySaver
        {
            get;
            private set;
        }

        /// <summary>
        /// DisabledByHoldbackPrefetchSpeculationRules
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("disabledByHoldbackPrefetchSpeculationRules")]
        public bool DisabledByHoldbackPrefetchSpeculationRules
        {
            get;
            private set;
        }

        /// <summary>
        /// DisabledByHoldbackPrerenderSpeculationRules
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("disabledByHoldbackPrerenderSpeculationRules")]
        public bool DisabledByHoldbackPrerenderSpeculationRules
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired when a prefetch attempt is updated.
    /// </summary>
    public class PrefetchStatusUpdatedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Key
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("key")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.Preload.PreloadingAttemptKey Key
        {
            get;
            private set;
        }

        /// <summary>
        /// The frame id of the frame initiating prefetch.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("initiatingFrameId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string InitiatingFrameId
        {
            get;
            private set;
        }

        /// <summary>
        /// PrefetchUrl
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("prefetchUrl")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string PrefetchUrl
        {
            get;
            private set;
        }

        /// <summary>
        /// Status
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("status")]
        public CefSharp.DevTools.Preload.PreloadingStatus Status
        {
            get;
            private set;
        }

        /// <summary>
        /// PrefetchStatus
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("prefetchStatus")]
        public CefSharp.DevTools.Preload.PrefetchStatus PrefetchStatus
        {
            get;
            private set;
        }

        /// <summary>
        /// RequestId
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("requestId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string RequestId
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired when a prerender attempt is updated.
    /// </summary>
    public class PrerenderStatusUpdatedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Key
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("key")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.Preload.PreloadingAttemptKey Key
        {
            get;
            private set;
        }

        /// <summary>
        /// Status
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("status")]
        public CefSharp.DevTools.Preload.PreloadingStatus Status
        {
            get;
            private set;
        }

        /// <summary>
        /// PrerenderStatus
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("prerenderStatus")]
        public CefSharp.DevTools.Preload.PrerenderFinalStatus? PrerenderStatus
        {
            get;
            private set;
        }

        /// <summary>
        /// This is used to give users more information about the name of Mojo interface
        /// that is incompatible with prerender and has caused the cancellation of the attempt.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("disallowedMojoInterface")]
        public string DisallowedMojoInterface
        {
            get;
            private set;
        }

        /// <summary>
        /// MismatchedHeaders
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("mismatchedHeaders")]
        public System.Collections.Generic.IList<CefSharp.DevTools.Preload.PrerenderMismatchedHeaders> MismatchedHeaders
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Send a list of sources for all preloading attempts in a document.
    /// </summary>
    public class PreloadingAttemptSourcesUpdatedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// LoaderId
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("loaderId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string LoaderId
        {
            get;
            private set;
        }

        /// <summary>
        /// PreloadingAttemptSources
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("preloadingAttemptSources")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public System.Collections.Generic.IList<CefSharp.DevTools.Preload.PreloadingAttemptSource> PreloadingAttemptSources
        {
            get;
            private set;
        }
    }
}

namespace CefSharp.DevTools.FedCm
{
    /// <summary>
    /// Whether this is a sign-up or sign-in action for this account, i.e.
    /// whether this account has ever been used to sign in to this RP before.
    /// </summary>
    public enum LoginState
    {
        /// <summary>
        /// SignIn
        /// </summary>
        [JsonPropertyName("SignIn")]
        SignIn,
        /// <summary>
        /// SignUp
        /// </summary>
        [JsonPropertyName("SignUp")]
        SignUp
    }

    /// <summary>
    /// The types of FedCM dialogs.
    /// </summary>
    public enum DialogType
    {
        /// <summary>
        /// AccountChooser
        /// </summary>
        [JsonPropertyName("AccountChooser")]
        AccountChooser,
        /// <summary>
        /// AutoReauthn
        /// </summary>
        [JsonPropertyName("AutoReauthn")]
        AutoReauthn,
        /// <summary>
        /// ConfirmIdpLogin
        /// </summary>
        [JsonPropertyName("ConfirmIdpLogin")]
        ConfirmIdpLogin,
        /// <summary>
        /// Error
        /// </summary>
        [JsonPropertyName("Error")]
        Error
    }

    /// <summary>
    /// The buttons on the FedCM dialog.
    /// </summary>
    public enum DialogButton
    {
        /// <summary>
        /// ConfirmIdpLoginContinue
        /// </summary>
        [JsonPropertyName("ConfirmIdpLoginContinue")]
        ConfirmIdpLoginContinue,
        /// <summary>
        /// ErrorGotIt
        /// </summary>
        [JsonPropertyName("ErrorGotIt")]
        ErrorGotIt,
        /// <summary>
        /// ErrorMoreDetails
        /// </summary>
        [JsonPropertyName("ErrorMoreDetails")]
        ErrorMoreDetails
    }

    /// <summary>
    /// The URLs that each account has
    /// </summary>
    public enum AccountUrlType
    {
        /// <summary>
        /// TermsOfService
        /// </summary>
        [JsonPropertyName("TermsOfService")]
        TermsOfService,
        /// <summary>
        /// PrivacyPolicy
        /// </summary>
        [JsonPropertyName("PrivacyPolicy")]
        PrivacyPolicy
    }

    /// <summary>
    /// Corresponds to IdentityRequestAccount
    /// </summary>
    public partial class Account : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// AccountId
        /// </summary>
        [JsonPropertyName("accountId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string AccountId
        {
            get;
            set;
        }

        /// <summary>
        /// Email
        /// </summary>
        [JsonPropertyName("email")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Email
        {
            get;
            set;
        }

        /// <summary>
        /// Name
        /// </summary>
        [JsonPropertyName("name")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Name
        {
            get;
            set;
        }

        /// <summary>
        /// GivenName
        /// </summary>
        [JsonPropertyName("givenName")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string GivenName
        {
            get;
            set;
        }

        /// <summary>
        /// PictureUrl
        /// </summary>
        [JsonPropertyName("pictureUrl")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string PictureUrl
        {
            get;
            set;
        }

        /// <summary>
        /// IdpConfigUrl
        /// </summary>
        [JsonPropertyName("idpConfigUrl")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string IdpConfigUrl
        {
            get;
            set;
        }

        /// <summary>
        /// IdpLoginUrl
        /// </summary>
        [JsonPropertyName("idpLoginUrl")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string IdpLoginUrl
        {
            get;
            set;
        }

        /// <summary>
        /// LoginState
        /// </summary>
        [JsonPropertyName("loginState")]
        public CefSharp.DevTools.FedCm.LoginState LoginState
        {
            get;
            set;
        }

        /// <summary>
        /// These two are only set if the loginState is signUp
        /// </summary>
        [JsonPropertyName("termsOfServiceUrl")]
        public string TermsOfServiceUrl
        {
            get;
            set;
        }

        /// <summary>
        /// PrivacyPolicyUrl
        /// </summary>
        [JsonPropertyName("privacyPolicyUrl")]
        public string PrivacyPolicyUrl
        {
            get;
            set;
        }
    }

    /// <summary>
    /// dialogShown
    /// </summary>
    public class DialogShownEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// DialogId
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("dialogId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string DialogId
        {
            get;
            private set;
        }

        /// <summary>
        /// DialogType
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("dialogType")]
        public CefSharp.DevTools.FedCm.DialogType DialogType
        {
            get;
            private set;
        }

        /// <summary>
        /// Accounts
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("accounts")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public System.Collections.Generic.IList<CefSharp.DevTools.FedCm.Account> Accounts
        {
            get;
            private set;
        }

        /// <summary>
        /// These exist primarily so that the caller can verify the
        /// RP context was used appropriately.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("title")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Title
        {
            get;
            private set;
        }

        /// <summary>
        /// Subtitle
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("subtitle")]
        public string Subtitle
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Triggered when a dialog is closed, either by user action, JS abort,
    /// or a command below.
    /// </summary>
    public class DialogClosedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// DialogId
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("dialogId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string DialogId
        {
            get;
            private set;
        }
    }
}

namespace CefSharp.DevTools.PWA
{
    /// <summary>
    /// The following types are the replica of
    /// https://crsrc.org/c/chrome/browser/web_applications/proto/web_app_os_integration_state.proto;drc=9910d3be894c8f142c977ba1023f30a656bc13fc;l=67
    /// </summary>
    public partial class FileHandlerAccept : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// New name of the mimetype according to
        /// https://www.iana.org/assignments/media-types/media-types.xhtml
        /// </summary>
        [JsonPropertyName("mediaType")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string MediaType
        {
            get;
            set;
        }

        /// <summary>
        /// FileExtensions
        /// </summary>
        [JsonPropertyName("fileExtensions")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string[] FileExtensions
        {
            get;
            set;
        }
    }

    /// <summary>
    /// FileHandler
    /// </summary>
    public partial class FileHandler : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Action
        /// </summary>
        [JsonPropertyName("action")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Action
        {
            get;
            set;
        }

        /// <summary>
        /// Accepts
        /// </summary>
        [JsonPropertyName("accepts")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public System.Collections.Generic.IList<CefSharp.DevTools.PWA.FileHandlerAccept> Accepts
        {
            get;
            set;
        }

        /// <summary>
        /// DisplayName
        /// </summary>
        [JsonPropertyName("displayName")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string DisplayName
        {
            get;
            set;
        }
    }

    /// <summary>
    /// If user prefers opening the app in browser or an app window.
    /// </summary>
    public enum DisplayMode
    {
        /// <summary>
        /// standalone
        /// </summary>
        [JsonPropertyName("standalone")]
        Standalone,
        /// <summary>
        /// browser
        /// </summary>
        [JsonPropertyName("browser")]
        Browser
    }
}

namespace CefSharp.DevTools.BluetoothEmulation
{
    /// <summary>
    /// Indicates the various states of Central.
    /// </summary>
    public enum CentralState
    {
        /// <summary>
        /// absent
        /// </summary>
        [JsonPropertyName("absent")]
        Absent,
        /// <summary>
        /// powered-off
        /// </summary>
        [JsonPropertyName("powered-off")]
        PoweredOff,
        /// <summary>
        /// powered-on
        /// </summary>
        [JsonPropertyName("powered-on")]
        PoweredOn
    }

    /// <summary>
    /// Stores the manufacturer data
    /// </summary>
    public partial class ManufacturerData : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Company identifier
        /// https://bitbucket.org/bluetooth-SIG/public/src/main/assigned_numbers/company_identifiers/company_identifiers.yaml
        /// https://usb.org/developers
        /// </summary>
        [JsonPropertyName("key")]
        public int Key
        {
            get;
            set;
        }

        /// <summary>
        /// Manufacturer-specific data
        /// </summary>
        [JsonPropertyName("data")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public byte[] Data
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Stores the byte data of the advertisement packet sent by a Bluetooth device.
    /// </summary>
    public partial class ScanRecord : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Name
        /// </summary>
        [JsonPropertyName("name")]
        public string Name
        {
            get;
            set;
        }

        /// <summary>
        /// Uuids
        /// </summary>
        [JsonPropertyName("uuids")]
        public string[] Uuids
        {
            get;
            set;
        }

        /// <summary>
        /// Stores the external appearance description of the device.
        /// </summary>
        [JsonPropertyName("appearance")]
        public int? Appearance
        {
            get;
            set;
        }

        /// <summary>
        /// Stores the transmission power of a broadcasting device.
        /// </summary>
        [JsonPropertyName("txPower")]
        public int? TxPower
        {
            get;
            set;
        }

        /// <summary>
        /// Key is the company identifier and the value is an array of bytes of
        /// manufacturer specific data.
        /// </summary>
        [JsonPropertyName("manufacturerData")]
        public System.Collections.Generic.IList<CefSharp.DevTools.BluetoothEmulation.ManufacturerData> ManufacturerData
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Stores the advertisement packet information that is sent by a Bluetooth device.
    /// </summary>
    public partial class ScanEntry : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// DeviceAddress
        /// </summary>
        [JsonPropertyName("deviceAddress")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string DeviceAddress
        {
            get;
            set;
        }

        /// <summary>
        /// Rssi
        /// </summary>
        [JsonPropertyName("rssi")]
        public int Rssi
        {
            get;
            set;
        }

        /// <summary>
        /// ScanRecord
        /// </summary>
        [JsonPropertyName("scanRecord")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.BluetoothEmulation.ScanRecord ScanRecord
        {
            get;
            set;
        }
    }
}

namespace CefSharp.DevTools.Debugger
{
    /// <summary>
    /// Location in the source code.
    /// </summary>
    public partial class Location : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Script identifier as reported in the `Debugger.scriptParsed`.
        /// </summary>
        [JsonPropertyName("scriptId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string ScriptId
        {
            get;
            set;
        }

        /// <summary>
        /// Line number in the script (0-based).
        /// </summary>
        [JsonPropertyName("lineNumber")]
        public int LineNumber
        {
            get;
            set;
        }

        /// <summary>
        /// Column number in the script (0-based).
        /// </summary>
        [JsonPropertyName("columnNumber")]
        public int? ColumnNumber
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Location in the source code.
    /// </summary>
    public partial class ScriptPosition : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// LineNumber
        /// </summary>
        [JsonPropertyName("lineNumber")]
        public int LineNumber
        {
            get;
            set;
        }

        /// <summary>
        /// ColumnNumber
        /// </summary>
        [JsonPropertyName("columnNumber")]
        public int ColumnNumber
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Location range within one script.
    /// </summary>
    public partial class LocationRange : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// ScriptId
        /// </summary>
        [JsonPropertyName("scriptId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string ScriptId
        {
            get;
            set;
        }

        /// <summary>
        /// Start
        /// </summary>
        [JsonPropertyName("start")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.Debugger.ScriptPosition Start
        {
            get;
            set;
        }

        /// <summary>
        /// End
        /// </summary>
        [JsonPropertyName("end")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.Debugger.ScriptPosition End
        {
            get;
            set;
        }
    }

    /// <summary>
    /// JavaScript call frame. Array of call frames form the call stack.
    /// </summary>
    public partial class CallFrame : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Call frame identifier. This identifier is only valid while the virtual machine is paused.
        /// </summary>
        [JsonPropertyName("callFrameId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string CallFrameId
        {
            get;
            set;
        }

        /// <summary>
        /// Name of the JavaScript function called on this call frame.
        /// </summary>
        [JsonPropertyName("functionName")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string FunctionName
        {
            get;
            set;
        }

        /// <summary>
        /// Location in the source code.
        /// </summary>
        [JsonPropertyName("functionLocation")]
        public CefSharp.DevTools.Debugger.Location FunctionLocation
        {
            get;
            set;
        }

        /// <summary>
        /// Location in the source code.
        /// </summary>
        [JsonPropertyName("location")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.Debugger.Location Location
        {
            get;
            set;
        }

        /// <summary>
        /// JavaScript script name or url.
        /// Deprecated in favor of using the `location.scriptId` to resolve the URL via a previously
        /// sent `Debugger.scriptParsed` event.
        /// </summary>
        [JsonPropertyName("url")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Url
        {
            get;
            set;
        }

        /// <summary>
        /// Scope chain for this call frame.
        /// </summary>
        [JsonPropertyName("scopeChain")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public System.Collections.Generic.IList<CefSharp.DevTools.Debugger.Scope> ScopeChain
        {
            get;
            set;
        }

        /// <summary>
        /// `this` object for this call frame.
        /// </summary>
        [JsonPropertyName("this")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.Runtime.RemoteObject This
        {
            get;
            set;
        }

        /// <summary>
        /// The value being returned, if the function is at return point.
        /// </summary>
        [JsonPropertyName("returnValue")]
        public CefSharp.DevTools.Runtime.RemoteObject ReturnValue
        {
            get;
            set;
        }

        /// <summary>
        /// Valid only while the VM is paused and indicates whether this frame
        /// can be restarted or not. Note that a `true` value here does not
        /// guarantee that Debugger#restartFrame with this CallFrameId will be
        /// successful, but it is very likely.
        /// </summary>
        [JsonPropertyName("canBeRestarted")]
        public bool? CanBeRestarted
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Scope type.
    /// </summary>
    public enum ScopeType
    {
        /// <summary>
        /// global
        /// </summary>
        [JsonPropertyName("global")]
        Global,
        /// <summary>
        /// local
        /// </summary>
        [JsonPropertyName("local")]
        Local,
        /// <summary>
        /// with
        /// </summary>
        [JsonPropertyName("with")]
        With,
        /// <summary>
        /// closure
        /// </summary>
        [JsonPropertyName("closure")]
        Closure,
        /// <summary>
        /// catch
        /// </summary>
        [JsonPropertyName("catch")]
        Catch,
        /// <summary>
        /// block
        /// </summary>
        [JsonPropertyName("block")]
        Block,
        /// <summary>
        /// script
        /// </summary>
        [JsonPropertyName("script")]
        Script,
        /// <summary>
        /// eval
        /// </summary>
        [JsonPropertyName("eval")]
        Eval,
        /// <summary>
        /// module
        /// </summary>
        [JsonPropertyName("module")]
        Module,
        /// <summary>
        /// wasm-expression-stack
        /// </summary>
        [JsonPropertyName("wasm-expression-stack")]
        WasmExpressionStack
    }

    /// <summary>
    /// Scope description.
    /// </summary>
    public partial class Scope : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Scope type.
        /// </summary>
        [JsonPropertyName("type")]
        public CefSharp.DevTools.Debugger.ScopeType Type
        {
            get;
            set;
        }

        /// <summary>
        /// Object representing the scope. For `global` and `with` scopes it represents the actual
        /// object; for the rest of the scopes, it is artificial transient object enumerating scope
        /// variables as its properties.
        /// </summary>
        [JsonPropertyName("object")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.Runtime.RemoteObject Object
        {
            get;
            set;
        }

        /// <summary>
        /// Name
        /// </summary>
        [JsonPropertyName("name")]
        public string Name
        {
            get;
            set;
        }

        /// <summary>
        /// Location in the source code where scope starts
        /// </summary>
        [JsonPropertyName("startLocation")]
        public CefSharp.DevTools.Debugger.Location StartLocation
        {
            get;
            set;
        }

        /// <summary>
        /// Location in the source code where scope ends
        /// </summary>
        [JsonPropertyName("endLocation")]
        public CefSharp.DevTools.Debugger.Location EndLocation
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Search match for resource.
    /// </summary>
    public partial class SearchMatch : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Line number in resource content.
        /// </summary>
        [JsonPropertyName("lineNumber")]
        public double LineNumber
        {
            get;
            set;
        }

        /// <summary>
        /// Line with match content.
        /// </summary>
        [JsonPropertyName("lineContent")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string LineContent
        {
            get;
            set;
        }
    }

    /// <summary>
    /// BreakLocationType
    /// </summary>
    public enum BreakLocationType
    {
        /// <summary>
        /// debuggerStatement
        /// </summary>
        [JsonPropertyName("debuggerStatement")]
        DebuggerStatement,
        /// <summary>
        /// call
        /// </summary>
        [JsonPropertyName("call")]
        Call,
        /// <summary>
        /// return
        /// </summary>
        [JsonPropertyName("return")]
        Return
    }

    /// <summary>
    /// BreakLocation
    /// </summary>
    public partial class BreakLocation : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Script identifier as reported in the `Debugger.scriptParsed`.
        /// </summary>
        [JsonPropertyName("scriptId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string ScriptId
        {
            get;
            set;
        }

        /// <summary>
        /// Line number in the script (0-based).
        /// </summary>
        [JsonPropertyName("lineNumber")]
        public int LineNumber
        {
            get;
            set;
        }

        /// <summary>
        /// Column number in the script (0-based).
        /// </summary>
        [JsonPropertyName("columnNumber")]
        public int? ColumnNumber
        {
            get;
            set;
        }

        /// <summary>
        /// Type
        /// </summary>
        [JsonPropertyName("type")]
        public CefSharp.DevTools.Debugger.BreakLocationType? Type
        {
            get;
            set;
        }
    }

    /// <summary>
    /// WasmDisassemblyChunk
    /// </summary>
    public partial class WasmDisassemblyChunk : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The next chunk of disassembled lines.
        /// </summary>
        [JsonPropertyName("lines")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string[] Lines
        {
            get;
            set;
        }

        /// <summary>
        /// The bytecode offsets describing the start of each line.
        /// </summary>
        [JsonPropertyName("bytecodeOffsets")]
        public int[] BytecodeOffsets
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Enum of possible script languages.
    /// </summary>
    public enum ScriptLanguage
    {
        /// <summary>
        /// JavaScript
        /// </summary>
        [JsonPropertyName("JavaScript")]
        JavaScript,
        /// <summary>
        /// WebAssembly
        /// </summary>
        [JsonPropertyName("WebAssembly")]
        WebAssembly
    }

    /// <summary>
    /// Type of the debug symbols.
    /// </summary>
    public enum DebugSymbolsType
    {
        /// <summary>
        /// None
        /// </summary>
        [JsonPropertyName("None")]
        None,
        /// <summary>
        /// SourceMap
        /// </summary>
        [JsonPropertyName("SourceMap")]
        SourceMap,
        /// <summary>
        /// EmbeddedDWARF
        /// </summary>
        [JsonPropertyName("EmbeddedDWARF")]
        EmbeddedDWARF,
        /// <summary>
        /// ExternalDWARF
        /// </summary>
        [JsonPropertyName("ExternalDWARF")]
        ExternalDWARF
    }

    /// <summary>
    /// Debug symbols available for a wasm script.
    /// </summary>
    public partial class DebugSymbols : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Type of the debug symbols.
        /// </summary>
        [JsonPropertyName("type")]
        public CefSharp.DevTools.Debugger.DebugSymbolsType Type
        {
            get;
            set;
        }

        /// <summary>
        /// URL of the external symbol source.
        /// </summary>
        [JsonPropertyName("externalURL")]
        public string ExternalURL
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Fired when breakpoint is resolved to an actual script and location.
    /// </summary>
    public class BreakpointResolvedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Breakpoint unique identifier.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("breakpointId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string BreakpointId
        {
            get;
            private set;
        }

        /// <summary>
        /// Actual breakpoint location.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("location")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.Debugger.Location Location
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Pause reason.
    /// </summary>
    public enum PausedReason
    {
        /// <summary>
        /// ambiguous
        /// </summary>
        [JsonPropertyName("ambiguous")]
        Ambiguous,
        /// <summary>
        /// assert
        /// </summary>
        [JsonPropertyName("assert")]
        Assert,
        /// <summary>
        /// CSPViolation
        /// </summary>
        [JsonPropertyName("CSPViolation")]
        CSPViolation,
        /// <summary>
        /// debugCommand
        /// </summary>
        [JsonPropertyName("debugCommand")]
        DebugCommand,
        /// <summary>
        /// DOM
        /// </summary>
        [JsonPropertyName("DOM")]
        DOM,
        /// <summary>
        /// EventListener
        /// </summary>
        [JsonPropertyName("EventListener")]
        EventListener,
        /// <summary>
        /// exception
        /// </summary>
        [JsonPropertyName("exception")]
        Exception,
        /// <summary>
        /// instrumentation
        /// </summary>
        [JsonPropertyName("instrumentation")]
        Instrumentation,
        /// <summary>
        /// OOM
        /// </summary>
        [JsonPropertyName("OOM")]
        OOM,
        /// <summary>
        /// other
        /// </summary>
        [JsonPropertyName("other")]
        Other,
        /// <summary>
        /// promiseRejection
        /// </summary>
        [JsonPropertyName("promiseRejection")]
        PromiseRejection,
        /// <summary>
        /// XHR
        /// </summary>
        [JsonPropertyName("XHR")]
        XHR,
        /// <summary>
        /// step
        /// </summary>
        [JsonPropertyName("step")]
        Step
    }

    /// <summary>
    /// Fired when the virtual machine stopped on breakpoint or exception or any other stop criteria.
    /// </summary>
    public class PausedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Call stack the virtual machine stopped on.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("callFrames")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public System.Collections.Generic.IList<CefSharp.DevTools.Debugger.CallFrame> CallFrames
        {
            get;
            private set;
        }

        /// <summary>
        /// Pause reason.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("reason")]
        public CefSharp.DevTools.Debugger.PausedReason Reason
        {
            get;
            private set;
        }

        /// <summary>
        /// Object containing break-specific auxiliary properties.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("data")]
        public object Data
        {
            get;
            private set;
        }

        /// <summary>
        /// Hit breakpoints IDs
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("hitBreakpoints")]
        public string[] HitBreakpoints
        {
            get;
            private set;
        }

        /// <summary>
        /// Async stack trace, if any.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("asyncStackTrace")]
        public CefSharp.DevTools.Runtime.StackTrace AsyncStackTrace
        {
            get;
            private set;
        }

        /// <summary>
        /// Async stack trace, if any.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("asyncStackTraceId")]
        public CefSharp.DevTools.Runtime.StackTraceId AsyncStackTraceId
        {
            get;
            private set;
        }

        /// <summary>
        /// Never present, will be removed.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("asyncCallStackTraceId")]
        public CefSharp.DevTools.Runtime.StackTraceId AsyncCallStackTraceId
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired when virtual machine fails to parse the script.
    /// </summary>
    public class ScriptFailedToParseEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Identifier of the script parsed.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("scriptId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string ScriptId
        {
            get;
            private set;
        }

        /// <summary>
        /// URL or name of the script parsed (if any).
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("url")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Url
        {
            get;
            private set;
        }

        /// <summary>
        /// Line offset of the script within the resource with given URL (for script tags).
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("startLine")]
        public int StartLine
        {
            get;
            private set;
        }

        /// <summary>
        /// Column offset of the script within the resource with given URL.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("startColumn")]
        public int StartColumn
        {
            get;
            private set;
        }

        /// <summary>
        /// Last line of the script.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("endLine")]
        public int EndLine
        {
            get;
            private set;
        }

        /// <summary>
        /// Length of the last line of the script.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("endColumn")]
        public int EndColumn
        {
            get;
            private set;
        }

        /// <summary>
        /// Specifies script creation context.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("executionContextId")]
        public int ExecutionContextId
        {
            get;
            private set;
        }

        /// <summary>
        /// Content hash of the script, SHA-256.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("hash")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Hash
        {
            get;
            private set;
        }

        /// <summary>
        /// Embedder-specific auxiliary data likely matching {isDefault: boolean, type: &apos;default&apos;|&apos;isolated&apos;|&apos;worker&apos;, frameId: string}
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("executionContextAuxData")]
        public object ExecutionContextAuxData
        {
            get;
            private set;
        }

        /// <summary>
        /// URL of source map associated with script (if any).
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("sourceMapURL")]
        public string SourceMapURL
        {
            get;
            private set;
        }

        /// <summary>
        /// True, if this script has sourceURL.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("hasSourceURL")]
        public bool? HasSourceURL
        {
            get;
            private set;
        }

        /// <summary>
        /// True, if this script is ES6 module.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("isModule")]
        public bool? IsModule
        {
            get;
            private set;
        }

        /// <summary>
        /// This script length.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("length")]
        public int? Length
        {
            get;
            private set;
        }

        /// <summary>
        /// JavaScript top stack frame of where the script parsed event was triggered if available.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("stackTrace")]
        public CefSharp.DevTools.Runtime.StackTrace StackTrace
        {
            get;
            private set;
        }

        /// <summary>
        /// If the scriptLanguage is WebAssembly, the code section offset in the module.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("codeOffset")]
        public int? CodeOffset
        {
            get;
            private set;
        }

        /// <summary>
        /// The language of the script.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("scriptLanguage")]
        public CefSharp.DevTools.Debugger.ScriptLanguage? ScriptLanguage
        {
            get;
            private set;
        }

        /// <summary>
        /// The name the embedder supplied for this script.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("embedderName")]
        public string EmbedderName
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Fired when virtual machine parses script. This event is also fired for all known and uncollected
    /// scripts upon enabling debugger.
    /// </summary>
    public class ScriptParsedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Identifier of the script parsed.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("scriptId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string ScriptId
        {
            get;
            private set;
        }

        /// <summary>
        /// URL or name of the script parsed (if any).
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("url")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Url
        {
            get;
            private set;
        }

        /// <summary>
        /// Line offset of the script within the resource with given URL (for script tags).
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("startLine")]
        public int StartLine
        {
            get;
            private set;
        }

        /// <summary>
        /// Column offset of the script within the resource with given URL.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("startColumn")]
        public int StartColumn
        {
            get;
            private set;
        }

        /// <summary>
        /// Last line of the script.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("endLine")]
        public int EndLine
        {
            get;
            private set;
        }

        /// <summary>
        /// Length of the last line of the script.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("endColumn")]
        public int EndColumn
        {
            get;
            private set;
        }

        /// <summary>
        /// Specifies script creation context.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("executionContextId")]
        public int ExecutionContextId
        {
            get;
            private set;
        }

        /// <summary>
        /// Content hash of the script, SHA-256.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("hash")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Hash
        {
            get;
            private set;
        }

        /// <summary>
        /// Embedder-specific auxiliary data likely matching {isDefault: boolean, type: &apos;default&apos;|&apos;isolated&apos;|&apos;worker&apos;, frameId: string}
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("executionContextAuxData")]
        public object ExecutionContextAuxData
        {
            get;
            private set;
        }

        /// <summary>
        /// True, if this script is generated as a result of the live edit operation.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("isLiveEdit")]
        public bool? IsLiveEdit
        {
            get;
            private set;
        }

        /// <summary>
        /// URL of source map associated with script (if any).
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("sourceMapURL")]
        public string SourceMapURL
        {
            get;
            private set;
        }

        /// <summary>
        /// True, if this script has sourceURL.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("hasSourceURL")]
        public bool? HasSourceURL
        {
            get;
            private set;
        }

        /// <summary>
        /// True, if this script is ES6 module.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("isModule")]
        public bool? IsModule
        {
            get;
            private set;
        }

        /// <summary>
        /// This script length.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("length")]
        public int? Length
        {
            get;
            private set;
        }

        /// <summary>
        /// JavaScript top stack frame of where the script parsed event was triggered if available.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("stackTrace")]
        public CefSharp.DevTools.Runtime.StackTrace StackTrace
        {
            get;
            private set;
        }

        /// <summary>
        /// If the scriptLanguage is WebAssembly, the code section offset in the module.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("codeOffset")]
        public int? CodeOffset
        {
            get;
            private set;
        }

        /// <summary>
        /// The language of the script.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("scriptLanguage")]
        public CefSharp.DevTools.Debugger.ScriptLanguage? ScriptLanguage
        {
            get;
            private set;
        }

        /// <summary>
        /// If the scriptLanguage is WebASsembly, the source of debug symbols for the module.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("debugSymbols")]
        public CefSharp.DevTools.Debugger.DebugSymbols DebugSymbols
        {
            get;
            private set;
        }

        /// <summary>
        /// The name the embedder supplied for this script.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("embedderName")]
        public string EmbedderName
        {
            get;
            private set;
        }
    }
}

namespace CefSharp.DevTools.HeapProfiler
{
    /// <summary>
    /// Sampling Heap Profile node. Holds callsite information, allocation statistics and child nodes.
    /// </summary>
    public partial class SamplingHeapProfileNode : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Function location.
        /// </summary>
        [JsonPropertyName("callFrame")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.Runtime.CallFrame CallFrame
        {
            get;
            set;
        }

        /// <summary>
        /// Allocations size in bytes for the node excluding children.
        /// </summary>
        [JsonPropertyName("selfSize")]
        public double SelfSize
        {
            get;
            set;
        }

        /// <summary>
        /// Node id. Ids are unique across all profiles collected between startSampling and stopSampling.
        /// </summary>
        [JsonPropertyName("id")]
        public int Id
        {
            get;
            set;
        }

        /// <summary>
        /// Child nodes.
        /// </summary>
        [JsonPropertyName("children")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public System.Collections.Generic.IList<CefSharp.DevTools.HeapProfiler.SamplingHeapProfileNode> Children
        {
            get;
            set;
        }
    }

    /// <summary>
    /// A single sample from a sampling profile.
    /// </summary>
    public partial class SamplingHeapProfileSample : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Allocation size in bytes attributed to the sample.
        /// </summary>
        [JsonPropertyName("size")]
        public double Size
        {
            get;
            set;
        }

        /// <summary>
        /// Id of the corresponding profile tree node.
        /// </summary>
        [JsonPropertyName("nodeId")]
        public int NodeId
        {
            get;
            set;
        }

        /// <summary>
        /// Time-ordered sample ordinal number. It is unique across all profiles retrieved
        /// between startSampling and stopSampling.
        /// </summary>
        [JsonPropertyName("ordinal")]
        public double Ordinal
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Sampling profile.
    /// </summary>
    public partial class SamplingHeapProfile : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Head
        /// </summary>
        [JsonPropertyName("head")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.HeapProfiler.SamplingHeapProfileNode Head
        {
            get;
            set;
        }

        /// <summary>
        /// Samples
        /// </summary>
        [JsonPropertyName("samples")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public System.Collections.Generic.IList<CefSharp.DevTools.HeapProfiler.SamplingHeapProfileSample> Samples
        {
            get;
            set;
        }
    }

    /// <summary>
    /// addHeapSnapshotChunk
    /// </summary>
    public class AddHeapSnapshotChunkEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Chunk
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("chunk")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Chunk
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// If heap objects tracking has been started then backend may send update for one or more fragments
    /// </summary>
    public class HeapStatsUpdateEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// An array of triplets. Each triplet describes a fragment. The first integer is the fragment
        /// index, the second integer is a total count of objects for the fragment, the third integer is
        /// a total size of the objects for the fragment.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("statsUpdate")]
        public int[] StatsUpdate
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// If heap objects tracking has been started then backend regularly sends a current value for last
    /// seen object id and corresponding timestamp. If the were changes in the heap since last event
    /// then one or more heapStatsUpdate events will be sent before a new lastSeenObjectId event.
    /// </summary>
    public class LastSeenObjectIdEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// LastSeenObjectId
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("lastSeenObjectId")]
        public int LastSeenObjectId
        {
            get;
            private set;
        }

        /// <summary>
        /// Timestamp
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("timestamp")]
        public double Timestamp
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// reportHeapSnapshotProgress
    /// </summary>
    public class ReportHeapSnapshotProgressEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Done
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("done")]
        public int Done
        {
            get;
            private set;
        }

        /// <summary>
        /// Total
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("total")]
        public int Total
        {
            get;
            private set;
        }

        /// <summary>
        /// Finished
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("finished")]
        public bool? Finished
        {
            get;
            private set;
        }
    }
}

namespace CefSharp.DevTools.Profiler
{
    /// <summary>
    /// Profile node. Holds callsite information, execution statistics and child nodes.
    /// </summary>
    public partial class ProfileNode : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Unique id of the node.
        /// </summary>
        [JsonPropertyName("id")]
        public int Id
        {
            get;
            set;
        }

        /// <summary>
        /// Function location.
        /// </summary>
        [JsonPropertyName("callFrame")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.Runtime.CallFrame CallFrame
        {
            get;
            set;
        }

        /// <summary>
        /// Number of samples where this node was on top of the call stack.
        /// </summary>
        [JsonPropertyName("hitCount")]
        public int? HitCount
        {
            get;
            set;
        }

        /// <summary>
        /// Child node ids.
        /// </summary>
        [JsonPropertyName("children")]
        public int[] Children
        {
            get;
            set;
        }

        /// <summary>
        /// The reason of being not optimized. The function may be deoptimized or marked as don&apos;t
        /// optimize.
        /// </summary>
        [JsonPropertyName("deoptReason")]
        public string DeoptReason
        {
            get;
            set;
        }

        /// <summary>
        /// An array of source position ticks.
        /// </summary>
        [JsonPropertyName("positionTicks")]
        public System.Collections.Generic.IList<CefSharp.DevTools.Profiler.PositionTickInfo> PositionTicks
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Profile.
    /// </summary>
    public partial class Profile : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The list of profile nodes. First item is the root node.
        /// </summary>
        [JsonPropertyName("nodes")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public System.Collections.Generic.IList<CefSharp.DevTools.Profiler.ProfileNode> Nodes
        {
            get;
            set;
        }

        /// <summary>
        /// Profiling start timestamp in microseconds.
        /// </summary>
        [JsonPropertyName("startTime")]
        public double StartTime
        {
            get;
            set;
        }

        /// <summary>
        /// Profiling end timestamp in microseconds.
        /// </summary>
        [JsonPropertyName("endTime")]
        public double EndTime
        {
            get;
            set;
        }

        /// <summary>
        /// Ids of samples top nodes.
        /// </summary>
        [JsonPropertyName("samples")]
        public int[] Samples
        {
            get;
            set;
        }

        /// <summary>
        /// Time intervals between adjacent samples in microseconds. The first delta is relative to the
        /// profile startTime.
        /// </summary>
        [JsonPropertyName("timeDeltas")]
        public int[] TimeDeltas
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Specifies a number of samples attributed to a certain source position.
    /// </summary>
    public partial class PositionTickInfo : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Source line number (1-based).
        /// </summary>
        [JsonPropertyName("line")]
        public int Line
        {
            get;
            set;
        }

        /// <summary>
        /// Number of samples attributed to the source line.
        /// </summary>
        [JsonPropertyName("ticks")]
        public int Ticks
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Coverage data for a source range.
    /// </summary>
    public partial class CoverageRange : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// JavaScript script source offset for the range start.
        /// </summary>
        [JsonPropertyName("startOffset")]
        public int StartOffset
        {
            get;
            set;
        }

        /// <summary>
        /// JavaScript script source offset for the range end.
        /// </summary>
        [JsonPropertyName("endOffset")]
        public int EndOffset
        {
            get;
            set;
        }

        /// <summary>
        /// Collected execution count of the source range.
        /// </summary>
        [JsonPropertyName("count")]
        public int Count
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Coverage data for a JavaScript function.
    /// </summary>
    public partial class FunctionCoverage : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// JavaScript function name.
        /// </summary>
        [JsonPropertyName("functionName")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string FunctionName
        {
            get;
            set;
        }

        /// <summary>
        /// Source ranges inside the function with coverage data.
        /// </summary>
        [JsonPropertyName("ranges")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public System.Collections.Generic.IList<CefSharp.DevTools.Profiler.CoverageRange> Ranges
        {
            get;
            set;
        }

        /// <summary>
        /// Whether coverage data for this function has block granularity.
        /// </summary>
        [JsonPropertyName("isBlockCoverage")]
        public bool IsBlockCoverage
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Coverage data for a JavaScript script.
    /// </summary>
    public partial class ScriptCoverage : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// JavaScript script id.
        /// </summary>
        [JsonPropertyName("scriptId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string ScriptId
        {
            get;
            set;
        }

        /// <summary>
        /// JavaScript script name or url.
        /// </summary>
        [JsonPropertyName("url")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Url
        {
            get;
            set;
        }

        /// <summary>
        /// Functions contained in the script that has coverage data.
        /// </summary>
        [JsonPropertyName("functions")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public System.Collections.Generic.IList<CefSharp.DevTools.Profiler.FunctionCoverage> Functions
        {
            get;
            set;
        }
    }

    /// <summary>
    /// consoleProfileFinished
    /// </summary>
    public class ConsoleProfileFinishedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Id
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("id")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Id
        {
            get;
            private set;
        }

        /// <summary>
        /// Location of console.profileEnd().
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("location")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.Debugger.Location Location
        {
            get;
            private set;
        }

        /// <summary>
        /// Profile
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("profile")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.Profiler.Profile Profile
        {
            get;
            private set;
        }

        /// <summary>
        /// Profile title passed as an argument to console.profile().
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("title")]
        public string Title
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Sent when new profile recording is started using console.profile() call.
    /// </summary>
    public class ConsoleProfileStartedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Id
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("id")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Id
        {
            get;
            private set;
        }

        /// <summary>
        /// Location of console.profile().
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("location")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.Debugger.Location Location
        {
            get;
            private set;
        }

        /// <summary>
        /// Profile title passed as an argument to console.profile().
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("title")]
        public string Title
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Reports coverage delta since the last poll (either from an event like this, or from
    /// `takePreciseCoverage` for the current isolate. May only be sent if precise code
    /// coverage has been started. This event can be trigged by the embedder to, for example,
    /// trigger collection of coverage data immediately at a certain point in time.
    /// </summary>
    public class PreciseCoverageDeltaUpdateEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Monotonically increasing time (in seconds) when the coverage update was taken in the backend.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("timestamp")]
        public double Timestamp
        {
            get;
            private set;
        }

        /// <summary>
        /// Identifier for distinguishing coverage events.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("occasion")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Occasion
        {
            get;
            private set;
        }

        /// <summary>
        /// Coverage data for the current isolate.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("result")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public System.Collections.Generic.IList<CefSharp.DevTools.Profiler.ScriptCoverage> Result
        {
            get;
            private set;
        }
    }
}

namespace CefSharp.DevTools.Runtime
{
    /// <summary>
    /// SerializationOptionsSerialization
    /// </summary>
    public enum SerializationOptionsSerialization
    {
        /// <summary>
        /// deep
        /// </summary>
        [JsonPropertyName("deep")]
        Deep,
        /// <summary>
        /// json
        /// </summary>
        [JsonPropertyName("json")]
        Json,
        /// <summary>
        /// idOnly
        /// </summary>
        [JsonPropertyName("idOnly")]
        IdOnly
    }

    /// <summary>
    /// Represents options for serialization. Overrides `generatePreview` and `returnByValue`.
    /// </summary>
    public partial class SerializationOptions : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Serialization
        /// </summary>
        [JsonPropertyName("serialization")]
        public CefSharp.DevTools.Runtime.SerializationOptionsSerialization Serialization
        {
            get;
            set;
        }

        /// <summary>
        /// Deep serialization depth. Default is full depth. Respected only in `deep` serialization mode.
        /// </summary>
        [JsonPropertyName("maxDepth")]
        public int? MaxDepth
        {
            get;
            set;
        }

        /// <summary>
        /// Embedder-specific parameters. For example if connected to V8 in Chrome these control DOM
        /// serialization via `maxNodeDepth: integer` and `includeShadowTree: &quot;none&quot; | &quot;open&quot; | &quot;all&quot;`.
        /// Values can be only of type string or integer.
        /// </summary>
        [JsonPropertyName("additionalParameters")]
        public object AdditionalParameters
        {
            get;
            set;
        }
    }

    /// <summary>
    /// DeepSerializedValueType
    /// </summary>
    public enum DeepSerializedValueType
    {
        /// <summary>
        /// undefined
        /// </summary>
        [JsonPropertyName("undefined")]
        Undefined,
        /// <summary>
        /// null
        /// </summary>
        [JsonPropertyName("null")]
        Null,
        /// <summary>
        /// string
        /// </summary>
        [JsonPropertyName("string")]
        String,
        /// <summary>
        /// number
        /// </summary>
        [JsonPropertyName("number")]
        Number,
        /// <summary>
        /// boolean
        /// </summary>
        [JsonPropertyName("boolean")]
        Boolean,
        /// <summary>
        /// bigint
        /// </summary>
        [JsonPropertyName("bigint")]
        Bigint,
        /// <summary>
        /// regexp
        /// </summary>
        [JsonPropertyName("regexp")]
        Regexp,
        /// <summary>
        /// date
        /// </summary>
        [JsonPropertyName("date")]
        Date,
        /// <summary>
        /// symbol
        /// </summary>
        [JsonPropertyName("symbol")]
        Symbol,
        /// <summary>
        /// array
        /// </summary>
        [JsonPropertyName("array")]
        Array,
        /// <summary>
        /// object
        /// </summary>
        [JsonPropertyName("object")]
        Object,
        /// <summary>
        /// function
        /// </summary>
        [JsonPropertyName("function")]
        Function,
        /// <summary>
        /// map
        /// </summary>
        [JsonPropertyName("map")]
        Map,
        /// <summary>
        /// set
        /// </summary>
        [JsonPropertyName("set")]
        Set,
        /// <summary>
        /// weakmap
        /// </summary>
        [JsonPropertyName("weakmap")]
        Weakmap,
        /// <summary>
        /// weakset
        /// </summary>
        [JsonPropertyName("weakset")]
        Weakset,
        /// <summary>
        /// error
        /// </summary>
        [JsonPropertyName("error")]
        Error,
        /// <summary>
        /// proxy
        /// </summary>
        [JsonPropertyName("proxy")]
        Proxy,
        /// <summary>
        /// promise
        /// </summary>
        [JsonPropertyName("promise")]
        Promise,
        /// <summary>
        /// typedarray
        /// </summary>
        [JsonPropertyName("typedarray")]
        Typedarray,
        /// <summary>
        /// arraybuffer
        /// </summary>
        [JsonPropertyName("arraybuffer")]
        Arraybuffer,
        /// <summary>
        /// node
        /// </summary>
        [JsonPropertyName("node")]
        Node,
        /// <summary>
        /// window
        /// </summary>
        [JsonPropertyName("window")]
        Window,
        /// <summary>
        /// generator
        /// </summary>
        [JsonPropertyName("generator")]
        Generator
    }

    /// <summary>
    /// Represents deep serialized value.
    /// </summary>
    public partial class DeepSerializedValue : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Type
        /// </summary>
        [JsonPropertyName("type")]
        public CefSharp.DevTools.Runtime.DeepSerializedValueType Type
        {
            get;
            set;
        }

        /// <summary>
        /// Value
        /// </summary>
        [JsonPropertyName("value")]
        public object Value
        {
            get;
            set;
        }

        /// <summary>
        /// ObjectId
        /// </summary>
        [JsonPropertyName("objectId")]
        public string ObjectId
        {
            get;
            set;
        }

        /// <summary>
        /// Set if value reference met more then once during serialization. In such
        /// case, value is provided only to one of the serialized values. Unique
        /// per value in the scope of one CDP call.
        /// </summary>
        [JsonPropertyName("weakLocalObjectReference")]
        public int? WeakLocalObjectReference
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Object type.
    /// </summary>
    public enum RemoteObjectType
    {
        /// <summary>
        /// object
        /// </summary>
        [JsonPropertyName("object")]
        Object,
        /// <summary>
        /// function
        /// </summary>
        [JsonPropertyName("function")]
        Function,
        /// <summary>
        /// undefined
        /// </summary>
        [JsonPropertyName("undefined")]
        Undefined,
        /// <summary>
        /// string
        /// </summary>
        [JsonPropertyName("string")]
        String,
        /// <summary>
        /// number
        /// </summary>
        [JsonPropertyName("number")]
        Number,
        /// <summary>
        /// boolean
        /// </summary>
        [JsonPropertyName("boolean")]
        Boolean,
        /// <summary>
        /// symbol
        /// </summary>
        [JsonPropertyName("symbol")]
        Symbol,
        /// <summary>
        /// bigint
        /// </summary>
        [JsonPropertyName("bigint")]
        Bigint
    }

    /// <summary>
    /// Object subtype hint. Specified for `object` type values only.
    /// NOTE: If you change anything here, make sure to also update
    /// `subtype` in `ObjectPreview` and `PropertyPreview` below.
    /// </summary>
    public enum RemoteObjectSubtype
    {
        /// <summary>
        /// array
        /// </summary>
        [JsonPropertyName("array")]
        Array,
        /// <summary>
        /// null
        /// </summary>
        [JsonPropertyName("null")]
        Null,
        /// <summary>
        /// node
        /// </summary>
        [JsonPropertyName("node")]
        Node,
        /// <summary>
        /// regexp
        /// </summary>
        [JsonPropertyName("regexp")]
        Regexp,
        /// <summary>
        /// date
        /// </summary>
        [JsonPropertyName("date")]
        Date,
        /// <summary>
        /// map
        /// </summary>
        [JsonPropertyName("map")]
        Map,
        /// <summary>
        /// set
        /// </summary>
        [JsonPropertyName("set")]
        Set,
        /// <summary>
        /// weakmap
        /// </summary>
        [JsonPropertyName("weakmap")]
        Weakmap,
        /// <summary>
        /// weakset
        /// </summary>
        [JsonPropertyName("weakset")]
        Weakset,
        /// <summary>
        /// iterator
        /// </summary>
        [JsonPropertyName("iterator")]
        Iterator,
        /// <summary>
        /// generator
        /// </summary>
        [JsonPropertyName("generator")]
        Generator,
        /// <summary>
        /// error
        /// </summary>
        [JsonPropertyName("error")]
        Error,
        /// <summary>
        /// proxy
        /// </summary>
        [JsonPropertyName("proxy")]
        Proxy,
        /// <summary>
        /// promise
        /// </summary>
        [JsonPropertyName("promise")]
        Promise,
        /// <summary>
        /// typedarray
        /// </summary>
        [JsonPropertyName("typedarray")]
        Typedarray,
        /// <summary>
        /// arraybuffer
        /// </summary>
        [JsonPropertyName("arraybuffer")]
        Arraybuffer,
        /// <summary>
        /// dataview
        /// </summary>
        [JsonPropertyName("dataview")]
        Dataview,
        /// <summary>
        /// webassemblymemory
        /// </summary>
        [JsonPropertyName("webassemblymemory")]
        Webassemblymemory,
        /// <summary>
        /// wasmvalue
        /// </summary>
        [JsonPropertyName("wasmvalue")]
        Wasmvalue
    }

    /// <summary>
    /// Mirror object referencing original JavaScript object.
    /// </summary>
    public partial class RemoteObject : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Object type.
        /// </summary>
        [JsonPropertyName("type")]
        public CefSharp.DevTools.Runtime.RemoteObjectType Type
        {
            get;
            set;
        }

        /// <summary>
        /// Object subtype hint. Specified for `object` type values only.
        /// NOTE: If you change anything here, make sure to also update
        /// `subtype` in `ObjectPreview` and `PropertyPreview` below.
        /// </summary>
        [JsonPropertyName("subtype")]
        public CefSharp.DevTools.Runtime.RemoteObjectSubtype? Subtype
        {
            get;
            set;
        }

        /// <summary>
        /// Object class (constructor) name. Specified for `object` type values only.
        /// </summary>
        [JsonPropertyName("className")]
        public string ClassName
        {
            get;
            set;
        }

        /// <summary>
        /// Remote object value in case of primitive values or JSON values (if it was requested).
        /// </summary>
        [JsonPropertyName("value")]
        public object Value
        {
            get;
            set;
        }

        /// <summary>
        /// Primitive value which can not be JSON-stringified does not have `value`, but gets this
        /// property.
        /// </summary>
        [JsonPropertyName("unserializableValue")]
        public string UnserializableValue
        {
            get;
            set;
        }

        /// <summary>
        /// String representation of the object.
        /// </summary>
        [JsonPropertyName("description")]
        public string Description
        {
            get;
            set;
        }

        /// <summary>
        /// Deep serialized value.
        /// </summary>
        [JsonPropertyName("deepSerializedValue")]
        public CefSharp.DevTools.Runtime.DeepSerializedValue DeepSerializedValue
        {
            get;
            set;
        }

        /// <summary>
        /// Unique object identifier (for non-primitive values).
        /// </summary>
        [JsonPropertyName("objectId")]
        public string ObjectId
        {
            get;
            set;
        }

        /// <summary>
        /// Preview containing abbreviated property values. Specified for `object` type values only.
        /// </summary>
        [JsonPropertyName("preview")]
        public CefSharp.DevTools.Runtime.ObjectPreview Preview
        {
            get;
            set;
        }

        /// <summary>
        /// CustomPreview
        /// </summary>
        [JsonPropertyName("customPreview")]
        public CefSharp.DevTools.Runtime.CustomPreview CustomPreview
        {
            get;
            set;
        }
    }

    /// <summary>
    /// CustomPreview
    /// </summary>
    public partial class CustomPreview : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// The JSON-stringified result of formatter.header(object, config) call.
        /// It contains json ML array that represents RemoteObject.
        /// </summary>
        [JsonPropertyName("header")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Header
        {
            get;
            set;
        }

        /// <summary>
        /// If formatter returns true as a result of formatter.hasBody call then bodyGetterId will
        /// contain RemoteObjectId for the function that returns result of formatter.body(object, config) call.
        /// The result value is json ML array.
        /// </summary>
        [JsonPropertyName("bodyGetterId")]
        public string BodyGetterId
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Object type.
    /// </summary>
    public enum ObjectPreviewType
    {
        /// <summary>
        /// object
        /// </summary>
        [JsonPropertyName("object")]
        Object,
        /// <summary>
        /// function
        /// </summary>
        [JsonPropertyName("function")]
        Function,
        /// <summary>
        /// undefined
        /// </summary>
        [JsonPropertyName("undefined")]
        Undefined,
        /// <summary>
        /// string
        /// </summary>
        [JsonPropertyName("string")]
        String,
        /// <summary>
        /// number
        /// </summary>
        [JsonPropertyName("number")]
        Number,
        /// <summary>
        /// boolean
        /// </summary>
        [JsonPropertyName("boolean")]
        Boolean,
        /// <summary>
        /// symbol
        /// </summary>
        [JsonPropertyName("symbol")]
        Symbol,
        /// <summary>
        /// bigint
        /// </summary>
        [JsonPropertyName("bigint")]
        Bigint
    }

    /// <summary>
    /// Object subtype hint. Specified for `object` type values only.
    /// </summary>
    public enum ObjectPreviewSubtype
    {
        /// <summary>
        /// array
        /// </summary>
        [JsonPropertyName("array")]
        Array,
        /// <summary>
        /// null
        /// </summary>
        [JsonPropertyName("null")]
        Null,
        /// <summary>
        /// node
        /// </summary>
        [JsonPropertyName("node")]
        Node,
        /// <summary>
        /// regexp
        /// </summary>
        [JsonPropertyName("regexp")]
        Regexp,
        /// <summary>
        /// date
        /// </summary>
        [JsonPropertyName("date")]
        Date,
        /// <summary>
        /// map
        /// </summary>
        [JsonPropertyName("map")]
        Map,
        /// <summary>
        /// set
        /// </summary>
        [JsonPropertyName("set")]
        Set,
        /// <summary>
        /// weakmap
        /// </summary>
        [JsonPropertyName("weakmap")]
        Weakmap,
        /// <summary>
        /// weakset
        /// </summary>
        [JsonPropertyName("weakset")]
        Weakset,
        /// <summary>
        /// iterator
        /// </summary>
        [JsonPropertyName("iterator")]
        Iterator,
        /// <summary>
        /// generator
        /// </summary>
        [JsonPropertyName("generator")]
        Generator,
        /// <summary>
        /// error
        /// </summary>
        [JsonPropertyName("error")]
        Error,
        /// <summary>
        /// proxy
        /// </summary>
        [JsonPropertyName("proxy")]
        Proxy,
        /// <summary>
        /// promise
        /// </summary>
        [JsonPropertyName("promise")]
        Promise,
        /// <summary>
        /// typedarray
        /// </summary>
        [JsonPropertyName("typedarray")]
        Typedarray,
        /// <summary>
        /// arraybuffer
        /// </summary>
        [JsonPropertyName("arraybuffer")]
        Arraybuffer,
        /// <summary>
        /// dataview
        /// </summary>
        [JsonPropertyName("dataview")]
        Dataview,
        /// <summary>
        /// webassemblymemory
        /// </summary>
        [JsonPropertyName("webassemblymemory")]
        Webassemblymemory,
        /// <summary>
        /// wasmvalue
        /// </summary>
        [JsonPropertyName("wasmvalue")]
        Wasmvalue
    }

    /// <summary>
    /// Object containing abbreviated remote object value.
    /// </summary>
    public partial class ObjectPreview : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Object type.
        /// </summary>
        [JsonPropertyName("type")]
        public CefSharp.DevTools.Runtime.ObjectPreviewType Type
        {
            get;
            set;
        }

        /// <summary>
        /// Object subtype hint. Specified for `object` type values only.
        /// </summary>
        [JsonPropertyName("subtype")]
        public CefSharp.DevTools.Runtime.ObjectPreviewSubtype? Subtype
        {
            get;
            set;
        }

        /// <summary>
        /// String representation of the object.
        /// </summary>
        [JsonPropertyName("description")]
        public string Description
        {
            get;
            set;
        }

        /// <summary>
        /// True iff some of the properties or entries of the original object did not fit.
        /// </summary>
        [JsonPropertyName("overflow")]
        public bool Overflow
        {
            get;
            set;
        }

        /// <summary>
        /// List of the properties.
        /// </summary>
        [JsonPropertyName("properties")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public System.Collections.Generic.IList<CefSharp.DevTools.Runtime.PropertyPreview> Properties
        {
            get;
            set;
        }

        /// <summary>
        /// List of the entries. Specified for `map` and `set` subtype values only.
        /// </summary>
        [JsonPropertyName("entries")]
        public System.Collections.Generic.IList<CefSharp.DevTools.Runtime.EntryPreview> Entries
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Object type. Accessor means that the property itself is an accessor property.
    /// </summary>
    public enum PropertyPreviewType
    {
        /// <summary>
        /// object
        /// </summary>
        [JsonPropertyName("object")]
        Object,
        /// <summary>
        /// function
        /// </summary>
        [JsonPropertyName("function")]
        Function,
        /// <summary>
        /// undefined
        /// </summary>
        [JsonPropertyName("undefined")]
        Undefined,
        /// <summary>
        /// string
        /// </summary>
        [JsonPropertyName("string")]
        String,
        /// <summary>
        /// number
        /// </summary>
        [JsonPropertyName("number")]
        Number,
        /// <summary>
        /// boolean
        /// </summary>
        [JsonPropertyName("boolean")]
        Boolean,
        /// <summary>
        /// symbol
        /// </summary>
        [JsonPropertyName("symbol")]
        Symbol,
        /// <summary>
        /// accessor
        /// </summary>
        [JsonPropertyName("accessor")]
        Accessor,
        /// <summary>
        /// bigint
        /// </summary>
        [JsonPropertyName("bigint")]
        Bigint
    }

    /// <summary>
    /// Object subtype hint. Specified for `object` type values only.
    /// </summary>
    public enum PropertyPreviewSubtype
    {
        /// <summary>
        /// array
        /// </summary>
        [JsonPropertyName("array")]
        Array,
        /// <summary>
        /// null
        /// </summary>
        [JsonPropertyName("null")]
        Null,
        /// <summary>
        /// node
        /// </summary>
        [JsonPropertyName("node")]
        Node,
        /// <summary>
        /// regexp
        /// </summary>
        [JsonPropertyName("regexp")]
        Regexp,
        /// <summary>
        /// date
        /// </summary>
        [JsonPropertyName("date")]
        Date,
        /// <summary>
        /// map
        /// </summary>
        [JsonPropertyName("map")]
        Map,
        /// <summary>
        /// set
        /// </summary>
        [JsonPropertyName("set")]
        Set,
        /// <summary>
        /// weakmap
        /// </summary>
        [JsonPropertyName("weakmap")]
        Weakmap,
        /// <summary>
        /// weakset
        /// </summary>
        [JsonPropertyName("weakset")]
        Weakset,
        /// <summary>
        /// iterator
        /// </summary>
        [JsonPropertyName("iterator")]
        Iterator,
        /// <summary>
        /// generator
        /// </summary>
        [JsonPropertyName("generator")]
        Generator,
        /// <summary>
        /// error
        /// </summary>
        [JsonPropertyName("error")]
        Error,
        /// <summary>
        /// proxy
        /// </summary>
        [JsonPropertyName("proxy")]
        Proxy,
        /// <summary>
        /// promise
        /// </summary>
        [JsonPropertyName("promise")]
        Promise,
        /// <summary>
        /// typedarray
        /// </summary>
        [JsonPropertyName("typedarray")]
        Typedarray,
        /// <summary>
        /// arraybuffer
        /// </summary>
        [JsonPropertyName("arraybuffer")]
        Arraybuffer,
        /// <summary>
        /// dataview
        /// </summary>
        [JsonPropertyName("dataview")]
        Dataview,
        /// <summary>
        /// webassemblymemory
        /// </summary>
        [JsonPropertyName("webassemblymemory")]
        Webassemblymemory,
        /// <summary>
        /// wasmvalue
        /// </summary>
        [JsonPropertyName("wasmvalue")]
        Wasmvalue
    }

    /// <summary>
    /// PropertyPreview
    /// </summary>
    public partial class PropertyPreview : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Property name.
        /// </summary>
        [JsonPropertyName("name")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Name
        {
            get;
            set;
        }

        /// <summary>
        /// Object type. Accessor means that the property itself is an accessor property.
        /// </summary>
        [JsonPropertyName("type")]
        public CefSharp.DevTools.Runtime.PropertyPreviewType Type
        {
            get;
            set;
        }

        /// <summary>
        /// User-friendly property value string.
        /// </summary>
        [JsonPropertyName("value")]
        public string Value
        {
            get;
            set;
        }

        /// <summary>
        /// Nested value preview.
        /// </summary>
        [JsonPropertyName("valuePreview")]
        public CefSharp.DevTools.Runtime.ObjectPreview ValuePreview
        {
            get;
            set;
        }

        /// <summary>
        /// Object subtype hint. Specified for `object` type values only.
        /// </summary>
        [JsonPropertyName("subtype")]
        public CefSharp.DevTools.Runtime.PropertyPreviewSubtype? Subtype
        {
            get;
            set;
        }
    }

    /// <summary>
    /// EntryPreview
    /// </summary>
    public partial class EntryPreview : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Preview of the key. Specified for map-like collection entries.
        /// </summary>
        [JsonPropertyName("key")]
        public CefSharp.DevTools.Runtime.ObjectPreview Key
        {
            get;
            set;
        }

        /// <summary>
        /// Preview of the value.
        /// </summary>
        [JsonPropertyName("value")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.Runtime.ObjectPreview Value
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Object property descriptor.
    /// </summary>
    public partial class PropertyDescriptor : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Property name or symbol description.
        /// </summary>
        [JsonPropertyName("name")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Name
        {
            get;
            set;
        }

        /// <summary>
        /// The value associated with the property.
        /// </summary>
        [JsonPropertyName("value")]
        public CefSharp.DevTools.Runtime.RemoteObject Value
        {
            get;
            set;
        }

        /// <summary>
        /// True if the value associated with the property may be changed (data descriptors only).
        /// </summary>
        [JsonPropertyName("writable")]
        public bool? Writable
        {
            get;
            set;
        }

        /// <summary>
        /// A function which serves as a getter for the property, or `undefined` if there is no getter
        /// (accessor descriptors only).
        /// </summary>
        [JsonPropertyName("get")]
        public CefSharp.DevTools.Runtime.RemoteObject Get
        {
            get;
            set;
        }

        /// <summary>
        /// A function which serves as a setter for the property, or `undefined` if there is no setter
        /// (accessor descriptors only).
        /// </summary>
        [JsonPropertyName("set")]
        public CefSharp.DevTools.Runtime.RemoteObject Set
        {
            get;
            set;
        }

        /// <summary>
        /// True if the type of this property descriptor may be changed and if the property may be
        /// deleted from the corresponding object.
        /// </summary>
        [JsonPropertyName("configurable")]
        public bool Configurable
        {
            get;
            set;
        }

        /// <summary>
        /// True if this property shows up during enumeration of the properties on the corresponding
        /// object.
        /// </summary>
        [JsonPropertyName("enumerable")]
        public bool Enumerable
        {
            get;
            set;
        }

        /// <summary>
        /// True if the result was thrown during the evaluation.
        /// </summary>
        [JsonPropertyName("wasThrown")]
        public bool? WasThrown
        {
            get;
            set;
        }

        /// <summary>
        /// True if the property is owned for the object.
        /// </summary>
        [JsonPropertyName("isOwn")]
        public bool? IsOwn
        {
            get;
            set;
        }

        /// <summary>
        /// Property symbol object, if the property is of the `symbol` type.
        /// </summary>
        [JsonPropertyName("symbol")]
        public CefSharp.DevTools.Runtime.RemoteObject Symbol
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Object internal property descriptor. This property isn&apos;t normally visible in JavaScript code.
    /// </summary>
    public partial class InternalPropertyDescriptor : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Conventional property name.
        /// </summary>
        [JsonPropertyName("name")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Name
        {
            get;
            set;
        }

        /// <summary>
        /// The value associated with the property.
        /// </summary>
        [JsonPropertyName("value")]
        public CefSharp.DevTools.Runtime.RemoteObject Value
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Object private field descriptor.
    /// </summary>
    public partial class PrivatePropertyDescriptor : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Private property name.
        /// </summary>
        [JsonPropertyName("name")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Name
        {
            get;
            set;
        }

        /// <summary>
        /// The value associated with the private property.
        /// </summary>
        [JsonPropertyName("value")]
        public CefSharp.DevTools.Runtime.RemoteObject Value
        {
            get;
            set;
        }

        /// <summary>
        /// A function which serves as a getter for the private property,
        /// or `undefined` if there is no getter (accessor descriptors only).
        /// </summary>
        [JsonPropertyName("get")]
        public CefSharp.DevTools.Runtime.RemoteObject Get
        {
            get;
            set;
        }

        /// <summary>
        /// A function which serves as a setter for the private property,
        /// or `undefined` if there is no setter (accessor descriptors only).
        /// </summary>
        [JsonPropertyName("set")]
        public CefSharp.DevTools.Runtime.RemoteObject Set
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Represents function call argument. Either remote object id `objectId`, primitive `value`,
    /// unserializable primitive value or neither of (for undefined) them should be specified.
    /// </summary>
    public partial class CallArgument : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Primitive value or serializable javascript object.
        /// </summary>
        [JsonPropertyName("value")]
        public object Value
        {
            get;
            set;
        }

        /// <summary>
        /// Primitive value which can not be JSON-stringified.
        /// </summary>
        [JsonPropertyName("unserializableValue")]
        public string UnserializableValue
        {
            get;
            set;
        }

        /// <summary>
        /// Remote object handle.
        /// </summary>
        [JsonPropertyName("objectId")]
        public string ObjectId
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Description of an isolated world.
    /// </summary>
    public partial class ExecutionContextDescription : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Unique id of the execution context. It can be used to specify in which execution context
        /// script evaluation should be performed.
        /// </summary>
        [JsonPropertyName("id")]
        public int Id
        {
            get;
            set;
        }

        /// <summary>
        /// Execution context origin.
        /// </summary>
        [JsonPropertyName("origin")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Origin
        {
            get;
            set;
        }

        /// <summary>
        /// Human readable name describing given context.
        /// </summary>
        [JsonPropertyName("name")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Name
        {
            get;
            set;
        }

        /// <summary>
        /// A system-unique execution context identifier. Unlike the id, this is unique across
        /// multiple processes, so can be reliably used to identify specific context while backend
        /// performs a cross-process navigation.
        /// </summary>
        [JsonPropertyName("uniqueId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string UniqueId
        {
            get;
            set;
        }

        /// <summary>
        /// Embedder-specific auxiliary data likely matching {isDefault: boolean, type: &apos;default&apos;|&apos;isolated&apos;|&apos;worker&apos;, frameId: string}
        /// </summary>
        [JsonPropertyName("auxData")]
        public object AuxData
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Detailed information about exception (or error) that was thrown during script compilation or
    /// execution.
    /// </summary>
    public partial class ExceptionDetails : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Exception id.
        /// </summary>
        [JsonPropertyName("exceptionId")]
        public int ExceptionId
        {
            get;
            set;
        }

        /// <summary>
        /// Exception text, which should be used together with exception object when available.
        /// </summary>
        [JsonPropertyName("text")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Text
        {
            get;
            set;
        }

        /// <summary>
        /// Line number of the exception location (0-based).
        /// </summary>
        [JsonPropertyName("lineNumber")]
        public int LineNumber
        {
            get;
            set;
        }

        /// <summary>
        /// Column number of the exception location (0-based).
        /// </summary>
        [JsonPropertyName("columnNumber")]
        public int ColumnNumber
        {
            get;
            set;
        }

        /// <summary>
        /// Script ID of the exception location.
        /// </summary>
        [JsonPropertyName("scriptId")]
        public string ScriptId
        {
            get;
            set;
        }

        /// <summary>
        /// URL of the exception location, to be used when the script was not reported.
        /// </summary>
        [JsonPropertyName("url")]
        public string Url
        {
            get;
            set;
        }

        /// <summary>
        /// JavaScript stack trace if available.
        /// </summary>
        [JsonPropertyName("stackTrace")]
        public CefSharp.DevTools.Runtime.StackTrace StackTrace
        {
            get;
            set;
        }

        /// <summary>
        /// Exception object if available.
        /// </summary>
        [JsonPropertyName("exception")]
        public CefSharp.DevTools.Runtime.RemoteObject Exception
        {
            get;
            set;
        }

        /// <summary>
        /// Identifier of the context where exception happened.
        /// </summary>
        [JsonPropertyName("executionContextId")]
        public int? ExecutionContextId
        {
            get;
            set;
        }

        /// <summary>
        /// Dictionary with entries of meta data that the client associated
        /// with this exception, such as information about associated network
        /// requests, etc.
        /// </summary>
        [JsonPropertyName("exceptionMetaData")]
        public object ExceptionMetaData
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Stack entry for runtime errors and assertions.
    /// </summary>
    public partial class CallFrame : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// JavaScript function name.
        /// </summary>
        [JsonPropertyName("functionName")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string FunctionName
        {
            get;
            set;
        }

        /// <summary>
        /// JavaScript script id.
        /// </summary>
        [JsonPropertyName("scriptId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string ScriptId
        {
            get;
            set;
        }

        /// <summary>
        /// JavaScript script name or url.
        /// </summary>
        [JsonPropertyName("url")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Url
        {
            get;
            set;
        }

        /// <summary>
        /// JavaScript script line number (0-based).
        /// </summary>
        [JsonPropertyName("lineNumber")]
        public int LineNumber
        {
            get;
            set;
        }

        /// <summary>
        /// JavaScript script column number (0-based).
        /// </summary>
        [JsonPropertyName("columnNumber")]
        public int ColumnNumber
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Call frames for assertions or error messages.
    /// </summary>
    public partial class StackTrace : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// String label of this stack trace. For async traces this may be a name of the function that
        /// initiated the async call.
        /// </summary>
        [JsonPropertyName("description")]
        public string Description
        {
            get;
            set;
        }

        /// <summary>
        /// JavaScript function name.
        /// </summary>
        [JsonPropertyName("callFrames")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public System.Collections.Generic.IList<CefSharp.DevTools.Runtime.CallFrame> CallFrames
        {
            get;
            set;
        }

        /// <summary>
        /// Asynchronous JavaScript stack trace that preceded this stack, if available.
        /// </summary>
        [JsonPropertyName("parent")]
        public CefSharp.DevTools.Runtime.StackTrace Parent
        {
            get;
            set;
        }

        /// <summary>
        /// Asynchronous JavaScript stack trace that preceded this stack, if available.
        /// </summary>
        [JsonPropertyName("parentId")]
        public CefSharp.DevTools.Runtime.StackTraceId ParentId
        {
            get;
            set;
        }
    }

    /// <summary>
    /// If `debuggerId` is set stack trace comes from another debugger and can be resolved there. This
    /// allows to track cross-debugger calls. See `Runtime.StackTrace` and `Debugger.paused` for usages.
    /// </summary>
    public partial class StackTraceId : CefSharp.DevTools.DevToolsDomainEntityBase
    {
        /// <summary>
        /// Id
        /// </summary>
        [JsonPropertyName("id")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Id
        {
            get;
            set;
        }

        /// <summary>
        /// DebuggerId
        /// </summary>
        [JsonPropertyName("debuggerId")]
        public string DebuggerId
        {
            get;
            set;
        }
    }

    /// <summary>
    /// Notification is issued every time when binding is called.
    /// </summary>
    public class BindingCalledEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Name
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("name")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Name
        {
            get;
            private set;
        }

        /// <summary>
        /// Payload
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("payload")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Payload
        {
            get;
            private set;
        }

        /// <summary>
        /// Identifier of the context where the call was made.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("executionContextId")]
        public int ExecutionContextId
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Type of the call.
    /// </summary>
    public enum ConsoleAPICalledType
    {
        /// <summary>
        /// log
        /// </summary>
        [JsonPropertyName("log")]
        Log,
        /// <summary>
        /// debug
        /// </summary>
        [JsonPropertyName("debug")]
        Debug,
        /// <summary>
        /// info
        /// </summary>
        [JsonPropertyName("info")]
        Info,
        /// <summary>
        /// error
        /// </summary>
        [JsonPropertyName("error")]
        Error,
        /// <summary>
        /// warning
        /// </summary>
        [JsonPropertyName("warning")]
        Warning,
        /// <summary>
        /// dir
        /// </summary>
        [JsonPropertyName("dir")]
        Dir,
        /// <summary>
        /// dirxml
        /// </summary>
        [JsonPropertyName("dirxml")]
        Dirxml,
        /// <summary>
        /// table
        /// </summary>
        [JsonPropertyName("table")]
        Table,
        /// <summary>
        /// trace
        /// </summary>
        [JsonPropertyName("trace")]
        Trace,
        /// <summary>
        /// clear
        /// </summary>
        [JsonPropertyName("clear")]
        Clear,
        /// <summary>
        /// startGroup
        /// </summary>
        [JsonPropertyName("startGroup")]
        StartGroup,
        /// <summary>
        /// startGroupCollapsed
        /// </summary>
        [JsonPropertyName("startGroupCollapsed")]
        StartGroupCollapsed,
        /// <summary>
        /// endGroup
        /// </summary>
        [JsonPropertyName("endGroup")]
        EndGroup,
        /// <summary>
        /// assert
        /// </summary>
        [JsonPropertyName("assert")]
        Assert,
        /// <summary>
        /// profile
        /// </summary>
        [JsonPropertyName("profile")]
        Profile,
        /// <summary>
        /// profileEnd
        /// </summary>
        [JsonPropertyName("profileEnd")]
        ProfileEnd,
        /// <summary>
        /// count
        /// </summary>
        [JsonPropertyName("count")]
        Count,
        /// <summary>
        /// timeEnd
        /// </summary>
        [JsonPropertyName("timeEnd")]
        TimeEnd
    }

    /// <summary>
    /// Issued when console API was called.
    /// </summary>
    public class ConsoleAPICalledEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Type of the call.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("type")]
        public CefSharp.DevTools.Runtime.ConsoleAPICalledType Type
        {
            get;
            private set;
        }

        /// <summary>
        /// Call arguments.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("args")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public System.Collections.Generic.IList<CefSharp.DevTools.Runtime.RemoteObject> Args
        {
            get;
            private set;
        }

        /// <summary>
        /// Identifier of the context where the call was made.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("executionContextId")]
        public int ExecutionContextId
        {
            get;
            private set;
        }

        /// <summary>
        /// Call timestamp.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("timestamp")]
        public double Timestamp
        {
            get;
            private set;
        }

        /// <summary>
        /// Stack trace captured when the call was made. The async stack chain is automatically reported for
        /// the following call types: `assert`, `error`, `trace`, `warning`. For other types the async call
        /// chain can be retrieved using `Debugger.getStackTrace` and `stackTrace.parentId` field.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("stackTrace")]
        public CefSharp.DevTools.Runtime.StackTrace StackTrace
        {
            get;
            private set;
        }

        /// <summary>
        /// Console context descriptor for calls on non-default console context (not console.*):
        /// &apos;anonymous#unique-logger-id&apos; for call on unnamed context, &apos;name#unique-logger-id&apos; for call
        /// on named context.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("context")]
        public string Context
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Issued when unhandled exception was revoked.
    /// </summary>
    public class ExceptionRevokedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Reason describing why exception was revoked.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("reason")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string Reason
        {
            get;
            private set;
        }

        /// <summary>
        /// The id of revoked exception, as reported in `exceptionThrown`.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("exceptionId")]
        public int ExceptionId
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Issued when exception was thrown and unhandled.
    /// </summary>
    public class ExceptionThrownEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Timestamp of the exception.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("timestamp")]
        public double Timestamp
        {
            get;
            private set;
        }

        /// <summary>
        /// ExceptionDetails
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("exceptionDetails")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.Runtime.ExceptionDetails ExceptionDetails
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Issued when new execution context is created.
    /// </summary>
    public class ExecutionContextCreatedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// A newly created execution context.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("context")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.Runtime.ExecutionContextDescription Context
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Issued when execution context is destroyed.
    /// </summary>
    public class ExecutionContextDestroyedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Id of the destroyed context
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("executionContextId")]
        public int ExecutionContextId
        {
            get;
            private set;
        }

        /// <summary>
        /// Unique Id of the destroyed context
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("executionContextUniqueId")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public string ExecutionContextUniqueId
        {
            get;
            private set;
        }
    }

    /// <summary>
    /// Issued when object should be inspected (for example, as a result of inspect() command line API
    /// call).
    /// </summary>
    public class InspectRequestedEventArgs : CefSharp.DevTools.DevToolsDomainEventArgsBase
    {
        /// <summary>
        /// Object
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("object")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public CefSharp.DevTools.Runtime.RemoteObject Object
        {
            get;
            private set;
        }

        /// <summary>
        /// Hints
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("hints")]
        [System.Diagnostics.CodeAnalysis.DisallowNull]
        public object Hints
        {
            get;
            private set;
        }

        /// <summary>
        /// Identifier of the context where the call was made.
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("executionContextId")]
        public int? ExecutionContextId
        {
            get;
            private set;
        }
    }
}

namespace CefSharp.DevTools.Accessibility
{
    /// <summary>
    /// GetPartialAXTreeResponse
    /// </summary>
    public class GetPartialAXTreeResponse : DevToolsDomainResponseBase
    {
        /// <summary>
        /// nodes
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("nodes")]
        public System.Collections.Generic.IList<CefSharp.DevTools.Accessibility.AXNode> Nodes
        {
            get;
            private set;
        }
    }
}

namespace CefSharp.DevTools.Accessibility
{
    /// <summary>
    /// GetFullAXTreeResponse
    /// </summary>
    public class GetFullAXTreeResponse : DevToolsDomainResponseBase
    {
        /// <summary>
        /// nodes
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("nodes")]
        public System.Collections.Generic.IList<CefSharp.DevTools.Accessibility.AXNode> Nodes
        {
            get;
            private set;
        }
    }
}

namespace CefSharp.DevTools.Accessibility
{
    /// <summary>
    /// GetRootAXNodeResponse
    /// </summary>
    public class GetRootAXNodeResponse : DevToolsDomainResponseBase
    {
        /// <summary>
        /// node
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("node")]
        public CefSharp.DevTools.Accessibility.AXNode Node
        {
            get;
            private set;
        }
    }
}

namespace CefSharp.DevTools.Accessibility
{
    /// <summary>
    /// GetAXNodeAndAncestorsResponse
    /// </summary>
    public class GetAXNodeAndAncestorsResponse : DevToolsDomainResponseBase
    {
        /// <summary>
        /// nodes
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("nodes")]
        public System.Collections.Generic.IList<CefSharp.DevTools.Accessibility.AXNode> Nodes
        {
            get;
            private set;
        }
    }
}

namespace CefSharp.DevTools.Accessibility
{
    /// <summary>
    /// GetChildAXNodesResponse
    /// </summary>
    public class GetChildAXNodesResponse : DevToolsDomainResponseBase
    {
        /// <summary>
        /// nodes
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("nodes")]
        public System.Collections.Generic.IList<CefSharp.DevTools.Accessibility.AXNode> Nodes
        {
            get;
            private set;
        }
    }
}

namespace CefSharp.DevTools.Accessibility
{
    /// <summary>
    /// QueryAXTreeResponse
    /// </summary>
    public class QueryAXTreeResponse : DevToolsDomainResponseBase
    {
        /// <summary>
        /// nodes
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("nodes")]
        public System.Collections.Generic.IList<CefSharp.DevTools.Accessibility.AXNode> Nodes
        {
            get;
            private set;
        }
    }
}

namespace CefSharp.DevTools.Accessibility
{
    using System.Linq;

    /// <summary>
    /// Accessibility
    /// </summary>
    public partial class AccessibilityClient : DevToolsDomainBase
    {
        private CefSharp.DevTools.IDevToolsClient _client;
        /// <summary>
        /// Accessibility
        /// </summary>
        /// <param name = "client">DevToolsClient</param>
        public AccessibilityClient(CefSharp.DevTools.IDevToolsClient client)
        {
            _client = (client);
        }

        /// <summary>
        /// The loadComplete event mirrors the load complete event sent by the browser to assistive
        /// technology when the web page has finished loading.
        /// </summary>
        public event System.EventHandler<LoadCompleteEventArgs> LoadComplete
        {
            add
            {
                _client.AddEventHandler<LoadCompleteEventArgs>("Accessibility.loadComplete", value);
            }

            remove
            {
                _client.RemoveEventHandler<LoadCompleteEventArgs>("Accessibility.loadComplete", value);
            }
        }

        /// <summary>
        /// The nodesUpdated event is sent every time a previously requested node has changed the in tree.
        /// </summary>
        public event System.EventHandler<NodesUpdatedEventArgs> NodesUpdated
        {
            add
            {
                _client.AddEventHandler<NodesUpdatedEventArgs>("Accessibility.nodesUpdated", value);
            }

            remove
            {
                _client.RemoveEventHandler<NodesUpdatedEventArgs>("Accessibility.nodesUpdated", value);
            }
        }

        /// <summary>
        /// Disables the accessibility domain.
        /// </summary>
        /// <returns>returns System.Threading.Tasks.Task&lt;DevToolsMethodResponse&gt;</returns>
        public System.Threading.Tasks.Task<DevToolsMethodResponse> DisableAsync()
        {
            System.Collections.Generic.Dictionary<string, object> dict = null;
            return _client.ExecuteDevToolsMethodAsync<DevToolsMethodResponse>("Accessibility.disable", dict);
        }

        /// <summary>
        /// Enables the accessibility domain which causes `AXNodeId`s to remain consistent between method calls.
        /// This turns on accessibility for the page, which can impact performance until accessibility is disabled.
        /// </summary>
        /// <returns>returns System.Threading.Tasks.Task&lt;DevToolsMethodResponse&gt;</returns>
        public System.Threading.Tasks.Task<DevToolsMethodResponse> EnableAsync()
        {
            System.Collections.Generic.Dictionary<string, object> dict = null;
            return _client.ExecuteDevToolsMethodAsync<DevToolsMethodResponse>("Accessibility.enable", dict);
        }

        partial void ValidateGetPartialAXTree(int? nodeId = null, int? backendNodeId = null, string objectId = null, bool? fetchRelatives = null);
        /// <summary>
        /// Fetches the accessibility node and partial accessibility tree for this DOM node, if it exists.
        /// </summary>
        /// <param name = "nodeId">Identifier of the node to get the partial accessibility tree for.</param>
        /// <param name = "backendNodeId">Identifier of the backend node to get the partial accessibility tree for.</param>
        /// <param name = "objectId">JavaScript object id of the node wrapper to get the partial accessibility tree for.</param>
        /// <param name = "fetchRelatives">Whether to fetch this node's ancestors, siblings and children. Defaults to true.</param>
        /// <returns>returns System.Threading.Tasks.Task&lt;GetPartialAXTreeResponse&gt;</returns>
        public System.Threading.Tasks.Task<GetPartialAXTreeResponse> GetPartialAXTreeAsync(int? nodeId = null, int? backendNodeId = null, string objectId = null, bool? fetchRelatives = null)
        {
            ValidateGetPartialAXTree(nodeId, backendNodeId, objectId, fetchRelatives);
            var dict = new System.Collections.Generic.Dictionary<string, object>();
            if (nodeId.HasValue)
            {
                dict.Add("nodeId", nodeId.Value);
            }

            if (backendNodeId.HasValue)
            {
                dict.Add("backendNodeId", backendNodeId.Value);
            }

            if (!(string.IsNullOrEmpty(objectId)))
            {
                dict.Add("objectId", objectId);
            }

            if (fetchRelatives.HasValue)
            {
                dict.Add("fetchRelatives", fetchRelatives.Value);
            }

            return _client.ExecuteDevToolsMethodAsync<GetPartialAXTreeResponse>("Accessibility.getPartialAXTree", dict);
        }

        partial void ValidateGetFullAXTree(int? depth = null, string frameId = null);
        /// <summary>
        /// Fetches the entire accessibility tree for the root Document
        /// </summary>
        /// <param name = "depth">The maximum depth at which descendants of the root node should be retrieved.If omitted, the full tree is returned.</param>
        /// <param name = "frameId">The frame for whose document the AX tree should be retrieved.If omitted, the root frame is used.</param>
        /// <returns>returns System.Threading.Tasks.Task&lt;GetFullAXTreeResponse&gt;</returns>
        public System.Threading.Tasks.Task<GetFullAXTreeResponse> GetFullAXTreeAsync(int? depth = null, string frameId = null)
        {
            ValidateGetFullAXTree(depth, frameId);
            var dict = new System.Collections.Generic.Dictionary<string, object>();
            if (depth.HasValue)
            {
                dict.Add("depth", depth.Value);
            }

            if (!(string.IsNullOrEmpty(frameId)))
            {
                dict.Add("frameId", frameId);
            }

            return _client.ExecuteDevToolsMethodAsync<GetFullAXTreeResponse>("Accessibility.getFullAXTree", dict);
        }

        partial void ValidateGetRootAXNode(string frameId = null);
        /// <summary>
        /// Fetches the root node.
        /// Requires `enable()` to have been called previously.
        /// </summary>
        /// <param name = "frameId">The frame in whose document the node resides.If omitted, the root frame is used.</param>
        /// <returns>returns System.Threading.Tasks.Task&lt;GetRootAXNodeResponse&gt;</returns>
        public System.Threading.Tasks.Task<GetRootAXNodeResponse> GetRootAXNodeAsync(string frameId = null)
        {
            ValidateGetRootAXNode(frameId);
            var dict = new System.Collections.Generic.Dictionary<string, object>();
            if (!(string.IsNullOrEmpty(frameId)))
            {
                dict.Add("frameId", frameId);
            }

            return _client.ExecuteDevToolsMethodAsync<GetRootAXNodeResponse>("Accessibility.getRootAXNode", dict);
        }

        partial void ValidateGetAXNodeAndAncestors(int? nodeId = null, int? backendNodeId = null, string objectId = null);
        /// <summary>
        /// Fetches a node and all ancestors up to and including the root.
        /// Requires `enable()` to have been called previously.
        /// </summary>
        /// <param name = "nodeId">Identifier of the node to get.</param>
        /// <param name = "backendNodeId">Identifier of the backend node to get.</param>
        /// <param name = "objectId">JavaScript object id of the node wrapper to get.</param>
        /// <returns>returns System.Threading.Tasks.Task&lt;GetAXNodeAndAncestorsResponse&gt;</returns>
        public System.Threading.Tasks.Task<GetAXNodeAndAncestorsResponse> GetAXNodeAndAncestorsAsync(int? nodeId = null, int? backendNodeId = null, string objectId = null)
        {
            ValidateGetAXNodeAndAncestors(nodeId, backendNodeId, objectId);
            var dict = new System.Collections.Generic.Dictionary<string, object>();
            if (nodeId.HasValue)
            {
                dict.Add("nodeId", nodeId.Value);
            }

            if (backendNodeId.HasValue)
            {
                dict.Add("backendNodeId", backendNodeId.Value);
            }

            if (!(string.IsNullOrEmpty(objectId)))
            {
                dict.Add("objectId", objectId);
            }

            return _client.ExecuteDevToolsMethodAsync<GetAXNodeAndAncestorsResponse>("Accessibility.getAXNodeAndAncestors", dict);
        }

        partial void ValidateGetChildAXNodes(string id, string frameId = null);
        /// <summary>
        /// Fetches a particular accessibility node by AXNodeId.
        /// Requires `enable()` to have been called previously.
        /// </summary>
        /// <param name = "id">id</param>
        /// <param name = "frameId">The frame in whose document the node resides.If omitted, the root frame is used.</param>
        /// <returns>returns System.Threading.Tasks.Task&lt;GetChildAXNodesResponse&gt;</returns>
        public System.Threading.Tasks.Task<GetChildAXNodesResponse> GetChildAXNodesAsync(string id, string frameId = null)
        {
            ValidateGetChildAXNodes(id, frameId);
            var dict = new System.Collections.Generic.Dictionary<string, object>();
            dict.Add("id", id);
            if (!(string.IsNullOrEmpty(frameId)))
            {
                dict.Add("frameId", frameId);
            }

            return _client.ExecuteDevToolsMethodAsync<GetChildAXNodesResponse>("Accessibility.getChildAXNodes", dict);
        }

        partial void ValidateQueryAXTree(int? nodeId = null, int? backendNodeId = null, string objectId = null, string accessibleName = null, string role = null);
        /// <summary>
        /// Query a DOM node&apos;s accessibility subtree for accessible name and role.
        /// This command computes the name and role for all nodes in the subtree, including those that are
        /// ignored for accessibility, and returns those that match the specified name and role. If no DOM
        /// node is specified, or the DOM node does not exist, the command returns an error. If neither
        /// `accessibleName` or `role` is specified, it returns all the accessibility nodes in the subtree.
        /// </summary>
        /// <param name = "nodeId">Identifier of the node for the root to query.</param>
        /// <param name = "backendNodeId">Identifier of the backend node for the root to query.</param>
        /// <param name = "objectId">JavaScript object id of the node wrapper for the root to query.</param>
        /// <param name = "accessibleName">Find nodes with this computed name.</param>
        /// <param name = "role">Find nodes with this computed role.</param>
        /// <returns>returns System.Threading.Tasks.Task&lt;QueryAXTreeResponse&gt;</returns>
        public System.Threading.Tasks.Task<QueryAXTreeResponse> QueryAXTreeAsync(int? nodeId = null, int? backendNodeId = null, string objectId = null, string accessibleName = null, string role = null)
        {
            ValidateQueryAXTree(nodeId, backendNodeId, objectId, accessibleName, role);
            var dict = new System.Collections.Generic.Dictionary<string, object>();
            if (nodeId.HasValue)
            {
                dict.Add("nodeId", nodeId.Value);
            }

            if (backendNodeId.HasValue)
            {
                dict.Add("backendNodeId", backendNodeId.Value);
            }

            if (!(string.IsNullOrEmpty(objectId)))
            {
                dict.Add("objectId", objectId);
            }

            if (!(string.IsNullOrEmpty(accessibleName)))
            {
                dict.Add("accessibleName", accessibleName);
            }

            if (!(string.IsNullOrEmpty(role)))
            {
                dict.Add("role", role);
            }

            return _client.ExecuteDevToolsMethodAsync<QueryAXTreeResponse>("Accessibility.queryAXTree", dict);
        }
    }
}

namespace CefSharp.DevTools.Animation
{
    /// <summary>
    /// GetCurrentTimeResponse
    /// </summary>
    public class GetCurrentTimeResponse : DevToolsDomainResponseBase
    {
        /// <summary>
        /// currentTime
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("currentTime")]
        public double CurrentTime
        {
            get;
            private set;
        }
    }
}

namespace CefSharp.DevTools.Animation
{
    /// <summary>
    /// GetPlaybackRateResponse
    /// </summary>
    public class GetPlaybackRateResponse : DevToolsDomainResponseBase
    {
        /// <summary>
        /// playbackRate
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("playbackRate")]
        public double PlaybackRate
        {
            get;
            private set;
        }
    }
}

namespace CefSharp.DevTools.Animation
{
    /// <summary>
    /// ResolveAnimationResponse
    /// </summary>
    public class ResolveAnimationResponse : DevToolsDomainResponseBase
    {
        /// <summary>
        /// remoteObject
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("remoteObject")]
        public CefSharp.DevTools.Runtime.RemoteObject RemoteObject
        {
            get;
            private set;
        }
    }
}

namespace CefSharp.DevTools.Animation
{
    using System.Linq;

    /// <summary>
    /// Animation
    /// </summary>
    public partial class AnimationClient : DevToolsDomainBase
    {
        private CefSharp.DevTools.IDevToolsClient _client;
        /// <summary>
        /// Animation
        /// </summary>
        /// <param name = "client">DevToolsClient</param>
        public AnimationClient(CefSharp.DevTools.IDevToolsClient client)
        {
            _client = (client);
        }

        /// <summary>
        /// Event for when an animation has been cancelled.
        /// </summary>
        public event System.EventHandler<AnimationCanceledEventArgs> AnimationCanceled
        {
            add
            {
                _client.AddEventHandler<AnimationCanceledEventArgs>("Animation.animationCanceled", value);
            }

            remove
            {
                _client.RemoveEventHandler<AnimationCanceledEventArgs>("Animation.animationCanceled", value);
            }
        }

        /// <summary>
        /// Event for each animation that has been created.
        /// </summary>
        public event System.EventHandler<AnimationCreatedEventArgs> AnimationCreated
        {
            add
            {
                _client.AddEventHandler<AnimationCreatedEventArgs>("Animation.animationCreated", value);
            }

            remove
            {
                _client.RemoveEventHandler<AnimationCreatedEventArgs>("Animation.animationCreated", value);
            }
        }

        /// <summary>
        /// Event for animation that has been started.
        /// </summary>
        public event System.EventHandler<AnimationStartedEventArgs> AnimationStarted
        {
            add
            {
                _client.AddEventHandler<AnimationStartedEventArgs>("Animation.animationStarted", value);
            }

            remove
            {
                _client.RemoveEventHandler<AnimationStartedEventArgs>("Animation.animationStarted", value);
            }
        }

        /// <summary>
        /// Event for animation that has been updated.
        /// </summary>
        public event System.EventHandler<AnimationUpdatedEventArgs> AnimationUpdated
        {
            add
            {
                _client.AddEventHandler<AnimationUpdatedEventArgs>("Animation.animationUpdated", value);
            }

            remove
            {
                _client.RemoveEventHandler<AnimationUpdatedEventArgs>("Animation.animationUpdated", value);
            }
        }

        /// <summary>
        /// Disables animation domain notifications.
        /// </summary>
        /// <returns>returns System.Threading.Tasks.Task&lt;DevToolsMethodResponse&gt;</returns>
        public System.Threading.Tasks.Task<DevToolsMethodResponse> DisableAsync()
        {
            System.Collections.Generic.Dictionary<string, object> dict = null;
            return _client.ExecuteDevToolsMethodAsync<DevToolsMethodResponse>("Animation.disable", dict);
        }

        /// <summary>
        /// Enables animation domain notifications.
        /// </summary>
        /// <returns>returns System.Threading.Tasks.Task&lt;DevToolsMethodResponse&gt;</returns>
        public System.Threading.Tasks.Task<DevToolsMethodResponse> EnableAsync()
        {
            System.Collections.Generic.Dictionary<string, object> dict = null;
            return _client.ExecuteDevToolsMethodAsync<DevToolsMethodResponse>("Animation.enable", dict);
        }

        partial void ValidateGetCurrentTime(string id);
        /// <summary>
        /// Returns the current time of the an animation.
        /// </summary>
        /// <param name = "id">Id of animation.</param>
        /// <returns>returns System.Threading.Tasks.Task&lt;GetCurrentTimeResponse&gt;</returns>
        public System.Threading.Tasks.Task<GetCurrentTimeResponse> GetCurrentTimeAsync(string id)
        {
            ValidateGetCurrentTime(id);
            var dict = new System.Collections.Generic.Dictionary<string, object>();
            dict.Add("id", id);
            return _client.ExecuteDevToolsMethodAsync<GetCurrentTimeResponse>("Animation.getCurrentTime", dict);
        }

        /// <summary>
        /// Gets the playback rate of the document timeline.
        /// </summary>
        /// <returns>returns System.Threading.Tasks.Task&lt;GetPlaybackRateResponse&gt;</returns>
        public System.Threading.Tasks.Task<GetPlaybackRateResponse> GetPlaybackRateAsync()
        {
            System.Collections.Generic.Dictionary<string, object> dict = null;
            return _client.ExecuteDevToolsMethodAsync<GetPlaybackRateResponse>("Animation.getPlaybackRate", dict);
        }

        partial void ValidateReleaseAnimations(string[] animations);
        /// <summary>
        /// Releases a set of animations to no longer be manipulated.
        /// </summary>
        /// <param name = "animations">List of animation ids to seek.</param>
        /// <returns>returns System.Threading.Tasks.Task&lt;DevToolsMethodResponse&gt;</returns>
        public System.Threading.Tasks.Task<DevToolsMethodResponse> ReleaseAnimationsAsync(string[] animations)
        {
            ValidateReleaseAnimations(animations);
            var dict = new System.Collections.Generic.Dictionary<string, object>();
            dict.Add("animations", animations);
            return _client.ExecuteDevToolsMethodAsync<DevToolsMethodResponse>("Animation.releaseAnimations", dict);
        }

        partial void ValidateResolveAnimation(string animationId);
        /// <summary>
        /// Gets the remote object of the Animation.
        /// </summary>
        /// <param name = "animationId">Animation id.</param>
        /// <returns>returns System.Threading.Tasks.Task&lt;ResolveAnimationResponse&gt;</returns>
        public System.Threading.Tasks.Task<ResolveAnimationResponse> ResolveAnimationAsync(string animationId)
        {
            ValidateResolveAnimation(animationId);
            var dict = new System.Collections.Generic.Dictionary<string, object>();
            dict.Add("animationId", animationId);
            return _client.ExecuteDevToolsMethodAsync<ResolveAnimationResponse>("Animation.resolveAnimation", dict);
        }

        partial void ValidateSeekAnimations(string[] animations, double currentTime);
        /// <summary>
        /// Seek a set of animations to a particular time within each animation.
        /// </summary>
        /// <param name = "animations">List of animation ids to seek.</param>
        /// <param name = "currentTime">Set the current time of each animation.</param>
        /// <returns>returns System.Threading.Tasks.Task&lt;DevToolsMethodResponse&gt;</returns>
        public System.Threading.Tasks.Task<DevToolsMethodResponse> SeekAnimationsAsync(string[] animations, double currentTime)
        {
            ValidateSeekAnimations(animations, currentTime);
            var dict = new System.Collections.Generic.Dictionary<string, object>();
            dict.Add("animations", animations);
            dict.Add("currentTime", currentTime);
            return _client.ExecuteDevToolsMethodAsync<DevToolsMethodResponse>("Animation.seekAnimations", dict);
        }

        partial void ValidateSetPaused(string[] animations, bool paused);
        /// <summary>
        /// Sets the paused state of a set of animations.
        /// </summary>
        /// <param name = "animations">Animations to set the pause state of.</param>
        /// <param name = "paused">Paused state to set to.</param>
        /// <returns>returns System.Threading.Tasks.Task&lt;DevToolsMethodResponse&gt;</returns>
        public System.Threading.Tasks.Task<DevToolsMethodResponse> SetPausedAsync(string[] animations, bool paused)
        {
            ValidateSetPaused(animations, paused);
            var dict = new System.Collections.Generic.Dictionary<string, object>();
            dict.Add("animations", animations);
            dict.Add("paused", paused);
            return _client.ExecuteDevToolsMethodAsync<DevToolsMethodResponse>("Animation.setPaused", dict);
        }

        partial void ValidateSetPlaybackRate(double playbackRate);
        /// <summary>
        /// Sets the playback rate of the document timeline.
        /// </summary>
        /// <param name = "playbackRate">Playback rate for animations on page</param>
        /// <returns>returns System.Threading.Tasks.Task&lt;DevToolsMethodResponse&gt;</returns>
        public System.Threading.Tasks.Task<DevToolsMethodResponse> SetPlaybackRateAsync(double playbackRate)
        {
            ValidateSetPlaybackRate(playbackRate);
            var dict = new System.Collections.Generic.Dictionary<string, object>();
            dict.Add("playbackRate", playbackRate);
            return _client.ExecuteDevToolsMethodAsync<DevToolsMethodResponse>("Animation.setPlaybackRate", dict);
        }

        partial void ValidateSetTiming(string animationId, double duration, double delay);
        /// <summary>
        /// Sets the timing of an animation node.
        /// </summary>
        /// <param name = "animationId">Animation id.</param>
        /// <param name = "duration">Duration of the animation.</param>
        /// <param name = "delay">Delay of the animation.</param>
        /// <returns>returns System.Threading.Tasks.Task&lt;DevToolsMethodResponse&gt;</returns>
        public System.Threading.Tasks.Task<DevToolsMethodResponse> SetTimingAsync(string animationId, double duration, double delay)
        {
            ValidateSetTiming(animationId, duration, delay);
            var dict = new System.Collections.Generic.Dictionary<string, object>();
            dict.Add("animationId", animationId);
            dict.Add("duration", duration);
            dict.Add("delay", delay);
            return _client.ExecuteDevToolsMethodAsync<DevToolsMethodResponse>("Animation.setTiming", dict);
        }
    }
}

namespace CefSharp.DevTools.Audits
{
    /// <summary>
    /// GetEncodedResponseResponse
    /// </summary>
    public class GetEncodedResponseResponse : DevToolsDomainResponseBase
    {
        /// <summary>
        /// body
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("body")]
        public byte[] Body
        {
            get;
            private set;
        }

        /// <summary>
        /// originalSize
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("originalSize")]
        public int OriginalSize
        {
            get;
            private set;
        }

        /// <summary>
        /// encodedSize
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("encodedSize")]
        public int EncodedSize
        {
            get;
            private set;
        }
    }
}

namespace CefSharp.DevTools.Audits
{
    /// <summary>
    /// CheckFormsIssuesResponse
    /// </summary>
    public class CheckFormsIssuesResponse : DevToolsDomainResponseBase
    {
        /// <summary>
        /// formIssues
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("formIssues")]
        public System.Collections.Generic.IList<CefSharp.DevTools.Audits.GenericIssueDetails> FormIssues
        {
            get;
            private set;
        }
    }
}

namespace CefSharp.DevTools.Audits
{
    using System.Linq;

    /// <summary>
    /// The encoding to use.
    /// </summary>
    public enum GetEncodedResponseEncoding
    {
        /// <summary>
        /// webp
        /// </summary>
        [JsonPropertyName("webp")]
        Webp,
        /// <summary>
        /// jpeg
        /// </summary>
        [JsonPropertyName("jpeg")]
        Jpeg,
        /// <summary>
        /// png
        /// </summary>
        [JsonPropertyName("png")]
        Png
    }

    /// <summary>
    /// Audits domain allows investigation of page violations and possible improvements.
    /// </summary>
    public partial class AuditsClient : DevToolsDomainBase
    {
        private CefSharp.DevTools.IDevToolsClient _client;
        /// <summary>
        /// Audits
        /// </summary>
        /// <param name = "client">DevToolsClient</param>
        public AuditsClient(CefSharp.DevTools.IDevToolsClient client)
        {
            _client = (client);
        }

        /// <summary>
        /// IssueAdded
        /// </summary>
        public event System.EventHandler<IssueAddedEventArgs> IssueAdded
        {
            add
            {
                _client.AddEventHandler<IssueAddedEventArgs>("Audits.issueAdded", value);
            }

            remove
            {
                _client.RemoveEventHandler<IssueAddedEventArgs>("Audits.issueAdded", value);
            }
        }

        partial void ValidateGetEncodedResponse(string requestId, CefSharp.DevTools.Audits.GetEncodedResponseEncoding encoding, double? quality = null, bool? sizeOnly = null);
        /// <summary>
        /// Returns the response body and size if it were re-encoded with the specified settings. Only
        /// applies to images.
        /// </summary>
        /// <param name = "requestId">Identifier of the network request to get content for.</param>
        /// <param name = "encoding">The encoding to use.</param>
        /// <param name = "quality">The quality of the encoding (0-1). (defaults to 1)</param>
        /// <param name = "sizeOnly">Whether to only return the size information (defaults to false).</param>
        /// <returns>returns System.Threading.Tasks.Task&lt;GetEncodedResponseResponse&gt;</returns>
        public System.Threading.Tasks.Task<GetEncodedResponseResponse> GetEncodedResponseAsync(string requestId, CefSharp.DevTools.Audits.GetEncodedResponseEncoding encoding, double? quality = null, bool? sizeOnly = null)
        {
            ValidateGetEncodedResponse(requestId, encoding, quality, sizeOnly);
            var dict = new System.Collections.Generic.Dictionary<string, object>();
            dict.Add("requestId", requestId);
            dict.Add("encoding", EnumToString(encoding));
            if (quality.HasValue)
            {
                dict.Add("quality", quality.Value);
            }

            if (sizeOnly.HasValue)
            {
                dict.Add("sizeOnly", sizeOnly.Value);
            }

            return _client.ExecuteDevToolsMethodAsync<GetEncodedResponseResponse>("Audits.getEncodedResponse", dict);
        }

        /// <summary>
        /// Disables issues domain, prevents further issues from being reported to the client.
        /// </summary>
        /// <returns>returns System.Threading.Tasks.Task&lt;DevToolsMethodResponse&gt;</returns>
        public System.Threading.Tasks.Task<DevToolsMethodResponse> DisableAsync()
        {
            System.Collections.Generic.Dictionary<string, object> dict = null;
            return _client.ExecuteDevToolsMethodAsync<DevToolsMethodResponse>("Audits.disable", dict);
        }

        /// <summary>
        /// Enables issues domain, sends the issues collected so far to the client by means of the
        /// `issueAdded` event.
        /// </summary>
        /// <returns>returns System.Threading.Tasks.Task&lt;DevToolsMethodResponse&gt;</returns>
        public System.Threading.Tasks.Task<DevToolsMethodResponse> EnableAsync()
        {
            System.Collections.Generic.Dictionary<string, object> dict = null;
            return _client.ExecuteDevToolsMethodAsync<DevToolsMethodResponse>("Audits.enable", dict);
        }

        partial void ValidateCheckContrast(bool? reportAAA = null);
        /// <summary>
        /// Runs the contrast check for the target page. Found issues are reported
        /// using Audits.issueAdded event.
        /// </summary>
        /// <param name = "reportAAA">Whether to report WCAG AAA level issues. Default is false.</param>
        /// <returns>returns System.Threading.Tasks.Task&lt;DevToolsMethodResponse&gt;</returns>
        public System.Threading.Tasks.Task<DevToolsMethodResponse> CheckContrastAsync(bool? reportAAA = null)
        {
            ValidateCheckContrast(reportAAA);
            var dict = new System.Collections.Generic.Dictionary<string, object>();
            if (reportAAA.HasValue)
            {
                dict.Add("reportAAA", reportAAA.Value);
            }

            return _client.ExecuteDevToolsMethodAsync<DevToolsMethodResponse>("Audits.checkContrast", dict);
        }

        /// <summary>
        /// Runs the form issues check for the target page. Found issues are reported
        /// using Audits.issueAdded event.
        /// </summary>
        /// <returns>returns System.Threading.Tasks.Task&lt;CheckFormsIssuesResponse&gt;</returns>
        public System.Threading.Tasks.Task<CheckFormsIssuesResponse> CheckFormsIssuesAsync()
        {
            System.Collections.Generic.Dictionary<string, object> dict = null;
            return _client.ExecuteDevToolsMethodAsync<CheckFormsIssuesResponse>("Audits.checkFormsIssues", dict);
        }
    }
}

namespace CefSharp.DevTools.Extensions
{
    /// <summary>
    /// LoadUnpackedResponse
    /// </summary>
    public class LoadUnpackedResponse : DevToolsDomainResponseBase
    {
        /// <summary>
        /// id
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("id")]
        public string Id
        {
            get;
            private set;
        }
    }
}

namespace CefSharp.DevTools.Extensions
{
    /// <summary>
    /// GetStorageItemsResponse
    /// </summary>
    public class GetStorageItemsResponse : DevToolsDomainResponseBase
    {
        /// <summary>
        /// data
        /// </summary>
        [JsonInclude]
        [JsonPropertyName("data")]
        public object Data
        {
            get;
            private set;
        }
    }
}

namespace CefSharp.DevTools.Extensions
{
    using System.Linq;

    /// <summary>
    /// Defines commands and events for browser extensions.
    /// </summary>
    public partial class ExtensionsClient : DevToolsDomainBase
    {
        private CefSharp.DevTools.IDevToolsClient _client;
        /// <summary>
        /// Extensions
        /// </summary>
        /// <param name = "client">DevToolsClient</param>
        public ExtensionsClient(CefSharp.DevTools.IDevToolsClient client)
        {
            _client = (client);
        }

        partial void ValidateLoadUnpacked(string path);
        /// <summary>
        /// Installs an unpacked extension from the filesystem similar to
        /// --load-extension CLI flags. Returns extension ID once the extension
        /// has been installed. Available if the client is connected using the
        /// --remote-debugging-pipe flag and the --enable-unsafe-extension-debugging
        /// flag is set.
        /// </summary>
        /// <param name = "path">Absolute file path.</param>
        /// <returns>returns System.Threading.Tasks.Task&lt;LoadUnpackedResponse&gt;</returns>
        public System.Threading.Tasks.Task<LoadUnpackedResponse> LoadUnpackedAsync(string path)
        {
            ValidateLoadUnpacked(path);
            var dict = new System.Collections.Generic.Dictionary<string, object>();
            dict.Add("path", path);
            return _client.ExecuteDevToolsMethodAsync<LoadUnpackedResponse>("Extensions.loadUnpacked", dict);
        }

        partial void ValidateGetStorageItems(string id, CefSharp.DevTools.Extensions.StorageArea storageArea, string[] keys = null);
        /// <summary>
        /// Gets data from extension storage in the given `storageArea`. If `keys` is
        /// specified, these are used to filter the result.
        /// </summary>
        /// <param name = "id">ID of extension.</param>
        /// <param name = "storageArea">StorageArea to retrieve data from.</param>
        /// <param name = "keys">Keys to retrieve.</param>
        /// <returns>returns System.Threading.Tasks.Task&lt;GetStorageItemsResponse&gt;</returns>
        public System.Threading.Tasks.Task<GetStorageItemsResponse> GetStorageItemsAsync(string id, CefSharp.DevTools.Extensions.StorageArea storageArea, string[] keys = null)
        {
            ValidateGetStorageItems(id, storageArea, keys);
            var dict = new System.Collections.Generic.Dictionary<string, object>();
            dict.Add("id", id);
            dict.Add("storageArea", EnumToString(storageArea));
            if ((keys) != (null))
            {
                dict.Add("keys", keys);
            }

            return _client.ExecuteDevToolsMethodAsync<GetStorageItemsResponse>("Extensions.getStorageItems", dict);
        }

        partial void ValidateRemoveStorageItems(string id, CefSharp.DevTools.Extensions.StorageArea storageArea, string[] keys);
        /// <summary>
        /// Removes `keys` from extension storage in the given `storageArea`.
        /// </summary>
        /// <param name = "id">ID of extension.</param>
        /// <param name = "storageArea">StorageArea to remove data from.</param>
        /// <param name = "keys">Keys to remove.</param>
        /// <returns>returns System.Threading.Tasks.Task&lt;DevToolsMethodResponse&gt;</returns>
        public System.Threading.Tasks.Task<DevToolsMethodResponse> RemoveStorageItemsAsync(string id, CefSharp.DevTools.Extensions.StorageArea storageArea, string[] keys)
        {
            ValidateRemoveStorageItems(id, storageArea, keys);
            var dict = new System.Collections.Generic.Dictionary<string, object>();
            dict.Add("id", id);
            dict.Add("storageArea", EnumToString(storageArea));
            dict.Add("keys", keys);
            return _client.ExecuteDevToolsMethodAsync<DevToolsMethodResponse>("Extensions.removeStorageItems", dict);
        }

        partial void ValidateClearStorageItems(string id, CefSharp.DevTools.Extensions.StorageArea storageArea);
        /// <summary>
        /// Clears extension storage in the given `storageArea`.
        /// </summary>
        /// <param name = "id">ID of extension.</param>
        /// <param name = "storageArea">StorageArea to remove data from.</param>
        /// <returns>returns System.Threading.Tasks.Task&lt;DevToolsMethodResponse&gt;</returns>
        public System.Threading.Tasks.Task<DevToolsMethodResponse> ClearStorageItemsAsync(string id, CefSharp.DevTools.Extensions.StorageArea storageArea)
        {
            ValidateClearStorageItems(id, storageArea);
            var dict = new System.Collections.Generic.Dictionary<string, object>();
            dict.Add("id", id);
            dict.Add("storageArea", EnumToString(storageArea));
            return _client.ExecuteDevToolsMethodAsync<DevToolsMethodResponse>("Extensions.clearStorageItems", dict);
        }

        partial void ValidateSetStorageItems(string id, CefSharp.DevTools.Extensions.StorageArea storageArea, object values);
        /// <summary>
        /// Sets `values` in extension storage in the given `storageArea`. The provided `values`
        /// will be merged with existing values in the storage area.
        /// </summary>
        /// <param name = "id">ID of extension.</param>
        /// <param name = "storageArea">StorageArea to set data in.</param>
        /// <param name = "values">Values to set.</param>
        /// <returns>returns System.Threading.Tasks.Task&lt;DevToolsMethodResponse&gt;</returns>
        public System.Threading.Tasks.Task<DevToolsMethodResponse> SetStorageItemsAsync(string id, CefSharp.DevTools.Extensions.StorageArea storageArea, object values)
        {
            ValidateSetStorageItems(id, storageArea, values);
            var dict = new System.Collections.Generic.Dictionary<string, object>();
            dict.Add("id", id);
            dict.Add("storageArea", EnumToString(storageArea));
            dict.Add("values", values);
            return _client.ExecuteDevToolsMethodAsync<DevToolsMethodResponse>("Extensions.setStorageItems", dict);
        }
    }
}

namespace CefSharp.DevTools.Autofill
{
    using System.Linq;

    /// <summary>
    /// Defines commands and events for Autofill.
    /// </summary>
    public partial class AutofillClient : DevToolsDomainBase
    {
        private CefSharp.DevTools.IDevToolsClient _client;
        /// <summary>
        /// Autofill
        /// </summary>
        /// <param name = "client">DevToolsClient</param>
        public AutofillClient(CefSharp.DevTools.IDevToolsClient client)
        {
            _client = (client);
        }

        /// <summary>
        /// Emitted when an address form is filled.
        /// </summary>
        public event System.EventHandler<AddressFormFilledEventArgs> AddressFormFilled
        {
            add
            {
                _client.AddEventHandler<AddressFormFilledEventArgs>("Autofill.addressFormFilled", value);
            }

            remove
            {
                _client.RemoveEventHandler<AddressFormFilledEventArgs>("Autofill.addressFormFilled", value);
            }
        }

        partial void ValidateTrigger(int fieldId, CefSharp.DevTools.Autofill.CreditCard card, string frameId = null);
        /// <summary>
        /// Trigger autofill on a form identified by the fieldId.
        /// If the field and related form cannot be autofilled, returns an error.
        /// </summary>
        /// <param name = "fieldId">Identifies a field that serves as an anchor for autofill.</param>
        /// <param name = "card">Credit card information to fill out the form. Credit card data is not saved.</param>
        /// <param name = "frameId">Identifies the frame that field belongs to.</param>
        /// <returns>returns System.Threading.Tasks.Task&lt;DevToolsMethodResponse&gt;</returns>
        public System.Threading.Tasks.Task<DevToolsMethodResponse> TriggerAsync(int fieldId, CefSharp.DevTools.Autofill.CreditCard card, string frameId = null)
        {
            ValidateTrigger(fieldId, card, frameId);
            var dict = new System.Collections.Generic.Dictionary<string, object>();
            dict.Add("fieldId", fieldId);
            dict.Add("card", card.ToDictionary());
            if (!(string.IsNullOrEmpty(frameId)))
            {
                dict.Add("frameId", frameId);
            }

            return _client.ExecuteDevToolsMethodAsync<DevToolsMethodResponse>("Autofill.trigger", dict);
        }

        partial void ValidateSetAddresses(System.Collections.Generic.IList<CefSharp.DevTools.Autofill.Address> addresses);
        /// <summary>
        /// Set addresses so that developers can verify their forms implementation.
        /// </summary>
        /// <param name = "addresses">addresses</param>
        /// <returns>returns System.Threading.Tasks.Task&lt;DevToolsMethodResponse&gt;</returns>
        public System.Threading.Tasks.Task<DevToolsMethodResponse> SetAddressesAsync(System.Collections.Generic.IList<CefSharp.DevTools.Autofill.Address> addresses)
        {
            ValidateSetAddresses(addresses);
            var dict = new System.Collections.Generic.Dictionary<string, object>();
            dict.Add("addresses", addresses.Select(x => x.ToDictionary()));
            return _client.ExecuteDevToolsMethodAsync<DevToolsMethodResponse>("Autofill.setAddresses", dict);
        }

        /// <summary>
        /// Disables autofill domain notifications.
        /// </summary>
        /// <returns>returns System.Threading.Tasks.Task&lt;DevToolsMethodResponse&gt;</returns>
        public System.Threading.Tasks.Task<DevToolsMethodResponse> DisableAsync()
        {
            System.Collections.Generic.Dictionary<string, object> dict = null;
            return _client.ExecuteDevToolsMethodAsync<DevToolsMethodResponse>("Autofill.disable", dict);
        }

        /// <summary>
        /// Enables autofill domain notifications.
        /// </summary>
        /// <returns>returns System.Threading.Tasks.Task&lt;DevToolsMethodResponse&gt;</returns>
        public System.Threading.Tasks.Task<DevToolsMethodResponse> EnableAsync()
        {
            System.Collections.Generic.Dictionary<string, object> dict = null;
            return _client.ExecuteDevToolsMethodAsync<DevToolsMethodResponse>("Autofill.enable", dict);
        }
    }
}

namespace CefSharp.DevTools.BackgroundService
{
    using System.Linq;

    /// <summary>
    /// Defines events for background web platform features.
    /// </summary>
    public partial class BackgroundServiceClient : DevToolsDomainBase
    {
        private CefSharp.DevTools.IDevToolsClient _client;
        /// <summary>
        /// BackgroundService
        /// </summary>
        /// <param name = "client">DevToolsClient</param>
        public BackgroundServiceClient(CefSharp.DevTools.IDevToolsClient client)
        {
            _client = (client);
        }

        /// <summary>
        /// Called when the recording state for the service has been updated.
        /// </summary>
        public event System.EventHandler<RecordingStateChangedEventArgs> RecordingStateChanged
        {
            add
            {
                _client.AddEventHandler<RecordingStateChangedEventArgs>("BackgroundService.recordingStateChanged", value);
            }

  